/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CODECS)

#include "JSVideoPixelFormat.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(VideoPixelFormat enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("I420"),
        MAKE_STATIC_STRING_IMPL("I420A"),
        MAKE_STATIC_STRING_IMPL("I422"),
        MAKE_STATIC_STRING_IMPL("I444"),
        MAKE_STATIC_STRING_IMPL("NV12"),
        MAKE_STATIC_STRING_IMPL("RGBA"),
        MAKE_STATIC_STRING_IMPL("RGBX"),
        MAKE_STATIC_STRING_IMPL("BGRA"),
        MAKE_STATIC_STRING_IMPL("BGRX"),
    };
    static_assert(static_cast<size_t>(VideoPixelFormat::I420) == 0, "VideoPixelFormat::I420 is not 0 as expected");
    static_assert(static_cast<size_t>(VideoPixelFormat::I420A) == 1, "VideoPixelFormat::I420A is not 1 as expected");
    static_assert(static_cast<size_t>(VideoPixelFormat::I422) == 2, "VideoPixelFormat::I422 is not 2 as expected");
    static_assert(static_cast<size_t>(VideoPixelFormat::I444) == 3, "VideoPixelFormat::I444 is not 3 as expected");
    static_assert(static_cast<size_t>(VideoPixelFormat::NV12) == 4, "VideoPixelFormat::NV12 is not 4 as expected");
    static_assert(static_cast<size_t>(VideoPixelFormat::RGBA) == 5, "VideoPixelFormat::RGBA is not 5 as expected");
    static_assert(static_cast<size_t>(VideoPixelFormat::RGBX) == 6, "VideoPixelFormat::RGBX is not 6 as expected");
    static_assert(static_cast<size_t>(VideoPixelFormat::BGRA) == 7, "VideoPixelFormat::BGRA is not 7 as expected");
    static_assert(static_cast<size_t>(VideoPixelFormat::BGRX) == 8, "VideoPixelFormat::BGRX is not 8 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, VideoPixelFormat enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<VideoPixelFormat> parseEnumerationFromString<VideoPixelFormat>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, VideoPixelFormat> mappings[] = {
        { "BGRA", VideoPixelFormat::BGRA },
        { "BGRX", VideoPixelFormat::BGRX },
        { "I420", VideoPixelFormat::I420 },
        { "I420A", VideoPixelFormat::I420A },
        { "I422", VideoPixelFormat::I422 },
        { "I444", VideoPixelFormat::I444 },
        { "NV12", VideoPixelFormat::NV12 },
        { "RGBA", VideoPixelFormat::RGBA },
        { "RGBX", VideoPixelFormat::RGBX },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<VideoPixelFormat> parseEnumeration<VideoPixelFormat>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<VideoPixelFormat>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<VideoPixelFormat>()
{
    return "\"I420\", \"I420A\", \"I422\", \"I444\", \"NV12\", \"RGBA\", \"RGBX\", \"BGRA\", \"BGRX\"";
}

} // namespace WebCore

#endif // ENABLE(WEB_CODECS)
