/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSTextMetrics.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsTextMetricsConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsTextMetrics_width);
static JSC_DECLARE_CUSTOM_GETTER(jsTextMetrics_actualBoundingBoxLeft);
static JSC_DECLARE_CUSTOM_GETTER(jsTextMetrics_actualBoundingBoxRight);
static JSC_DECLARE_CUSTOM_GETTER(jsTextMetrics_fontBoundingBoxAscent);
static JSC_DECLARE_CUSTOM_GETTER(jsTextMetrics_fontBoundingBoxDescent);
static JSC_DECLARE_CUSTOM_GETTER(jsTextMetrics_actualBoundingBoxAscent);
static JSC_DECLARE_CUSTOM_GETTER(jsTextMetrics_actualBoundingBoxDescent);
static JSC_DECLARE_CUSTOM_GETTER(jsTextMetrics_emHeightAscent);
static JSC_DECLARE_CUSTOM_GETTER(jsTextMetrics_emHeightDescent);
static JSC_DECLARE_CUSTOM_GETTER(jsTextMetrics_hangingBaseline);
static JSC_DECLARE_CUSTOM_GETTER(jsTextMetrics_alphabeticBaseline);
static JSC_DECLARE_CUSTOM_GETTER(jsTextMetrics_ideographicBaseline);

class JSTextMetricsPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSTextMetricsPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTextMetricsPrototype* ptr = new (NotNull, JSC::allocateCell<JSTextMetricsPrototype>(vm)) JSTextMetricsPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTextMetricsPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTextMetricsPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTextMetricsPrototype, JSTextMetricsPrototype::Base);

using JSTextMetricsDOMConstructor = JSDOMConstructorNotConstructable<JSTextMetrics>;

template<> const ClassInfo JSTextMetricsDOMConstructor::s_info = { "TextMetrics"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextMetricsDOMConstructor) };

template<> JSValue JSTextMetricsDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSTextMetricsDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "TextMetrics"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSTextMetrics::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSTextMetricsPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsTextMetricsConstructor, 0 } },
    { "width"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextMetrics_width, 0 } },
    { "actualBoundingBoxLeft"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextMetrics_actualBoundingBoxLeft, 0 } },
    { "actualBoundingBoxRight"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextMetrics_actualBoundingBoxRight, 0 } },
    { "fontBoundingBoxAscent"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextMetrics_fontBoundingBoxAscent, 0 } },
    { "fontBoundingBoxDescent"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextMetrics_fontBoundingBoxDescent, 0 } },
    { "actualBoundingBoxAscent"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextMetrics_actualBoundingBoxAscent, 0 } },
    { "actualBoundingBoxDescent"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextMetrics_actualBoundingBoxDescent, 0 } },
    { "emHeightAscent"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextMetrics_emHeightAscent, 0 } },
    { "emHeightDescent"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextMetrics_emHeightDescent, 0 } },
    { "hangingBaseline"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextMetrics_hangingBaseline, 0 } },
    { "alphabeticBaseline"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextMetrics_alphabeticBaseline, 0 } },
    { "ideographicBaseline"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTextMetrics_ideographicBaseline, 0 } },
};

const ClassInfo JSTextMetricsPrototype::s_info = { "TextMetrics"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextMetricsPrototype) };

void JSTextMetricsPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTextMetrics::info(), JSTextMetricsPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSTextMetrics::s_info = { "TextMetrics"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextMetrics) };

JSTextMetrics::JSTextMetrics(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TextMetrics>&& impl)
    : JSDOMWrapper<TextMetrics>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, TextMetrics>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSTextMetrics::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSTextMetricsPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSTextMetricsPrototype::create(vm, &globalObject, structure);
}

JSObject* JSTextMetrics::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSTextMetrics>(vm, globalObject);
}

JSValue JSTextMetrics::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTextMetricsDOMConstructor, DOMConstructorID::TextMetrics>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSTextMetrics::destroy(JSC::JSCell* cell)
{
    JSTextMetrics* thisObject = static_cast<JSTextMetrics*>(cell);
    thisObject->JSTextMetrics::~JSTextMetrics();
}

JSC_DEFINE_CUSTOM_GETTER(jsTextMetricsConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTextMetricsPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSTextMetrics::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsTextMetrics_widthGetter(JSGlobalObject& lexicalGlobalObject, JSTextMetrics& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.width())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextMetrics_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextMetrics>::get<jsTextMetrics_widthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTextMetrics_actualBoundingBoxLeftGetter(JSGlobalObject& lexicalGlobalObject, JSTextMetrics& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.actualBoundingBoxLeft())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextMetrics_actualBoundingBoxLeft, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextMetrics>::get<jsTextMetrics_actualBoundingBoxLeftGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTextMetrics_actualBoundingBoxRightGetter(JSGlobalObject& lexicalGlobalObject, JSTextMetrics& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.actualBoundingBoxRight())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextMetrics_actualBoundingBoxRight, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextMetrics>::get<jsTextMetrics_actualBoundingBoxRightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTextMetrics_fontBoundingBoxAscentGetter(JSGlobalObject& lexicalGlobalObject, JSTextMetrics& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.fontBoundingBoxAscent())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextMetrics_fontBoundingBoxAscent, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextMetrics>::get<jsTextMetrics_fontBoundingBoxAscentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTextMetrics_fontBoundingBoxDescentGetter(JSGlobalObject& lexicalGlobalObject, JSTextMetrics& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.fontBoundingBoxDescent())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextMetrics_fontBoundingBoxDescent, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextMetrics>::get<jsTextMetrics_fontBoundingBoxDescentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTextMetrics_actualBoundingBoxAscentGetter(JSGlobalObject& lexicalGlobalObject, JSTextMetrics& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.actualBoundingBoxAscent())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextMetrics_actualBoundingBoxAscent, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextMetrics>::get<jsTextMetrics_actualBoundingBoxAscentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTextMetrics_actualBoundingBoxDescentGetter(JSGlobalObject& lexicalGlobalObject, JSTextMetrics& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.actualBoundingBoxDescent())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextMetrics_actualBoundingBoxDescent, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextMetrics>::get<jsTextMetrics_actualBoundingBoxDescentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTextMetrics_emHeightAscentGetter(JSGlobalObject& lexicalGlobalObject, JSTextMetrics& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.emHeightAscent())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextMetrics_emHeightAscent, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextMetrics>::get<jsTextMetrics_emHeightAscentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTextMetrics_emHeightDescentGetter(JSGlobalObject& lexicalGlobalObject, JSTextMetrics& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.emHeightDescent())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextMetrics_emHeightDescent, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextMetrics>::get<jsTextMetrics_emHeightDescentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTextMetrics_hangingBaselineGetter(JSGlobalObject& lexicalGlobalObject, JSTextMetrics& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.hangingBaseline())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextMetrics_hangingBaseline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextMetrics>::get<jsTextMetrics_hangingBaselineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTextMetrics_alphabeticBaselineGetter(JSGlobalObject& lexicalGlobalObject, JSTextMetrics& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.alphabeticBaseline())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextMetrics_alphabeticBaseline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextMetrics>::get<jsTextMetrics_alphabeticBaselineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTextMetrics_ideographicBaselineGetter(JSGlobalObject& lexicalGlobalObject, JSTextMetrics& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.ideographicBaseline())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTextMetrics_ideographicBaseline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTextMetrics>::get<jsTextMetrics_ideographicBaselineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSTextMetrics::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSTextMetrics, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForTextMetrics.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForTextMetrics = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForTextMetrics.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForTextMetrics = std::forward<decltype(space)>(space); }
    );
}

void JSTextMetrics::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSTextMetrics*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSTextMetricsOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSTextMetricsOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsTextMetrics = static_cast<JSTextMetrics*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsTextMetrics->wrapped(), jsTextMetrics);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7TextMetrics@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11TextMetricsE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<TextMetrics>&& impl)
{

    if constexpr (std::is_polymorphic_v<TextMetrics>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7TextMetrics@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore11TextMetricsE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // TextMetrics has subclasses. If TextMetrics has subclasses that get passed
        // to toJS() we currently require TextMetrics you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<TextMetrics>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, TextMetrics& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

TextMetrics* JSTextMetrics::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSTextMetrics*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
