/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSecurityPolicyViolationEvent.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSSecurityPolicyViolationEventDisposition.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> SecurityPolicyViolationEvent::Init convertDictionary<SecurityPolicyViolationEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    SecurityPolicyViolationEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bubblesValue.isUndefined()) {
        result.bubbles = convert<IDLBoolean>(lexicalGlobalObject, bubblesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bubbles = false;
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cancelableValue.isUndefined()) {
        result.cancelable = convert<IDLBoolean>(lexicalGlobalObject, cancelableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.cancelable = false;
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!composedValue.isUndefined()) {
        result.composed = convert<IDLBoolean>(lexicalGlobalObject, composedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composed = false;
    JSValue blockedURIValue;
    if (isNullOrUndefined)
        blockedURIValue = jsUndefined();
    else {
        blockedURIValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "blockedURI"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!blockedURIValue.isUndefined()) {
        result.blockedURI = convert<IDLUSVString>(lexicalGlobalObject, blockedURIValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.blockedURI = emptyString();
    JSValue columnNumberValue;
    if (isNullOrUndefined)
        columnNumberValue = jsUndefined();
    else {
        columnNumberValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "columnNumber"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!columnNumberValue.isUndefined()) {
        result.columnNumber = convert<IDLUnsignedLong>(lexicalGlobalObject, columnNumberValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.columnNumber = 0;
    JSValue dispositionValue;
    if (isNullOrUndefined)
        dispositionValue = jsUndefined();
    else {
        dispositionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "disposition"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!dispositionValue.isUndefined()) {
        result.disposition = convert<IDLEnumeration<SecurityPolicyViolationEventDisposition>>(lexicalGlobalObject, dispositionValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "disposition", "SecurityPolicyViolationEventInit", "SecurityPolicyViolationEventDisposition");
        return { };
    }
    JSValue documentURIValue;
    if (isNullOrUndefined)
        documentURIValue = jsUndefined();
    else {
        documentURIValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "documentURI"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!documentURIValue.isUndefined()) {
        result.documentURI = convert<IDLUSVString>(lexicalGlobalObject, documentURIValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "documentURI", "SecurityPolicyViolationEventInit", "USVString");
        return { };
    }
    JSValue effectiveDirectiveValue;
    if (isNullOrUndefined)
        effectiveDirectiveValue = jsUndefined();
    else {
        effectiveDirectiveValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "effectiveDirective"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!effectiveDirectiveValue.isUndefined()) {
        result.effectiveDirective = convert<IDLDOMString>(lexicalGlobalObject, effectiveDirectiveValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "effectiveDirective", "SecurityPolicyViolationEventInit", "DOMString");
        return { };
    }
    JSValue lineNumberValue;
    if (isNullOrUndefined)
        lineNumberValue = jsUndefined();
    else {
        lineNumberValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "lineNumber"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!lineNumberValue.isUndefined()) {
        result.lineNumber = convert<IDLUnsignedLong>(lexicalGlobalObject, lineNumberValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.lineNumber = 0;
    JSValue originalPolicyValue;
    if (isNullOrUndefined)
        originalPolicyValue = jsUndefined();
    else {
        originalPolicyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "originalPolicy"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!originalPolicyValue.isUndefined()) {
        result.originalPolicy = convert<IDLDOMString>(lexicalGlobalObject, originalPolicyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "originalPolicy", "SecurityPolicyViolationEventInit", "DOMString");
        return { };
    }
    JSValue referrerValue;
    if (isNullOrUndefined)
        referrerValue = jsUndefined();
    else {
        referrerValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "referrer"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!referrerValue.isUndefined()) {
        result.referrer = convert<IDLUSVString>(lexicalGlobalObject, referrerValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.referrer = emptyString();
    JSValue sampleValue;
    if (isNullOrUndefined)
        sampleValue = jsUndefined();
    else {
        sampleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sample"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sampleValue.isUndefined()) {
        result.sample = convert<IDLDOMString>(lexicalGlobalObject, sampleValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.sample = emptyString();
    JSValue sourceFileValue;
    if (isNullOrUndefined)
        sourceFileValue = jsUndefined();
    else {
        sourceFileValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sourceFile"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sourceFileValue.isUndefined()) {
        result.sourceFile = convert<IDLUSVString>(lexicalGlobalObject, sourceFileValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.sourceFile = emptyString();
    JSValue statusCodeValue;
    if (isNullOrUndefined)
        statusCodeValue = jsUndefined();
    else {
        statusCodeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "statusCode"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!statusCodeValue.isUndefined()) {
        result.statusCode = convert<IDLUnsignedShort>(lexicalGlobalObject, statusCodeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "statusCode", "SecurityPolicyViolationEventInit", "unsigned short");
        return { };
    }
    JSValue violatedDirectiveValue;
    if (isNullOrUndefined)
        violatedDirectiveValue = jsUndefined();
    else {
        violatedDirectiveValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "violatedDirective"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!violatedDirectiveValue.isUndefined()) {
        result.violatedDirective = convert<IDLDOMString>(lexicalGlobalObject, violatedDirectiveValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "violatedDirective", "SecurityPolicyViolationEventInit", "DOMString");
        return { };
    }
    return result;
}

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_documentURI);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_referrer);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_blockedURI);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_effectiveDirective);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_violatedDirective);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_originalPolicy);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_sourceFile);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_sample);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_disposition);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_statusCode);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_lineno);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_lineNumber);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_colno);
static JSC_DECLARE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_columnNumber);

class JSSecurityPolicyViolationEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSecurityPolicyViolationEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSecurityPolicyViolationEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSSecurityPolicyViolationEventPrototype>(vm)) JSSecurityPolicyViolationEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSecurityPolicyViolationEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSecurityPolicyViolationEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSecurityPolicyViolationEventPrototype, JSSecurityPolicyViolationEventPrototype::Base);

using JSSecurityPolicyViolationEventDOMConstructor = JSDOMConstructor<JSSecurityPolicyViolationEvent>;

static inline EncodedJSValue constructJSSecurityPolicyViolationEvent1(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSSecurityPolicyViolationEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto type = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = SecurityPolicyViolationEvent::create(WTFMove(type));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<SecurityPolicyViolationEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<SecurityPolicyViolationEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}

static inline EncodedJSValue constructJSSecurityPolicyViolationEvent2(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSSecurityPolicyViolationEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto type = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto eventInitDict = convert<IDLDictionary<SecurityPolicyViolationEvent::Init>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = SecurityPolicyViolationEvent::create(WTFMove(type), WTFMove(eventInitDict));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<SecurityPolicyViolationEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<SecurityPolicyViolationEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSSecurityPolicyViolationEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 1) {
        RELEASE_AND_RETURN(throwScope, (constructJSSecurityPolicyViolationEvent1(lexicalGlobalObject, callFrame)));
    }
    if (argsCount == 2) {
        RELEASE_AND_RETURN(throwScope, (constructJSSecurityPolicyViolationEvent2(lexicalGlobalObject, callFrame)));
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}
JSC_ANNOTATE_HOST_FUNCTION(JSSecurityPolicyViolationEventConstructorConstruct, JSSecurityPolicyViolationEventDOMConstructor::construct);

template<> const ClassInfo JSSecurityPolicyViolationEventDOMConstructor::s_info = { "SecurityPolicyViolationEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSecurityPolicyViolationEventDOMConstructor) };

template<> JSValue JSSecurityPolicyViolationEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSSecurityPolicyViolationEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SecurityPolicyViolationEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSecurityPolicyViolationEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSSecurityPolicyViolationEventPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEventConstructor, 0 } },
    { "documentURI"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_documentURI, 0 } },
    { "referrer"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_referrer, 0 } },
    { "blockedURI"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_blockedURI, 0 } },
    { "effectiveDirective"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_effectiveDirective, 0 } },
    { "violatedDirective"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_violatedDirective, 0 } },
    { "originalPolicy"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_originalPolicy, 0 } },
    { "sourceFile"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_sourceFile, 0 } },
    { "sample"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_sample, 0 } },
    { "disposition"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_disposition, 0 } },
    { "statusCode"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_statusCode, 0 } },
    { "lineno"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_lineno, 0 } },
    { "lineNumber"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_lineNumber, 0 } },
    { "colno"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_colno, 0 } },
    { "columnNumber"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSecurityPolicyViolationEvent_columnNumber, 0 } },
};

const ClassInfo JSSecurityPolicyViolationEventPrototype::s_info = { "SecurityPolicyViolationEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSecurityPolicyViolationEventPrototype) };

void JSSecurityPolicyViolationEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSecurityPolicyViolationEvent::info(), JSSecurityPolicyViolationEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSecurityPolicyViolationEvent::s_info = { "SecurityPolicyViolationEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSecurityPolicyViolationEvent) };

JSSecurityPolicyViolationEvent::JSSecurityPolicyViolationEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SecurityPolicyViolationEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<SecurityPolicyViolationEvent> JSSecurityPolicyViolationEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, SecurityPolicyViolationEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSSecurityPolicyViolationEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSecurityPolicyViolationEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSSecurityPolicyViolationEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSecurityPolicyViolationEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSecurityPolicyViolationEvent>(vm, globalObject);
}

JSValue JSSecurityPolicyViolationEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSecurityPolicyViolationEventDOMConstructor, DOMConstructorID::SecurityPolicyViolationEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSecurityPolicyViolationEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSecurityPolicyViolationEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsSecurityPolicyViolationEvent_documentURIGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.documentURI())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_documentURI, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_documentURIGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_referrerGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.referrer())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_referrer, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_referrerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_blockedURIGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.blockedURI())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_blockedURI, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_blockedURIGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_effectiveDirectiveGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.effectiveDirective())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_effectiveDirective, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_effectiveDirectiveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_violatedDirectiveGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.violatedDirective())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_violatedDirective, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_violatedDirectiveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_originalPolicyGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.originalPolicy())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_originalPolicy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_originalPolicyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_sourceFileGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.sourceFile())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_sourceFile, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_sourceFileGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_sampleGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.sample())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_sample, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_sampleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_dispositionGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<SecurityPolicyViolationEventDisposition>>(lexicalGlobalObject, throwScope, impl.disposition())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_disposition, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_dispositionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_statusCodeGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.statusCode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_statusCode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_statusCodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_linenoGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.lineNumber())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_lineno, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_linenoGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_lineNumberGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.lineNumber())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_lineNumber, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_lineNumberGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_colnoGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.columnNumber())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_colno, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_colnoGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSecurityPolicyViolationEvent_columnNumberGetter(JSGlobalObject& lexicalGlobalObject, JSSecurityPolicyViolationEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.columnNumber())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSecurityPolicyViolationEvent_columnNumber, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSecurityPolicyViolationEvent>::get<jsSecurityPolicyViolationEvent_columnNumberGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSSecurityPolicyViolationEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSecurityPolicyViolationEvent, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSecurityPolicyViolationEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSecurityPolicyViolationEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSecurityPolicyViolationEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSecurityPolicyViolationEvent = std::forward<decltype(space)>(space); }
    );
}

void JSSecurityPolicyViolationEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSecurityPolicyViolationEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SecurityPolicyViolationEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore28SecurityPolicyViolationEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SecurityPolicyViolationEvent>&& impl)
{

    if constexpr (std::is_polymorphic_v<SecurityPolicyViolationEvent>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7SecurityPolicyViolationEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore28SecurityPolicyViolationEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // SecurityPolicyViolationEvent has subclasses. If SecurityPolicyViolationEvent has subclasses that get passed
        // to toJS() we currently require SecurityPolicyViolationEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<SecurityPolicyViolationEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SecurityPolicyViolationEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
