/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "JSDOMConvertEnumeration.h"
#include "JSDOMWrapper.h"
#include "JSEventTarget.h"
#include "ScreenOrientation.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class JSScreenOrientation : public JSEventTarget {
public:
    using Base = JSEventTarget;
    using DOMWrapped = ScreenOrientation;
    static JSScreenOrientation* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<ScreenOrientation>&& impl)
    {
        JSScreenOrientation* ptr = new (NotNull, JSC::allocateCell<JSScreenOrientation>(globalObject->vm())) JSScreenOrientation(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static ScreenOrientation* toWrapped(JSC::VM&, JSC::JSValue);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info(), JSC::NonArray);
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    template<typename, JSC::SubspaceAccess mode> static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        if constexpr (mode == JSC::SubspaceAccess::Concurrently)
            return nullptr;
        return subspaceForImpl(vm);
    }
    static JSC::GCClient::IsoSubspace* subspaceForImpl(JSC::VM& vm);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
    ScreenOrientation& wrapped() const
    {
        return static_cast<ScreenOrientation&>(Base::wrapped());
    }

    Ref<ScreenOrientation> protectedWrapped() const;

protected:
    JSScreenOrientation(JSC::Structure*, JSDOMGlobalObject&, Ref<ScreenOrientation>&&);

    DECLARE_DEFAULT_FINISH_CREATION;
};

class JSScreenOrientationOwner final : public JSC::WeakHandleOwner {
public:
    bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::AbstractSlotVisitor&, const char**) final;
    void finalize(JSC::Handle<JSC::Unknown>, void* context) final;
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, ScreenOrientation*)
{
    static NeverDestroyed<JSScreenOrientationOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(ScreenOrientation* wrappableObject)
{
    return wrappableObject;
}

JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, ScreenOrientation&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ScreenOrientation* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<ScreenOrientation>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<ScreenOrientation>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

template<> struct JSDOMWrapperConverterTraits<ScreenOrientation> {
    using WrapperClass = JSScreenOrientation;
    using ToWrappedReturnType = ScreenOrientation*;
};
String convertEnumerationToString(ScreenOrientationLockType);
template<> JSC::JSString* convertEnumerationToJS(JSC::VM&, ScreenOrientationLockType);

template<> std::optional<ScreenOrientationLockType> parseEnumerationFromString<ScreenOrientationLockType>(const String&);
template<> std::optional<ScreenOrientationLockType> parseEnumeration<ScreenOrientationLockType>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<ScreenOrientationLockType>();

String convertEnumerationToString(ScreenOrientationType);
template<> JSC::JSString* convertEnumerationToJS(JSC::VM&, ScreenOrientationType);

template<> std::optional<ScreenOrientationType> parseEnumerationFromString<ScreenOrientationType>(const String&);
template<> std::optional<ScreenOrientationType> parseEnumeration<ScreenOrientationType>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<ScreenOrientationType>();


} // namespace WebCore
