/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGAnimationElement.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSSVGStringList.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsSVGAnimationElementPrototypeFunction_getStartTime);
static JSC_DECLARE_HOST_FUNCTION(jsSVGAnimationElementPrototypeFunction_getCurrentTime);
static JSC_DECLARE_HOST_FUNCTION(jsSVGAnimationElementPrototypeFunction_getSimpleDuration);
static JSC_DECLARE_HOST_FUNCTION(jsSVGAnimationElementPrototypeFunction_beginElement);
static JSC_DECLARE_HOST_FUNCTION(jsSVGAnimationElementPrototypeFunction_beginElementAt);
static JSC_DECLARE_HOST_FUNCTION(jsSVGAnimationElementPrototypeFunction_endElement);
static JSC_DECLARE_HOST_FUNCTION(jsSVGAnimationElementPrototypeFunction_endElementAt);
static JSC_DECLARE_HOST_FUNCTION(jsSVGAnimationElementPrototypeFunction_hasExtension);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGAnimationElementConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGAnimationElement_targetElement);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGAnimationElement_requiredExtensions);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGAnimationElement_systemLanguage);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGAnimationElement_requiredFeatures);

class JSSVGAnimationElementPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGAnimationElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGAnimationElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGAnimationElementPrototype>(vm)) JSSVGAnimationElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGAnimationElementPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGAnimationElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGAnimationElementPrototype, JSSVGAnimationElementPrototype::Base);

using JSSVGAnimationElementDOMConstructor = JSDOMConstructorNotConstructable<JSSVGAnimationElement>;

template<> const ClassInfo JSSVGAnimationElementDOMConstructor::s_info = { "SVGAnimationElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGAnimationElementDOMConstructor) };

template<> JSValue JSSVGAnimationElementDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGElement::getConstructor(vm, &globalObject);
}

template<> void JSSVGAnimationElementDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGAnimationElement"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGAnimationElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSSVGAnimationElementPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGAnimationElementConstructor, 0 } },
    { "targetElement"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGAnimationElement_targetElement, 0 } },
    { "requiredExtensions"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGAnimationElement_requiredExtensions, 0 } },
    { "systemLanguage"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGAnimationElement_systemLanguage, 0 } },
    { "requiredFeatures"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGAnimationElement_requiredFeatures, 0 } },
    { "getStartTime"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGAnimationElementPrototypeFunction_getStartTime, 0 } },
    { "getCurrentTime"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGAnimationElementPrototypeFunction_getCurrentTime, 0 } },
    { "getSimpleDuration"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGAnimationElementPrototypeFunction_getSimpleDuration, 0 } },
    { "beginElement"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGAnimationElementPrototypeFunction_beginElement, 0 } },
    { "beginElementAt"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGAnimationElementPrototypeFunction_beginElementAt, 1 } },
    { "endElement"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGAnimationElementPrototypeFunction_endElement, 0 } },
    { "endElementAt"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGAnimationElementPrototypeFunction_endElementAt, 1 } },
    { "hasExtension"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGAnimationElementPrototypeFunction_hasExtension, 1 } },
};

const ClassInfo JSSVGAnimationElementPrototype::s_info = { "SVGAnimationElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGAnimationElementPrototype) };

void JSSVGAnimationElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGAnimationElement::info(), JSSVGAnimationElementPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGAnimationElement::s_info = { "SVGAnimationElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGAnimationElement) };

JSSVGAnimationElement::JSSVGAnimationElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGAnimationElement>&& impl)
    : JSSVGElement(structure, globalObject, WTFMove(impl))
{
}

Ref<SVGAnimationElement> JSSVGAnimationElement::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSSVGAnimationElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGAnimationElementPrototype::createStructure(vm, &globalObject, JSSVGElement::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSSVGAnimationElementPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGAnimationElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGAnimationElement>(vm, globalObject);
}

JSValue JSSVGAnimationElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAnimationElementDOMConstructor, DOMConstructorID::SVGAnimationElement>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGAnimationElementConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGAnimationElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGAnimationElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsSVGAnimationElement_targetElementGetter(JSGlobalObject& lexicalGlobalObject, JSSVGAnimationElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<SVGElement>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.targetElement())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGAnimationElement_targetElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGAnimationElement>::get<jsSVGAnimationElement_targetElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGAnimationElement_requiredExtensionsGetter(JSGlobalObject& lexicalGlobalObject, JSSVGAnimationElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGStringList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.requiredExtensions())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGAnimationElement_requiredExtensions, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGAnimationElement>::get<jsSVGAnimationElement_requiredExtensionsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGAnimationElement_systemLanguageGetter(JSGlobalObject& lexicalGlobalObject, JSSVGAnimationElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGStringList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.systemLanguage())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGAnimationElement_systemLanguage, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGAnimationElement>::get<jsSVGAnimationElement_systemLanguageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGAnimationElement_requiredFeaturesGetter(JSGlobalObject& lexicalGlobalObject, JSSVGAnimationElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGStringList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.requiredFeatures())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGAnimationElement_requiredFeatures, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGAnimationElement>::get<jsSVGAnimationElement_requiredFeaturesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsSVGAnimationElementPrototypeFunction_getStartTimeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGAnimationElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLFloat>(*lexicalGlobalObject, throwScope, impl.getStartTime())));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGAnimationElementPrototypeFunction_getStartTime, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGAnimationElement>::call<jsSVGAnimationElementPrototypeFunction_getStartTimeBody>(*lexicalGlobalObject, *callFrame, "getStartTime");
}

static inline JSC::EncodedJSValue jsSVGAnimationElementPrototypeFunction_getCurrentTimeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGAnimationElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLFloat>(*lexicalGlobalObject, throwScope, impl.getCurrentTime())));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGAnimationElementPrototypeFunction_getCurrentTime, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGAnimationElement>::call<jsSVGAnimationElementPrototypeFunction_getCurrentTimeBody>(*lexicalGlobalObject, *callFrame, "getCurrentTime");
}

static inline JSC::EncodedJSValue jsSVGAnimationElementPrototypeFunction_getSimpleDurationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGAnimationElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLFloat>(*lexicalGlobalObject, throwScope, impl.getSimpleDuration())));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGAnimationElementPrototypeFunction_getSimpleDuration, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGAnimationElement>::call<jsSVGAnimationElementPrototypeFunction_getSimpleDurationBody>(*lexicalGlobalObject, *callFrame, "getSimpleDuration");
}

static inline JSC::EncodedJSValue jsSVGAnimationElementPrototypeFunction_beginElementBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGAnimationElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.beginElement(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGAnimationElementPrototypeFunction_beginElement, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGAnimationElement>::call<jsSVGAnimationElementPrototypeFunction_beginElementBody>(*lexicalGlobalObject, *callFrame, "beginElement");
}

static inline JSC::EncodedJSValue jsSVGAnimationElementPrototypeFunction_beginElementAtBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGAnimationElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto offset = convert<IDLFloat>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.beginElementAt(WTFMove(offset)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGAnimationElementPrototypeFunction_beginElementAt, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGAnimationElement>::call<jsSVGAnimationElementPrototypeFunction_beginElementAtBody>(*lexicalGlobalObject, *callFrame, "beginElementAt");
}

static inline JSC::EncodedJSValue jsSVGAnimationElementPrototypeFunction_endElementBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGAnimationElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.endElement(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGAnimationElementPrototypeFunction_endElement, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGAnimationElement>::call<jsSVGAnimationElementPrototypeFunction_endElementBody>(*lexicalGlobalObject, *callFrame, "endElement");
}

static inline JSC::EncodedJSValue jsSVGAnimationElementPrototypeFunction_endElementAtBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGAnimationElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto offset = convert<IDLFloat>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.endElementAt(WTFMove(offset)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGAnimationElementPrototypeFunction_endElementAt, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGAnimationElement>::call<jsSVGAnimationElementPrototypeFunction_endElementAtBody>(*lexicalGlobalObject, *callFrame, "endElementAt");
}

static inline JSC::EncodedJSValue jsSVGAnimationElementPrototypeFunction_hasExtensionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGAnimationElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto extension = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.hasExtension(WTFMove(extension)))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGAnimationElementPrototypeFunction_hasExtension, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGAnimationElement>::call<jsSVGAnimationElementPrototypeFunction_hasExtensionBody>(*lexicalGlobalObject, *callFrame, "hasExtension");
}

JSC::GCClient::IsoSubspace* JSSVGAnimationElement::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGAnimationElement, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGAnimationElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGAnimationElement = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGAnimationElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGAnimationElement = std::forward<decltype(space)>(space); }
    );
}

void JSSVGAnimationElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGAnimationElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
