/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSRsaOtherPrimesInfo.h"

#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

template<> RsaOtherPrimesInfo convertDictionary<RsaOtherPrimesInfo>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RsaOtherPrimesInfo result;
    JSValue dValue;
    if (isNullOrUndefined)
        dValue = jsUndefined();
    else {
        dValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "d"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!dValue.isUndefined()) {
        result.d = convert<IDLDOMString>(lexicalGlobalObject, dValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "d", "RsaOtherPrimesInfo", "DOMString");
        return { };
    }
    JSValue rValue;
    if (isNullOrUndefined)
        rValue = jsUndefined();
    else {
        rValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "r"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!rValue.isUndefined()) {
        result.r = convert<IDLDOMString>(lexicalGlobalObject, rValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "r", "RsaOtherPrimesInfo", "DOMString");
        return { };
    }
    JSValue tValue;
    if (isNullOrUndefined)
        tValue = jsUndefined();
    else {
        tValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "t"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!tValue.isUndefined()) {
        result.t = convert<IDLDOMString>(lexicalGlobalObject, tValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "t", "RsaOtherPrimesInfo", "DOMString");
        return { };
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const RsaOtherPrimesInfo& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto dValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, dictionary.d);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "d"_s), dValue);
    auto rValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, dictionary.r);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "r"_s), rValue);
    auto tValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, dictionary.t);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "t"_s), tValue);
    return result;
}

} // namespace WebCore
