/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPushManager.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSPushPermissionState.h"
#include "JSPushSubscription.h"
#include "JSPushSubscriptionOptionsInit.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsPushManagerPrototypeFunction_subscribe);
static JSC_DECLARE_HOST_FUNCTION(jsPushManagerPrototypeFunction_getSubscription);
static JSC_DECLARE_HOST_FUNCTION(jsPushManagerPrototypeFunction_permissionState);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsPushManagerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPushManagerConstructor_supportedContentEncodings);

class JSPushManagerPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPushManagerPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPushManagerPrototype* ptr = new (NotNull, JSC::allocateCell<JSPushManagerPrototype>(vm)) JSPushManagerPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPushManagerPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPushManagerPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPushManagerPrototype, JSPushManagerPrototype::Base);

using JSPushManagerDOMConstructor = JSDOMConstructorNotConstructable<JSPushManager>;

/* Hash table for constructor */

static const HashTableValue JSPushManagerConstructorTableValues[] =
{
    { "supportedContentEncodings"_s, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), NoIntrinsic, { HashTableValue::GetterSetterType, jsPushManagerConstructor_supportedContentEncodings, 0 } },
};

template<> const ClassInfo JSPushManagerDOMConstructor::s_info = { "PushManager"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPushManagerDOMConstructor) };

template<> JSValue JSPushManagerDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSPushManagerDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "PushManager"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSPushManager::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSPushManager::info(), JSPushManagerConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSPushManagerPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPushManagerConstructor, 0 } },
    { "subscribe"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPushManagerPrototypeFunction_subscribe, 0 } },
    { "getSubscription"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPushManagerPrototypeFunction_getSubscription, 0 } },
    { "permissionState"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPushManagerPrototypeFunction_permissionState, 0 } },
};

const ClassInfo JSPushManagerPrototype::s_info = { "PushManager"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPushManagerPrototype) };

void JSPushManagerPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPushManager::info(), JSPushManagerPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSPushManager::s_info = { "PushManager"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPushManager) };

JSPushManager::JSPushManager(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PushManager>&& impl)
    : JSDOMWrapper<PushManager>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, PushManager>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSPushManager::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSPushManagerPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSPushManagerPrototype::create(vm, &globalObject, structure);
}

JSObject* JSPushManager::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPushManager>(vm, globalObject);
}

JSValue JSPushManager::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPushManagerDOMConstructor, DOMConstructorID::PushManager>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSPushManager::destroy(JSC::JSCell* cell)
{
    JSPushManager* thisObject = static_cast<JSPushManager*>(cell);
    thisObject->JSPushManager::~JSPushManager();
}

JSC_DEFINE_CUSTOM_GETTER(jsPushManagerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPushManagerPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPushManager::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsPushManagerConstructor_supportedContentEncodingsGetter(JSGlobalObject& lexicalGlobalObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFrozenArray<IDLDOMString>>(lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject), throwScope, PushManager::supportedContentEncodings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPushManagerConstructor_supportedContentEncodings, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPushManager>::getStatic<jsPushManagerConstructor_supportedContentEncodingsGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsPushManagerPrototypeFunction_subscribeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSPushManager>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto options = convert<IDLDictionary<PushSubscriptionOptionsInit>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<PushSubscription>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.subscribe(*context, WTFMove(options), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsPushManagerPrototypeFunction_subscribe, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSPushManager>::call<jsPushManagerPrototypeFunction_subscribeBody>(*lexicalGlobalObject, *callFrame, "subscribe");
}

static inline JSC::EncodedJSValue jsPushManagerPrototypeFunction_getSubscriptionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSPushManager>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLNullable<IDLInterface<PushSubscription>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.getSubscription(*context, WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsPushManagerPrototypeFunction_getSubscription, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSPushManager>::call<jsPushManagerPrototypeFunction_getSubscriptionBody>(*lexicalGlobalObject, *callFrame, "getSubscription");
}

static inline JSC::EncodedJSValue jsPushManagerPrototypeFunction_permissionStateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSPushManager>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto options = convert<IDLDictionary<PushSubscriptionOptionsInit>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLEnumeration<PushPermissionState>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.permissionState(*context, WTFMove(options), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsPushManagerPrototypeFunction_permissionState, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSPushManager>::call<jsPushManagerPrototypeFunction_permissionStateBody>(*lexicalGlobalObject, *callFrame, "permissionState");
}

JSC::GCClient::IsoSubspace* JSPushManager::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSPushManager, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForPushManager.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForPushManager = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForPushManager.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForPushManager = std::forward<decltype(space)>(space); }
    );
}

void JSPushManager::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPushManager*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSPushManagerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSPushManagerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsPushManager = static_cast<JSPushManager*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsPushManager->wrapped(), jsPushManager);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7PushManager@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11PushManagerE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<PushManager>&& impl)
{

    if constexpr (std::is_polymorphic_v<PushManager>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7PushManager@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore11PushManagerE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // PushManager has subclasses. If PushManager has subclasses that get passed
        // to toJS() we currently require PushManager you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<PushManager>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PushManager& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

PushManager* JSPushManager::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPushManager*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
