/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSProcessingInstruction.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSStyleSheet.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsProcessingInstructionConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsProcessingInstruction_target);
static JSC_DECLARE_CUSTOM_GETTER(jsProcessingInstruction_sheet);

class JSProcessingInstructionPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSProcessingInstructionPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSProcessingInstructionPrototype* ptr = new (NotNull, JSC::allocateCell<JSProcessingInstructionPrototype>(vm)) JSProcessingInstructionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSProcessingInstructionPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSProcessingInstructionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSProcessingInstructionPrototype, JSProcessingInstructionPrototype::Base);

using JSProcessingInstructionDOMConstructor = JSDOMConstructorNotConstructable<JSProcessingInstruction>;

template<> const ClassInfo JSProcessingInstructionDOMConstructor::s_info = { "ProcessingInstruction"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSProcessingInstructionDOMConstructor) };

template<> JSValue JSProcessingInstructionDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCharacterData::getConstructor(vm, &globalObject);
}

template<> void JSProcessingInstructionDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ProcessingInstruction"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSProcessingInstruction::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSProcessingInstructionPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsProcessingInstructionConstructor, 0 } },
    { "target"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsProcessingInstruction_target, 0 } },
    { "sheet"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsProcessingInstruction_sheet, 0 } },
};

const ClassInfo JSProcessingInstructionPrototype::s_info = { "ProcessingInstruction"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSProcessingInstructionPrototype) };

void JSProcessingInstructionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSProcessingInstruction::info(), JSProcessingInstructionPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSProcessingInstruction::s_info = { "ProcessingInstruction"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSProcessingInstruction) };

JSProcessingInstruction::JSProcessingInstruction(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ProcessingInstruction>&& impl)
    : JSCharacterData(structure, globalObject, WTFMove(impl))
{
}

Ref<ProcessingInstruction> JSProcessingInstruction::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSProcessingInstruction::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSProcessingInstructionPrototype::createStructure(vm, &globalObject, JSCharacterData::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSProcessingInstructionPrototype::create(vm, &globalObject, structure);
}

JSObject* JSProcessingInstruction::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSProcessingInstruction>(vm, globalObject);
}

JSValue JSProcessingInstruction::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSProcessingInstructionDOMConstructor, DOMConstructorID::ProcessingInstruction>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsProcessingInstructionConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSProcessingInstructionPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSProcessingInstruction::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsProcessingInstruction_targetGetter(JSGlobalObject& lexicalGlobalObject, JSProcessingInstruction& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.target())));
}

JSC_DEFINE_CUSTOM_GETTER(jsProcessingInstruction_target, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSProcessingInstruction>::get<jsProcessingInstruction_targetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsProcessingInstruction_sheetGetter(JSGlobalObject& lexicalGlobalObject, JSProcessingInstruction& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<StyleSheet>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.sheet())));
}

JSC_DEFINE_CUSTOM_GETTER(jsProcessingInstruction_sheet, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSProcessingInstruction>::get<jsProcessingInstruction_sheetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSProcessingInstruction::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSProcessingInstruction, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForProcessingInstruction.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForProcessingInstruction = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForProcessingInstruction.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForProcessingInstruction = std::forward<decltype(space)>(space); }
    );
}

void JSProcessingInstruction::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSProcessingInstruction*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ProcessingInstruction@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21ProcessingInstructionE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ProcessingInstruction>&& impl)
{

    if constexpr (std::is_polymorphic_v<ProcessingInstruction>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7ProcessingInstruction@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore21ProcessingInstructionE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // ProcessingInstruction has subclasses. If ProcessingInstruction has subclasses that get passed
        // to toJS() we currently require ProcessingInstruction you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<ProcessingInstruction>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ProcessingInstruction& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
