/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSOESTextureFloatLinear.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSOESTextureFloatLinearPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOESTextureFloatLinearPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOESTextureFloatLinearPrototype* ptr = new (NotNull, JSC::allocateCell<JSOESTextureFloatLinearPrototype>(vm)) JSOESTextureFloatLinearPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESTextureFloatLinearPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOESTextureFloatLinearPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESTextureFloatLinearPrototype, JSOESTextureFloatLinearPrototype::Base);

/* Hash table for prototype */
const ClassInfo JSOESTextureFloatLinearPrototype::s_info = { "OESTextureFloatLinear"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESTextureFloatLinearPrototype) };

void JSOESTextureFloatLinearPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSOESTextureFloatLinear::s_info = { "OESTextureFloatLinear"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESTextureFloatLinear) };

JSOESTextureFloatLinear::JSOESTextureFloatLinear(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OESTextureFloatLinear>&& impl)
    : JSDOMWrapper<OESTextureFloatLinear>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, OESTextureFloatLinear>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSOESTextureFloatLinear::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSOESTextureFloatLinearPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSOESTextureFloatLinearPrototype::create(vm, &globalObject, structure);
}

JSObject* JSOESTextureFloatLinear::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOESTextureFloatLinear>(vm, globalObject);
}

void JSOESTextureFloatLinear::destroy(JSC::JSCell* cell)
{
    JSOESTextureFloatLinear* thisObject = static_cast<JSOESTextureFloatLinear*>(cell);
    thisObject->JSOESTextureFloatLinear::~JSOESTextureFloatLinear();
}

JSC::GCClient::IsoSubspace* JSOESTextureFloatLinear::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSOESTextureFloatLinear, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForOESTextureFloatLinear.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForOESTextureFloatLinear = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForOESTextureFloatLinear.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForOESTextureFloatLinear = std::forward<decltype(space)>(space); }
    );
}

void JSOESTextureFloatLinear::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOESTextureFloatLinear*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSOESTextureFloatLinearOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsOESTextureFloatLinear = jsCast<JSOESTextureFloatLinear*>(handle.slot()->asCell());
    auto& owner = jsOESTextureFloatLinear->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsOESTextureFloatLinear";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSOESTextureFloatLinearOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOESTextureFloatLinear = static_cast<JSOESTextureFloatLinear*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsOESTextureFloatLinear->wrapped(), jsOESTextureFloatLinear);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OESTextureFloatLinear@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21OESTextureFloatLinearE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OESTextureFloatLinear>&& impl)
{

    if constexpr (std::is_polymorphic_v<OESTextureFloatLinear>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7OESTextureFloatLinear@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore21OESTextureFloatLinearE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // OESTextureFloatLinear has subclasses. If OESTextureFloatLinear has subclasses that get passed
        // to toJS() we currently require OESTextureFloatLinear you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<OESTextureFloatLinear>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OESTextureFloatLinear& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

OESTextureFloatLinear* JSOESTextureFloatLinear::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSOESTextureFloatLinear*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
