/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSOESDrawBuffersIndexed.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_enableiOES);
static JSC_DECLARE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_disableiOES);
static JSC_DECLARE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_blendEquationiOES);
static JSC_DECLARE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_blendEquationSeparateiOES);
static JSC_DECLARE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_blendFunciOES);
static JSC_DECLARE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_blendFuncSeparateiOES);
static JSC_DECLARE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_colorMaskiOES);

class JSOESDrawBuffersIndexedPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOESDrawBuffersIndexedPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOESDrawBuffersIndexedPrototype* ptr = new (NotNull, JSC::allocateCell<JSOESDrawBuffersIndexedPrototype>(vm)) JSOESDrawBuffersIndexedPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESDrawBuffersIndexedPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOESDrawBuffersIndexedPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESDrawBuffersIndexedPrototype, JSOESDrawBuffersIndexedPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSOESDrawBuffersIndexedPrototypeTableValues[] =
{
    { "enableiOES"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOESDrawBuffersIndexedPrototypeFunction_enableiOES, 2 } },
    { "disableiOES"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOESDrawBuffersIndexedPrototypeFunction_disableiOES, 2 } },
    { "blendEquationiOES"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOESDrawBuffersIndexedPrototypeFunction_blendEquationiOES, 2 } },
    { "blendEquationSeparateiOES"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOESDrawBuffersIndexedPrototypeFunction_blendEquationSeparateiOES, 3 } },
    { "blendFunciOES"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOESDrawBuffersIndexedPrototypeFunction_blendFunciOES, 3 } },
    { "blendFuncSeparateiOES"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOESDrawBuffersIndexedPrototypeFunction_blendFuncSeparateiOES, 5 } },
    { "colorMaskiOES"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOESDrawBuffersIndexedPrototypeFunction_colorMaskiOES, 5 } },
};

const ClassInfo JSOESDrawBuffersIndexedPrototype::s_info = { "OESDrawBuffersIndexed"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESDrawBuffersIndexedPrototype) };

void JSOESDrawBuffersIndexedPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSOESDrawBuffersIndexed::info(), JSOESDrawBuffersIndexedPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSOESDrawBuffersIndexed::s_info = { "OESDrawBuffersIndexed"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESDrawBuffersIndexed) };

JSOESDrawBuffersIndexed::JSOESDrawBuffersIndexed(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OESDrawBuffersIndexed>&& impl)
    : JSDOMWrapper<OESDrawBuffersIndexed>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, OESDrawBuffersIndexed>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSOESDrawBuffersIndexed::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSOESDrawBuffersIndexedPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSOESDrawBuffersIndexedPrototype::create(vm, &globalObject, structure);
}

JSObject* JSOESDrawBuffersIndexed::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOESDrawBuffersIndexed>(vm, globalObject);
}

void JSOESDrawBuffersIndexed::destroy(JSC::JSCell* cell)
{
    JSOESDrawBuffersIndexed* thisObject = static_cast<JSOESDrawBuffersIndexed*>(cell);
    thisObject->JSOESDrawBuffersIndexed::~JSOESDrawBuffersIndexed();
}

static inline JSC::EncodedJSValue jsOESDrawBuffersIndexedPrototypeFunction_enableiOESBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOESDrawBuffersIndexed>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.enableiOES(WTFMove(target), WTFMove(index)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_enableiOES, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOESDrawBuffersIndexed>::call<jsOESDrawBuffersIndexedPrototypeFunction_enableiOESBody>(*lexicalGlobalObject, *callFrame, "enableiOES");
}

static inline JSC::EncodedJSValue jsOESDrawBuffersIndexedPrototypeFunction_disableiOESBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOESDrawBuffersIndexed>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.disableiOES(WTFMove(target), WTFMove(index)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_disableiOES, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOESDrawBuffersIndexed>::call<jsOESDrawBuffersIndexedPrototypeFunction_disableiOESBody>(*lexicalGlobalObject, *callFrame, "disableiOES");
}

static inline JSC::EncodedJSValue jsOESDrawBuffersIndexedPrototypeFunction_blendEquationiOESBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOESDrawBuffersIndexed>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto buf = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto mode = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.blendEquationiOES(WTFMove(buf), WTFMove(mode)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_blendEquationiOES, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOESDrawBuffersIndexed>::call<jsOESDrawBuffersIndexedPrototypeFunction_blendEquationiOESBody>(*lexicalGlobalObject, *callFrame, "blendEquationiOES");
}

static inline JSC::EncodedJSValue jsOESDrawBuffersIndexedPrototypeFunction_blendEquationSeparateiOESBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOESDrawBuffersIndexed>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto buf = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto modeRGB = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto modeAlpha = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.blendEquationSeparateiOES(WTFMove(buf), WTFMove(modeRGB), WTFMove(modeAlpha)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_blendEquationSeparateiOES, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOESDrawBuffersIndexed>::call<jsOESDrawBuffersIndexedPrototypeFunction_blendEquationSeparateiOESBody>(*lexicalGlobalObject, *callFrame, "blendEquationSeparateiOES");
}

static inline JSC::EncodedJSValue jsOESDrawBuffersIndexedPrototypeFunction_blendFunciOESBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOESDrawBuffersIndexed>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto buf = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto src = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto dst = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.blendFunciOES(WTFMove(buf), WTFMove(src), WTFMove(dst)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_blendFunciOES, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOESDrawBuffersIndexed>::call<jsOESDrawBuffersIndexedPrototypeFunction_blendFunciOESBody>(*lexicalGlobalObject, *callFrame, "blendFunciOES");
}

static inline JSC::EncodedJSValue jsOESDrawBuffersIndexedPrototypeFunction_blendFuncSeparateiOESBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOESDrawBuffersIndexed>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto buf = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto srcRGB = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto dstRGB = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto srcAlpha = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto dstAlpha = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument4.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.blendFuncSeparateiOES(WTFMove(buf), WTFMove(srcRGB), WTFMove(dstRGB), WTFMove(srcAlpha), WTFMove(dstAlpha)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_blendFuncSeparateiOES, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOESDrawBuffersIndexed>::call<jsOESDrawBuffersIndexedPrototypeFunction_blendFuncSeparateiOESBody>(*lexicalGlobalObject, *callFrame, "blendFuncSeparateiOES");
}

static inline JSC::EncodedJSValue jsOESDrawBuffersIndexedPrototypeFunction_colorMaskiOESBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOESDrawBuffersIndexed>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto buf = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto r = convert<IDLBoolean>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto g = convert<IDLBoolean>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto b = convert<IDLBoolean>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto a = convert<IDLBoolean>(*lexicalGlobalObject, argument4.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.colorMaskiOES(WTFMove(buf), WTFMove(r), WTFMove(g), WTFMove(b), WTFMove(a)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOESDrawBuffersIndexedPrototypeFunction_colorMaskiOES, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOESDrawBuffersIndexed>::call<jsOESDrawBuffersIndexedPrototypeFunction_colorMaskiOESBody>(*lexicalGlobalObject, *callFrame, "colorMaskiOES");
}

JSC::GCClient::IsoSubspace* JSOESDrawBuffersIndexed::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSOESDrawBuffersIndexed, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForOESDrawBuffersIndexed.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForOESDrawBuffersIndexed = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForOESDrawBuffersIndexed.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForOESDrawBuffersIndexed = std::forward<decltype(space)>(space); }
    );
}

void JSOESDrawBuffersIndexed::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOESDrawBuffersIndexed*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSOESDrawBuffersIndexedOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsOESDrawBuffersIndexed = jsCast<JSOESDrawBuffersIndexed*>(handle.slot()->asCell());
    auto& owner = jsOESDrawBuffersIndexed->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsOESDrawBuffersIndexed";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSOESDrawBuffersIndexedOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOESDrawBuffersIndexed = static_cast<JSOESDrawBuffersIndexed*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsOESDrawBuffersIndexed->wrapped(), jsOESDrawBuffersIndexed);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OESDrawBuffersIndexed@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21OESDrawBuffersIndexedE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OESDrawBuffersIndexed>&& impl)
{

    if constexpr (std::is_polymorphic_v<OESDrawBuffersIndexed>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7OESDrawBuffersIndexed@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore21OESDrawBuffersIndexedE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // OESDrawBuffersIndexed has subclasses. If OESDrawBuffersIndexed has subclasses that get passed
        // to toJS() we currently require OESDrawBuffersIndexed you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<OESDrawBuffersIndexed>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OESDrawBuffersIndexed& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

OESDrawBuffersIndexed* JSOESDrawBuffersIndexed::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSOESDrawBuffersIndexed*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
