/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSNavigationPreloadManager.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSNavigationPreloadState.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsNavigationPreloadManagerPrototypeFunction_enable);
static JSC_DECLARE_HOST_FUNCTION(jsNavigationPreloadManagerPrototypeFunction_disable);
static JSC_DECLARE_HOST_FUNCTION(jsNavigationPreloadManagerPrototypeFunction_setHeaderValue);
static JSC_DECLARE_HOST_FUNCTION(jsNavigationPreloadManagerPrototypeFunction_getState);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsNavigationPreloadManagerConstructor);

class JSNavigationPreloadManagerPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSNavigationPreloadManagerPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSNavigationPreloadManagerPrototype* ptr = new (NotNull, JSC::allocateCell<JSNavigationPreloadManagerPrototype>(vm)) JSNavigationPreloadManagerPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNavigationPreloadManagerPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSNavigationPreloadManagerPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNavigationPreloadManagerPrototype, JSNavigationPreloadManagerPrototype::Base);

using JSNavigationPreloadManagerDOMConstructor = JSDOMConstructorNotConstructable<JSNavigationPreloadManager>;

template<> const ClassInfo JSNavigationPreloadManagerDOMConstructor::s_info = { "NavigationPreloadManager"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigationPreloadManagerDOMConstructor) };

template<> JSValue JSNavigationPreloadManagerDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSNavigationPreloadManagerDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "NavigationPreloadManager"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSNavigationPreloadManager::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSNavigationPreloadManagerPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigationPreloadManagerConstructor, 0 } },
    { "enable"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNavigationPreloadManagerPrototypeFunction_enable, 0 } },
    { "disable"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNavigationPreloadManagerPrototypeFunction_disable, 0 } },
    { "setHeaderValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNavigationPreloadManagerPrototypeFunction_setHeaderValue, 1 } },
    { "getState"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNavigationPreloadManagerPrototypeFunction_getState, 0 } },
};

const ClassInfo JSNavigationPreloadManagerPrototype::s_info = { "NavigationPreloadManager"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigationPreloadManagerPrototype) };

void JSNavigationPreloadManagerPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSNavigationPreloadManager::info(), JSNavigationPreloadManagerPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSNavigationPreloadManager::s_info = { "NavigationPreloadManager"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigationPreloadManager) };

JSNavigationPreloadManager::JSNavigationPreloadManager(Structure* structure, JSDOMGlobalObject& globalObject, Ref<NavigationPreloadManager>&& impl)
    : JSDOMWrapper<NavigationPreloadManager>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, NavigationPreloadManager>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSNavigationPreloadManager::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSNavigationPreloadManagerPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSNavigationPreloadManagerPrototype::create(vm, &globalObject, structure);
}

JSObject* JSNavigationPreloadManager::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSNavigationPreloadManager>(vm, globalObject);
}

JSValue JSNavigationPreloadManager::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNavigationPreloadManagerDOMConstructor, DOMConstructorID::NavigationPreloadManager>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSNavigationPreloadManager::destroy(JSC::JSCell* cell)
{
    JSNavigationPreloadManager* thisObject = static_cast<JSNavigationPreloadManager*>(cell);
    thisObject->JSNavigationPreloadManager::~JSNavigationPreloadManager();
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigationPreloadManagerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSNavigationPreloadManagerPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSNavigationPreloadManager::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsNavigationPreloadManagerPrototypeFunction_enableBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSNavigationPreloadManager>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.enable(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsNavigationPreloadManagerPrototypeFunction_enable, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSNavigationPreloadManager>::call<jsNavigationPreloadManagerPrototypeFunction_enableBody>(*lexicalGlobalObject, *callFrame, "enable");
}

static inline JSC::EncodedJSValue jsNavigationPreloadManagerPrototypeFunction_disableBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSNavigationPreloadManager>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.disable(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsNavigationPreloadManagerPrototypeFunction_disable, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSNavigationPreloadManager>::call<jsNavigationPreloadManagerPrototypeFunction_disableBody>(*lexicalGlobalObject, *callFrame, "disable");
}

static inline JSC::EncodedJSValue jsNavigationPreloadManagerPrototypeFunction_setHeaderValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSNavigationPreloadManager>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLByteString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.setHeaderValue(WTFMove(value), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsNavigationPreloadManagerPrototypeFunction_setHeaderValue, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSNavigationPreloadManager>::call<jsNavigationPreloadManagerPrototypeFunction_setHeaderValueBody>(*lexicalGlobalObject, *callFrame, "setHeaderValue");
}

static inline JSC::EncodedJSValue jsNavigationPreloadManagerPrototypeFunction_getStateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSNavigationPreloadManager>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLDictionary<NavigationPreloadState>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.getState(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsNavigationPreloadManagerPrototypeFunction_getState, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSNavigationPreloadManager>::call<jsNavigationPreloadManagerPrototypeFunction_getStateBody>(*lexicalGlobalObject, *callFrame, "getState");
}

JSC::GCClient::IsoSubspace* JSNavigationPreloadManager::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSNavigationPreloadManager, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForNavigationPreloadManager.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForNavigationPreloadManager = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForNavigationPreloadManager.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForNavigationPreloadManager = std::forward<decltype(space)>(space); }
    );
}

void JSNavigationPreloadManager::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSNavigationPreloadManager*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSNavigationPreloadManagerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSNavigationPreloadManagerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsNavigationPreloadManager = static_cast<JSNavigationPreloadManager*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsNavigationPreloadManager->wrapped(), jsNavigationPreloadManager);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<NavigationPreloadManager>&& impl)
{
    return createWrapper<NavigationPreloadManager>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, NavigationPreloadManager& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

NavigationPreloadManager* JSNavigationPreloadManager::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSNavigationPreloadManager*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
