/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSNavigationHistoryEntry.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsNavigationHistoryEntryPrototypeFunction_getState);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsNavigationHistoryEntryConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigationHistoryEntry_url);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigationHistoryEntry_key);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigationHistoryEntry_id);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigationHistoryEntry_index);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigationHistoryEntry_sameDocument);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigationHistoryEntry_ondispose);
static JSC_DECLARE_CUSTOM_SETTER(setJSNavigationHistoryEntry_ondispose);

class JSNavigationHistoryEntryPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSNavigationHistoryEntryPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSNavigationHistoryEntryPrototype* ptr = new (NotNull, JSC::allocateCell<JSNavigationHistoryEntryPrototype>(vm)) JSNavigationHistoryEntryPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNavigationHistoryEntryPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSNavigationHistoryEntryPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNavigationHistoryEntryPrototype, JSNavigationHistoryEntryPrototype::Base);

using JSNavigationHistoryEntryDOMConstructor = JSDOMConstructorNotConstructable<JSNavigationHistoryEntry>;

template<> const ClassInfo JSNavigationHistoryEntryDOMConstructor::s_info = { "NavigationHistoryEntry"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigationHistoryEntryDOMConstructor) };

template<> JSValue JSNavigationHistoryEntryDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSNavigationHistoryEntryDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "NavigationHistoryEntry"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSNavigationHistoryEntry::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSNavigationHistoryEntryPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigationHistoryEntryConstructor, 0 } },
    { "url"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigationHistoryEntry_url, 0 } },
    { "key"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigationHistoryEntry_key, 0 } },
    { "id"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigationHistoryEntry_id, 0 } },
    { "index"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigationHistoryEntry_index, 0 } },
    { "sameDocument"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigationHistoryEntry_sameDocument, 0 } },
    { "ondispose"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigationHistoryEntry_ondispose, setJSNavigationHistoryEntry_ondispose } },
    { "getState"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNavigationHistoryEntryPrototypeFunction_getState, 0 } },
};

const ClassInfo JSNavigationHistoryEntryPrototype::s_info = { "NavigationHistoryEntry"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigationHistoryEntryPrototype) };

void JSNavigationHistoryEntryPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSNavigationHistoryEntry::info(), JSNavigationHistoryEntryPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSNavigationHistoryEntry::s_info = { "NavigationHistoryEntry"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigationHistoryEntry) };

JSNavigationHistoryEntry::JSNavigationHistoryEntry(Structure* structure, JSDOMGlobalObject& globalObject, Ref<NavigationHistoryEntry>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<NavigationHistoryEntry> JSNavigationHistoryEntry::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, NavigationHistoryEntry>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSNavigationHistoryEntry::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSNavigationHistoryEntryPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSNavigationHistoryEntryPrototype::create(vm, &globalObject, structure);
}

JSObject* JSNavigationHistoryEntry::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSNavigationHistoryEntry>(vm, globalObject);
}

JSValue JSNavigationHistoryEntry::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNavigationHistoryEntryDOMConstructor, DOMConstructorID::NavigationHistoryEntry>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigationHistoryEntryConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSNavigationHistoryEntryPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSNavigationHistoryEntry::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsNavigationHistoryEntry_urlGetter(JSGlobalObject& lexicalGlobalObject, JSNavigationHistoryEntry& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.url())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigationHistoryEntry_url, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigationHistoryEntry>::get<jsNavigationHistoryEntry_urlGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigationHistoryEntry_keyGetter(JSGlobalObject& lexicalGlobalObject, JSNavigationHistoryEntry& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.key())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigationHistoryEntry_key, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigationHistoryEntry>::get<jsNavigationHistoryEntry_keyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigationHistoryEntry_idGetter(JSGlobalObject& lexicalGlobalObject, JSNavigationHistoryEntry& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.id())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigationHistoryEntry_id, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigationHistoryEntry>::get<jsNavigationHistoryEntry_idGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigationHistoryEntry_indexGetter(JSGlobalObject& lexicalGlobalObject, JSNavigationHistoryEntry& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLongLong>(lexicalGlobalObject, throwScope, impl.index())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigationHistoryEntry_index, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigationHistoryEntry>::get<jsNavigationHistoryEntry_indexGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigationHistoryEntry_sameDocumentGetter(JSGlobalObject& lexicalGlobalObject, JSNavigationHistoryEntry& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.sameDocument())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigationHistoryEntry_sameDocument, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigationHistoryEntry>::get<jsNavigationHistoryEntry_sameDocumentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigationHistoryEntry_ondisposeGetter(JSGlobalObject& lexicalGlobalObject, JSNavigationHistoryEntry& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().disposeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigationHistoryEntry_ondispose, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigationHistoryEntry>::get<jsNavigationHistoryEntry_ondisposeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSNavigationHistoryEntry_ondisposeSetter(JSGlobalObject& lexicalGlobalObject, JSNavigationHistoryEntry& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().disposeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSNavigationHistoryEntry_ondispose, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigationHistoryEntry>::set<setJSNavigationHistoryEntry_ondisposeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsNavigationHistoryEntryPrototypeFunction_getStateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNavigationHistoryEntry>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLAny>(*lexicalGlobalObject, throwScope, impl.getState())));
}

JSC_DEFINE_HOST_FUNCTION(jsNavigationHistoryEntryPrototypeFunction_getState, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNavigationHistoryEntry>::call<jsNavigationHistoryEntryPrototypeFunction_getStateBody>(*lexicalGlobalObject, *callFrame, "getState");
}

JSC::GCClient::IsoSubspace* JSNavigationHistoryEntry::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSNavigationHistoryEntry, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForNavigationHistoryEntry.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForNavigationHistoryEntry = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForNavigationHistoryEntry.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForNavigationHistoryEntry = std::forward<decltype(space)>(space); }
    );
}

void JSNavigationHistoryEntry::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSNavigationHistoryEntry*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7NavigationHistoryEntry@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22NavigationHistoryEntryE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<NavigationHistoryEntry>&& impl)
{

    if constexpr (std::is_polymorphic_v<NavigationHistoryEntry>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7NavigationHistoryEntry@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore22NavigationHistoryEntryE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // NavigationHistoryEntry has subclasses. If NavigationHistoryEntry has subclasses that get passed
        // to toJS() we currently require NavigationHistoryEntry you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<NavigationHistoryEntry>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, NavigationHistoryEntry& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

NavigationHistoryEntry* JSNavigationHistoryEntry::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSNavigationHistoryEntry*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
