/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSNamedNodeMap.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "Document.h"
#include "DocumentInlines.h"
#include "Element.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSAttr.h"
#include "JSDOMAbstractOperations.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSNodeCustom.h"
#include "Quirks.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/ArrayPrototype.h>
#include <JavaScriptCore/BuiltinNames.h>
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/PropertyNameArray.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsNamedNodeMapPrototypeFunction_item);
static JSC_DECLARE_HOST_FUNCTION(jsNamedNodeMapPrototypeFunction_getNamedItem);
static JSC_DECLARE_HOST_FUNCTION(jsNamedNodeMapPrototypeFunction_getNamedItemNS);
static JSC_DECLARE_HOST_FUNCTION(jsNamedNodeMapPrototypeFunction_setNamedItem);
static JSC_DECLARE_HOST_FUNCTION(jsNamedNodeMapPrototypeFunction_setNamedItemNS);
static JSC_DECLARE_HOST_FUNCTION(jsNamedNodeMapPrototypeFunction_removeNamedItem);
static JSC_DECLARE_HOST_FUNCTION(jsNamedNodeMapPrototypeFunction_removeNamedItemNS);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsNamedNodeMapConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsNamedNodeMap_length);

class JSNamedNodeMapPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSNamedNodeMapPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSNamedNodeMapPrototype* ptr = new (NotNull, JSC::allocateCell<JSNamedNodeMapPrototype>(vm)) JSNamedNodeMapPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNamedNodeMapPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSNamedNodeMapPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNamedNodeMapPrototype, JSNamedNodeMapPrototype::Base);

using JSNamedNodeMapDOMConstructor = JSDOMConstructorNotConstructable<JSNamedNodeMap>;

template<> const ClassInfo JSNamedNodeMapDOMConstructor::s_info = { "NamedNodeMap"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNamedNodeMapDOMConstructor) };

template<> JSValue JSNamedNodeMapDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSNamedNodeMapDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "NamedNodeMap"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSNamedNodeMap::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSNamedNodeMapPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsNamedNodeMapConstructor, 0 } },
    { "length"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNamedNodeMap_length, 0 } },
    { "item"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNamedNodeMapPrototypeFunction_item, 1 } },
    { "getNamedItem"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNamedNodeMapPrototypeFunction_getNamedItem, 1 } },
    { "getNamedItemNS"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNamedNodeMapPrototypeFunction_getNamedItemNS, 2 } },
    { "setNamedItem"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNamedNodeMapPrototypeFunction_setNamedItem, 1 } },
    { "setNamedItemNS"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNamedNodeMapPrototypeFunction_setNamedItemNS, 1 } },
    { "removeNamedItem"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNamedNodeMapPrototypeFunction_removeNamedItem, 1 } },
    { "removeNamedItemNS"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNamedNodeMapPrototypeFunction_removeNamedItemNS, 2 } },
};

const ClassInfo JSNamedNodeMapPrototype::s_info = { "NamedNodeMap"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNamedNodeMapPrototype) };

void JSNamedNodeMapPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSNamedNodeMap::info(), JSNamedNodeMapPrototypeTableValues, *this);
    putDirect(vm, vm.propertyNames->iteratorSymbol, globalObject()->arrayPrototype()->getDirect(vm, vm.propertyNames->builtinNames().valuesPrivateName()), static_cast<unsigned>(JSC::PropertyAttribute::DontEnum));
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSNamedNodeMap::s_info = { "NamedNodeMap"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNamedNodeMap) };

JSNamedNodeMap::JSNamedNodeMap(Structure* structure, JSDOMGlobalObject& globalObject, Ref<NamedNodeMap>&& impl)
    : JSDOMWrapper<NamedNodeMap>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, NamedNodeMap>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSNamedNodeMap::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSNamedNodeMapPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSNamedNodeMapPrototype::create(vm, &globalObject, structure);
}

JSObject* JSNamedNodeMap::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSNamedNodeMap>(vm, globalObject);
}

JSValue JSNamedNodeMap::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNamedNodeMapDOMConstructor, DOMConstructorID::NamedNodeMap>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSNamedNodeMap::destroy(JSC::JSCell* cell)
{
    JSNamedNodeMap* thisObject = static_cast<JSNamedNodeMap*>(cell);
    thisObject->JSNamedNodeMap::~JSNamedNodeMap();
}

bool JSNamedNodeMap::legacyPlatformObjectGetOwnProperty(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, PropertySlot& slot, bool ignoreNamedProperties)
{
    auto throwScope = DECLARE_THROW_SCOPE(JSC::getVM(lexicalGlobalObject));
    auto* thisObject = jsCast<JSNamedNodeMap*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (auto index = parseIndex(propertyName)) {
        if (auto item = thisObject->wrapped().item(index.value()); LIKELY(!!item)) {
            auto value = toJS<IDLNullable<IDLInterface<Attr>>>(*lexicalGlobalObject, *thisObject->globalObject(), throwScope, WTFMove(item));
            RETURN_IF_EXCEPTION(throwScope, false);
            slot.setValue(thisObject, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), value);
            return true;
        }
        return JSObject::getOwnPropertySlot(object, lexicalGlobalObject, propertyName, slot);
    }
    if (!ignoreNamedProperties) {
        using GetterIDLType = IDLInterface<Attr>;
        auto getterFunctor = visibleNamedPropertyItemAccessorFunctor<GetterIDLType, JSNamedNodeMap>([] (JSNamedNodeMap& thisObject, PropertyName propertyName) -> decltype(auto) {
            return thisObject.wrapped().getNamedItem(propertyNameToAtomString(propertyName));
        });
        if (auto namedProperty = accessVisibleNamedProperty<LegacyOverrideBuiltIns::No>(*lexicalGlobalObject, *thisObject, propertyName, getterFunctor)) {
            auto value = toJS<IDLNullable<IDLInterface<Attr>>>(*lexicalGlobalObject, *thisObject->globalObject(), throwScope, WTFMove(namedProperty.value()));
            RETURN_IF_EXCEPTION(throwScope, false);
            slot.setValue(thisObject, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum, value);
            return true;
        }
    }
    return JSObject::getOwnPropertySlot(object, lexicalGlobalObject, propertyName, slot);
}

bool JSNamedNodeMap::getOwnPropertySlot(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, PropertySlot& slot)
{
    bool ignoreNamedProperties = false;
    return legacyPlatformObjectGetOwnProperty(object, lexicalGlobalObject, propertyName, slot, ignoreNamedProperties);
}

bool JSNamedNodeMap::getOwnPropertySlotByIndex(JSObject* object, JSGlobalObject* lexicalGlobalObject, unsigned index, PropertySlot& slot)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* thisObject = jsCast<JSNamedNodeMap*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (LIKELY(index <= MAX_ARRAY_INDEX)) {
        if (auto item = thisObject->wrapped().item(index); LIKELY(!!item)) {
            auto value = toJS<IDLNullable<IDLInterface<Attr>>>(*lexicalGlobalObject, *thisObject->globalObject(), throwScope, WTFMove(item));
            RETURN_IF_EXCEPTION(throwScope, false);
            slot.setValue(thisObject, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), value);
            return true;
        }
        return JSObject::getOwnPropertySlotByIndex(object, lexicalGlobalObject, index, slot);
    }
    auto propertyName = Identifier::from(vm, index);
    using GetterIDLType = IDLInterface<Attr>;
    auto getterFunctor = visibleNamedPropertyItemAccessorFunctor<GetterIDLType, JSNamedNodeMap>([] (JSNamedNodeMap& thisObject, PropertyName propertyName) -> decltype(auto) {
        return thisObject.wrapped().getNamedItem(propertyNameToAtomString(propertyName));
    });
    if (auto namedProperty = accessVisibleNamedProperty<LegacyOverrideBuiltIns::No>(*lexicalGlobalObject, *thisObject, propertyName, getterFunctor)) {
        auto value = toJS<IDLNullable<IDLInterface<Attr>>>(*lexicalGlobalObject, *thisObject->globalObject(), throwScope, WTFMove(namedProperty.value()));
        RETURN_IF_EXCEPTION(throwScope, false);
        slot.setValue(thisObject, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum, value);
        return true;
    }
    return JSObject::getOwnPropertySlotByIndex(object, lexicalGlobalObject, index, slot);
}

void JSNamedNodeMap::getOwnPropertyNames(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyNameArray& propertyNames, DontEnumPropertiesMode mode)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto* thisObject = jsCast<JSNamedNodeMap*>(object);
    ASSERT_GC_OBJECT_INHERITS(object, info());
    for (unsigned i = 0, count = thisObject->wrapped().length(); i < count; ++i)
        propertyNames.add(Identifier::from(vm, i));
    if (mode == DontEnumPropertiesMode::Include) {
        for (auto& propertyName : thisObject->wrapped().supportedPropertyNames())
            propertyNames.add(Identifier::fromString(vm, propertyName));
    }
    JSObject::getOwnPropertyNames(object, lexicalGlobalObject, propertyNames, mode);
}

bool JSNamedNodeMap::put(JSCell* cell, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, JSValue value, PutPropertySlot& putPropertySlot)
{
    auto* thisObject = jsCast<JSNamedNodeMap*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());

    if (UNLIKELY(thisObject != putPropertySlot.thisValue()))
        return JSObject::put(thisObject, lexicalGlobalObject, propertyName, value, putPropertySlot);

    // Temporary quirk for ungap/@custom-elements polyfill (rdar://problem/111008826), consider removing in 2025.
    if (auto* document = dynamicDowncast<Document>(jsDynamicCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext())) {
        if (UNLIKELY(document->quirks().needsConfigurableIndexedPropertiesQuirk()))
            return JSObject::put(thisObject, lexicalGlobalObject, propertyName, value, putPropertySlot);
    }

    auto throwScope = DECLARE_THROW_SCOPE(lexicalGlobalObject->vm());

    throwScope.assertNoException();
    PropertyDescriptor ownDescriptor;
    PropertySlot slot(thisObject, PropertySlot::InternalMethodType::GetOwnProperty);;
    bool ignoreNamedProperties = true;
    bool hasOwnProperty = legacyPlatformObjectGetOwnProperty(thisObject, lexicalGlobalObject, propertyName, slot, ignoreNamedProperties);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (hasOwnProperty) {
        ownDescriptor.setPropertySlot(lexicalGlobalObject, propertyName, slot);
        RETURN_IF_EXCEPTION(throwScope, false);
    }
    RELEASE_AND_RETURN(throwScope, ordinarySetWithOwnDescriptor(lexicalGlobalObject, thisObject, propertyName, value, putPropertySlot.thisValue(), WTFMove(ownDescriptor), putPropertySlot.isStrictMode()));
}

bool JSNamedNodeMap::putByIndex(JSCell* cell, JSGlobalObject* lexicalGlobalObject, unsigned index, JSValue value, bool shouldThrow)
{

    // Temporary quirk for ungap/@custom-elements polyfill (rdar://problem/111008826), consider removing in 2025.
    if (auto* document = dynamicDowncast<Document>(jsDynamicCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext())) {
        if (UNLIKELY(document->quirks().needsConfigurableIndexedPropertiesQuirk()))
            return JSObject::putByIndex(cell, lexicalGlobalObject, index, value, shouldThrow);
    }

    auto* thisObject = jsCast<JSNamedNodeMap*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());

    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    throwScope.assertNoException();
    auto propertyName = Identifier::from(vm, index);
    PutPropertySlot putPropertySlot(thisObject, shouldThrow);
    RELEASE_AND_RETURN(throwScope, ordinarySetSlow(lexicalGlobalObject, thisObject, propertyName, value, putPropertySlot.thisValue(), shouldThrow));
}

bool JSNamedNodeMap::defineOwnProperty(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, const PropertyDescriptor& propertyDescriptor, bool shouldThrow)
{
    auto* thisObject = jsCast<JSNamedNodeMap*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());

    auto throwScope = DECLARE_THROW_SCOPE(lexicalGlobalObject->vm());

    if (parseIndex(propertyName))
        return typeError(lexicalGlobalObject, throwScope, shouldThrow, "Cannot set indexed properties on this object"_s);

    if (!propertyName.isSymbol()) {
        PropertySlot slot { thisObject, PropertySlot::InternalMethodType::VMInquiry, &lexicalGlobalObject->vm() };
        bool found = JSObject::getOwnPropertySlot(thisObject, lexicalGlobalObject, propertyName, slot);
        slot.disallowVMEntry.reset();
        RETURN_IF_EXCEPTION(throwScope, false);
        if (!found) {
            if (thisObject->wrapped().isSupportedPropertyName(propertyNameToString(propertyName)))
                return typeError(lexicalGlobalObject, throwScope, shouldThrow, "Cannot set named properties on this object"_s);
        }
    }

    PropertyDescriptor newPropertyDescriptor = propertyDescriptor;
    throwScope.release();
    return JSObject::defineOwnProperty(object, lexicalGlobalObject, propertyName, newPropertyDescriptor, shouldThrow);
}

bool JSNamedNodeMap::deleteProperty(JSCell* cell, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, DeletePropertySlot& slot)
{
    auto& thisObject = *jsCast<JSNamedNodeMap*>(cell);
    auto& impl = thisObject.wrapped();

    // Temporary quirk for ungap/@custom-elements polyfill (rdar://problem/111008826), consider removing in 2025.
    if (auto* document = dynamicDowncast<Document>(jsDynamicCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext())) {
        if (UNLIKELY(document->quirks().needsConfigurableIndexedPropertiesQuirk()))
            return JSObject::deleteProperty(cell, lexicalGlobalObject, propertyName, slot);
    }

    if (auto index = parseIndex(propertyName))
        return !impl.isSupportedPropertyIndex(index.value());
    if (!propertyName.isSymbol() && impl.isSupportedPropertyName(propertyNameToString(propertyName))) {
        PropertySlot slotForGet { &thisObject, PropertySlot::InternalMethodType::VMInquiry, &lexicalGlobalObject->vm() };
        if (!JSObject::getOwnPropertySlot(&thisObject, lexicalGlobalObject, propertyName, slotForGet))
            return false;
    }
    return JSObject::deleteProperty(cell, lexicalGlobalObject, propertyName, slot);
}

bool JSNamedNodeMap::deletePropertyByIndex(JSCell* cell, JSGlobalObject* lexicalGlobalObject, unsigned index)
{
    UNUSED_PARAM(lexicalGlobalObject);
    auto& thisObject = *jsCast<JSNamedNodeMap*>(cell);
    auto& impl = thisObject.wrapped();

    // Temporary quirk for ungap/@custom-elements polyfill (rdar://problem/111008826), consider removing in 2025.
    if (auto* document = dynamicDowncast<Document>(jsDynamicCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext())) {
        if (UNLIKELY(document->quirks().needsConfigurableIndexedPropertiesQuirk()))
            return JSObject::deletePropertyByIndex(cell, lexicalGlobalObject, index);
    }

    return !impl.isSupportedPropertyIndex(index);
}

JSC_DEFINE_CUSTOM_GETTER(jsNamedNodeMapConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSNamedNodeMapPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSNamedNodeMap::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsNamedNodeMap_lengthGetter(JSGlobalObject& lexicalGlobalObject, JSNamedNodeMap& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.length())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNamedNodeMap_length, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNamedNodeMap>::get<jsNamedNodeMap_lengthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsNamedNodeMapPrototypeFunction_itemBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNamedNodeMap>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<Attr>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.item(WTFMove(index)))));
}

JSC_DEFINE_HOST_FUNCTION(jsNamedNodeMapPrototypeFunction_item, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNamedNodeMap>::call<jsNamedNodeMapPrototypeFunction_itemBody>(*lexicalGlobalObject, *callFrame, "item");
}

static inline JSC::EncodedJSValue jsNamedNodeMapPrototypeFunction_getNamedItemBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNamedNodeMap>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto qualifiedName = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<Attr>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getNamedItem(WTFMove(qualifiedName)))));
}

JSC_DEFINE_HOST_FUNCTION(jsNamedNodeMapPrototypeFunction_getNamedItem, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNamedNodeMap>::call<jsNamedNodeMapPrototypeFunction_getNamedItemBody>(*lexicalGlobalObject, *callFrame, "getNamedItem");
}

static inline JSC::EncodedJSValue jsNamedNodeMapPrototypeFunction_getNamedItemNSBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNamedNodeMap>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto namespaceURI = convert<IDLNullable<IDLAtomStringAdaptor<IDLDOMString>>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto localName = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<Attr>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getNamedItemNS(WTFMove(namespaceURI), WTFMove(localName)))));
}

JSC_DEFINE_HOST_FUNCTION(jsNamedNodeMapPrototypeFunction_getNamedItemNS, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNamedNodeMap>::call<jsNamedNodeMapPrototypeFunction_getNamedItemNSBody>(*lexicalGlobalObject, *callFrame, "getNamedItemNS");
}

static inline JSC::EncodedJSValue jsNamedNodeMapPrototypeFunction_setNamedItemBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNamedNodeMap>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto attr = convert<IDLInterface<Attr>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "attr", "NamedNodeMap", "setNamedItem", "Attr"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<Attr>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.setNamedItem(*attr))));
}

JSC_DEFINE_HOST_FUNCTION(jsNamedNodeMapPrototypeFunction_setNamedItem, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNamedNodeMap>::call<jsNamedNodeMapPrototypeFunction_setNamedItemBody>(*lexicalGlobalObject, *callFrame, "setNamedItem");
}

static inline JSC::EncodedJSValue jsNamedNodeMapPrototypeFunction_setNamedItemNSBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNamedNodeMap>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto attr = convert<IDLInterface<Attr>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "attr", "NamedNodeMap", "setNamedItemNS", "Attr"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<Attr>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.setNamedItem(*attr))));
}

JSC_DEFINE_HOST_FUNCTION(jsNamedNodeMapPrototypeFunction_setNamedItemNS, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNamedNodeMap>::call<jsNamedNodeMapPrototypeFunction_setNamedItemNSBody>(*lexicalGlobalObject, *callFrame, "setNamedItemNS");
}

static inline JSC::EncodedJSValue jsNamedNodeMapPrototypeFunction_removeNamedItemBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNamedNodeMap>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto qualifiedName = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<Attr>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.removeNamedItem(WTFMove(qualifiedName)))));
}

JSC_DEFINE_HOST_FUNCTION(jsNamedNodeMapPrototypeFunction_removeNamedItem, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNamedNodeMap>::call<jsNamedNodeMapPrototypeFunction_removeNamedItemBody>(*lexicalGlobalObject, *callFrame, "removeNamedItem");
}

static inline JSC::EncodedJSValue jsNamedNodeMapPrototypeFunction_removeNamedItemNSBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNamedNodeMap>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto namespaceURI = convert<IDLNullable<IDLAtomStringAdaptor<IDLDOMString>>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto localName = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<Attr>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.removeNamedItemNS(WTFMove(namespaceURI), WTFMove(localName)))));
}

JSC_DEFINE_HOST_FUNCTION(jsNamedNodeMapPrototypeFunction_removeNamedItemNS, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNamedNodeMap>::call<jsNamedNodeMapPrototypeFunction_removeNamedItemNSBody>(*lexicalGlobalObject, *callFrame, "removeNamedItemNS");
}

JSC::GCClient::IsoSubspace* JSNamedNodeMap::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSNamedNodeMap, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForNamedNodeMap.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForNamedNodeMap = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForNamedNodeMap.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForNamedNodeMap = std::forward<decltype(space)>(space); }
    );
}

void JSNamedNodeMap::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSNamedNodeMap*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSNamedNodeMapOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsNamedNodeMap = jsCast<JSNamedNodeMap*>(handle.slot()->asCell());
    Element* owner = WTF::getPtr(jsNamedNodeMap->wrapped().element());
    if (!owner)
        return false;
    if (UNLIKELY(reason))
        *reason = "Reachable from NamedNodeMapOwner";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSNamedNodeMapOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsNamedNodeMap = static_cast<JSNamedNodeMap*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsNamedNodeMap->wrapped(), jsNamedNodeMap);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7NamedNodeMap@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12NamedNodeMapE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<NamedNodeMap>&& impl)
{

    if constexpr (std::is_polymorphic_v<NamedNodeMap>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7NamedNodeMap@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12NamedNodeMapE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // NamedNodeMap has subclasses. If NamedNodeMap has subclasses that get passed
        // to toJS() we currently require NamedNodeMap you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<NamedNodeMap>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, NamedNodeMap& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

NamedNodeMap* JSNamedNodeMap::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSNamedNodeMap*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
