/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "JSAnimationEffect.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMWrapper.h"
#include "KeyframeEffect.h"

namespace WebCore {

class JSKeyframeEffect : public JSAnimationEffect {
public:
    using Base = JSAnimationEffect;
    using DOMWrapped = KeyframeEffect;
    static JSKeyframeEffect* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<KeyframeEffect>&& impl)
    {
        JSKeyframeEffect* ptr = new (NotNull, JSC::allocateCell<JSKeyframeEffect>(globalObject->vm())) JSKeyframeEffect(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static KeyframeEffect* toWrapped(JSC::VM&, JSC::JSValue);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info(), JSC::NonArray);
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    template<typename, JSC::SubspaceAccess mode> static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        if constexpr (mode == JSC::SubspaceAccess::Concurrently)
            return nullptr;
        return subspaceForImpl(vm);
    }
    static JSC::GCClient::IsoSubspace* subspaceForImpl(JSC::VM& vm);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);

    // Custom functions
    JSC::JSValue getKeyframes(JSC::JSGlobalObject&, JSC::CallFrame&);
    KeyframeEffect& wrapped() const
    {
        return static_cast<KeyframeEffect&>(Base::wrapped());
    }

    Ref<KeyframeEffect> protectedWrapped() const;

protected:
    JSKeyframeEffect(JSC::Structure*, JSDOMGlobalObject&, Ref<KeyframeEffect>&&);

    DECLARE_DEFAULT_FINISH_CREATION;
};

JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, KeyframeEffect&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, KeyframeEffect* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<KeyframeEffect>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<KeyframeEffect>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

template<> struct JSDOMWrapperConverterTraits<KeyframeEffect> {
    using WrapperClass = JSKeyframeEffect;
    using ToWrappedReturnType = KeyframeEffect*;
};
template<> KeyframeEffect::BasePropertyIndexedKeyframe convertDictionary<KeyframeEffect::BasePropertyIndexedKeyframe>(JSC::JSGlobalObject&, JSC::JSValue);

template<> KeyframeEffect::BaseKeyframe convertDictionary<KeyframeEffect::BaseKeyframe>(JSC::JSGlobalObject&, JSC::JSValue);

template<> KeyframeEffect::BaseComputedKeyframe convertDictionary<KeyframeEffect::BaseComputedKeyframe>(JSC::JSGlobalObject&, JSC::JSValue);

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject&, JSDOMGlobalObject&, const KeyframeEffect::BaseComputedKeyframe&);


} // namespace WebCore
