/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSInspectorAuditAccessibilityObject.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSNode.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> InspectorAuditAccessibilityObject::ComputedProperties convertDictionary<InspectorAuditAccessibilityObject::ComputedProperties>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    InspectorAuditAccessibilityObject::ComputedProperties result;
    JSValue busyValue;
    if (isNullOrUndefined)
        busyValue = jsUndefined();
    else {
        busyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "busy"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!busyValue.isUndefined()) {
        result.busy = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, busyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue checkedValue;
    if (isNullOrUndefined)
        checkedValue = jsUndefined();
    else {
        checkedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "checked"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!checkedValue.isUndefined()) {
        result.checked = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, checkedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue currentStateValue;
    if (isNullOrUndefined)
        currentStateValue = jsUndefined();
    else {
        currentStateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "currentState"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!currentStateValue.isUndefined()) {
        result.currentState = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, currentStateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue disabledValue;
    if (isNullOrUndefined)
        disabledValue = jsUndefined();
    else {
        disabledValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "disabled"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!disabledValue.isUndefined()) {
        result.disabled = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, disabledValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue expandedValue;
    if (isNullOrUndefined)
        expandedValue = jsUndefined();
    else {
        expandedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "expanded"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!expandedValue.isUndefined()) {
        result.expanded = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, expandedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue focusedValue;
    if (isNullOrUndefined)
        focusedValue = jsUndefined();
    else {
        focusedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "focused"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!focusedValue.isUndefined()) {
        result.focused = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, focusedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue headingLevelValue;
    if (isNullOrUndefined)
        headingLevelValue = jsUndefined();
    else {
        headingLevelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "headingLevel"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!headingLevelValue.isUndefined()) {
        result.headingLevel = convert<IDLNullable<IDLLong>>(lexicalGlobalObject, headingLevelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue hiddenValue;
    if (isNullOrUndefined)
        hiddenValue = jsUndefined();
    else {
        hiddenValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "hidden"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!hiddenValue.isUndefined()) {
        result.hidden = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, hiddenValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue hierarchicalLevelValue;
    if (isNullOrUndefined)
        hierarchicalLevelValue = jsUndefined();
    else {
        hierarchicalLevelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "hierarchicalLevel"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!hierarchicalLevelValue.isUndefined()) {
        result.hierarchicalLevel = convert<IDLNullable<IDLLong>>(lexicalGlobalObject, hierarchicalLevelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue ignoredValue;
    if (isNullOrUndefined)
        ignoredValue = jsUndefined();
    else {
        ignoredValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ignored"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!ignoredValue.isUndefined()) {
        result.ignored = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, ignoredValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue ignoredByDefaultValue;
    if (isNullOrUndefined)
        ignoredByDefaultValue = jsUndefined();
    else {
        ignoredByDefaultValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ignoredByDefault"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!ignoredByDefaultValue.isUndefined()) {
        result.ignoredByDefault = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, ignoredByDefaultValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue invalidStatusValue;
    if (isNullOrUndefined)
        invalidStatusValue = jsUndefined();
    else {
        invalidStatusValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "invalidStatus"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!invalidStatusValue.isUndefined()) {
        result.invalidStatus = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, invalidStatusValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue isPopUpButtonValue;
    if (isNullOrUndefined)
        isPopUpButtonValue = jsUndefined();
    else {
        isPopUpButtonValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "isPopUpButton"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!isPopUpButtonValue.isUndefined()) {
        result.isPopUpButton = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, isPopUpButtonValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!labelValue.isUndefined()) {
        result.label = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, labelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue liveRegionAtomicValue;
    if (isNullOrUndefined)
        liveRegionAtomicValue = jsUndefined();
    else {
        liveRegionAtomicValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "liveRegionAtomic"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!liveRegionAtomicValue.isUndefined()) {
        result.liveRegionAtomic = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, liveRegionAtomicValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue liveRegionRelevantValue;
    if (isNullOrUndefined)
        liveRegionRelevantValue = jsUndefined();
    else {
        liveRegionRelevantValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "liveRegionRelevant"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!liveRegionRelevantValue.isUndefined()) {
        result.liveRegionRelevant = convert<IDLNullable<IDLSequence<IDLDOMString>>>(lexicalGlobalObject, liveRegionRelevantValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue liveRegionStatusValue;
    if (isNullOrUndefined)
        liveRegionStatusValue = jsUndefined();
    else {
        liveRegionStatusValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "liveRegionStatus"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!liveRegionStatusValue.isUndefined()) {
        result.liveRegionStatus = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, liveRegionStatusValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue pressedValue;
    if (isNullOrUndefined)
        pressedValue = jsUndefined();
    else {
        pressedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pressed"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!pressedValue.isUndefined()) {
        result.pressed = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, pressedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue readonlyValue;
    if (isNullOrUndefined)
        readonlyValue = jsUndefined();
    else {
        readonlyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "readonly"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!readonlyValue.isUndefined()) {
        result.readonly = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, readonlyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue requiredValue;
    if (isNullOrUndefined)
        requiredValue = jsUndefined();
    else {
        requiredValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "required"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!requiredValue.isUndefined()) {
        result.required = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, requiredValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue roleValue;
    if (isNullOrUndefined)
        roleValue = jsUndefined();
    else {
        roleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "role"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!roleValue.isUndefined()) {
        result.role = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, roleValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue selectedValue;
    if (isNullOrUndefined)
        selectedValue = jsUndefined();
    else {
        selectedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "selected"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!selectedValue.isUndefined()) {
        result.selected = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, selectedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const InspectorAuditAccessibilityObject::ComputedProperties& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.busy)) {
        auto busyValue = toJS<IDLNullable<IDLBoolean>>(lexicalGlobalObject, throwScope, IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.busy));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "busy"_s), busyValue);
    }
    if (!IDLNullable<IDLDOMString>::isNullValue(dictionary.checked)) {
        auto checkedValue = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, IDLNullable<IDLDOMString>::extractValueFromNullable(dictionary.checked));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "checked"_s), checkedValue);
    }
    if (!IDLNullable<IDLDOMString>::isNullValue(dictionary.currentState)) {
        auto currentStateValue = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, IDLNullable<IDLDOMString>::extractValueFromNullable(dictionary.currentState));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "currentState"_s), currentStateValue);
    }
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.disabled)) {
        auto disabledValue = toJS<IDLNullable<IDLBoolean>>(lexicalGlobalObject, throwScope, IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.disabled));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "disabled"_s), disabledValue);
    }
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.expanded)) {
        auto expandedValue = toJS<IDLNullable<IDLBoolean>>(lexicalGlobalObject, throwScope, IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.expanded));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "expanded"_s), expandedValue);
    }
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.focused)) {
        auto focusedValue = toJS<IDLNullable<IDLBoolean>>(lexicalGlobalObject, throwScope, IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.focused));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "focused"_s), focusedValue);
    }
    if (!IDLNullable<IDLLong>::isNullValue(dictionary.headingLevel)) {
        auto headingLevelValue = toJS<IDLNullable<IDLLong>>(lexicalGlobalObject, throwScope, IDLNullable<IDLLong>::extractValueFromNullable(dictionary.headingLevel));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "headingLevel"_s), headingLevelValue);
    }
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.hidden)) {
        auto hiddenValue = toJS<IDLNullable<IDLBoolean>>(lexicalGlobalObject, throwScope, IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.hidden));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "hidden"_s), hiddenValue);
    }
    if (!IDLNullable<IDLLong>::isNullValue(dictionary.hierarchicalLevel)) {
        auto hierarchicalLevelValue = toJS<IDLNullable<IDLLong>>(lexicalGlobalObject, throwScope, IDLNullable<IDLLong>::extractValueFromNullable(dictionary.hierarchicalLevel));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "hierarchicalLevel"_s), hierarchicalLevelValue);
    }
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.ignored)) {
        auto ignoredValue = toJS<IDLNullable<IDLBoolean>>(lexicalGlobalObject, throwScope, IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.ignored));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "ignored"_s), ignoredValue);
    }
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.ignoredByDefault)) {
        auto ignoredByDefaultValue = toJS<IDLNullable<IDLBoolean>>(lexicalGlobalObject, throwScope, IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.ignoredByDefault));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "ignoredByDefault"_s), ignoredByDefaultValue);
    }
    if (!IDLNullable<IDLDOMString>::isNullValue(dictionary.invalidStatus)) {
        auto invalidStatusValue = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, IDLNullable<IDLDOMString>::extractValueFromNullable(dictionary.invalidStatus));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "invalidStatus"_s), invalidStatusValue);
    }
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.isPopUpButton)) {
        auto isPopUpButtonValue = toJS<IDLNullable<IDLBoolean>>(lexicalGlobalObject, throwScope, IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.isPopUpButton));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "isPopUpButton"_s), isPopUpButtonValue);
    }
    if (!IDLNullable<IDLDOMString>::isNullValue(dictionary.label)) {
        auto labelValue = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, IDLNullable<IDLDOMString>::extractValueFromNullable(dictionary.label));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "label"_s), labelValue);
    }
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.liveRegionAtomic)) {
        auto liveRegionAtomicValue = toJS<IDLNullable<IDLBoolean>>(lexicalGlobalObject, throwScope, IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.liveRegionAtomic));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "liveRegionAtomic"_s), liveRegionAtomicValue);
    }
    if (!IDLNullable<IDLSequence<IDLDOMString>>::isNullValue(dictionary.liveRegionRelevant)) {
        auto liveRegionRelevantValue = toJS<IDLNullable<IDLSequence<IDLDOMString>>>(lexicalGlobalObject, globalObject, throwScope, IDLNullable<IDLSequence<IDLDOMString>>::extractValueFromNullable(dictionary.liveRegionRelevant));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "liveRegionRelevant"_s), liveRegionRelevantValue);
    }
    if (!IDLNullable<IDLDOMString>::isNullValue(dictionary.liveRegionStatus)) {
        auto liveRegionStatusValue = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, IDLNullable<IDLDOMString>::extractValueFromNullable(dictionary.liveRegionStatus));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "liveRegionStatus"_s), liveRegionStatusValue);
    }
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.pressed)) {
        auto pressedValue = toJS<IDLNullable<IDLBoolean>>(lexicalGlobalObject, throwScope, IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.pressed));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "pressed"_s), pressedValue);
    }
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.readonly)) {
        auto readonlyValue = toJS<IDLNullable<IDLBoolean>>(lexicalGlobalObject, throwScope, IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.readonly));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "readonly"_s), readonlyValue);
    }
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.required)) {
        auto requiredValue = toJS<IDLNullable<IDLBoolean>>(lexicalGlobalObject, throwScope, IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.required));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "required"_s), requiredValue);
    }
    if (!IDLNullable<IDLDOMString>::isNullValue(dictionary.role)) {
        auto roleValue = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, IDLNullable<IDLDOMString>::extractValueFromNullable(dictionary.role));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "role"_s), roleValue);
    }
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.selected)) {
        auto selectedValue = toJS<IDLNullable<IDLBoolean>>(lexicalGlobalObject, throwScope, IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.selected));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "selected"_s), selectedValue);
    }
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsInspectorAuditAccessibilityObjectPrototypeFunction_getElementsByComputedRole);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorAuditAccessibilityObjectPrototypeFunction_getActiveDescendant);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorAuditAccessibilityObjectPrototypeFunction_getChildNodes);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorAuditAccessibilityObjectPrototypeFunction_getComputedProperties);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorAuditAccessibilityObjectPrototypeFunction_getControlledNodes);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorAuditAccessibilityObjectPrototypeFunction_getFlowedNodes);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorAuditAccessibilityObjectPrototypeFunction_getMouseEventNode);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorAuditAccessibilityObjectPrototypeFunction_getOwnedNodes);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorAuditAccessibilityObjectPrototypeFunction_getParentNode);
static JSC_DECLARE_HOST_FUNCTION(jsInspectorAuditAccessibilityObjectPrototypeFunction_getSelectedChildNodes);

class JSInspectorAuditAccessibilityObjectPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSInspectorAuditAccessibilityObjectPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSInspectorAuditAccessibilityObjectPrototype* ptr = new (NotNull, JSC::allocateCell<JSInspectorAuditAccessibilityObjectPrototype>(vm)) JSInspectorAuditAccessibilityObjectPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSInspectorAuditAccessibilityObjectPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSInspectorAuditAccessibilityObjectPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSInspectorAuditAccessibilityObjectPrototype, JSInspectorAuditAccessibilityObjectPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSInspectorAuditAccessibilityObjectPrototypeTableValues[] =
{
    { "getElementsByComputedRole"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorAuditAccessibilityObjectPrototypeFunction_getElementsByComputedRole, 1 } },
    { "getActiveDescendant"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorAuditAccessibilityObjectPrototypeFunction_getActiveDescendant, 1 } },
    { "getChildNodes"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorAuditAccessibilityObjectPrototypeFunction_getChildNodes, 1 } },
    { "getComputedProperties"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorAuditAccessibilityObjectPrototypeFunction_getComputedProperties, 1 } },
    { "getControlledNodes"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorAuditAccessibilityObjectPrototypeFunction_getControlledNodes, 1 } },
    { "getFlowedNodes"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorAuditAccessibilityObjectPrototypeFunction_getFlowedNodes, 1 } },
    { "getMouseEventNode"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorAuditAccessibilityObjectPrototypeFunction_getMouseEventNode, 1 } },
    { "getOwnedNodes"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorAuditAccessibilityObjectPrototypeFunction_getOwnedNodes, 1 } },
    { "getParentNode"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorAuditAccessibilityObjectPrototypeFunction_getParentNode, 1 } },
    { "getSelectedChildNodes"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsInspectorAuditAccessibilityObjectPrototypeFunction_getSelectedChildNodes, 1 } },
};

const ClassInfo JSInspectorAuditAccessibilityObjectPrototype::s_info = { "InspectorAuditAccessibilityObject"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInspectorAuditAccessibilityObjectPrototype) };

void JSInspectorAuditAccessibilityObjectPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSInspectorAuditAccessibilityObject::info(), JSInspectorAuditAccessibilityObjectPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSInspectorAuditAccessibilityObject::s_info = { "InspectorAuditAccessibilityObject"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInspectorAuditAccessibilityObject) };

JSInspectorAuditAccessibilityObject::JSInspectorAuditAccessibilityObject(Structure* structure, JSDOMGlobalObject& globalObject, Ref<InspectorAuditAccessibilityObject>&& impl)
    : JSDOMWrapper<InspectorAuditAccessibilityObject>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, InspectorAuditAccessibilityObject>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSInspectorAuditAccessibilityObject::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSInspectorAuditAccessibilityObjectPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSInspectorAuditAccessibilityObjectPrototype::create(vm, &globalObject, structure);
}

JSObject* JSInspectorAuditAccessibilityObject::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSInspectorAuditAccessibilityObject>(vm, globalObject);
}

void JSInspectorAuditAccessibilityObject::destroy(JSC::JSCell* cell)
{
    JSInspectorAuditAccessibilityObject* thisObject = static_cast<JSInspectorAuditAccessibilityObject*>(cell);
    thisObject->JSInspectorAuditAccessibilityObject::~JSInspectorAuditAccessibilityObject();
}

static inline JSC::EncodedJSValue jsInspectorAuditAccessibilityObjectPrototypeFunction_getElementsByComputedRoleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditAccessibilityObject>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    auto& document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto role = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto container = convert<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "container", "InspectorAuditAccessibilityObject", "getElementsByComputedRole", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLSequence<IDLInterface<Node>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getElementsByComputedRole(document, WTFMove(role), WTFMove(container)))));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorAuditAccessibilityObjectPrototypeFunction_getElementsByComputedRole, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorAuditAccessibilityObject>::call<jsInspectorAuditAccessibilityObjectPrototypeFunction_getElementsByComputedRoleBody>(*lexicalGlobalObject, *callFrame, "getElementsByComputedRole");
}

static inline JSC::EncodedJSValue jsInspectorAuditAccessibilityObjectPrototypeFunction_getActiveDescendantBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditAccessibilityObject>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "InspectorAuditAccessibilityObject", "getActiveDescendant", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getActiveDescendant(*node))));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorAuditAccessibilityObjectPrototypeFunction_getActiveDescendant, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorAuditAccessibilityObject>::call<jsInspectorAuditAccessibilityObjectPrototypeFunction_getActiveDescendantBody>(*lexicalGlobalObject, *callFrame, "getActiveDescendant");
}

static inline JSC::EncodedJSValue jsInspectorAuditAccessibilityObjectPrototypeFunction_getChildNodesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditAccessibilityObject>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "InspectorAuditAccessibilityObject", "getChildNodes", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLSequence<IDLInterface<Node>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getChildNodes(*node))));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorAuditAccessibilityObjectPrototypeFunction_getChildNodes, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorAuditAccessibilityObject>::call<jsInspectorAuditAccessibilityObjectPrototypeFunction_getChildNodesBody>(*lexicalGlobalObject, *callFrame, "getChildNodes");
}

static inline JSC::EncodedJSValue jsInspectorAuditAccessibilityObjectPrototypeFunction_getComputedPropertiesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditAccessibilityObject>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "InspectorAuditAccessibilityObject", "getComputedProperties", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLDictionary<InspectorAuditAccessibilityObject::ComputedProperties>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getComputedProperties(*node))));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorAuditAccessibilityObjectPrototypeFunction_getComputedProperties, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorAuditAccessibilityObject>::call<jsInspectorAuditAccessibilityObjectPrototypeFunction_getComputedPropertiesBody>(*lexicalGlobalObject, *callFrame, "getComputedProperties");
}

static inline JSC::EncodedJSValue jsInspectorAuditAccessibilityObjectPrototypeFunction_getControlledNodesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditAccessibilityObject>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "InspectorAuditAccessibilityObject", "getControlledNodes", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLSequence<IDLInterface<Node>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getControlledNodes(*node))));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorAuditAccessibilityObjectPrototypeFunction_getControlledNodes, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorAuditAccessibilityObject>::call<jsInspectorAuditAccessibilityObjectPrototypeFunction_getControlledNodesBody>(*lexicalGlobalObject, *callFrame, "getControlledNodes");
}

static inline JSC::EncodedJSValue jsInspectorAuditAccessibilityObjectPrototypeFunction_getFlowedNodesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditAccessibilityObject>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "InspectorAuditAccessibilityObject", "getFlowedNodes", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLSequence<IDLInterface<Node>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getFlowedNodes(*node))));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorAuditAccessibilityObjectPrototypeFunction_getFlowedNodes, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorAuditAccessibilityObject>::call<jsInspectorAuditAccessibilityObjectPrototypeFunction_getFlowedNodesBody>(*lexicalGlobalObject, *callFrame, "getFlowedNodes");
}

static inline JSC::EncodedJSValue jsInspectorAuditAccessibilityObjectPrototypeFunction_getMouseEventNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditAccessibilityObject>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "InspectorAuditAccessibilityObject", "getMouseEventNode", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getMouseEventNode(*node))));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorAuditAccessibilityObjectPrototypeFunction_getMouseEventNode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorAuditAccessibilityObject>::call<jsInspectorAuditAccessibilityObjectPrototypeFunction_getMouseEventNodeBody>(*lexicalGlobalObject, *callFrame, "getMouseEventNode");
}

static inline JSC::EncodedJSValue jsInspectorAuditAccessibilityObjectPrototypeFunction_getOwnedNodesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditAccessibilityObject>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "InspectorAuditAccessibilityObject", "getOwnedNodes", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLSequence<IDLInterface<Node>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getOwnedNodes(*node))));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorAuditAccessibilityObjectPrototypeFunction_getOwnedNodes, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorAuditAccessibilityObject>::call<jsInspectorAuditAccessibilityObjectPrototypeFunction_getOwnedNodesBody>(*lexicalGlobalObject, *callFrame, "getOwnedNodes");
}

static inline JSC::EncodedJSValue jsInspectorAuditAccessibilityObjectPrototypeFunction_getParentNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditAccessibilityObject>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "InspectorAuditAccessibilityObject", "getParentNode", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getParentNode(*node))));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorAuditAccessibilityObjectPrototypeFunction_getParentNode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorAuditAccessibilityObject>::call<jsInspectorAuditAccessibilityObjectPrototypeFunction_getParentNodeBody>(*lexicalGlobalObject, *callFrame, "getParentNode");
}

static inline JSC::EncodedJSValue jsInspectorAuditAccessibilityObjectPrototypeFunction_getSelectedChildNodesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditAccessibilityObject>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "InspectorAuditAccessibilityObject", "getSelectedChildNodes", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLSequence<IDLInterface<Node>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getSelectedChildNodes(*node))));
}

JSC_DEFINE_HOST_FUNCTION(jsInspectorAuditAccessibilityObjectPrototypeFunction_getSelectedChildNodes, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSInspectorAuditAccessibilityObject>::call<jsInspectorAuditAccessibilityObjectPrototypeFunction_getSelectedChildNodesBody>(*lexicalGlobalObject, *callFrame, "getSelectedChildNodes");
}

JSC::GCClient::IsoSubspace* JSInspectorAuditAccessibilityObject::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSInspectorAuditAccessibilityObject, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForInspectorAuditAccessibilityObject.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForInspectorAuditAccessibilityObject = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForInspectorAuditAccessibilityObject.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForInspectorAuditAccessibilityObject = std::forward<decltype(space)>(space); }
    );
}

void JSInspectorAuditAccessibilityObject::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSInspectorAuditAccessibilityObject*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSInspectorAuditAccessibilityObjectOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSInspectorAuditAccessibilityObjectOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsInspectorAuditAccessibilityObject = static_cast<JSInspectorAuditAccessibilityObject*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsInspectorAuditAccessibilityObject->wrapped(), jsInspectorAuditAccessibilityObject);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7InspectorAuditAccessibilityObject@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore33InspectorAuditAccessibilityObjectE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<InspectorAuditAccessibilityObject>&& impl)
{

    if constexpr (std::is_polymorphic_v<InspectorAuditAccessibilityObject>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7InspectorAuditAccessibilityObject@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore33InspectorAuditAccessibilityObjectE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // InspectorAuditAccessibilityObject has subclasses. If InspectorAuditAccessibilityObject has subclasses that get passed
        // to toJS() we currently require InspectorAuditAccessibilityObject you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<InspectorAuditAccessibilityObject>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, InspectorAuditAccessibilityObject& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

InspectorAuditAccessibilityObject* JSInspectorAuditAccessibilityObject::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSInspectorAuditAccessibilityObject*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
