/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSIDBCursorWithValue.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsIDBCursorWithValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBCursorWithValue_value);

class JSIDBCursorWithValuePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSIDBCursorWithValuePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIDBCursorWithValuePrototype* ptr = new (NotNull, JSC::allocateCell<JSIDBCursorWithValuePrototype>(vm)) JSIDBCursorWithValuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIDBCursorWithValuePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIDBCursorWithValuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIDBCursorWithValuePrototype, JSIDBCursorWithValuePrototype::Base);

using JSIDBCursorWithValueDOMConstructor = JSDOMConstructorNotConstructable<JSIDBCursorWithValue>;

template<> const ClassInfo JSIDBCursorWithValueDOMConstructor::s_info = { "IDBCursorWithValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBCursorWithValueDOMConstructor) };

template<> JSValue JSIDBCursorWithValueDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSIDBCursor::getConstructor(vm, &globalObject);
}

template<> void JSIDBCursorWithValueDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "IDBCursorWithValue"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSIDBCursorWithValue::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSIDBCursorWithValuePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBCursorWithValueConstructor, 0 } },
    { "value"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBCursorWithValue_value, 0 } },
};

const ClassInfo JSIDBCursorWithValuePrototype::s_info = { "IDBCursorWithValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBCursorWithValuePrototype) };

void JSIDBCursorWithValuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIDBCursorWithValue::info(), JSIDBCursorWithValuePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSIDBCursorWithValue::s_info = { "IDBCursorWithValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBCursorWithValue) };

JSIDBCursorWithValue::JSIDBCursorWithValue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IDBCursorWithValue>&& impl)
    : JSIDBCursor(structure, globalObject, WTFMove(impl))
{
}

Ref<IDBCursorWithValue> JSIDBCursorWithValue::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, IDBCursorWithValue>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSIDBCursorWithValue::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSIDBCursorWithValuePrototype::createStructure(vm, &globalObject, JSIDBCursor::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSIDBCursorWithValuePrototype::create(vm, &globalObject, structure);
}

JSObject* JSIDBCursorWithValue::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSIDBCursorWithValue>(vm, globalObject);
}

JSValue JSIDBCursorWithValue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBCursorWithValueDOMConstructor, DOMConstructorID::IDBCursorWithValue>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBCursorWithValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIDBCursorWithValuePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSIDBCursorWithValue::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsIDBCursorWithValue_valueGetter(JSGlobalObject& lexicalGlobalObject, JSIDBCursorWithValue& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return thisObject.value(lexicalGlobalObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBCursorWithValue_value, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBCursorWithValue>::get<jsIDBCursorWithValue_valueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSIDBCursorWithValue::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSIDBCursorWithValue, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForIDBCursorWithValue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForIDBCursorWithValue = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForIDBCursorWithValue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForIDBCursorWithValue = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSIDBCursorWithValue::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSIDBCursorWithValue*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSIDBCursorWithValue);

template<typename Visitor>
void JSIDBCursorWithValue::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSIDBCursorWithValue*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSIDBCursorWithValue::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSIDBCursorWithValue::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSIDBCursorWithValue::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSIDBCursorWithValue*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
