/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLBodyElement.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "ElementInlines.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "HTMLNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSErrorHandler.h"
#include "JSEventListener.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElementConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_aLink);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_aLink);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_background);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_background);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_bgColor);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_bgColor);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_link);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_link);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_text);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_text);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_vLink);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_vLink);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onblur);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onblur);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onerror);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onerror);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onfocus);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onfocus);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onload);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onload);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onresize);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onresize);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onscroll);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onscroll);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onfocusin);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onfocusin);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onfocusout);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onfocusout);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onwebkitmouseforcechanged);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onwebkitmouseforcechanged);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onwebkitmouseforcedown);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onwebkitmouseforcedown);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onwebkitmouseforcewillbegin);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onwebkitmouseforcewillbegin);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onwebkitmouseforceup);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onwebkitmouseforceup);
#if ENABLE(ORIENTATION_EVENTS)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onorientationchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onorientationchange);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onafterprint);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onafterprint);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onbeforeprint);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onbeforeprint);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onbeforeunload);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onbeforeunload);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onhashchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onhashchange);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onlanguagechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onlanguagechange);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onmessage);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onmessage);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onmessageerror);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onmessageerror);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onoffline);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onoffline);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_ononline);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_ononline);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onpagehide);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onpagehide);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onpageshow);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onpageshow);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onpopstate);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onpopstate);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onrejectionhandled);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onrejectionhandled);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onstorage);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onstorage);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onunhandledrejection);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onunhandledrejection);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_onunload);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_onunload);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_ongamepadconnected);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_ongamepadconnected);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLBodyElement_ongamepaddisconnected);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLBodyElement_ongamepaddisconnected);

class JSHTMLBodyElementPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLBodyElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLBodyElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLBodyElementPrototype>(vm)) JSHTMLBodyElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLBodyElementPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLBodyElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLBodyElementPrototype, JSHTMLBodyElementPrototype::Base);

using JSHTMLBodyElementDOMConstructor = JSDOMConstructorNotConstructable<JSHTMLBodyElement>;

template<> const ClassInfo JSHTMLBodyElementDOMConstructor::s_info = { "HTMLBodyElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLBodyElementDOMConstructor) };

template<> JSValue JSHTMLBodyElementDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLBodyElementDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "HTMLBodyElement"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSHTMLBodyElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLBodyElementPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElementConstructor, 0 } },
    { "aLink"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_aLink, setJSHTMLBodyElement_aLink } },
    { "background"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_background, setJSHTMLBodyElement_background } },
    { "bgColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_bgColor, setJSHTMLBodyElement_bgColor } },
    { "link"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_link, setJSHTMLBodyElement_link } },
    { "text"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_text, setJSHTMLBodyElement_text } },
    { "vLink"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_vLink, setJSHTMLBodyElement_vLink } },
    { "onblur"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onblur, setJSHTMLBodyElement_onblur } },
    { "onerror"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onerror, setJSHTMLBodyElement_onerror } },
    { "onfocus"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onfocus, setJSHTMLBodyElement_onfocus } },
    { "onload"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onload, setJSHTMLBodyElement_onload } },
    { "onresize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onresize, setJSHTMLBodyElement_onresize } },
    { "onscroll"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onscroll, setJSHTMLBodyElement_onscroll } },
    { "onfocusin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onfocusin, setJSHTMLBodyElement_onfocusin } },
    { "onfocusout"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onfocusout, setJSHTMLBodyElement_onfocusout } },
    { "onwebkitmouseforcechanged"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onwebkitmouseforcechanged, setJSHTMLBodyElement_onwebkitmouseforcechanged } },
    { "onwebkitmouseforcedown"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onwebkitmouseforcedown, setJSHTMLBodyElement_onwebkitmouseforcedown } },
    { "onwebkitmouseforcewillbegin"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onwebkitmouseforcewillbegin, setJSHTMLBodyElement_onwebkitmouseforcewillbegin } },
    { "onwebkitmouseforceup"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onwebkitmouseforceup, setJSHTMLBodyElement_onwebkitmouseforceup } },
#if ENABLE(ORIENTATION_EVENTS)
    { "onorientationchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onorientationchange, setJSHTMLBodyElement_onorientationchange } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "onafterprint"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onafterprint, setJSHTMLBodyElement_onafterprint } },
    { "onbeforeprint"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onbeforeprint, setJSHTMLBodyElement_onbeforeprint } },
    { "onbeforeunload"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onbeforeunload, setJSHTMLBodyElement_onbeforeunload } },
    { "onhashchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onhashchange, setJSHTMLBodyElement_onhashchange } },
    { "onlanguagechange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onlanguagechange, setJSHTMLBodyElement_onlanguagechange } },
    { "onmessage"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onmessage, setJSHTMLBodyElement_onmessage } },
    { "onmessageerror"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onmessageerror, setJSHTMLBodyElement_onmessageerror } },
    { "onoffline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onoffline, setJSHTMLBodyElement_onoffline } },
    { "ononline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_ononline, setJSHTMLBodyElement_ononline } },
    { "onpagehide"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onpagehide, setJSHTMLBodyElement_onpagehide } },
    { "onpageshow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onpageshow, setJSHTMLBodyElement_onpageshow } },
    { "onpopstate"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onpopstate, setJSHTMLBodyElement_onpopstate } },
    { "onrejectionhandled"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onrejectionhandled, setJSHTMLBodyElement_onrejectionhandled } },
    { "onstorage"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onstorage, setJSHTMLBodyElement_onstorage } },
    { "onunhandledrejection"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onunhandledrejection, setJSHTMLBodyElement_onunhandledrejection } },
    { "onunload"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_onunload, setJSHTMLBodyElement_onunload } },
    { "ongamepadconnected"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_ongamepadconnected, setJSHTMLBodyElement_ongamepadconnected } },
    { "ongamepaddisconnected"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLBodyElement_ongamepaddisconnected, setJSHTMLBodyElement_ongamepaddisconnected } },
};

const ClassInfo JSHTMLBodyElementPrototype::s_info = { "HTMLBodyElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLBodyElementPrototype) };

void JSHTMLBodyElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLBodyElement::info(), JSHTMLBodyElementPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSHTMLBodyElement::s_info = { "HTMLBodyElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLBodyElement) };

JSHTMLBodyElement::JSHTMLBodyElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLBodyElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

Ref<HTMLBodyElement> JSHTMLBodyElement::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSHTMLBodyElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSHTMLBodyElementPrototype::createStructure(vm, &globalObject, JSHTMLElement::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSHTMLBodyElementPrototype::create(vm, &globalObject, structure);
}

JSObject* JSHTMLBodyElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLBodyElement>(vm, globalObject);
}

JSValue JSHTMLBodyElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLBodyElementDOMConstructor, DOMConstructorID::HTMLBodyElement>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElementConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLBodyElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLBodyElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsHTMLBodyElement_aLinkGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::alinkAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_aLink, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_aLinkGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_aLinkSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLegacyNullToEmptyAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::alinkAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_aLink, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_aLinkSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_backgroundGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::backgroundAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_background, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_backgroundGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_backgroundSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::backgroundAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_background, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_backgroundSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_bgColorGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::bgcolorAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_bgColor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_bgColorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_bgColorSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLegacyNullToEmptyAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::bgcolorAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_bgColor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_bgColorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_linkGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::linkAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_link, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_linkGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_linkSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLegacyNullToEmptyAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::linkAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_link, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_linkSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_textGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::textAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_text, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_textGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_textSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLegacyNullToEmptyAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::textAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_text, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_textSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_vLinkGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::vlinkAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_vLink, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_vLinkGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_vLinkSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLegacyNullToEmptyAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::vlinkAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_vLink, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_vLinkSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onblurGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().blurEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onblur, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onblurGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onblurSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().blurEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onblur, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onblurSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onerrorGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onerrorSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSErrorHandler>(thisObject.wrapped(), eventNames().errorEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onfocusGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().focusEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onfocus, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onfocusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onfocusSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().focusEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onfocus, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onfocusSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onloadGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().loadEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onloadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onloadSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().loadEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onresizeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().resizeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onresize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onresizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onresizeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().resizeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onresize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onresizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onscrollGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().scrollEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onscroll, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onscrollGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onscrollSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().scrollEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onscroll, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onscrollSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onfocusinGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().focusinEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onfocusin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onfocusinGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onfocusinSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().focusinEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onfocusin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onfocusinSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onfocusoutGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().focusoutEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onfocusout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onfocusoutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onfocusoutSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().focusoutEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onfocusout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onfocusoutSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onwebkitmouseforcechangedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().webkitmouseforcechangedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onwebkitmouseforcechanged, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onwebkitmouseforcechangedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onwebkitmouseforcechangedSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().webkitmouseforcechangedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onwebkitmouseforcechanged, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onwebkitmouseforcechangedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onwebkitmouseforcedownGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().webkitmouseforcedownEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onwebkitmouseforcedown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onwebkitmouseforcedownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onwebkitmouseforcedownSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().webkitmouseforcedownEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onwebkitmouseforcedown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onwebkitmouseforcedownSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onwebkitmouseforcewillbeginGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().webkitmouseforcewillbeginEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onwebkitmouseforcewillbegin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onwebkitmouseforcewillbeginGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onwebkitmouseforcewillbeginSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().webkitmouseforcewillbeginEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onwebkitmouseforcewillbegin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onwebkitmouseforcewillbeginSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onwebkitmouseforceupGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().webkitmouseforceupEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onwebkitmouseforceup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onwebkitmouseforceupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onwebkitmouseforceupSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().webkitmouseforceupEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onwebkitmouseforceup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onwebkitmouseforceupSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#if ENABLE(ORIENTATION_EVENTS)
static inline JSValue jsHTMLBodyElement_onorientationchangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().orientationchangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onorientationchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onorientationchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(ORIENTATION_EVENTS)
static inline bool setJSHTMLBodyElement_onorientationchangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().orientationchangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onorientationchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onorientationchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

static inline JSValue jsHTMLBodyElement_onafterprintGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().afterprintEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onafterprint, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onafterprintGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onafterprintSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().afterprintEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onafterprint, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onafterprintSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onbeforeprintGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().beforeprintEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onbeforeprint, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onbeforeprintGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onbeforeprintSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().beforeprintEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onbeforeprint, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onbeforeprintSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onbeforeunloadGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().beforeunloadEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onbeforeunload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onbeforeunloadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onbeforeunloadSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().beforeunloadEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onbeforeunload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onbeforeunloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onhashchangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().hashchangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onhashchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onhashchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onhashchangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().hashchangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onhashchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onhashchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onlanguagechangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().languagechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onlanguagechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onlanguagechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onlanguagechangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().languagechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onlanguagechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onlanguagechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onmessageGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().messageEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onmessage, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onmessageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onmessageSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().messageEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onmessage, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onmessageSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onmessageerrorGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().messageerrorEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onmessageerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onmessageerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onmessageerrorSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().messageerrorEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onmessageerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onmessageerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onofflineGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().offlineEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onoffline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onofflineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onofflineSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().offlineEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onoffline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onofflineSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_ononlineGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().onlineEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_ononline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_ononlineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_ononlineSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().onlineEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_ononline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_ononlineSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onpagehideGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().pagehideEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onpagehide, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onpagehideGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onpagehideSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().pagehideEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onpagehide, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onpagehideSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onpageshowGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().pageshowEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onpageshow, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onpageshowGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onpageshowSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().pageshowEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onpageshow, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onpageshowSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onpopstateGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().popstateEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onpopstate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onpopstateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onpopstateSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().popstateEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onpopstate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onpopstateSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onrejectionhandledGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().rejectionhandledEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onrejectionhandled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onrejectionhandledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onrejectionhandledSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().rejectionhandledEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onrejectionhandled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onrejectionhandledSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onstorageGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().storageEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onstorage, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onstorageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onstorageSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().storageEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onstorage, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onstorageSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onunhandledrejectionGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().unhandledrejectionEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onunhandledrejection, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onunhandledrejectionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onunhandledrejectionSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().unhandledrejectionEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onunhandledrejection, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onunhandledrejectionSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_onunloadGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().unloadEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_onunload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_onunloadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_onunloadSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().unloadEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_onunload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_onunloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_ongamepadconnectedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().gamepadconnectedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_ongamepadconnected, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_ongamepadconnectedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_ongamepadconnectedSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().gamepadconnectedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_ongamepadconnected, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_ongamepadconnectedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLBodyElement_ongamepaddisconnectedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().gamepaddisconnectedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLBodyElement_ongamepaddisconnected, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElement_ongamepaddisconnectedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLBodyElement_ongamepaddisconnectedSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setWindowEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().gamepaddisconnectedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLBodyElement_ongamepaddisconnected, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElement_ongamepaddisconnectedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSHTMLBodyElement::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSHTMLBodyElement, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForHTMLBodyElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForHTMLBodyElement = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForHTMLBodyElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForHTMLBodyElement = std::forward<decltype(space)>(space); }
    );
}

void JSHTMLBodyElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLBodyElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

void JSHTMLBodyElement::forEachWindowEventHandlerContentAttribute(const Function<void(const AtomString& attributeName, const AtomString& eventName)>& function)
{
    static constexpr std::pair<decltype(HTMLNames::altAttr)&, const AtomString EventNames::*> table[] = {
        { HTMLNames::onblurAttr, &EventNames::blurEvent },
        { HTMLNames::onerrorAttr, &EventNames::errorEvent },
        { HTMLNames::onfocusAttr, &EventNames::focusEvent },
        { HTMLNames::onloadAttr, &EventNames::loadEvent },
        { HTMLNames::onresizeAttr, &EventNames::resizeEvent },
        { HTMLNames::onscrollAttr, &EventNames::scrollEvent },
        { HTMLNames::onfocusinAttr, &EventNames::focusinEvent },
        { HTMLNames::onfocusoutAttr, &EventNames::focusoutEvent },
        { HTMLNames::onwebkitmouseforcechangedAttr, &EventNames::webkitmouseforcechangedEvent },
        { HTMLNames::onwebkitmouseforcedownAttr, &EventNames::webkitmouseforcedownEvent },
        { HTMLNames::onwebkitmouseforcewillbeginAttr, &EventNames::webkitmouseforcewillbeginEvent },
        { HTMLNames::onwebkitmouseforceupAttr, &EventNames::webkitmouseforceupEvent },
        { HTMLNames::onorientationchangeAttr, &EventNames::orientationchangeEvent },
        { HTMLNames::onafterprintAttr, &EventNames::afterprintEvent },
        { HTMLNames::onbeforeprintAttr, &EventNames::beforeprintEvent },
        { HTMLNames::onbeforeunloadAttr, &EventNames::beforeunloadEvent },
        { HTMLNames::onhashchangeAttr, &EventNames::hashchangeEvent },
        { HTMLNames::onlanguagechangeAttr, &EventNames::languagechangeEvent },
        { HTMLNames::onmessageAttr, &EventNames::messageEvent },
        { HTMLNames::onmessageerrorAttr, &EventNames::messageerrorEvent },
        { HTMLNames::onofflineAttr, &EventNames::offlineEvent },
        { HTMLNames::ononlineAttr, &EventNames::onlineEvent },
        { HTMLNames::onpagehideAttr, &EventNames::pagehideEvent },
        { HTMLNames::onpageshowAttr, &EventNames::pageshowEvent },
        { HTMLNames::onpopstateAttr, &EventNames::popstateEvent },
        { HTMLNames::onrejectionhandledAttr, &EventNames::rejectionhandledEvent },
        { HTMLNames::onstorageAttr, &EventNames::storageEvent },
        { HTMLNames::onunhandledrejectionAttr, &EventNames::unhandledrejectionEvent },
        { HTMLNames::onunloadAttr, &EventNames::unloadEvent },
        { HTMLNames::ongamepadconnectedAttr, &EventNames::gamepadconnectedEvent },
        { HTMLNames::ongamepaddisconnectedAttr, &EventNames::gamepaddisconnectedEvent },
    };
    auto& eventNames = WebCore::eventNames();
    for (auto& names : table)
        function(names.first.get().localName(), eventNames.*names.second);
}


}
