/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GEOLOCATION)

#include "JSGeolocationCoordinates.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGeolocationCoordinatesConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGeolocationCoordinates_latitude);
static JSC_DECLARE_CUSTOM_GETTER(jsGeolocationCoordinates_longitude);
static JSC_DECLARE_CUSTOM_GETTER(jsGeolocationCoordinates_altitude);
static JSC_DECLARE_CUSTOM_GETTER(jsGeolocationCoordinates_accuracy);
static JSC_DECLARE_CUSTOM_GETTER(jsGeolocationCoordinates_altitudeAccuracy);
static JSC_DECLARE_CUSTOM_GETTER(jsGeolocationCoordinates_heading);
static JSC_DECLARE_CUSTOM_GETTER(jsGeolocationCoordinates_speed);
static JSC_DECLARE_CUSTOM_GETTER(jsGeolocationCoordinates_floorLevel);

class JSGeolocationCoordinatesPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGeolocationCoordinatesPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGeolocationCoordinatesPrototype* ptr = new (NotNull, JSC::allocateCell<JSGeolocationCoordinatesPrototype>(vm)) JSGeolocationCoordinatesPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGeolocationCoordinatesPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGeolocationCoordinatesPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGeolocationCoordinatesPrototype, JSGeolocationCoordinatesPrototype::Base);

using JSGeolocationCoordinatesDOMConstructor = JSDOMConstructorNotConstructable<JSGeolocationCoordinates>;

template<> const ClassInfo JSGeolocationCoordinatesDOMConstructor::s_info = { "GeolocationCoordinates"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGeolocationCoordinatesDOMConstructor) };

template<> JSValue JSGeolocationCoordinatesDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGeolocationCoordinatesDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GeolocationCoordinates"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGeolocationCoordinates::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSGeolocationCoordinatesPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGeolocationCoordinatesConstructor, 0 } },
    { "latitude"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGeolocationCoordinates_latitude, 0 } },
    { "longitude"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGeolocationCoordinates_longitude, 0 } },
    { "altitude"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGeolocationCoordinates_altitude, 0 } },
    { "accuracy"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGeolocationCoordinates_accuracy, 0 } },
    { "altitudeAccuracy"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGeolocationCoordinates_altitudeAccuracy, 0 } },
    { "heading"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGeolocationCoordinates_heading, 0 } },
    { "speed"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGeolocationCoordinates_speed, 0 } },
    { "floorLevel"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGeolocationCoordinates_floorLevel, 0 } },
};

const ClassInfo JSGeolocationCoordinatesPrototype::s_info = { "GeolocationCoordinates"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGeolocationCoordinatesPrototype) };

void JSGeolocationCoordinatesPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGeolocationCoordinates::info(), JSGeolocationCoordinatesPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().geolocationFloorLevelEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "floorLevel"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGeolocationCoordinates::s_info = { "GeolocationCoordinates"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGeolocationCoordinates) };

JSGeolocationCoordinates::JSGeolocationCoordinates(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GeolocationCoordinates>&& impl)
    : JSDOMWrapper<GeolocationCoordinates>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GeolocationCoordinates>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGeolocationCoordinates::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGeolocationCoordinatesPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGeolocationCoordinatesPrototype::create(vm, &globalObject, structure);
}

JSObject* JSGeolocationCoordinates::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGeolocationCoordinates>(vm, globalObject);
}

JSValue JSGeolocationCoordinates::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGeolocationCoordinatesDOMConstructor, DOMConstructorID::GeolocationCoordinates>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGeolocationCoordinates::destroy(JSC::JSCell* cell)
{
    JSGeolocationCoordinates* thisObject = static_cast<JSGeolocationCoordinates*>(cell);
    thisObject->JSGeolocationCoordinates::~JSGeolocationCoordinates();
}

JSC_DEFINE_CUSTOM_GETTER(jsGeolocationCoordinatesConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGeolocationCoordinatesPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGeolocationCoordinates::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsGeolocationCoordinates_latitudeGetter(JSGlobalObject& lexicalGlobalObject, JSGeolocationCoordinates& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.latitude())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGeolocationCoordinates_latitude, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGeolocationCoordinates>::get<jsGeolocationCoordinates_latitudeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGeolocationCoordinates_longitudeGetter(JSGlobalObject& lexicalGlobalObject, JSGeolocationCoordinates& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.longitude())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGeolocationCoordinates_longitude, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGeolocationCoordinates>::get<jsGeolocationCoordinates_longitudeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGeolocationCoordinates_altitudeGetter(JSGlobalObject& lexicalGlobalObject, JSGeolocationCoordinates& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUnrestrictedDouble>>(lexicalGlobalObject, throwScope, impl.altitude())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGeolocationCoordinates_altitude, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGeolocationCoordinates>::get<jsGeolocationCoordinates_altitudeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGeolocationCoordinates_accuracyGetter(JSGlobalObject& lexicalGlobalObject, JSGeolocationCoordinates& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.accuracy())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGeolocationCoordinates_accuracy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGeolocationCoordinates>::get<jsGeolocationCoordinates_accuracyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGeolocationCoordinates_altitudeAccuracyGetter(JSGlobalObject& lexicalGlobalObject, JSGeolocationCoordinates& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUnrestrictedDouble>>(lexicalGlobalObject, throwScope, impl.altitudeAccuracy())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGeolocationCoordinates_altitudeAccuracy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGeolocationCoordinates>::get<jsGeolocationCoordinates_altitudeAccuracyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGeolocationCoordinates_headingGetter(JSGlobalObject& lexicalGlobalObject, JSGeolocationCoordinates& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUnrestrictedDouble>>(lexicalGlobalObject, throwScope, impl.heading())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGeolocationCoordinates_heading, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGeolocationCoordinates>::get<jsGeolocationCoordinates_headingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGeolocationCoordinates_speedGetter(JSGlobalObject& lexicalGlobalObject, JSGeolocationCoordinates& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUnrestrictedDouble>>(lexicalGlobalObject, throwScope, impl.speed())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGeolocationCoordinates_speed, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGeolocationCoordinates>::get<jsGeolocationCoordinates_speedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGeolocationCoordinates_floorLevelGetter(JSGlobalObject& lexicalGlobalObject, JSGeolocationCoordinates& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUnrestrictedDouble>>(lexicalGlobalObject, throwScope, impl.floorLevel())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGeolocationCoordinates_floorLevel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGeolocationCoordinates>::get<jsGeolocationCoordinates_floorLevelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSGeolocationCoordinates::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGeolocationCoordinates, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGeolocationCoordinates.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGeolocationCoordinates = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGeolocationCoordinates.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGeolocationCoordinates = std::forward<decltype(space)>(space); }
    );
}

void JSGeolocationCoordinates::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGeolocationCoordinates*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSGeolocationCoordinatesOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGeolocationCoordinatesOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGeolocationCoordinates = static_cast<JSGeolocationCoordinates*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsGeolocationCoordinates->wrapped(), jsGeolocationCoordinates);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GeolocationCoordinates@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22GeolocationCoordinatesE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GeolocationCoordinates>&& impl)
{

    if constexpr (std::is_polymorphic_v<GeolocationCoordinates>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GeolocationCoordinates@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore22GeolocationCoordinatesE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GeolocationCoordinates has subclasses. If GeolocationCoordinates has subclasses that get passed
        // to toJS() we currently require GeolocationCoordinates you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<GeolocationCoordinates>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GeolocationCoordinates& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GeolocationCoordinates* JSGeolocationCoordinates::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGeolocationCoordinates*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(GEOLOCATION)
