/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPURenderPassTimestampWrites.h"

#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSGPUQuerySet.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> GPURenderPassTimestampWrites convertDictionary<GPURenderPassTimestampWrites>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPURenderPassTimestampWrites result;
    JSValue beginningOfPassWriteIndexValue;
    if (isNullOrUndefined)
        beginningOfPassWriteIndexValue = jsUndefined();
    else {
        beginningOfPassWriteIndexValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "beginningOfPassWriteIndex"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!beginningOfPassWriteIndexValue.isUndefined()) {
        result.beginningOfPassWriteIndex = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, beginningOfPassWriteIndexValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue endOfPassWriteIndexValue;
    if (isNullOrUndefined)
        endOfPassWriteIndexValue = jsUndefined();
    else {
        endOfPassWriteIndexValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "endOfPassWriteIndex"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!endOfPassWriteIndexValue.isUndefined()) {
        result.endOfPassWriteIndex = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, endOfPassWriteIndexValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue querySetValue;
    if (isNullOrUndefined)
        querySetValue = jsUndefined();
    else {
        querySetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "querySet"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!querySetValue.isUndefined()) {
        result.querySet = convert<IDLInterface<GPUQuerySet>>(lexicalGlobalObject, querySetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "querySet", "GPURenderPassTimestampWrites", "GPUQuerySet");
        return { };
    }
    return result;
}

} // namespace WebCore
