/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUDepthStencilState.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSGPUCompareFunction.h"
#include "JSGPUStencilFaceState.h"
#include "JSGPUTextureFormat.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> GPUDepthStencilState convertDictionary<GPUDepthStencilState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUDepthStencilState result;
    JSValue depthBiasValue;
    if (isNullOrUndefined)
        depthBiasValue = jsUndefined();
    else {
        depthBiasValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthBias"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!depthBiasValue.isUndefined()) {
        result.depthBias = convert<IDLEnforceRangeAdaptor<IDLLong>>(lexicalGlobalObject, depthBiasValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.depthBias = 0;
    JSValue depthBiasClampValue;
    if (isNullOrUndefined)
        depthBiasClampValue = jsUndefined();
    else {
        depthBiasClampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthBiasClamp"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!depthBiasClampValue.isUndefined()) {
        result.depthBiasClamp = convert<IDLFloat>(lexicalGlobalObject, depthBiasClampValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.depthBiasClamp = 0;
    JSValue depthBiasSlopeScaleValue;
    if (isNullOrUndefined)
        depthBiasSlopeScaleValue = jsUndefined();
    else {
        depthBiasSlopeScaleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthBiasSlopeScale"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!depthBiasSlopeScaleValue.isUndefined()) {
        result.depthBiasSlopeScale = convert<IDLFloat>(lexicalGlobalObject, depthBiasSlopeScaleValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.depthBiasSlopeScale = 0;
    JSValue depthCompareValue;
    if (isNullOrUndefined)
        depthCompareValue = jsUndefined();
    else {
        depthCompareValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthCompare"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!depthCompareValue.isUndefined()) {
        result.depthCompare = convert<IDLEnumeration<GPUCompareFunction>>(lexicalGlobalObject, depthCompareValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue depthWriteEnabledValue;
    if (isNullOrUndefined)
        depthWriteEnabledValue = jsUndefined();
    else {
        depthWriteEnabledValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthWriteEnabled"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!depthWriteEnabledValue.isUndefined()) {
        result.depthWriteEnabled = convert<IDLBoolean>(lexicalGlobalObject, depthWriteEnabledValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue formatValue;
    if (isNullOrUndefined)
        formatValue = jsUndefined();
    else {
        formatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "format"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!formatValue.isUndefined()) {
        result.format = convert<IDLEnumeration<GPUTextureFormat>>(lexicalGlobalObject, formatValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "format", "GPUDepthStencilState", "GPUTextureFormat");
        return { };
    }
    JSValue stencilBackValue;
    if (isNullOrUndefined)
        stencilBackValue = jsUndefined();
    else {
        stencilBackValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stencilBack"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!stencilBackValue.isUndefined()) {
        result.stencilBack = convert<IDLDictionary<GPUStencilFaceState>>(lexicalGlobalObject, stencilBackValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue stencilFrontValue;
    if (isNullOrUndefined)
        stencilFrontValue = jsUndefined();
    else {
        stencilFrontValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stencilFront"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!stencilFrontValue.isUndefined()) {
        result.stencilFront = convert<IDLDictionary<GPUStencilFaceState>>(lexicalGlobalObject, stencilFrontValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue stencilReadMaskValue;
    if (isNullOrUndefined)
        stencilReadMaskValue = jsUndefined();
    else {
        stencilReadMaskValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stencilReadMask"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!stencilReadMaskValue.isUndefined()) {
        result.stencilReadMask = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, stencilReadMaskValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.stencilReadMask = 0xFFFFFFFF;
    JSValue stencilWriteMaskValue;
    if (isNullOrUndefined)
        stencilWriteMaskValue = jsUndefined();
    else {
        stencilWriteMaskValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stencilWriteMask"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!stencilWriteMaskValue.isUndefined()) {
        result.stencilWriteMask = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, stencilWriteMaskValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.stencilWriteMask = 0xFFFFFFFF;
    return result;
}

} // namespace WebCore
