/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CODECS)

#include "JSFlacEncoderConfig.h"

#include "JSDOMConvertNumbers.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_CODECS)

template<> FlacEncoderConfig convertDictionary<FlacEncoderConfig>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    FlacEncoderConfig result;
    JSValue blockSizeValue;
    if (isNullOrUndefined)
        blockSizeValue = jsUndefined();
    else {
        blockSizeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "blockSize"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!blockSizeValue.isUndefined()) {
        result.blockSize = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, blockSizeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.blockSize = 0;
    JSValue compressLevelValue;
    if (isNullOrUndefined)
        compressLevelValue = jsUndefined();
    else {
        compressLevelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "compressLevel"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!compressLevelValue.isUndefined()) {
        result.compressLevel = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, compressLevelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.compressLevel = 5;
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const FlacEncoderConfig& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto blockSizeValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, dictionary.blockSize);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "blockSize"_s), blockSizeValue);
    auto compressLevelValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, dictionary.compressLevel);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "compressLevel"_s), compressLevelValue);
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_CODECS)
