/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "FileSystemFileHandle.h"
#include "JSDOMWrapper.h"
#include "JSFileSystemHandle.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class JSFileSystemFileHandle : public JSFileSystemHandle {
public:
    using Base = JSFileSystemHandle;
    using DOMWrapped = FileSystemFileHandle;
    static JSFileSystemFileHandle* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<FileSystemFileHandle>&& impl)
    {
        JSFileSystemFileHandle* ptr = new (NotNull, JSC::allocateCell<JSFileSystemFileHandle>(globalObject->vm())) JSFileSystemFileHandle(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info(), JSC::NonArray);
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    template<typename, JSC::SubspaceAccess mode> static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        if constexpr (mode == JSC::SubspaceAccess::Concurrently)
            return nullptr;
        return subspaceForImpl(vm);
    }
    static JSC::GCClient::IsoSubspace* subspaceForImpl(JSC::VM& vm);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
    FileSystemFileHandle& wrapped() const
    {
        return static_cast<FileSystemFileHandle&>(Base::wrapped());
    }

    Ref<FileSystemFileHandle> protectedWrapped() const;

protected:
    JSFileSystemFileHandle(JSC::Structure*, JSDOMGlobalObject&, Ref<FileSystemFileHandle>&&);

    DECLARE_DEFAULT_FINISH_CREATION;
};

class JSFileSystemFileHandleOwner final : public JSC::WeakHandleOwner {
public:
    bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::AbstractSlotVisitor&, const char**) final;
    void finalize(JSC::Handle<JSC::Unknown>, void* context) final;
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, FileSystemFileHandle*)
{
    static NeverDestroyed<JSFileSystemFileHandleOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(FileSystemFileHandle* wrappableObject)
{
    return wrappableObject;
}


template<> struct JSDOMWrapperConverterTraits<FileSystemFileHandle> {
    using WrapperClass = JSFileSystemFileHandle;
    using ToWrappedReturnType = FileSystemFileHandle*;
};

} // namespace WebCore
