/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSEXTDisjointTimerQueryWebGL2.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSWebGLQuery.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsEXTDisjointTimerQueryWebGL2PrototypeFunction_queryCounterEXT);

class JSEXTDisjointTimerQueryWebGL2Prototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSEXTDisjointTimerQueryWebGL2Prototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEXTDisjointTimerQueryWebGL2Prototype* ptr = new (NotNull, JSC::allocateCell<JSEXTDisjointTimerQueryWebGL2Prototype>(vm)) JSEXTDisjointTimerQueryWebGL2Prototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTDisjointTimerQueryWebGL2Prototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEXTDisjointTimerQueryWebGL2Prototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTDisjointTimerQueryWebGL2Prototype, JSEXTDisjointTimerQueryWebGL2Prototype::Base);

/* Hash table for prototype */

static const HashTableValue JSEXTDisjointTimerQueryWebGL2PrototypeTableValues[] =
{
    { "queryCounterEXT"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsEXTDisjointTimerQueryWebGL2PrototypeFunction_queryCounterEXT, 2 } },
    { "QUERY_COUNTER_BITS_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8864 } },
    { "TIME_ELAPSED_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x88BF } },
    { "TIMESTAMP_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8E28 } },
    { "GPU_DISJOINT_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8FBB } },
};

const ClassInfo JSEXTDisjointTimerQueryWebGL2Prototype::s_info = { "EXTDisjointTimerQueryWebGL2"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTDisjointTimerQueryWebGL2Prototype) };

void JSEXTDisjointTimerQueryWebGL2Prototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSEXTDisjointTimerQueryWebGL2::info(), JSEXTDisjointTimerQueryWebGL2PrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSEXTDisjointTimerQueryWebGL2::s_info = { "EXTDisjointTimerQueryWebGL2"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTDisjointTimerQueryWebGL2) };

JSEXTDisjointTimerQueryWebGL2::JSEXTDisjointTimerQueryWebGL2(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EXTDisjointTimerQueryWebGL2>&& impl)
    : JSDOMWrapper<EXTDisjointTimerQueryWebGL2>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, EXTDisjointTimerQueryWebGL2>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSEXTDisjointTimerQueryWebGL2::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSEXTDisjointTimerQueryWebGL2Prototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSEXTDisjointTimerQueryWebGL2Prototype::create(vm, &globalObject, structure);
}

JSObject* JSEXTDisjointTimerQueryWebGL2::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSEXTDisjointTimerQueryWebGL2>(vm, globalObject);
}

void JSEXTDisjointTimerQueryWebGL2::destroy(JSC::JSCell* cell)
{
    JSEXTDisjointTimerQueryWebGL2* thisObject = static_cast<JSEXTDisjointTimerQueryWebGL2*>(cell);
    thisObject->JSEXTDisjointTimerQueryWebGL2::~JSEXTDisjointTimerQueryWebGL2();
}

static inline JSC::EncodedJSValue jsEXTDisjointTimerQueryWebGL2PrototypeFunction_queryCounterEXTBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSEXTDisjointTimerQueryWebGL2>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto query = convert<IDLInterface<WebGLQuery>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "query", "EXTDisjointTimerQueryWebGL2", "queryCounterEXT", "WebGLQuery"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto target = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.queryCounterEXT(*query, WTFMove(target)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsEXTDisjointTimerQueryWebGL2PrototypeFunction_queryCounterEXT, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSEXTDisjointTimerQueryWebGL2>::call<jsEXTDisjointTimerQueryWebGL2PrototypeFunction_queryCounterEXTBody>(*lexicalGlobalObject, *callFrame, "queryCounterEXT");
}

JSC::GCClient::IsoSubspace* JSEXTDisjointTimerQueryWebGL2::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSEXTDisjointTimerQueryWebGL2, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForEXTDisjointTimerQueryWebGL2.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForEXTDisjointTimerQueryWebGL2 = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForEXTDisjointTimerQueryWebGL2.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForEXTDisjointTimerQueryWebGL2 = std::forward<decltype(space)>(space); }
    );
}

void JSEXTDisjointTimerQueryWebGL2::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSEXTDisjointTimerQueryWebGL2*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSEXTDisjointTimerQueryWebGL2Owner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsEXTDisjointTimerQueryWebGL2 = jsCast<JSEXTDisjointTimerQueryWebGL2*>(handle.slot()->asCell());
    auto& owner = jsEXTDisjointTimerQueryWebGL2->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsEXTDisjointTimerQueryWebGL2";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSEXTDisjointTimerQueryWebGL2Owner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEXTDisjointTimerQueryWebGL2 = static_cast<JSEXTDisjointTimerQueryWebGL2*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsEXTDisjointTimerQueryWebGL2->wrapped(), jsEXTDisjointTimerQueryWebGL2);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EXTDisjointTimerQueryWebGL2@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore27EXTDisjointTimerQueryWebGL2E[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<EXTDisjointTimerQueryWebGL2>&& impl)
{

    if constexpr (std::is_polymorphic_v<EXTDisjointTimerQueryWebGL2>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7EXTDisjointTimerQueryWebGL2@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore27EXTDisjointTimerQueryWebGL2E[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // EXTDisjointTimerQueryWebGL2 has subclasses. If EXTDisjointTimerQueryWebGL2 has subclasses that get passed
        // to toJS() we currently require EXTDisjointTimerQueryWebGL2 you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<EXTDisjointTimerQueryWebGL2>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, EXTDisjointTimerQueryWebGL2& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

EXTDisjointTimerQueryWebGL2* JSEXTDisjointTimerQueryWebGL2::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEXTDisjointTimerQueryWebGL2*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
