/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCanvasRenderingContext2DSettings.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMGlobalObject.h"
#include "JSPredefinedColorSpace.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

template<> CanvasRenderingContext2DSettings convertDictionary<CanvasRenderingContext2DSettings>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    CanvasRenderingContext2DSettings result;
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().canvasColorSpaceEnabled) {
        JSValue colorSpaceValue;
        if (isNullOrUndefined)
            colorSpaceValue = jsUndefined();
        else {
            colorSpaceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "colorSpace"_s));
            RETURN_IF_EXCEPTION(throwScope, { });
        }
        if (!colorSpaceValue.isUndefined()) {
            result.colorSpace = convert<IDLEnumeration<PredefinedColorSpace>>(lexicalGlobalObject, colorSpaceValue);
            RETURN_IF_EXCEPTION(throwScope, { });
        } else
            result.colorSpace = PredefinedColorSpace::SRGB;
    }
    JSValue desynchronizedValue;
    if (isNullOrUndefined)
        desynchronizedValue = jsUndefined();
    else {
        desynchronizedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "desynchronized"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!desynchronizedValue.isUndefined()) {
        result.desynchronized = convert<IDLBoolean>(lexicalGlobalObject, desynchronizedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.desynchronized = false;
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().domTestingAPIsEnabled) {
        JSValue renderingModeForTestingValue;
        if (isNullOrUndefined)
            renderingModeForTestingValue = jsUndefined();
        else {
            renderingModeForTestingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "renderingModeForTesting"_s));
            RETURN_IF_EXCEPTION(throwScope, { });
        }
        if (!renderingModeForTestingValue.isUndefined()) {
            result.renderingModeForTesting = convert<IDLNullable<IDLEnumeration<CanvasRenderingContext2DSettings::RenderingMode>>>(lexicalGlobalObject, renderingModeForTestingValue);
            RETURN_IF_EXCEPTION(throwScope, { });
        }
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const CanvasRenderingContext2DSettings& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext()->settingsValues().canvasColorSpaceEnabled) {
        auto colorSpaceValue = toJS<IDLEnumeration<PredefinedColorSpace>>(lexicalGlobalObject, throwScope, dictionary.colorSpace);
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "colorSpace"_s), colorSpaceValue);
    }
    auto desynchronizedValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.desynchronized);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "desynchronized"_s), desynchronizedValue);
    if (jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext()->settingsValues().domTestingAPIsEnabled) {
        if (!IDLNullable<IDLEnumeration<CanvasRenderingContext2DSettings::RenderingMode>>::isNullValue(dictionary.renderingModeForTesting)) {
            auto renderingModeForTestingValue = toJS<IDLNullable<IDLEnumeration<CanvasRenderingContext2DSettings::RenderingMode>>>(lexicalGlobalObject, throwScope, IDLNullable<IDLEnumeration<CanvasRenderingContext2DSettings::RenderingMode>>::extractValueFromNullable(dictionary.renderingModeForTesting));
            RETURN_IF_EXCEPTION(throwScope, { });
            result->putDirect(vm, JSC::Identifier::fromString(vm, "renderingModeForTesting"_s), renderingModeForTestingValue);
        }
    }
    return result;
}

String convertEnumerationToString(CanvasRenderingContext2DSettings::RenderingMode enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("Unaccelerated"),
        MAKE_STATIC_STRING_IMPL("Accelerated"),
    };
    static_assert(static_cast<size_t>(CanvasRenderingContext2DSettings::RenderingMode::Unaccelerated) == 0, "CanvasRenderingContext2DSettings::RenderingMode::Unaccelerated is not 0 as expected");
    static_assert(static_cast<size_t>(CanvasRenderingContext2DSettings::RenderingMode::Accelerated) == 1, "CanvasRenderingContext2DSettings::RenderingMode::Accelerated is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, CanvasRenderingContext2DSettings::RenderingMode enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<CanvasRenderingContext2DSettings::RenderingMode> parseEnumerationFromString<CanvasRenderingContext2DSettings::RenderingMode>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, CanvasRenderingContext2DSettings::RenderingMode> mappings[] = {
        { "Accelerated", CanvasRenderingContext2DSettings::RenderingMode::Accelerated },
        { "Unaccelerated", CanvasRenderingContext2DSettings::RenderingMode::Unaccelerated },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<CanvasRenderingContext2DSettings::RenderingMode> parseEnumeration<CanvasRenderingContext2DSettings::RenderingMode>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<CanvasRenderingContext2DSettings::RenderingMode>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<CanvasRenderingContext2DSettings::RenderingMode>()
{
    return "\"Unaccelerated\", \"Accelerated\"";
}

} // namespace WebCore
