/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSCanvasCaptureMediaStreamTrack.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSHTMLCanvasElement.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsCanvasCaptureMediaStreamTrackPrototypeFunction_requestFrame);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCanvasCaptureMediaStreamTrackConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCanvasCaptureMediaStreamTrack_canvas);

class JSCanvasCaptureMediaStreamTrackPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCanvasCaptureMediaStreamTrackPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCanvasCaptureMediaStreamTrackPrototype* ptr = new (NotNull, JSC::allocateCell<JSCanvasCaptureMediaStreamTrackPrototype>(vm)) JSCanvasCaptureMediaStreamTrackPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCanvasCaptureMediaStreamTrackPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCanvasCaptureMediaStreamTrackPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCanvasCaptureMediaStreamTrackPrototype, JSCanvasCaptureMediaStreamTrackPrototype::Base);

using JSCanvasCaptureMediaStreamTrackDOMConstructor = JSDOMConstructorNotConstructable<JSCanvasCaptureMediaStreamTrack>;

template<> const ClassInfo JSCanvasCaptureMediaStreamTrackDOMConstructor::s_info = { "CanvasCaptureMediaStreamTrack"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCanvasCaptureMediaStreamTrackDOMConstructor) };

template<> JSValue JSCanvasCaptureMediaStreamTrackDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSMediaStreamTrack::getConstructor(vm, &globalObject);
}

template<> void JSCanvasCaptureMediaStreamTrackDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CanvasCaptureMediaStreamTrack"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCanvasCaptureMediaStreamTrack::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSCanvasCaptureMediaStreamTrackPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCanvasCaptureMediaStreamTrackConstructor, 0 } },
    { "canvas"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCanvasCaptureMediaStreamTrack_canvas, 0 } },
    { "requestFrame"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCanvasCaptureMediaStreamTrackPrototypeFunction_requestFrame, 0 } },
};

const ClassInfo JSCanvasCaptureMediaStreamTrackPrototype::s_info = { "CanvasCaptureMediaStreamTrack"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCanvasCaptureMediaStreamTrackPrototype) };

void JSCanvasCaptureMediaStreamTrackPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCanvasCaptureMediaStreamTrack::info(), JSCanvasCaptureMediaStreamTrackPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCanvasCaptureMediaStreamTrack::s_info = { "CanvasCaptureMediaStreamTrack"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCanvasCaptureMediaStreamTrack) };

JSCanvasCaptureMediaStreamTrack::JSCanvasCaptureMediaStreamTrack(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CanvasCaptureMediaStreamTrack>&& impl)
    : JSMediaStreamTrack(structure, globalObject, WTFMove(impl))
{
}

Ref<CanvasCaptureMediaStreamTrack> JSCanvasCaptureMediaStreamTrack::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, CanvasCaptureMediaStreamTrack>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSCanvasCaptureMediaStreamTrack::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCanvasCaptureMediaStreamTrackPrototype::createStructure(vm, &globalObject, JSMediaStreamTrack::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCanvasCaptureMediaStreamTrackPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCanvasCaptureMediaStreamTrack::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCanvasCaptureMediaStreamTrack>(vm, globalObject);
}

JSValue JSCanvasCaptureMediaStreamTrack::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCanvasCaptureMediaStreamTrackDOMConstructor, DOMConstructorID::CanvasCaptureMediaStreamTrack>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCanvasCaptureMediaStreamTrackConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCanvasCaptureMediaStreamTrackPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCanvasCaptureMediaStreamTrack::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsCanvasCaptureMediaStreamTrack_canvasGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasCaptureMediaStreamTrack& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<HTMLCanvasElement>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.canvas())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCanvasCaptureMediaStreamTrack_canvas, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCanvasCaptureMediaStreamTrack>::get<jsCanvasCaptureMediaStreamTrack_canvasGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsCanvasCaptureMediaStreamTrackPrototypeFunction_requestFrameBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasCaptureMediaStreamTrack>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.requestFrame(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCanvasCaptureMediaStreamTrackPrototypeFunction_requestFrame, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCanvasCaptureMediaStreamTrack>::call<jsCanvasCaptureMediaStreamTrackPrototypeFunction_requestFrameBody>(*lexicalGlobalObject, *callFrame, "requestFrame");
}

JSC::GCClient::IsoSubspace* JSCanvasCaptureMediaStreamTrack::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCanvasCaptureMediaStreamTrack, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCanvasCaptureMediaStreamTrack.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCanvasCaptureMediaStreamTrack = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCanvasCaptureMediaStreamTrack.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCanvasCaptureMediaStreamTrack = std::forward<decltype(space)>(space); }
    );
}

void JSCanvasCaptureMediaStreamTrack::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCanvasCaptureMediaStreamTrack*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSCanvasCaptureMediaStreamTrackOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsCanvasCaptureMediaStreamTrack = jsCast<JSCanvasCaptureMediaStreamTrack*>(handle.slot()->asCell());
    auto& wrapped = jsCanvasCaptureMediaStreamTrack->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSCanvasCaptureMediaStreamTrackOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCanvasCaptureMediaStreamTrack = static_cast<JSCanvasCaptureMediaStreamTrack*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsCanvasCaptureMediaStreamTrack->wrapped(), jsCanvasCaptureMediaStreamTrack);
}


}

#endif // ENABLE(MEDIA_STREAM)
