/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSRGB.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSCSSKeywordValue.h"
#include "JSCSSNumericValue.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSRGBConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSRGB_r);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSRGB_r);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSRGB_g);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSRGB_g);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSRGB_b);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSRGB_b);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSRGB_alpha);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSRGB_alpha);

class JSCSSRGBPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSRGBPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSRGBPrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSRGBPrototype>(vm)) JSCSSRGBPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSRGBPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSRGBPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSRGBPrototype, JSCSSRGBPrototype::Base);

using JSCSSRGBDOMConstructor = JSDOMConstructor<JSCSSRGB>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSCSSRGBDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSCSSRGBDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto r = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto g = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto b = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto alpha = argument3.value().isUndefined() ? 1.0 : convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = CSSRGB::create(WTFMove(r), WTFMove(g), WTFMove(b), WTFMove(alpha));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<CSSRGB>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<CSSRGB>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSCSSRGBDOMConstructorConstruct, JSCSSRGBDOMConstructor::construct);

template<> const ClassInfo JSCSSRGBDOMConstructor::s_info = { "CSSRGB"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSRGBDOMConstructor) };

template<> JSValue JSCSSRGBDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSColorValue::getConstructor(vm, &globalObject);
}

template<> void JSCSSRGBDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(3), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSRGB"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSRGB::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSCSSRGBPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSRGBConstructor, 0 } },
    { "r"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSRGB_r, setJSCSSRGB_r } },
    { "g"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSRGB_g, setJSCSSRGB_g } },
    { "b"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSRGB_b, setJSCSSRGB_b } },
    { "alpha"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSRGB_alpha, setJSCSSRGB_alpha } },
};

const ClassInfo JSCSSRGBPrototype::s_info = { "CSSRGB"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSRGBPrototype) };

void JSCSSRGBPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSRGB::info(), JSCSSRGBPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSRGB::s_info = { "CSSRGB"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSRGB) };

JSCSSRGB::JSCSSRGB(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSRGB>&& impl)
    : JSCSSColorValue(structure, globalObject, WTFMove(impl))
{
}

Ref<CSSRGB> JSCSSRGB::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSRGB>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSRGB::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSRGBPrototype::createStructure(vm, &globalObject, JSCSSColorValue::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCSSRGBPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSRGB::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSRGB>(vm, globalObject);
}

JSValue JSCSSRGB::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSRGBDOMConstructor, DOMConstructorID::CSSRGB>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSRGBConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSRGBPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSRGB::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsCSSRGB_rGetter(JSGlobalObject& lexicalGlobalObject, JSCSSRGB& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.r())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSRGB_r, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSRGB>::get<jsCSSRGB_rGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSRGB_rSetter(JSGlobalObject& lexicalGlobalObject, JSCSSRGB& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setR(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSRGB_r, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSRGB>::set<setJSCSSRGB_rSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSRGB_gGetter(JSGlobalObject& lexicalGlobalObject, JSCSSRGB& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.g())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSRGB_g, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSRGB>::get<jsCSSRGB_gGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSRGB_gSetter(JSGlobalObject& lexicalGlobalObject, JSCSSRGB& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setG(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSRGB_g, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSRGB>::set<setJSCSSRGB_gSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSRGB_bGetter(JSGlobalObject& lexicalGlobalObject, JSCSSRGB& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.b())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSRGB_b, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSRGB>::get<jsCSSRGB_bGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSRGB_bSetter(JSGlobalObject& lexicalGlobalObject, JSCSSRGB& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setB(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSRGB_b, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSRGB>::set<setJSCSSRGB_bSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSRGB_alphaGetter(JSGlobalObject& lexicalGlobalObject, JSCSSRGB& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.alpha())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSRGB_alpha, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSRGB>::get<jsCSSRGB_alphaGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSRGB_alphaSetter(JSGlobalObject& lexicalGlobalObject, JSCSSRGB& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAlpha(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSRGB_alpha, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSRGB>::set<setJSCSSRGB_alphaSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSCSSRGB::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSRGB, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSRGB.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSRGB = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSRGB.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSRGB = std::forward<decltype(space)>(space); }
    );
}

void JSCSSRGB::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSRGB*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CSSRGB@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore6CSSRGBE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CSSRGB>&& impl)
{

    if constexpr (std::is_polymorphic_v<CSSRGB>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CSSRGB@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore6CSSRGBE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CSSRGB has subclasses. If CSSRGB has subclasses that get passed
        // to toJS() we currently require CSSRGB you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<CSSRGB>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CSSRGB& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CSSRGB* JSCSSRGB::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCSSRGB*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
