/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCDATASection.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCDATASectionConstructor);

class JSCDATASectionPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCDATASectionPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCDATASectionPrototype* ptr = new (NotNull, JSC::allocateCell<JSCDATASectionPrototype>(vm)) JSCDATASectionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCDATASectionPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCDATASectionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCDATASectionPrototype, JSCDATASectionPrototype::Base);

using JSCDATASectionDOMConstructor = JSDOMConstructorNotConstructable<JSCDATASection>;

template<> const ClassInfo JSCDATASectionDOMConstructor::s_info = { "CDATASection"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCDATASectionDOMConstructor) };

template<> JSValue JSCDATASectionDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSText::getConstructor(vm, &globalObject);
}

template<> void JSCDATASectionDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CDATASection"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCDATASection::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSCDATASectionPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCDATASectionConstructor, 0 } },
};

const ClassInfo JSCDATASectionPrototype::s_info = { "CDATASection"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCDATASectionPrototype) };

void JSCDATASectionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCDATASection::info(), JSCDATASectionPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCDATASection::s_info = { "CDATASection"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCDATASection) };

JSCDATASection::JSCDATASection(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CDATASection>&& impl)
    : JSText(structure, globalObject, WTFMove(impl))
{
}

Ref<CDATASection> JSCDATASection::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSCDATASection::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCDATASectionPrototype::createStructure(vm, &globalObject, JSText::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCDATASectionPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCDATASection::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCDATASection>(vm, globalObject);
}

JSValue JSCDATASection::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCDATASectionDOMConstructor, DOMConstructorID::CDATASection>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCDATASectionConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCDATASectionPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCDATASection::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

JSC::GCClient::IsoSubspace* JSCDATASection::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCDATASection, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCDATASection.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCDATASection = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCDATASection.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCDATASection = std::forward<decltype(space)>(space); }
    );
}

void JSCDATASection::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCDATASection*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CDATASection@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12CDATASectionE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CDATASection>&& impl)
{

    if constexpr (std::is_polymorphic_v<CDATASection>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CDATASection@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12CDATASectionE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CDATASection has subclasses. If CDATASection has subclasses that get passed
        // to toJS() we currently require CDATASection you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<CDATASection>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CDATASection& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
