/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CODECS)

#include "JSBitrateMode.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(BitrateMode enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("constant"),
        MAKE_STATIC_STRING_IMPL("variable"),
    };
    static_assert(static_cast<size_t>(BitrateMode::Constant) == 0, "BitrateMode::Constant is not 0 as expected");
    static_assert(static_cast<size_t>(BitrateMode::Variable) == 1, "BitrateMode::Variable is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, BitrateMode enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<BitrateMode> parseEnumerationFromString<BitrateMode>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, BitrateMode> mappings[] = {
        { "constant", BitrateMode::Constant },
        { "variable", BitrateMode::Variable },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<BitrateMode> parseEnumeration<BitrateMode>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<BitrateMode>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<BitrateMode>()
{
    return "\"constant\", \"variable\"";
}

} // namespace WebCore

#endif // ENABLE(WEB_CODECS)
