/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSBackgroundFetchUpdateUIEvent.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSBackgroundFetchEventInit.h"
#include "JSBackgroundFetchUIOptions.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsBackgroundFetchUpdateUIEventPrototypeFunction_updateUI);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsBackgroundFetchUpdateUIEventConstructor);

class JSBackgroundFetchUpdateUIEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSBackgroundFetchUpdateUIEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSBackgroundFetchUpdateUIEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSBackgroundFetchUpdateUIEventPrototype>(vm)) JSBackgroundFetchUpdateUIEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSBackgroundFetchUpdateUIEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSBackgroundFetchUpdateUIEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSBackgroundFetchUpdateUIEventPrototype, JSBackgroundFetchUpdateUIEventPrototype::Base);

using JSBackgroundFetchUpdateUIEventDOMConstructor = JSDOMConstructor<JSBackgroundFetchUpdateUIEvent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSBackgroundFetchUpdateUIEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSBackgroundFetchUpdateUIEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto type = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto init = convert<IDLDictionary<BackgroundFetchEventInit>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = BackgroundFetchUpdateUIEvent::create(WTFMove(type), WTFMove(init));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<BackgroundFetchUpdateUIEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<BackgroundFetchUpdateUIEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSBackgroundFetchUpdateUIEventDOMConstructorConstruct, JSBackgroundFetchUpdateUIEventDOMConstructor::construct);

template<> const ClassInfo JSBackgroundFetchUpdateUIEventDOMConstructor::s_info = { "BackgroundFetchUpdateUIEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBackgroundFetchUpdateUIEventDOMConstructor) };

template<> JSValue JSBackgroundFetchUpdateUIEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSBackgroundFetchEvent::getConstructor(vm, &globalObject);
}

template<> void JSBackgroundFetchUpdateUIEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(2), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "BackgroundFetchUpdateUIEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSBackgroundFetchUpdateUIEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSBackgroundFetchUpdateUIEventPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsBackgroundFetchUpdateUIEventConstructor, 0 } },
    { "updateUI"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsBackgroundFetchUpdateUIEventPrototypeFunction_updateUI, 0 } },
};

const ClassInfo JSBackgroundFetchUpdateUIEventPrototype::s_info = { "BackgroundFetchUpdateUIEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBackgroundFetchUpdateUIEventPrototype) };

void JSBackgroundFetchUpdateUIEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSBackgroundFetchUpdateUIEvent::info(), JSBackgroundFetchUpdateUIEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSBackgroundFetchUpdateUIEvent::s_info = { "BackgroundFetchUpdateUIEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBackgroundFetchUpdateUIEvent) };

JSBackgroundFetchUpdateUIEvent::JSBackgroundFetchUpdateUIEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<BackgroundFetchUpdateUIEvent>&& impl)
    : JSBackgroundFetchEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<BackgroundFetchUpdateUIEvent> JSBackgroundFetchUpdateUIEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, BackgroundFetchUpdateUIEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSBackgroundFetchUpdateUIEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSBackgroundFetchUpdateUIEventPrototype::createStructure(vm, &globalObject, JSBackgroundFetchEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSBackgroundFetchUpdateUIEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSBackgroundFetchUpdateUIEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSBackgroundFetchUpdateUIEvent>(vm, globalObject);
}

JSValue JSBackgroundFetchUpdateUIEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSBackgroundFetchUpdateUIEventDOMConstructor, DOMConstructorID::BackgroundFetchUpdateUIEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsBackgroundFetchUpdateUIEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSBackgroundFetchUpdateUIEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSBackgroundFetchUpdateUIEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsBackgroundFetchUpdateUIEventPrototypeFunction_updateUIBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSBackgroundFetchUpdateUIEvent>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto options = convert<IDLDictionary<BackgroundFetchUIOptions>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.updateUI(WTFMove(options), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsBackgroundFetchUpdateUIEventPrototypeFunction_updateUI, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSBackgroundFetchUpdateUIEvent>::call<jsBackgroundFetchUpdateUIEventPrototypeFunction_updateUIBody>(*lexicalGlobalObject, *callFrame, "updateUI");
}

JSC::GCClient::IsoSubspace* JSBackgroundFetchUpdateUIEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSBackgroundFetchUpdateUIEvent, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForBackgroundFetchUpdateUIEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForBackgroundFetchUpdateUIEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForBackgroundFetchUpdateUIEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForBackgroundFetchUpdateUIEvent = std::forward<decltype(space)>(space); }
    );
}

void JSBackgroundFetchUpdateUIEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSBackgroundFetchUpdateUIEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7BackgroundFetchUpdateUIEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore28BackgroundFetchUpdateUIEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<BackgroundFetchUpdateUIEvent>&& impl)
{

    if constexpr (std::is_polymorphic_v<BackgroundFetchUpdateUIEvent>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7BackgroundFetchUpdateUIEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore28BackgroundFetchUpdateUIEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // BackgroundFetchUpdateUIEvent has subclasses. If BackgroundFetchUpdateUIEvent has subclasses that get passed
        // to toJS() we currently require BackgroundFetchUpdateUIEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<BackgroundFetchUpdateUIEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, BackgroundFetchUpdateUIEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
