/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSBackgroundFetchRecord.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSFetchRequest.h"
#include "JSFetchResponse.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsBackgroundFetchRecordConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsBackgroundFetchRecord_request);
static JSC_DECLARE_CUSTOM_GETTER(jsBackgroundFetchRecord_responseReady);

class JSBackgroundFetchRecordPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSBackgroundFetchRecordPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSBackgroundFetchRecordPrototype* ptr = new (NotNull, JSC::allocateCell<JSBackgroundFetchRecordPrototype>(vm)) JSBackgroundFetchRecordPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSBackgroundFetchRecordPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSBackgroundFetchRecordPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSBackgroundFetchRecordPrototype, JSBackgroundFetchRecordPrototype::Base);

using JSBackgroundFetchRecordDOMConstructor = JSDOMConstructorNotConstructable<JSBackgroundFetchRecord>;

template<> const ClassInfo JSBackgroundFetchRecordDOMConstructor::s_info = { "BackgroundFetchRecord"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBackgroundFetchRecordDOMConstructor) };

template<> JSValue JSBackgroundFetchRecordDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSBackgroundFetchRecordDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "BackgroundFetchRecord"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSBackgroundFetchRecord::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSBackgroundFetchRecordPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsBackgroundFetchRecordConstructor, 0 } },
    { "request"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBackgroundFetchRecord_request, 0 } },
    { "responseReady"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsBackgroundFetchRecord_responseReady, 0 } },
};

const ClassInfo JSBackgroundFetchRecordPrototype::s_info = { "BackgroundFetchRecord"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBackgroundFetchRecordPrototype) };

void JSBackgroundFetchRecordPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSBackgroundFetchRecord::info(), JSBackgroundFetchRecordPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSBackgroundFetchRecord::s_info = { "BackgroundFetchRecord"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBackgroundFetchRecord) };

JSBackgroundFetchRecord::JSBackgroundFetchRecord(Structure* structure, JSDOMGlobalObject& globalObject, Ref<BackgroundFetchRecord>&& impl)
    : JSDOMWrapper<BackgroundFetchRecord>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, BackgroundFetchRecord>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSBackgroundFetchRecord::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSBackgroundFetchRecordPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSBackgroundFetchRecordPrototype::create(vm, &globalObject, structure);
}

JSObject* JSBackgroundFetchRecord::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSBackgroundFetchRecord>(vm, globalObject);
}

JSValue JSBackgroundFetchRecord::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSBackgroundFetchRecordDOMConstructor, DOMConstructorID::BackgroundFetchRecord>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSBackgroundFetchRecord::destroy(JSC::JSCell* cell)
{
    JSBackgroundFetchRecord* thisObject = static_cast<JSBackgroundFetchRecord*>(cell);
    thisObject->JSBackgroundFetchRecord::~JSBackgroundFetchRecord();
}

JSC_DEFINE_CUSTOM_GETTER(jsBackgroundFetchRecordConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSBackgroundFetchRecordPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSBackgroundFetchRecord::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsBackgroundFetchRecord_requestGetter(JSGlobalObject& lexicalGlobalObject, JSBackgroundFetchRecord& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<FetchRequest>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.request())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBackgroundFetchRecord_request, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBackgroundFetchRecord>::get<jsBackgroundFetchRecord_requestGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsBackgroundFetchRecord_responseReadyGetter(JSGlobalObject& lexicalGlobalObject, JSBackgroundFetchRecord& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLPromise<IDLInterface<FetchResponse>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, [&]() -> decltype(auto) { return impl.responseReady(); })));
}

JSC_DEFINE_CUSTOM_GETTER(jsBackgroundFetchRecord_responseReady, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBackgroundFetchRecord>::get<jsBackgroundFetchRecord_responseReadyGetter, CastedThisErrorBehavior::RejectPromise>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSBackgroundFetchRecord::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSBackgroundFetchRecord, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForBackgroundFetchRecord.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForBackgroundFetchRecord = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForBackgroundFetchRecord.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForBackgroundFetchRecord = std::forward<decltype(space)>(space); }
    );
}

void JSBackgroundFetchRecord::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSBackgroundFetchRecord*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSBackgroundFetchRecordOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSBackgroundFetchRecordOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsBackgroundFetchRecord = static_cast<JSBackgroundFetchRecord*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsBackgroundFetchRecord->wrapped(), jsBackgroundFetchRecord);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7BackgroundFetchRecord@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21BackgroundFetchRecordE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<BackgroundFetchRecord>&& impl)
{

    if constexpr (std::is_polymorphic_v<BackgroundFetchRecord>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7BackgroundFetchRecord@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore21BackgroundFetchRecordE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // BackgroundFetchRecord has subclasses. If BackgroundFetchRecord has subclasses that get passed
        // to toJS() we currently require BackgroundFetchRecord you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<BackgroundFetchRecord>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, BackgroundFetchRecord& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

BackgroundFetchRecord* JSBackgroundFetchRecord::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSBackgroundFetchRecord*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
