/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSBackgroundFetchEvent.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSBackgroundFetchEventInit.h"
#include "JSBackgroundFetchRegistration.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsBackgroundFetchEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsBackgroundFetchEvent_registration);

class JSBackgroundFetchEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSBackgroundFetchEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSBackgroundFetchEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSBackgroundFetchEventPrototype>(vm)) JSBackgroundFetchEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSBackgroundFetchEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSBackgroundFetchEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSBackgroundFetchEventPrototype, JSBackgroundFetchEventPrototype::Base);

using JSBackgroundFetchEventDOMConstructor = JSDOMConstructor<JSBackgroundFetchEvent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSBackgroundFetchEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSBackgroundFetchEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto type = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto init = convert<IDLDictionary<BackgroundFetchEventInit>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = BackgroundFetchEvent::create(WTFMove(type), WTFMove(init));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<BackgroundFetchEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<BackgroundFetchEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSBackgroundFetchEventDOMConstructorConstruct, JSBackgroundFetchEventDOMConstructor::construct);

template<> const ClassInfo JSBackgroundFetchEventDOMConstructor::s_info = { "BackgroundFetchEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBackgroundFetchEventDOMConstructor) };

template<> JSValue JSBackgroundFetchEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSExtendableEvent::getConstructor(vm, &globalObject);
}

template<> void JSBackgroundFetchEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(2), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "BackgroundFetchEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSBackgroundFetchEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSBackgroundFetchEventPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsBackgroundFetchEventConstructor, 0 } },
    { "registration"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsBackgroundFetchEvent_registration, 0 } },
};

const ClassInfo JSBackgroundFetchEventPrototype::s_info = { "BackgroundFetchEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBackgroundFetchEventPrototype) };

void JSBackgroundFetchEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSBackgroundFetchEvent::info(), JSBackgroundFetchEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSBackgroundFetchEvent::s_info = { "BackgroundFetchEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBackgroundFetchEvent) };

JSBackgroundFetchEvent::JSBackgroundFetchEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<BackgroundFetchEvent>&& impl)
    : JSExtendableEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<BackgroundFetchEvent> JSBackgroundFetchEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, BackgroundFetchEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSBackgroundFetchEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSBackgroundFetchEventPrototype::createStructure(vm, &globalObject, JSExtendableEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSBackgroundFetchEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSBackgroundFetchEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSBackgroundFetchEvent>(vm, globalObject);
}

JSValue JSBackgroundFetchEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSBackgroundFetchEventDOMConstructor, DOMConstructorID::BackgroundFetchEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsBackgroundFetchEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSBackgroundFetchEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSBackgroundFetchEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsBackgroundFetchEvent_registrationGetter(JSGlobalObject& lexicalGlobalObject, JSBackgroundFetchEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<BackgroundFetchRegistration>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.registration())));
}

JSC_DEFINE_CUSTOM_GETTER(jsBackgroundFetchEvent_registration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSBackgroundFetchEvent>::get<jsBackgroundFetchEvent_registrationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSBackgroundFetchEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSBackgroundFetchEvent, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForBackgroundFetchEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForBackgroundFetchEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForBackgroundFetchEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForBackgroundFetchEvent = std::forward<decltype(space)>(space); }
    );
}

void JSBackgroundFetchEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSBackgroundFetchEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7BackgroundFetchEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore20BackgroundFetchEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<BackgroundFetchEvent>&& impl)
{

    if constexpr (std::is_polymorphic_v<BackgroundFetchEvent>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7BackgroundFetchEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore20BackgroundFetchEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // BackgroundFetchEvent has subclasses. If BackgroundFetchEvent has subclasses that get passed
        // to toJS() we currently require BackgroundFetchEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<BackgroundFetchEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, BackgroundFetchEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
