// Generated by zig-wayland

// Copyright 2021 Isaac Freund
// 
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
// 

// This protocol allows for a privileged Wayland client to lock the session
// and display arbitrary graphics while the session is locked.
// 
// The compositor may choose to restrict this protocol to a special client
// launched by the compositor itself or expose it to all privileged clients,
// this is compositor policy.
// 
// The client is responsible for performing authentication and informing the
// compositor when the session should be unlocked. If the client dies while
// the session is locked the session remains locked, possibly permanently
// depending on compositor policy.
// 
// The key words "must", "must not", "required", "shall", "shall not",
// "should", "should not", "recommended",  "may", and "optional" in this
// document are to be interpreted as described in IETF RFC 2119.
// 
// Warning! The protocol described in this file is currently in the
// testing phase. Backward compatible changes may be added together with
// the corresponding interface version bump. Backward incompatible changes
// can only be done by creating a new major version of the extension.
// 

const common = @import("common.zig");pub const session_lock_manager_v1 = struct {
 extern const ext_session_lock_manager_v1_interface: common.Interface;
 pub inline fn getInterface() *const common.Interface {
  return &ext_session_lock_manager_v1_interface;
 }};pub const session_lock_v1 = struct {
 extern const ext_session_lock_v1_interface: common.Interface;
 pub inline fn getInterface() *const common.Interface {
  return &ext_session_lock_v1_interface;
 }pub const Error = enum(c_int) {invalid_destroy= 0,invalid_unlock= 1,role= 2,duplicate_output= 3,already_constructed= 4,_,};
};pub const session_lock_surface_v1 = struct {
 extern const ext_session_lock_surface_v1_interface: common.Interface;
 pub inline fn getInterface() *const common.Interface {
  return &ext_session_lock_surface_v1_interface;
 }pub const Error = enum(c_int) {commit_before_first_ack= 0,null_buffer= 1,dimensions_mismatch= 2,invalid_serial= 3,_,};
};