// Generated by zig-wayland

// Copyright 2021 Isaac Freund
// 
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
// 

// This protocol allows for a privileged Wayland client to lock the session
// and display arbitrary graphics while the session is locked.
// 
// The compositor may choose to restrict this protocol to a special client
// launched by the compositor itself or expose it to all privileged clients,
// this is compositor policy.
// 
// The client is responsible for performing authentication and informing the
// compositor when the session should be unlocked. If the client dies while
// the session is locked the session remains locked, possibly permanently
// depending on compositor policy.
// 
// The key words "must", "must not", "required", "shall", "shall not",
// "should", "should not", "recommended",  "may", and "optional" in this
// document are to be interpreted as described in IETF RFC 2119.
// 
// Warning! The protocol described in this file is currently in the
// testing phase. Backward compatible changes may be added together with
// the corresponding interface version bump. Backward incompatible changes
// can only be done by creating a new major version of the extension.
// 

const std = @import("std");
const posix = std.posix;
const client = @import("wayland.zig").client;
const common = @import("common.zig");pub const SessionLockManagerV1 = opaque {
 pub const generated_version = 1;
 pub const getInterface = common.ext.session_lock_manager_v1.getInterface;pub fn setQueue(_session_lock_manager_v1: *SessionLockManagerV1, _queue: *client.wl.EventQueue) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_session_lock_manager_v1);
    _proxy.setQueue(_queue);
}pub fn destroy(_session_lock_manager_v1: *SessionLockManagerV1) void {const _proxy: *client.wl.Proxy = @ptrCast(_session_lock_manager_v1);_proxy.marshal(0, null);_proxy.destroy();}
pub fn lock(_session_lock_manager_v1: *SessionLockManagerV1) !*client.ext.SessionLockV1{const _proxy: *client.wl.Proxy = @ptrCast(_session_lock_manager_v1);var _args = [_]common.Argument{.{ .o = null },};
return @ptrCast(try _proxy.marshalConstructor(1, &_args, client.ext.SessionLockV1.getInterface()));}
};
pub const SessionLockV1 = opaque {
 pub const generated_version = 1;
 pub const getInterface = common.ext.session_lock_v1.getInterface;pub const Error = common.ext.session_lock_v1.Error;
pub fn setQueue(_session_lock_v1: *SessionLockV1, _queue: *client.wl.EventQueue) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_session_lock_v1);
    _proxy.setQueue(_queue);
}pub const Event = union(enum) {locked: void,finished: void,};
pub inline fn setListener(
    _session_lock_v1: *SessionLockV1,
    comptime T: type,
    _listener: *const fn (session_lock_v1: *SessionLockV1, event: Event, data: T) void,
    _data: T,
) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_session_lock_v1);
    const _mut_data: ?*anyopaque = @ptrFromInt(@intFromPtr(_data));
    _proxy.addDispatcher(common.Dispatcher(SessionLockV1, T).dispatcher, _listener, _mut_data);
}pub fn destroy(_session_lock_v1: *SessionLockV1) void {const _proxy: *client.wl.Proxy = @ptrCast(_session_lock_v1);_proxy.marshal(0, null);_proxy.destroy();}
pub fn getLockSurface(_session_lock_v1: *SessionLockV1, _surface:*client.wl.Surface, _output:*client.wl.Output) !*client.ext.SessionLockSurfaceV1{const _proxy: *client.wl.Proxy = @ptrCast(_session_lock_v1);var _args = [_]common.Argument{.{ .o = null },.{ .o = @ptrCast(_surface) },.{ .o = @ptrCast(_output) },};
return @ptrCast(try _proxy.marshalConstructor(1, &_args, client.ext.SessionLockSurfaceV1.getInterface()));}
pub fn unlockAndDestroy(_session_lock_v1: *SessionLockV1) void {const _proxy: *client.wl.Proxy = @ptrCast(_session_lock_v1);_proxy.marshal(2, null);_proxy.destroy();}
};
pub const SessionLockSurfaceV1 = opaque {
 pub const generated_version = 1;
 pub const getInterface = common.ext.session_lock_surface_v1.getInterface;pub const Error = common.ext.session_lock_surface_v1.Error;
pub fn setQueue(_session_lock_surface_v1: *SessionLockSurfaceV1, _queue: *client.wl.EventQueue) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_session_lock_surface_v1);
    _proxy.setQueue(_queue);
}pub const Event = union(enum) {configure: struct {serial:u32,width:u32,height:u32,},
};
pub inline fn setListener(
    _session_lock_surface_v1: *SessionLockSurfaceV1,
    comptime T: type,
    _listener: *const fn (session_lock_surface_v1: *SessionLockSurfaceV1, event: Event, data: T) void,
    _data: T,
) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_session_lock_surface_v1);
    const _mut_data: ?*anyopaque = @ptrFromInt(@intFromPtr(_data));
    _proxy.addDispatcher(common.Dispatcher(SessionLockSurfaceV1, T).dispatcher, _listener, _mut_data);
}pub fn destroy(_session_lock_surface_v1: *SessionLockSurfaceV1) void {const _proxy: *client.wl.Proxy = @ptrCast(_session_lock_surface_v1);_proxy.marshal(0, null);_proxy.destroy();}
pub fn ackConfigure(_session_lock_surface_v1: *SessionLockSurfaceV1, _serial:u32) void {const _proxy: *client.wl.Proxy = @ptrCast(_session_lock_surface_v1);var _args = [_]common.Argument{.{ .u = _serial},};
_proxy.marshal(1, &_args);}
};
