/* Generated by wayland-scanner 1.22.0 */

#ifndef RIVER_CONTROL_UNSTABLE_V1_CLIENT_PROTOCOL_H
#define RIVER_CONTROL_UNSTABLE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_river_control_unstable_v1 The river_control_unstable_v1 protocol
 * @section page_ifaces_river_control_unstable_v1 Interfaces
 * - @subpage page_iface_zriver_control_v1 - run compositor commands
 * - @subpage page_iface_zriver_command_callback_v1 - callback object
 * @section page_copyright_river_control_unstable_v1 Copyright
 * <pre>
 *
 * Copyright 2020 The River Developers
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * </pre>
 */
struct wl_seat;
struct zriver_command_callback_v1;
struct zriver_control_v1;

#ifndef ZRIVER_CONTROL_V1_INTERFACE
#define ZRIVER_CONTROL_V1_INTERFACE
/**
 * @page page_iface_zriver_control_v1 zriver_control_v1
 * @section page_iface_zriver_control_v1_desc Description
 *
 * This interface allows clients to run compositor commands and receive a
 * success/failure response with output or a failure message respectively.
 *
 * Each command is built up in a series of add_argument requests and
 * executed with a run_command request. The first argument is the command
 * to be run.
 *
 * A complete list of commands should be made available in the man page of
 * the compositor.
 * @section page_iface_zriver_control_v1_api API
 * See @ref iface_zriver_control_v1.
 */
/**
 * @defgroup iface_zriver_control_v1 The zriver_control_v1 interface
 *
 * This interface allows clients to run compositor commands and receive a
 * success/failure response with output or a failure message respectively.
 *
 * Each command is built up in a series of add_argument requests and
 * executed with a run_command request. The first argument is the command
 * to be run.
 *
 * A complete list of commands should be made available in the man page of
 * the compositor.
 */
extern const struct wl_interface zriver_control_v1_interface;
#endif
#ifndef ZRIVER_COMMAND_CALLBACK_V1_INTERFACE
#define ZRIVER_COMMAND_CALLBACK_V1_INTERFACE
/**
 * @page page_iface_zriver_command_callback_v1 zriver_command_callback_v1
 * @section page_iface_zriver_command_callback_v1_desc Description
 *
 * This object is created by the run_command request. Exactly one of the
 * success or failure events will be sent. This object will be destroyed
 * by the compositor after one of the events is sent.
 * @section page_iface_zriver_command_callback_v1_api API
 * See @ref iface_zriver_command_callback_v1.
 */
/**
 * @defgroup iface_zriver_command_callback_v1 The zriver_command_callback_v1 interface
 *
 * This object is created by the run_command request. Exactly one of the
 * success or failure events will be sent. This object will be destroyed
 * by the compositor after one of the events is sent.
 */
extern const struct wl_interface zriver_command_callback_v1_interface;
#endif

#define ZRIVER_CONTROL_V1_DESTROY 0
#define ZRIVER_CONTROL_V1_ADD_ARGUMENT 1
#define ZRIVER_CONTROL_V1_RUN_COMMAND 2


/**
 * @ingroup iface_zriver_control_v1
 */
#define ZRIVER_CONTROL_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zriver_control_v1
 */
#define ZRIVER_CONTROL_V1_ADD_ARGUMENT_SINCE_VERSION 1
/**
 * @ingroup iface_zriver_control_v1
 */
#define ZRIVER_CONTROL_V1_RUN_COMMAND_SINCE_VERSION 1

/** @ingroup iface_zriver_control_v1 */
static inline void
zriver_control_v1_set_user_data(struct zriver_control_v1 *zriver_control_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zriver_control_v1, user_data);
}

/** @ingroup iface_zriver_control_v1 */
static inline void *
zriver_control_v1_get_user_data(struct zriver_control_v1 *zriver_control_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zriver_control_v1);
}

static inline uint32_t
zriver_control_v1_get_version(struct zriver_control_v1 *zriver_control_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zriver_control_v1);
}

/**
 * @ingroup iface_zriver_control_v1
 *
 * This request indicates that the client will not use the
 * river_control object any more. Objects that have been created
 * through this instance are not affected.
 */
static inline void
zriver_control_v1_destroy(struct zriver_control_v1 *zriver_control_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zriver_control_v1,
			 ZRIVER_CONTROL_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zriver_control_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_zriver_control_v1
 *
 * Arguments are stored by the server in the order they were sent until
 * the run_command request is made.
 */
static inline void
zriver_control_v1_add_argument(struct zriver_control_v1 *zriver_control_v1, const char *argument)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zriver_control_v1,
			 ZRIVER_CONTROL_V1_ADD_ARGUMENT, NULL, wl_proxy_get_version((struct wl_proxy *) zriver_control_v1), 0, argument);
}

/**
 * @ingroup iface_zriver_control_v1
 *
 * Execute the command built up using the add_argument request for the
 * given seat.
 */
static inline struct zriver_command_callback_v1 *
zriver_control_v1_run_command(struct zriver_control_v1 *zriver_control_v1, struct wl_seat *seat)
{
	struct wl_proxy *callback;

	callback = wl_proxy_marshal_flags((struct wl_proxy *) zriver_control_v1,
			 ZRIVER_CONTROL_V1_RUN_COMMAND, &zriver_command_callback_v1_interface, wl_proxy_get_version((struct wl_proxy *) zriver_control_v1), 0, seat, NULL);

	return (struct zriver_command_callback_v1 *) callback;
}

/**
 * @ingroup iface_zriver_command_callback_v1
 * @struct zriver_command_callback_v1_listener
 */
struct zriver_command_callback_v1_listener {
	/**
	 * command successful
	 *
	 * Sent when the command has been successfully received and
	 * executed by the compositor. Some commands may produce output, in
	 * which case the output argument will be a non-empty string.
	 * @param output the output of the command
	 */
	void (*success)(void *data,
			struct zriver_command_callback_v1 *zriver_command_callback_v1,
			const char *output);
	/**
	 * command failed
	 *
	 * Sent when the command could not be carried out. This could be
	 * due to sending a non-existent command, no command, not enough
	 * arguments, too many arguments, invalid arguments, etc.
	 * @param failure_message a message explaining why failure occurred
	 */
	void (*failure)(void *data,
			struct zriver_command_callback_v1 *zriver_command_callback_v1,
			const char *failure_message);
};

/**
 * @ingroup iface_zriver_command_callback_v1
 */
static inline int
zriver_command_callback_v1_add_listener(struct zriver_command_callback_v1 *zriver_command_callback_v1,
					const struct zriver_command_callback_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zriver_command_callback_v1,
				     (void (**)(void)) listener, data);
}

/**
 * @ingroup iface_zriver_command_callback_v1
 */
#define ZRIVER_COMMAND_CALLBACK_V1_SUCCESS_SINCE_VERSION 1
/**
 * @ingroup iface_zriver_command_callback_v1
 */
#define ZRIVER_COMMAND_CALLBACK_V1_FAILURE_SINCE_VERSION 1


/** @ingroup iface_zriver_command_callback_v1 */
static inline void
zriver_command_callback_v1_set_user_data(struct zriver_command_callback_v1 *zriver_command_callback_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zriver_command_callback_v1, user_data);
}

/** @ingroup iface_zriver_command_callback_v1 */
static inline void *
zriver_command_callback_v1_get_user_data(struct zriver_command_callback_v1 *zriver_command_callback_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zriver_command_callback_v1);
}

static inline uint32_t
zriver_command_callback_v1_get_version(struct zriver_command_callback_v1 *zriver_command_callback_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zriver_command_callback_v1);
}

/** @ingroup iface_zriver_command_callback_v1 */
static inline void
zriver_command_callback_v1_destroy(struct zriver_command_callback_v1 *zriver_command_callback_v1)
{
	wl_proxy_destroy((struct wl_proxy *) zriver_command_callback_v1);
}

#ifdef  __cplusplus
}
#endif

#endif
