
/* Copyright (c) 2015-2023 Valve Corporation
 * Copyright (c) 2015-2023 LunarG, Inc.
 * Copyright (c) 2015-2017, 2019 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Author: Lenny Komow <lenny@lunarg.com>
 * Author: Joey Bzdek <joey@lunarg.com>
 * Author: Shannon McPherson <shannon@lunarg.com>
 * Author: David Pinedo <david@lunarg.com>
 * Author: Charles Giessen <charles@lunarg.com>
 */

/*
 * This file is generated from the Khronos Vulkan XML API Registry.
 */

#pragma once

#include "api_dump.h"
#include "api_dump_video_json.h"




//============================= typedefs ==============================//


//=========================== Type Implementations ==========================//

void dump_json_uint32_t(uint32_t object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << object << "\"";
}
void dump_json_uint8_t(uint8_t object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << (uint32_t) object << "\"";
}
void dump_json_uint16_t(uint16_t object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << object << "\"";
}
void dump_json_int32_t(int32_t object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << object << "\"";
}
void dump_json_int8_t(int8_t object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << (int32_t) object << "\"";
}

//========================= Basetype Implementations ========================//






//======================= System Type Implementations =======================//


//========================== Handle Implementations =========================//


//=========================== Enum Implementations ==========================//

void dump_json_StdVideoH264ChromaFormatIdc(StdVideoH264ChromaFormatIdc object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"STD_VIDEO_H264_CHROMA_FORMAT_IDC_MONOCHROME\"";
        break;
    case 1:
        settings.stream() << "\"STD_VIDEO_H264_CHROMA_FORMAT_IDC_420\"";
        break;
    case 2:
        settings.stream() << "\"STD_VIDEO_H264_CHROMA_FORMAT_IDC_422\"";
        break;
    case 3:
        settings.stream() << "\"STD_VIDEO_H264_CHROMA_FORMAT_IDC_444\"";
        break;
    case 0x7FFFFFFF:
        settings.stream() << "\"STD_VIDEO_H264_CHROMA_FORMAT_IDC_INVALID\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_StdVideoH264ProfileIdc(StdVideoH264ProfileIdc object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 66:
        settings.stream() << "\"STD_VIDEO_H264_PROFILE_IDC_BASELINE\"";
        break;
    case 77:
        settings.stream() << "\"STD_VIDEO_H264_PROFILE_IDC_MAIN\"";
        break;
    case 100:
        settings.stream() << "\"STD_VIDEO_H264_PROFILE_IDC_HIGH\"";
        break;
    case 244:
        settings.stream() << "\"STD_VIDEO_H264_PROFILE_IDC_HIGH_444_PREDICTIVE\"";
        break;
    case 0x7FFFFFFF:
        settings.stream() << "\"STD_VIDEO_H264_PROFILE_IDC_INVALID\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_StdVideoH264LevelIdc(StdVideoH264LevelIdc object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"STD_VIDEO_H264_LEVEL_IDC_1_0\"";
        break;
    case 1:
        settings.stream() << "\"STD_VIDEO_H264_LEVEL_IDC_1_1\"";
        break;
    case 2:
        settings.stream() << "\"STD_VIDEO_H264_LEVEL_IDC_1_2\"";
        break;
    case 3:
        settings.stream() << "\"STD_VIDEO_H264_LEVEL_IDC_1_3\"";
        break;
    case 4:
        settings.stream() << "\"STD_VIDEO_H264_LEVEL_IDC_2_0\"";
        break;
    case 5:
        settings.stream() << "\"STD_VIDEO_H264_LEVEL_IDC_2_1\"";
        break;
    case 6:
        settings.stream() << "\"STD_VIDEO_H264_LEVEL_IDC_2_2\"";
        break;
    case 7:
        settings.stream() << "\"STD_VIDEO_H264_LEVEL_IDC_3_0\"";
        break;
    case 8:
        settings.stream() << "\"STD_VIDEO_H264_LEVEL_IDC_3_1\"";
        break;
    case 9:
        settings.stream() << "\"STD_VIDEO_H264_LEVEL_IDC_3_2\"";
        break;
    case 10:
        settings.stream() << "\"STD_VIDEO_H264_LEVEL_IDC_4_0\"";
        break;
    case 11:
        settings.stream() << "\"STD_VIDEO_H264_LEVEL_IDC_4_1\"";
        break;
    case 12:
        settings.stream() << "\"STD_VIDEO_H264_LEVEL_IDC_4_2\"";
        break;
    case 13:
        settings.stream() << "\"STD_VIDEO_H264_LEVEL_IDC_5_0\"";
        break;
    case 14:
        settings.stream() << "\"STD_VIDEO_H264_LEVEL_IDC_5_1\"";
        break;
    case 15:
        settings.stream() << "\"STD_VIDEO_H264_LEVEL_IDC_5_2\"";
        break;
    case 16:
        settings.stream() << "\"STD_VIDEO_H264_LEVEL_IDC_6_0\"";
        break;
    case 17:
        settings.stream() << "\"STD_VIDEO_H264_LEVEL_IDC_6_1\"";
        break;
    case 18:
        settings.stream() << "\"STD_VIDEO_H264_LEVEL_IDC_6_2\"";
        break;
    case 0x7FFFFFFF:
        settings.stream() << "\"STD_VIDEO_H264_LEVEL_IDC_INVALID\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_StdVideoH264PocType(StdVideoH264PocType object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"STD_VIDEO_H264_POC_TYPE_0\"";
        break;
    case 1:
        settings.stream() << "\"STD_VIDEO_H264_POC_TYPE_1\"";
        break;
    case 2:
        settings.stream() << "\"STD_VIDEO_H264_POC_TYPE_2\"";
        break;
    case 0x7FFFFFFF:
        settings.stream() << "\"STD_VIDEO_H264_POC_TYPE_INVALID\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_StdVideoH264AspectRatioIdc(StdVideoH264AspectRatioIdc object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"STD_VIDEO_H264_ASPECT_RATIO_IDC_UNSPECIFIED\"";
        break;
    case 1:
        settings.stream() << "\"STD_VIDEO_H264_ASPECT_RATIO_IDC_SQUARE\"";
        break;
    case 2:
        settings.stream() << "\"STD_VIDEO_H264_ASPECT_RATIO_IDC_12_11\"";
        break;
    case 3:
        settings.stream() << "\"STD_VIDEO_H264_ASPECT_RATIO_IDC_10_11\"";
        break;
    case 4:
        settings.stream() << "\"STD_VIDEO_H264_ASPECT_RATIO_IDC_16_11\"";
        break;
    case 5:
        settings.stream() << "\"STD_VIDEO_H264_ASPECT_RATIO_IDC_40_33\"";
        break;
    case 6:
        settings.stream() << "\"STD_VIDEO_H264_ASPECT_RATIO_IDC_24_11\"";
        break;
    case 7:
        settings.stream() << "\"STD_VIDEO_H264_ASPECT_RATIO_IDC_20_11\"";
        break;
    case 8:
        settings.stream() << "\"STD_VIDEO_H264_ASPECT_RATIO_IDC_32_11\"";
        break;
    case 9:
        settings.stream() << "\"STD_VIDEO_H264_ASPECT_RATIO_IDC_80_33\"";
        break;
    case 10:
        settings.stream() << "\"STD_VIDEO_H264_ASPECT_RATIO_IDC_18_11\"";
        break;
    case 11:
        settings.stream() << "\"STD_VIDEO_H264_ASPECT_RATIO_IDC_15_11\"";
        break;
    case 12:
        settings.stream() << "\"STD_VIDEO_H264_ASPECT_RATIO_IDC_64_33\"";
        break;
    case 13:
        settings.stream() << "\"STD_VIDEO_H264_ASPECT_RATIO_IDC_160_99\"";
        break;
    case 14:
        settings.stream() << "\"STD_VIDEO_H264_ASPECT_RATIO_IDC_4_3\"";
        break;
    case 15:
        settings.stream() << "\"STD_VIDEO_H264_ASPECT_RATIO_IDC_3_2\"";
        break;
    case 16:
        settings.stream() << "\"STD_VIDEO_H264_ASPECT_RATIO_IDC_2_1\"";
        break;
    case 255:
        settings.stream() << "\"STD_VIDEO_H264_ASPECT_RATIO_IDC_EXTENDED_SAR\"";
        break;
    case 0x7FFFFFFF:
        settings.stream() << "\"STD_VIDEO_H264_ASPECT_RATIO_IDC_INVALID\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_StdVideoH264WeightedBipredIdc(StdVideoH264WeightedBipredIdc object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_DEFAULT\"";
        break;
    case 1:
        settings.stream() << "\"STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_EXPLICIT\"";
        break;
    case 2:
        settings.stream() << "\"STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_IMPLICIT\"";
        break;
    case 0x7FFFFFFF:
        settings.stream() << "\"STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_INVALID\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_StdVideoH264ModificationOfPicNumsIdc(StdVideoH264ModificationOfPicNumsIdc object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_SHORT_TERM_SUBTRACT\"";
        break;
    case 1:
        settings.stream() << "\"STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_SHORT_TERM_ADD\"";
        break;
    case 2:
        settings.stream() << "\"STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_LONG_TERM\"";
        break;
    case 3:
        settings.stream() << "\"STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_END\"";
        break;
    case 0x7FFFFFFF:
        settings.stream() << "\"STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_INVALID\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_StdVideoH264MemMgmtControlOp(StdVideoH264MemMgmtControlOp object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_END\"";
        break;
    case 1:
        settings.stream() << "\"STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_UNMARK_SHORT_TERM\"";
        break;
    case 2:
        settings.stream() << "\"STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_UNMARK_LONG_TERM\"";
        break;
    case 3:
        settings.stream() << "\"STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_MARK_LONG_TERM\"";
        break;
    case 4:
        settings.stream() << "\"STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_SET_MAX_LONG_TERM_INDEX\"";
        break;
    case 5:
        settings.stream() << "\"STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_UNMARK_ALL\"";
        break;
    case 6:
        settings.stream() << "\"STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_MARK_CURRENT_AS_LONG_TERM\"";
        break;
    case 0x7FFFFFFF:
        settings.stream() << "\"STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_INVALID\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_StdVideoH264CabacInitIdc(StdVideoH264CabacInitIdc object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"STD_VIDEO_H264_CABAC_INIT_IDC_0\"";
        break;
    case 1:
        settings.stream() << "\"STD_VIDEO_H264_CABAC_INIT_IDC_1\"";
        break;
    case 2:
        settings.stream() << "\"STD_VIDEO_H264_CABAC_INIT_IDC_2\"";
        break;
    case 0x7FFFFFFF:
        settings.stream() << "\"STD_VIDEO_H264_CABAC_INIT_IDC_INVALID\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_StdVideoH264DisableDeblockingFilterIdc(StdVideoH264DisableDeblockingFilterIdc object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"STD_VIDEO_H264_DISABLE_DEBLOCKING_FILTER_IDC_DISABLED\"";
        break;
    case 1:
        settings.stream() << "\"STD_VIDEO_H264_DISABLE_DEBLOCKING_FILTER_IDC_ENABLED\"";
        break;
    case 2:
        settings.stream() << "\"STD_VIDEO_H264_DISABLE_DEBLOCKING_FILTER_IDC_PARTIAL\"";
        break;
    case 0x7FFFFFFF:
        settings.stream() << "\"STD_VIDEO_H264_DISABLE_DEBLOCKING_FILTER_IDC_INVALID\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_StdVideoH264SliceType(StdVideoH264SliceType object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"STD_VIDEO_H264_SLICE_TYPE_P\"";
        break;
    case 1:
        settings.stream() << "\"STD_VIDEO_H264_SLICE_TYPE_B\"";
        break;
    case 2:
        settings.stream() << "\"STD_VIDEO_H264_SLICE_TYPE_I\"";
        break;
    case 0x7FFFFFFF:
        settings.stream() << "\"STD_VIDEO_H264_SLICE_TYPE_INVALID\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_StdVideoH264PictureType(StdVideoH264PictureType object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"STD_VIDEO_H264_PICTURE_TYPE_P\"";
        break;
    case 1:
        settings.stream() << "\"STD_VIDEO_H264_PICTURE_TYPE_B\"";
        break;
    case 2:
        settings.stream() << "\"STD_VIDEO_H264_PICTURE_TYPE_I\"";
        break;
    case 5:
        settings.stream() << "\"STD_VIDEO_H264_PICTURE_TYPE_IDR\"";
        break;
    case 0x7FFFFFFF:
        settings.stream() << "\"STD_VIDEO_H264_PICTURE_TYPE_INVALID\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_StdVideoH264NonVclNaluType(StdVideoH264NonVclNaluType object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"STD_VIDEO_H264_NON_VCL_NALU_TYPE_SPS\"";
        break;
    case 1:
        settings.stream() << "\"STD_VIDEO_H264_NON_VCL_NALU_TYPE_PPS\"";
        break;
    case 2:
        settings.stream() << "\"STD_VIDEO_H264_NON_VCL_NALU_TYPE_AUD\"";
        break;
    case 3:
        settings.stream() << "\"STD_VIDEO_H264_NON_VCL_NALU_TYPE_PREFIX\"";
        break;
    case 4:
        settings.stream() << "\"STD_VIDEO_H264_NON_VCL_NALU_TYPE_END_OF_SEQUENCE\"";
        break;
    case 5:
        settings.stream() << "\"STD_VIDEO_H264_NON_VCL_NALU_TYPE_END_OF_STREAM\"";
        break;
    case 6:
        settings.stream() << "\"STD_VIDEO_H264_NON_VCL_NALU_TYPE_PRECODED\"";
        break;
    case 0x7FFFFFFF:
        settings.stream() << "\"STD_VIDEO_H264_NON_VCL_NALU_TYPE_INVALID\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_StdVideoDecodeH264FieldOrderCount(StdVideoDecodeH264FieldOrderCount object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_TOP\"";
        break;
    case 1:
        settings.stream() << "\"STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_BOTTOM\"";
        break;
    case 0x7FFFFFFF:
        settings.stream() << "\"STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_INVALID\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_StdVideoH265ChromaFormatIdc(StdVideoH265ChromaFormatIdc object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"STD_VIDEO_H265_CHROMA_FORMAT_IDC_MONOCHROME\"";
        break;
    case 1:
        settings.stream() << "\"STD_VIDEO_H265_CHROMA_FORMAT_IDC_420\"";
        break;
    case 2:
        settings.stream() << "\"STD_VIDEO_H265_CHROMA_FORMAT_IDC_422\"";
        break;
    case 3:
        settings.stream() << "\"STD_VIDEO_H265_CHROMA_FORMAT_IDC_444\"";
        break;
    case 0x7FFFFFFF:
        settings.stream() << "\"STD_VIDEO_H265_CHROMA_FORMAT_IDC_INVALID\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_StdVideoH265ProfileIdc(StdVideoH265ProfileIdc object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 1:
        settings.stream() << "\"STD_VIDEO_H265_PROFILE_IDC_MAIN\"";
        break;
    case 2:
        settings.stream() << "\"STD_VIDEO_H265_PROFILE_IDC_MAIN_10\"";
        break;
    case 3:
        settings.stream() << "\"STD_VIDEO_H265_PROFILE_IDC_MAIN_STILL_PICTURE\"";
        break;
    case 4:
        settings.stream() << "\"STD_VIDEO_H265_PROFILE_IDC_FORMAT_RANGE_EXTENSIONS\"";
        break;
    case 9:
        settings.stream() << "\"STD_VIDEO_H265_PROFILE_IDC_SCC_EXTENSIONS\"";
        break;
    case 0x7FFFFFFF:
        settings.stream() << "\"STD_VIDEO_H265_PROFILE_IDC_INVALID\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_StdVideoH265LevelIdc(StdVideoH265LevelIdc object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"STD_VIDEO_H265_LEVEL_IDC_1_0\"";
        break;
    case 1:
        settings.stream() << "\"STD_VIDEO_H265_LEVEL_IDC_2_0\"";
        break;
    case 2:
        settings.stream() << "\"STD_VIDEO_H265_LEVEL_IDC_2_1\"";
        break;
    case 3:
        settings.stream() << "\"STD_VIDEO_H265_LEVEL_IDC_3_0\"";
        break;
    case 4:
        settings.stream() << "\"STD_VIDEO_H265_LEVEL_IDC_3_1\"";
        break;
    case 5:
        settings.stream() << "\"STD_VIDEO_H265_LEVEL_IDC_4_0\"";
        break;
    case 6:
        settings.stream() << "\"STD_VIDEO_H265_LEVEL_IDC_4_1\"";
        break;
    case 7:
        settings.stream() << "\"STD_VIDEO_H265_LEVEL_IDC_5_0\"";
        break;
    case 8:
        settings.stream() << "\"STD_VIDEO_H265_LEVEL_IDC_5_1\"";
        break;
    case 9:
        settings.stream() << "\"STD_VIDEO_H265_LEVEL_IDC_5_2\"";
        break;
    case 10:
        settings.stream() << "\"STD_VIDEO_H265_LEVEL_IDC_6_0\"";
        break;
    case 11:
        settings.stream() << "\"STD_VIDEO_H265_LEVEL_IDC_6_1\"";
        break;
    case 12:
        settings.stream() << "\"STD_VIDEO_H265_LEVEL_IDC_6_2\"";
        break;
    case 0x7FFFFFFF:
        settings.stream() << "\"STD_VIDEO_H265_LEVEL_IDC_INVALID\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_StdVideoH265SliceType(StdVideoH265SliceType object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"STD_VIDEO_H265_SLICE_TYPE_B\"";
        break;
    case 1:
        settings.stream() << "\"STD_VIDEO_H265_SLICE_TYPE_P\"";
        break;
    case 2:
        settings.stream() << "\"STD_VIDEO_H265_SLICE_TYPE_I\"";
        break;
    case 0x7FFFFFFF:
        settings.stream() << "\"STD_VIDEO_H265_SLICE_TYPE_INVALID\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_StdVideoH265PictureType(StdVideoH265PictureType object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"STD_VIDEO_H265_PICTURE_TYPE_P\"";
        break;
    case 1:
        settings.stream() << "\"STD_VIDEO_H265_PICTURE_TYPE_B\"";
        break;
    case 2:
        settings.stream() << "\"STD_VIDEO_H265_PICTURE_TYPE_I\"";
        break;
    case 3:
        settings.stream() << "\"STD_VIDEO_H265_PICTURE_TYPE_IDR\"";
        break;
    case 0x7FFFFFFF:
        settings.stream() << "\"STD_VIDEO_H265_PICTURE_TYPE_INVALID\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_StdVideoH265AspectRatioIdc(StdVideoH265AspectRatioIdc object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"STD_VIDEO_H265_ASPECT_RATIO_IDC_UNSPECIFIED\"";
        break;
    case 1:
        settings.stream() << "\"STD_VIDEO_H265_ASPECT_RATIO_IDC_SQUARE\"";
        break;
    case 2:
        settings.stream() << "\"STD_VIDEO_H265_ASPECT_RATIO_IDC_12_11\"";
        break;
    case 3:
        settings.stream() << "\"STD_VIDEO_H265_ASPECT_RATIO_IDC_10_11\"";
        break;
    case 4:
        settings.stream() << "\"STD_VIDEO_H265_ASPECT_RATIO_IDC_16_11\"";
        break;
    case 5:
        settings.stream() << "\"STD_VIDEO_H265_ASPECT_RATIO_IDC_40_33\"";
        break;
    case 6:
        settings.stream() << "\"STD_VIDEO_H265_ASPECT_RATIO_IDC_24_11\"";
        break;
    case 7:
        settings.stream() << "\"STD_VIDEO_H265_ASPECT_RATIO_IDC_20_11\"";
        break;
    case 8:
        settings.stream() << "\"STD_VIDEO_H265_ASPECT_RATIO_IDC_32_11\"";
        break;
    case 9:
        settings.stream() << "\"STD_VIDEO_H265_ASPECT_RATIO_IDC_80_33\"";
        break;
    case 10:
        settings.stream() << "\"STD_VIDEO_H265_ASPECT_RATIO_IDC_18_11\"";
        break;
    case 11:
        settings.stream() << "\"STD_VIDEO_H265_ASPECT_RATIO_IDC_15_11\"";
        break;
    case 12:
        settings.stream() << "\"STD_VIDEO_H265_ASPECT_RATIO_IDC_64_33\"";
        break;
    case 13:
        settings.stream() << "\"STD_VIDEO_H265_ASPECT_RATIO_IDC_160_99\"";
        break;
    case 14:
        settings.stream() << "\"STD_VIDEO_H265_ASPECT_RATIO_IDC_4_3\"";
        break;
    case 15:
        settings.stream() << "\"STD_VIDEO_H265_ASPECT_RATIO_IDC_3_2\"";
        break;
    case 16:
        settings.stream() << "\"STD_VIDEO_H265_ASPECT_RATIO_IDC_2_1\"";
        break;
    case 255:
        settings.stream() << "\"STD_VIDEO_H265_ASPECT_RATIO_IDC_EXTENDED_SAR\"";
        break;
    case 0x7FFFFFFF:
        settings.stream() << "\"STD_VIDEO_H265_ASPECT_RATIO_IDC_INVALID\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}

//========================= Bitmask Implementations =========================//


//=========================== Flag Implementations ==========================//




//======================= Func Pointer Implementations ======================//


//========================== Struct Implementations =========================//

void dump_json_StdVideoH264SpsVuiFlags(const StdVideoH264SpsVuiFlags& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.aspect_ratio_info_present_flag, NULL, settings, "uint32_t", "aspect_ratio_info_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.overscan_info_present_flag, NULL, settings, "uint32_t", "overscan_info_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.overscan_appropriate_flag, NULL, settings, "uint32_t", "overscan_appropriate_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.video_signal_type_present_flag, NULL, settings, "uint32_t", "video_signal_type_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.video_full_range_flag, NULL, settings, "uint32_t", "video_full_range_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.color_description_present_flag, NULL, settings, "uint32_t", "color_description_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.chroma_loc_info_present_flag, NULL, settings, "uint32_t", "chroma_loc_info_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.timing_info_present_flag, NULL, settings, "uint32_t", "timing_info_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.fixed_frame_rate_flag, NULL, settings, "uint32_t", "fixed_frame_rate_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.bitstream_restriction_flag, NULL, settings, "uint32_t", "bitstream_restriction_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.nal_hrd_parameters_present_flag, NULL, settings, "uint32_t", "nal_hrd_parameters_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.vcl_hrd_parameters_present_flag, NULL, settings, "uint32_t", "vcl_hrd_parameters_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH264HrdParameters(const StdVideoH264HrdParameters& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint8_t>(object.cpb_cnt_minus1, NULL, settings, "uint8_t", "cpb_cnt_minus1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.bit_rate_scale, NULL, settings, "uint8_t", "bit_rate_scale", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.cpb_size_scale, NULL, settings, "uint8_t", "cpb_size_scale", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.reserved1, NULL, settings, "uint8_t", "reserved1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_array<const uint32_t>(object.bit_rate_value_minus1, STD_VIDEO_H264_CPB_CNT_LIST_SIZE, settings, "uint32_t[STD_VIDEO_H264_CPB_CNT_LIST_SIZE]", "uint32_t", "bit_rate_value_minus1", false, false, indents + 1, dump_json_uint32_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const uint32_t>(object.cpb_size_value_minus1, STD_VIDEO_H264_CPB_CNT_LIST_SIZE, settings, "uint32_t[STD_VIDEO_H264_CPB_CNT_LIST_SIZE]", "uint32_t", "cpb_size_value_minus1", false, false, indents + 1, dump_json_uint32_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const uint8_t>(object.cbr_flag, STD_VIDEO_H264_CPB_CNT_LIST_SIZE, settings, "uint8_t[STD_VIDEO_H264_CPB_CNT_LIST_SIZE]", "uint8_t", "cbr_flag", false, false, indents + 1, dump_json_uint8_t); // IQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.initial_cpb_removal_delay_length_minus1, NULL, settings, "uint32_t", "initial_cpb_removal_delay_length_minus1", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.cpb_removal_delay_length_minus1, NULL, settings, "uint32_t", "cpb_removal_delay_length_minus1", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.dpb_output_delay_length_minus1, NULL, settings, "uint32_t", "dpb_output_delay_length_minus1", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.time_offset_length, NULL, settings, "uint32_t", "time_offset_length", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH264SequenceParameterSetVui(const StdVideoH264SequenceParameterSetVui& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoH264SpsVuiFlags>(object.flags, NULL, settings, "StdVideoH264SpsVuiFlags", "flags", true, false, indents + 1, dump_json_StdVideoH264SpsVuiFlags);
    settings.stream() << ",\n";
    dump_json_value<const StdVideoH264AspectRatioIdc>(object.aspect_ratio_idc, NULL, settings, "StdVideoH264AspectRatioIdc", "aspect_ratio_idc", false, false, indents + 1, dump_json_StdVideoH264AspectRatioIdc);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.sar_width, NULL, settings, "uint16_t", "sar_width", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.sar_height, NULL, settings, "uint16_t", "sar_height", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.video_format, NULL, settings, "uint8_t", "video_format", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.colour_primaries, NULL, settings, "uint8_t", "colour_primaries", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.transfer_characteristics, NULL, settings, "uint8_t", "transfer_characteristics", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.matrix_coefficients, NULL, settings, "uint8_t", "matrix_coefficients", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.num_units_in_tick, NULL, settings, "uint32_t", "num_units_in_tick", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.time_scale, NULL, settings, "uint32_t", "time_scale", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.max_num_reorder_frames, NULL, settings, "uint8_t", "max_num_reorder_frames", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.max_dec_frame_buffering, NULL, settings, "uint8_t", "max_dec_frame_buffering", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.chroma_sample_loc_type_top_field, NULL, settings, "uint8_t", "chroma_sample_loc_type_top_field", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.chroma_sample_loc_type_bottom_field, NULL, settings, "uint8_t", "chroma_sample_loc_type_bottom_field", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.reserved1, NULL, settings, "uint32_t", "reserved1", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoH264HrdParameters>(object.pHrdParameters, settings, "const StdVideoH264HrdParameters*", "pHrdParameters", true, false, indents + 1, dump_json_StdVideoH264HrdParameters);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH264SpsFlags(const StdVideoH264SpsFlags& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.constraint_set0_flag, NULL, settings, "uint32_t", "constraint_set0_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.constraint_set1_flag, NULL, settings, "uint32_t", "constraint_set1_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.constraint_set2_flag, NULL, settings, "uint32_t", "constraint_set2_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.constraint_set3_flag, NULL, settings, "uint32_t", "constraint_set3_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.constraint_set4_flag, NULL, settings, "uint32_t", "constraint_set4_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.constraint_set5_flag, NULL, settings, "uint32_t", "constraint_set5_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.direct_8x8_inference_flag, NULL, settings, "uint32_t", "direct_8x8_inference_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.mb_adaptive_frame_field_flag, NULL, settings, "uint32_t", "mb_adaptive_frame_field_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.frame_mbs_only_flag, NULL, settings, "uint32_t", "frame_mbs_only_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.delta_pic_order_always_zero_flag, NULL, settings, "uint32_t", "delta_pic_order_always_zero_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.separate_colour_plane_flag, NULL, settings, "uint32_t", "separate_colour_plane_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.gaps_in_frame_num_value_allowed_flag, NULL, settings, "uint32_t", "gaps_in_frame_num_value_allowed_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.qpprime_y_zero_transform_bypass_flag, NULL, settings, "uint32_t", "qpprime_y_zero_transform_bypass_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.frame_cropping_flag, NULL, settings, "uint32_t", "frame_cropping_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.seq_scaling_matrix_present_flag, NULL, settings, "uint32_t", "seq_scaling_matrix_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.vui_parameters_present_flag, NULL, settings, "uint32_t", "vui_parameters_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH264ScalingLists(const StdVideoH264ScalingLists& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint16_t>(object.scaling_list_present_mask, NULL, settings, "uint16_t", "scaling_list_present_mask", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.use_default_scaling_matrix_mask, NULL, settings, "uint16_t", "use_default_scaling_matrix_mask", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    settings.stream() << ",\n";
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH264SequenceParameterSet(const StdVideoH264SequenceParameterSet& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoH264SpsFlags>(object.flags, NULL, settings, "StdVideoH264SpsFlags", "flags", true, false, indents + 1, dump_json_StdVideoH264SpsFlags);
    settings.stream() << ",\n";
    dump_json_value<const StdVideoH264ProfileIdc>(object.profile_idc, NULL, settings, "StdVideoH264ProfileIdc", "profile_idc", false, false, indents + 1, dump_json_StdVideoH264ProfileIdc);
    settings.stream() << ",\n";
    dump_json_value<const StdVideoH264LevelIdc>(object.level_idc, NULL, settings, "StdVideoH264LevelIdc", "level_idc", false, false, indents + 1, dump_json_StdVideoH264LevelIdc);
    settings.stream() << ",\n";
    dump_json_value<const StdVideoH264ChromaFormatIdc>(object.chroma_format_idc, NULL, settings, "StdVideoH264ChromaFormatIdc", "chroma_format_idc", false, false, indents + 1, dump_json_StdVideoH264ChromaFormatIdc);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.seq_parameter_set_id, NULL, settings, "uint8_t", "seq_parameter_set_id", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.bit_depth_luma_minus8, NULL, settings, "uint8_t", "bit_depth_luma_minus8", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.bit_depth_chroma_minus8, NULL, settings, "uint8_t", "bit_depth_chroma_minus8", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.log2_max_frame_num_minus4, NULL, settings, "uint8_t", "log2_max_frame_num_minus4", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const StdVideoH264PocType>(object.pic_order_cnt_type, NULL, settings, "StdVideoH264PocType", "pic_order_cnt_type", false, false, indents + 1, dump_json_StdVideoH264PocType);
    settings.stream() << ",\n";
    dump_json_value<const int32_t>(object.offset_for_non_ref_pic, NULL, settings, "int32_t", "offset_for_non_ref_pic", false, false, indents + 1, dump_json_int32_t);
    settings.stream() << ",\n";
    dump_json_value<const int32_t>(object.offset_for_top_to_bottom_field, NULL, settings, "int32_t", "offset_for_top_to_bottom_field", false, false, indents + 1, dump_json_int32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.log2_max_pic_order_cnt_lsb_minus4, NULL, settings, "uint8_t", "log2_max_pic_order_cnt_lsb_minus4", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.num_ref_frames_in_pic_order_cnt_cycle, NULL, settings, "uint8_t", "num_ref_frames_in_pic_order_cnt_cycle", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.max_num_ref_frames, NULL, settings, "uint8_t", "max_num_ref_frames", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.reserved1, NULL, settings, "uint8_t", "reserved1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.pic_width_in_mbs_minus1, NULL, settings, "uint32_t", "pic_width_in_mbs_minus1", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.pic_height_in_map_units_minus1, NULL, settings, "uint32_t", "pic_height_in_map_units_minus1", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.frame_crop_left_offset, NULL, settings, "uint32_t", "frame_crop_left_offset", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.frame_crop_right_offset, NULL, settings, "uint32_t", "frame_crop_right_offset", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.frame_crop_top_offset, NULL, settings, "uint32_t", "frame_crop_top_offset", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.frame_crop_bottom_offset, NULL, settings, "uint32_t", "frame_crop_bottom_offset", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.reserved2, NULL, settings, "uint32_t", "reserved2", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_pointer<const int32_t>(object.pOffsetForRefFrame, settings, "const int32_t*", "pOffsetForRefFrame", false, false, indents + 1, dump_json_int32_t);
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoH264ScalingLists>(object.pScalingLists, settings, "const StdVideoH264ScalingLists*", "pScalingLists", true, false, indents + 1, dump_json_StdVideoH264ScalingLists);
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoH264SequenceParameterSetVui>(object.pSequenceParameterSetVui, settings, "const StdVideoH264SequenceParameterSetVui*", "pSequenceParameterSetVui", true, false, indents + 1, dump_json_StdVideoH264SequenceParameterSetVui);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH264PpsFlags(const StdVideoH264PpsFlags& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.transform_8x8_mode_flag, NULL, settings, "uint32_t", "transform_8x8_mode_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.redundant_pic_cnt_present_flag, NULL, settings, "uint32_t", "redundant_pic_cnt_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.constrained_intra_pred_flag, NULL, settings, "uint32_t", "constrained_intra_pred_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.deblocking_filter_control_present_flag, NULL, settings, "uint32_t", "deblocking_filter_control_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.weighted_pred_flag, NULL, settings, "uint32_t", "weighted_pred_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.bottom_field_pic_order_in_frame_present_flag, NULL, settings, "uint32_t", "bottom_field_pic_order_in_frame_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.entropy_coding_mode_flag, NULL, settings, "uint32_t", "entropy_coding_mode_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.pic_scaling_matrix_present_flag, NULL, settings, "uint32_t", "pic_scaling_matrix_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH264PictureParameterSet(const StdVideoH264PictureParameterSet& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoH264PpsFlags>(object.flags, NULL, settings, "StdVideoH264PpsFlags", "flags", true, false, indents + 1, dump_json_StdVideoH264PpsFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.seq_parameter_set_id, NULL, settings, "uint8_t", "seq_parameter_set_id", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.pic_parameter_set_id, NULL, settings, "uint8_t", "pic_parameter_set_id", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.num_ref_idx_l0_default_active_minus1, NULL, settings, "uint8_t", "num_ref_idx_l0_default_active_minus1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.num_ref_idx_l1_default_active_minus1, NULL, settings, "uint8_t", "num_ref_idx_l1_default_active_minus1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const StdVideoH264WeightedBipredIdc>(object.weighted_bipred_idc, NULL, settings, "StdVideoH264WeightedBipredIdc", "weighted_bipred_idc", false, false, indents + 1, dump_json_StdVideoH264WeightedBipredIdc);
    settings.stream() << ",\n";
    dump_json_value<const int8_t>(object.pic_init_qp_minus26, NULL, settings, "int8_t", "pic_init_qp_minus26", false, false, indents + 1, dump_json_int8_t);
    settings.stream() << ",\n";
    dump_json_value<const int8_t>(object.pic_init_qs_minus26, NULL, settings, "int8_t", "pic_init_qs_minus26", false, false, indents + 1, dump_json_int8_t);
    settings.stream() << ",\n";
    dump_json_value<const int8_t>(object.chroma_qp_index_offset, NULL, settings, "int8_t", "chroma_qp_index_offset", false, false, indents + 1, dump_json_int8_t);
    settings.stream() << ",\n";
    dump_json_value<const int8_t>(object.second_chroma_qp_index_offset, NULL, settings, "int8_t", "second_chroma_qp_index_offset", false, false, indents + 1, dump_json_int8_t);
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoH264ScalingLists>(object.pScalingLists, settings, "const StdVideoH264ScalingLists*", "pScalingLists", true, false, indents + 1, dump_json_StdVideoH264ScalingLists);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoDecodeH264PictureInfoFlags(const StdVideoDecodeH264PictureInfoFlags& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.field_pic_flag, NULL, settings, "uint32_t", "field_pic_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.is_intra, NULL, settings, "uint32_t", "is_intra", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.IdrPicFlag, NULL, settings, "uint32_t", "IdrPicFlag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.bottom_field_flag, NULL, settings, "uint32_t", "bottom_field_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.is_reference, NULL, settings, "uint32_t", "is_reference", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.complementary_field_pair, NULL, settings, "uint32_t", "complementary_field_pair", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoDecodeH264PictureInfo(const StdVideoDecodeH264PictureInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoDecodeH264PictureInfoFlags>(object.flags, NULL, settings, "StdVideoDecodeH264PictureInfoFlags", "flags", true, false, indents + 1, dump_json_StdVideoDecodeH264PictureInfoFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.seq_parameter_set_id, NULL, settings, "uint8_t", "seq_parameter_set_id", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.pic_parameter_set_id, NULL, settings, "uint8_t", "pic_parameter_set_id", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.reserved1, NULL, settings, "uint8_t", "reserved1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.reserved2, NULL, settings, "uint8_t", "reserved2", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.frame_num, NULL, settings, "uint16_t", "frame_num", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.idr_pic_id, NULL, settings, "uint16_t", "idr_pic_id", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_array<const int32_t>(object.PicOrderCnt, STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_LIST_SIZE, settings, "int32_t[STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_LIST_SIZE]", "int32_t", "PicOrderCnt", false, false, indents + 1, dump_json_int32_t); // IQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoDecodeH264ReferenceInfoFlags(const StdVideoDecodeH264ReferenceInfoFlags& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.top_field_flag, NULL, settings, "uint32_t", "top_field_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.bottom_field_flag, NULL, settings, "uint32_t", "bottom_field_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.used_for_long_term_reference, NULL, settings, "uint32_t", "used_for_long_term_reference", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.is_non_existing, NULL, settings, "uint32_t", "is_non_existing", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoDecodeH264ReferenceInfo(const StdVideoDecodeH264ReferenceInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoDecodeH264ReferenceInfoFlags>(object.flags, NULL, settings, "StdVideoDecodeH264ReferenceInfoFlags", "flags", true, false, indents + 1, dump_json_StdVideoDecodeH264ReferenceInfoFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.FrameNum, NULL, settings, "uint16_t", "FrameNum", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.reserved, NULL, settings, "uint16_t", "reserved", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_array<const int32_t>(object.PicOrderCnt, STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_LIST_SIZE, settings, "int32_t[STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_LIST_SIZE]", "int32_t", "PicOrderCnt", false, false, indents + 1, dump_json_int32_t); // IQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoEncodeH264WeightTableFlags(const StdVideoEncodeH264WeightTableFlags& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.luma_weight_l0_flag, NULL, settings, "uint32_t", "luma_weight_l0_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.chroma_weight_l0_flag, NULL, settings, "uint32_t", "chroma_weight_l0_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.luma_weight_l1_flag, NULL, settings, "uint32_t", "luma_weight_l1_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.chroma_weight_l1_flag, NULL, settings, "uint32_t", "chroma_weight_l1_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoEncodeH264WeightTable(const StdVideoEncodeH264WeightTable& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoEncodeH264WeightTableFlags>(object.flags, NULL, settings, "StdVideoEncodeH264WeightTableFlags", "flags", true, false, indents + 1, dump_json_StdVideoEncodeH264WeightTableFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.luma_log2_weight_denom, NULL, settings, "uint8_t", "luma_log2_weight_denom", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.chroma_log2_weight_denom, NULL, settings, "uint8_t", "chroma_log2_weight_denom", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_array<const int8_t>(object.luma_weight_l0, STD_VIDEO_H264_MAX_NUM_LIST_REF, settings, "int8_t[STD_VIDEO_H264_MAX_NUM_LIST_REF]", "int8_t", "luma_weight_l0", false, false, indents + 1, dump_json_int8_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const int8_t>(object.luma_offset_l0, STD_VIDEO_H264_MAX_NUM_LIST_REF, settings, "int8_t[STD_VIDEO_H264_MAX_NUM_LIST_REF]", "int8_t", "luma_offset_l0", false, false, indents + 1, dump_json_int8_t); // IQA
    settings.stream() << ",\n";
    settings.stream() << ",\n";
    settings.stream() << ",\n";
    dump_json_array<const int8_t>(object.luma_weight_l1, STD_VIDEO_H264_MAX_NUM_LIST_REF, settings, "int8_t[STD_VIDEO_H264_MAX_NUM_LIST_REF]", "int8_t", "luma_weight_l1", false, false, indents + 1, dump_json_int8_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const int8_t>(object.luma_offset_l1, STD_VIDEO_H264_MAX_NUM_LIST_REF, settings, "int8_t[STD_VIDEO_H264_MAX_NUM_LIST_REF]", "int8_t", "luma_offset_l1", false, false, indents + 1, dump_json_int8_t); // IQA
    settings.stream() << ",\n";
    settings.stream() << ",\n";
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoEncodeH264SliceHeaderFlags(const StdVideoEncodeH264SliceHeaderFlags& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.direct_spatial_mv_pred_flag, NULL, settings, "uint32_t", "direct_spatial_mv_pred_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.num_ref_idx_active_override_flag, NULL, settings, "uint32_t", "num_ref_idx_active_override_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.no_output_of_prior_pics_flag, NULL, settings, "uint32_t", "no_output_of_prior_pics_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.adaptive_ref_pic_marking_mode_flag, NULL, settings, "uint32_t", "adaptive_ref_pic_marking_mode_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.no_prior_references_available_flag, NULL, settings, "uint32_t", "no_prior_references_available_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoEncodeH264PictureInfoFlags(const StdVideoEncodeH264PictureInfoFlags& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.idr_flag, NULL, settings, "uint32_t", "idr_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.is_reference_flag, NULL, settings, "uint32_t", "is_reference_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.used_for_long_term_reference, NULL, settings, "uint32_t", "used_for_long_term_reference", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoEncodeH264ReferenceInfoFlags(const StdVideoEncodeH264ReferenceInfoFlags& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.used_for_long_term_reference, NULL, settings, "uint32_t", "used_for_long_term_reference", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoEncodeH264ReferenceListsInfoFlags(const StdVideoEncodeH264ReferenceListsInfoFlags& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.ref_pic_list_modification_flag_l0, NULL, settings, "uint32_t", "ref_pic_list_modification_flag_l0", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.ref_pic_list_modification_flag_l1, NULL, settings, "uint32_t", "ref_pic_list_modification_flag_l1", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoEncodeH264RefListModEntry(const StdVideoEncodeH264RefListModEntry& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoH264ModificationOfPicNumsIdc>(object.modification_of_pic_nums_idc, NULL, settings, "StdVideoH264ModificationOfPicNumsIdc", "modification_of_pic_nums_idc", false, false, indents + 1, dump_json_StdVideoH264ModificationOfPicNumsIdc);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.abs_diff_pic_num_minus1, NULL, settings, "uint16_t", "abs_diff_pic_num_minus1", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.long_term_pic_num, NULL, settings, "uint16_t", "long_term_pic_num", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoEncodeH264RefPicMarkingEntry(const StdVideoEncodeH264RefPicMarkingEntry& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoH264MemMgmtControlOp>(object.operation, NULL, settings, "StdVideoH264MemMgmtControlOp", "operation", false, false, indents + 1, dump_json_StdVideoH264MemMgmtControlOp);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.difference_of_pic_nums_minus1, NULL, settings, "uint16_t", "difference_of_pic_nums_minus1", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.long_term_pic_num, NULL, settings, "uint16_t", "long_term_pic_num", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.long_term_frame_idx, NULL, settings, "uint16_t", "long_term_frame_idx", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.max_long_term_frame_idx_plus1, NULL, settings, "uint16_t", "max_long_term_frame_idx_plus1", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoEncodeH264ReferenceListsInfo(const StdVideoEncodeH264ReferenceListsInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoEncodeH264ReferenceListsInfoFlags>(object.flags, NULL, settings, "StdVideoEncodeH264ReferenceListsInfoFlags", "flags", true, false, indents + 1, dump_json_StdVideoEncodeH264ReferenceListsInfoFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.refPicList0EntryCount, NULL, settings, "uint8_t", "refPicList0EntryCount", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.refPicList1EntryCount, NULL, settings, "uint8_t", "refPicList1EntryCount", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.refList0ModOpCount, NULL, settings, "uint8_t", "refList0ModOpCount", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.refList1ModOpCount, NULL, settings, "uint8_t", "refList1ModOpCount", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.refPicMarkingOpCount, NULL, settings, "uint8_t", "refPicMarkingOpCount", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_array<const uint8_t>(object.reserved1, 7, settings, "uint8_t[7]", "uint8_t", "reserved1", false, false, indents + 1, dump_json_uint8_t); // IQA
    settings.stream() << ",\n";
    dump_json_pointer<const uint8_t>(object.pRefPicList0Entries, settings, "const uint8_t*", "pRefPicList0Entries", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_pointer<const uint8_t>(object.pRefPicList1Entries, settings, "const uint8_t*", "pRefPicList1Entries", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoEncodeH264RefListModEntry>(object.pRefList0ModOperations, settings, "const StdVideoEncodeH264RefListModEntry*", "pRefList0ModOperations", true, false, indents + 1, dump_json_StdVideoEncodeH264RefListModEntry);
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoEncodeH264RefListModEntry>(object.pRefList1ModOperations, settings, "const StdVideoEncodeH264RefListModEntry*", "pRefList1ModOperations", true, false, indents + 1, dump_json_StdVideoEncodeH264RefListModEntry);
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoEncodeH264RefPicMarkingEntry>(object.pRefPicMarkingOperations, settings, "const StdVideoEncodeH264RefPicMarkingEntry*", "pRefPicMarkingOperations", true, false, indents + 1, dump_json_StdVideoEncodeH264RefPicMarkingEntry);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoEncodeH264PictureInfo(const StdVideoEncodeH264PictureInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoEncodeH264PictureInfoFlags>(object.flags, NULL, settings, "StdVideoEncodeH264PictureInfoFlags", "flags", true, false, indents + 1, dump_json_StdVideoEncodeH264PictureInfoFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.seq_parameter_set_id, NULL, settings, "uint8_t", "seq_parameter_set_id", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.pic_parameter_set_id, NULL, settings, "uint8_t", "pic_parameter_set_id", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.reserved1, NULL, settings, "uint16_t", "reserved1", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const StdVideoH264PictureType>(object.pictureType, NULL, settings, "StdVideoH264PictureType", "pictureType", false, false, indents + 1, dump_json_StdVideoH264PictureType);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.frame_num, NULL, settings, "uint32_t", "frame_num", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const int32_t>(object.PicOrderCnt, NULL, settings, "int32_t", "PicOrderCnt", false, false, indents + 1, dump_json_int32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoEncodeH264ReferenceInfo(const StdVideoEncodeH264ReferenceInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoEncodeH264ReferenceInfoFlags>(object.flags, NULL, settings, "StdVideoEncodeH264ReferenceInfoFlags", "flags", true, false, indents + 1, dump_json_StdVideoEncodeH264ReferenceInfoFlags);
    settings.stream() << ",\n";
    dump_json_value<const StdVideoH264PictureType>(object.pictureType, NULL, settings, "StdVideoH264PictureType", "pictureType", false, false, indents + 1, dump_json_StdVideoH264PictureType);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.FrameNum, NULL, settings, "uint32_t", "FrameNum", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const int32_t>(object.PicOrderCnt, NULL, settings, "int32_t", "PicOrderCnt", false, false, indents + 1, dump_json_int32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.long_term_pic_num, NULL, settings, "uint16_t", "long_term_pic_num", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.long_term_frame_idx, NULL, settings, "uint16_t", "long_term_frame_idx", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoEncodeH264SliceHeader(const StdVideoEncodeH264SliceHeader& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoEncodeH264SliceHeaderFlags>(object.flags, NULL, settings, "StdVideoEncodeH264SliceHeaderFlags", "flags", true, false, indents + 1, dump_json_StdVideoEncodeH264SliceHeaderFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.first_mb_in_slice, NULL, settings, "uint32_t", "first_mb_in_slice", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const StdVideoH264SliceType>(object.slice_type, NULL, settings, "StdVideoH264SliceType", "slice_type", false, false, indents + 1, dump_json_StdVideoH264SliceType);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.idr_pic_id, NULL, settings, "uint16_t", "idr_pic_id", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.num_ref_idx_l0_active_minus1, NULL, settings, "uint8_t", "num_ref_idx_l0_active_minus1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.num_ref_idx_l1_active_minus1, NULL, settings, "uint8_t", "num_ref_idx_l1_active_minus1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const StdVideoH264CabacInitIdc>(object.cabac_init_idc, NULL, settings, "StdVideoH264CabacInitIdc", "cabac_init_idc", false, false, indents + 1, dump_json_StdVideoH264CabacInitIdc);
    settings.stream() << ",\n";
    dump_json_value<const StdVideoH264DisableDeblockingFilterIdc>(object.disable_deblocking_filter_idc, NULL, settings, "StdVideoH264DisableDeblockingFilterIdc", "disable_deblocking_filter_idc", false, false, indents + 1, dump_json_StdVideoH264DisableDeblockingFilterIdc);
    settings.stream() << ",\n";
    dump_json_value<const int8_t>(object.slice_alpha_c0_offset_div2, NULL, settings, "int8_t", "slice_alpha_c0_offset_div2", false, false, indents + 1, dump_json_int8_t);
    settings.stream() << ",\n";
    dump_json_value<const int8_t>(object.slice_beta_offset_div2, NULL, settings, "int8_t", "slice_beta_offset_div2", false, false, indents + 1, dump_json_int8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.reserved1, NULL, settings, "uint16_t", "reserved1", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.reserved2, NULL, settings, "uint32_t", "reserved2", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoEncodeH264WeightTable>(object.pWeightTable, settings, "const StdVideoEncodeH264WeightTable*", "pWeightTable", true, false, indents + 1, dump_json_StdVideoEncodeH264WeightTable);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH265DecPicBufMgr(const StdVideoH265DecPicBufMgr& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_array<const uint32_t>(object.max_latency_increase_plus1, STD_VIDEO_H265_SUBLAYERS_LIST_SIZE, settings, "uint32_t[STD_VIDEO_H265_SUBLAYERS_LIST_SIZE]", "uint32_t", "max_latency_increase_plus1", false, false, indents + 1, dump_json_uint32_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const uint8_t>(object.max_dec_pic_buffering_minus1, STD_VIDEO_H265_SUBLAYERS_LIST_SIZE, settings, "uint8_t[STD_VIDEO_H265_SUBLAYERS_LIST_SIZE]", "uint8_t", "max_dec_pic_buffering_minus1", false, false, indents + 1, dump_json_uint8_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const uint8_t>(object.max_num_reorder_pics, STD_VIDEO_H265_SUBLAYERS_LIST_SIZE, settings, "uint8_t[STD_VIDEO_H265_SUBLAYERS_LIST_SIZE]", "uint8_t", "max_num_reorder_pics", false, false, indents + 1, dump_json_uint8_t); // IQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH265SubLayerHrdParameters(const StdVideoH265SubLayerHrdParameters& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_array<const uint32_t>(object.bit_rate_value_minus1, STD_VIDEO_H265_CPB_CNT_LIST_SIZE, settings, "uint32_t[STD_VIDEO_H265_CPB_CNT_LIST_SIZE]", "uint32_t", "bit_rate_value_minus1", false, false, indents + 1, dump_json_uint32_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const uint32_t>(object.cpb_size_value_minus1, STD_VIDEO_H265_CPB_CNT_LIST_SIZE, settings, "uint32_t[STD_VIDEO_H265_CPB_CNT_LIST_SIZE]", "uint32_t", "cpb_size_value_minus1", false, false, indents + 1, dump_json_uint32_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const uint32_t>(object.cpb_size_du_value_minus1, STD_VIDEO_H265_CPB_CNT_LIST_SIZE, settings, "uint32_t[STD_VIDEO_H265_CPB_CNT_LIST_SIZE]", "uint32_t", "cpb_size_du_value_minus1", false, false, indents + 1, dump_json_uint32_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const uint32_t>(object.bit_rate_du_value_minus1, STD_VIDEO_H265_CPB_CNT_LIST_SIZE, settings, "uint32_t[STD_VIDEO_H265_CPB_CNT_LIST_SIZE]", "uint32_t", "bit_rate_du_value_minus1", false, false, indents + 1, dump_json_uint32_t); // IQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.cbr_flag, NULL, settings, "uint32_t", "cbr_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH265HrdFlags(const StdVideoH265HrdFlags& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.nal_hrd_parameters_present_flag, NULL, settings, "uint32_t", "nal_hrd_parameters_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.vcl_hrd_parameters_present_flag, NULL, settings, "uint32_t", "vcl_hrd_parameters_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.sub_pic_hrd_params_present_flag, NULL, settings, "uint32_t", "sub_pic_hrd_params_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.sub_pic_cpb_params_in_pic_timing_sei_flag, NULL, settings, "uint32_t", "sub_pic_cpb_params_in_pic_timing_sei_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.fixed_pic_rate_general_flag, NULL, settings, "uint32_t", "fixed_pic_rate_general_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.fixed_pic_rate_within_cvs_flag, NULL, settings, "uint32_t", "fixed_pic_rate_within_cvs_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.low_delay_hrd_flag, NULL, settings, "uint32_t", "low_delay_hrd_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH265HrdParameters(const StdVideoH265HrdParameters& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoH265HrdFlags>(object.flags, NULL, settings, "StdVideoH265HrdFlags", "flags", true, false, indents + 1, dump_json_StdVideoH265HrdFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.tick_divisor_minus2, NULL, settings, "uint8_t", "tick_divisor_minus2", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.du_cpb_removal_delay_increment_length_minus1, NULL, settings, "uint8_t", "du_cpb_removal_delay_increment_length_minus1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.dpb_output_delay_du_length_minus1, NULL, settings, "uint8_t", "dpb_output_delay_du_length_minus1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.bit_rate_scale, NULL, settings, "uint8_t", "bit_rate_scale", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.cpb_size_scale, NULL, settings, "uint8_t", "cpb_size_scale", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.cpb_size_du_scale, NULL, settings, "uint8_t", "cpb_size_du_scale", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.initial_cpb_removal_delay_length_minus1, NULL, settings, "uint8_t", "initial_cpb_removal_delay_length_minus1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.au_cpb_removal_delay_length_minus1, NULL, settings, "uint8_t", "au_cpb_removal_delay_length_minus1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.dpb_output_delay_length_minus1, NULL, settings, "uint8_t", "dpb_output_delay_length_minus1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_array<const uint8_t>(object.cpb_cnt_minus1, STD_VIDEO_H265_SUBLAYERS_LIST_SIZE, settings, "uint8_t[STD_VIDEO_H265_SUBLAYERS_LIST_SIZE]", "uint8_t", "cpb_cnt_minus1", false, false, indents + 1, dump_json_uint8_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const uint16_t>(object.elemental_duration_in_tc_minus1, STD_VIDEO_H265_SUBLAYERS_LIST_SIZE, settings, "uint16_t[STD_VIDEO_H265_SUBLAYERS_LIST_SIZE]", "uint16_t", "elemental_duration_in_tc_minus1", false, false, indents + 1, dump_json_uint16_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const uint16_t>(object.reserved, 3, settings, "uint16_t[3]", "uint16_t", "reserved", false, false, indents + 1, dump_json_uint16_t); // IQA
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoH265SubLayerHrdParameters>(object.pSubLayerHrdParametersNal, settings, "const StdVideoH265SubLayerHrdParameters*", "pSubLayerHrdParametersNal", true, false, indents + 1, dump_json_StdVideoH265SubLayerHrdParameters);
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoH265SubLayerHrdParameters>(object.pSubLayerHrdParametersVcl, settings, "const StdVideoH265SubLayerHrdParameters*", "pSubLayerHrdParametersVcl", true, false, indents + 1, dump_json_StdVideoH265SubLayerHrdParameters);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH265VpsFlags(const StdVideoH265VpsFlags& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.vps_temporal_id_nesting_flag, NULL, settings, "uint32_t", "vps_temporal_id_nesting_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.vps_sub_layer_ordering_info_present_flag, NULL, settings, "uint32_t", "vps_sub_layer_ordering_info_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.vps_timing_info_present_flag, NULL, settings, "uint32_t", "vps_timing_info_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.vps_poc_proportional_to_timing_flag, NULL, settings, "uint32_t", "vps_poc_proportional_to_timing_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH265ProfileTierLevelFlags(const StdVideoH265ProfileTierLevelFlags& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.general_tier_flag, NULL, settings, "uint32_t", "general_tier_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.general_progressive_source_flag, NULL, settings, "uint32_t", "general_progressive_source_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.general_interlaced_source_flag, NULL, settings, "uint32_t", "general_interlaced_source_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.general_non_packed_constraint_flag, NULL, settings, "uint32_t", "general_non_packed_constraint_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.general_frame_only_constraint_flag, NULL, settings, "uint32_t", "general_frame_only_constraint_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH265ProfileTierLevel(const StdVideoH265ProfileTierLevel& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoH265ProfileTierLevelFlags>(object.flags, NULL, settings, "StdVideoH265ProfileTierLevelFlags", "flags", true, false, indents + 1, dump_json_StdVideoH265ProfileTierLevelFlags);
    settings.stream() << ",\n";
    dump_json_value<const StdVideoH265ProfileIdc>(object.general_profile_idc, NULL, settings, "StdVideoH265ProfileIdc", "general_profile_idc", false, false, indents + 1, dump_json_StdVideoH265ProfileIdc);
    settings.stream() << ",\n";
    dump_json_value<const StdVideoH265LevelIdc>(object.general_level_idc, NULL, settings, "StdVideoH265LevelIdc", "general_level_idc", false, false, indents + 1, dump_json_StdVideoH265LevelIdc);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH265VideoParameterSet(const StdVideoH265VideoParameterSet& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoH265VpsFlags>(object.flags, NULL, settings, "StdVideoH265VpsFlags", "flags", true, false, indents + 1, dump_json_StdVideoH265VpsFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.vps_video_parameter_set_id, NULL, settings, "uint8_t", "vps_video_parameter_set_id", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.vps_max_sub_layers_minus1, NULL, settings, "uint8_t", "vps_max_sub_layers_minus1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.reserved1, NULL, settings, "uint8_t", "reserved1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.reserved2, NULL, settings, "uint8_t", "reserved2", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.vps_num_units_in_tick, NULL, settings, "uint32_t", "vps_num_units_in_tick", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.vps_time_scale, NULL, settings, "uint32_t", "vps_time_scale", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.vps_num_ticks_poc_diff_one_minus1, NULL, settings, "uint32_t", "vps_num_ticks_poc_diff_one_minus1", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.reserved3, NULL, settings, "uint32_t", "reserved3", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoH265DecPicBufMgr>(object.pDecPicBufMgr, settings, "const StdVideoH265DecPicBufMgr*", "pDecPicBufMgr", true, false, indents + 1, dump_json_StdVideoH265DecPicBufMgr);
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoH265HrdParameters>(object.pHrdParameters, settings, "const StdVideoH265HrdParameters*", "pHrdParameters", true, false, indents + 1, dump_json_StdVideoH265HrdParameters);
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoH265ProfileTierLevel>(object.pProfileTierLevel, settings, "const StdVideoH265ProfileTierLevel*", "pProfileTierLevel", true, false, indents + 1, dump_json_StdVideoH265ProfileTierLevel);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH265ScalingLists(const StdVideoH265ScalingLists& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    settings.stream() << ",\n";
    settings.stream() << ",\n";
    settings.stream() << ",\n";
    settings.stream() << ",\n";
    dump_json_array<const uint8_t>(object.ScalingListDCCoef16x16, STD_VIDEO_H265_SCALING_LIST_16X16_NUM_LISTS, settings, "uint8_t[STD_VIDEO_H265_SCALING_LIST_16X16_NUM_LISTS]", "uint8_t", "ScalingListDCCoef16x16", false, false, indents + 1, dump_json_uint8_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const uint8_t>(object.ScalingListDCCoef32x32, STD_VIDEO_H265_SCALING_LIST_32X32_NUM_LISTS, settings, "uint8_t[STD_VIDEO_H265_SCALING_LIST_32X32_NUM_LISTS]", "uint8_t", "ScalingListDCCoef32x32", false, false, indents + 1, dump_json_uint8_t); // IQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH265SpsVuiFlags(const StdVideoH265SpsVuiFlags& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.aspect_ratio_info_present_flag, NULL, settings, "uint32_t", "aspect_ratio_info_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.overscan_info_present_flag, NULL, settings, "uint32_t", "overscan_info_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.overscan_appropriate_flag, NULL, settings, "uint32_t", "overscan_appropriate_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.video_signal_type_present_flag, NULL, settings, "uint32_t", "video_signal_type_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.video_full_range_flag, NULL, settings, "uint32_t", "video_full_range_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.colour_description_present_flag, NULL, settings, "uint32_t", "colour_description_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.chroma_loc_info_present_flag, NULL, settings, "uint32_t", "chroma_loc_info_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.neutral_chroma_indication_flag, NULL, settings, "uint32_t", "neutral_chroma_indication_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.field_seq_flag, NULL, settings, "uint32_t", "field_seq_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.frame_field_info_present_flag, NULL, settings, "uint32_t", "frame_field_info_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.default_display_window_flag, NULL, settings, "uint32_t", "default_display_window_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.vui_timing_info_present_flag, NULL, settings, "uint32_t", "vui_timing_info_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.vui_poc_proportional_to_timing_flag, NULL, settings, "uint32_t", "vui_poc_proportional_to_timing_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.vui_hrd_parameters_present_flag, NULL, settings, "uint32_t", "vui_hrd_parameters_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.bitstream_restriction_flag, NULL, settings, "uint32_t", "bitstream_restriction_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.tiles_fixed_structure_flag, NULL, settings, "uint32_t", "tiles_fixed_structure_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.motion_vectors_over_pic_boundaries_flag, NULL, settings, "uint32_t", "motion_vectors_over_pic_boundaries_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.restricted_ref_pic_lists_flag, NULL, settings, "uint32_t", "restricted_ref_pic_lists_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH265SequenceParameterSetVui(const StdVideoH265SequenceParameterSetVui& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoH265SpsVuiFlags>(object.flags, NULL, settings, "StdVideoH265SpsVuiFlags", "flags", true, false, indents + 1, dump_json_StdVideoH265SpsVuiFlags);
    settings.stream() << ",\n";
    dump_json_value<const StdVideoH265AspectRatioIdc>(object.aspect_ratio_idc, NULL, settings, "StdVideoH265AspectRatioIdc", "aspect_ratio_idc", false, false, indents + 1, dump_json_StdVideoH265AspectRatioIdc);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.sar_width, NULL, settings, "uint16_t", "sar_width", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.sar_height, NULL, settings, "uint16_t", "sar_height", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.video_format, NULL, settings, "uint8_t", "video_format", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.colour_primaries, NULL, settings, "uint8_t", "colour_primaries", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.transfer_characteristics, NULL, settings, "uint8_t", "transfer_characteristics", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.matrix_coeffs, NULL, settings, "uint8_t", "matrix_coeffs", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.chroma_sample_loc_type_top_field, NULL, settings, "uint8_t", "chroma_sample_loc_type_top_field", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.chroma_sample_loc_type_bottom_field, NULL, settings, "uint8_t", "chroma_sample_loc_type_bottom_field", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.reserved1, NULL, settings, "uint8_t", "reserved1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.reserved2, NULL, settings, "uint8_t", "reserved2", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.def_disp_win_left_offset, NULL, settings, "uint16_t", "def_disp_win_left_offset", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.def_disp_win_right_offset, NULL, settings, "uint16_t", "def_disp_win_right_offset", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.def_disp_win_top_offset, NULL, settings, "uint16_t", "def_disp_win_top_offset", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.def_disp_win_bottom_offset, NULL, settings, "uint16_t", "def_disp_win_bottom_offset", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.vui_num_units_in_tick, NULL, settings, "uint32_t", "vui_num_units_in_tick", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.vui_time_scale, NULL, settings, "uint32_t", "vui_time_scale", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.vui_num_ticks_poc_diff_one_minus1, NULL, settings, "uint32_t", "vui_num_ticks_poc_diff_one_minus1", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.min_spatial_segmentation_idc, NULL, settings, "uint16_t", "min_spatial_segmentation_idc", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.reserved3, NULL, settings, "uint16_t", "reserved3", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.max_bytes_per_pic_denom, NULL, settings, "uint8_t", "max_bytes_per_pic_denom", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.max_bits_per_min_cu_denom, NULL, settings, "uint8_t", "max_bits_per_min_cu_denom", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.log2_max_mv_length_horizontal, NULL, settings, "uint8_t", "log2_max_mv_length_horizontal", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.log2_max_mv_length_vertical, NULL, settings, "uint8_t", "log2_max_mv_length_vertical", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoH265HrdParameters>(object.pHrdParameters, settings, "const StdVideoH265HrdParameters*", "pHrdParameters", true, false, indents + 1, dump_json_StdVideoH265HrdParameters);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH265PredictorPaletteEntries(const StdVideoH265PredictorPaletteEntries& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH265SpsFlags(const StdVideoH265SpsFlags& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.sps_temporal_id_nesting_flag, NULL, settings, "uint32_t", "sps_temporal_id_nesting_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.separate_colour_plane_flag, NULL, settings, "uint32_t", "separate_colour_plane_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.conformance_window_flag, NULL, settings, "uint32_t", "conformance_window_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.sps_sub_layer_ordering_info_present_flag, NULL, settings, "uint32_t", "sps_sub_layer_ordering_info_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.scaling_list_enabled_flag, NULL, settings, "uint32_t", "scaling_list_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.sps_scaling_list_data_present_flag, NULL, settings, "uint32_t", "sps_scaling_list_data_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.amp_enabled_flag, NULL, settings, "uint32_t", "amp_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.sample_adaptive_offset_enabled_flag, NULL, settings, "uint32_t", "sample_adaptive_offset_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.pcm_enabled_flag, NULL, settings, "uint32_t", "pcm_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.pcm_loop_filter_disabled_flag, NULL, settings, "uint32_t", "pcm_loop_filter_disabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.long_term_ref_pics_present_flag, NULL, settings, "uint32_t", "long_term_ref_pics_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.sps_temporal_mvp_enabled_flag, NULL, settings, "uint32_t", "sps_temporal_mvp_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.strong_intra_smoothing_enabled_flag, NULL, settings, "uint32_t", "strong_intra_smoothing_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.vui_parameters_present_flag, NULL, settings, "uint32_t", "vui_parameters_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.sps_extension_present_flag, NULL, settings, "uint32_t", "sps_extension_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.sps_range_extension_flag, NULL, settings, "uint32_t", "sps_range_extension_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.transform_skip_rotation_enabled_flag, NULL, settings, "uint32_t", "transform_skip_rotation_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.transform_skip_context_enabled_flag, NULL, settings, "uint32_t", "transform_skip_context_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.implicit_rdpcm_enabled_flag, NULL, settings, "uint32_t", "implicit_rdpcm_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.explicit_rdpcm_enabled_flag, NULL, settings, "uint32_t", "explicit_rdpcm_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.extended_precision_processing_flag, NULL, settings, "uint32_t", "extended_precision_processing_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.intra_smoothing_disabled_flag, NULL, settings, "uint32_t", "intra_smoothing_disabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.high_precision_offsets_enabled_flag, NULL, settings, "uint32_t", "high_precision_offsets_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.persistent_rice_adaptation_enabled_flag, NULL, settings, "uint32_t", "persistent_rice_adaptation_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.cabac_bypass_alignment_enabled_flag, NULL, settings, "uint32_t", "cabac_bypass_alignment_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.sps_scc_extension_flag, NULL, settings, "uint32_t", "sps_scc_extension_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.sps_curr_pic_ref_enabled_flag, NULL, settings, "uint32_t", "sps_curr_pic_ref_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.palette_mode_enabled_flag, NULL, settings, "uint32_t", "palette_mode_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.sps_palette_predictor_initializers_present_flag, NULL, settings, "uint32_t", "sps_palette_predictor_initializers_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.intra_boundary_filtering_disabled_flag, NULL, settings, "uint32_t", "intra_boundary_filtering_disabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH265ShortTermRefPicSetFlags(const StdVideoH265ShortTermRefPicSetFlags& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.inter_ref_pic_set_prediction_flag, NULL, settings, "uint32_t", "inter_ref_pic_set_prediction_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.delta_rps_sign, NULL, settings, "uint32_t", "delta_rps_sign", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH265ShortTermRefPicSet(const StdVideoH265ShortTermRefPicSet& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoH265ShortTermRefPicSetFlags>(object.flags, NULL, settings, "StdVideoH265ShortTermRefPicSetFlags", "flags", true, false, indents + 1, dump_json_StdVideoH265ShortTermRefPicSetFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.delta_idx_minus1, NULL, settings, "uint32_t", "delta_idx_minus1", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.use_delta_flag, NULL, settings, "uint16_t", "use_delta_flag", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.abs_delta_rps_minus1, NULL, settings, "uint16_t", "abs_delta_rps_minus1", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.used_by_curr_pic_flag, NULL, settings, "uint16_t", "used_by_curr_pic_flag", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.used_by_curr_pic_s0_flag, NULL, settings, "uint16_t", "used_by_curr_pic_s0_flag", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.used_by_curr_pic_s1_flag, NULL, settings, "uint16_t", "used_by_curr_pic_s1_flag", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.reserved1, NULL, settings, "uint16_t", "reserved1", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.reserved2, NULL, settings, "uint8_t", "reserved2", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.reserved3, NULL, settings, "uint8_t", "reserved3", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.num_negative_pics, NULL, settings, "uint8_t", "num_negative_pics", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.num_positive_pics, NULL, settings, "uint8_t", "num_positive_pics", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_array<const uint16_t>(object.delta_poc_s0_minus1, STD_VIDEO_H265_MAX_DPB_SIZE, settings, "uint16_t[STD_VIDEO_H265_MAX_DPB_SIZE]", "uint16_t", "delta_poc_s0_minus1", false, false, indents + 1, dump_json_uint16_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const uint16_t>(object.delta_poc_s1_minus1, STD_VIDEO_H265_MAX_DPB_SIZE, settings, "uint16_t[STD_VIDEO_H265_MAX_DPB_SIZE]", "uint16_t", "delta_poc_s1_minus1", false, false, indents + 1, dump_json_uint16_t); // IQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH265LongTermRefPicsSps(const StdVideoH265LongTermRefPicsSps& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.used_by_curr_pic_lt_sps_flag, NULL, settings, "uint32_t", "used_by_curr_pic_lt_sps_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const uint32_t>(object.lt_ref_pic_poc_lsb_sps, STD_VIDEO_H265_MAX_LONG_TERM_REF_PICS_SPS, settings, "uint32_t[STD_VIDEO_H265_MAX_LONG_TERM_REF_PICS_SPS]", "uint32_t", "lt_ref_pic_poc_lsb_sps", false, false, indents + 1, dump_json_uint32_t); // IQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH265SequenceParameterSet(const StdVideoH265SequenceParameterSet& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoH265SpsFlags>(object.flags, NULL, settings, "StdVideoH265SpsFlags", "flags", true, false, indents + 1, dump_json_StdVideoH265SpsFlags);
    settings.stream() << ",\n";
    dump_json_value<const StdVideoH265ChromaFormatIdc>(object.chroma_format_idc, NULL, settings, "StdVideoH265ChromaFormatIdc", "chroma_format_idc", false, false, indents + 1, dump_json_StdVideoH265ChromaFormatIdc);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.pic_width_in_luma_samples, NULL, settings, "uint32_t", "pic_width_in_luma_samples", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.pic_height_in_luma_samples, NULL, settings, "uint32_t", "pic_height_in_luma_samples", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.sps_video_parameter_set_id, NULL, settings, "uint8_t", "sps_video_parameter_set_id", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.sps_max_sub_layers_minus1, NULL, settings, "uint8_t", "sps_max_sub_layers_minus1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.sps_seq_parameter_set_id, NULL, settings, "uint8_t", "sps_seq_parameter_set_id", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.bit_depth_luma_minus8, NULL, settings, "uint8_t", "bit_depth_luma_minus8", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.bit_depth_chroma_minus8, NULL, settings, "uint8_t", "bit_depth_chroma_minus8", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.log2_max_pic_order_cnt_lsb_minus4, NULL, settings, "uint8_t", "log2_max_pic_order_cnt_lsb_minus4", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.log2_min_luma_coding_block_size_minus3, NULL, settings, "uint8_t", "log2_min_luma_coding_block_size_minus3", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.log2_diff_max_min_luma_coding_block_size, NULL, settings, "uint8_t", "log2_diff_max_min_luma_coding_block_size", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.log2_min_luma_transform_block_size_minus2, NULL, settings, "uint8_t", "log2_min_luma_transform_block_size_minus2", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.log2_diff_max_min_luma_transform_block_size, NULL, settings, "uint8_t", "log2_diff_max_min_luma_transform_block_size", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.max_transform_hierarchy_depth_inter, NULL, settings, "uint8_t", "max_transform_hierarchy_depth_inter", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.max_transform_hierarchy_depth_intra, NULL, settings, "uint8_t", "max_transform_hierarchy_depth_intra", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.num_short_term_ref_pic_sets, NULL, settings, "uint8_t", "num_short_term_ref_pic_sets", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.num_long_term_ref_pics_sps, NULL, settings, "uint8_t", "num_long_term_ref_pics_sps", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.pcm_sample_bit_depth_luma_minus1, NULL, settings, "uint8_t", "pcm_sample_bit_depth_luma_minus1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.pcm_sample_bit_depth_chroma_minus1, NULL, settings, "uint8_t", "pcm_sample_bit_depth_chroma_minus1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.log2_min_pcm_luma_coding_block_size_minus3, NULL, settings, "uint8_t", "log2_min_pcm_luma_coding_block_size_minus3", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.log2_diff_max_min_pcm_luma_coding_block_size, NULL, settings, "uint8_t", "log2_diff_max_min_pcm_luma_coding_block_size", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.reserved1, NULL, settings, "uint8_t", "reserved1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.reserved2, NULL, settings, "uint8_t", "reserved2", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.palette_max_size, NULL, settings, "uint8_t", "palette_max_size", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.delta_palette_max_predictor_size, NULL, settings, "uint8_t", "delta_palette_max_predictor_size", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.motion_vector_resolution_control_idc, NULL, settings, "uint8_t", "motion_vector_resolution_control_idc", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.sps_num_palette_predictor_initializers_minus1, NULL, settings, "uint8_t", "sps_num_palette_predictor_initializers_minus1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.conf_win_left_offset, NULL, settings, "uint32_t", "conf_win_left_offset", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.conf_win_right_offset, NULL, settings, "uint32_t", "conf_win_right_offset", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.conf_win_top_offset, NULL, settings, "uint32_t", "conf_win_top_offset", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.conf_win_bottom_offset, NULL, settings, "uint32_t", "conf_win_bottom_offset", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoH265ProfileTierLevel>(object.pProfileTierLevel, settings, "const StdVideoH265ProfileTierLevel*", "pProfileTierLevel", true, false, indents + 1, dump_json_StdVideoH265ProfileTierLevel);
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoH265DecPicBufMgr>(object.pDecPicBufMgr, settings, "const StdVideoH265DecPicBufMgr*", "pDecPicBufMgr", true, false, indents + 1, dump_json_StdVideoH265DecPicBufMgr);
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoH265ScalingLists>(object.pScalingLists, settings, "const StdVideoH265ScalingLists*", "pScalingLists", true, false, indents + 1, dump_json_StdVideoH265ScalingLists);
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoH265ShortTermRefPicSet>(object.pShortTermRefPicSet, settings, "const StdVideoH265ShortTermRefPicSet*", "pShortTermRefPicSet", true, false, indents + 1, dump_json_StdVideoH265ShortTermRefPicSet);
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoH265LongTermRefPicsSps>(object.pLongTermRefPicsSps, settings, "const StdVideoH265LongTermRefPicsSps*", "pLongTermRefPicsSps", true, false, indents + 1, dump_json_StdVideoH265LongTermRefPicsSps);
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoH265SequenceParameterSetVui>(object.pSequenceParameterSetVui, settings, "const StdVideoH265SequenceParameterSetVui*", "pSequenceParameterSetVui", true, false, indents + 1, dump_json_StdVideoH265SequenceParameterSetVui);
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoH265PredictorPaletteEntries>(object.pPredictorPaletteEntries, settings, "const StdVideoH265PredictorPaletteEntries*", "pPredictorPaletteEntries", true, false, indents + 1, dump_json_StdVideoH265PredictorPaletteEntries);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH265PpsFlags(const StdVideoH265PpsFlags& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.dependent_slice_segments_enabled_flag, NULL, settings, "uint32_t", "dependent_slice_segments_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.output_flag_present_flag, NULL, settings, "uint32_t", "output_flag_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.sign_data_hiding_enabled_flag, NULL, settings, "uint32_t", "sign_data_hiding_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.cabac_init_present_flag, NULL, settings, "uint32_t", "cabac_init_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.constrained_intra_pred_flag, NULL, settings, "uint32_t", "constrained_intra_pred_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.transform_skip_enabled_flag, NULL, settings, "uint32_t", "transform_skip_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.cu_qp_delta_enabled_flag, NULL, settings, "uint32_t", "cu_qp_delta_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.pps_slice_chroma_qp_offsets_present_flag, NULL, settings, "uint32_t", "pps_slice_chroma_qp_offsets_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.weighted_pred_flag, NULL, settings, "uint32_t", "weighted_pred_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.weighted_bipred_flag, NULL, settings, "uint32_t", "weighted_bipred_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.transquant_bypass_enabled_flag, NULL, settings, "uint32_t", "transquant_bypass_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.tiles_enabled_flag, NULL, settings, "uint32_t", "tiles_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.entropy_coding_sync_enabled_flag, NULL, settings, "uint32_t", "entropy_coding_sync_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.uniform_spacing_flag, NULL, settings, "uint32_t", "uniform_spacing_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.loop_filter_across_tiles_enabled_flag, NULL, settings, "uint32_t", "loop_filter_across_tiles_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.pps_loop_filter_across_slices_enabled_flag, NULL, settings, "uint32_t", "pps_loop_filter_across_slices_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.deblocking_filter_control_present_flag, NULL, settings, "uint32_t", "deblocking_filter_control_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.deblocking_filter_override_enabled_flag, NULL, settings, "uint32_t", "deblocking_filter_override_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.pps_deblocking_filter_disabled_flag, NULL, settings, "uint32_t", "pps_deblocking_filter_disabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.pps_scaling_list_data_present_flag, NULL, settings, "uint32_t", "pps_scaling_list_data_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.lists_modification_present_flag, NULL, settings, "uint32_t", "lists_modification_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.slice_segment_header_extension_present_flag, NULL, settings, "uint32_t", "slice_segment_header_extension_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.pps_extension_present_flag, NULL, settings, "uint32_t", "pps_extension_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.cross_component_prediction_enabled_flag, NULL, settings, "uint32_t", "cross_component_prediction_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.chroma_qp_offset_list_enabled_flag, NULL, settings, "uint32_t", "chroma_qp_offset_list_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.pps_curr_pic_ref_enabled_flag, NULL, settings, "uint32_t", "pps_curr_pic_ref_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.residual_adaptive_colour_transform_enabled_flag, NULL, settings, "uint32_t", "residual_adaptive_colour_transform_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.pps_slice_act_qp_offsets_present_flag, NULL, settings, "uint32_t", "pps_slice_act_qp_offsets_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.pps_palette_predictor_initializers_present_flag, NULL, settings, "uint32_t", "pps_palette_predictor_initializers_present_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.monochrome_palette_flag, NULL, settings, "uint32_t", "monochrome_palette_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.pps_range_extension_flag, NULL, settings, "uint32_t", "pps_range_extension_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoH265PictureParameterSet(const StdVideoH265PictureParameterSet& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoH265PpsFlags>(object.flags, NULL, settings, "StdVideoH265PpsFlags", "flags", true, false, indents + 1, dump_json_StdVideoH265PpsFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.pps_pic_parameter_set_id, NULL, settings, "uint8_t", "pps_pic_parameter_set_id", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.pps_seq_parameter_set_id, NULL, settings, "uint8_t", "pps_seq_parameter_set_id", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.sps_video_parameter_set_id, NULL, settings, "uint8_t", "sps_video_parameter_set_id", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.num_extra_slice_header_bits, NULL, settings, "uint8_t", "num_extra_slice_header_bits", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.num_ref_idx_l0_default_active_minus1, NULL, settings, "uint8_t", "num_ref_idx_l0_default_active_minus1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.num_ref_idx_l1_default_active_minus1, NULL, settings, "uint8_t", "num_ref_idx_l1_default_active_minus1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const int8_t>(object.init_qp_minus26, NULL, settings, "int8_t", "init_qp_minus26", false, false, indents + 1, dump_json_int8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.diff_cu_qp_delta_depth, NULL, settings, "uint8_t", "diff_cu_qp_delta_depth", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const int8_t>(object.pps_cb_qp_offset, NULL, settings, "int8_t", "pps_cb_qp_offset", false, false, indents + 1, dump_json_int8_t);
    settings.stream() << ",\n";
    dump_json_value<const int8_t>(object.pps_cr_qp_offset, NULL, settings, "int8_t", "pps_cr_qp_offset", false, false, indents + 1, dump_json_int8_t);
    settings.stream() << ",\n";
    dump_json_value<const int8_t>(object.pps_beta_offset_div2, NULL, settings, "int8_t", "pps_beta_offset_div2", false, false, indents + 1, dump_json_int8_t);
    settings.stream() << ",\n";
    dump_json_value<const int8_t>(object.pps_tc_offset_div2, NULL, settings, "int8_t", "pps_tc_offset_div2", false, false, indents + 1, dump_json_int8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.log2_parallel_merge_level_minus2, NULL, settings, "uint8_t", "log2_parallel_merge_level_minus2", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.log2_max_transform_skip_block_size_minus2, NULL, settings, "uint8_t", "log2_max_transform_skip_block_size_minus2", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.diff_cu_chroma_qp_offset_depth, NULL, settings, "uint8_t", "diff_cu_chroma_qp_offset_depth", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.chroma_qp_offset_list_len_minus1, NULL, settings, "uint8_t", "chroma_qp_offset_list_len_minus1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_array<const int8_t>(object.cb_qp_offset_list, STD_VIDEO_H265_CHROMA_QP_OFFSET_LIST_SIZE, settings, "int8_t[STD_VIDEO_H265_CHROMA_QP_OFFSET_LIST_SIZE]", "int8_t", "cb_qp_offset_list", false, false, indents + 1, dump_json_int8_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const int8_t>(object.cr_qp_offset_list, STD_VIDEO_H265_CHROMA_QP_OFFSET_LIST_SIZE, settings, "int8_t[STD_VIDEO_H265_CHROMA_QP_OFFSET_LIST_SIZE]", "int8_t", "cr_qp_offset_list", false, false, indents + 1, dump_json_int8_t); // IQA
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.log2_sao_offset_scale_luma, NULL, settings, "uint8_t", "log2_sao_offset_scale_luma", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.log2_sao_offset_scale_chroma, NULL, settings, "uint8_t", "log2_sao_offset_scale_chroma", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const int8_t>(object.pps_act_y_qp_offset_plus5, NULL, settings, "int8_t", "pps_act_y_qp_offset_plus5", false, false, indents + 1, dump_json_int8_t);
    settings.stream() << ",\n";
    dump_json_value<const int8_t>(object.pps_act_cb_qp_offset_plus5, NULL, settings, "int8_t", "pps_act_cb_qp_offset_plus5", false, false, indents + 1, dump_json_int8_t);
    settings.stream() << ",\n";
    dump_json_value<const int8_t>(object.pps_act_cr_qp_offset_plus3, NULL, settings, "int8_t", "pps_act_cr_qp_offset_plus3", false, false, indents + 1, dump_json_int8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.pps_num_palette_predictor_initializers, NULL, settings, "uint8_t", "pps_num_palette_predictor_initializers", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.luma_bit_depth_entry_minus8, NULL, settings, "uint8_t", "luma_bit_depth_entry_minus8", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.chroma_bit_depth_entry_minus8, NULL, settings, "uint8_t", "chroma_bit_depth_entry_minus8", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.num_tile_columns_minus1, NULL, settings, "uint8_t", "num_tile_columns_minus1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.num_tile_rows_minus1, NULL, settings, "uint8_t", "num_tile_rows_minus1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.reserved1, NULL, settings, "uint8_t", "reserved1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.reserved2, NULL, settings, "uint8_t", "reserved2", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_array<const uint16_t>(object.column_width_minus1, STD_VIDEO_H265_CHROMA_QP_OFFSET_TILE_COLS_LIST_SIZE, settings, "uint16_t[STD_VIDEO_H265_CHROMA_QP_OFFSET_TILE_COLS_LIST_SIZE]", "uint16_t", "column_width_minus1", false, false, indents + 1, dump_json_uint16_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const uint16_t>(object.row_height_minus1, STD_VIDEO_H265_CHROMA_QP_OFFSET_TILE_ROWS_LIST_SIZE, settings, "uint16_t[STD_VIDEO_H265_CHROMA_QP_OFFSET_TILE_ROWS_LIST_SIZE]", "uint16_t", "row_height_minus1", false, false, indents + 1, dump_json_uint16_t); // IQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.reserved3, NULL, settings, "uint32_t", "reserved3", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoH265ScalingLists>(object.pScalingLists, settings, "const StdVideoH265ScalingLists*", "pScalingLists", true, false, indents + 1, dump_json_StdVideoH265ScalingLists);
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoH265PredictorPaletteEntries>(object.pPredictorPaletteEntries, settings, "const StdVideoH265PredictorPaletteEntries*", "pPredictorPaletteEntries", true, false, indents + 1, dump_json_StdVideoH265PredictorPaletteEntries);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoDecodeH265PictureInfoFlags(const StdVideoDecodeH265PictureInfoFlags& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.IrapPicFlag, NULL, settings, "uint32_t", "IrapPicFlag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.IdrPicFlag, NULL, settings, "uint32_t", "IdrPicFlag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.IsReference, NULL, settings, "uint32_t", "IsReference", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.short_term_ref_pic_set_sps_flag, NULL, settings, "uint32_t", "short_term_ref_pic_set_sps_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoDecodeH265PictureInfo(const StdVideoDecodeH265PictureInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoDecodeH265PictureInfoFlags>(object.flags, NULL, settings, "StdVideoDecodeH265PictureInfoFlags", "flags", true, false, indents + 1, dump_json_StdVideoDecodeH265PictureInfoFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.sps_video_parameter_set_id, NULL, settings, "uint8_t", "sps_video_parameter_set_id", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.pps_seq_parameter_set_id, NULL, settings, "uint8_t", "pps_seq_parameter_set_id", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.pps_pic_parameter_set_id, NULL, settings, "uint8_t", "pps_pic_parameter_set_id", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.NumDeltaPocsOfRefRpsIdx, NULL, settings, "uint8_t", "NumDeltaPocsOfRefRpsIdx", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const int32_t>(object.PicOrderCntVal, NULL, settings, "int32_t", "PicOrderCntVal", false, false, indents + 1, dump_json_int32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.NumBitsForSTRefPicSetInSlice, NULL, settings, "uint16_t", "NumBitsForSTRefPicSetInSlice", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.reserved, NULL, settings, "uint16_t", "reserved", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_array<const uint8_t>(object.RefPicSetStCurrBefore, STD_VIDEO_DECODE_H265_REF_PIC_SET_LIST_SIZE, settings, "uint8_t[STD_VIDEO_DECODE_H265_REF_PIC_SET_LIST_SIZE]", "uint8_t", "RefPicSetStCurrBefore", false, false, indents + 1, dump_json_uint8_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const uint8_t>(object.RefPicSetStCurrAfter, STD_VIDEO_DECODE_H265_REF_PIC_SET_LIST_SIZE, settings, "uint8_t[STD_VIDEO_DECODE_H265_REF_PIC_SET_LIST_SIZE]", "uint8_t", "RefPicSetStCurrAfter", false, false, indents + 1, dump_json_uint8_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const uint8_t>(object.RefPicSetLtCurr, STD_VIDEO_DECODE_H265_REF_PIC_SET_LIST_SIZE, settings, "uint8_t[STD_VIDEO_DECODE_H265_REF_PIC_SET_LIST_SIZE]", "uint8_t", "RefPicSetLtCurr", false, false, indents + 1, dump_json_uint8_t); // IQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoDecodeH265ReferenceInfoFlags(const StdVideoDecodeH265ReferenceInfoFlags& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.used_for_long_term_reference, NULL, settings, "uint32_t", "used_for_long_term_reference", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.unused_for_reference, NULL, settings, "uint32_t", "unused_for_reference", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoDecodeH265ReferenceInfo(const StdVideoDecodeH265ReferenceInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoDecodeH265ReferenceInfoFlags>(object.flags, NULL, settings, "StdVideoDecodeH265ReferenceInfoFlags", "flags", true, false, indents + 1, dump_json_StdVideoDecodeH265ReferenceInfoFlags);
    settings.stream() << ",\n";
    dump_json_value<const int32_t>(object.PicOrderCntVal, NULL, settings, "int32_t", "PicOrderCntVal", false, false, indents + 1, dump_json_int32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoEncodeH265WeightTableFlags(const StdVideoEncodeH265WeightTableFlags& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint16_t>(object.luma_weight_l0_flag, NULL, settings, "uint16_t", "luma_weight_l0_flag", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.chroma_weight_l0_flag, NULL, settings, "uint16_t", "chroma_weight_l0_flag", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.luma_weight_l1_flag, NULL, settings, "uint16_t", "luma_weight_l1_flag", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.chroma_weight_l1_flag, NULL, settings, "uint16_t", "chroma_weight_l1_flag", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoEncodeH265WeightTable(const StdVideoEncodeH265WeightTable& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoEncodeH265WeightTableFlags>(object.flags, NULL, settings, "StdVideoEncodeH265WeightTableFlags", "flags", true, false, indents + 1, dump_json_StdVideoEncodeH265WeightTableFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.luma_log2_weight_denom, NULL, settings, "uint8_t", "luma_log2_weight_denom", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const int8_t>(object.delta_chroma_log2_weight_denom, NULL, settings, "int8_t", "delta_chroma_log2_weight_denom", false, false, indents + 1, dump_json_int8_t);
    settings.stream() << ",\n";
    dump_json_array<const int8_t>(object.delta_luma_weight_l0, STD_VIDEO_H265_MAX_NUM_LIST_REF, settings, "int8_t[STD_VIDEO_H265_MAX_NUM_LIST_REF]", "int8_t", "delta_luma_weight_l0", false, false, indents + 1, dump_json_int8_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const int8_t>(object.luma_offset_l0, STD_VIDEO_H265_MAX_NUM_LIST_REF, settings, "int8_t[STD_VIDEO_H265_MAX_NUM_LIST_REF]", "int8_t", "luma_offset_l0", false, false, indents + 1, dump_json_int8_t); // IQA
    settings.stream() << ",\n";
    settings.stream() << ",\n";
    settings.stream() << ",\n";
    dump_json_array<const int8_t>(object.delta_luma_weight_l1, STD_VIDEO_H265_MAX_NUM_LIST_REF, settings, "int8_t[STD_VIDEO_H265_MAX_NUM_LIST_REF]", "int8_t", "delta_luma_weight_l1", false, false, indents + 1, dump_json_int8_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const int8_t>(object.luma_offset_l1, STD_VIDEO_H265_MAX_NUM_LIST_REF, settings, "int8_t[STD_VIDEO_H265_MAX_NUM_LIST_REF]", "int8_t", "luma_offset_l1", false, false, indents + 1, dump_json_int8_t); // IQA
    settings.stream() << ",\n";
    settings.stream() << ",\n";
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoEncodeH265SliceSegmentHeaderFlags(const StdVideoEncodeH265SliceSegmentHeaderFlags& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.first_slice_segment_in_pic_flag, NULL, settings, "uint32_t", "first_slice_segment_in_pic_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.no_output_of_prior_pics_flag, NULL, settings, "uint32_t", "no_output_of_prior_pics_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.dependent_slice_segment_flag, NULL, settings, "uint32_t", "dependent_slice_segment_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.pic_output_flag, NULL, settings, "uint32_t", "pic_output_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.short_term_ref_pic_set_sps_flag, NULL, settings, "uint32_t", "short_term_ref_pic_set_sps_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.slice_temporal_mvp_enable_flag, NULL, settings, "uint32_t", "slice_temporal_mvp_enable_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.slice_sao_luma_flag, NULL, settings, "uint32_t", "slice_sao_luma_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.slice_sao_chroma_flag, NULL, settings, "uint32_t", "slice_sao_chroma_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.num_ref_idx_active_override_flag, NULL, settings, "uint32_t", "num_ref_idx_active_override_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.mvd_l1_zero_flag, NULL, settings, "uint32_t", "mvd_l1_zero_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.cabac_init_flag, NULL, settings, "uint32_t", "cabac_init_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.cu_chroma_qp_offset_enabled_flag, NULL, settings, "uint32_t", "cu_chroma_qp_offset_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.deblocking_filter_override_flag, NULL, settings, "uint32_t", "deblocking_filter_override_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.slice_deblocking_filter_disabled_flag, NULL, settings, "uint32_t", "slice_deblocking_filter_disabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.collocated_from_l0_flag, NULL, settings, "uint32_t", "collocated_from_l0_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.slice_loop_filter_across_slices_enabled_flag, NULL, settings, "uint32_t", "slice_loop_filter_across_slices_enabled_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoEncodeH265SliceSegmentLongTermRefPics(const StdVideoEncodeH265SliceSegmentLongTermRefPics& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint8_t>(object.num_long_term_sps, NULL, settings, "uint8_t", "num_long_term_sps", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.num_long_term_pics, NULL, settings, "uint8_t", "num_long_term_pics", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_array<const uint8_t>(object.lt_idx_sps, STD_VIDEO_H265_MAX_LONG_TERM_REF_PICS_SPS, settings, "uint8_t[STD_VIDEO_H265_MAX_LONG_TERM_REF_PICS_SPS]", "uint8_t", "lt_idx_sps", false, false, indents + 1, dump_json_uint8_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const uint8_t>(object.poc_lsb_lt, STD_VIDEO_H265_MAX_LONG_TERM_PICS, settings, "uint8_t[STD_VIDEO_H265_MAX_LONG_TERM_PICS]", "uint8_t", "poc_lsb_lt", false, false, indents + 1, dump_json_uint8_t); // IQA
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.used_by_curr_pic_lt_flag, NULL, settings, "uint16_t", "used_by_curr_pic_lt_flag", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_array<const uint8_t>(object.delta_poc_msb_present_flag, STD_VIDEO_H265_MAX_DELTA_POC, settings, "uint8_t[STD_VIDEO_H265_MAX_DELTA_POC]", "uint8_t", "delta_poc_msb_present_flag", false, false, indents + 1, dump_json_uint8_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const uint8_t>(object.delta_poc_msb_cycle_lt, STD_VIDEO_H265_MAX_DELTA_POC, settings, "uint8_t[STD_VIDEO_H265_MAX_DELTA_POC]", "uint8_t", "delta_poc_msb_cycle_lt", false, false, indents + 1, dump_json_uint8_t); // IQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoEncodeH265SliceSegmentHeader(const StdVideoEncodeH265SliceSegmentHeader& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoEncodeH265SliceSegmentHeaderFlags>(object.flags, NULL, settings, "StdVideoEncodeH265SliceSegmentHeaderFlags", "flags", true, false, indents + 1, dump_json_StdVideoEncodeH265SliceSegmentHeaderFlags);
    settings.stream() << ",\n";
    dump_json_value<const StdVideoH265SliceType>(object.slice_type, NULL, settings, "StdVideoH265SliceType", "slice_type", false, false, indents + 1, dump_json_StdVideoH265SliceType);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.slice_segment_address, NULL, settings, "uint32_t", "slice_segment_address", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.short_term_ref_pic_set_idx, NULL, settings, "uint8_t", "short_term_ref_pic_set_idx", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.collocated_ref_idx, NULL, settings, "uint8_t", "collocated_ref_idx", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.num_ref_idx_l0_active_minus1, NULL, settings, "uint8_t", "num_ref_idx_l0_active_minus1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.num_ref_idx_l1_active_minus1, NULL, settings, "uint8_t", "num_ref_idx_l1_active_minus1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.MaxNumMergeCand, NULL, settings, "uint8_t", "MaxNumMergeCand", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const int8_t>(object.slice_cb_qp_offset, NULL, settings, "int8_t", "slice_cb_qp_offset", false, false, indents + 1, dump_json_int8_t);
    settings.stream() << ",\n";
    dump_json_value<const int8_t>(object.slice_cr_qp_offset, NULL, settings, "int8_t", "slice_cr_qp_offset", false, false, indents + 1, dump_json_int8_t);
    settings.stream() << ",\n";
    dump_json_value<const int8_t>(object.slice_beta_offset_div2, NULL, settings, "int8_t", "slice_beta_offset_div2", false, false, indents + 1, dump_json_int8_t);
    settings.stream() << ",\n";
    dump_json_value<const int8_t>(object.slice_tc_offset_div2, NULL, settings, "int8_t", "slice_tc_offset_div2", false, false, indents + 1, dump_json_int8_t);
    settings.stream() << ",\n";
    dump_json_value<const int8_t>(object.slice_act_y_qp_offset, NULL, settings, "int8_t", "slice_act_y_qp_offset", false, false, indents + 1, dump_json_int8_t);
    settings.stream() << ",\n";
    dump_json_value<const int8_t>(object.slice_act_cb_qp_offset, NULL, settings, "int8_t", "slice_act_cb_qp_offset", false, false, indents + 1, dump_json_int8_t);
    settings.stream() << ",\n";
    dump_json_value<const int8_t>(object.slice_act_cr_qp_offset, NULL, settings, "int8_t", "slice_act_cr_qp_offset", false, false, indents + 1, dump_json_int8_t);
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoH265ShortTermRefPicSet>(object.pShortTermRefPicSet, settings, "const StdVideoH265ShortTermRefPicSet*pShortTermRefPicSet", "pShortTermRefPicSet", true, false, indents + 1, dump_json_StdVideoH265ShortTermRefPicSet);
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoEncodeH265SliceSegmentLongTermRefPics>(object.pLongTermRefPics, settings, "const StdVideoEncodeH265SliceSegmentLongTermRefPics*pLongTermRefPics", "pLongTermRefPics", true, false, indents + 1, dump_json_StdVideoEncodeH265SliceSegmentLongTermRefPics);
    settings.stream() << ",\n";
    dump_json_pointer<const StdVideoEncodeH265WeightTable>(object.pWeightTable, settings, "const StdVideoEncodeH265WeightTable*", "pWeightTable", true, false, indents + 1, dump_json_StdVideoEncodeH265WeightTable);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoEncodeH265ReferenceListsInfoFlags(const StdVideoEncodeH265ReferenceListsInfoFlags& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.ref_pic_list_modification_flag_l0, NULL, settings, "uint32_t", "ref_pic_list_modification_flag_l0", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.ref_pic_list_modification_flag_l1, NULL, settings, "uint32_t", "ref_pic_list_modification_flag_l1", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoEncodeH265ReferenceListsInfo(const StdVideoEncodeH265ReferenceListsInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoEncodeH265ReferenceListsInfoFlags>(object.flags, NULL, settings, "StdVideoEncodeH265ReferenceListsInfoFlags", "flags", true, false, indents + 1, dump_json_StdVideoEncodeH265ReferenceListsInfoFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.num_ref_idx_l0_active_minus1, NULL, settings, "uint8_t", "num_ref_idx_l0_active_minus1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.num_ref_idx_l1_active_minus1, NULL, settings, "uint8_t", "num_ref_idx_l1_active_minus1", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint16_t>(object.reserved1, NULL, settings, "uint16_t", "reserved1", false, false, indents + 1, dump_json_uint16_t);
    settings.stream() << ",\n";
    dump_json_pointer<const uint8_t>(object.pRefPicList0Entries, settings, "const uint8_t*", "pRefPicList0Entries", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_pointer<const uint8_t>(object.pRefPicList1Entries, settings, "const uint8_t*", "pRefPicList1Entries", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_pointer<const uint8_t>(object.pRefList0Modifications, settings, "const uint8_t*", "pRefList0Modifications", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_pointer<const uint8_t>(object.pRefList1Modifications, settings, "const uint8_t*", "pRefList1Modifications", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoEncodeH265PictureInfoFlags(const StdVideoEncodeH265PictureInfoFlags& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.is_reference_flag, NULL, settings, "uint32_t", "is_reference_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.IrapPicFlag, NULL, settings, "uint32_t", "IrapPicFlag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.long_term_flag, NULL, settings, "uint32_t", "long_term_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.discardable_flag, NULL, settings, "uint32_t", "discardable_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.cross_layer_bla_flag, NULL, settings, "uint32_t", "cross_layer_bla_flag", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoEncodeH265PictureInfo(const StdVideoEncodeH265PictureInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoEncodeH265PictureInfoFlags>(object.flags, NULL, settings, "StdVideoEncodeH265PictureInfoFlags", "flags", true, false, indents + 1, dump_json_StdVideoEncodeH265PictureInfoFlags);
    settings.stream() << ",\n";
    dump_json_value<const StdVideoH265PictureType>(object.PictureType, NULL, settings, "StdVideoH265PictureType", "PictureType", false, false, indents + 1, dump_json_StdVideoH265PictureType);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.sps_video_parameter_set_id, NULL, settings, "uint8_t", "sps_video_parameter_set_id", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.pps_seq_parameter_set_id, NULL, settings, "uint8_t", "pps_seq_parameter_set_id", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.pps_pic_parameter_set_id, NULL, settings, "uint8_t", "pps_pic_parameter_set_id", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.TemporalId, NULL, settings, "uint8_t", "TemporalId", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const int32_t>(object.PicOrderCntVal, NULL, settings, "int32_t", "PicOrderCntVal", false, false, indents + 1, dump_json_int32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoEncodeH265ReferenceInfoFlags(const StdVideoEncodeH265ReferenceInfoFlags& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.used_for_long_term_reference, NULL, settings, "uint32_t", "used_for_long_term_reference", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.unused_for_reference, NULL, settings, "uint32_t", "unused_for_reference", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_StdVideoEncodeH265ReferenceInfo(const StdVideoEncodeH265ReferenceInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const StdVideoEncodeH265ReferenceInfoFlags>(object.flags, NULL, settings, "StdVideoEncodeH265ReferenceInfoFlags", "flags", true, false, indents + 1, dump_json_StdVideoEncodeH265ReferenceInfoFlags);
    settings.stream() << ",\n";
    dump_json_value<const StdVideoH265PictureType>(object.PictureType, NULL, settings, "StdVideoH265PictureType", "PictureType", false, false, indents + 1, dump_json_StdVideoH265PictureType);
    settings.stream() << ",\n";
    dump_json_value<const int32_t>(object.PicOrderCntVal, NULL, settings, "int32_t", "PicOrderCntVal", false, false, indents + 1, dump_json_int32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.TemporalId, NULL, settings, "uint8_t", "TemporalId", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}

//========================== Union Implementations ==========================//


//======================== pNext Chain Implementation =======================//


//========================= Function Implementations ========================//



