
/* Copyright (c) 2015-2023 Valve Corporation
 * Copyright (c) 2015-2023 LunarG, Inc.
 * Copyright (c) 2015-2017, 2019 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Author: Lenny Komow <lenny@lunarg.com>
 * Author: Joey Bzdek <joey@lunarg.com>
 * Author: Shannon McPherson <shannon@lunarg.com>
 * Author: Charles Giessen <charles@lunarg.com>
 */

/*
 * This file is generated from the Khronos Vulkan XML API Registry.
 */

#pragma once

#include "api_dump.h"
#include "api_dump_video_html.h"

void dump_html_pNext_trampoline(const void* object, const ApiDumpSettings& settings, int indents);


void dump_html_VkClearColorValue(const VkClearColorValue& object, const ApiDumpSettings& settings, int indents);
void dump_html_VkClearValue(const VkClearValue& object, const ApiDumpSettings& settings, int indents);
void dump_html_VkPerformanceCounterResultKHR(const VkPerformanceCounterResultKHR& object, const ApiDumpSettings& settings, int indents);
void dump_html_VkDeviceOrHostAddressKHR(const VkDeviceOrHostAddressKHR& object, const ApiDumpSettings& settings, int indents);
void dump_html_VkDeviceOrHostAddressConstKHR(const VkDeviceOrHostAddressConstKHR& object, const ApiDumpSettings& settings, int indents);
void dump_html_VkAccelerationStructureGeometryDataKHR(const VkAccelerationStructureGeometryDataKHR& object, const ApiDumpSettings& settings, int indents);
void dump_html_VkPerformanceValueDataINTEL(const VkPerformanceValueDataINTEL& object, const ApiDumpSettings& settings, int indents);
void dump_html_VkPipelineExecutableStatisticValueKHR(const VkPipelineExecutableStatisticValueKHR& object, const ApiDumpSettings& settings, int indents);
void dump_html_VkDescriptorDataEXT(const VkDescriptorDataEXT& object, const ApiDumpSettings& settings, int indents);
void dump_html_VkAccelerationStructureMotionInstanceDataNV(const VkAccelerationStructureMotionInstanceDataNV& object, const ApiDumpSettings& settings, int indents);

//============================= typedefs ==============================//

// Functions for dumping typedef types that the codegen scripting can't handle
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkAccelerationStructureTypeKHR(VkAccelerationStructureTypeKHR object, const ApiDumpSettings& settings, int indents);
void dump_html_VkAccelerationStructureTypeNV(VkAccelerationStructureTypeNV object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkAccelerationStructureTypeKHR(object, settings, indents);
}
void dump_html_VkBuildAccelerationStructureFlagsKHR(VkBuildAccelerationStructureFlagsKHR object, const ApiDumpSettings& settings, int indents);
void dump_html_VkBuildAccelerationStructureFlagsNV(VkBuildAccelerationStructureFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkBuildAccelerationStructureFlagsKHR(object, settings, indents);
}
#endif // VK_ENABLE_BETA_EXTENSIONS

//=========================== Type Implementations ==========================//

void dump_html_uint64_t(uint64_t object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    settings.stream() << object;
    settings.stream() << "</div></summary>";
}
void dump_html_size_t(size_t object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    settings.stream() << object;
    settings.stream() << "</div></summary>";
}
void dump_html_char(char object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    settings.stream() << object;
    settings.stream() << "</div></summary>";
}
void dump_html_float(float object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    settings.stream() << object;
    settings.stream() << "</div></summary>";
}
void dump_html_int64_t(int64_t object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    settings.stream() << object;
    settings.stream() << "</div></summary>";
}
void dump_html_double(double object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    settings.stream() << object;
    settings.stream() << "</div></summary>";
}

//========================= Basetype Implementations ========================//

void dump_html_VkBool32(VkBool32 object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>" << object << "</div></summary>";
}
void dump_html_VkDeviceAddress(VkDeviceAddress object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>" << object << "</div></summary>";
}
void dump_html_VkDeviceSize(VkDeviceSize object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>" << object << "</div></summary>";
}
void dump_html_VkFlags(VkFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>" << object << "</div></summary>";
}
void dump_html_VkSampleMask(VkSampleMask object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>" << object << "</div></summary>";
}
void dump_html_VkFlags64(VkFlags64 object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>" << object << "</div></summary>";
}
#if defined(VK_USE_PLATFORM_METAL_EXT)
void dump_html_MTLDevice_id(MTLDevice_id object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>" << object << "</div></summary>";
}
#endif // VK_USE_PLATFORM_METAL_EXT
#if defined(VK_USE_PLATFORM_METAL_EXT)
void dump_html_MTLCommandQueue_id(MTLCommandQueue_id object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>" << object << "</div></summary>";
}
#endif // VK_USE_PLATFORM_METAL_EXT
#if defined(VK_USE_PLATFORM_METAL_EXT)
void dump_html_MTLBuffer_id(MTLBuffer_id object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>" << object << "</div></summary>";
}
#endif // VK_USE_PLATFORM_METAL_EXT
#if defined(VK_USE_PLATFORM_METAL_EXT)
void dump_html_MTLTexture_id(MTLTexture_id object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>" << object << "</div></summary>";
}
#endif // VK_USE_PLATFORM_METAL_EXT
#if defined(VK_USE_PLATFORM_METAL_EXT)
void dump_html_IOSurfaceRef(IOSurfaceRef object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>" << object << "</div></summary>";
}
#endif // VK_USE_PLATFORM_METAL_EXT
#if defined(VK_USE_PLATFORM_METAL_EXT)
void dump_html_MTLSharedEvent_id(MTLSharedEvent_id object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>" << object << "</div></summary>";
}
#endif // VK_USE_PLATFORM_METAL_EXT
void dump_html_VkRemoteAddressNV(VkRemoteAddressNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>" << object << "</div></summary>";
}


#if defined(VK_USE_PLATFORM_ANDROID_KHR)
#if defined(VK_USE_PLATFORM_ANDROID_KHR)
void dump_html_ANativeWindow(const ANativeWindow* object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>" << object << "</div></summary>";
}
#endif
#endif // VK_USE_PLATFORM_ANDROID_KHR
#if defined(VK_USE_PLATFORM_ANDROID_KHR)
#if defined(VK_USE_PLATFORM_ANDROID_KHR)
void dump_html_AHardwareBuffer(const AHardwareBuffer* object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>" << object << "</div></summary>";
}
#endif
#endif // VK_USE_PLATFORM_ANDROID_KHR


#if defined(VK_USE_PLATFORM_METAL_EXT)
#if defined(VK_USE_PLATFORM_METAL_EXT)
void dump_html_CAMetalLayer(CAMetalLayer object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>" << object << "</div></summary>";
}
#endif
#endif // VK_USE_PLATFORM_METAL_EXT

//======================= System Type Implementations =======================//

#if defined(VK_USE_PLATFORM_WIN32_KHR)
void dump_html_HANDLE(const HANDLE object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "<div class='val'>" << object << "</div></summary>";
    else
        settings.stream() << "<div class='val'>address</div></summary>";
}
#endif // VK_USE_PLATFORM_WIN32_KHR
#if defined(VK_USE_PLATFORM_WIN32_KHR)
void dump_html_HMONITOR(const HMONITOR object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "<div class='val'>" << object << "</div></summary>";
    else
        settings.stream() << "<div class='val'>address</div></summary>";
}
#endif // VK_USE_PLATFORM_WIN32_KHR
#if defined(VK_USE_PLATFORM_WAYLAND_KHR)
void dump_html_wl_display(const wl_display object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "<div class='val'>" << object << "</div></summary>";
    else
        settings.stream() << "<div class='val'>address</div></summary>";
}
#endif // VK_USE_PLATFORM_WAYLAND_KHR
#if defined(VK_USE_PLATFORM_WIN32_KHR)
void dump_html_LPCWSTR(const LPCWSTR object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "<div class='val'>" << object << "</div></summary>";
    else
        settings.stream() << "<div class='val'>address</div></summary>";
}
#endif // VK_USE_PLATFORM_WIN32_KHR
#if defined(VK_USE_PLATFORM_XCB_KHR)
void dump_html_xcb_visualid_t(const xcb_visualid_t object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "<div class='val'>" << object << "</div></summary>";
    else
        settings.stream() << "<div class='val'>address</div></summary>";
}
#endif // VK_USE_PLATFORM_XCB_KHR
#if defined(VK_USE_PLATFORM_WAYLAND_KHR)
void dump_html_wl_surface(const wl_surface object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "<div class='val'>" << object << "</div></summary>";
    else
        settings.stream() << "<div class='val'>address</div></summary>";
}
#endif // VK_USE_PLATFORM_WAYLAND_KHR
#if defined(VK_USE_PLATFORM_FUCHSIA)
void dump_html_zx_handle_t(const zx_handle_t object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "<div class='val'>" << object << "</div></summary>";
    else
        settings.stream() << "<div class='val'>address</div></summary>";
}
#endif // VK_USE_PLATFORM_FUCHSIA
#if defined(VK_USE_PLATFORM_DIRECTFB_EXT)
void dump_html_IDirectFB(const IDirectFB object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "<div class='val'>" << object << "</div></summary>";
    else
        settings.stream() << "<div class='val'>address</div></summary>";
}
#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#if defined(VK_USE_PLATFORM_GGP)
void dump_html_GgpFrameToken(const GgpFrameToken object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "<div class='val'>" << object << "</div></summary>";
    else
        settings.stream() << "<div class='val'>address</div></summary>";
}
#endif // VK_USE_PLATFORM_GGP
#if defined(VK_USE_PLATFORM_XCB_KHR)
void dump_html_xcb_window_t(const xcb_window_t object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "<div class='val'>" << object << "</div></summary>";
    else
        settings.stream() << "<div class='val'>address</div></summary>";
}
#endif // VK_USE_PLATFORM_XCB_KHR
#if defined(VK_USE_PLATFORM_XLIB_KHR)
void dump_html_Display(const Display* object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    OutputAddress(settings, object);
    settings.stream() << "</div>";
}
#endif // VK_USE_PLATFORM_XLIB_KHR
#if defined(VK_USE_PLATFORM_XLIB_KHR)
void dump_html_VisualID(const VisualID object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "<div class='val'>" << object << "</div></summary>";
    else
        settings.stream() << "<div class='val'>address</div></summary>";
}
#endif // VK_USE_PLATFORM_XLIB_KHR
#if defined(VK_USE_PLATFORM_WIN32_KHR)
void dump_html_HINSTANCE(const HINSTANCE object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "<div class='val'>" << object << "</div></summary>";
    else
        settings.stream() << "<div class='val'>address</div></summary>";
}
#endif // VK_USE_PLATFORM_WIN32_KHR
#if defined(VK_USE_PLATFORM_GGP)
void dump_html_GgpStreamDescriptor(const GgpStreamDescriptor object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "<div class='val'>" << object << "</div></summary>";
    else
        settings.stream() << "<div class='val'>address</div></summary>";
}
#endif // VK_USE_PLATFORM_GGP
#if defined(VK_USE_PLATFORM_SCREEN_QNX)
void dump_html__screen_window(const _screen_window object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "<div class='val'>" << object << "</div></summary>";
    else
        settings.stream() << "<div class='val'>address</div></summary>";
}
#endif // VK_USE_PLATFORM_SCREEN_QNX
#if defined(VK_USE_PLATFORM_XCB_KHR)
void dump_html_xcb_connection_t(const xcb_connection_t* object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    OutputAddress(settings, object);
    settings.stream() << "</div>";
}
#endif // VK_USE_PLATFORM_XCB_KHR
#if defined(VK_USE_PLATFORM_XLIB_KHR)
void dump_html_Window(const Window object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "<div class='val'>" << object << "</div></summary>";
    else
        settings.stream() << "<div class='val'>address</div></summary>";
}
#endif // VK_USE_PLATFORM_XLIB_KHR
#if defined(VK_USE_PLATFORM_DIRECTFB_EXT)
void dump_html_IDirectFBSurface(const IDirectFBSurface object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "<div class='val'>" << object << "</div></summary>";
    else
        settings.stream() << "<div class='val'>address</div></summary>";
}
#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#if defined(VK_USE_PLATFORM_SCREEN_QNX)
void dump_html__screen_context(const _screen_context object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "<div class='val'>" << object << "</div></summary>";
    else
        settings.stream() << "<div class='val'>address</div></summary>";
}
#endif // VK_USE_PLATFORM_SCREEN_QNX
#if defined(VK_USE_PLATFORM_WIN32_KHR)
void dump_html_SECURITY_ATTRIBUTES(const SECURITY_ATTRIBUTES* object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    OutputAddress(settings, object);
    settings.stream() << "</div>";
}
#endif // VK_USE_PLATFORM_WIN32_KHR
#if defined(VK_USE_PLATFORM_WIN32_KHR)
void dump_html_HWND(const HWND object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "<div class='val'>" << object << "</div></summary>";
    else
        settings.stream() << "<div class='val'>address</div></summary>";
}
#endif // VK_USE_PLATFORM_WIN32_KHR
#if defined(VK_USE_PLATFORM_WIN32_KHR)
void dump_html_DWORD(const DWORD object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "<div class='val'>" << object << "</div></summary>";
    else
        settings.stream() << "<div class='val'>address</div></summary>";
}
#endif // VK_USE_PLATFORM_WIN32_KHR

//========================== Handle Implementations =========================//

void dump_html_VkBuffer(const VkBuffer object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkImage(const VkImage object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkInstance(const VkInstance object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkPhysicalDevice(const VkPhysicalDevice object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkDevice(const VkDevice object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkQueue(const VkQueue object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkSemaphore(const VkSemaphore object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkCommandBuffer(const VkCommandBuffer object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkFence(const VkFence object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkDeviceMemory(const VkDeviceMemory object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkEvent(const VkEvent object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkQueryPool(const VkQueryPool object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkBufferView(const VkBufferView object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkImageView(const VkImageView object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkShaderModule(const VkShaderModule object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkPipelineCache(const VkPipelineCache object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkPipelineLayout(const VkPipelineLayout object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkPipeline(const VkPipeline object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkRenderPass(const VkRenderPass object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkDescriptorSetLayout(const VkDescriptorSetLayout object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkSampler(const VkSampler object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkDescriptorSet(const VkDescriptorSet object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkDescriptorPool(const VkDescriptorPool object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkFramebuffer(const VkFramebuffer object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkCommandPool(const VkCommandPool object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkSamplerYcbcrConversion(const VkSamplerYcbcrConversion object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkDescriptorUpdateTemplate(const VkDescriptorUpdateTemplate object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkPrivateDataSlot(const VkPrivateDataSlot object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkSurfaceKHR(const VkSurfaceKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkSwapchainKHR(const VkSwapchainKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkDisplayKHR(const VkDisplayKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkDisplayModeKHR(const VkDisplayModeKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkDebugReportCallbackEXT(const VkDebugReportCallbackEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkVideoSessionKHR(const VkVideoSessionKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkVideoSessionParametersKHR(const VkVideoSessionParametersKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkCuModuleNVX(const VkCuModuleNVX object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkCuFunctionNVX(const VkCuFunctionNVX object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkDebugUtilsMessengerEXT(const VkDebugUtilsMessengerEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkAccelerationStructureKHR(const VkAccelerationStructureKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkDeferredOperationKHR(const VkDeferredOperationKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkValidationCacheEXT(const VkValidationCacheEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkAccelerationStructureNV(const VkAccelerationStructureNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkPerformanceConfigurationINTEL(const VkPerformanceConfigurationINTEL object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkIndirectCommandsLayoutNV(const VkIndirectCommandsLayoutNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
#if defined(VK_USE_PLATFORM_FUCHSIA)
void dump_html_VkBufferCollectionFUCHSIA(const VkBufferCollectionFUCHSIA object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
#endif // VK_USE_PLATFORM_FUCHSIA
void dump_html_VkMicromapEXT(const VkMicromapEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkOpticalFlowSessionNV(const VkOpticalFlowSessionNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}
void dump_html_VkShaderEXT(const VkShaderEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress()) {
        settings.stream() << object;

        std::unordered_map<uint64_t, std::string>::const_iterator it = ApiDumpInstance::current().object_name_map.find((uint64_t) object);
        if (it != ApiDumpInstance::current().object_name_map.end()) {
            settings.stream() << "</div><div class='val'>[" << it->second << "]";
        }
    } else {
        settings.stream() << "address";
    }
    settings.stream() << "</div></summary>";
}

//=========================== Enum Implementations ==========================//

void dump_html_VkResult(VkResult object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_SUCCESS (";
        break;
    case 1:
        settings.stream() << "VK_NOT_READY (";
        break;
    case 2:
        settings.stream() << "VK_TIMEOUT (";
        break;
    case 3:
        settings.stream() << "VK_EVENT_SET (";
        break;
    case 4:
        settings.stream() << "VK_EVENT_RESET (";
        break;
    case 5:
        settings.stream() << "VK_INCOMPLETE (";
        break;
    case -1:
        settings.stream() << "VK_ERROR_OUT_OF_HOST_MEMORY (";
        break;
    case -2:
        settings.stream() << "VK_ERROR_OUT_OF_DEVICE_MEMORY (";
        break;
    case -3:
        settings.stream() << "VK_ERROR_INITIALIZATION_FAILED (";
        break;
    case -4:
        settings.stream() << "VK_ERROR_DEVICE_LOST (";
        break;
    case -5:
        settings.stream() << "VK_ERROR_MEMORY_MAP_FAILED (";
        break;
    case -6:
        settings.stream() << "VK_ERROR_LAYER_NOT_PRESENT (";
        break;
    case -7:
        settings.stream() << "VK_ERROR_EXTENSION_NOT_PRESENT (";
        break;
    case -8:
        settings.stream() << "VK_ERROR_FEATURE_NOT_PRESENT (";
        break;
    case -9:
        settings.stream() << "VK_ERROR_INCOMPATIBLE_DRIVER (";
        break;
    case -10:
        settings.stream() << "VK_ERROR_TOO_MANY_OBJECTS (";
        break;
    case -11:
        settings.stream() << "VK_ERROR_FORMAT_NOT_SUPPORTED (";
        break;
    case -12:
        settings.stream() << "VK_ERROR_FRAGMENTED_POOL (";
        break;
    case -13:
        settings.stream() << "VK_ERROR_UNKNOWN (";
        break;
    case -1000069000:
        settings.stream() << "VK_ERROR_OUT_OF_POOL_MEMORY (";
        break;
    case -1000072003:
        settings.stream() << "VK_ERROR_INVALID_EXTERNAL_HANDLE (";
        break;
    case -1000161000:
        settings.stream() << "VK_ERROR_FRAGMENTATION (";
        break;
    case -1000257000:
        settings.stream() << "VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS (";
        break;
    case 1000297000:
        settings.stream() << "VK_PIPELINE_COMPILE_REQUIRED (";
        break;
    case -1000000000:
        settings.stream() << "VK_ERROR_SURFACE_LOST_KHR (";
        break;
    case -1000000001:
        settings.stream() << "VK_ERROR_NATIVE_WINDOW_IN_USE_KHR (";
        break;
    case 1000001003:
        settings.stream() << "VK_SUBOPTIMAL_KHR (";
        break;
    case -1000001004:
        settings.stream() << "VK_ERROR_OUT_OF_DATE_KHR (";
        break;
    case -1000003001:
        settings.stream() << "VK_ERROR_INCOMPATIBLE_DISPLAY_KHR (";
        break;
    case -1000011001:
        settings.stream() << "VK_ERROR_VALIDATION_FAILED_EXT (";
        break;
    case -1000012000:
        settings.stream() << "VK_ERROR_INVALID_SHADER_NV (";
        break;
    case -1000023000:
        settings.stream() << "VK_ERROR_IMAGE_USAGE_NOT_SUPPORTED_KHR (";
        break;
    case -1000023001:
        settings.stream() << "VK_ERROR_VIDEO_PICTURE_LAYOUT_NOT_SUPPORTED_KHR (";
        break;
    case -1000023002:
        settings.stream() << "VK_ERROR_VIDEO_PROFILE_OPERATION_NOT_SUPPORTED_KHR (";
        break;
    case -1000023003:
        settings.stream() << "VK_ERROR_VIDEO_PROFILE_FORMAT_NOT_SUPPORTED_KHR (";
        break;
    case -1000023004:
        settings.stream() << "VK_ERROR_VIDEO_PROFILE_CODEC_NOT_SUPPORTED_KHR (";
        break;
    case -1000023005:
        settings.stream() << "VK_ERROR_VIDEO_STD_VERSION_NOT_SUPPORTED_KHR (";
        break;
    case -1000158000:
        settings.stream() << "VK_ERROR_INVALID_DRM_FORMAT_MODIFIER_PLANE_LAYOUT_EXT (";
        break;
    case -1000174001:
        settings.stream() << "VK_ERROR_NOT_PERMITTED_KHR (";
        break;
    case -1000255000:
        settings.stream() << "VK_ERROR_FULL_SCREEN_EXCLUSIVE_MODE_LOST_EXT (";
        break;
    case 1000268000:
        settings.stream() << "VK_THREAD_IDLE_KHR (";
        break;
    case 1000268001:
        settings.stream() << "VK_THREAD_DONE_KHR (";
        break;
    case 1000268002:
        settings.stream() << "VK_OPERATION_DEFERRED_KHR (";
        break;
    case 1000268003:
        settings.stream() << "VK_OPERATION_NOT_DEFERRED_KHR (";
        break;
    case -1000299000:
        settings.stream() << "VK_ERROR_INVALID_VIDEO_STD_PARAMETERS_KHR (";
        break;
    case -1000338000:
        settings.stream() << "VK_ERROR_COMPRESSION_EXHAUSTED_EXT (";
        break;
    case 1000482000:
        settings.stream() << "VK_ERROR_INCOMPATIBLE_SHADER_BINARY_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkStructureType(VkStructureType object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_STRUCTURE_TYPE_APPLICATION_INFO (";
        break;
    case 1:
        settings.stream() << "VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO (";
        break;
    case 2:
        settings.stream() << "VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO (";
        break;
    case 3:
        settings.stream() << "VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO (";
        break;
    case 4:
        settings.stream() << "VK_STRUCTURE_TYPE_SUBMIT_INFO (";
        break;
    case 5:
        settings.stream() << "VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO (";
        break;
    case 6:
        settings.stream() << "VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE (";
        break;
    case 7:
        settings.stream() << "VK_STRUCTURE_TYPE_BIND_SPARSE_INFO (";
        break;
    case 8:
        settings.stream() << "VK_STRUCTURE_TYPE_FENCE_CREATE_INFO (";
        break;
    case 9:
        settings.stream() << "VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO (";
        break;
    case 10:
        settings.stream() << "VK_STRUCTURE_TYPE_EVENT_CREATE_INFO (";
        break;
    case 11:
        settings.stream() << "VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO (";
        break;
    case 12:
        settings.stream() << "VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO (";
        break;
    case 13:
        settings.stream() << "VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO (";
        break;
    case 14:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO (";
        break;
    case 15:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO (";
        break;
    case 16:
        settings.stream() << "VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO (";
        break;
    case 17:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO (";
        break;
    case 18:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO (";
        break;
    case 19:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO (";
        break;
    case 20:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO (";
        break;
    case 21:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO (";
        break;
    case 22:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO (";
        break;
    case 23:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO (";
        break;
    case 24:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO (";
        break;
    case 25:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO (";
        break;
    case 26:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO (";
        break;
    case 27:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO (";
        break;
    case 28:
        settings.stream() << "VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO (";
        break;
    case 29:
        settings.stream() << "VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO (";
        break;
    case 30:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO (";
        break;
    case 31:
        settings.stream() << "VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO (";
        break;
    case 32:
        settings.stream() << "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO (";
        break;
    case 33:
        settings.stream() << "VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO (";
        break;
    case 34:
        settings.stream() << "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO (";
        break;
    case 35:
        settings.stream() << "VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET (";
        break;
    case 36:
        settings.stream() << "VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET (";
        break;
    case 37:
        settings.stream() << "VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO (";
        break;
    case 38:
        settings.stream() << "VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO (";
        break;
    case 39:
        settings.stream() << "VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO (";
        break;
    case 40:
        settings.stream() << "VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO (";
        break;
    case 41:
        settings.stream() << "VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO (";
        break;
    case 42:
        settings.stream() << "VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO (";
        break;
    case 43:
        settings.stream() << "VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO (";
        break;
    case 44:
        settings.stream() << "VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER (";
        break;
    case 45:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER (";
        break;
    case 46:
        settings.stream() << "VK_STRUCTURE_TYPE_MEMORY_BARRIER (";
        break;
    case 47:
        settings.stream() << "VK_STRUCTURE_TYPE_LOADER_INSTANCE_CREATE_INFO (";
        break;
    case 48:
        settings.stream() << "VK_STRUCTURE_TYPE_LOADER_DEVICE_CREATE_INFO (";
        break;
    case 1000094000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES (";
        break;
    case 1000157000:
        settings.stream() << "VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO (";
        break;
    case 1000157001:
        settings.stream() << "VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO (";
        break;
    case 1000083000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES (";
        break;
    case 1000127000:
        settings.stream() << "VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS (";
        break;
    case 1000127001:
        settings.stream() << "VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO (";
        break;
    case 1000060000:
        settings.stream() << "VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO (";
        break;
    case 1000060003:
        settings.stream() << "VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO (";
        break;
    case 1000060004:
        settings.stream() << "VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO (";
        break;
    case 1000060005:
        settings.stream() << "VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO (";
        break;
    case 1000060006:
        settings.stream() << "VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO (";
        break;
    case 1000060013:
        settings.stream() << "VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO (";
        break;
    case 1000060014:
        settings.stream() << "VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO (";
        break;
    case 1000070000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES (";
        break;
    case 1000070001:
        settings.stream() << "VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO (";
        break;
    case 1000146000:
        settings.stream() << "VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2 (";
        break;
    case 1000146001:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2 (";
        break;
    case 1000146002:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2 (";
        break;
    case 1000146003:
        settings.stream() << "VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2 (";
        break;
    case 1000146004:
        settings.stream() << "VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2 (";
        break;
    case 1000059000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2 (";
        break;
    case 1000059001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2 (";
        break;
    case 1000059002:
        settings.stream() << "VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2 (";
        break;
    case 1000059003:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2 (";
        break;
    case 1000059004:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2 (";
        break;
    case 1000059005:
        settings.stream() << "VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2 (";
        break;
    case 1000059006:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2 (";
        break;
    case 1000059007:
        settings.stream() << "VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2 (";
        break;
    case 1000059008:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2 (";
        break;
    case 1000117000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES (";
        break;
    case 1000117001:
        settings.stream() << "VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO (";
        break;
    case 1000117002:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO (";
        break;
    case 1000117003:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO (";
        break;
    case 1000053000:
        settings.stream() << "VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO (";
        break;
    case 1000053001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES (";
        break;
    case 1000053002:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES (";
        break;
    case 1000120000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES (";
        break;
    case 1000145000:
        settings.stream() << "VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO (";
        break;
    case 1000145001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES (";
        break;
    case 1000145002:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES (";
        break;
    case 1000145003:
        settings.stream() << "VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2 (";
        break;
    case 1000156000:
        settings.stream() << "VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO (";
        break;
    case 1000156001:
        settings.stream() << "VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO (";
        break;
    case 1000156002:
        settings.stream() << "VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO (";
        break;
    case 1000156003:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO (";
        break;
    case 1000156004:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES (";
        break;
    case 1000156005:
        settings.stream() << "VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES (";
        break;
    case 1000085000:
        settings.stream() << "VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO (";
        break;
    case 1000071000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO (";
        break;
    case 1000071001:
        settings.stream() << "VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES (";
        break;
    case 1000071002:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO (";
        break;
    case 1000071003:
        settings.stream() << "VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES (";
        break;
    case 1000071004:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES (";
        break;
    case 1000072000:
        settings.stream() << "VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO (";
        break;
    case 1000072001:
        settings.stream() << "VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO (";
        break;
    case 1000072002:
        settings.stream() << "VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO (";
        break;
    case 1000112000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO (";
        break;
    case 1000112001:
        settings.stream() << "VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES (";
        break;
    case 1000113000:
        settings.stream() << "VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO (";
        break;
    case 1000077000:
        settings.stream() << "VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO (";
        break;
    case 1000076000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO (";
        break;
    case 1000076001:
        settings.stream() << "VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES (";
        break;
    case 1000168000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES (";
        break;
    case 1000168001:
        settings.stream() << "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT (";
        break;
    case 1000063000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES (";
        break;
    case 49:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES (";
        break;
    case 50:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES (";
        break;
    case 51:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES (";
        break;
    case 52:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES (";
        break;
    case 1000147000:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO (";
        break;
    case 1000109000:
        settings.stream() << "VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2 (";
        break;
    case 1000109001:
        settings.stream() << "VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2 (";
        break;
    case 1000109002:
        settings.stream() << "VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2 (";
        break;
    case 1000109003:
        settings.stream() << "VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2 (";
        break;
    case 1000109004:
        settings.stream() << "VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2 (";
        break;
    case 1000109005:
        settings.stream() << "VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO (";
        break;
    case 1000109006:
        settings.stream() << "VK_STRUCTURE_TYPE_SUBPASS_END_INFO (";
        break;
    case 1000177000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES (";
        break;
    case 1000196000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES (";
        break;
    case 1000180000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES (";
        break;
    case 1000082000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES (";
        break;
    case 1000197000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES (";
        break;
    case 1000161000:
        settings.stream() << "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO (";
        break;
    case 1000161001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES (";
        break;
    case 1000161002:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES (";
        break;
    case 1000161003:
        settings.stream() << "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO (";
        break;
    case 1000161004:
        settings.stream() << "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT (";
        break;
    case 1000199000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES (";
        break;
    case 1000199001:
        settings.stream() << "VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE (";
        break;
    case 1000221000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES (";
        break;
    case 1000246000:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO (";
        break;
    case 1000130000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES (";
        break;
    case 1000130001:
        settings.stream() << "VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO (";
        break;
    case 1000211000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES (";
        break;
    case 1000108000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES (";
        break;
    case 1000108001:
        settings.stream() << "VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO (";
        break;
    case 1000108002:
        settings.stream() << "VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO (";
        break;
    case 1000108003:
        settings.stream() << "VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO (";
        break;
    case 1000253000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES (";
        break;
    case 1000175000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES (";
        break;
    case 1000241000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES (";
        break;
    case 1000241001:
        settings.stream() << "VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT (";
        break;
    case 1000241002:
        settings.stream() << "VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT (";
        break;
    case 1000261000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES (";
        break;
    case 1000207000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES (";
        break;
    case 1000207001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES (";
        break;
    case 1000207002:
        settings.stream() << "VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO (";
        break;
    case 1000207003:
        settings.stream() << "VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO (";
        break;
    case 1000207004:
        settings.stream() << "VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO (";
        break;
    case 1000207005:
        settings.stream() << "VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO (";
        break;
    case 1000257000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES (";
        break;
    case 1000244001:
        settings.stream() << "VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO (";
        break;
    case 1000257002:
        settings.stream() << "VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO (";
        break;
    case 1000257003:
        settings.stream() << "VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO (";
        break;
    case 1000257004:
        settings.stream() << "VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO (";
        break;
    case 53:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES (";
        break;
    case 54:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES (";
        break;
    case 1000192000:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO (";
        break;
    case 1000215000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES (";
        break;
    case 1000245000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES (";
        break;
    case 1000276000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES (";
        break;
    case 1000295000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES (";
        break;
    case 1000295001:
        settings.stream() << "VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO (";
        break;
    case 1000295002:
        settings.stream() << "VK_STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO (";
        break;
    case 1000297000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES (";
        break;
    case 1000314000:
        settings.stream() << "VK_STRUCTURE_TYPE_MEMORY_BARRIER_2 (";
        break;
    case 1000314001:
        settings.stream() << "VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2 (";
        break;
    case 1000314002:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2 (";
        break;
    case 1000314003:
        settings.stream() << "VK_STRUCTURE_TYPE_DEPENDENCY_INFO (";
        break;
    case 1000314004:
        settings.stream() << "VK_STRUCTURE_TYPE_SUBMIT_INFO_2 (";
        break;
    case 1000314005:
        settings.stream() << "VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO (";
        break;
    case 1000314006:
        settings.stream() << "VK_STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO (";
        break;
    case 1000314007:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES (";
        break;
    case 1000325000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES (";
        break;
    case 1000335000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES (";
        break;
    case 1000337000:
        settings.stream() << "VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2 (";
        break;
    case 1000337001:
        settings.stream() << "VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2 (";
        break;
    case 1000337002:
        settings.stream() << "VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2 (";
        break;
    case 1000337003:
        settings.stream() << "VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2 (";
        break;
    case 1000337004:
        settings.stream() << "VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2 (";
        break;
    case 1000337005:
        settings.stream() << "VK_STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2 (";
        break;
    case 1000337006:
        settings.stream() << "VK_STRUCTURE_TYPE_BUFFER_COPY_2 (";
        break;
    case 1000337007:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_COPY_2 (";
        break;
    case 1000337008:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_BLIT_2 (";
        break;
    case 1000337009:
        settings.stream() << "VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2 (";
        break;
    case 1000337010:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_RESOLVE_2 (";
        break;
    case 1000225000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES (";
        break;
    case 1000225001:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO (";
        break;
    case 1000225002:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES (";
        break;
    case 1000138000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES (";
        break;
    case 1000138001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES (";
        break;
    case 1000138002:
        settings.stream() << "VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK (";
        break;
    case 1000138003:
        settings.stream() << "VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO (";
        break;
    case 1000066000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES (";
        break;
    case 1000044000:
        settings.stream() << "VK_STRUCTURE_TYPE_RENDERING_INFO (";
        break;
    case 1000044001:
        settings.stream() << "VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO (";
        break;
    case 1000044002:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO (";
        break;
    case 1000044003:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES (";
        break;
    case 1000044004:
        settings.stream() << "VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO (";
        break;
    case 1000280000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES (";
        break;
    case 1000280001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES (";
        break;
    case 1000281001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES (";
        break;
    case 1000360000:
        settings.stream() << "VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3 (";
        break;
    case 1000413000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES (";
        break;
    case 1000413001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES (";
        break;
    case 1000413002:
        settings.stream() << "VK_STRUCTURE_TYPE_DEVICE_BUFFER_MEMORY_REQUIREMENTS (";
        break;
    case 1000413003:
        settings.stream() << "VK_STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS (";
        break;
    case 1000001000:
        settings.stream() << "VK_STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR (";
        break;
    case 1000001001:
        settings.stream() << "VK_STRUCTURE_TYPE_PRESENT_INFO_KHR (";
        break;
    case 1000060007:
        settings.stream() << "VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR (";
        break;
    case 1000060008:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR (";
        break;
    case 1000060009:
        settings.stream() << "VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR (";
        break;
    case 1000060010:
        settings.stream() << "VK_STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR (";
        break;
    case 1000060011:
        settings.stream() << "VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR (";
        break;
    case 1000060012:
        settings.stream() << "VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR (";
        break;
    case 1000002000:
        settings.stream() << "VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR (";
        break;
    case 1000002001:
        settings.stream() << "VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR (";
        break;
    case 1000003000:
        settings.stream() << "VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR (";
        break;
    case 1000004000:
        settings.stream() << "VK_STRUCTURE_TYPE_XLIB_SURFACE_CREATE_INFO_KHR (";
        break;
    case 1000005000:
        settings.stream() << "VK_STRUCTURE_TYPE_XCB_SURFACE_CREATE_INFO_KHR (";
        break;
    case 1000006000:
        settings.stream() << "VK_STRUCTURE_TYPE_WAYLAND_SURFACE_CREATE_INFO_KHR (";
        break;
    case 1000008000:
        settings.stream() << "VK_STRUCTURE_TYPE_ANDROID_SURFACE_CREATE_INFO_KHR (";
        break;
    case 1000009000:
        settings.stream() << "VK_STRUCTURE_TYPE_WIN32_SURFACE_CREATE_INFO_KHR (";
        break;
    case 1000010000:
        settings.stream() << "VK_STRUCTURE_TYPE_NATIVE_BUFFER_ANDROID (";
        break;
    case 1000010001:
        settings.stream() << "VK_STRUCTURE_TYPE_SWAPCHAIN_IMAGE_CREATE_INFO_ANDROID (";
        break;
    case 1000010002:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENTATION_PROPERTIES_ANDROID (";
        break;
    case 1000011000:
        settings.stream() << "VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT (";
        break;
    case 1000018000:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD (";
        break;
    case 1000022000:
        settings.stream() << "VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT (";
        break;
    case 1000022001:
        settings.stream() << "VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT (";
        break;
    case 1000022002:
        settings.stream() << "VK_STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT (";
        break;
    case 1000023000:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_PROFILE_INFO_KHR (";
        break;
    case 1000023001:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_CAPABILITIES_KHR (";
        break;
    case 1000023002:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_PICTURE_RESOURCE_INFO_KHR (";
        break;
    case 1000023003:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_SESSION_MEMORY_REQUIREMENTS_KHR (";
        break;
    case 1000023004:
        settings.stream() << "VK_STRUCTURE_TYPE_BIND_VIDEO_SESSION_MEMORY_INFO_KHR (";
        break;
    case 1000023005:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_SESSION_CREATE_INFO_KHR (";
        break;
    case 1000023006:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_CREATE_INFO_KHR (";
        break;
    case 1000023007:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_UPDATE_INFO_KHR (";
        break;
    case 1000023008:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_BEGIN_CODING_INFO_KHR (";
        break;
    case 1000023009:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_END_CODING_INFO_KHR (";
        break;
    case 1000023010:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_CODING_CONTROL_INFO_KHR (";
        break;
    case 1000023011:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_REFERENCE_SLOT_INFO_KHR (";
        break;
    case 1000023012:
        settings.stream() << "VK_STRUCTURE_TYPE_QUEUE_FAMILY_VIDEO_PROPERTIES_KHR (";
        break;
    case 1000023013:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_PROFILE_LIST_INFO_KHR (";
        break;
    case 1000023014:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_FORMAT_INFO_KHR (";
        break;
    case 1000023015:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_FORMAT_PROPERTIES_KHR (";
        break;
    case 1000023016:
        settings.stream() << "VK_STRUCTURE_TYPE_QUEUE_FAMILY_QUERY_RESULT_STATUS_PROPERTIES_KHR (";
        break;
    case 1000024000:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_DECODE_INFO_KHR (";
        break;
    case 1000024001:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_DECODE_CAPABILITIES_KHR (";
        break;
    case 1000024002:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_DECODE_USAGE_INFO_KHR (";
        break;
    case 1000026000:
        settings.stream() << "VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV (";
        break;
    case 1000026001:
        settings.stream() << "VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV (";
        break;
    case 1000026002:
        settings.stream() << "VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV (";
        break;
    case 1000028000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT (";
        break;
    case 1000028001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT (";
        break;
    case 1000028002:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT (";
        break;
    case 1000029000:
        settings.stream() << "VK_STRUCTURE_TYPE_CU_MODULE_CREATE_INFO_NVX (";
        break;
    case 1000029001:
        settings.stream() << "VK_STRUCTURE_TYPE_CU_FUNCTION_CREATE_INFO_NVX (";
        break;
    case 1000029002:
        settings.stream() << "VK_STRUCTURE_TYPE_CU_LAUNCH_INFO_NVX (";
        break;
    case 1000030000:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_VIEW_HANDLE_INFO_NVX (";
        break;
    case 1000030001:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_VIEW_ADDRESS_PROPERTIES_NVX (";
        break;
    case 1000038000:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_CAPABILITIES_EXT (";
        break;
    case 1000038001:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_CREATE_INFO_EXT (";
        break;
    case 1000038002:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_ADD_INFO_EXT (";
        break;
    case 1000038003:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_VCL_FRAME_INFO_EXT (";
        break;
    case 1000038004:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_DPB_SLOT_INFO_EXT (";
        break;
    case 1000038005:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_NALU_SLICE_INFO_EXT (";
        break;
    case 1000038007:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_PROFILE_INFO_EXT (";
        break;
    case 1000038008:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_INFO_EXT (";
        break;
    case 1000038009:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_LAYER_INFO_EXT (";
        break;
    case 1000039000:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_CAPABILITIES_EXT (";
        break;
    case 1000039001:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_CREATE_INFO_EXT (";
        break;
    case 1000039002:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_ADD_INFO_EXT (";
        break;
    case 1000039003:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_VCL_FRAME_INFO_EXT (";
        break;
    case 1000039004:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_DPB_SLOT_INFO_EXT (";
        break;
    case 1000039005:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_NALU_SLICE_SEGMENT_INFO_EXT (";
        break;
    case 1000039007:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_PROFILE_INFO_EXT (";
        break;
    case 1000039009:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_INFO_EXT (";
        break;
    case 1000039010:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_LAYER_INFO_EXT (";
        break;
    case 1000040000:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_CAPABILITIES_KHR (";
        break;
    case 1000040001:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PICTURE_INFO_KHR (";
        break;
    case 1000040003:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PROFILE_INFO_KHR (";
        break;
    case 1000040004:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_CREATE_INFO_KHR (";
        break;
    case 1000040005:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR (";
        break;
    case 1000040006:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_DPB_SLOT_INFO_KHR (";
        break;
    case 1000041000:
        settings.stream() << "VK_STRUCTURE_TYPE_TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD (";
        break;
    case 1000044006:
        settings.stream() << "VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR (";
        break;
    case 1000044007:
        settings.stream() << "VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT (";
        break;
    case 1000044008:
        settings.stream() << "VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD (";
        break;
    case 1000044009:
        settings.stream() << "VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX (";
        break;
    case 1000049000:
        settings.stream() << "VK_STRUCTURE_TYPE_STREAM_DESCRIPTOR_SURFACE_CREATE_INFO_GGP (";
        break;
    case 1000050000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV (";
        break;
    case 1000051000:
        settings.stream() << "VK_STRUCTURE_TYPE_PRIVATE_VENDOR_INFO_RESERVED_OFFSET_0_NV (";
        break;
    case 1000056000:
        settings.stream() << "VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV (";
        break;
    case 1000056001:
        settings.stream() << "VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV (";
        break;
    case 1000057000:
        settings.stream() << "VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_NV (";
        break;
    case 1000057001:
        settings.stream() << "VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_NV (";
        break;
    case 1000058000:
        settings.stream() << "VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV (";
        break;
    case 1000061000:
        settings.stream() << "VK_STRUCTURE_TYPE_VALIDATION_FLAGS_EXT (";
        break;
    case 1000062000:
        settings.stream() << "VK_STRUCTURE_TYPE_VI_SURFACE_CREATE_INFO_NN (";
        break;
    case 1000067000:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_VIEW_ASTC_DECODE_MODE_EXT (";
        break;
    case 1000067001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT (";
        break;
    case 1000068000:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_ROBUSTNESS_CREATE_INFO_EXT (";
        break;
    case 1000068001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES_EXT (";
        break;
    case 1000068002:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_PROPERTIES_EXT (";
        break;
    case 1000073000:
        settings.stream() << "VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR (";
        break;
    case 1000073001:
        settings.stream() << "VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR (";
        break;
    case 1000073002:
        settings.stream() << "VK_STRUCTURE_TYPE_MEMORY_WIN32_HANDLE_PROPERTIES_KHR (";
        break;
    case 1000073003:
        settings.stream() << "VK_STRUCTURE_TYPE_MEMORY_GET_WIN32_HANDLE_INFO_KHR (";
        break;
    case 1000074000:
        settings.stream() << "VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR (";
        break;
    case 1000074001:
        settings.stream() << "VK_STRUCTURE_TYPE_MEMORY_FD_PROPERTIES_KHR (";
        break;
    case 1000074002:
        settings.stream() << "VK_STRUCTURE_TYPE_MEMORY_GET_FD_INFO_KHR (";
        break;
    case 1000075000:
        settings.stream() << "VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR (";
        break;
    case 1000078000:
        settings.stream() << "VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR (";
        break;
    case 1000078001:
        settings.stream() << "VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR (";
        break;
    case 1000078002:
        settings.stream() << "VK_STRUCTURE_TYPE_D3D12_FENCE_SUBMIT_INFO_KHR (";
        break;
    case 1000078003:
        settings.stream() << "VK_STRUCTURE_TYPE_SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR (";
        break;
    case 1000079000:
        settings.stream() << "VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_FD_INFO_KHR (";
        break;
    case 1000079001:
        settings.stream() << "VK_STRUCTURE_TYPE_SEMAPHORE_GET_FD_INFO_KHR (";
        break;
    case 1000080000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR (";
        break;
    case 1000081000:
        settings.stream() << "VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT (";
        break;
    case 1000081001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT (";
        break;
    case 1000081002:
        settings.stream() << "VK_STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT (";
        break;
    case 1000084000:
        settings.stream() << "VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR (";
        break;
    case 1000087000:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV (";
        break;
    case 1000090000:
        settings.stream() << "VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_EXT (";
        break;
    case 1000091000:
        settings.stream() << "VK_STRUCTURE_TYPE_DISPLAY_POWER_INFO_EXT (";
        break;
    case 1000091001:
        settings.stream() << "VK_STRUCTURE_TYPE_DEVICE_EVENT_INFO_EXT (";
        break;
    case 1000091002:
        settings.stream() << "VK_STRUCTURE_TYPE_DISPLAY_EVENT_INFO_EXT (";
        break;
    case 1000091003:
        settings.stream() << "VK_STRUCTURE_TYPE_SWAPCHAIN_COUNTER_CREATE_INFO_EXT (";
        break;
    case 1000092000:
        settings.stream() << "VK_STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE (";
        break;
    case 1000097000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX (";
        break;
    case 1000098000:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV (";
        break;
    case 1000099000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT (";
        break;
    case 1000099001:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT (";
        break;
    case 1000101000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT (";
        break;
    case 1000101001:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT (";
        break;
    case 1000102000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT (";
        break;
    case 1000102001:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT (";
        break;
    case 1000105000:
        settings.stream() << "VK_STRUCTURE_TYPE_HDR_METADATA_EXT (";
        break;
    case 1000111000:
        settings.stream() << "VK_STRUCTURE_TYPE_SHARED_PRESENT_SURFACE_CAPABILITIES_KHR (";
        break;
    case 1000114000:
        settings.stream() << "VK_STRUCTURE_TYPE_IMPORT_FENCE_WIN32_HANDLE_INFO_KHR (";
        break;
    case 1000114001:
        settings.stream() << "VK_STRUCTURE_TYPE_EXPORT_FENCE_WIN32_HANDLE_INFO_KHR (";
        break;
    case 1000114002:
        settings.stream() << "VK_STRUCTURE_TYPE_FENCE_GET_WIN32_HANDLE_INFO_KHR (";
        break;
    case 1000115000:
        settings.stream() << "VK_STRUCTURE_TYPE_IMPORT_FENCE_FD_INFO_KHR (";
        break;
    case 1000115001:
        settings.stream() << "VK_STRUCTURE_TYPE_FENCE_GET_FD_INFO_KHR (";
        break;
    case 1000116000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR (";
        break;
    case 1000116001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR (";
        break;
    case 1000116002:
        settings.stream() << "VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR (";
        break;
    case 1000116003:
        settings.stream() << "VK_STRUCTURE_TYPE_PERFORMANCE_QUERY_SUBMIT_INFO_KHR (";
        break;
    case 1000116004:
        settings.stream() << "VK_STRUCTURE_TYPE_ACQUIRE_PROFILING_LOCK_INFO_KHR (";
        break;
    case 1000116005:
        settings.stream() << "VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_KHR (";
        break;
    case 1000116006:
        settings.stream() << "VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_DESCRIPTION_KHR (";
        break;
    case 1000119000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SURFACE_INFO_2_KHR (";
        break;
    case 1000119001:
        settings.stream() << "VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_KHR (";
        break;
    case 1000119002:
        settings.stream() << "VK_STRUCTURE_TYPE_SURFACE_FORMAT_2_KHR (";
        break;
    case 1000121000:
        settings.stream() << "VK_STRUCTURE_TYPE_DISPLAY_PROPERTIES_2_KHR (";
        break;
    case 1000121001:
        settings.stream() << "VK_STRUCTURE_TYPE_DISPLAY_PLANE_PROPERTIES_2_KHR (";
        break;
    case 1000121002:
        settings.stream() << "VK_STRUCTURE_TYPE_DISPLAY_MODE_PROPERTIES_2_KHR (";
        break;
    case 1000121003:
        settings.stream() << "VK_STRUCTURE_TYPE_DISPLAY_PLANE_INFO_2_KHR (";
        break;
    case 1000121004:
        settings.stream() << "VK_STRUCTURE_TYPE_DISPLAY_PLANE_CAPABILITIES_2_KHR (";
        break;
    case 1000122000:
        settings.stream() << "VK_STRUCTURE_TYPE_IOS_SURFACE_CREATE_INFO_MVK (";
        break;
    case 1000123000:
        settings.stream() << "VK_STRUCTURE_TYPE_MACOS_SURFACE_CREATE_INFO_MVK (";
        break;
    case 1000128000:
        settings.stream() << "VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT (";
        break;
    case 1000128001:
        settings.stream() << "VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_TAG_INFO_EXT (";
        break;
    case 1000128002:
        settings.stream() << "VK_STRUCTURE_TYPE_DEBUG_UTILS_LABEL_EXT (";
        break;
    case 1000128003:
        settings.stream() << "VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT (";
        break;
    case 1000128004:
        settings.stream() << "VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT (";
        break;
    case 1000129000:
        settings.stream() << "VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_USAGE_ANDROID (";
        break;
    case 1000129001:
        settings.stream() << "VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID (";
        break;
    case 1000129002:
        settings.stream() << "VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID (";
        break;
    case 1000129003:
        settings.stream() << "VK_STRUCTURE_TYPE_IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID (";
        break;
    case 1000129004:
        settings.stream() << "VK_STRUCTURE_TYPE_MEMORY_GET_ANDROID_HARDWARE_BUFFER_INFO_ANDROID (";
        break;
    case 1000129005:
        settings.stream() << "VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID (";
        break;
    case 1000129006:
        settings.stream() << "VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_2_ANDROID (";
        break;
    case 1000143000:
        settings.stream() << "VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT (";
        break;
    case 1000143001:
        settings.stream() << "VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT (";
        break;
    case 1000143002:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT (";
        break;
    case 1000143003:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT (";
        break;
    case 1000143004:
        settings.stream() << "VK_STRUCTURE_TYPE_MULTISAMPLE_PROPERTIES_EXT (";
        break;
    case 1000148000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT (";
        break;
    case 1000148001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT (";
        break;
    case 1000148002:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT (";
        break;
    case 1000149000:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV (";
        break;
    case 1000150007:
        settings.stream() << "VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR (";
        break;
    case 1000150000:
        settings.stream() << "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_GEOMETRY_INFO_KHR (";
        break;
    case 1000150002:
        settings.stream() << "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR (";
        break;
    case 1000150003:
        settings.stream() << "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_AABBS_DATA_KHR (";
        break;
    case 1000150004:
        settings.stream() << "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_INSTANCES_DATA_KHR (";
        break;
    case 1000150005:
        settings.stream() << "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_TRIANGLES_DATA_KHR (";
        break;
    case 1000150006:
        settings.stream() << "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_KHR (";
        break;
    case 1000150009:
        settings.stream() << "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_INFO_KHR (";
        break;
    case 1000150010:
        settings.stream() << "VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_INFO_KHR (";
        break;
    case 1000150011:
        settings.stream() << "VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_TO_MEMORY_INFO_KHR (";
        break;
    case 1000150012:
        settings.stream() << "VK_STRUCTURE_TYPE_COPY_MEMORY_TO_ACCELERATION_STRUCTURE_INFO_KHR (";
        break;
    case 1000150013:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR (";
        break;
    case 1000150014:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR (";
        break;
    case 1000150017:
        settings.stream() << "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR (";
        break;
    case 1000150020:
        settings.stream() << "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR (";
        break;
    case 1000347000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR (";
        break;
    case 1000347001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR (";
        break;
    case 1000150015:
        settings.stream() << "VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_KHR (";
        break;
    case 1000150016:
        settings.stream() << "VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_KHR (";
        break;
    case 1000150018:
        settings.stream() << "VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_INTERFACE_CREATE_INFO_KHR (";
        break;
    case 1000348013:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR (";
        break;
    case 1000152000:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV (";
        break;
    case 1000154000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV (";
        break;
    case 1000154001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_PROPERTIES_NV (";
        break;
    case 1000158000:
        settings.stream() << "VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT (";
        break;
    case 1000158002:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT (";
        break;
    case 1000158003:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT (";
        break;
    case 1000158004:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT (";
        break;
    case 1000158005:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT (";
        break;
    case 1000158006:
        settings.stream() << "VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT (";
        break;
    case 1000160000:
        settings.stream() << "VK_STRUCTURE_TYPE_VALIDATION_CACHE_CREATE_INFO_EXT (";
        break;
    case 1000160001:
        settings.stream() << "VK_STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT (";
        break;
    case 1000163000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_FEATURES_KHR (";
        break;
    case 1000163001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR (";
        break;
    case 1000164000:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SHADING_RATE_IMAGE_STATE_CREATE_INFO_NV (";
        break;
    case 1000164001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV (";
        break;
    case 1000164002:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV (";
        break;
    case 1000164005:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_COARSE_SAMPLE_ORDER_STATE_CREATE_INFO_NV (";
        break;
    case 1000165000:
        settings.stream() << "VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_NV (";
        break;
    case 1000165001:
        settings.stream() << "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_NV (";
        break;
    case 1000165003:
        settings.stream() << "VK_STRUCTURE_TYPE_GEOMETRY_NV (";
        break;
    case 1000165004:
        settings.stream() << "VK_STRUCTURE_TYPE_GEOMETRY_TRIANGLES_NV (";
        break;
    case 1000165005:
        settings.stream() << "VK_STRUCTURE_TYPE_GEOMETRY_AABB_NV (";
        break;
    case 1000165006:
        settings.stream() << "VK_STRUCTURE_TYPE_BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV (";
        break;
    case 1000165007:
        settings.stream() << "VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV (";
        break;
    case 1000165008:
        settings.stream() << "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV (";
        break;
    case 1000165009:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV (";
        break;
    case 1000165011:
        settings.stream() << "VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_NV (";
        break;
    case 1000165012:
        settings.stream() << "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_INFO_NV (";
        break;
    case 1000166000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV (";
        break;
    case 1000166001:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV (";
        break;
    case 1000170000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT (";
        break;
    case 1000170001:
        settings.stream() << "VK_STRUCTURE_TYPE_FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT (";
        break;
    case 1000178000:
        settings.stream() << "VK_STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT (";
        break;
    case 1000178001:
        settings.stream() << "VK_STRUCTURE_TYPE_MEMORY_HOST_POINTER_PROPERTIES_EXT (";
        break;
    case 1000178002:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT (";
        break;
    case 1000181000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR (";
        break;
    case 1000183000:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD (";
        break;
    case 1000184000:
        settings.stream() << "VK_STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_EXT (";
        break;
    case 1000185000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD (";
        break;
    case 1000187000:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_CAPABILITIES_KHR (";
        break;
    case 1000187001:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_CREATE_INFO_KHR (";
        break;
    case 1000187002:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR (";
        break;
    case 1000187003:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PROFILE_INFO_KHR (";
        break;
    case 1000187004:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PICTURE_INFO_KHR (";
        break;
    case 1000187005:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_DPB_SLOT_INFO_KHR (";
        break;
    case 1000174000:
        settings.stream() << "VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_KHR (";
        break;
    case 1000388000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES_KHR (";
        break;
    case 1000388001:
        settings.stream() << "VK_STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES_KHR (";
        break;
    case 1000189000:
        settings.stream() << "VK_STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD (";
        break;
    case 1000190000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT (";
        break;
    case 1000190001:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO_EXT (";
        break;
    case 1000190002:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT (";
        break;
    case 1000191000:
        settings.stream() << "VK_STRUCTURE_TYPE_PRESENT_FRAME_TOKEN_GGP (";
        break;
    case 1000201000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_NV (";
        break;
    case 1000202000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV (";
        break;
    case 1000202001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV (";
        break;
    case 1000204000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV (";
        break;
    case 1000205000:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_EXCLUSIVE_SCISSOR_STATE_CREATE_INFO_NV (";
        break;
    case 1000205002:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV (";
        break;
    case 1000206000:
        settings.stream() << "VK_STRUCTURE_TYPE_CHECKPOINT_DATA_NV (";
        break;
    case 1000206001:
        settings.stream() << "VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV (";
        break;
    case 1000209000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL (";
        break;
    case 1000210000:
        settings.stream() << "VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL (";
        break;
    case 1000210001:
        settings.stream() << "VK_STRUCTURE_TYPE_INITIALIZE_PERFORMANCE_API_INFO_INTEL (";
        break;
    case 1000210002:
        settings.stream() << "VK_STRUCTURE_TYPE_PERFORMANCE_MARKER_INFO_INTEL (";
        break;
    case 1000210003:
        settings.stream() << "VK_STRUCTURE_TYPE_PERFORMANCE_STREAM_MARKER_INFO_INTEL (";
        break;
    case 1000210004:
        settings.stream() << "VK_STRUCTURE_TYPE_PERFORMANCE_OVERRIDE_INFO_INTEL (";
        break;
    case 1000210005:
        settings.stream() << "VK_STRUCTURE_TYPE_PERFORMANCE_CONFIGURATION_ACQUIRE_INFO_INTEL (";
        break;
    case 1000212000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT (";
        break;
    case 1000213000:
        settings.stream() << "VK_STRUCTURE_TYPE_DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD (";
        break;
    case 1000213001:
        settings.stream() << "VK_STRUCTURE_TYPE_SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD (";
        break;
    case 1000214000:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGEPIPE_SURFACE_CREATE_INFO_FUCHSIA (";
        break;
    case 1000217000:
        settings.stream() << "VK_STRUCTURE_TYPE_METAL_SURFACE_CREATE_INFO_EXT (";
        break;
    case 1000218000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT (";
        break;
    case 1000218001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT (";
        break;
    case 1000218002:
        settings.stream() << "VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT (";
        break;
    case 1000226000:
        settings.stream() << "VK_STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR (";
        break;
    case 1000226001:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR (";
        break;
    case 1000226002:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR (";
        break;
    case 1000226003:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR (";
        break;
    case 1000226004:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_KHR (";
        break;
    case 1000227000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD (";
        break;
    case 1000229000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD (";
        break;
    case 1000234000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT (";
        break;
    case 1000237000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT (";
        break;
    case 1000238000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT (";
        break;
    case 1000238001:
        settings.stream() << "VK_STRUCTURE_TYPE_MEMORY_PRIORITY_ALLOCATE_INFO_EXT (";
        break;
    case 1000239000:
        settings.stream() << "VK_STRUCTURE_TYPE_SURFACE_PROTECTED_CAPABILITIES_KHR (";
        break;
    case 1000240000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV (";
        break;
    case 1000244000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT (";
        break;
    case 1000244002:
        settings.stream() << "VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT (";
        break;
    case 1000247000:
        settings.stream() << "VK_STRUCTURE_TYPE_VALIDATION_FEATURES_EXT (";
        break;
    case 1000248000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR (";
        break;
    case 1000249000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV (";
        break;
    case 1000249001:
        settings.stream() << "VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_NV (";
        break;
    case 1000249002:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_NV (";
        break;
    case 1000250000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV (";
        break;
    case 1000250001:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_REDUCTION_STATE_CREATE_INFO_NV (";
        break;
    case 1000250002:
        settings.stream() << "VK_STRUCTURE_TYPE_FRAMEBUFFER_MIXED_SAMPLES_COMBINATION_NV (";
        break;
    case 1000251000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT (";
        break;
    case 1000252000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT (";
        break;
    case 1000254000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT (";
        break;
    case 1000254001:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT (";
        break;
    case 1000254002:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT (";
        break;
    case 1000255000:
        settings.stream() << "VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_INFO_EXT (";
        break;
    case 1000255002:
        settings.stream() << "VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_FULL_SCREEN_EXCLUSIVE_EXT (";
        break;
    case 1000255001:
        settings.stream() << "VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_WIN32_INFO_EXT (";
        break;
    case 1000256000:
        settings.stream() << "VK_STRUCTURE_TYPE_HEADLESS_SURFACE_CREATE_INFO_EXT (";
        break;
    case 1000259000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT (";
        break;
    case 1000259001:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_EXT (";
        break;
    case 1000259002:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT (";
        break;
    case 1000260000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT (";
        break;
    case 1000265000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT (";
        break;
    case 1000267000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT (";
        break;
    case 1000269000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR (";
        break;
    case 1000269001:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_INFO_KHR (";
        break;
    case 1000269002:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_PROPERTIES_KHR (";
        break;
    case 1000269003:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INFO_KHR (";
        break;
    case 1000269004:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_STATISTIC_KHR (";
        break;
    case 1000269005:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INTERNAL_REPRESENTATION_KHR (";
        break;
    case 1000271000:
        settings.stream() << "VK_STRUCTURE_TYPE_MEMORY_MAP_INFO_KHR (";
        break;
    case 1000271001:
        settings.stream() << "VK_STRUCTURE_TYPE_MEMORY_UNMAP_INFO_KHR (";
        break;
    case 1000273000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT (";
        break;
    case 1000274000:
        settings.stream() << "VK_STRUCTURE_TYPE_SURFACE_PRESENT_MODE_EXT (";
        break;
    case 1000274001:
        settings.stream() << "VK_STRUCTURE_TYPE_SURFACE_PRESENT_SCALING_CAPABILITIES_EXT (";
        break;
    case 1000274002:
        settings.stream() << "VK_STRUCTURE_TYPE_SURFACE_PRESENT_MODE_COMPATIBILITY_EXT (";
        break;
    case 1000275000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SWAPCHAIN_MAINTENANCE_1_FEATURES_EXT (";
        break;
    case 1000275001:
        settings.stream() << "VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_FENCE_INFO_EXT (";
        break;
    case 1000275002:
        settings.stream() << "VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODES_CREATE_INFO_EXT (";
        break;
    case 1000275003:
        settings.stream() << "VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODE_INFO_EXT (";
        break;
    case 1000275004:
        settings.stream() << "VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_SCALING_CREATE_INFO_EXT (";
        break;
    case 1000275005:
        settings.stream() << "VK_STRUCTURE_TYPE_RELEASE_SWAPCHAIN_IMAGES_INFO_EXT (";
        break;
    case 1000277000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_NV (";
        break;
    case 1000277001:
        settings.stream() << "VK_STRUCTURE_TYPE_GRAPHICS_SHADER_GROUP_CREATE_INFO_NV (";
        break;
    case 1000277002:
        settings.stream() << "VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV (";
        break;
    case 1000277003:
        settings.stream() << "VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_TOKEN_NV (";
        break;
    case 1000277004:
        settings.stream() << "VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NV (";
        break;
    case 1000277005:
        settings.stream() << "VK_STRUCTURE_TYPE_GENERATED_COMMANDS_INFO_NV (";
        break;
    case 1000277006:
        settings.stream() << "VK_STRUCTURE_TYPE_GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_NV (";
        break;
    case 1000277007:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV (";
        break;
    case 1000278000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INHERITED_VIEWPORT_SCISSOR_FEATURES_NV (";
        break;
    case 1000278001:
        settings.stream() << "VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_VIEWPORT_SCISSOR_INFO_NV (";
        break;
    case 1000281000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT (";
        break;
    case 1000282000:
        settings.stream() << "VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDER_PASS_TRANSFORM_INFO_QCOM (";
        break;
    case 1000282001:
        settings.stream() << "VK_STRUCTURE_TYPE_RENDER_PASS_TRANSFORM_BEGIN_INFO_QCOM (";
        break;
    case 1000284000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT (";
        break;
    case 1000284001:
        settings.stream() << "VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT (";
        break;
    case 1000284002:
        settings.stream() << "VK_STRUCTURE_TYPE_DEVICE_MEMORY_REPORT_CALLBACK_DATA_EXT (";
        break;
    case 1000286000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT (";
        break;
    case 1000286001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT (";
        break;
    case 1000287000:
        settings.stream() << "VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT (";
        break;
    case 1000287001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT (";
        break;
    case 1000287002:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT (";
        break;
    case 1000290000:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR (";
        break;
    case 1000292000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_BARRIER_FEATURES_NV (";
        break;
    case 1000292001:
        settings.stream() << "VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_PRESENT_BARRIER_NV (";
        break;
    case 1000292002:
        settings.stream() << "VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_BARRIER_CREATE_INFO_NV (";
        break;
    case 1000294000:
        settings.stream() << "VK_STRUCTURE_TYPE_PRESENT_ID_KHR (";
        break;
    case 1000294001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_ID_FEATURES_KHR (";
        break;
    case 1000299000:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_ENCODE_INFO_KHR (";
        break;
    case 1000299001:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_INFO_KHR (";
        break;
    case 1000299002:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_LAYER_INFO_KHR (";
        break;
    case 1000299003:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_ENCODE_CAPABILITIES_KHR (";
        break;
    case 1000299004:
        settings.stream() << "VK_STRUCTURE_TYPE_VIDEO_ENCODE_USAGE_INFO_KHR (";
        break;
    case 1000299005:
        settings.stream() << "VK_STRUCTURE_TYPE_QUERY_POOL_VIDEO_ENCODE_FEEDBACK_CREATE_INFO_KHR (";
        break;
    case 1000300000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DIAGNOSTICS_CONFIG_FEATURES_NV (";
        break;
    case 1000300001:
        settings.stream() << "VK_STRUCTURE_TYPE_DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV (";
        break;
    case 1000308000:
        settings.stream() << "VK_STRUCTURE_TYPE_REFRESH_OBJECT_LIST_KHR (";
        break;
    case 1000309000:
        settings.stream() << "VK_STRUCTURE_TYPE_RESERVED_QCOM (";
        break;
    case 1000310000:
        settings.stream() << "VK_STRUCTURE_TYPE_QUERY_LOW_LATENCY_SUPPORT_NV (";
        break;
    case 1000311000:
        settings.stream() << "VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT (";
        break;
    case 1000311001:
        settings.stream() << "VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECTS_INFO_EXT (";
        break;
    case 1000311002:
        settings.stream() << "VK_STRUCTURE_TYPE_EXPORT_METAL_DEVICE_INFO_EXT (";
        break;
    case 1000311003:
        settings.stream() << "VK_STRUCTURE_TYPE_EXPORT_METAL_COMMAND_QUEUE_INFO_EXT (";
        break;
    case 1000311004:
        settings.stream() << "VK_STRUCTURE_TYPE_EXPORT_METAL_BUFFER_INFO_EXT (";
        break;
    case 1000311005:
        settings.stream() << "VK_STRUCTURE_TYPE_IMPORT_METAL_BUFFER_INFO_EXT (";
        break;
    case 1000311006:
        settings.stream() << "VK_STRUCTURE_TYPE_EXPORT_METAL_TEXTURE_INFO_EXT (";
        break;
    case 1000311007:
        settings.stream() << "VK_STRUCTURE_TYPE_IMPORT_METAL_TEXTURE_INFO_EXT (";
        break;
    case 1000311008:
        settings.stream() << "VK_STRUCTURE_TYPE_EXPORT_METAL_IO_SURFACE_INFO_EXT (";
        break;
    case 1000311009:
        settings.stream() << "VK_STRUCTURE_TYPE_IMPORT_METAL_IO_SURFACE_INFO_EXT (";
        break;
    case 1000311010:
        settings.stream() << "VK_STRUCTURE_TYPE_EXPORT_METAL_SHARED_EVENT_INFO_EXT (";
        break;
    case 1000311011:
        settings.stream() << "VK_STRUCTURE_TYPE_IMPORT_METAL_SHARED_EVENT_INFO_EXT (";
        break;
    case 1000314008:
        settings.stream() << "VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV (";
        break;
    case 1000314009:
        settings.stream() << "VK_STRUCTURE_TYPE_CHECKPOINT_DATA_2_NV (";
        break;
    case 1000316000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_PROPERTIES_EXT (";
        break;
    case 1000316001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_DENSITY_MAP_PROPERTIES_EXT (";
        break;
    case 1000316002:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_FEATURES_EXT (";
        break;
    case 1000316003:
        settings.stream() << "VK_STRUCTURE_TYPE_DESCRIPTOR_ADDRESS_INFO_EXT (";
        break;
    case 1000316004:
        settings.stream() << "VK_STRUCTURE_TYPE_DESCRIPTOR_GET_INFO_EXT (";
        break;
    case 1000316005:
        settings.stream() << "VK_STRUCTURE_TYPE_BUFFER_CAPTURE_DESCRIPTOR_DATA_INFO_EXT (";
        break;
    case 1000316006:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_CAPTURE_DESCRIPTOR_DATA_INFO_EXT (";
        break;
    case 1000316007:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_VIEW_CAPTURE_DESCRIPTOR_DATA_INFO_EXT (";
        break;
    case 1000316008:
        settings.stream() << "VK_STRUCTURE_TYPE_SAMPLER_CAPTURE_DESCRIPTOR_DATA_INFO_EXT (";
        break;
    case 1000316010:
        settings.stream() << "VK_STRUCTURE_TYPE_OPAQUE_CAPTURE_DESCRIPTOR_DATA_CREATE_INFO_EXT (";
        break;
    case 1000316011:
        settings.stream() << "VK_STRUCTURE_TYPE_DESCRIPTOR_BUFFER_BINDING_INFO_EXT (";
        break;
    case 1000316012:
        settings.stream() << "VK_STRUCTURE_TYPE_DESCRIPTOR_BUFFER_BINDING_PUSH_DESCRIPTOR_BUFFER_HANDLE_EXT (";
        break;
    case 1000316009:
        settings.stream() << "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CAPTURE_DESCRIPTOR_DATA_INFO_EXT (";
        break;
    case 1000320000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT (";
        break;
    case 1000320001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT (";
        break;
    case 1000320002:
        settings.stream() << "VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT (";
        break;
    case 1000321000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EARLY_AND_LATE_FRAGMENT_TESTS_FEATURES_AMD (";
        break;
    case 1000203000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR (";
        break;
    case 1000322000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_PROPERTIES_KHR (";
        break;
    case 1000323000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR (";
        break;
    case 1000326000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_PROPERTIES_NV (";
        break;
    case 1000326001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV (";
        break;
    case 1000326002:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_ENUM_STATE_CREATE_INFO_NV (";
        break;
    case 1000327000:
        settings.stream() << "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_MOTION_TRIANGLES_DATA_NV (";
        break;
    case 1000327001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MOTION_BLUR_FEATURES_NV (";
        break;
    case 1000327002:
        settings.stream() << "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MOTION_INFO_NV (";
        break;
    case 1000328000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_EXT (";
        break;
    case 1000328001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_EXT (";
        break;
    case 1000330000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT (";
        break;
    case 1000332000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT (";
        break;
    case 1000332001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_PROPERTIES_EXT (";
        break;
    case 1000333000:
        settings.stream() << "VK_STRUCTURE_TYPE_COPY_COMMAND_TRANSFORM_INFO_QCOM (";
        break;
    case 1000336000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR (";
        break;
    case 1000338000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT (";
        break;
    case 1000338001:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT (";
        break;
    case 1000338002:
        settings.stream() << "VK_STRUCTURE_TYPE_SUBRESOURCE_LAYOUT_2_EXT (";
        break;
    case 1000338003:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_SUBRESOURCE_2_EXT (";
        break;
    case 1000338004:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_PROPERTIES_EXT (";
        break;
    case 1000339000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_FEATURES_EXT (";
        break;
    case 1000340000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT (";
        break;
    case 1000341000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FAULT_FEATURES_EXT (";
        break;
    case 1000341001:
        settings.stream() << "VK_STRUCTURE_TYPE_DEVICE_FAULT_COUNTS_EXT (";
        break;
    case 1000341002:
        settings.stream() << "VK_STRUCTURE_TYPE_DEVICE_FAULT_INFO_EXT (";
        break;
    case 1000344000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RGBA10X6_FORMATS_FEATURES_EXT (";
        break;
    case 1000346000:
        settings.stream() << "VK_STRUCTURE_TYPE_DIRECTFB_SURFACE_CREATE_INFO_EXT (";
        break;
    case 1000352000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT (";
        break;
    case 1000352001:
        settings.stream() << "VK_STRUCTURE_TYPE_VERTEX_INPUT_BINDING_DESCRIPTION_2_EXT (";
        break;
    case 1000352002:
        settings.stream() << "VK_STRUCTURE_TYPE_VERTEX_INPUT_ATTRIBUTE_DESCRIPTION_2_EXT (";
        break;
    case 1000353000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRM_PROPERTIES_EXT (";
        break;
    case 1000354000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ADDRESS_BINDING_REPORT_FEATURES_EXT (";
        break;
    case 1000354001:
        settings.stream() << "VK_STRUCTURE_TYPE_DEVICE_ADDRESS_BINDING_CALLBACK_DATA_EXT (";
        break;
    case 1000355000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT (";
        break;
    case 1000355001:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_DEPTH_CLIP_CONTROL_CREATE_INFO_EXT (";
        break;
    case 1000356000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT (";
        break;
    case 1000364000:
        settings.stream() << "VK_STRUCTURE_TYPE_IMPORT_MEMORY_ZIRCON_HANDLE_INFO_FUCHSIA (";
        break;
    case 1000364001:
        settings.stream() << "VK_STRUCTURE_TYPE_MEMORY_ZIRCON_HANDLE_PROPERTIES_FUCHSIA (";
        break;
    case 1000364002:
        settings.stream() << "VK_STRUCTURE_TYPE_MEMORY_GET_ZIRCON_HANDLE_INFO_FUCHSIA (";
        break;
    case 1000365000:
        settings.stream() << "VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_ZIRCON_HANDLE_INFO_FUCHSIA (";
        break;
    case 1000365001:
        settings.stream() << "VK_STRUCTURE_TYPE_SEMAPHORE_GET_ZIRCON_HANDLE_INFO_FUCHSIA (";
        break;
    case 1000366000:
        settings.stream() << "VK_STRUCTURE_TYPE_BUFFER_COLLECTION_CREATE_INFO_FUCHSIA (";
        break;
    case 1000366001:
        settings.stream() << "VK_STRUCTURE_TYPE_IMPORT_MEMORY_BUFFER_COLLECTION_FUCHSIA (";
        break;
    case 1000366002:
        settings.stream() << "VK_STRUCTURE_TYPE_BUFFER_COLLECTION_IMAGE_CREATE_INFO_FUCHSIA (";
        break;
    case 1000366003:
        settings.stream() << "VK_STRUCTURE_TYPE_BUFFER_COLLECTION_PROPERTIES_FUCHSIA (";
        break;
    case 1000366004:
        settings.stream() << "VK_STRUCTURE_TYPE_BUFFER_CONSTRAINTS_INFO_FUCHSIA (";
        break;
    case 1000366005:
        settings.stream() << "VK_STRUCTURE_TYPE_BUFFER_COLLECTION_BUFFER_CREATE_INFO_FUCHSIA (";
        break;
    case 1000366006:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_CONSTRAINTS_INFO_FUCHSIA (";
        break;
    case 1000366007:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_FORMAT_CONSTRAINTS_INFO_FUCHSIA (";
        break;
    case 1000366008:
        settings.stream() << "VK_STRUCTURE_TYPE_SYSMEM_COLOR_SPACE_FUCHSIA (";
        break;
    case 1000366009:
        settings.stream() << "VK_STRUCTURE_TYPE_BUFFER_COLLECTION_CONSTRAINTS_INFO_FUCHSIA (";
        break;
    case 1000369000:
        settings.stream() << "VK_STRUCTURE_TYPE_SUBPASS_SHADING_PIPELINE_CREATE_INFO_HUAWEI (";
        break;
    case 1000369001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_FEATURES_HUAWEI (";
        break;
    case 1000369002:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_PROPERTIES_HUAWEI (";
        break;
    case 1000370000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INVOCATION_MASK_FEATURES_HUAWEI (";
        break;
    case 1000371000:
        settings.stream() << "VK_STRUCTURE_TYPE_MEMORY_GET_REMOTE_ADDRESS_INFO_NV (";
        break;
    case 1000371001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_RDMA_FEATURES_NV (";
        break;
    case 1000372000:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_PROPERTIES_IDENTIFIER_EXT (";
        break;
    case 1000372001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROPERTIES_FEATURES_EXT (";
        break;
    case 1000373000:
        settings.stream() << "VK_STRUCTURE_TYPE_IMPORT_FENCE_SCI_SYNC_INFO_NV (";
        break;
    case 1000373001:
        settings.stream() << "VK_STRUCTURE_TYPE_EXPORT_FENCE_SCI_SYNC_INFO_NV (";
        break;
    case 1000373002:
        settings.stream() << "VK_STRUCTURE_TYPE_FENCE_GET_SCI_SYNC_INFO_NV (";
        break;
    case 1000373003:
        settings.stream() << "VK_STRUCTURE_TYPE_SCI_SYNC_ATTRIBUTES_INFO_NV (";
        break;
    case 1000373004:
        settings.stream() << "VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_SCI_SYNC_INFO_NV (";
        break;
    case 1000373005:
        settings.stream() << "VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_SCI_SYNC_INFO_NV (";
        break;
    case 1000373006:
        settings.stream() << "VK_STRUCTURE_TYPE_SEMAPHORE_GET_SCI_SYNC_INFO_NV (";
        break;
    case 1000373007:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SCI_SYNC_FEATURES_NV (";
        break;
    case 1000374000:
        settings.stream() << "VK_STRUCTURE_TYPE_IMPORT_MEMORY_SCI_BUF_INFO_NV (";
        break;
    case 1000374001:
        settings.stream() << "VK_STRUCTURE_TYPE_EXPORT_MEMORY_SCI_BUF_INFO_NV (";
        break;
    case 1000374002:
        settings.stream() << "VK_STRUCTURE_TYPE_MEMORY_GET_SCI_BUF_INFO_NV (";
        break;
    case 1000374003:
        settings.stream() << "VK_STRUCTURE_TYPE_MEMORY_SCI_BUF_PROPERTIES_NV (";
        break;
    case 1000374004:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_SCI_BUF_FEATURES_NV (";
        break;
    case 1000376000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_FEATURES_EXT (";
        break;
    case 1000376001:
        settings.stream() << "VK_STRUCTURE_TYPE_SUBPASS_RESOLVE_PERFORMANCE_QUERY_EXT (";
        break;
    case 1000376002:
        settings.stream() << "VK_STRUCTURE_TYPE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_INFO_EXT (";
        break;
    case 1000377000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT (";
        break;
    case 1000378000:
        settings.stream() << "VK_STRUCTURE_TYPE_SCREEN_SURFACE_CREATE_INFO_QNX (";
        break;
    case 1000381000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT (";
        break;
    case 1000381001:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT (";
        break;
    case 1000382000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT (";
        break;
    case 1000386000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR (";
        break;
    case 1000391000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT (";
        break;
    case 1000391001:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_VIEW_MIN_LOD_CREATE_INFO_EXT (";
        break;
    case 1000392000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT (";
        break;
    case 1000392001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT (";
        break;
    case 1000393000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT (";
        break;
    case 1000395000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TILE_IMAGE_FEATURES_EXT (";
        break;
    case 1000395001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TILE_IMAGE_PROPERTIES_EXT (";
        break;
    case 1000396000:
        settings.stream() << "VK_STRUCTURE_TYPE_MICROMAP_BUILD_INFO_EXT (";
        break;
    case 1000396001:
        settings.stream() << "VK_STRUCTURE_TYPE_MICROMAP_VERSION_INFO_EXT (";
        break;
    case 1000396002:
        settings.stream() << "VK_STRUCTURE_TYPE_COPY_MICROMAP_INFO_EXT (";
        break;
    case 1000396003:
        settings.stream() << "VK_STRUCTURE_TYPE_COPY_MICROMAP_TO_MEMORY_INFO_EXT (";
        break;
    case 1000396004:
        settings.stream() << "VK_STRUCTURE_TYPE_COPY_MEMORY_TO_MICROMAP_INFO_EXT (";
        break;
    case 1000396005:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_FEATURES_EXT (";
        break;
    case 1000396006:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_PROPERTIES_EXT (";
        break;
    case 1000396007:
        settings.stream() << "VK_STRUCTURE_TYPE_MICROMAP_CREATE_INFO_EXT (";
        break;
    case 1000396008:
        settings.stream() << "VK_STRUCTURE_TYPE_MICROMAP_BUILD_SIZES_INFO_EXT (";
        break;
    case 1000396009:
        settings.stream() << "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_TRIANGLES_OPACITY_MICROMAP_EXT (";
        break;
    case 1000397000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISPLACEMENT_MICROMAP_FEATURES_NV (";
        break;
    case 1000397001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISPLACEMENT_MICROMAP_PROPERTIES_NV (";
        break;
    case 1000397002:
        settings.stream() << "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_TRIANGLES_DISPLACEMENT_MICROMAP_NV (";
        break;
    case 1000404000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_FEATURES_HUAWEI (";
        break;
    case 1000404001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_PROPERTIES_HUAWEI (";
        break;
    case 1000411000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT (";
        break;
    case 1000411001:
        settings.stream() << "VK_STRUCTURE_TYPE_SAMPLER_BORDER_COLOR_COMPONENT_MAPPING_CREATE_INFO_EXT (";
        break;
    case 1000412000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PAGEABLE_DEVICE_LOCAL_MEMORY_FEATURES_EXT (";
        break;
    case 1000415000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_ARM (";
        break;
    case 1000418000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_SLICED_VIEW_OF_3D_FEATURES_EXT (";
        break;
    case 1000418001:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_VIEW_SLICED_CREATE_INFO_EXT (";
        break;
    case 1000420000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_SET_HOST_MAPPING_FEATURES_VALVE (";
        break;
    case 1000420001:
        settings.stream() << "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_BINDING_REFERENCE_VALVE (";
        break;
    case 1000420002:
        settings.stream() << "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_HOST_MAPPING_INFO_VALVE (";
        break;
    case 1000421000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_EXT (";
        break;
    case 1000422000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT (";
        break;
    case 1000425000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_FEATURES_QCOM (";
        break;
    case 1000425001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_PROPERTIES_QCOM (";
        break;
    case 1000425002:
        settings.stream() << "VK_STRUCTURE_TYPE_SUBPASS_FRAGMENT_DENSITY_MAP_OFFSET_END_INFO_QCOM (";
        break;
    case 1000426000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_FEATURES_NV (";
        break;
    case 1000426001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_PROPERTIES_NV (";
        break;
    case 1000427000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_DECOMPRESSION_FEATURES_NV (";
        break;
    case 1000427001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_DECOMPRESSION_PROPERTIES_NV (";
        break;
    case 1000430000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINEAR_COLOR_ATTACHMENT_FEATURES_NV (";
        break;
    case 1000435000:
        settings.stream() << "VK_STRUCTURE_TYPE_APPLICATION_PARAMETERS_EXT (";
        break;
    case 1000437000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT (";
        break;
    case 1000440000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_FEATURES_QCOM (";
        break;
    case 1000440001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_PROPERTIES_QCOM (";
        break;
    case 1000440002:
        settings.stream() << "VK_STRUCTURE_TYPE_IMAGE_VIEW_SAMPLE_WEIGHT_CREATE_INFO_QCOM (";
        break;
    case 1000455000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT (";
        break;
    case 1000455001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_PROPERTIES_EXT (";
        break;
    case 1000458000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_MERGE_FEEDBACK_FEATURES_EXT (";
        break;
    case 1000458001:
        settings.stream() << "VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_CONTROL_EXT (";
        break;
    case 1000458002:
        settings.stream() << "VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_FEEDBACK_CREATE_INFO_EXT (";
        break;
    case 1000458003:
        settings.stream() << "VK_STRUCTURE_TYPE_RENDER_PASS_SUBPASS_FEEDBACK_CREATE_INFO_EXT (";
        break;
    case 1000459000:
        settings.stream() << "VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_INFO_LUNARG (";
        break;
    case 1000459001:
        settings.stream() << "VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_LIST_LUNARG (";
        break;
    case 1000462000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MODULE_IDENTIFIER_FEATURES_EXT (";
        break;
    case 1000462001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MODULE_IDENTIFIER_PROPERTIES_EXT (";
        break;
    case 1000462002:
        settings.stream() << "VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_MODULE_IDENTIFIER_CREATE_INFO_EXT (";
        break;
    case 1000462003:
        settings.stream() << "VK_STRUCTURE_TYPE_SHADER_MODULE_IDENTIFIER_EXT (";
        break;
    case 1000342000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT (";
        break;
    case 1000464000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_FEATURES_NV (";
        break;
    case 1000464001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_PROPERTIES_NV (";
        break;
    case 1000464002:
        settings.stream() << "VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_INFO_NV (";
        break;
    case 1000464003:
        settings.stream() << "VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_PROPERTIES_NV (";
        break;
    case 1000464004:
        settings.stream() << "VK_STRUCTURE_TYPE_OPTICAL_FLOW_SESSION_CREATE_INFO_NV (";
        break;
    case 1000464005:
        settings.stream() << "VK_STRUCTURE_TYPE_OPTICAL_FLOW_EXECUTE_INFO_NV (";
        break;
    case 1000464010:
        settings.stream() << "VK_STRUCTURE_TYPE_OPTICAL_FLOW_SESSION_CREATE_PRIVATE_DATA_INFO_NV (";
        break;
    case 1000465000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_DITHERING_FEATURES_EXT (";
        break;
    case 1000466000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES_EXT (";
        break;
    case 1000481000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_POSITION_FETCH_FEATURES_KHR (";
        break;
    case 1000482000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_OBJECT_FEATURES_EXT (";
        break;
    case 1000482001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_OBJECT_PROPERTIES_EXT (";
        break;
    case 1000482002:
        settings.stream() << "VK_STRUCTURE_TYPE_SHADER_CREATE_INFO_EXT (";
        break;
    case 1000484000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_PROPERTIES_FEATURES_QCOM (";
        break;
    case 1000484001:
        settings.stream() << "VK_STRUCTURE_TYPE_TILE_PROPERTIES_QCOM (";
        break;
    case 1000485000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_AMIGO_PROFILING_FEATURES_SEC (";
        break;
    case 1000485001:
        settings.stream() << "VK_STRUCTURE_TYPE_AMIGO_PROFILING_SUBMIT_INFO_SEC (";
        break;
    case 1000488000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_VIEWPORTS_FEATURES_QCOM (";
        break;
    case 1000489000:
        settings.stream() << "VK_STRUCTURE_TYPE_SEMAPHORE_SCI_SYNC_POOL_CREATE_INFO_NV (";
        break;
    case 1000489001:
        settings.stream() << "VK_STRUCTURE_TYPE_SEMAPHORE_SCI_SYNC_CREATE_INFO_NV (";
        break;
    case 1000489002:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SCI_SYNC_2_FEATURES_NV (";
        break;
    case 1000490000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_FEATURES_NV (";
        break;
    case 1000490001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_PROPERTIES_NV (";
        break;
    case 1000351000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT (";
        break;
    case 1000351002:
        settings.stream() << "VK_STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_EXT (";
        break;
    case 1000497000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_BUILTINS_FEATURES_ARM (";
        break;
    case 1000497001:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_BUILTINS_PROPERTIES_ARM (";
        break;
    case 1000498000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_LIBRARY_GROUP_HANDLES_FEATURES_EXT (";
        break;
    case 1000510000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_RENDER_AREAS_FEATURES_QCOM (";
        break;
    case 1000510001:
        settings.stream() << "VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_RENDER_AREAS_RENDER_PASS_BEGIN_INFO_QCOM (";
        break;
    case 1000524000:
        settings.stream() << "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_FEATURES_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkPipelineCacheHeaderVersion(VkPipelineCacheHeaderVersion object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 1:
        settings.stream() << "VK_PIPELINE_CACHE_HEADER_VERSION_ONE (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkImageLayout(VkImageLayout object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_IMAGE_LAYOUT_UNDEFINED (";
        break;
    case 1:
        settings.stream() << "VK_IMAGE_LAYOUT_GENERAL (";
        break;
    case 2:
        settings.stream() << "VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL (";
        break;
    case 3:
        settings.stream() << "VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL (";
        break;
    case 4:
        settings.stream() << "VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL (";
        break;
    case 5:
        settings.stream() << "VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL (";
        break;
    case 6:
        settings.stream() << "VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL (";
        break;
    case 7:
        settings.stream() << "VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL (";
        break;
    case 8:
        settings.stream() << "VK_IMAGE_LAYOUT_PREINITIALIZED (";
        break;
    case 1000117000:
        settings.stream() << "VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL (";
        break;
    case 1000117001:
        settings.stream() << "VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL (";
        break;
    case 1000241000:
        settings.stream() << "VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL (";
        break;
    case 1000241001:
        settings.stream() << "VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL (";
        break;
    case 1000241002:
        settings.stream() << "VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL (";
        break;
    case 1000241003:
        settings.stream() << "VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL (";
        break;
    case 1000314000:
        settings.stream() << "VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL (";
        break;
    case 1000314001:
        settings.stream() << "VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL (";
        break;
    case 1000001002:
        settings.stream() << "VK_IMAGE_LAYOUT_PRESENT_SRC_KHR (";
        break;
    case 1000024000:
        settings.stream() << "VK_IMAGE_LAYOUT_VIDEO_DECODE_DST_KHR (";
        break;
    case 1000024001:
        settings.stream() << "VK_IMAGE_LAYOUT_VIDEO_DECODE_SRC_KHR (";
        break;
    case 1000024002:
        settings.stream() << "VK_IMAGE_LAYOUT_VIDEO_DECODE_DPB_KHR (";
        break;
    case 1000111000:
        settings.stream() << "VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR (";
        break;
    case 1000218000:
        settings.stream() << "VK_IMAGE_LAYOUT_FRAGMENT_DENSITY_MAP_OPTIMAL_EXT (";
        break;
    case 1000164003:
        settings.stream() << "VK_IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR (";
        break;
    case 1000299000:
        settings.stream() << "VK_IMAGE_LAYOUT_VIDEO_ENCODE_DST_KHR (";
        break;
    case 1000299001:
        settings.stream() << "VK_IMAGE_LAYOUT_VIDEO_ENCODE_SRC_KHR (";
        break;
    case 1000299002:
        settings.stream() << "VK_IMAGE_LAYOUT_VIDEO_ENCODE_DPB_KHR (";
        break;
    case 1000339000:
        settings.stream() << "VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkObjectType(VkObjectType object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_OBJECT_TYPE_UNKNOWN (";
        break;
    case 1:
        settings.stream() << "VK_OBJECT_TYPE_INSTANCE (";
        break;
    case 2:
        settings.stream() << "VK_OBJECT_TYPE_PHYSICAL_DEVICE (";
        break;
    case 3:
        settings.stream() << "VK_OBJECT_TYPE_DEVICE (";
        break;
    case 4:
        settings.stream() << "VK_OBJECT_TYPE_QUEUE (";
        break;
    case 5:
        settings.stream() << "VK_OBJECT_TYPE_SEMAPHORE (";
        break;
    case 6:
        settings.stream() << "VK_OBJECT_TYPE_COMMAND_BUFFER (";
        break;
    case 7:
        settings.stream() << "VK_OBJECT_TYPE_FENCE (";
        break;
    case 8:
        settings.stream() << "VK_OBJECT_TYPE_DEVICE_MEMORY (";
        break;
    case 9:
        settings.stream() << "VK_OBJECT_TYPE_BUFFER (";
        break;
    case 10:
        settings.stream() << "VK_OBJECT_TYPE_IMAGE (";
        break;
    case 11:
        settings.stream() << "VK_OBJECT_TYPE_EVENT (";
        break;
    case 12:
        settings.stream() << "VK_OBJECT_TYPE_QUERY_POOL (";
        break;
    case 13:
        settings.stream() << "VK_OBJECT_TYPE_BUFFER_VIEW (";
        break;
    case 14:
        settings.stream() << "VK_OBJECT_TYPE_IMAGE_VIEW (";
        break;
    case 15:
        settings.stream() << "VK_OBJECT_TYPE_SHADER_MODULE (";
        break;
    case 16:
        settings.stream() << "VK_OBJECT_TYPE_PIPELINE_CACHE (";
        break;
    case 17:
        settings.stream() << "VK_OBJECT_TYPE_PIPELINE_LAYOUT (";
        break;
    case 18:
        settings.stream() << "VK_OBJECT_TYPE_RENDER_PASS (";
        break;
    case 19:
        settings.stream() << "VK_OBJECT_TYPE_PIPELINE (";
        break;
    case 20:
        settings.stream() << "VK_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT (";
        break;
    case 21:
        settings.stream() << "VK_OBJECT_TYPE_SAMPLER (";
        break;
    case 22:
        settings.stream() << "VK_OBJECT_TYPE_DESCRIPTOR_POOL (";
        break;
    case 23:
        settings.stream() << "VK_OBJECT_TYPE_DESCRIPTOR_SET (";
        break;
    case 24:
        settings.stream() << "VK_OBJECT_TYPE_FRAMEBUFFER (";
        break;
    case 25:
        settings.stream() << "VK_OBJECT_TYPE_COMMAND_POOL (";
        break;
    case 1000156000:
        settings.stream() << "VK_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION (";
        break;
    case 1000085000:
        settings.stream() << "VK_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE (";
        break;
    case 1000295000:
        settings.stream() << "VK_OBJECT_TYPE_PRIVATE_DATA_SLOT (";
        break;
    case 1000000000:
        settings.stream() << "VK_OBJECT_TYPE_SURFACE_KHR (";
        break;
    case 1000001000:
        settings.stream() << "VK_OBJECT_TYPE_SWAPCHAIN_KHR (";
        break;
    case 1000002000:
        settings.stream() << "VK_OBJECT_TYPE_DISPLAY_KHR (";
        break;
    case 1000002001:
        settings.stream() << "VK_OBJECT_TYPE_DISPLAY_MODE_KHR (";
        break;
    case 1000011000:
        settings.stream() << "VK_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT (";
        break;
    case 1000023000:
        settings.stream() << "VK_OBJECT_TYPE_VIDEO_SESSION_KHR (";
        break;
    case 1000023001:
        settings.stream() << "VK_OBJECT_TYPE_VIDEO_SESSION_PARAMETERS_KHR (";
        break;
    case 1000029000:
        settings.stream() << "VK_OBJECT_TYPE_CU_MODULE_NVX (";
        break;
    case 1000029001:
        settings.stream() << "VK_OBJECT_TYPE_CU_FUNCTION_NVX (";
        break;
    case 1000128000:
        settings.stream() << "VK_OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT (";
        break;
    case 1000150000:
        settings.stream() << "VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR (";
        break;
    case 1000160000:
        settings.stream() << "VK_OBJECT_TYPE_VALIDATION_CACHE_EXT (";
        break;
    case 1000165000:
        settings.stream() << "VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV (";
        break;
    case 1000210000:
        settings.stream() << "VK_OBJECT_TYPE_PERFORMANCE_CONFIGURATION_INTEL (";
        break;
    case 1000268000:
        settings.stream() << "VK_OBJECT_TYPE_DEFERRED_OPERATION_KHR (";
        break;
    case 1000277000:
        settings.stream() << "VK_OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_NV (";
        break;
    case 1000366000:
        settings.stream() << "VK_OBJECT_TYPE_BUFFER_COLLECTION_FUCHSIA (";
        break;
    case 1000396000:
        settings.stream() << "VK_OBJECT_TYPE_MICROMAP_EXT (";
        break;
    case 1000464000:
        settings.stream() << "VK_OBJECT_TYPE_OPTICAL_FLOW_SESSION_NV (";
        break;
    case 1000482000:
        settings.stream() << "VK_OBJECT_TYPE_SHADER_EXT (";
        break;
    case 1000489000:
        settings.stream() << "VK_OBJECT_TYPE_SEMAPHORE_SCI_SYNC_POOL_NV (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkVendorId(VkVendorId object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0x10001:
        settings.stream() << "VK_VENDOR_ID_VIV (";
        break;
    case 0x10002:
        settings.stream() << "VK_VENDOR_ID_VSI (";
        break;
    case 0x10003:
        settings.stream() << "VK_VENDOR_ID_KAZAN (";
        break;
    case 0x10004:
        settings.stream() << "VK_VENDOR_ID_CODEPLAY (";
        break;
    case 0x10005:
        settings.stream() << "VK_VENDOR_ID_MESA (";
        break;
    case 0x10006:
        settings.stream() << "VK_VENDOR_ID_POCL (";
        break;
    case 0x10007:
        settings.stream() << "VK_VENDOR_ID_MOBILEYE (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkSystemAllocationScope(VkSystemAllocationScope object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_SYSTEM_ALLOCATION_SCOPE_COMMAND (";
        break;
    case 1:
        settings.stream() << "VK_SYSTEM_ALLOCATION_SCOPE_OBJECT (";
        break;
    case 2:
        settings.stream() << "VK_SYSTEM_ALLOCATION_SCOPE_CACHE (";
        break;
    case 3:
        settings.stream() << "VK_SYSTEM_ALLOCATION_SCOPE_DEVICE (";
        break;
    case 4:
        settings.stream() << "VK_SYSTEM_ALLOCATION_SCOPE_INSTANCE (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkInternalAllocationType(VkInternalAllocationType object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_INTERNAL_ALLOCATION_TYPE_EXECUTABLE (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkFormat(VkFormat object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_FORMAT_UNDEFINED (";
        break;
    case 1:
        settings.stream() << "VK_FORMAT_R4G4_UNORM_PACK8 (";
        break;
    case 2:
        settings.stream() << "VK_FORMAT_R4G4B4A4_UNORM_PACK16 (";
        break;
    case 3:
        settings.stream() << "VK_FORMAT_B4G4R4A4_UNORM_PACK16 (";
        break;
    case 4:
        settings.stream() << "VK_FORMAT_R5G6B5_UNORM_PACK16 (";
        break;
    case 5:
        settings.stream() << "VK_FORMAT_B5G6R5_UNORM_PACK16 (";
        break;
    case 6:
        settings.stream() << "VK_FORMAT_R5G5B5A1_UNORM_PACK16 (";
        break;
    case 7:
        settings.stream() << "VK_FORMAT_B5G5R5A1_UNORM_PACK16 (";
        break;
    case 8:
        settings.stream() << "VK_FORMAT_A1R5G5B5_UNORM_PACK16 (";
        break;
    case 9:
        settings.stream() << "VK_FORMAT_R8_UNORM (";
        break;
    case 10:
        settings.stream() << "VK_FORMAT_R8_SNORM (";
        break;
    case 11:
        settings.stream() << "VK_FORMAT_R8_USCALED (";
        break;
    case 12:
        settings.stream() << "VK_FORMAT_R8_SSCALED (";
        break;
    case 13:
        settings.stream() << "VK_FORMAT_R8_UINT (";
        break;
    case 14:
        settings.stream() << "VK_FORMAT_R8_SINT (";
        break;
    case 15:
        settings.stream() << "VK_FORMAT_R8_SRGB (";
        break;
    case 16:
        settings.stream() << "VK_FORMAT_R8G8_UNORM (";
        break;
    case 17:
        settings.stream() << "VK_FORMAT_R8G8_SNORM (";
        break;
    case 18:
        settings.stream() << "VK_FORMAT_R8G8_USCALED (";
        break;
    case 19:
        settings.stream() << "VK_FORMAT_R8G8_SSCALED (";
        break;
    case 20:
        settings.stream() << "VK_FORMAT_R8G8_UINT (";
        break;
    case 21:
        settings.stream() << "VK_FORMAT_R8G8_SINT (";
        break;
    case 22:
        settings.stream() << "VK_FORMAT_R8G8_SRGB (";
        break;
    case 23:
        settings.stream() << "VK_FORMAT_R8G8B8_UNORM (";
        break;
    case 24:
        settings.stream() << "VK_FORMAT_R8G8B8_SNORM (";
        break;
    case 25:
        settings.stream() << "VK_FORMAT_R8G8B8_USCALED (";
        break;
    case 26:
        settings.stream() << "VK_FORMAT_R8G8B8_SSCALED (";
        break;
    case 27:
        settings.stream() << "VK_FORMAT_R8G8B8_UINT (";
        break;
    case 28:
        settings.stream() << "VK_FORMAT_R8G8B8_SINT (";
        break;
    case 29:
        settings.stream() << "VK_FORMAT_R8G8B8_SRGB (";
        break;
    case 30:
        settings.stream() << "VK_FORMAT_B8G8R8_UNORM (";
        break;
    case 31:
        settings.stream() << "VK_FORMAT_B8G8R8_SNORM (";
        break;
    case 32:
        settings.stream() << "VK_FORMAT_B8G8R8_USCALED (";
        break;
    case 33:
        settings.stream() << "VK_FORMAT_B8G8R8_SSCALED (";
        break;
    case 34:
        settings.stream() << "VK_FORMAT_B8G8R8_UINT (";
        break;
    case 35:
        settings.stream() << "VK_FORMAT_B8G8R8_SINT (";
        break;
    case 36:
        settings.stream() << "VK_FORMAT_B8G8R8_SRGB (";
        break;
    case 37:
        settings.stream() << "VK_FORMAT_R8G8B8A8_UNORM (";
        break;
    case 38:
        settings.stream() << "VK_FORMAT_R8G8B8A8_SNORM (";
        break;
    case 39:
        settings.stream() << "VK_FORMAT_R8G8B8A8_USCALED (";
        break;
    case 40:
        settings.stream() << "VK_FORMAT_R8G8B8A8_SSCALED (";
        break;
    case 41:
        settings.stream() << "VK_FORMAT_R8G8B8A8_UINT (";
        break;
    case 42:
        settings.stream() << "VK_FORMAT_R8G8B8A8_SINT (";
        break;
    case 43:
        settings.stream() << "VK_FORMAT_R8G8B8A8_SRGB (";
        break;
    case 44:
        settings.stream() << "VK_FORMAT_B8G8R8A8_UNORM (";
        break;
    case 45:
        settings.stream() << "VK_FORMAT_B8G8R8A8_SNORM (";
        break;
    case 46:
        settings.stream() << "VK_FORMAT_B8G8R8A8_USCALED (";
        break;
    case 47:
        settings.stream() << "VK_FORMAT_B8G8R8A8_SSCALED (";
        break;
    case 48:
        settings.stream() << "VK_FORMAT_B8G8R8A8_UINT (";
        break;
    case 49:
        settings.stream() << "VK_FORMAT_B8G8R8A8_SINT (";
        break;
    case 50:
        settings.stream() << "VK_FORMAT_B8G8R8A8_SRGB (";
        break;
    case 51:
        settings.stream() << "VK_FORMAT_A8B8G8R8_UNORM_PACK32 (";
        break;
    case 52:
        settings.stream() << "VK_FORMAT_A8B8G8R8_SNORM_PACK32 (";
        break;
    case 53:
        settings.stream() << "VK_FORMAT_A8B8G8R8_USCALED_PACK32 (";
        break;
    case 54:
        settings.stream() << "VK_FORMAT_A8B8G8R8_SSCALED_PACK32 (";
        break;
    case 55:
        settings.stream() << "VK_FORMAT_A8B8G8R8_UINT_PACK32 (";
        break;
    case 56:
        settings.stream() << "VK_FORMAT_A8B8G8R8_SINT_PACK32 (";
        break;
    case 57:
        settings.stream() << "VK_FORMAT_A8B8G8R8_SRGB_PACK32 (";
        break;
    case 58:
        settings.stream() << "VK_FORMAT_A2R10G10B10_UNORM_PACK32 (";
        break;
    case 59:
        settings.stream() << "VK_FORMAT_A2R10G10B10_SNORM_PACK32 (";
        break;
    case 60:
        settings.stream() << "VK_FORMAT_A2R10G10B10_USCALED_PACK32 (";
        break;
    case 61:
        settings.stream() << "VK_FORMAT_A2R10G10B10_SSCALED_PACK32 (";
        break;
    case 62:
        settings.stream() << "VK_FORMAT_A2R10G10B10_UINT_PACK32 (";
        break;
    case 63:
        settings.stream() << "VK_FORMAT_A2R10G10B10_SINT_PACK32 (";
        break;
    case 64:
        settings.stream() << "VK_FORMAT_A2B10G10R10_UNORM_PACK32 (";
        break;
    case 65:
        settings.stream() << "VK_FORMAT_A2B10G10R10_SNORM_PACK32 (";
        break;
    case 66:
        settings.stream() << "VK_FORMAT_A2B10G10R10_USCALED_PACK32 (";
        break;
    case 67:
        settings.stream() << "VK_FORMAT_A2B10G10R10_SSCALED_PACK32 (";
        break;
    case 68:
        settings.stream() << "VK_FORMAT_A2B10G10R10_UINT_PACK32 (";
        break;
    case 69:
        settings.stream() << "VK_FORMAT_A2B10G10R10_SINT_PACK32 (";
        break;
    case 70:
        settings.stream() << "VK_FORMAT_R16_UNORM (";
        break;
    case 71:
        settings.stream() << "VK_FORMAT_R16_SNORM (";
        break;
    case 72:
        settings.stream() << "VK_FORMAT_R16_USCALED (";
        break;
    case 73:
        settings.stream() << "VK_FORMAT_R16_SSCALED (";
        break;
    case 74:
        settings.stream() << "VK_FORMAT_R16_UINT (";
        break;
    case 75:
        settings.stream() << "VK_FORMAT_R16_SINT (";
        break;
    case 76:
        settings.stream() << "VK_FORMAT_R16_SFLOAT (";
        break;
    case 77:
        settings.stream() << "VK_FORMAT_R16G16_UNORM (";
        break;
    case 78:
        settings.stream() << "VK_FORMAT_R16G16_SNORM (";
        break;
    case 79:
        settings.stream() << "VK_FORMAT_R16G16_USCALED (";
        break;
    case 80:
        settings.stream() << "VK_FORMAT_R16G16_SSCALED (";
        break;
    case 81:
        settings.stream() << "VK_FORMAT_R16G16_UINT (";
        break;
    case 82:
        settings.stream() << "VK_FORMAT_R16G16_SINT (";
        break;
    case 83:
        settings.stream() << "VK_FORMAT_R16G16_SFLOAT (";
        break;
    case 84:
        settings.stream() << "VK_FORMAT_R16G16B16_UNORM (";
        break;
    case 85:
        settings.stream() << "VK_FORMAT_R16G16B16_SNORM (";
        break;
    case 86:
        settings.stream() << "VK_FORMAT_R16G16B16_USCALED (";
        break;
    case 87:
        settings.stream() << "VK_FORMAT_R16G16B16_SSCALED (";
        break;
    case 88:
        settings.stream() << "VK_FORMAT_R16G16B16_UINT (";
        break;
    case 89:
        settings.stream() << "VK_FORMAT_R16G16B16_SINT (";
        break;
    case 90:
        settings.stream() << "VK_FORMAT_R16G16B16_SFLOAT (";
        break;
    case 91:
        settings.stream() << "VK_FORMAT_R16G16B16A16_UNORM (";
        break;
    case 92:
        settings.stream() << "VK_FORMAT_R16G16B16A16_SNORM (";
        break;
    case 93:
        settings.stream() << "VK_FORMAT_R16G16B16A16_USCALED (";
        break;
    case 94:
        settings.stream() << "VK_FORMAT_R16G16B16A16_SSCALED (";
        break;
    case 95:
        settings.stream() << "VK_FORMAT_R16G16B16A16_UINT (";
        break;
    case 96:
        settings.stream() << "VK_FORMAT_R16G16B16A16_SINT (";
        break;
    case 97:
        settings.stream() << "VK_FORMAT_R16G16B16A16_SFLOAT (";
        break;
    case 98:
        settings.stream() << "VK_FORMAT_R32_UINT (";
        break;
    case 99:
        settings.stream() << "VK_FORMAT_R32_SINT (";
        break;
    case 100:
        settings.stream() << "VK_FORMAT_R32_SFLOAT (";
        break;
    case 101:
        settings.stream() << "VK_FORMAT_R32G32_UINT (";
        break;
    case 102:
        settings.stream() << "VK_FORMAT_R32G32_SINT (";
        break;
    case 103:
        settings.stream() << "VK_FORMAT_R32G32_SFLOAT (";
        break;
    case 104:
        settings.stream() << "VK_FORMAT_R32G32B32_UINT (";
        break;
    case 105:
        settings.stream() << "VK_FORMAT_R32G32B32_SINT (";
        break;
    case 106:
        settings.stream() << "VK_FORMAT_R32G32B32_SFLOAT (";
        break;
    case 107:
        settings.stream() << "VK_FORMAT_R32G32B32A32_UINT (";
        break;
    case 108:
        settings.stream() << "VK_FORMAT_R32G32B32A32_SINT (";
        break;
    case 109:
        settings.stream() << "VK_FORMAT_R32G32B32A32_SFLOAT (";
        break;
    case 110:
        settings.stream() << "VK_FORMAT_R64_UINT (";
        break;
    case 111:
        settings.stream() << "VK_FORMAT_R64_SINT (";
        break;
    case 112:
        settings.stream() << "VK_FORMAT_R64_SFLOAT (";
        break;
    case 113:
        settings.stream() << "VK_FORMAT_R64G64_UINT (";
        break;
    case 114:
        settings.stream() << "VK_FORMAT_R64G64_SINT (";
        break;
    case 115:
        settings.stream() << "VK_FORMAT_R64G64_SFLOAT (";
        break;
    case 116:
        settings.stream() << "VK_FORMAT_R64G64B64_UINT (";
        break;
    case 117:
        settings.stream() << "VK_FORMAT_R64G64B64_SINT (";
        break;
    case 118:
        settings.stream() << "VK_FORMAT_R64G64B64_SFLOAT (";
        break;
    case 119:
        settings.stream() << "VK_FORMAT_R64G64B64A64_UINT (";
        break;
    case 120:
        settings.stream() << "VK_FORMAT_R64G64B64A64_SINT (";
        break;
    case 121:
        settings.stream() << "VK_FORMAT_R64G64B64A64_SFLOAT (";
        break;
    case 122:
        settings.stream() << "VK_FORMAT_B10G11R11_UFLOAT_PACK32 (";
        break;
    case 123:
        settings.stream() << "VK_FORMAT_E5B9G9R9_UFLOAT_PACK32 (";
        break;
    case 124:
        settings.stream() << "VK_FORMAT_D16_UNORM (";
        break;
    case 125:
        settings.stream() << "VK_FORMAT_X8_D24_UNORM_PACK32 (";
        break;
    case 126:
        settings.stream() << "VK_FORMAT_D32_SFLOAT (";
        break;
    case 127:
        settings.stream() << "VK_FORMAT_S8_UINT (";
        break;
    case 128:
        settings.stream() << "VK_FORMAT_D16_UNORM_S8_UINT (";
        break;
    case 129:
        settings.stream() << "VK_FORMAT_D24_UNORM_S8_UINT (";
        break;
    case 130:
        settings.stream() << "VK_FORMAT_D32_SFLOAT_S8_UINT (";
        break;
    case 131:
        settings.stream() << "VK_FORMAT_BC1_RGB_UNORM_BLOCK (";
        break;
    case 132:
        settings.stream() << "VK_FORMAT_BC1_RGB_SRGB_BLOCK (";
        break;
    case 133:
        settings.stream() << "VK_FORMAT_BC1_RGBA_UNORM_BLOCK (";
        break;
    case 134:
        settings.stream() << "VK_FORMAT_BC1_RGBA_SRGB_BLOCK (";
        break;
    case 135:
        settings.stream() << "VK_FORMAT_BC2_UNORM_BLOCK (";
        break;
    case 136:
        settings.stream() << "VK_FORMAT_BC2_SRGB_BLOCK (";
        break;
    case 137:
        settings.stream() << "VK_FORMAT_BC3_UNORM_BLOCK (";
        break;
    case 138:
        settings.stream() << "VK_FORMAT_BC3_SRGB_BLOCK (";
        break;
    case 139:
        settings.stream() << "VK_FORMAT_BC4_UNORM_BLOCK (";
        break;
    case 140:
        settings.stream() << "VK_FORMAT_BC4_SNORM_BLOCK (";
        break;
    case 141:
        settings.stream() << "VK_FORMAT_BC5_UNORM_BLOCK (";
        break;
    case 142:
        settings.stream() << "VK_FORMAT_BC5_SNORM_BLOCK (";
        break;
    case 143:
        settings.stream() << "VK_FORMAT_BC6H_UFLOAT_BLOCK (";
        break;
    case 144:
        settings.stream() << "VK_FORMAT_BC6H_SFLOAT_BLOCK (";
        break;
    case 145:
        settings.stream() << "VK_FORMAT_BC7_UNORM_BLOCK (";
        break;
    case 146:
        settings.stream() << "VK_FORMAT_BC7_SRGB_BLOCK (";
        break;
    case 147:
        settings.stream() << "VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK (";
        break;
    case 148:
        settings.stream() << "VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK (";
        break;
    case 149:
        settings.stream() << "VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK (";
        break;
    case 150:
        settings.stream() << "VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK (";
        break;
    case 151:
        settings.stream() << "VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK (";
        break;
    case 152:
        settings.stream() << "VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK (";
        break;
    case 153:
        settings.stream() << "VK_FORMAT_EAC_R11_UNORM_BLOCK (";
        break;
    case 154:
        settings.stream() << "VK_FORMAT_EAC_R11_SNORM_BLOCK (";
        break;
    case 155:
        settings.stream() << "VK_FORMAT_EAC_R11G11_UNORM_BLOCK (";
        break;
    case 156:
        settings.stream() << "VK_FORMAT_EAC_R11G11_SNORM_BLOCK (";
        break;
    case 157:
        settings.stream() << "VK_FORMAT_ASTC_4x4_UNORM_BLOCK (";
        break;
    case 158:
        settings.stream() << "VK_FORMAT_ASTC_4x4_SRGB_BLOCK (";
        break;
    case 159:
        settings.stream() << "VK_FORMAT_ASTC_5x4_UNORM_BLOCK (";
        break;
    case 160:
        settings.stream() << "VK_FORMAT_ASTC_5x4_SRGB_BLOCK (";
        break;
    case 161:
        settings.stream() << "VK_FORMAT_ASTC_5x5_UNORM_BLOCK (";
        break;
    case 162:
        settings.stream() << "VK_FORMAT_ASTC_5x5_SRGB_BLOCK (";
        break;
    case 163:
        settings.stream() << "VK_FORMAT_ASTC_6x5_UNORM_BLOCK (";
        break;
    case 164:
        settings.stream() << "VK_FORMAT_ASTC_6x5_SRGB_BLOCK (";
        break;
    case 165:
        settings.stream() << "VK_FORMAT_ASTC_6x6_UNORM_BLOCK (";
        break;
    case 166:
        settings.stream() << "VK_FORMAT_ASTC_6x6_SRGB_BLOCK (";
        break;
    case 167:
        settings.stream() << "VK_FORMAT_ASTC_8x5_UNORM_BLOCK (";
        break;
    case 168:
        settings.stream() << "VK_FORMAT_ASTC_8x5_SRGB_BLOCK (";
        break;
    case 169:
        settings.stream() << "VK_FORMAT_ASTC_8x6_UNORM_BLOCK (";
        break;
    case 170:
        settings.stream() << "VK_FORMAT_ASTC_8x6_SRGB_BLOCK (";
        break;
    case 171:
        settings.stream() << "VK_FORMAT_ASTC_8x8_UNORM_BLOCK (";
        break;
    case 172:
        settings.stream() << "VK_FORMAT_ASTC_8x8_SRGB_BLOCK (";
        break;
    case 173:
        settings.stream() << "VK_FORMAT_ASTC_10x5_UNORM_BLOCK (";
        break;
    case 174:
        settings.stream() << "VK_FORMAT_ASTC_10x5_SRGB_BLOCK (";
        break;
    case 175:
        settings.stream() << "VK_FORMAT_ASTC_10x6_UNORM_BLOCK (";
        break;
    case 176:
        settings.stream() << "VK_FORMAT_ASTC_10x6_SRGB_BLOCK (";
        break;
    case 177:
        settings.stream() << "VK_FORMAT_ASTC_10x8_UNORM_BLOCK (";
        break;
    case 178:
        settings.stream() << "VK_FORMAT_ASTC_10x8_SRGB_BLOCK (";
        break;
    case 179:
        settings.stream() << "VK_FORMAT_ASTC_10x10_UNORM_BLOCK (";
        break;
    case 180:
        settings.stream() << "VK_FORMAT_ASTC_10x10_SRGB_BLOCK (";
        break;
    case 181:
        settings.stream() << "VK_FORMAT_ASTC_12x10_UNORM_BLOCK (";
        break;
    case 182:
        settings.stream() << "VK_FORMAT_ASTC_12x10_SRGB_BLOCK (";
        break;
    case 183:
        settings.stream() << "VK_FORMAT_ASTC_12x12_UNORM_BLOCK (";
        break;
    case 184:
        settings.stream() << "VK_FORMAT_ASTC_12x12_SRGB_BLOCK (";
        break;
    case 1000156000:
        settings.stream() << "VK_FORMAT_G8B8G8R8_422_UNORM (";
        break;
    case 1000156001:
        settings.stream() << "VK_FORMAT_B8G8R8G8_422_UNORM (";
        break;
    case 1000156002:
        settings.stream() << "VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM (";
        break;
    case 1000156003:
        settings.stream() << "VK_FORMAT_G8_B8R8_2PLANE_420_UNORM (";
        break;
    case 1000156004:
        settings.stream() << "VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM (";
        break;
    case 1000156005:
        settings.stream() << "VK_FORMAT_G8_B8R8_2PLANE_422_UNORM (";
        break;
    case 1000156006:
        settings.stream() << "VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM (";
        break;
    case 1000156007:
        settings.stream() << "VK_FORMAT_R10X6_UNORM_PACK16 (";
        break;
    case 1000156008:
        settings.stream() << "VK_FORMAT_R10X6G10X6_UNORM_2PACK16 (";
        break;
    case 1000156009:
        settings.stream() << "VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16 (";
        break;
    case 1000156010:
        settings.stream() << "VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16 (";
        break;
    case 1000156011:
        settings.stream() << "VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16 (";
        break;
    case 1000156012:
        settings.stream() << "VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16 (";
        break;
    case 1000156013:
        settings.stream() << "VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16 (";
        break;
    case 1000156014:
        settings.stream() << "VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16 (";
        break;
    case 1000156015:
        settings.stream() << "VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16 (";
        break;
    case 1000156016:
        settings.stream() << "VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16 (";
        break;
    case 1000156017:
        settings.stream() << "VK_FORMAT_R12X4_UNORM_PACK16 (";
        break;
    case 1000156018:
        settings.stream() << "VK_FORMAT_R12X4G12X4_UNORM_2PACK16 (";
        break;
    case 1000156019:
        settings.stream() << "VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16 (";
        break;
    case 1000156020:
        settings.stream() << "VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16 (";
        break;
    case 1000156021:
        settings.stream() << "VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16 (";
        break;
    case 1000156022:
        settings.stream() << "VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16 (";
        break;
    case 1000156023:
        settings.stream() << "VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16 (";
        break;
    case 1000156024:
        settings.stream() << "VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16 (";
        break;
    case 1000156025:
        settings.stream() << "VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16 (";
        break;
    case 1000156026:
        settings.stream() << "VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16 (";
        break;
    case 1000156027:
        settings.stream() << "VK_FORMAT_G16B16G16R16_422_UNORM (";
        break;
    case 1000156028:
        settings.stream() << "VK_FORMAT_B16G16R16G16_422_UNORM (";
        break;
    case 1000156029:
        settings.stream() << "VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM (";
        break;
    case 1000156030:
        settings.stream() << "VK_FORMAT_G16_B16R16_2PLANE_420_UNORM (";
        break;
    case 1000156031:
        settings.stream() << "VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM (";
        break;
    case 1000156032:
        settings.stream() << "VK_FORMAT_G16_B16R16_2PLANE_422_UNORM (";
        break;
    case 1000156033:
        settings.stream() << "VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM (";
        break;
    case 1000330000:
        settings.stream() << "VK_FORMAT_G8_B8R8_2PLANE_444_UNORM (";
        break;
    case 1000330001:
        settings.stream() << "VK_FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16 (";
        break;
    case 1000330002:
        settings.stream() << "VK_FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16 (";
        break;
    case 1000330003:
        settings.stream() << "VK_FORMAT_G16_B16R16_2PLANE_444_UNORM (";
        break;
    case 1000340000:
        settings.stream() << "VK_FORMAT_A4R4G4B4_UNORM_PACK16 (";
        break;
    case 1000340001:
        settings.stream() << "VK_FORMAT_A4B4G4R4_UNORM_PACK16 (";
        break;
    case 1000066000:
        settings.stream() << "VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK (";
        break;
    case 1000066001:
        settings.stream() << "VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK (";
        break;
    case 1000066002:
        settings.stream() << "VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK (";
        break;
    case 1000066003:
        settings.stream() << "VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK (";
        break;
    case 1000066004:
        settings.stream() << "VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK (";
        break;
    case 1000066005:
        settings.stream() << "VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK (";
        break;
    case 1000066006:
        settings.stream() << "VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK (";
        break;
    case 1000066007:
        settings.stream() << "VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK (";
        break;
    case 1000066008:
        settings.stream() << "VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK (";
        break;
    case 1000066009:
        settings.stream() << "VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK (";
        break;
    case 1000066010:
        settings.stream() << "VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK (";
        break;
    case 1000066011:
        settings.stream() << "VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK (";
        break;
    case 1000066012:
        settings.stream() << "VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK (";
        break;
    case 1000066013:
        settings.stream() << "VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK (";
        break;
    case 1000054000:
        settings.stream() << "VK_FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG (";
        break;
    case 1000054001:
        settings.stream() << "VK_FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG (";
        break;
    case 1000054002:
        settings.stream() << "VK_FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG (";
        break;
    case 1000054003:
        settings.stream() << "VK_FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG (";
        break;
    case 1000054004:
        settings.stream() << "VK_FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG (";
        break;
    case 1000054005:
        settings.stream() << "VK_FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG (";
        break;
    case 1000054006:
        settings.stream() << "VK_FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG (";
        break;
    case 1000054007:
        settings.stream() << "VK_FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG (";
        break;
    case 1000288000:
        settings.stream() << "VK_FORMAT_ASTC_3x3x3_UNORM_BLOCK_EXT (";
        break;
    case 1000288001:
        settings.stream() << "VK_FORMAT_ASTC_3x3x3_SRGB_BLOCK_EXT (";
        break;
    case 1000288002:
        settings.stream() << "VK_FORMAT_ASTC_3x3x3_SFLOAT_BLOCK_EXT (";
        break;
    case 1000288003:
        settings.stream() << "VK_FORMAT_ASTC_4x3x3_UNORM_BLOCK_EXT (";
        break;
    case 1000288004:
        settings.stream() << "VK_FORMAT_ASTC_4x3x3_SRGB_BLOCK_EXT (";
        break;
    case 1000288005:
        settings.stream() << "VK_FORMAT_ASTC_4x3x3_SFLOAT_BLOCK_EXT (";
        break;
    case 1000288006:
        settings.stream() << "VK_FORMAT_ASTC_4x4x3_UNORM_BLOCK_EXT (";
        break;
    case 1000288007:
        settings.stream() << "VK_FORMAT_ASTC_4x4x3_SRGB_BLOCK_EXT (";
        break;
    case 1000288008:
        settings.stream() << "VK_FORMAT_ASTC_4x4x3_SFLOAT_BLOCK_EXT (";
        break;
    case 1000288009:
        settings.stream() << "VK_FORMAT_ASTC_4x4x4_UNORM_BLOCK_EXT (";
        break;
    case 1000288010:
        settings.stream() << "VK_FORMAT_ASTC_4x4x4_SRGB_BLOCK_EXT (";
        break;
    case 1000288011:
        settings.stream() << "VK_FORMAT_ASTC_4x4x4_SFLOAT_BLOCK_EXT (";
        break;
    case 1000288012:
        settings.stream() << "VK_FORMAT_ASTC_5x4x4_UNORM_BLOCK_EXT (";
        break;
    case 1000288013:
        settings.stream() << "VK_FORMAT_ASTC_5x4x4_SRGB_BLOCK_EXT (";
        break;
    case 1000288014:
        settings.stream() << "VK_FORMAT_ASTC_5x4x4_SFLOAT_BLOCK_EXT (";
        break;
    case 1000288015:
        settings.stream() << "VK_FORMAT_ASTC_5x5x4_UNORM_BLOCK_EXT (";
        break;
    case 1000288016:
        settings.stream() << "VK_FORMAT_ASTC_5x5x4_SRGB_BLOCK_EXT (";
        break;
    case 1000288017:
        settings.stream() << "VK_FORMAT_ASTC_5x5x4_SFLOAT_BLOCK_EXT (";
        break;
    case 1000288018:
        settings.stream() << "VK_FORMAT_ASTC_5x5x5_UNORM_BLOCK_EXT (";
        break;
    case 1000288019:
        settings.stream() << "VK_FORMAT_ASTC_5x5x5_SRGB_BLOCK_EXT (";
        break;
    case 1000288020:
        settings.stream() << "VK_FORMAT_ASTC_5x5x5_SFLOAT_BLOCK_EXT (";
        break;
    case 1000288021:
        settings.stream() << "VK_FORMAT_ASTC_6x5x5_UNORM_BLOCK_EXT (";
        break;
    case 1000288022:
        settings.stream() << "VK_FORMAT_ASTC_6x5x5_SRGB_BLOCK_EXT (";
        break;
    case 1000288023:
        settings.stream() << "VK_FORMAT_ASTC_6x5x5_SFLOAT_BLOCK_EXT (";
        break;
    case 1000288024:
        settings.stream() << "VK_FORMAT_ASTC_6x6x5_UNORM_BLOCK_EXT (";
        break;
    case 1000288025:
        settings.stream() << "VK_FORMAT_ASTC_6x6x5_SRGB_BLOCK_EXT (";
        break;
    case 1000288026:
        settings.stream() << "VK_FORMAT_ASTC_6x6x5_SFLOAT_BLOCK_EXT (";
        break;
    case 1000288027:
        settings.stream() << "VK_FORMAT_ASTC_6x6x6_UNORM_BLOCK_EXT (";
        break;
    case 1000288028:
        settings.stream() << "VK_FORMAT_ASTC_6x6x6_SRGB_BLOCK_EXT (";
        break;
    case 1000288029:
        settings.stream() << "VK_FORMAT_ASTC_6x6x6_SFLOAT_BLOCK_EXT (";
        break;
    case 1000464000:
        settings.stream() << "VK_FORMAT_R16G16_S10_5_NV (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkImageTiling(VkImageTiling object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_IMAGE_TILING_OPTIMAL (";
        break;
    case 1:
        settings.stream() << "VK_IMAGE_TILING_LINEAR (";
        break;
    case 1000158000:
        settings.stream() << "VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkImageType(VkImageType object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_IMAGE_TYPE_1D (";
        break;
    case 1:
        settings.stream() << "VK_IMAGE_TYPE_2D (";
        break;
    case 2:
        settings.stream() << "VK_IMAGE_TYPE_3D (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkPhysicalDeviceType(VkPhysicalDeviceType object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_PHYSICAL_DEVICE_TYPE_OTHER (";
        break;
    case 1:
        settings.stream() << "VK_PHYSICAL_DEVICE_TYPE_INTEGRATED_GPU (";
        break;
    case 2:
        settings.stream() << "VK_PHYSICAL_DEVICE_TYPE_DISCRETE_GPU (";
        break;
    case 3:
        settings.stream() << "VK_PHYSICAL_DEVICE_TYPE_VIRTUAL_GPU (";
        break;
    case 4:
        settings.stream() << "VK_PHYSICAL_DEVICE_TYPE_CPU (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkQueryType(VkQueryType object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_QUERY_TYPE_OCCLUSION (";
        break;
    case 1:
        settings.stream() << "VK_QUERY_TYPE_PIPELINE_STATISTICS (";
        break;
    case 2:
        settings.stream() << "VK_QUERY_TYPE_TIMESTAMP (";
        break;
    case 1000023000:
        settings.stream() << "VK_QUERY_TYPE_RESULT_STATUS_ONLY_KHR (";
        break;
    case 1000028004:
        settings.stream() << "VK_QUERY_TYPE_TRANSFORM_FEEDBACK_STREAM_EXT (";
        break;
    case 1000116000:
        settings.stream() << "VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR (";
        break;
    case 1000150000:
        settings.stream() << "VK_QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_KHR (";
        break;
    case 1000150001:
        settings.stream() << "VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_SIZE_KHR (";
        break;
    case 1000165000:
        settings.stream() << "VK_QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_NV (";
        break;
    case 1000210000:
        settings.stream() << "VK_QUERY_TYPE_PERFORMANCE_QUERY_INTEL (";
        break;
    case 1000299000:
        settings.stream() << "VK_QUERY_TYPE_VIDEO_ENCODE_FEEDBACK_KHR (";
        break;
    case 1000328000:
        settings.stream() << "VK_QUERY_TYPE_MESH_PRIMITIVES_GENERATED_EXT (";
        break;
    case 1000382000:
        settings.stream() << "VK_QUERY_TYPE_PRIMITIVES_GENERATED_EXT (";
        break;
    case 1000386000:
        settings.stream() << "VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_BOTTOM_LEVEL_POINTERS_KHR (";
        break;
    case 1000386001:
        settings.stream() << "VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SIZE_KHR (";
        break;
    case 1000396000:
        settings.stream() << "VK_QUERY_TYPE_MICROMAP_SERIALIZATION_SIZE_EXT (";
        break;
    case 1000396001:
        settings.stream() << "VK_QUERY_TYPE_MICROMAP_COMPACTED_SIZE_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkSharingMode(VkSharingMode object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_SHARING_MODE_EXCLUSIVE (";
        break;
    case 1:
        settings.stream() << "VK_SHARING_MODE_CONCURRENT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkComponentSwizzle(VkComponentSwizzle object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_COMPONENT_SWIZZLE_IDENTITY (";
        break;
    case 1:
        settings.stream() << "VK_COMPONENT_SWIZZLE_ZERO (";
        break;
    case 2:
        settings.stream() << "VK_COMPONENT_SWIZZLE_ONE (";
        break;
    case 3:
        settings.stream() << "VK_COMPONENT_SWIZZLE_R (";
        break;
    case 4:
        settings.stream() << "VK_COMPONENT_SWIZZLE_G (";
        break;
    case 5:
        settings.stream() << "VK_COMPONENT_SWIZZLE_B (";
        break;
    case 6:
        settings.stream() << "VK_COMPONENT_SWIZZLE_A (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkImageViewType(VkImageViewType object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_IMAGE_VIEW_TYPE_1D (";
        break;
    case 1:
        settings.stream() << "VK_IMAGE_VIEW_TYPE_2D (";
        break;
    case 2:
        settings.stream() << "VK_IMAGE_VIEW_TYPE_3D (";
        break;
    case 3:
        settings.stream() << "VK_IMAGE_VIEW_TYPE_CUBE (";
        break;
    case 4:
        settings.stream() << "VK_IMAGE_VIEW_TYPE_1D_ARRAY (";
        break;
    case 5:
        settings.stream() << "VK_IMAGE_VIEW_TYPE_2D_ARRAY (";
        break;
    case 6:
        settings.stream() << "VK_IMAGE_VIEW_TYPE_CUBE_ARRAY (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkBlendFactor(VkBlendFactor object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_BLEND_FACTOR_ZERO (";
        break;
    case 1:
        settings.stream() << "VK_BLEND_FACTOR_ONE (";
        break;
    case 2:
        settings.stream() << "VK_BLEND_FACTOR_SRC_COLOR (";
        break;
    case 3:
        settings.stream() << "VK_BLEND_FACTOR_ONE_MINUS_SRC_COLOR (";
        break;
    case 4:
        settings.stream() << "VK_BLEND_FACTOR_DST_COLOR (";
        break;
    case 5:
        settings.stream() << "VK_BLEND_FACTOR_ONE_MINUS_DST_COLOR (";
        break;
    case 6:
        settings.stream() << "VK_BLEND_FACTOR_SRC_ALPHA (";
        break;
    case 7:
        settings.stream() << "VK_BLEND_FACTOR_ONE_MINUS_SRC_ALPHA (";
        break;
    case 8:
        settings.stream() << "VK_BLEND_FACTOR_DST_ALPHA (";
        break;
    case 9:
        settings.stream() << "VK_BLEND_FACTOR_ONE_MINUS_DST_ALPHA (";
        break;
    case 10:
        settings.stream() << "VK_BLEND_FACTOR_CONSTANT_COLOR (";
        break;
    case 11:
        settings.stream() << "VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_COLOR (";
        break;
    case 12:
        settings.stream() << "VK_BLEND_FACTOR_CONSTANT_ALPHA (";
        break;
    case 13:
        settings.stream() << "VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA (";
        break;
    case 14:
        settings.stream() << "VK_BLEND_FACTOR_SRC_ALPHA_SATURATE (";
        break;
    case 15:
        settings.stream() << "VK_BLEND_FACTOR_SRC1_COLOR (";
        break;
    case 16:
        settings.stream() << "VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR (";
        break;
    case 17:
        settings.stream() << "VK_BLEND_FACTOR_SRC1_ALPHA (";
        break;
    case 18:
        settings.stream() << "VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkBlendOp(VkBlendOp object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_BLEND_OP_ADD (";
        break;
    case 1:
        settings.stream() << "VK_BLEND_OP_SUBTRACT (";
        break;
    case 2:
        settings.stream() << "VK_BLEND_OP_REVERSE_SUBTRACT (";
        break;
    case 3:
        settings.stream() << "VK_BLEND_OP_MIN (";
        break;
    case 4:
        settings.stream() << "VK_BLEND_OP_MAX (";
        break;
    case 1000148000:
        settings.stream() << "VK_BLEND_OP_ZERO_EXT (";
        break;
    case 1000148001:
        settings.stream() << "VK_BLEND_OP_SRC_EXT (";
        break;
    case 1000148002:
        settings.stream() << "VK_BLEND_OP_DST_EXT (";
        break;
    case 1000148003:
        settings.stream() << "VK_BLEND_OP_SRC_OVER_EXT (";
        break;
    case 1000148004:
        settings.stream() << "VK_BLEND_OP_DST_OVER_EXT (";
        break;
    case 1000148005:
        settings.stream() << "VK_BLEND_OP_SRC_IN_EXT (";
        break;
    case 1000148006:
        settings.stream() << "VK_BLEND_OP_DST_IN_EXT (";
        break;
    case 1000148007:
        settings.stream() << "VK_BLEND_OP_SRC_OUT_EXT (";
        break;
    case 1000148008:
        settings.stream() << "VK_BLEND_OP_DST_OUT_EXT (";
        break;
    case 1000148009:
        settings.stream() << "VK_BLEND_OP_SRC_ATOP_EXT (";
        break;
    case 1000148010:
        settings.stream() << "VK_BLEND_OP_DST_ATOP_EXT (";
        break;
    case 1000148011:
        settings.stream() << "VK_BLEND_OP_XOR_EXT (";
        break;
    case 1000148012:
        settings.stream() << "VK_BLEND_OP_MULTIPLY_EXT (";
        break;
    case 1000148013:
        settings.stream() << "VK_BLEND_OP_SCREEN_EXT (";
        break;
    case 1000148014:
        settings.stream() << "VK_BLEND_OP_OVERLAY_EXT (";
        break;
    case 1000148015:
        settings.stream() << "VK_BLEND_OP_DARKEN_EXT (";
        break;
    case 1000148016:
        settings.stream() << "VK_BLEND_OP_LIGHTEN_EXT (";
        break;
    case 1000148017:
        settings.stream() << "VK_BLEND_OP_COLORDODGE_EXT (";
        break;
    case 1000148018:
        settings.stream() << "VK_BLEND_OP_COLORBURN_EXT (";
        break;
    case 1000148019:
        settings.stream() << "VK_BLEND_OP_HARDLIGHT_EXT (";
        break;
    case 1000148020:
        settings.stream() << "VK_BLEND_OP_SOFTLIGHT_EXT (";
        break;
    case 1000148021:
        settings.stream() << "VK_BLEND_OP_DIFFERENCE_EXT (";
        break;
    case 1000148022:
        settings.stream() << "VK_BLEND_OP_EXCLUSION_EXT (";
        break;
    case 1000148023:
        settings.stream() << "VK_BLEND_OP_INVERT_EXT (";
        break;
    case 1000148024:
        settings.stream() << "VK_BLEND_OP_INVERT_RGB_EXT (";
        break;
    case 1000148025:
        settings.stream() << "VK_BLEND_OP_LINEARDODGE_EXT (";
        break;
    case 1000148026:
        settings.stream() << "VK_BLEND_OP_LINEARBURN_EXT (";
        break;
    case 1000148027:
        settings.stream() << "VK_BLEND_OP_VIVIDLIGHT_EXT (";
        break;
    case 1000148028:
        settings.stream() << "VK_BLEND_OP_LINEARLIGHT_EXT (";
        break;
    case 1000148029:
        settings.stream() << "VK_BLEND_OP_PINLIGHT_EXT (";
        break;
    case 1000148030:
        settings.stream() << "VK_BLEND_OP_HARDMIX_EXT (";
        break;
    case 1000148031:
        settings.stream() << "VK_BLEND_OP_HSL_HUE_EXT (";
        break;
    case 1000148032:
        settings.stream() << "VK_BLEND_OP_HSL_SATURATION_EXT (";
        break;
    case 1000148033:
        settings.stream() << "VK_BLEND_OP_HSL_COLOR_EXT (";
        break;
    case 1000148034:
        settings.stream() << "VK_BLEND_OP_HSL_LUMINOSITY_EXT (";
        break;
    case 1000148035:
        settings.stream() << "VK_BLEND_OP_PLUS_EXT (";
        break;
    case 1000148036:
        settings.stream() << "VK_BLEND_OP_PLUS_CLAMPED_EXT (";
        break;
    case 1000148037:
        settings.stream() << "VK_BLEND_OP_PLUS_CLAMPED_ALPHA_EXT (";
        break;
    case 1000148038:
        settings.stream() << "VK_BLEND_OP_PLUS_DARKER_EXT (";
        break;
    case 1000148039:
        settings.stream() << "VK_BLEND_OP_MINUS_EXT (";
        break;
    case 1000148040:
        settings.stream() << "VK_BLEND_OP_MINUS_CLAMPED_EXT (";
        break;
    case 1000148041:
        settings.stream() << "VK_BLEND_OP_CONTRAST_EXT (";
        break;
    case 1000148042:
        settings.stream() << "VK_BLEND_OP_INVERT_OVG_EXT (";
        break;
    case 1000148043:
        settings.stream() << "VK_BLEND_OP_RED_EXT (";
        break;
    case 1000148044:
        settings.stream() << "VK_BLEND_OP_GREEN_EXT (";
        break;
    case 1000148045:
        settings.stream() << "VK_BLEND_OP_BLUE_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkCompareOp(VkCompareOp object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_COMPARE_OP_NEVER (";
        break;
    case 1:
        settings.stream() << "VK_COMPARE_OP_LESS (";
        break;
    case 2:
        settings.stream() << "VK_COMPARE_OP_EQUAL (";
        break;
    case 3:
        settings.stream() << "VK_COMPARE_OP_LESS_OR_EQUAL (";
        break;
    case 4:
        settings.stream() << "VK_COMPARE_OP_GREATER (";
        break;
    case 5:
        settings.stream() << "VK_COMPARE_OP_NOT_EQUAL (";
        break;
    case 6:
        settings.stream() << "VK_COMPARE_OP_GREATER_OR_EQUAL (";
        break;
    case 7:
        settings.stream() << "VK_COMPARE_OP_ALWAYS (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkDynamicState(VkDynamicState object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_DYNAMIC_STATE_VIEWPORT (";
        break;
    case 1:
        settings.stream() << "VK_DYNAMIC_STATE_SCISSOR (";
        break;
    case 2:
        settings.stream() << "VK_DYNAMIC_STATE_LINE_WIDTH (";
        break;
    case 3:
        settings.stream() << "VK_DYNAMIC_STATE_DEPTH_BIAS (";
        break;
    case 4:
        settings.stream() << "VK_DYNAMIC_STATE_BLEND_CONSTANTS (";
        break;
    case 5:
        settings.stream() << "VK_DYNAMIC_STATE_DEPTH_BOUNDS (";
        break;
    case 6:
        settings.stream() << "VK_DYNAMIC_STATE_STENCIL_COMPARE_MASK (";
        break;
    case 7:
        settings.stream() << "VK_DYNAMIC_STATE_STENCIL_WRITE_MASK (";
        break;
    case 8:
        settings.stream() << "VK_DYNAMIC_STATE_STENCIL_REFERENCE (";
        break;
    case 1000267000:
        settings.stream() << "VK_DYNAMIC_STATE_CULL_MODE (";
        break;
    case 1000267001:
        settings.stream() << "VK_DYNAMIC_STATE_FRONT_FACE (";
        break;
    case 1000267002:
        settings.stream() << "VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY (";
        break;
    case 1000267003:
        settings.stream() << "VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT (";
        break;
    case 1000267004:
        settings.stream() << "VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT (";
        break;
    case 1000267005:
        settings.stream() << "VK_DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE (";
        break;
    case 1000267006:
        settings.stream() << "VK_DYNAMIC_STATE_DEPTH_TEST_ENABLE (";
        break;
    case 1000267007:
        settings.stream() << "VK_DYNAMIC_STATE_DEPTH_WRITE_ENABLE (";
        break;
    case 1000267008:
        settings.stream() << "VK_DYNAMIC_STATE_DEPTH_COMPARE_OP (";
        break;
    case 1000267009:
        settings.stream() << "VK_DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE (";
        break;
    case 1000267010:
        settings.stream() << "VK_DYNAMIC_STATE_STENCIL_TEST_ENABLE (";
        break;
    case 1000267011:
        settings.stream() << "VK_DYNAMIC_STATE_STENCIL_OP (";
        break;
    case 1000377001:
        settings.stream() << "VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE (";
        break;
    case 1000377002:
        settings.stream() << "VK_DYNAMIC_STATE_DEPTH_BIAS_ENABLE (";
        break;
    case 1000377004:
        settings.stream() << "VK_DYNAMIC_STATE_PRIMITIVE_RESTART_ENABLE (";
        break;
    case 1000087000:
        settings.stream() << "VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_NV (";
        break;
    case 1000099000:
        settings.stream() << "VK_DYNAMIC_STATE_DISCARD_RECTANGLE_EXT (";
        break;
    case 1000099001:
        settings.stream() << "VK_DYNAMIC_STATE_DISCARD_RECTANGLE_ENABLE_EXT (";
        break;
    case 1000099002:
        settings.stream() << "VK_DYNAMIC_STATE_DISCARD_RECTANGLE_MODE_EXT (";
        break;
    case 1000143000:
        settings.stream() << "VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_EXT (";
        break;
    case 1000347000:
        settings.stream() << "VK_DYNAMIC_STATE_RAY_TRACING_PIPELINE_STACK_SIZE_KHR (";
        break;
    case 1000164004:
        settings.stream() << "VK_DYNAMIC_STATE_VIEWPORT_SHADING_RATE_PALETTE_NV (";
        break;
    case 1000164006:
        settings.stream() << "VK_DYNAMIC_STATE_VIEWPORT_COARSE_SAMPLE_ORDER_NV (";
        break;
    case 1000205000:
        settings.stream() << "VK_DYNAMIC_STATE_EXCLUSIVE_SCISSOR_ENABLE_NV (";
        break;
    case 1000205001:
        settings.stream() << "VK_DYNAMIC_STATE_EXCLUSIVE_SCISSOR_NV (";
        break;
    case 1000226000:
        settings.stream() << "VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR (";
        break;
    case 1000259000:
        settings.stream() << "VK_DYNAMIC_STATE_LINE_STIPPLE_EXT (";
        break;
    case 1000352000:
        settings.stream() << "VK_DYNAMIC_STATE_VERTEX_INPUT_EXT (";
        break;
    case 1000377000:
        settings.stream() << "VK_DYNAMIC_STATE_PATCH_CONTROL_POINTS_EXT (";
        break;
    case 1000377003:
        settings.stream() << "VK_DYNAMIC_STATE_LOGIC_OP_EXT (";
        break;
    case 1000381000:
        settings.stream() << "VK_DYNAMIC_STATE_COLOR_WRITE_ENABLE_EXT (";
        break;
    case 1000455002:
        settings.stream() << "VK_DYNAMIC_STATE_TESSELLATION_DOMAIN_ORIGIN_EXT (";
        break;
    case 1000455003:
        settings.stream() << "VK_DYNAMIC_STATE_DEPTH_CLAMP_ENABLE_EXT (";
        break;
    case 1000455004:
        settings.stream() << "VK_DYNAMIC_STATE_POLYGON_MODE_EXT (";
        break;
    case 1000455005:
        settings.stream() << "VK_DYNAMIC_STATE_RASTERIZATION_SAMPLES_EXT (";
        break;
    case 1000455006:
        settings.stream() << "VK_DYNAMIC_STATE_SAMPLE_MASK_EXT (";
        break;
    case 1000455007:
        settings.stream() << "VK_DYNAMIC_STATE_ALPHA_TO_COVERAGE_ENABLE_EXT (";
        break;
    case 1000455008:
        settings.stream() << "VK_DYNAMIC_STATE_ALPHA_TO_ONE_ENABLE_EXT (";
        break;
    case 1000455009:
        settings.stream() << "VK_DYNAMIC_STATE_LOGIC_OP_ENABLE_EXT (";
        break;
    case 1000455010:
        settings.stream() << "VK_DYNAMIC_STATE_COLOR_BLEND_ENABLE_EXT (";
        break;
    case 1000455011:
        settings.stream() << "VK_DYNAMIC_STATE_COLOR_BLEND_EQUATION_EXT (";
        break;
    case 1000455012:
        settings.stream() << "VK_DYNAMIC_STATE_COLOR_WRITE_MASK_EXT (";
        break;
    case 1000455013:
        settings.stream() << "VK_DYNAMIC_STATE_RASTERIZATION_STREAM_EXT (";
        break;
    case 1000455014:
        settings.stream() << "VK_DYNAMIC_STATE_CONSERVATIVE_RASTERIZATION_MODE_EXT (";
        break;
    case 1000455015:
        settings.stream() << "VK_DYNAMIC_STATE_EXTRA_PRIMITIVE_OVERESTIMATION_SIZE_EXT (";
        break;
    case 1000455016:
        settings.stream() << "VK_DYNAMIC_STATE_DEPTH_CLIP_ENABLE_EXT (";
        break;
    case 1000455017:
        settings.stream() << "VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_ENABLE_EXT (";
        break;
    case 1000455018:
        settings.stream() << "VK_DYNAMIC_STATE_COLOR_BLEND_ADVANCED_EXT (";
        break;
    case 1000455019:
        settings.stream() << "VK_DYNAMIC_STATE_PROVOKING_VERTEX_MODE_EXT (";
        break;
    case 1000455020:
        settings.stream() << "VK_DYNAMIC_STATE_LINE_RASTERIZATION_MODE_EXT (";
        break;
    case 1000455021:
        settings.stream() << "VK_DYNAMIC_STATE_LINE_STIPPLE_ENABLE_EXT (";
        break;
    case 1000455022:
        settings.stream() << "VK_DYNAMIC_STATE_DEPTH_CLIP_NEGATIVE_ONE_TO_ONE_EXT (";
        break;
    case 1000455023:
        settings.stream() << "VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_ENABLE_NV (";
        break;
    case 1000455024:
        settings.stream() << "VK_DYNAMIC_STATE_VIEWPORT_SWIZZLE_NV (";
        break;
    case 1000455025:
        settings.stream() << "VK_DYNAMIC_STATE_COVERAGE_TO_COLOR_ENABLE_NV (";
        break;
    case 1000455026:
        settings.stream() << "VK_DYNAMIC_STATE_COVERAGE_TO_COLOR_LOCATION_NV (";
        break;
    case 1000455027:
        settings.stream() << "VK_DYNAMIC_STATE_COVERAGE_MODULATION_MODE_NV (";
        break;
    case 1000455028:
        settings.stream() << "VK_DYNAMIC_STATE_COVERAGE_MODULATION_TABLE_ENABLE_NV (";
        break;
    case 1000455029:
        settings.stream() << "VK_DYNAMIC_STATE_COVERAGE_MODULATION_TABLE_NV (";
        break;
    case 1000455030:
        settings.stream() << "VK_DYNAMIC_STATE_SHADING_RATE_IMAGE_ENABLE_NV (";
        break;
    case 1000455031:
        settings.stream() << "VK_DYNAMIC_STATE_REPRESENTATIVE_FRAGMENT_TEST_ENABLE_NV (";
        break;
    case 1000455032:
        settings.stream() << "VK_DYNAMIC_STATE_COVERAGE_REDUCTION_MODE_NV (";
        break;
    case 1000524000:
        settings.stream() << "VK_DYNAMIC_STATE_ATTACHMENT_FEEDBACK_LOOP_ENABLE_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkFrontFace(VkFrontFace object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_FRONT_FACE_COUNTER_CLOCKWISE (";
        break;
    case 1:
        settings.stream() << "VK_FRONT_FACE_CLOCKWISE (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkVertexInputRate(VkVertexInputRate object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_VERTEX_INPUT_RATE_VERTEX (";
        break;
    case 1:
        settings.stream() << "VK_VERTEX_INPUT_RATE_INSTANCE (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkPrimitiveTopology(VkPrimitiveTopology object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_PRIMITIVE_TOPOLOGY_POINT_LIST (";
        break;
    case 1:
        settings.stream() << "VK_PRIMITIVE_TOPOLOGY_LINE_LIST (";
        break;
    case 2:
        settings.stream() << "VK_PRIMITIVE_TOPOLOGY_LINE_STRIP (";
        break;
    case 3:
        settings.stream() << "VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST (";
        break;
    case 4:
        settings.stream() << "VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP (";
        break;
    case 5:
        settings.stream() << "VK_PRIMITIVE_TOPOLOGY_TRIANGLE_FAN (";
        break;
    case 6:
        settings.stream() << "VK_PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY (";
        break;
    case 7:
        settings.stream() << "VK_PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY (";
        break;
    case 8:
        settings.stream() << "VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY (";
        break;
    case 9:
        settings.stream() << "VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY (";
        break;
    case 10:
        settings.stream() << "VK_PRIMITIVE_TOPOLOGY_PATCH_LIST (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkPolygonMode(VkPolygonMode object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_POLYGON_MODE_FILL (";
        break;
    case 1:
        settings.stream() << "VK_POLYGON_MODE_LINE (";
        break;
    case 2:
        settings.stream() << "VK_POLYGON_MODE_POINT (";
        break;
    case 1000153000:
        settings.stream() << "VK_POLYGON_MODE_FILL_RECTANGLE_NV (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkStencilOp(VkStencilOp object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_STENCIL_OP_KEEP (";
        break;
    case 1:
        settings.stream() << "VK_STENCIL_OP_ZERO (";
        break;
    case 2:
        settings.stream() << "VK_STENCIL_OP_REPLACE (";
        break;
    case 3:
        settings.stream() << "VK_STENCIL_OP_INCREMENT_AND_CLAMP (";
        break;
    case 4:
        settings.stream() << "VK_STENCIL_OP_DECREMENT_AND_CLAMP (";
        break;
    case 5:
        settings.stream() << "VK_STENCIL_OP_INVERT (";
        break;
    case 6:
        settings.stream() << "VK_STENCIL_OP_INCREMENT_AND_WRAP (";
        break;
    case 7:
        settings.stream() << "VK_STENCIL_OP_DECREMENT_AND_WRAP (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkLogicOp(VkLogicOp object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_LOGIC_OP_CLEAR (";
        break;
    case 1:
        settings.stream() << "VK_LOGIC_OP_AND (";
        break;
    case 2:
        settings.stream() << "VK_LOGIC_OP_AND_REVERSE (";
        break;
    case 3:
        settings.stream() << "VK_LOGIC_OP_COPY (";
        break;
    case 4:
        settings.stream() << "VK_LOGIC_OP_AND_INVERTED (";
        break;
    case 5:
        settings.stream() << "VK_LOGIC_OP_NO_OP (";
        break;
    case 6:
        settings.stream() << "VK_LOGIC_OP_XOR (";
        break;
    case 7:
        settings.stream() << "VK_LOGIC_OP_OR (";
        break;
    case 8:
        settings.stream() << "VK_LOGIC_OP_NOR (";
        break;
    case 9:
        settings.stream() << "VK_LOGIC_OP_EQUIVALENT (";
        break;
    case 10:
        settings.stream() << "VK_LOGIC_OP_INVERT (";
        break;
    case 11:
        settings.stream() << "VK_LOGIC_OP_OR_REVERSE (";
        break;
    case 12:
        settings.stream() << "VK_LOGIC_OP_COPY_INVERTED (";
        break;
    case 13:
        settings.stream() << "VK_LOGIC_OP_OR_INVERTED (";
        break;
    case 14:
        settings.stream() << "VK_LOGIC_OP_NAND (";
        break;
    case 15:
        settings.stream() << "VK_LOGIC_OP_SET (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkBorderColor(VkBorderColor object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_BORDER_COLOR_FLOAT_TRANSPARENT_BLACK (";
        break;
    case 1:
        settings.stream() << "VK_BORDER_COLOR_INT_TRANSPARENT_BLACK (";
        break;
    case 2:
        settings.stream() << "VK_BORDER_COLOR_FLOAT_OPAQUE_BLACK (";
        break;
    case 3:
        settings.stream() << "VK_BORDER_COLOR_INT_OPAQUE_BLACK (";
        break;
    case 4:
        settings.stream() << "VK_BORDER_COLOR_FLOAT_OPAQUE_WHITE (";
        break;
    case 5:
        settings.stream() << "VK_BORDER_COLOR_INT_OPAQUE_WHITE (";
        break;
    case 1000287003:
        settings.stream() << "VK_BORDER_COLOR_FLOAT_CUSTOM_EXT (";
        break;
    case 1000287004:
        settings.stream() << "VK_BORDER_COLOR_INT_CUSTOM_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkFilter(VkFilter object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_FILTER_NEAREST (";
        break;
    case 1:
        settings.stream() << "VK_FILTER_LINEAR (";
        break;
    case 1000015000:
        settings.stream() << "VK_FILTER_CUBIC_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkSamplerAddressMode(VkSamplerAddressMode object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_SAMPLER_ADDRESS_MODE_REPEAT (";
        break;
    case 1:
        settings.stream() << "VK_SAMPLER_ADDRESS_MODE_MIRRORED_REPEAT (";
        break;
    case 2:
        settings.stream() << "VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE (";
        break;
    case 3:
        settings.stream() << "VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER (";
        break;
    case 4:
        settings.stream() << "VK_SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkSamplerMipmapMode(VkSamplerMipmapMode object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_SAMPLER_MIPMAP_MODE_NEAREST (";
        break;
    case 1:
        settings.stream() << "VK_SAMPLER_MIPMAP_MODE_LINEAR (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkDescriptorType(VkDescriptorType object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_DESCRIPTOR_TYPE_SAMPLER (";
        break;
    case 1:
        settings.stream() << "VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER (";
        break;
    case 2:
        settings.stream() << "VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE (";
        break;
    case 3:
        settings.stream() << "VK_DESCRIPTOR_TYPE_STORAGE_IMAGE (";
        break;
    case 4:
        settings.stream() << "VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER (";
        break;
    case 5:
        settings.stream() << "VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER (";
        break;
    case 6:
        settings.stream() << "VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER (";
        break;
    case 7:
        settings.stream() << "VK_DESCRIPTOR_TYPE_STORAGE_BUFFER (";
        break;
    case 8:
        settings.stream() << "VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC (";
        break;
    case 9:
        settings.stream() << "VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC (";
        break;
    case 10:
        settings.stream() << "VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT (";
        break;
    case 1000138000:
        settings.stream() << "VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK (";
        break;
    case 1000150000:
        settings.stream() << "VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR (";
        break;
    case 1000165000:
        settings.stream() << "VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV (";
        break;
    case 1000440000:
        settings.stream() << "VK_DESCRIPTOR_TYPE_SAMPLE_WEIGHT_IMAGE_QCOM (";
        break;
    case 1000440001:
        settings.stream() << "VK_DESCRIPTOR_TYPE_BLOCK_MATCH_IMAGE_QCOM (";
        break;
    case 1000351000:
        settings.stream() << "VK_DESCRIPTOR_TYPE_MUTABLE_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkAttachmentLoadOp(VkAttachmentLoadOp object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_ATTACHMENT_LOAD_OP_LOAD (";
        break;
    case 1:
        settings.stream() << "VK_ATTACHMENT_LOAD_OP_CLEAR (";
        break;
    case 2:
        settings.stream() << "VK_ATTACHMENT_LOAD_OP_DONT_CARE (";
        break;
    case 1000400000:
        settings.stream() << "VK_ATTACHMENT_LOAD_OP_NONE_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkAttachmentStoreOp(VkAttachmentStoreOp object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_ATTACHMENT_STORE_OP_STORE (";
        break;
    case 1:
        settings.stream() << "VK_ATTACHMENT_STORE_OP_DONT_CARE (";
        break;
    case 1000301000:
        settings.stream() << "VK_ATTACHMENT_STORE_OP_NONE (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkPipelineBindPoint(VkPipelineBindPoint object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_PIPELINE_BIND_POINT_GRAPHICS (";
        break;
    case 1:
        settings.stream() << "VK_PIPELINE_BIND_POINT_COMPUTE (";
        break;
    case 1000165000:
        settings.stream() << "VK_PIPELINE_BIND_POINT_RAY_TRACING_KHR (";
        break;
    case 1000369003:
        settings.stream() << "VK_PIPELINE_BIND_POINT_SUBPASS_SHADING_HUAWEI (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkCommandBufferLevel(VkCommandBufferLevel object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_COMMAND_BUFFER_LEVEL_PRIMARY (";
        break;
    case 1:
        settings.stream() << "VK_COMMAND_BUFFER_LEVEL_SECONDARY (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkIndexType(VkIndexType object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_INDEX_TYPE_UINT16 (";
        break;
    case 1:
        settings.stream() << "VK_INDEX_TYPE_UINT32 (";
        break;
    case 1000165000:
        settings.stream() << "VK_INDEX_TYPE_NONE_KHR (";
        break;
    case 1000265000:
        settings.stream() << "VK_INDEX_TYPE_UINT8_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkSubpassContents(VkSubpassContents object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_SUBPASS_CONTENTS_INLINE (";
        break;
    case 1:
        settings.stream() << "VK_SUBPASS_CONTENTS_SECONDARY_COMMAND_BUFFERS (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkPointClippingBehavior(VkPointClippingBehavior object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_POINT_CLIPPING_BEHAVIOR_ALL_CLIP_PLANES (";
        break;
    case 1:
        settings.stream() << "VK_POINT_CLIPPING_BEHAVIOR_USER_CLIP_PLANES_ONLY (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkTessellationDomainOrigin(VkTessellationDomainOrigin object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_TESSELLATION_DOMAIN_ORIGIN_UPPER_LEFT (";
        break;
    case 1:
        settings.stream() << "VK_TESSELLATION_DOMAIN_ORIGIN_LOWER_LEFT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkSamplerYcbcrModelConversion(VkSamplerYcbcrModelConversion object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_SAMPLER_YCBCR_MODEL_CONVERSION_RGB_IDENTITY (";
        break;
    case 1:
        settings.stream() << "VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_IDENTITY (";
        break;
    case 2:
        settings.stream() << "VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_709 (";
        break;
    case 3:
        settings.stream() << "VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_601 (";
        break;
    case 4:
        settings.stream() << "VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_2020 (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkSamplerYcbcrRange(VkSamplerYcbcrRange object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_SAMPLER_YCBCR_RANGE_ITU_FULL (";
        break;
    case 1:
        settings.stream() << "VK_SAMPLER_YCBCR_RANGE_ITU_NARROW (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkChromaLocation(VkChromaLocation object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_CHROMA_LOCATION_COSITED_EVEN (";
        break;
    case 1:
        settings.stream() << "VK_CHROMA_LOCATION_MIDPOINT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkDescriptorUpdateTemplateType(VkDescriptorUpdateTemplateType object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET (";
        break;
    case 1:
        settings.stream() << "VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS_KHR (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkDriverId(VkDriverId object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 1:
        settings.stream() << "VK_DRIVER_ID_AMD_PROPRIETARY (";
        break;
    case 2:
        settings.stream() << "VK_DRIVER_ID_AMD_OPEN_SOURCE (";
        break;
    case 3:
        settings.stream() << "VK_DRIVER_ID_MESA_RADV (";
        break;
    case 4:
        settings.stream() << "VK_DRIVER_ID_NVIDIA_PROPRIETARY (";
        break;
    case 5:
        settings.stream() << "VK_DRIVER_ID_INTEL_PROPRIETARY_WINDOWS (";
        break;
    case 6:
        settings.stream() << "VK_DRIVER_ID_INTEL_OPEN_SOURCE_MESA (";
        break;
    case 7:
        settings.stream() << "VK_DRIVER_ID_IMAGINATION_PROPRIETARY (";
        break;
    case 8:
        settings.stream() << "VK_DRIVER_ID_QUALCOMM_PROPRIETARY (";
        break;
    case 9:
        settings.stream() << "VK_DRIVER_ID_ARM_PROPRIETARY (";
        break;
    case 10:
        settings.stream() << "VK_DRIVER_ID_GOOGLE_SWIFTSHADER (";
        break;
    case 11:
        settings.stream() << "VK_DRIVER_ID_GGP_PROPRIETARY (";
        break;
    case 12:
        settings.stream() << "VK_DRIVER_ID_BROADCOM_PROPRIETARY (";
        break;
    case 13:
        settings.stream() << "VK_DRIVER_ID_MESA_LLVMPIPE (";
        break;
    case 14:
        settings.stream() << "VK_DRIVER_ID_MOLTENVK (";
        break;
    case 15:
        settings.stream() << "VK_DRIVER_ID_COREAVI_PROPRIETARY (";
        break;
    case 16:
        settings.stream() << "VK_DRIVER_ID_JUICE_PROPRIETARY (";
        break;
    case 17:
        settings.stream() << "VK_DRIVER_ID_VERISILICON_PROPRIETARY (";
        break;
    case 18:
        settings.stream() << "VK_DRIVER_ID_MESA_TURNIP (";
        break;
    case 19:
        settings.stream() << "VK_DRIVER_ID_MESA_V3DV (";
        break;
    case 20:
        settings.stream() << "VK_DRIVER_ID_MESA_PANVK (";
        break;
    case 21:
        settings.stream() << "VK_DRIVER_ID_SAMSUNG_PROPRIETARY (";
        break;
    case 22:
        settings.stream() << "VK_DRIVER_ID_MESA_VENUS (";
        break;
    case 23:
        settings.stream() << "VK_DRIVER_ID_MESA_DOZEN (";
        break;
    case 24:
        settings.stream() << "VK_DRIVER_ID_MESA_NVK (";
        break;
    case 25:
        settings.stream() << "VK_DRIVER_ID_IMAGINATION_OPEN_SOURCE_MESA (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkShaderFloatControlsIndependence(VkShaderFloatControlsIndependence object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY (";
        break;
    case 1:
        settings.stream() << "VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_ALL (";
        break;
    case 2:
        settings.stream() << "VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkSamplerReductionMode(VkSamplerReductionMode object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE (";
        break;
    case 1:
        settings.stream() << "VK_SAMPLER_REDUCTION_MODE_MIN (";
        break;
    case 2:
        settings.stream() << "VK_SAMPLER_REDUCTION_MODE_MAX (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkSemaphoreType(VkSemaphoreType object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_SEMAPHORE_TYPE_BINARY (";
        break;
    case 1:
        settings.stream() << "VK_SEMAPHORE_TYPE_TIMELINE (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkPresentModeKHR(VkPresentModeKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_PRESENT_MODE_IMMEDIATE_KHR (";
        break;
    case 1:
        settings.stream() << "VK_PRESENT_MODE_MAILBOX_KHR (";
        break;
    case 2:
        settings.stream() << "VK_PRESENT_MODE_FIFO_KHR (";
        break;
    case 3:
        settings.stream() << "VK_PRESENT_MODE_FIFO_RELAXED_KHR (";
        break;
    case 1000111000:
        settings.stream() << "VK_PRESENT_MODE_SHARED_DEMAND_REFRESH_KHR (";
        break;
    case 1000111001:
        settings.stream() << "VK_PRESENT_MODE_SHARED_CONTINUOUS_REFRESH_KHR (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkColorSpaceKHR(VkColorSpaceKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_COLOR_SPACE_SRGB_NONLINEAR_KHR (";
        break;
    case 1000104001:
        settings.stream() << "VK_COLOR_SPACE_DISPLAY_P3_NONLINEAR_EXT (";
        break;
    case 1000104002:
        settings.stream() << "VK_COLOR_SPACE_EXTENDED_SRGB_LINEAR_EXT (";
        break;
    case 1000104003:
        settings.stream() << "VK_COLOR_SPACE_DISPLAY_P3_LINEAR_EXT (";
        break;
    case 1000104004:
        settings.stream() << "VK_COLOR_SPACE_DCI_P3_NONLINEAR_EXT (";
        break;
    case 1000104005:
        settings.stream() << "VK_COLOR_SPACE_BT709_LINEAR_EXT (";
        break;
    case 1000104006:
        settings.stream() << "VK_COLOR_SPACE_BT709_NONLINEAR_EXT (";
        break;
    case 1000104007:
        settings.stream() << "VK_COLOR_SPACE_BT2020_LINEAR_EXT (";
        break;
    case 1000104008:
        settings.stream() << "VK_COLOR_SPACE_HDR10_ST2084_EXT (";
        break;
    case 1000104009:
        settings.stream() << "VK_COLOR_SPACE_DOLBYVISION_EXT (";
        break;
    case 1000104010:
        settings.stream() << "VK_COLOR_SPACE_HDR10_HLG_EXT (";
        break;
    case 1000104011:
        settings.stream() << "VK_COLOR_SPACE_ADOBERGB_LINEAR_EXT (";
        break;
    case 1000104012:
        settings.stream() << "VK_COLOR_SPACE_ADOBERGB_NONLINEAR_EXT (";
        break;
    case 1000104013:
        settings.stream() << "VK_COLOR_SPACE_PASS_THROUGH_EXT (";
        break;
    case 1000104014:
        settings.stream() << "VK_COLOR_SPACE_EXTENDED_SRGB_NONLINEAR_EXT (";
        break;
    case 1000213000:
        settings.stream() << "VK_COLOR_SPACE_DISPLAY_NATIVE_AMD (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkDebugReportObjectTypeEXT(VkDebugReportObjectTypeEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_UNKNOWN_EXT (";
        break;
    case 1:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_INSTANCE_EXT (";
        break;
    case 2:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_PHYSICAL_DEVICE_EXT (";
        break;
    case 3:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_DEVICE_EXT (";
        break;
    case 4:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_QUEUE_EXT (";
        break;
    case 5:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_SEMAPHORE_EXT (";
        break;
    case 6:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_COMMAND_BUFFER_EXT (";
        break;
    case 7:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_FENCE_EXT (";
        break;
    case 8:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_DEVICE_MEMORY_EXT (";
        break;
    case 9:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_EXT (";
        break;
    case 10:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_IMAGE_EXT (";
        break;
    case 11:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_EVENT_EXT (";
        break;
    case 12:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_QUERY_POOL_EXT (";
        break;
    case 13:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_VIEW_EXT (";
        break;
    case 14:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_IMAGE_VIEW_EXT (";
        break;
    case 15:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_SHADER_MODULE_EXT (";
        break;
    case 16:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_CACHE_EXT (";
        break;
    case 17:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_LAYOUT_EXT (";
        break;
    case 18:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_RENDER_PASS_EXT (";
        break;
    case 19:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_EXT (";
        break;
    case 20:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT_EXT (";
        break;
    case 21:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_SAMPLER_EXT (";
        break;
    case 22:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_POOL_EXT (";
        break;
    case 23:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_SET_EXT (";
        break;
    case 24:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_FRAMEBUFFER_EXT (";
        break;
    case 25:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_COMMAND_POOL_EXT (";
        break;
    case 26:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_SURFACE_KHR_EXT (";
        break;
    case 27:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_SWAPCHAIN_KHR_EXT (";
        break;
    case 28:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT_EXT (";
        break;
    case 29:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_DISPLAY_KHR_EXT (";
        break;
    case 30:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_DISPLAY_MODE_KHR_EXT (";
        break;
    case 33:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_VALIDATION_CACHE_EXT_EXT (";
        break;
    case 1000156000:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION_EXT (";
        break;
    case 1000085000:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_EXT (";
        break;
    case 1000029000:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_CU_MODULE_NVX_EXT (";
        break;
    case 1000029001:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_CU_FUNCTION_NVX_EXT (";
        break;
    case 1000150000:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR_EXT (";
        break;
    case 1000165000:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV_EXT (";
        break;
    case 1000366000:
        settings.stream() << "VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_COLLECTION_FUCHSIA_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkRasterizationOrderAMD(VkRasterizationOrderAMD object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_RASTERIZATION_ORDER_STRICT_AMD (";
        break;
    case 1:
        settings.stream() << "VK_RASTERIZATION_ORDER_RELAXED_AMD (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkQueryResultStatusKHR(VkQueryResultStatusKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case -1:
        settings.stream() << "VK_QUERY_RESULT_STATUS_ERROR_KHR (";
        break;
    case 0:
        settings.stream() << "VK_QUERY_RESULT_STATUS_NOT_READY_KHR (";
        break;
    case 1:
        settings.stream() << "VK_QUERY_RESULT_STATUS_COMPLETE_KHR (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeH264RateControlStructureEXT(VkVideoEncodeH264RateControlStructureEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_VIDEO_ENCODE_H264_RATE_CONTROL_STRUCTURE_UNKNOWN_EXT (";
        break;
    case 1:
        settings.stream() << "VK_VIDEO_ENCODE_H264_RATE_CONTROL_STRUCTURE_FLAT_EXT (";
        break;
    case 2:
        settings.stream() << "VK_VIDEO_ENCODE_H264_RATE_CONTROL_STRUCTURE_DYADIC_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
#endif // VK_ENABLE_BETA_EXTENSIONS
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeH265RateControlStructureEXT(VkVideoEncodeH265RateControlStructureEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_VIDEO_ENCODE_H265_RATE_CONTROL_STRUCTURE_UNKNOWN_EXT (";
        break;
    case 1:
        settings.stream() << "VK_VIDEO_ENCODE_H265_RATE_CONTROL_STRUCTURE_FLAT_EXT (";
        break;
    case 2:
        settings.stream() << "VK_VIDEO_ENCODE_H265_RATE_CONTROL_STRUCTURE_DYADIC_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
#endif // VK_ENABLE_BETA_EXTENSIONS
void dump_html_VkShaderInfoTypeAMD(VkShaderInfoTypeAMD object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_SHADER_INFO_TYPE_STATISTICS_AMD (";
        break;
    case 1:
        settings.stream() << "VK_SHADER_INFO_TYPE_BINARY_AMD (";
        break;
    case 2:
        settings.stream() << "VK_SHADER_INFO_TYPE_DISASSEMBLY_AMD (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkValidationCheckEXT(VkValidationCheckEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_VALIDATION_CHECK_ALL_EXT (";
        break;
    case 1:
        settings.stream() << "VK_VALIDATION_CHECK_SHADERS_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkPipelineRobustnessBufferBehaviorEXT(VkPipelineRobustnessBufferBehaviorEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_PIPELINE_ROBUSTNESS_BUFFER_BEHAVIOR_DEVICE_DEFAULT_EXT (";
        break;
    case 1:
        settings.stream() << "VK_PIPELINE_ROBUSTNESS_BUFFER_BEHAVIOR_DISABLED_EXT (";
        break;
    case 2:
        settings.stream() << "VK_PIPELINE_ROBUSTNESS_BUFFER_BEHAVIOR_ROBUST_BUFFER_ACCESS_EXT (";
        break;
    case 3:
        settings.stream() << "VK_PIPELINE_ROBUSTNESS_BUFFER_BEHAVIOR_ROBUST_BUFFER_ACCESS_2_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkPipelineRobustnessImageBehaviorEXT(VkPipelineRobustnessImageBehaviorEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_PIPELINE_ROBUSTNESS_IMAGE_BEHAVIOR_DEVICE_DEFAULT_EXT (";
        break;
    case 1:
        settings.stream() << "VK_PIPELINE_ROBUSTNESS_IMAGE_BEHAVIOR_DISABLED_EXT (";
        break;
    case 2:
        settings.stream() << "VK_PIPELINE_ROBUSTNESS_IMAGE_BEHAVIOR_ROBUST_IMAGE_ACCESS_EXT (";
        break;
    case 3:
        settings.stream() << "VK_PIPELINE_ROBUSTNESS_IMAGE_BEHAVIOR_ROBUST_IMAGE_ACCESS_2_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkDisplayPowerStateEXT(VkDisplayPowerStateEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_DISPLAY_POWER_STATE_OFF_EXT (";
        break;
    case 1:
        settings.stream() << "VK_DISPLAY_POWER_STATE_SUSPEND_EXT (";
        break;
    case 2:
        settings.stream() << "VK_DISPLAY_POWER_STATE_ON_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkDeviceEventTypeEXT(VkDeviceEventTypeEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_DEVICE_EVENT_TYPE_DISPLAY_HOTPLUG_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkDisplayEventTypeEXT(VkDisplayEventTypeEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_DISPLAY_EVENT_TYPE_FIRST_PIXEL_OUT_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkViewportCoordinateSwizzleNV(VkViewportCoordinateSwizzleNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_X_NV (";
        break;
    case 1:
        settings.stream() << "VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_X_NV (";
        break;
    case 2:
        settings.stream() << "VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_Y_NV (";
        break;
    case 3:
        settings.stream() << "VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_Y_NV (";
        break;
    case 4:
        settings.stream() << "VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_Z_NV (";
        break;
    case 5:
        settings.stream() << "VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_Z_NV (";
        break;
    case 6:
        settings.stream() << "VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_W_NV (";
        break;
    case 7:
        settings.stream() << "VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_W_NV (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkDiscardRectangleModeEXT(VkDiscardRectangleModeEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_DISCARD_RECTANGLE_MODE_INCLUSIVE_EXT (";
        break;
    case 1:
        settings.stream() << "VK_DISCARD_RECTANGLE_MODE_EXCLUSIVE_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkConservativeRasterizationModeEXT(VkConservativeRasterizationModeEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_CONSERVATIVE_RASTERIZATION_MODE_DISABLED_EXT (";
        break;
    case 1:
        settings.stream() << "VK_CONSERVATIVE_RASTERIZATION_MODE_OVERESTIMATE_EXT (";
        break;
    case 2:
        settings.stream() << "VK_CONSERVATIVE_RASTERIZATION_MODE_UNDERESTIMATE_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkPerformanceCounterUnitKHR(VkPerformanceCounterUnitKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_PERFORMANCE_COUNTER_UNIT_GENERIC_KHR (";
        break;
    case 1:
        settings.stream() << "VK_PERFORMANCE_COUNTER_UNIT_PERCENTAGE_KHR (";
        break;
    case 2:
        settings.stream() << "VK_PERFORMANCE_COUNTER_UNIT_NANOSECONDS_KHR (";
        break;
    case 3:
        settings.stream() << "VK_PERFORMANCE_COUNTER_UNIT_BYTES_KHR (";
        break;
    case 4:
        settings.stream() << "VK_PERFORMANCE_COUNTER_UNIT_BYTES_PER_SECOND_KHR (";
        break;
    case 5:
        settings.stream() << "VK_PERFORMANCE_COUNTER_UNIT_KELVIN_KHR (";
        break;
    case 6:
        settings.stream() << "VK_PERFORMANCE_COUNTER_UNIT_WATTS_KHR (";
        break;
    case 7:
        settings.stream() << "VK_PERFORMANCE_COUNTER_UNIT_VOLTS_KHR (";
        break;
    case 8:
        settings.stream() << "VK_PERFORMANCE_COUNTER_UNIT_AMPS_KHR (";
        break;
    case 9:
        settings.stream() << "VK_PERFORMANCE_COUNTER_UNIT_HERTZ_KHR (";
        break;
    case 10:
        settings.stream() << "VK_PERFORMANCE_COUNTER_UNIT_CYCLES_KHR (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkPerformanceCounterScopeKHR(VkPerformanceCounterScopeKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_PERFORMANCE_COUNTER_SCOPE_COMMAND_BUFFER_KHR (";
        break;
    case 1:
        settings.stream() << "VK_PERFORMANCE_COUNTER_SCOPE_RENDER_PASS_KHR (";
        break;
    case 2:
        settings.stream() << "VK_PERFORMANCE_COUNTER_SCOPE_COMMAND_KHR (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkPerformanceCounterStorageKHR(VkPerformanceCounterStorageKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_PERFORMANCE_COUNTER_STORAGE_INT32_KHR (";
        break;
    case 1:
        settings.stream() << "VK_PERFORMANCE_COUNTER_STORAGE_INT64_KHR (";
        break;
    case 2:
        settings.stream() << "VK_PERFORMANCE_COUNTER_STORAGE_UINT32_KHR (";
        break;
    case 3:
        settings.stream() << "VK_PERFORMANCE_COUNTER_STORAGE_UINT64_KHR (";
        break;
    case 4:
        settings.stream() << "VK_PERFORMANCE_COUNTER_STORAGE_FLOAT32_KHR (";
        break;
    case 5:
        settings.stream() << "VK_PERFORMANCE_COUNTER_STORAGE_FLOAT64_KHR (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkBlendOverlapEXT(VkBlendOverlapEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_BLEND_OVERLAP_UNCORRELATED_EXT (";
        break;
    case 1:
        settings.stream() << "VK_BLEND_OVERLAP_DISJOINT_EXT (";
        break;
    case 2:
        settings.stream() << "VK_BLEND_OVERLAP_CONJOINT_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkAccelerationStructureTypeKHR(VkAccelerationStructureTypeKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR (";
        break;
    case 1:
        settings.stream() << "VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR (";
        break;
    case 2:
        settings.stream() << "VK_ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkBuildAccelerationStructureModeKHR(VkBuildAccelerationStructureModeKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_BUILD_ACCELERATION_STRUCTURE_MODE_BUILD_KHR (";
        break;
    case 1:
        settings.stream() << "VK_BUILD_ACCELERATION_STRUCTURE_MODE_UPDATE_KHR (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkGeometryTypeKHR(VkGeometryTypeKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_GEOMETRY_TYPE_TRIANGLES_KHR (";
        break;
    case 1:
        settings.stream() << "VK_GEOMETRY_TYPE_AABBS_KHR (";
        break;
    case 2:
        settings.stream() << "VK_GEOMETRY_TYPE_INSTANCES_KHR (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkAccelerationStructureBuildTypeKHR(VkAccelerationStructureBuildTypeKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_ACCELERATION_STRUCTURE_BUILD_TYPE_HOST_KHR (";
        break;
    case 1:
        settings.stream() << "VK_ACCELERATION_STRUCTURE_BUILD_TYPE_DEVICE_KHR (";
        break;
    case 2:
        settings.stream() << "VK_ACCELERATION_STRUCTURE_BUILD_TYPE_HOST_OR_DEVICE_KHR (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkCopyAccelerationStructureModeKHR(VkCopyAccelerationStructureModeKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_COPY_ACCELERATION_STRUCTURE_MODE_CLONE_KHR (";
        break;
    case 1:
        settings.stream() << "VK_COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_KHR (";
        break;
    case 2:
        settings.stream() << "VK_COPY_ACCELERATION_STRUCTURE_MODE_SERIALIZE_KHR (";
        break;
    case 3:
        settings.stream() << "VK_COPY_ACCELERATION_STRUCTURE_MODE_DESERIALIZE_KHR (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkAccelerationStructureCompatibilityKHR(VkAccelerationStructureCompatibilityKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_ACCELERATION_STRUCTURE_COMPATIBILITY_COMPATIBLE_KHR (";
        break;
    case 1:
        settings.stream() << "VK_ACCELERATION_STRUCTURE_COMPATIBILITY_INCOMPATIBLE_KHR (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkCoverageModulationModeNV(VkCoverageModulationModeNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_COVERAGE_MODULATION_MODE_NONE_NV (";
        break;
    case 1:
        settings.stream() << "VK_COVERAGE_MODULATION_MODE_RGB_NV (";
        break;
    case 2:
        settings.stream() << "VK_COVERAGE_MODULATION_MODE_ALPHA_NV (";
        break;
    case 3:
        settings.stream() << "VK_COVERAGE_MODULATION_MODE_RGBA_NV (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkValidationCacheHeaderVersionEXT(VkValidationCacheHeaderVersionEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 1:
        settings.stream() << "VK_VALIDATION_CACHE_HEADER_VERSION_ONE_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkShadingRatePaletteEntryNV(VkShadingRatePaletteEntryNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_SHADING_RATE_PALETTE_ENTRY_NO_INVOCATIONS_NV (";
        break;
    case 1:
        settings.stream() << "VK_SHADING_RATE_PALETTE_ENTRY_16_INVOCATIONS_PER_PIXEL_NV (";
        break;
    case 2:
        settings.stream() << "VK_SHADING_RATE_PALETTE_ENTRY_8_INVOCATIONS_PER_PIXEL_NV (";
        break;
    case 3:
        settings.stream() << "VK_SHADING_RATE_PALETTE_ENTRY_4_INVOCATIONS_PER_PIXEL_NV (";
        break;
    case 4:
        settings.stream() << "VK_SHADING_RATE_PALETTE_ENTRY_2_INVOCATIONS_PER_PIXEL_NV (";
        break;
    case 5:
        settings.stream() << "VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_PIXEL_NV (";
        break;
    case 6:
        settings.stream() << "VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X1_PIXELS_NV (";
        break;
    case 7:
        settings.stream() << "VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_1X2_PIXELS_NV (";
        break;
    case 8:
        settings.stream() << "VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X2_PIXELS_NV (";
        break;
    case 9:
        settings.stream() << "VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_4X2_PIXELS_NV (";
        break;
    case 10:
        settings.stream() << "VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X4_PIXELS_NV (";
        break;
    case 11:
        settings.stream() << "VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_4X4_PIXELS_NV (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkCoarseSampleOrderTypeNV(VkCoarseSampleOrderTypeNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_COARSE_SAMPLE_ORDER_TYPE_DEFAULT_NV (";
        break;
    case 1:
        settings.stream() << "VK_COARSE_SAMPLE_ORDER_TYPE_CUSTOM_NV (";
        break;
    case 2:
        settings.stream() << "VK_COARSE_SAMPLE_ORDER_TYPE_PIXEL_MAJOR_NV (";
        break;
    case 3:
        settings.stream() << "VK_COARSE_SAMPLE_ORDER_TYPE_SAMPLE_MAJOR_NV (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkRayTracingShaderGroupTypeKHR(VkRayTracingShaderGroupTypeKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_KHR (";
        break;
    case 1:
        settings.stream() << "VK_RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_KHR (";
        break;
    case 2:
        settings.stream() << "VK_RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_KHR (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkAccelerationStructureMemoryRequirementsTypeNV(VkAccelerationStructureMemoryRequirementsTypeNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV (";
        break;
    case 1:
        settings.stream() << "VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_BUILD_SCRATCH_NV (";
        break;
    case 2:
        settings.stream() << "VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_UPDATE_SCRATCH_NV (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkQueueGlobalPriorityKHR(VkQueueGlobalPriorityKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 128:
        settings.stream() << "VK_QUEUE_GLOBAL_PRIORITY_LOW_KHR (";
        break;
    case 256:
        settings.stream() << "VK_QUEUE_GLOBAL_PRIORITY_MEDIUM_KHR (";
        break;
    case 512:
        settings.stream() << "VK_QUEUE_GLOBAL_PRIORITY_HIGH_KHR (";
        break;
    case 1024:
        settings.stream() << "VK_QUEUE_GLOBAL_PRIORITY_REALTIME_KHR (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkTimeDomainEXT(VkTimeDomainEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_TIME_DOMAIN_DEVICE_EXT (";
        break;
    case 1:
        settings.stream() << "VK_TIME_DOMAIN_CLOCK_MONOTONIC_EXT (";
        break;
    case 2:
        settings.stream() << "VK_TIME_DOMAIN_CLOCK_MONOTONIC_RAW_EXT (";
        break;
    case 3:
        settings.stream() << "VK_TIME_DOMAIN_QUERY_PERFORMANCE_COUNTER_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkMemoryOverallocationBehaviorAMD(VkMemoryOverallocationBehaviorAMD object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_MEMORY_OVERALLOCATION_BEHAVIOR_DEFAULT_AMD (";
        break;
    case 1:
        settings.stream() << "VK_MEMORY_OVERALLOCATION_BEHAVIOR_ALLOWED_AMD (";
        break;
    case 2:
        settings.stream() << "VK_MEMORY_OVERALLOCATION_BEHAVIOR_DISALLOWED_AMD (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkPerformanceConfigurationTypeINTEL(VkPerformanceConfigurationTypeINTEL object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_PERFORMANCE_CONFIGURATION_TYPE_COMMAND_QUEUE_METRICS_DISCOVERY_ACTIVATED_INTEL (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkQueryPoolSamplingModeINTEL(VkQueryPoolSamplingModeINTEL object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_QUERY_POOL_SAMPLING_MODE_MANUAL_INTEL (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkPerformanceOverrideTypeINTEL(VkPerformanceOverrideTypeINTEL object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_PERFORMANCE_OVERRIDE_TYPE_NULL_HARDWARE_INTEL (";
        break;
    case 1:
        settings.stream() << "VK_PERFORMANCE_OVERRIDE_TYPE_FLUSH_GPU_CACHES_INTEL (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkPerformanceParameterTypeINTEL(VkPerformanceParameterTypeINTEL object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_PERFORMANCE_PARAMETER_TYPE_HW_COUNTERS_SUPPORTED_INTEL (";
        break;
    case 1:
        settings.stream() << "VK_PERFORMANCE_PARAMETER_TYPE_STREAM_MARKER_VALID_BITS_INTEL (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkPerformanceValueTypeINTEL(VkPerformanceValueTypeINTEL object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_PERFORMANCE_VALUE_TYPE_UINT32_INTEL (";
        break;
    case 1:
        settings.stream() << "VK_PERFORMANCE_VALUE_TYPE_UINT64_INTEL (";
        break;
    case 2:
        settings.stream() << "VK_PERFORMANCE_VALUE_TYPE_FLOAT_INTEL (";
        break;
    case 3:
        settings.stream() << "VK_PERFORMANCE_VALUE_TYPE_BOOL_INTEL (";
        break;
    case 4:
        settings.stream() << "VK_PERFORMANCE_VALUE_TYPE_STRING_INTEL (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkFragmentShadingRateCombinerOpKHR(VkFragmentShadingRateCombinerOpKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR (";
        break;
    case 1:
        settings.stream() << "VK_FRAGMENT_SHADING_RATE_COMBINER_OP_REPLACE_KHR (";
        break;
    case 2:
        settings.stream() << "VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MIN_KHR (";
        break;
    case 3:
        settings.stream() << "VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MAX_KHR (";
        break;
    case 4:
        settings.stream() << "VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MUL_KHR (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkValidationFeatureEnableEXT(VkValidationFeatureEnableEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_VALIDATION_FEATURE_ENABLE_GPU_ASSISTED_EXT (";
        break;
    case 1:
        settings.stream() << "VK_VALIDATION_FEATURE_ENABLE_GPU_ASSISTED_RESERVE_BINDING_SLOT_EXT (";
        break;
    case 2:
        settings.stream() << "VK_VALIDATION_FEATURE_ENABLE_BEST_PRACTICES_EXT (";
        break;
    case 3:
        settings.stream() << "VK_VALIDATION_FEATURE_ENABLE_DEBUG_PRINTF_EXT (";
        break;
    case 4:
        settings.stream() << "VK_VALIDATION_FEATURE_ENABLE_SYNCHRONIZATION_VALIDATION_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkValidationFeatureDisableEXT(VkValidationFeatureDisableEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_VALIDATION_FEATURE_DISABLE_ALL_EXT (";
        break;
    case 1:
        settings.stream() << "VK_VALIDATION_FEATURE_DISABLE_SHADERS_EXT (";
        break;
    case 2:
        settings.stream() << "VK_VALIDATION_FEATURE_DISABLE_THREAD_SAFETY_EXT (";
        break;
    case 3:
        settings.stream() << "VK_VALIDATION_FEATURE_DISABLE_API_PARAMETERS_EXT (";
        break;
    case 4:
        settings.stream() << "VK_VALIDATION_FEATURE_DISABLE_OBJECT_LIFETIMES_EXT (";
        break;
    case 5:
        settings.stream() << "VK_VALIDATION_FEATURE_DISABLE_CORE_CHECKS_EXT (";
        break;
    case 6:
        settings.stream() << "VK_VALIDATION_FEATURE_DISABLE_UNIQUE_HANDLES_EXT (";
        break;
    case 7:
        settings.stream() << "VK_VALIDATION_FEATURE_DISABLE_SHADER_VALIDATION_CACHE_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkComponentTypeNV(VkComponentTypeNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_COMPONENT_TYPE_FLOAT16_NV (";
        break;
    case 1:
        settings.stream() << "VK_COMPONENT_TYPE_FLOAT32_NV (";
        break;
    case 2:
        settings.stream() << "VK_COMPONENT_TYPE_FLOAT64_NV (";
        break;
    case 3:
        settings.stream() << "VK_COMPONENT_TYPE_SINT8_NV (";
        break;
    case 4:
        settings.stream() << "VK_COMPONENT_TYPE_SINT16_NV (";
        break;
    case 5:
        settings.stream() << "VK_COMPONENT_TYPE_SINT32_NV (";
        break;
    case 6:
        settings.stream() << "VK_COMPONENT_TYPE_SINT64_NV (";
        break;
    case 7:
        settings.stream() << "VK_COMPONENT_TYPE_UINT8_NV (";
        break;
    case 8:
        settings.stream() << "VK_COMPONENT_TYPE_UINT16_NV (";
        break;
    case 9:
        settings.stream() << "VK_COMPONENT_TYPE_UINT32_NV (";
        break;
    case 10:
        settings.stream() << "VK_COMPONENT_TYPE_UINT64_NV (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkScopeNV(VkScopeNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 1:
        settings.stream() << "VK_SCOPE_DEVICE_NV (";
        break;
    case 2:
        settings.stream() << "VK_SCOPE_WORKGROUP_NV (";
        break;
    case 3:
        settings.stream() << "VK_SCOPE_SUBGROUP_NV (";
        break;
    case 5:
        settings.stream() << "VK_SCOPE_QUEUE_FAMILY_NV (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkCoverageReductionModeNV(VkCoverageReductionModeNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_COVERAGE_REDUCTION_MODE_MERGE_NV (";
        break;
    case 1:
        settings.stream() << "VK_COVERAGE_REDUCTION_MODE_TRUNCATE_NV (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkProvokingVertexModeEXT(VkProvokingVertexModeEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_PROVOKING_VERTEX_MODE_FIRST_VERTEX_EXT (";
        break;
    case 1:
        settings.stream() << "VK_PROVOKING_VERTEX_MODE_LAST_VERTEX_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
#if defined(VK_USE_PLATFORM_WIN32_KHR)
void dump_html_VkFullScreenExclusiveEXT(VkFullScreenExclusiveEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_FULL_SCREEN_EXCLUSIVE_DEFAULT_EXT (";
        break;
    case 1:
        settings.stream() << "VK_FULL_SCREEN_EXCLUSIVE_ALLOWED_EXT (";
        break;
    case 2:
        settings.stream() << "VK_FULL_SCREEN_EXCLUSIVE_DISALLOWED_EXT (";
        break;
    case 3:
        settings.stream() << "VK_FULL_SCREEN_EXCLUSIVE_APPLICATION_CONTROLLED_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
#endif // VK_USE_PLATFORM_WIN32_KHR
void dump_html_VkLineRasterizationModeEXT(VkLineRasterizationModeEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_LINE_RASTERIZATION_MODE_DEFAULT_EXT (";
        break;
    case 1:
        settings.stream() << "VK_LINE_RASTERIZATION_MODE_RECTANGULAR_EXT (";
        break;
    case 2:
        settings.stream() << "VK_LINE_RASTERIZATION_MODE_BRESENHAM_EXT (";
        break;
    case 3:
        settings.stream() << "VK_LINE_RASTERIZATION_MODE_RECTANGULAR_SMOOTH_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkPipelineExecutableStatisticFormatKHR(VkPipelineExecutableStatisticFormatKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_BOOL32_KHR (";
        break;
    case 1:
        settings.stream() << "VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_INT64_KHR (";
        break;
    case 2:
        settings.stream() << "VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_UINT64_KHR (";
        break;
    case 3:
        settings.stream() << "VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_FLOAT64_KHR (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkIndirectCommandsTokenTypeNV(VkIndirectCommandsTokenTypeNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_INDIRECT_COMMANDS_TOKEN_TYPE_SHADER_GROUP_NV (";
        break;
    case 1:
        settings.stream() << "VK_INDIRECT_COMMANDS_TOKEN_TYPE_STATE_FLAGS_NV (";
        break;
    case 2:
        settings.stream() << "VK_INDIRECT_COMMANDS_TOKEN_TYPE_INDEX_BUFFER_NV (";
        break;
    case 3:
        settings.stream() << "VK_INDIRECT_COMMANDS_TOKEN_TYPE_VERTEX_BUFFER_NV (";
        break;
    case 4:
        settings.stream() << "VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV (";
        break;
    case 5:
        settings.stream() << "VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_INDEXED_NV (";
        break;
    case 6:
        settings.stream() << "VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_NV (";
        break;
    case 7:
        settings.stream() << "VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_TASKS_NV (";
        break;
    case 1000328000:
        settings.stream() << "VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_MESH_TASKS_NV (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkDeviceMemoryReportEventTypeEXT(VkDeviceMemoryReportEventTypeEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_ALLOCATE_EXT (";
        break;
    case 1:
        settings.stream() << "VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_FREE_EXT (";
        break;
    case 2:
        settings.stream() << "VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_IMPORT_EXT (";
        break;
    case 3:
        settings.stream() << "VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_UNIMPORT_EXT (";
        break;
    case 4:
        settings.stream() << "VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_ALLOCATION_FAILED_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeTuningModeKHR(VkVideoEncodeTuningModeKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_VIDEO_ENCODE_TUNING_MODE_DEFAULT_KHR (";
        break;
    case 1:
        settings.stream() << "VK_VIDEO_ENCODE_TUNING_MODE_HIGH_QUALITY_KHR (";
        break;
    case 2:
        settings.stream() << "VK_VIDEO_ENCODE_TUNING_MODE_LOW_LATENCY_KHR (";
        break;
    case 3:
        settings.stream() << "VK_VIDEO_ENCODE_TUNING_MODE_ULTRA_LOW_LATENCY_KHR (";
        break;
    case 4:
        settings.stream() << "VK_VIDEO_ENCODE_TUNING_MODE_LOSSLESS_KHR (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
#endif // VK_ENABLE_BETA_EXTENSIONS
void dump_html_VkFragmentShadingRateTypeNV(VkFragmentShadingRateTypeNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_FRAGMENT_SHADING_RATE_TYPE_FRAGMENT_SIZE_NV (";
        break;
    case 1:
        settings.stream() << "VK_FRAGMENT_SHADING_RATE_TYPE_ENUMS_NV (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkFragmentShadingRateNV(VkFragmentShadingRateNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_PIXEL_NV (";
        break;
    case 1:
        settings.stream() << "VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_1X2_PIXELS_NV (";
        break;
    case 4:
        settings.stream() << "VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X1_PIXELS_NV (";
        break;
    case 5:
        settings.stream() << "VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X2_PIXELS_NV (";
        break;
    case 6:
        settings.stream() << "VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X4_PIXELS_NV (";
        break;
    case 9:
        settings.stream() << "VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_4X2_PIXELS_NV (";
        break;
    case 10:
        settings.stream() << "VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_4X4_PIXELS_NV (";
        break;
    case 11:
        settings.stream() << "VK_FRAGMENT_SHADING_RATE_2_INVOCATIONS_PER_PIXEL_NV (";
        break;
    case 12:
        settings.stream() << "VK_FRAGMENT_SHADING_RATE_4_INVOCATIONS_PER_PIXEL_NV (";
        break;
    case 13:
        settings.stream() << "VK_FRAGMENT_SHADING_RATE_8_INVOCATIONS_PER_PIXEL_NV (";
        break;
    case 14:
        settings.stream() << "VK_FRAGMENT_SHADING_RATE_16_INVOCATIONS_PER_PIXEL_NV (";
        break;
    case 15:
        settings.stream() << "VK_FRAGMENT_SHADING_RATE_NO_INVOCATIONS_NV (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkAccelerationStructureMotionInstanceTypeNV(VkAccelerationStructureMotionInstanceTypeNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_STATIC_NV (";
        break;
    case 1:
        settings.stream() << "VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_MATRIX_MOTION_NV (";
        break;
    case 2:
        settings.stream() << "VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_SRT_MOTION_NV (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkDeviceFaultAddressTypeEXT(VkDeviceFaultAddressTypeEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_DEVICE_FAULT_ADDRESS_TYPE_NONE_EXT (";
        break;
    case 1:
        settings.stream() << "VK_DEVICE_FAULT_ADDRESS_TYPE_READ_INVALID_EXT (";
        break;
    case 2:
        settings.stream() << "VK_DEVICE_FAULT_ADDRESS_TYPE_WRITE_INVALID_EXT (";
        break;
    case 3:
        settings.stream() << "VK_DEVICE_FAULT_ADDRESS_TYPE_EXECUTE_INVALID_EXT (";
        break;
    case 4:
        settings.stream() << "VK_DEVICE_FAULT_ADDRESS_TYPE_INSTRUCTION_POINTER_UNKNOWN_EXT (";
        break;
    case 5:
        settings.stream() << "VK_DEVICE_FAULT_ADDRESS_TYPE_INSTRUCTION_POINTER_INVALID_EXT (";
        break;
    case 6:
        settings.stream() << "VK_DEVICE_FAULT_ADDRESS_TYPE_INSTRUCTION_POINTER_FAULT_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkDeviceFaultVendorBinaryHeaderVersionEXT(VkDeviceFaultVendorBinaryHeaderVersionEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 1:
        settings.stream() << "VK_DEVICE_FAULT_VENDOR_BINARY_HEADER_VERSION_ONE_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkShaderGroupShaderKHR(VkShaderGroupShaderKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_SHADER_GROUP_SHADER_GENERAL_KHR (";
        break;
    case 1:
        settings.stream() << "VK_SHADER_GROUP_SHADER_CLOSEST_HIT_KHR (";
        break;
    case 2:
        settings.stream() << "VK_SHADER_GROUP_SHADER_ANY_HIT_KHR (";
        break;
    case 3:
        settings.stream() << "VK_SHADER_GROUP_SHADER_INTERSECTION_KHR (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkDeviceAddressBindingTypeEXT(VkDeviceAddressBindingTypeEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_DEVICE_ADDRESS_BINDING_TYPE_BIND_EXT (";
        break;
    case 1:
        settings.stream() << "VK_DEVICE_ADDRESS_BINDING_TYPE_UNBIND_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkMicromapTypeEXT(VkMicromapTypeEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_MICROMAP_TYPE_OPACITY_MICROMAP_EXT (";
        break;
    case 1000397000:
        settings.stream() << "VK_MICROMAP_TYPE_DISPLACEMENT_MICROMAP_NV (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkBuildMicromapModeEXT(VkBuildMicromapModeEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_BUILD_MICROMAP_MODE_BUILD_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkCopyMicromapModeEXT(VkCopyMicromapModeEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_COPY_MICROMAP_MODE_CLONE_EXT (";
        break;
    case 1:
        settings.stream() << "VK_COPY_MICROMAP_MODE_SERIALIZE_EXT (";
        break;
    case 2:
        settings.stream() << "VK_COPY_MICROMAP_MODE_DESERIALIZE_EXT (";
        break;
    case 3:
        settings.stream() << "VK_COPY_MICROMAP_MODE_COMPACT_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkOpacityMicromapFormatEXT(VkOpacityMicromapFormatEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 1:
        settings.stream() << "VK_OPACITY_MICROMAP_FORMAT_2_STATE_EXT (";
        break;
    case 2:
        settings.stream() << "VK_OPACITY_MICROMAP_FORMAT_4_STATE_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkOpacityMicromapSpecialIndexEXT(VkOpacityMicromapSpecialIndexEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case -1:
        settings.stream() << "VK_OPACITY_MICROMAP_SPECIAL_INDEX_FULLY_TRANSPARENT_EXT (";
        break;
    case -2:
        settings.stream() << "VK_OPACITY_MICROMAP_SPECIAL_INDEX_FULLY_OPAQUE_EXT (";
        break;
    case -3:
        settings.stream() << "VK_OPACITY_MICROMAP_SPECIAL_INDEX_FULLY_UNKNOWN_TRANSPARENT_EXT (";
        break;
    case -4:
        settings.stream() << "VK_OPACITY_MICROMAP_SPECIAL_INDEX_FULLY_UNKNOWN_OPAQUE_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkDisplacementMicromapFormatNV(VkDisplacementMicromapFormatNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 1:
        settings.stream() << "VK_DISPLACEMENT_MICROMAP_FORMAT_64_TRIANGLES_64_BYTES_NV (";
        break;
    case 2:
        settings.stream() << "VK_DISPLACEMENT_MICROMAP_FORMAT_256_TRIANGLES_128_BYTES_NV (";
        break;
    case 3:
        settings.stream() << "VK_DISPLACEMENT_MICROMAP_FORMAT_1024_TRIANGLES_128_BYTES_NV (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
#endif // VK_ENABLE_BETA_EXTENSIONS
void dump_html_VkSubpassMergeStatusEXT(VkSubpassMergeStatusEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_SUBPASS_MERGE_STATUS_MERGED_EXT (";
        break;
    case 1:
        settings.stream() << "VK_SUBPASS_MERGE_STATUS_DISALLOWED_EXT (";
        break;
    case 2:
        settings.stream() << "VK_SUBPASS_MERGE_STATUS_NOT_MERGED_SIDE_EFFECTS_EXT (";
        break;
    case 3:
        settings.stream() << "VK_SUBPASS_MERGE_STATUS_NOT_MERGED_SAMPLES_MISMATCH_EXT (";
        break;
    case 4:
        settings.stream() << "VK_SUBPASS_MERGE_STATUS_NOT_MERGED_VIEWS_MISMATCH_EXT (";
        break;
    case 5:
        settings.stream() << "VK_SUBPASS_MERGE_STATUS_NOT_MERGED_ALIASING_EXT (";
        break;
    case 6:
        settings.stream() << "VK_SUBPASS_MERGE_STATUS_NOT_MERGED_DEPENDENCIES_EXT (";
        break;
    case 7:
        settings.stream() << "VK_SUBPASS_MERGE_STATUS_NOT_MERGED_INCOMPATIBLE_INPUT_ATTACHMENT_EXT (";
        break;
    case 8:
        settings.stream() << "VK_SUBPASS_MERGE_STATUS_NOT_MERGED_TOO_MANY_ATTACHMENTS_EXT (";
        break;
    case 9:
        settings.stream() << "VK_SUBPASS_MERGE_STATUS_NOT_MERGED_INSUFFICIENT_STORAGE_EXT (";
        break;
    case 10:
        settings.stream() << "VK_SUBPASS_MERGE_STATUS_NOT_MERGED_DEPTH_STENCIL_COUNT_EXT (";
        break;
    case 11:
        settings.stream() << "VK_SUBPASS_MERGE_STATUS_NOT_MERGED_RESOLVE_ATTACHMENT_REUSE_EXT (";
        break;
    case 12:
        settings.stream() << "VK_SUBPASS_MERGE_STATUS_NOT_MERGED_SINGLE_SUBPASS_EXT (";
        break;
    case 13:
        settings.stream() << "VK_SUBPASS_MERGE_STATUS_NOT_MERGED_UNSPECIFIED_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkDirectDriverLoadingModeLUNARG(VkDirectDriverLoadingModeLUNARG object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_DIRECT_DRIVER_LOADING_MODE_EXCLUSIVE_LUNARG (";
        break;
    case 1:
        settings.stream() << "VK_DIRECT_DRIVER_LOADING_MODE_INCLUSIVE_LUNARG (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkOpticalFlowPerformanceLevelNV(VkOpticalFlowPerformanceLevelNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_OPTICAL_FLOW_PERFORMANCE_LEVEL_UNKNOWN_NV (";
        break;
    case 1:
        settings.stream() << "VK_OPTICAL_FLOW_PERFORMANCE_LEVEL_SLOW_NV (";
        break;
    case 2:
        settings.stream() << "VK_OPTICAL_FLOW_PERFORMANCE_LEVEL_MEDIUM_NV (";
        break;
    case 3:
        settings.stream() << "VK_OPTICAL_FLOW_PERFORMANCE_LEVEL_FAST_NV (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkOpticalFlowSessionBindingPointNV(VkOpticalFlowSessionBindingPointNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_OPTICAL_FLOW_SESSION_BINDING_POINT_UNKNOWN_NV (";
        break;
    case 1:
        settings.stream() << "VK_OPTICAL_FLOW_SESSION_BINDING_POINT_INPUT_NV (";
        break;
    case 2:
        settings.stream() << "VK_OPTICAL_FLOW_SESSION_BINDING_POINT_REFERENCE_NV (";
        break;
    case 3:
        settings.stream() << "VK_OPTICAL_FLOW_SESSION_BINDING_POINT_HINT_NV (";
        break;
    case 4:
        settings.stream() << "VK_OPTICAL_FLOW_SESSION_BINDING_POINT_FLOW_VECTOR_NV (";
        break;
    case 5:
        settings.stream() << "VK_OPTICAL_FLOW_SESSION_BINDING_POINT_BACKWARD_FLOW_VECTOR_NV (";
        break;
    case 6:
        settings.stream() << "VK_OPTICAL_FLOW_SESSION_BINDING_POINT_COST_NV (";
        break;
    case 7:
        settings.stream() << "VK_OPTICAL_FLOW_SESSION_BINDING_POINT_BACKWARD_COST_NV (";
        break;
    case 8:
        settings.stream() << "VK_OPTICAL_FLOW_SESSION_BINDING_POINT_GLOBAL_FLOW_NV (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkShaderCodeTypeEXT(VkShaderCodeTypeEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_SHADER_CODE_TYPE_BINARY_EXT (";
        break;
    case 1:
        settings.stream() << "VK_SHADER_CODE_TYPE_SPIRV_EXT (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}
void dump_html_VkRayTracingInvocationReorderModeNV(VkRayTracingInvocationReorderModeNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "VK_RAY_TRACING_INVOCATION_REORDER_MODE_NONE_NV (";
        break;
    case 1:
        settings.stream() << "VK_RAY_TRACING_INVOCATION_REORDER_MODE_REORDER_NV (";
        break;
    default:
        settings.stream() << "UNKNOWN (";
    }
    settings.stream() << object << ")</div></summary>";
}

//========================= Bitmask Implementations =========================//

void dump_html_VkAccessFlagBits(VkAccessFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_INDIRECT_COMMAND_READ_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_INDEX_READ_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_VERTEX_ATTRIBUTE_READ_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_UNIFORM_READ_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_INPUT_ATTACHMENT_READ_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_SHADER_READ_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_SHADER_WRITE_BIT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_COLOR_ATTACHMENT_READ_BIT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_COLOR_ATTACHMENT_WRITE_BIT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_TRANSFER_READ_BIT"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_TRANSFER_WRITE_BIT"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_HOST_READ_BIT"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_HOST_WRITE_BIT"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_MEMORY_READ_BIT"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_MEMORY_WRITE_BIT"; is_first = false;
    }
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_NONE"; is_first = false;
    }
    if(object & 33554432) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_TRANSFORM_FEEDBACK_WRITE_BIT_EXT"; is_first = false;
    }
    if(object & 67108864) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT"; is_first = false;
    }
    if(object & 134217728) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_CONDITIONAL_RENDERING_READ_BIT_EXT"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT"; is_first = false;
    }
    if(object & 2097152) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_ACCELERATION_STRUCTURE_READ_BIT_KHR"; is_first = false;
    }
    if(object & 4194304) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_KHR"; is_first = false;
    }
    if(object & 16777216) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_FRAGMENT_DENSITY_MAP_READ_BIT_EXT"; is_first = false;
    }
    if(object & 8388608) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_COMMAND_PREPROCESS_READ_BIT_NV"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_COMMAND_PREPROCESS_WRITE_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkImageAspectFlagBits(VkImageAspectFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_COLOR_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_DEPTH_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_STENCIL_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_METADATA_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_PLANE_0_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_PLANE_1_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_PLANE_2_BIT"; is_first = false;
    }
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_NONE"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_MEMORY_PLANE_0_BIT_EXT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_MEMORY_PLANE_1_BIT_EXT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_MEMORY_PLANE_2_BIT_EXT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_MEMORY_PLANE_3_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkFormatFeatureFlagBits(VkFormatFeatureFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_STORAGE_IMAGE_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_STORAGE_IMAGE_ATOMIC_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_ATOMIC_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_VERTEX_BUFFER_BIT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_BLIT_SRC_BIT"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_BLIT_DST_BIT"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_TRANSFER_SRC_BIT"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_TRANSFER_DST_BIT"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT"; is_first = false;
    }
    if(object & 2097152) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT"; is_first = false;
    }
    if(object & 4194304) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_DISJOINT_BIT"; is_first = false;
    }
    if(object & 8388608) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT"; is_first = false;
    }
    if(object & 33554432) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_VIDEO_DECODE_OUTPUT_BIT_KHR"; is_first = false;
    }
    if(object & 67108864) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_VIDEO_DECODE_DPB_BIT_KHR"; is_first = false;
    }
    if(object & 536870912) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_EXT"; is_first = false;
    }
    if(object & 16777216) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_FRAGMENT_DENSITY_MAP_BIT_EXT"; is_first = false;
    }
    if(object & 1073741824) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR"; is_first = false;
    }
    if(object & 134217728) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_VIDEO_ENCODE_INPUT_BIT_KHR"; is_first = false;
    }
    if(object & 268435456) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_VIDEO_ENCODE_DPB_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkImageCreateFlagBits(VkImageCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_SPARSE_BINDING_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_SPARSE_ALIASED_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_ALIAS_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_EXTENDED_USAGE_BIT"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_PROTECTED_BIT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_DISJOINT_BIT"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_EXT"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_RESERVED_19_BIT_EXT"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_BIT_EXT"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_2D_VIEW_COMPATIBLE_BIT_EXT"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_FRAGMENT_DENSITY_MAP_OFFSET_BIT_QCOM"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkSampleCountFlagBits(VkSampleCountFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLE_COUNT_1_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLE_COUNT_2_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLE_COUNT_4_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLE_COUNT_8_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLE_COUNT_16_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLE_COUNT_32_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLE_COUNT_64_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkImageUsageFlagBits(VkImageUsageFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_TRANSFER_SRC_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_TRANSFER_DST_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_SAMPLED_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_STORAGE_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_VIDEO_DECODE_SRC_BIT_KHR"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_RESERVED_16_BIT_QCOM"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_RESERVED_17_BIT_QCOM"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR"; is_first = false;
    }
    if(object & 4194304) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_RESERVED_22_BIT_EXT"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_VIDEO_ENCODE_DST_BIT_KHR"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_INVOCATION_MASK_BIT_HUAWEI"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_SAMPLE_WEIGHT_BIT_QCOM"; is_first = false;
    }
    if(object & 2097152) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_SAMPLE_BLOCK_MATCH_BIT_QCOM"; is_first = false;
    }
    if(object & 8388608) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_RESERVED_23_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkInstanceCreateFlagBits(VkInstanceCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_INSTANCE_CREATE_ENUMERATE_PORTABILITY_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkMemoryHeapFlagBits(VkMemoryHeapFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_HEAP_DEVICE_LOCAL_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_HEAP_MULTI_INSTANCE_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkMemoryPropertyFlagBits(VkMemoryPropertyFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_DEVICE_LOCAL_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_HOST_VISIBLE_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_HOST_COHERENT_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_HOST_CACHED_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_PROTECTED_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_DEVICE_UNCACHED_BIT_AMD"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_RDMA_CAPABLE_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkQueueFlagBits(VkQueueFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_GRAPHICS_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_COMPUTE_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_TRANSFER_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_SPARSE_BINDING_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_PROTECTED_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_VIDEO_DECODE_BIT_KHR"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_RESERVED_9_BIT_EXT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_VIDEO_ENCODE_BIT_KHR"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_RESERVED_7_BIT_QCOM"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_RESERVED_11_BIT_ARM"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_OPTICAL_FLOW_BIT_NV"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_RESERVED_10_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkDeviceQueueCreateFlagBits(VkDeviceQueueCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_QUEUE_CREATE_PROTECTED_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_QUEUE_CREATE_RESERVED_1_BIT_QCOM"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkPipelineStageFlagBits(VkPipelineStageFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_VERTEX_INPUT_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_VERTEX_SHADER_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_TRANSFER_BIT"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_HOST_BIT"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_ALL_GRAPHICS_BIT"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_ALL_COMMANDS_BIT"; is_first = false;
    }
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_NONE"; is_first = false;
    }
    if(object & 16777216) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT"; is_first = false;
    }
    if(object & 33554432) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR"; is_first = false;
    }
    if(object & 2097152) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR"; is_first = false;
    }
    if(object & 8388608) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT"; is_first = false;
    }
    if(object & 4194304) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_NV"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_TASK_SHADER_BIT_EXT"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_MESH_SHADER_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkSparseMemoryBindFlagBits(VkSparseMemoryBindFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SPARSE_MEMORY_BIND_METADATA_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkSparseImageFormatFlagBits(VkSparseImageFormatFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SPARSE_IMAGE_FORMAT_SINGLE_MIPTAIL_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SPARSE_IMAGE_FORMAT_ALIGNED_MIP_SIZE_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SPARSE_IMAGE_FORMAT_NONSTANDARD_BLOCK_SIZE_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkFenceCreateFlagBits(VkFenceCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FENCE_CREATE_SIGNALED_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkEventCreateFlagBits(VkEventCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EVENT_CREATE_DEVICE_ONLY_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkQueryPipelineStatisticFlagBits(VkQueryPipelineStatisticFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_VERTICES_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_PRIMITIVES_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_VERTEX_SHADER_INVOCATIONS_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_INVOCATIONS_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_PRIMITIVES_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_CLIPPING_INVOCATIONS_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_CLIPPING_PRIMITIVES_BIT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_FRAGMENT_SHADER_INVOCATIONS_BIT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_CONTROL_SHADER_PATCHES_BIT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_EVALUATION_SHADER_INVOCATIONS_BIT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_COMPUTE_SHADER_INVOCATIONS_BIT"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_TASK_SHADER_INVOCATIONS_BIT_EXT"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_MESH_SHADER_INVOCATIONS_BIT_EXT"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_CLUSTER_CULLING_SHADER_INVOCATIONS_BIT_HUAWEI"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkQueryResultFlagBits(VkQueryResultFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_RESULT_64_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_RESULT_WAIT_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_RESULT_WITH_AVAILABILITY_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_RESULT_PARTIAL_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_RESULT_WITH_STATUS_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkBufferCreateFlagBits(VkBufferCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_CREATE_SPARSE_BINDING_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_CREATE_SPARSE_ALIASED_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_CREATE_PROTECTED_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkBufferUsageFlagBits(VkBufferUsageFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_TRANSFER_SRC_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_TRANSFER_DST_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_UNIFORM_BUFFER_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_STORAGE_BUFFER_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_INDEX_BUFFER_BIT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_VERTEX_BUFFER_BIT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_VIDEO_DECODE_SRC_BIT_KHR"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_VIDEO_DECODE_DST_BIT_KHR"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_BUFFER_BIT_EXT"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_COUNTER_BUFFER_BIT_EXT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_CONDITIONAL_RENDERING_BIT_EXT"; is_first = false;
    }
    if(object & 33554432) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_RESERVED_25_BIT_AMD"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_BUILD_INPUT_READ_ONLY_BIT_KHR"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_STORAGE_BIT_KHR"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_SHADER_BINDING_TABLE_BIT_KHR"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_RESERVED_18_BIT_QCOM"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_VIDEO_ENCODE_DST_BIT_KHR"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_VIDEO_ENCODE_SRC_BIT_KHR"; is_first = false;
    }
    if(object & 2097152) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT"; is_first = false;
    }
    if(object & 4194304) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT"; is_first = false;
    }
    if(object & 67108864) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT"; is_first = false;
    }
    if(object & 8388608) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_MICROMAP_BUILD_INPUT_READ_ONLY_BIT_EXT"; is_first = false;
    }
    if(object & 16777216) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_MICROMAP_STORAGE_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkImageViewCreateFlagBits(VkImageViewCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DYNAMIC_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_VIEW_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DEFERRED_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkPipelineCacheCreateFlagBits(VkPipelineCacheCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CACHE_CREATE_EXTERNALLY_SYNCHRONIZED_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkColorComponentFlagBits(VkColorComponentFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COLOR_COMPONENT_R_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COLOR_COMPONENT_G_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COLOR_COMPONENT_B_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COLOR_COMPONENT_A_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkPipelineCreateFlagBits(VkPipelineCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_DISABLE_OPTIMIZATION_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_ALLOW_DERIVATIVES_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_DERIVATIVE_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_DISPATCH_BASE_BIT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT"; is_first = false;
    }
    if(object & 2097152) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR"; is_first = false;
    }
    if(object & 4194304) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_BIT_EXT"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_DEFER_COMPILE_BIT_NV"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_CAPTURE_STATISTICS_BIT_KHR"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_LIBRARY_BIT_KHR"; is_first = false;
    }
    if(object & 536870912) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_DESCRIPTOR_BUFFER_BIT_EXT"; is_first = false;
    }
    if(object & 8388608) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RETAIN_LINK_TIME_OPTIMIZATION_INFO_BIT_EXT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV"; is_first = false;
    }
    if(object & 33554432) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_COLOR_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT"; is_first = false;
    }
    if(object & 67108864) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_DEPTH_STENCIL_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT"; is_first = false;
    }
    if(object & 16777216) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_OPACITY_MICROMAP_BIT_EXT"; is_first = false;
    }
    if(object & 268435456) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_DISPLACEMENT_MICROMAP_BIT_NV"; is_first = false;
    }
    if(object & 134217728) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_NO_PROTECTED_ACCESS_BIT_EXT"; is_first = false;
    }
    if(object & 1073741824) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_PROTECTED_ACCESS_ONLY_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkPipelineShaderStageCreateFlagBits(VkPipelineShaderStageCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_SHADER_STAGE_CREATE_RESERVED_3_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkShaderStageFlagBits(VkShaderStageFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_VERTEX_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_GEOMETRY_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_FRAGMENT_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_COMPUTE_BIT"; is_first = false;
    }
    if(object == 0x0000001F) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_ALL_GRAPHICS"; is_first = false;
    }
    if(object == 0x7FFFFFFF) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_ALL"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_RAYGEN_BIT_KHR"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_ANY_HIT_BIT_KHR"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_CLOSEST_HIT_BIT_KHR"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_MISS_BIT_KHR"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_INTERSECTION_BIT_KHR"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_CALLABLE_BIT_KHR"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_TASK_BIT_EXT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_MESH_BIT_EXT"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_SUBPASS_SHADING_BIT_HUAWEI"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_CLUSTER_CULLING_BIT_HUAWEI"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkCullModeFlagBits(VkCullModeFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CULL_MODE_NONE"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CULL_MODE_FRONT_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CULL_MODE_BACK_BIT"; is_first = false;
    }
    if(object == 0x00000003) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CULL_MODE_FRONT_AND_BACK"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkPipelineDepthStencilStateCreateFlagBits(VkPipelineDepthStencilStateCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkPipelineColorBlendStateCreateFlagBits(VkPipelineColorBlendStateCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_COLOR_BLEND_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkPipelineLayoutCreateFlagBits(VkPipelineLayoutCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_LAYOUT_CREATE_RESERVED_0_BIT_AMD"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkSamplerCreateFlagBits(VkSamplerCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLER_CREATE_SUBSAMPLED_COARSE_RECONSTRUCTION_BIT_EXT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLER_CREATE_NON_SEAMLESS_CUBE_MAP_BIT_EXT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLER_CREATE_IMAGE_PROCESSING_BIT_QCOM"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkDescriptorPoolCreateFlagBits(VkDescriptorPoolCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_POOL_CREATE_FREE_DESCRIPTOR_SET_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkDescriptorSetLayoutCreateFlagBits(VkDescriptorSetLayoutCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_SET_LAYOUT_CREATE_EMBEDDED_IMMUTABLE_SAMPLERS_BIT_EXT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_SET_LAYOUT_CREATE_RESERVED_3_BIT_AMD"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_SET_LAYOUT_CREATE_RESERVED_6_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkAttachmentDescriptionFlagBits(VkAttachmentDescriptionFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkDependencyFlagBits(VkDependencyFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEPENDENCY_BY_REGION_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEPENDENCY_DEVICE_GROUP_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEPENDENCY_VIEW_LOCAL_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEPENDENCY_FEEDBACK_LOOP_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkFramebufferCreateFlagBits(VkFramebufferCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkRenderPassCreateFlagBits(VkRenderPassCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDER_PASS_CREATE_RESERVED_0_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDER_PASS_CREATE_TRANSFORM_BIT_QCOM"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkSubpassDescriptionFlagBits(VkSubpassDescriptionFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_PER_VIEW_ATTRIBUTES_BIT_NVX"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_PER_VIEW_POSITION_X_ONLY_BIT_NVX"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_FRAGMENT_REGION_BIT_QCOM"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_COLOR_ACCESS_BIT_EXT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_EXT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_EXT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_ENABLE_LEGACY_DITHERING_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkCommandPoolCreateFlagBits(VkCommandPoolCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_POOL_CREATE_TRANSIENT_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_POOL_CREATE_RESET_COMMAND_BUFFER_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_POOL_CREATE_PROTECTED_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkCommandPoolResetFlagBits(VkCommandPoolResetFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_POOL_RESET_RELEASE_RESOURCES_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_POOL_RESET_RESERVED_1_BIT_COREAVI"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkCommandBufferUsageFlagBits(VkCommandBufferUsageFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkQueryControlFlagBits(VkQueryControlFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_CONTROL_PRECISE_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkCommandBufferResetFlagBits(VkCommandBufferResetFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_BUFFER_RESET_RELEASE_RESOURCES_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkStencilFaceFlagBits(VkStencilFaceFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_STENCIL_FACE_FRONT_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_STENCIL_FACE_BACK_BIT"; is_first = false;
    }
    if(object == 0x00000003) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_STENCIL_FACE_FRONT_AND_BACK"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkSubgroupFeatureFlagBits(VkSubgroupFeatureFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_BASIC_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_VOTE_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_ARITHMETIC_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_BALLOT_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_SHUFFLE_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_SHUFFLE_RELATIVE_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_CLUSTERED_BIT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_QUAD_BIT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_PARTITIONED_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkPeerMemoryFeatureFlagBits(VkPeerMemoryFeatureFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PEER_MEMORY_FEATURE_COPY_SRC_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PEER_MEMORY_FEATURE_COPY_DST_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PEER_MEMORY_FEATURE_GENERIC_SRC_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PEER_MEMORY_FEATURE_GENERIC_DST_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkMemoryAllocateFlagBits(VkMemoryAllocateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkExternalMemoryHandleTypeFlagBits(VkExternalMemoryHandleTypeFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_DMA_BUF_BIT_EXT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_ALLOCATION_BIT_EXT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_MAPPED_FOREIGN_MEMORY_BIT_EXT"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_ZIRCON_VMO_BIT_FUCHSIA"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_RDMA_ADDRESS_BIT_NV"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_SCI_BUF_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkExternalMemoryFeatureFlagBits(VkExternalMemoryFeatureFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkExternalFenceHandleTypeFlagBits(VkExternalFenceHandleTypeFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_FD_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_HANDLE_TYPE_SYNC_FD_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_HANDLE_TYPE_SCI_SYNC_OBJ_BIT_NV"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_HANDLE_TYPE_SCI_SYNC_FENCE_BIT_NV"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_HANDLE_TYPE_SCI_SYNC_OBJ_BIT_NV"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_HANDLE_TYPE_SCI_SYNC_FENCE_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkExternalFenceFeatureFlagBits(VkExternalFenceFeatureFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_FEATURE_EXPORTABLE_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_FEATURE_IMPORTABLE_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkFenceImportFlagBits(VkFenceImportFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FENCE_IMPORT_TEMPORARY_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkSemaphoreImportFlagBits(VkSemaphoreImportFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SEMAPHORE_IMPORT_TEMPORARY_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkExternalSemaphoreHandleTypeFlagBits(VkExternalSemaphoreHandleTypeFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_SYNC_FD_BIT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_ZIRCON_EVENT_BIT_FUCHSIA"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_SCI_SYNC_OBJ_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkExternalSemaphoreFeatureFlagBits(VkExternalSemaphoreFeatureFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_FEATURE_EXPORTABLE_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_FEATURE_IMPORTABLE_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkResolveModeFlagBits(VkResolveModeFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RESOLVE_MODE_NONE"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RESOLVE_MODE_SAMPLE_ZERO_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RESOLVE_MODE_AVERAGE_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RESOLVE_MODE_MIN_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RESOLVE_MODE_MAX_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkDescriptorBindingFlagBits(VkDescriptorBindingFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_BINDING_RESERVED_4_BIT_QCOM"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkSemaphoreWaitFlagBits(VkSemaphoreWaitFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SEMAPHORE_WAIT_ANY_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkPipelineCreationFeedbackFlagBits(VkPipelineCreationFeedbackFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATION_FEEDBACK_VALID_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATION_FEEDBACK_APPLICATION_PIPELINE_CACHE_HIT_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATION_FEEDBACK_BASE_PIPELINE_ACCELERATION_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkToolPurposeFlagBits(VkToolPurposeFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TOOL_PURPOSE_VALIDATION_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TOOL_PURPOSE_PROFILING_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TOOL_PURPOSE_TRACING_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TOOL_PURPOSE_ADDITIONAL_FEATURES_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TOOL_PURPOSE_MODIFYING_FEATURES_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TOOL_PURPOSE_DEBUG_REPORTING_BIT_EXT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TOOL_PURPOSE_DEBUG_MARKERS_BIT_EXT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TOOL_PURPOSE_DEBUG_REPORTING_BIT_EXT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TOOL_PURPOSE_DEBUG_MARKERS_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkPipelineStageFlagBits2(VkPipelineStageFlagBits2 object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_NONE"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_HOST_BIT"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT"; is_first = false;
    }
    if(object & 4294967296) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_COPY_BIT"; is_first = false;
    }
    if(object & 8589934592) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_RESOLVE_BIT"; is_first = false;
    }
    if(object & 17179869184) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_BLIT_BIT"; is_first = false;
    }
    if(object & 34359738368) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_CLEAR_BIT"; is_first = false;
    }
    if(object & 68719476736) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT"; is_first = false;
    }
    if(object & 137438953472) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT"; is_first = false;
    }
    if(object & 274877906944) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_PRE_RASTERIZATION_SHADERS_BIT"; is_first = false;
    }
    if(object & 67108864) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR"; is_first = false;
    }
    if(object & 134217728) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR"; is_first = false;
    }
    if(object & 16777216) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV"; is_first = false;
    }
    if(object & 4194304) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR"; is_first = false;
    }
    if(object & 33554432) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR"; is_first = false;
    }
    if(object & 2097152) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR"; is_first = false;
    }
    if(object & 8388608) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT"; is_first = false;
    }
    if(object & 549755813888) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_SUBPASS_SHADING_BIT_HUAWEI"; is_first = false;
    }
    if(object & 1099511627776) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI"; is_first = false;
    }
    if(object & 268435456) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR"; is_first = false;
    }
    if(object & 1073741824) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT"; is_first = false;
    }
    if(object & 2199023255552) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI"; is_first = false;
    }
    if(object & 8796093022208) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_RESERVED_43_BIT_ARM"; is_first = false;
    }
    if(object & 536870912) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV"; is_first = false;
    }
    if(object & 4398046511104) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_RESERVED_42_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkAccessFlagBits2(VkAccessFlagBits2 object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_NONE"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_INDEX_READ_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_UNIFORM_READ_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_SHADER_READ_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_SHADER_WRITE_BIT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_TRANSFER_READ_BIT"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_TRANSFER_WRITE_BIT"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_HOST_READ_BIT"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_HOST_WRITE_BIT"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_MEMORY_READ_BIT"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_MEMORY_WRITE_BIT"; is_first = false;
    }
    if(object & 4294967296) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_SHADER_SAMPLED_READ_BIT"; is_first = false;
    }
    if(object & 8589934592) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_SHADER_STORAGE_READ_BIT"; is_first = false;
    }
    if(object & 17179869184) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT"; is_first = false;
    }
    if(object & 34359738368) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR"; is_first = false;
    }
    if(object & 68719476736) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR"; is_first = false;
    }
    if(object & 70368744177664) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_RESERVED_46_BIT_EXT"; is_first = false;
    }
    if(object & 137438953472) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR"; is_first = false;
    }
    if(object & 274877906944) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR"; is_first = false;
    }
    if(object & 33554432) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT"; is_first = false;
    }
    if(object & 67108864) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT"; is_first = false;
    }
    if(object & 134217728) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV"; is_first = false;
    }
    if(object & 8388608) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR"; is_first = false;
    }
    if(object & 2097152) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR"; is_first = false;
    }
    if(object & 4194304) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR"; is_first = false;
    }
    if(object & 16777216) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT"; is_first = false;
    }
    if(object & 2199023255552) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_DESCRIPTOR_BUFFER_READ_BIT_EXT"; is_first = false;
    }
    if(object & 549755813888) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_INVOCATION_MASK_READ_BIT_HUAWEI"; is_first = false;
    }
    if(object & 1099511627776) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR"; is_first = false;
    }
    if(object & 17592186044416) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_MICROMAP_READ_BIT_EXT"; is_first = false;
    }
    if(object & 35184372088832) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_MICROMAP_WRITE_BIT_EXT"; is_first = false;
    }
    if(object & 562949953421312) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_RESERVED_49_BIT_ARM"; is_first = false;
    }
    if(object & 1125899906842624) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_RESERVED_50_BIT_ARM"; is_first = false;
    }
    if(object & 4398046511104) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_OPTICAL_FLOW_READ_BIT_NV"; is_first = false;
    }
    if(object & 8796093022208) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_OPTICAL_FLOW_WRITE_BIT_NV"; is_first = false;
    }
    if(object & 140737488355328) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_RESERVED_47_BIT_EXT"; is_first = false;
    }
    if(object & 281474976710656) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_RESERVED_48_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkSubmitFlagBits(VkSubmitFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBMIT_PROTECTED_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkRenderingFlagBits(VkRenderingFlagBits object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDERING_CONTENTS_SECONDARY_COMMAND_BUFFERS_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDERING_SUSPENDING_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDERING_RESUMING_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDERING_ENABLE_LEGACY_DITHERING_BIT_EXT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDERING_ENABLE_LEGACY_DITHERING_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkFormatFeatureFlagBits2(VkFormatFeatureFlagBits2 object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_STORAGE_IMAGE_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_STORAGE_IMAGE_ATOMIC_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_UNIFORM_TEXEL_BUFFER_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_STORAGE_TEXEL_BUFFER_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_STORAGE_TEXEL_BUFFER_ATOMIC_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_VERTEX_BUFFER_BIT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_COLOR_ATTACHMENT_BIT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_COLOR_ATTACHMENT_BLEND_BIT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_DEPTH_STENCIL_ATTACHMENT_BIT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_BLIT_SRC_BIT"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_BLIT_DST_BIT"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_FILTER_LINEAR_BIT"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_FILTER_CUBIC_BIT"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_TRANSFER_SRC_BIT"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_TRANSFER_DST_BIT"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_FILTER_MINMAX_BIT"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_MIDPOINT_CHROMA_SAMPLES_BIT"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT"; is_first = false;
    }
    if(object & 2097152) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT"; is_first = false;
    }
    if(object & 4194304) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_DISJOINT_BIT"; is_first = false;
    }
    if(object & 8388608) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_COSITED_CHROMA_SAMPLES_BIT"; is_first = false;
    }
    if(object & 2147483648) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_STORAGE_READ_WITHOUT_FORMAT_BIT"; is_first = false;
    }
    if(object & 4294967296) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_STORAGE_WRITE_WITHOUT_FORMAT_BIT"; is_first = false;
    }
    if(object & 8589934592) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_DEPTH_COMPARISON_BIT"; is_first = false;
    }
    if(object & 33554432) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_VIDEO_DECODE_OUTPUT_BIT_KHR"; is_first = false;
    }
    if(object & 67108864) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_VIDEO_DECODE_DPB_BIT_KHR"; is_first = false;
    }
    if(object & 536870912) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR"; is_first = false;
    }
    if(object & 16777216) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_FRAGMENT_DENSITY_MAP_BIT_EXT"; is_first = false;
    }
    if(object & 1073741824) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR"; is_first = false;
    }
    if(object & 17592186044416) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_RESERVED_44_BIT_EXT"; is_first = false;
    }
    if(object & 35184372088832) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_RESERVED_45_BIT_EXT"; is_first = false;
    }
    if(object & 134217728) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_VIDEO_ENCODE_INPUT_BIT_KHR"; is_first = false;
    }
    if(object & 268435456) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_VIDEO_ENCODE_DPB_BIT_KHR"; is_first = false;
    }
    if(object & 274877906944) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_LINEAR_COLOR_ATTACHMENT_BIT_NV"; is_first = false;
    }
    if(object & 17179869184) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_WEIGHT_IMAGE_BIT_QCOM"; is_first = false;
    }
    if(object & 34359738368) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_WEIGHT_SAMPLED_IMAGE_BIT_QCOM"; is_first = false;
    }
    if(object & 68719476736) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_BLOCK_MATCHING_BIT_QCOM"; is_first = false;
    }
    if(object & 137438953472) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_BOX_FILTER_SAMPLED_BIT_QCOM"; is_first = false;
    }
    if(object & 549755813888) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_RESERVED_39_BIT_EXT"; is_first = false;
    }
    if(object & 1099511627776) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_OPTICAL_FLOW_IMAGE_BIT_NV"; is_first = false;
    }
    if(object & 2199023255552) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_OPTICAL_FLOW_VECTOR_BIT_NV"; is_first = false;
    }
    if(object & 4398046511104) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_OPTICAL_FLOW_COST_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkSurfaceTransformFlagBitsKHR(VkSurfaceTransformFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_BIT_KHR"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_90_BIT_KHR"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_180_BIT_KHR"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_270_BIT_KHR"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_INHERIT_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkCompositeAlphaFlagBitsKHR(VkCompositeAlphaFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMPOSITE_ALPHA_OPAQUE_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMPOSITE_ALPHA_PRE_MULTIPLIED_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMPOSITE_ALPHA_POST_MULTIPLIED_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMPOSITE_ALPHA_INHERIT_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkSwapchainCreateFlagBitsKHR(VkSwapchainCreateFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SWAPCHAIN_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SWAPCHAIN_CREATE_PROTECTED_BIT_KHR"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SWAPCHAIN_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SWAPCHAIN_CREATE_MUTABLE_FORMAT_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SWAPCHAIN_CREATE_DEFERRED_MEMORY_ALLOCATION_BIT_EXT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SWAPCHAIN_CREATE_RESERVED_4_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkDeviceGroupPresentModeFlagBitsKHR(VkDeviceGroupPresentModeFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_GROUP_PRESENT_MODE_REMOTE_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_GROUP_PRESENT_MODE_SUM_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_MULTI_DEVICE_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkDisplayPlaneAlphaFlagBitsKHR(VkDisplayPlaneAlphaFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DISPLAY_PLANE_ALPHA_OPAQUE_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DISPLAY_PLANE_ALPHA_GLOBAL_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_PREMULTIPLIED_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkDebugReportFlagBitsEXT(VkDebugReportFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_REPORT_INFORMATION_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_REPORT_WARNING_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_REPORT_PERFORMANCE_WARNING_BIT_EXT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_REPORT_ERROR_BIT_EXT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_REPORT_DEBUG_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkVideoCodecOperationFlagBitsKHR(VkVideoCodecOperationFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODEC_OPERATION_NONE_KHR"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODEC_OPERATION_ENCODE_H264_BIT_EXT"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODEC_OPERATION_ENCODE_H265_BIT_EXT"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODEC_OPERATION_DECODE_H264_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODEC_OPERATION_DECODE_H265_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkVideoChromaSubsamplingFlagBitsKHR(VkVideoChromaSubsamplingFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CHROMA_SUBSAMPLING_INVALID_KHR"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CHROMA_SUBSAMPLING_MONOCHROME_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CHROMA_SUBSAMPLING_420_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CHROMA_SUBSAMPLING_422_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CHROMA_SUBSAMPLING_444_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkVideoComponentBitDepthFlagBitsKHR(VkVideoComponentBitDepthFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_COMPONENT_BIT_DEPTH_INVALID_KHR"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_COMPONENT_BIT_DEPTH_8_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_COMPONENT_BIT_DEPTH_10_BIT_KHR"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_COMPONENT_BIT_DEPTH_12_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkVideoCapabilityFlagBitsKHR(VkVideoCapabilityFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CAPABILITY_PROTECTED_CONTENT_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CAPABILITY_SEPARATE_REFERENCE_IMAGES_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkVideoSessionCreateFlagBitsKHR(VkVideoSessionCreateFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_SESSION_CREATE_PROTECTED_CONTENT_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkVideoCodingControlFlagBitsKHR(VkVideoCodingControlFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODING_CONTROL_RESET_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODING_CONTROL_ENCODE_RATE_CONTROL_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODING_CONTROL_ENCODE_RATE_CONTROL_LAYER_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkVideoDecodeCapabilityFlagBitsKHR(VkVideoDecodeCapabilityFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_CAPABILITY_DPB_AND_OUTPUT_COINCIDE_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_CAPABILITY_DPB_AND_OUTPUT_DISTINCT_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkVideoDecodeUsageFlagBitsKHR(VkVideoDecodeUsageFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_USAGE_DEFAULT_KHR"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_USAGE_TRANSCODING_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_USAGE_OFFLINE_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_USAGE_STREAMING_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeH264CapabilityFlagBitsEXT(VkVideoEncodeH264CapabilityFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_DIRECT_8X8_INFERENCE_ENABLED_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_DIRECT_8X8_INFERENCE_DISABLED_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_SEPARATE_COLOUR_PLANE_BIT_EXT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_QPPRIME_Y_ZERO_TRANSFORM_BYPASS_BIT_EXT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_SCALING_LISTS_BIT_EXT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_HRD_COMPLIANCE_BIT_EXT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_CHROMA_QP_OFFSET_BIT_EXT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_SECOND_CHROMA_QP_OFFSET_BIT_EXT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_PIC_INIT_QP_MINUS26_BIT_EXT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_WEIGHTED_PRED_BIT_EXT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_WEIGHTED_BIPRED_EXPLICIT_BIT_EXT"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_WEIGHTED_BIPRED_IMPLICIT_BIT_EXT"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_WEIGHTED_PRED_NO_TABLE_BIT_EXT"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_TRANSFORM_8X8_BIT_EXT"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_CABAC_BIT_EXT"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_CAVLC_BIT_EXT"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_DEBLOCKING_FILTER_DISABLED_BIT_EXT"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_DEBLOCKING_FILTER_ENABLED_BIT_EXT"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_DEBLOCKING_FILTER_PARTIAL_BIT_EXT"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_DISABLE_DIRECT_SPATIAL_MV_PRED_BIT_EXT"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_MULTIPLE_SLICE_PER_FRAME_BIT_EXT"; is_first = false;
    }
    if(object & 2097152) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_SLICE_MB_COUNT_BIT_EXT"; is_first = false;
    }
    if(object & 4194304) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_ROW_UNALIGNED_SLICE_BIT_EXT"; is_first = false;
    }
    if(object & 8388608) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_DIFFERENT_SLICE_TYPE_BIT_EXT"; is_first = false;
    }
    if(object & 16777216) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_B_FRAME_IN_L1_LIST_BIT_EXT"; is_first = false;
    }
    if(object & 33554432) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_DIFFERENT_REFERENCE_FINAL_LISTS_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
#endif // VK_ENABLE_BETA_EXTENSIONS
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeH265CapabilityFlagBitsEXT(VkVideoEncodeH265CapabilityFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_SEPARATE_COLOUR_PLANE_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_SCALING_LISTS_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_SAMPLE_ADAPTIVE_OFFSET_ENABLED_BIT_EXT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_PCM_ENABLE_BIT_EXT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_SPS_TEMPORAL_MVP_ENABLED_BIT_EXT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_HRD_COMPLIANCE_BIT_EXT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_INIT_QP_MINUS26_BIT_EXT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_LOG2_PARALLEL_MERGE_LEVEL_MINUS2_BIT_EXT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_SIGN_DATA_HIDING_ENABLED_BIT_EXT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_TRANSFORM_SKIP_ENABLED_BIT_EXT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_TRANSFORM_SKIP_DISABLED_BIT_EXT"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_PPS_SLICE_CHROMA_QP_OFFSETS_PRESENT_BIT_EXT"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_WEIGHTED_PRED_BIT_EXT"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_WEIGHTED_BIPRED_BIT_EXT"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_WEIGHTED_PRED_NO_TABLE_BIT_EXT"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_TRANSQUANT_BYPASS_ENABLED_BIT_EXT"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_ENTROPY_CODING_SYNC_ENABLED_BIT_EXT"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_DEBLOCKING_FILTER_OVERRIDE_ENABLED_BIT_EXT"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_MULTIPLE_TILE_PER_FRAME_BIT_EXT"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_MULTIPLE_SLICE_PER_TILE_BIT_EXT"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_MULTIPLE_TILE_PER_SLICE_BIT_EXT"; is_first = false;
    }
    if(object & 2097152) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_SLICE_SEGMENT_CTB_COUNT_BIT_EXT"; is_first = false;
    }
    if(object & 4194304) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_ROW_UNALIGNED_SLICE_SEGMENT_BIT_EXT"; is_first = false;
    }
    if(object & 8388608) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_DEPENDENT_SLICE_SEGMENT_BIT_EXT"; is_first = false;
    }
    if(object & 16777216) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_DIFFERENT_SLICE_TYPE_BIT_EXT"; is_first = false;
    }
    if(object & 33554432) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_B_FRAME_IN_L1_LIST_BIT_EXT"; is_first = false;
    }
    if(object & 67108864) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_DIFFERENT_REFERENCE_FINAL_LISTS_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
#endif // VK_ENABLE_BETA_EXTENSIONS
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeH265CtbSizeFlagBitsEXT(VkVideoEncodeH265CtbSizeFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CTB_SIZE_16_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CTB_SIZE_32_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CTB_SIZE_64_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
#endif // VK_ENABLE_BETA_EXTENSIONS
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeH265TransformBlockSizeFlagBitsEXT(VkVideoEncodeH265TransformBlockSizeFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_TRANSFORM_BLOCK_SIZE_4_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_TRANSFORM_BLOCK_SIZE_8_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_TRANSFORM_BLOCK_SIZE_16_BIT_EXT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_TRANSFORM_BLOCK_SIZE_32_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
#endif // VK_ENABLE_BETA_EXTENSIONS
void dump_html_VkVideoDecodeH264PictureLayoutFlagBitsKHR(VkVideoDecodeH264PictureLayoutFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_H264_PICTURE_LAYOUT_PROGRESSIVE_KHR"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_H264_PICTURE_LAYOUT_INTERLACED_INTERLEAVED_LINES_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_H264_PICTURE_LAYOUT_INTERLACED_SEPARATE_PLANES_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkExternalMemoryHandleTypeFlagBitsNV(VkExternalMemoryHandleTypeFlagBitsNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT_NV"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_NV"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_IMAGE_BIT_NV"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_IMAGE_KMT_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkExternalMemoryFeatureFlagBitsNV(VkExternalMemoryFeatureFlagBitsNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT_NV"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT_NV"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkConditionalRenderingFlagBitsEXT(VkConditionalRenderingFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CONDITIONAL_RENDERING_INVERTED_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkSurfaceCounterFlagBitsEXT(VkSurfaceCounterFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_COUNTER_VBLANK_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkPerformanceCounterDescriptionFlagBitsKHR(VkPerformanceCounterDescriptionFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PERFORMANCE_COUNTER_DESCRIPTION_PERFORMANCE_IMPACTING_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PERFORMANCE_COUNTER_DESCRIPTION_CONCURRENTLY_IMPACTED_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkAcquireProfilingLockFlagBitsKHR(VkAcquireProfilingLockFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkDebugUtilsMessageSeverityFlagBitsEXT(VkDebugUtilsMessageSeverityFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_UTILS_MESSAGE_SEVERITY_VERBOSE_BIT_EXT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_UTILS_MESSAGE_SEVERITY_INFO_BIT_EXT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_UTILS_MESSAGE_SEVERITY_WARNING_BIT_EXT"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_UTILS_MESSAGE_SEVERITY_ERROR_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkDebugUtilsMessageTypeFlagBitsEXT(VkDebugUtilsMessageTypeFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_UTILS_MESSAGE_TYPE_GENERAL_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_UTILS_MESSAGE_TYPE_VALIDATION_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_UTILS_MESSAGE_TYPE_PERFORMANCE_BIT_EXT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_UTILS_MESSAGE_TYPE_DEVICE_ADDRESS_BINDING_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkBuildAccelerationStructureFlagBitsKHR(VkBuildAccelerationStructureFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_UPDATE_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_COMPACTION_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_KHR"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_LOW_MEMORY_BIT_KHR"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_OPACITY_MICROMAP_UPDATE_EXT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_DISABLE_OPACITY_MICROMAPS_EXT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_OPACITY_MICROMAP_DATA_UPDATE_EXT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_DISPLACEMENT_MICROMAP_UPDATE_NV"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_DATA_ACCESS_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkGeometryFlagBitsKHR(VkGeometryFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GEOMETRY_OPAQUE_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GEOMETRY_NO_DUPLICATE_ANY_HIT_INVOCATION_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkGeometryInstanceFlagBitsKHR(VkGeometryInstanceFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GEOMETRY_INSTANCE_TRIANGLE_FACING_CULL_DISABLE_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GEOMETRY_INSTANCE_TRIANGLE_FLIP_FACING_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GEOMETRY_INSTANCE_FORCE_OPAQUE_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GEOMETRY_INSTANCE_FORCE_NO_OPAQUE_BIT_KHR"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GEOMETRY_INSTANCE_FORCE_OPACITY_MICROMAP_2_STATE_EXT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GEOMETRY_INSTANCE_DISABLE_OPACITY_MICROMAPS_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkAccelerationStructureCreateFlagBitsKHR(VkAccelerationStructureCreateFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCELERATION_STRUCTURE_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCELERATION_STRUCTURE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkPipelineCompilerControlFlagBitsAMD(VkPipelineCompilerControlFlagBitsAMD object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkShaderCorePropertiesFlagBitsAMD(VkShaderCorePropertiesFlagBitsAMD object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkPresentScalingFlagBitsEXT(VkPresentScalingFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PRESENT_SCALING_ONE_TO_ONE_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PRESENT_SCALING_ASPECT_RATIO_STRETCH_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PRESENT_SCALING_STRETCH_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkPresentGravityFlagBitsEXT(VkPresentGravityFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PRESENT_GRAVITY_MIN_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PRESENT_GRAVITY_MAX_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PRESENT_GRAVITY_CENTERED_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkIndirectStateFlagBitsNV(VkIndirectStateFlagBitsNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_INDIRECT_STATE_FLAG_FRONTFACE_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkIndirectCommandsLayoutUsageFlagBitsNV(VkIndirectCommandsLayoutUsageFlagBitsNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_INDIRECT_COMMANDS_LAYOUT_USAGE_EXPLICIT_PREPROCESS_BIT_NV"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_INDIRECT_COMMANDS_LAYOUT_USAGE_INDEXED_SEQUENCES_BIT_NV"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_INDIRECT_COMMANDS_LAYOUT_USAGE_UNORDERED_SEQUENCES_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeCapabilityFlagBitsKHR(VkVideoEncodeCapabilityFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_CAPABILITY_PRECEDING_EXTERNALLY_ENCODED_BYTES_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
#endif // VK_ENABLE_BETA_EXTENSIONS
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeRateControlModeFlagBitsKHR(VkVideoEncodeRateControlModeFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_RATE_CONTROL_MODE_DEFAULT_KHR"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_RATE_CONTROL_MODE_DISABLED_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_RATE_CONTROL_MODE_CBR_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_RATE_CONTROL_MODE_VBR_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
#endif // VK_ENABLE_BETA_EXTENSIONS
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeFeedbackFlagBitsKHR(VkVideoEncodeFeedbackFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_FEEDBACK_BITSTREAM_BUFFER_OFFSET_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_FEEDBACK_BITSTREAM_BYTES_WRITTEN_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
#endif // VK_ENABLE_BETA_EXTENSIONS
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeUsageFlagBitsKHR(VkVideoEncodeUsageFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_USAGE_DEFAULT_KHR"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_USAGE_TRANSCODING_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_USAGE_STREAMING_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_USAGE_RECORDING_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_USAGE_CONFERENCING_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
#endif // VK_ENABLE_BETA_EXTENSIONS
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeContentFlagBitsKHR(VkVideoEncodeContentFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_CONTENT_DEFAULT_KHR"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_CONTENT_CAMERA_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_CONTENT_DESKTOP_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_CONTENT_RENDERED_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
#endif // VK_ENABLE_BETA_EXTENSIONS
void dump_html_VkDeviceDiagnosticsConfigFlagBitsNV(VkDeviceDiagnosticsConfigFlagBitsNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_SHADER_DEBUG_INFO_BIT_NV"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_RESOURCE_TRACKING_BIT_NV"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_AUTOMATIC_CHECKPOINTS_BIT_NV"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_SHADER_ERROR_REPORTING_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
#if defined(VK_USE_PLATFORM_METAL_EXT)
void dump_html_VkExportMetalObjectTypeFlagBitsEXT(VkExportMetalObjectTypeFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXPORT_METAL_OBJECT_TYPE_METAL_DEVICE_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXPORT_METAL_OBJECT_TYPE_METAL_COMMAND_QUEUE_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXPORT_METAL_OBJECT_TYPE_METAL_BUFFER_BIT_EXT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXPORT_METAL_OBJECT_TYPE_METAL_TEXTURE_BIT_EXT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXPORT_METAL_OBJECT_TYPE_METAL_IOSURFACE_BIT_EXT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXPORT_METAL_OBJECT_TYPE_METAL_SHARED_EVENT_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
#endif // VK_USE_PLATFORM_METAL_EXT
void dump_html_VkGraphicsPipelineLibraryFlagBitsEXT(VkGraphicsPipelineLibraryFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GRAPHICS_PIPELINE_LIBRARY_VERTEX_INPUT_INTERFACE_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkImageCompressionFlagBitsEXT(VkImageCompressionFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_DEFAULT_EXT"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_DEFAULT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_EXPLICIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_DISABLED_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkImageCompressionFixedRateFlagBitsEXT(VkImageCompressionFixedRateFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_NONE_EXT"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_1BPC_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_2BPC_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_3BPC_BIT_EXT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_4BPC_BIT_EXT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_5BPC_BIT_EXT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_6BPC_BIT_EXT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_7BPC_BIT_EXT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_8BPC_BIT_EXT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_9BPC_BIT_EXT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_10BPC_BIT_EXT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_11BPC_BIT_EXT"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_12BPC_BIT_EXT"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_13BPC_BIT_EXT"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_14BPC_BIT_EXT"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_15BPC_BIT_EXT"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_16BPC_BIT_EXT"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_17BPC_BIT_EXT"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_18BPC_BIT_EXT"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_19BPC_BIT_EXT"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_20BPC_BIT_EXT"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_21BPC_BIT_EXT"; is_first = false;
    }
    if(object & 2097152) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_22BPC_BIT_EXT"; is_first = false;
    }
    if(object & 4194304) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_23BPC_BIT_EXT"; is_first = false;
    }
    if(object & 8388608) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_24BPC_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkDeviceAddressBindingFlagBitsEXT(VkDeviceAddressBindingFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_ADDRESS_BINDING_INTERNAL_OBJECT_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
#if defined(VK_USE_PLATFORM_FUCHSIA)
void dump_html_VkImageConstraintsInfoFlagBitsFUCHSIA(VkImageConstraintsInfoFlagBitsFUCHSIA object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CONSTRAINTS_INFO_CPU_READ_RARELY_FUCHSIA"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CONSTRAINTS_INFO_CPU_READ_OFTEN_FUCHSIA"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CONSTRAINTS_INFO_CPU_WRITE_RARELY_FUCHSIA"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CONSTRAINTS_INFO_CPU_WRITE_OFTEN_FUCHSIA"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CONSTRAINTS_INFO_PROTECTED_OPTIONAL_FUCHSIA"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
#endif // VK_USE_PLATFORM_FUCHSIA
void dump_html_VkBuildMicromapFlagBitsEXT(VkBuildMicromapFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_MICROMAP_PREFER_FAST_TRACE_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_MICROMAP_PREFER_FAST_BUILD_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_MICROMAP_ALLOW_COMPACTION_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkMicromapCreateFlagBitsEXT(VkMicromapCreateFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MICROMAP_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkMemoryDecompressionMethodFlagBitsNV(VkMemoryDecompressionMethodFlagBitsNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_DECOMPRESSION_METHOD_GDEFLATE_1_0_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkOpticalFlowGridSizeFlagBitsNV(VkOpticalFlowGridSizeFlagBitsNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_GRID_SIZE_UNKNOWN_NV"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_GRID_SIZE_1X1_BIT_NV"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_GRID_SIZE_2X2_BIT_NV"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_GRID_SIZE_4X4_BIT_NV"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_GRID_SIZE_8X8_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkOpticalFlowUsageFlagBitsNV(VkOpticalFlowUsageFlagBitsNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_USAGE_UNKNOWN_NV"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_USAGE_INPUT_BIT_NV"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_USAGE_OUTPUT_BIT_NV"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_USAGE_HINT_BIT_NV"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_USAGE_COST_BIT_NV"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_USAGE_GLOBAL_FLOW_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkOpticalFlowSessionCreateFlagBitsNV(VkOpticalFlowSessionCreateFlagBitsNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_SESSION_CREATE_ENABLE_HINT_BIT_NV"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_SESSION_CREATE_ENABLE_COST_BIT_NV"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_SESSION_CREATE_ENABLE_GLOBAL_FLOW_BIT_NV"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_SESSION_CREATE_ALLOW_REGIONS_BIT_NV"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_SESSION_CREATE_BOTH_DIRECTIONS_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkOpticalFlowExecuteFlagBitsNV(VkOpticalFlowExecuteFlagBitsNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_EXECUTE_DISABLE_TEMPORAL_HINTS_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}
void dump_html_VkShaderCreateFlagBitsEXT(VkShaderCreateFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    bool is_first = true;
    settings.stream() << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_LINK_STAGE_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_REQUIRE_FULL_SUBGROUPS_BIT_EXT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_NO_TASK_SHADER_BIT_EXT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_DISPATCH_BASE_BIT_EXT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_EXT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_FRAGMENT_DENSITY_MAP_ATTACHMENT_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ")";
    settings.stream() << "</div></summary>";
}

//=========================== Flag Implementations ==========================//

void dump_html_VkAccessFlags(VkAccessFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkAccessFlagBits((VkAccessFlagBits) object, settings, indents);
}
void dump_html_VkImageAspectFlags(VkImageAspectFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkImageAspectFlagBits((VkImageAspectFlagBits) object, settings, indents);
}
void dump_html_VkFormatFeatureFlags(VkFormatFeatureFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkFormatFeatureFlagBits((VkFormatFeatureFlagBits) object, settings, indents);
}
void dump_html_VkImageCreateFlags(VkImageCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkImageCreateFlagBits((VkImageCreateFlagBits) object, settings, indents);
}
void dump_html_VkSampleCountFlags(VkSampleCountFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkSampleCountFlagBits((VkSampleCountFlagBits) object, settings, indents);
}
void dump_html_VkImageUsageFlags(VkImageUsageFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkImageUsageFlagBits((VkImageUsageFlagBits) object, settings, indents);
}
void dump_html_VkInstanceCreateFlags(VkInstanceCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkInstanceCreateFlagBits((VkInstanceCreateFlagBits) object, settings, indents);
}
void dump_html_VkMemoryHeapFlags(VkMemoryHeapFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkMemoryHeapFlagBits((VkMemoryHeapFlagBits) object, settings, indents);
}
void dump_html_VkMemoryPropertyFlags(VkMemoryPropertyFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkMemoryPropertyFlagBits((VkMemoryPropertyFlagBits) object, settings, indents);
}
void dump_html_VkQueueFlags(VkQueueFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkQueueFlagBits((VkQueueFlagBits) object, settings, indents);
}
void dump_html_VkDeviceQueueCreateFlags(VkDeviceQueueCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkDeviceQueueCreateFlagBits((VkDeviceQueueCreateFlagBits) object, settings, indents);
}
void dump_html_VkPipelineStageFlags(VkPipelineStageFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkPipelineStageFlagBits((VkPipelineStageFlagBits) object, settings, indents);
}
void dump_html_VkSparseMemoryBindFlags(VkSparseMemoryBindFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkSparseMemoryBindFlagBits((VkSparseMemoryBindFlagBits) object, settings, indents);
}
void dump_html_VkSparseImageFormatFlags(VkSparseImageFormatFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkSparseImageFormatFlagBits((VkSparseImageFormatFlagBits) object, settings, indents);
}
void dump_html_VkFenceCreateFlags(VkFenceCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkFenceCreateFlagBits((VkFenceCreateFlagBits) object, settings, indents);
}
void dump_html_VkEventCreateFlags(VkEventCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkEventCreateFlagBits((VkEventCreateFlagBits) object, settings, indents);
}
void dump_html_VkQueryPipelineStatisticFlags(VkQueryPipelineStatisticFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkQueryPipelineStatisticFlagBits((VkQueryPipelineStatisticFlagBits) object, settings, indents);
}
void dump_html_VkQueryResultFlags(VkQueryResultFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkQueryResultFlagBits((VkQueryResultFlagBits) object, settings, indents);
}
void dump_html_VkBufferCreateFlags(VkBufferCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkBufferCreateFlagBits((VkBufferCreateFlagBits) object, settings, indents);
}
void dump_html_VkBufferUsageFlags(VkBufferUsageFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkBufferUsageFlagBits((VkBufferUsageFlagBits) object, settings, indents);
}
void dump_html_VkImageViewCreateFlags(VkImageViewCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkImageViewCreateFlagBits((VkImageViewCreateFlagBits) object, settings, indents);
}
void dump_html_VkPipelineCacheCreateFlags(VkPipelineCacheCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkPipelineCacheCreateFlagBits((VkPipelineCacheCreateFlagBits) object, settings, indents);
}
void dump_html_VkColorComponentFlags(VkColorComponentFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkColorComponentFlagBits((VkColorComponentFlagBits) object, settings, indents);
}
void dump_html_VkPipelineCreateFlags(VkPipelineCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkPipelineCreateFlagBits((VkPipelineCreateFlagBits) object, settings, indents);
}
void dump_html_VkPipelineShaderStageCreateFlags(VkPipelineShaderStageCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkPipelineShaderStageCreateFlagBits((VkPipelineShaderStageCreateFlagBits) object, settings, indents);
}
void dump_html_VkCullModeFlags(VkCullModeFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkCullModeFlagBits((VkCullModeFlagBits) object, settings, indents);
}
void dump_html_VkPipelineDepthStencilStateCreateFlags(VkPipelineDepthStencilStateCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkPipelineDepthStencilStateCreateFlagBits((VkPipelineDepthStencilStateCreateFlagBits) object, settings, indents);
}
void dump_html_VkPipelineColorBlendStateCreateFlags(VkPipelineColorBlendStateCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkPipelineColorBlendStateCreateFlagBits((VkPipelineColorBlendStateCreateFlagBits) object, settings, indents);
}
void dump_html_VkPipelineLayoutCreateFlags(VkPipelineLayoutCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkPipelineLayoutCreateFlagBits((VkPipelineLayoutCreateFlagBits) object, settings, indents);
}
void dump_html_VkShaderStageFlags(VkShaderStageFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkShaderStageFlagBits((VkShaderStageFlagBits) object, settings, indents);
}
void dump_html_VkSamplerCreateFlags(VkSamplerCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkSamplerCreateFlagBits((VkSamplerCreateFlagBits) object, settings, indents);
}
void dump_html_VkDescriptorPoolCreateFlags(VkDescriptorPoolCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkDescriptorPoolCreateFlagBits((VkDescriptorPoolCreateFlagBits) object, settings, indents);
}
void dump_html_VkDescriptorSetLayoutCreateFlags(VkDescriptorSetLayoutCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkDescriptorSetLayoutCreateFlagBits((VkDescriptorSetLayoutCreateFlagBits) object, settings, indents);
}
void dump_html_VkAttachmentDescriptionFlags(VkAttachmentDescriptionFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkAttachmentDescriptionFlagBits((VkAttachmentDescriptionFlagBits) object, settings, indents);
}
void dump_html_VkDependencyFlags(VkDependencyFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkDependencyFlagBits((VkDependencyFlagBits) object, settings, indents);
}
void dump_html_VkFramebufferCreateFlags(VkFramebufferCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkFramebufferCreateFlagBits((VkFramebufferCreateFlagBits) object, settings, indents);
}
void dump_html_VkRenderPassCreateFlags(VkRenderPassCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkRenderPassCreateFlagBits((VkRenderPassCreateFlagBits) object, settings, indents);
}
void dump_html_VkSubpassDescriptionFlags(VkSubpassDescriptionFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkSubpassDescriptionFlagBits((VkSubpassDescriptionFlagBits) object, settings, indents);
}
void dump_html_VkCommandPoolCreateFlags(VkCommandPoolCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkCommandPoolCreateFlagBits((VkCommandPoolCreateFlagBits) object, settings, indents);
}
void dump_html_VkCommandPoolResetFlags(VkCommandPoolResetFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkCommandPoolResetFlagBits((VkCommandPoolResetFlagBits) object, settings, indents);
}
void dump_html_VkCommandBufferUsageFlags(VkCommandBufferUsageFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkCommandBufferUsageFlagBits((VkCommandBufferUsageFlagBits) object, settings, indents);
}
void dump_html_VkQueryControlFlags(VkQueryControlFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkQueryControlFlagBits((VkQueryControlFlagBits) object, settings, indents);
}
void dump_html_VkCommandBufferResetFlags(VkCommandBufferResetFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkCommandBufferResetFlagBits((VkCommandBufferResetFlagBits) object, settings, indents);
}
void dump_html_VkStencilFaceFlags(VkStencilFaceFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkStencilFaceFlagBits((VkStencilFaceFlagBits) object, settings, indents);
}
void dump_html_VkSubgroupFeatureFlags(VkSubgroupFeatureFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkSubgroupFeatureFlagBits((VkSubgroupFeatureFlagBits) object, settings, indents);
}
void dump_html_VkPeerMemoryFeatureFlags(VkPeerMemoryFeatureFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkPeerMemoryFeatureFlagBits((VkPeerMemoryFeatureFlagBits) object, settings, indents);
}
void dump_html_VkMemoryAllocateFlags(VkMemoryAllocateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkMemoryAllocateFlagBits((VkMemoryAllocateFlagBits) object, settings, indents);
}
void dump_html_VkExternalMemoryHandleTypeFlags(VkExternalMemoryHandleTypeFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkExternalMemoryHandleTypeFlagBits((VkExternalMemoryHandleTypeFlagBits) object, settings, indents);
}
void dump_html_VkExternalMemoryFeatureFlags(VkExternalMemoryFeatureFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkExternalMemoryFeatureFlagBits((VkExternalMemoryFeatureFlagBits) object, settings, indents);
}
void dump_html_VkExternalFenceHandleTypeFlags(VkExternalFenceHandleTypeFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkExternalFenceHandleTypeFlagBits((VkExternalFenceHandleTypeFlagBits) object, settings, indents);
}
void dump_html_VkExternalFenceFeatureFlags(VkExternalFenceFeatureFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkExternalFenceFeatureFlagBits((VkExternalFenceFeatureFlagBits) object, settings, indents);
}
void dump_html_VkFenceImportFlags(VkFenceImportFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkFenceImportFlagBits((VkFenceImportFlagBits) object, settings, indents);
}
void dump_html_VkSemaphoreImportFlags(VkSemaphoreImportFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkSemaphoreImportFlagBits((VkSemaphoreImportFlagBits) object, settings, indents);
}
void dump_html_VkExternalSemaphoreHandleTypeFlags(VkExternalSemaphoreHandleTypeFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkExternalSemaphoreHandleTypeFlagBits((VkExternalSemaphoreHandleTypeFlagBits) object, settings, indents);
}
void dump_html_VkExternalSemaphoreFeatureFlags(VkExternalSemaphoreFeatureFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkExternalSemaphoreFeatureFlagBits((VkExternalSemaphoreFeatureFlagBits) object, settings, indents);
}
void dump_html_VkResolveModeFlags(VkResolveModeFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkResolveModeFlagBits((VkResolveModeFlagBits) object, settings, indents);
}
void dump_html_VkDescriptorBindingFlags(VkDescriptorBindingFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkDescriptorBindingFlagBits((VkDescriptorBindingFlagBits) object, settings, indents);
}
void dump_html_VkSemaphoreWaitFlags(VkSemaphoreWaitFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkSemaphoreWaitFlagBits((VkSemaphoreWaitFlagBits) object, settings, indents);
}
void dump_html_VkPipelineCreationFeedbackFlags(VkPipelineCreationFeedbackFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkPipelineCreationFeedbackFlagBits((VkPipelineCreationFeedbackFlagBits) object, settings, indents);
}
void dump_html_VkToolPurposeFlags(VkToolPurposeFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkToolPurposeFlagBits((VkToolPurposeFlagBits) object, settings, indents);
}
void dump_html_VkPipelineStageFlags2(VkPipelineStageFlags2 object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkPipelineStageFlagBits2((VkPipelineStageFlagBits2) object, settings, indents);
}
void dump_html_VkAccessFlags2(VkAccessFlags2 object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkAccessFlagBits2((VkAccessFlagBits2) object, settings, indents);
}
void dump_html_VkSubmitFlags(VkSubmitFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkSubmitFlagBits((VkSubmitFlagBits) object, settings, indents);
}
void dump_html_VkRenderingFlags(VkRenderingFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkRenderingFlagBits((VkRenderingFlagBits) object, settings, indents);
}
void dump_html_VkFormatFeatureFlags2(VkFormatFeatureFlags2 object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkFormatFeatureFlagBits2((VkFormatFeatureFlagBits2) object, settings, indents);
}
void dump_html_VkCompositeAlphaFlagsKHR(VkCompositeAlphaFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkCompositeAlphaFlagBitsKHR((VkCompositeAlphaFlagBitsKHR) object, settings, indents);
}
void dump_html_VkSurfaceTransformFlagsKHR(VkSurfaceTransformFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkSurfaceTransformFlagBitsKHR((VkSurfaceTransformFlagBitsKHR) object, settings, indents);
}
void dump_html_VkSwapchainCreateFlagsKHR(VkSwapchainCreateFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkSwapchainCreateFlagBitsKHR((VkSwapchainCreateFlagBitsKHR) object, settings, indents);
}
void dump_html_VkDeviceGroupPresentModeFlagsKHR(VkDeviceGroupPresentModeFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkDeviceGroupPresentModeFlagBitsKHR((VkDeviceGroupPresentModeFlagBitsKHR) object, settings, indents);
}
void dump_html_VkDisplayPlaneAlphaFlagsKHR(VkDisplayPlaneAlphaFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkDisplayPlaneAlphaFlagBitsKHR((VkDisplayPlaneAlphaFlagBitsKHR) object, settings, indents);
}
void dump_html_VkDebugReportFlagsEXT(VkDebugReportFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkDebugReportFlagBitsEXT((VkDebugReportFlagBitsEXT) object, settings, indents);
}
void dump_html_VkVideoCodecOperationFlagsKHR(VkVideoCodecOperationFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkVideoCodecOperationFlagBitsKHR((VkVideoCodecOperationFlagBitsKHR) object, settings, indents);
}
void dump_html_VkVideoChromaSubsamplingFlagsKHR(VkVideoChromaSubsamplingFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkVideoChromaSubsamplingFlagBitsKHR((VkVideoChromaSubsamplingFlagBitsKHR) object, settings, indents);
}
void dump_html_VkVideoComponentBitDepthFlagsKHR(VkVideoComponentBitDepthFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkVideoComponentBitDepthFlagBitsKHR((VkVideoComponentBitDepthFlagBitsKHR) object, settings, indents);
}
void dump_html_VkVideoCapabilityFlagsKHR(VkVideoCapabilityFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkVideoCapabilityFlagBitsKHR((VkVideoCapabilityFlagBitsKHR) object, settings, indents);
}
void dump_html_VkVideoSessionCreateFlagsKHR(VkVideoSessionCreateFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkVideoSessionCreateFlagBitsKHR((VkVideoSessionCreateFlagBitsKHR) object, settings, indents);
}
void dump_html_VkVideoCodingControlFlagsKHR(VkVideoCodingControlFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkVideoCodingControlFlagBitsKHR((VkVideoCodingControlFlagBitsKHR) object, settings, indents);
}
void dump_html_VkVideoDecodeCapabilityFlagsKHR(VkVideoDecodeCapabilityFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkVideoDecodeCapabilityFlagBitsKHR((VkVideoDecodeCapabilityFlagBitsKHR) object, settings, indents);
}
void dump_html_VkVideoDecodeUsageFlagsKHR(VkVideoDecodeUsageFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkVideoDecodeUsageFlagBitsKHR((VkVideoDecodeUsageFlagBitsKHR) object, settings, indents);
}
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeH264CapabilityFlagsEXT(VkVideoEncodeH264CapabilityFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkVideoEncodeH264CapabilityFlagBitsEXT((VkVideoEncodeH264CapabilityFlagBitsEXT) object, settings, indents);
}
#endif // VK_ENABLE_BETA_EXTENSIONS
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeH265CapabilityFlagsEXT(VkVideoEncodeH265CapabilityFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkVideoEncodeH265CapabilityFlagBitsEXT((VkVideoEncodeH265CapabilityFlagBitsEXT) object, settings, indents);
}
#endif // VK_ENABLE_BETA_EXTENSIONS
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeH265CtbSizeFlagsEXT(VkVideoEncodeH265CtbSizeFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkVideoEncodeH265CtbSizeFlagBitsEXT((VkVideoEncodeH265CtbSizeFlagBitsEXT) object, settings, indents);
}
#endif // VK_ENABLE_BETA_EXTENSIONS
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeH265TransformBlockSizeFlagsEXT(VkVideoEncodeH265TransformBlockSizeFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkVideoEncodeH265TransformBlockSizeFlagBitsEXT((VkVideoEncodeH265TransformBlockSizeFlagBitsEXT) object, settings, indents);
}
#endif // VK_ENABLE_BETA_EXTENSIONS
void dump_html_VkVideoDecodeH264PictureLayoutFlagsKHR(VkVideoDecodeH264PictureLayoutFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkVideoDecodeH264PictureLayoutFlagBitsKHR((VkVideoDecodeH264PictureLayoutFlagBitsKHR) object, settings, indents);
}
void dump_html_VkExternalMemoryHandleTypeFlagsNV(VkExternalMemoryHandleTypeFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkExternalMemoryHandleTypeFlagBitsNV((VkExternalMemoryHandleTypeFlagBitsNV) object, settings, indents);
}
void dump_html_VkExternalMemoryFeatureFlagsNV(VkExternalMemoryFeatureFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkExternalMemoryFeatureFlagBitsNV((VkExternalMemoryFeatureFlagBitsNV) object, settings, indents);
}
void dump_html_VkConditionalRenderingFlagsEXT(VkConditionalRenderingFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkConditionalRenderingFlagBitsEXT((VkConditionalRenderingFlagBitsEXT) object, settings, indents);
}
void dump_html_VkSurfaceCounterFlagsEXT(VkSurfaceCounterFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkSurfaceCounterFlagBitsEXT((VkSurfaceCounterFlagBitsEXT) object, settings, indents);
}
void dump_html_VkPerformanceCounterDescriptionFlagsKHR(VkPerformanceCounterDescriptionFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkPerformanceCounterDescriptionFlagBitsKHR((VkPerformanceCounterDescriptionFlagBitsKHR) object, settings, indents);
}
void dump_html_VkAcquireProfilingLockFlagsKHR(VkAcquireProfilingLockFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkAcquireProfilingLockFlagBitsKHR((VkAcquireProfilingLockFlagBitsKHR) object, settings, indents);
}
void dump_html_VkDebugUtilsMessageTypeFlagsEXT(VkDebugUtilsMessageTypeFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkDebugUtilsMessageTypeFlagBitsEXT((VkDebugUtilsMessageTypeFlagBitsEXT) object, settings, indents);
}
void dump_html_VkDebugUtilsMessageSeverityFlagsEXT(VkDebugUtilsMessageSeverityFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkDebugUtilsMessageSeverityFlagBitsEXT((VkDebugUtilsMessageSeverityFlagBitsEXT) object, settings, indents);
}
void dump_html_VkBuildAccelerationStructureFlagsKHR(VkBuildAccelerationStructureFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkBuildAccelerationStructureFlagBitsKHR((VkBuildAccelerationStructureFlagBitsKHR) object, settings, indents);
}
void dump_html_VkGeometryFlagsKHR(VkGeometryFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkGeometryFlagBitsKHR((VkGeometryFlagBitsKHR) object, settings, indents);
}
void dump_html_VkGeometryInstanceFlagsKHR(VkGeometryInstanceFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkGeometryInstanceFlagBitsKHR((VkGeometryInstanceFlagBitsKHR) object, settings, indents);
}
void dump_html_VkAccelerationStructureCreateFlagsKHR(VkAccelerationStructureCreateFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkAccelerationStructureCreateFlagBitsKHR((VkAccelerationStructureCreateFlagBitsKHR) object, settings, indents);
}
void dump_html_VkPipelineCompilerControlFlagsAMD(VkPipelineCompilerControlFlagsAMD object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkPipelineCompilerControlFlagBitsAMD((VkPipelineCompilerControlFlagBitsAMD) object, settings, indents);
}
void dump_html_VkShaderCorePropertiesFlagsAMD(VkShaderCorePropertiesFlagsAMD object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkShaderCorePropertiesFlagBitsAMD((VkShaderCorePropertiesFlagBitsAMD) object, settings, indents);
}
void dump_html_VkPresentScalingFlagsEXT(VkPresentScalingFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkPresentScalingFlagBitsEXT((VkPresentScalingFlagBitsEXT) object, settings, indents);
}
void dump_html_VkPresentGravityFlagsEXT(VkPresentGravityFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkPresentGravityFlagBitsEXT((VkPresentGravityFlagBitsEXT) object, settings, indents);
}
void dump_html_VkIndirectStateFlagsNV(VkIndirectStateFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkIndirectStateFlagBitsNV((VkIndirectStateFlagBitsNV) object, settings, indents);
}
void dump_html_VkIndirectCommandsLayoutUsageFlagsNV(VkIndirectCommandsLayoutUsageFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkIndirectCommandsLayoutUsageFlagBitsNV((VkIndirectCommandsLayoutUsageFlagBitsNV) object, settings, indents);
}
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeCapabilityFlagsKHR(VkVideoEncodeCapabilityFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkVideoEncodeCapabilityFlagBitsKHR((VkVideoEncodeCapabilityFlagBitsKHR) object, settings, indents);
}
#endif // VK_ENABLE_BETA_EXTENSIONS
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeRateControlModeFlagsKHR(VkVideoEncodeRateControlModeFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkVideoEncodeRateControlModeFlagBitsKHR((VkVideoEncodeRateControlModeFlagBitsKHR) object, settings, indents);
}
#endif // VK_ENABLE_BETA_EXTENSIONS
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeFeedbackFlagsKHR(VkVideoEncodeFeedbackFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkVideoEncodeFeedbackFlagBitsKHR((VkVideoEncodeFeedbackFlagBitsKHR) object, settings, indents);
}
#endif // VK_ENABLE_BETA_EXTENSIONS
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeUsageFlagsKHR(VkVideoEncodeUsageFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkVideoEncodeUsageFlagBitsKHR((VkVideoEncodeUsageFlagBitsKHR) object, settings, indents);
}
#endif // VK_ENABLE_BETA_EXTENSIONS
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeContentFlagsKHR(VkVideoEncodeContentFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkVideoEncodeContentFlagBitsKHR((VkVideoEncodeContentFlagBitsKHR) object, settings, indents);
}
#endif // VK_ENABLE_BETA_EXTENSIONS
void dump_html_VkDeviceDiagnosticsConfigFlagsNV(VkDeviceDiagnosticsConfigFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkDeviceDiagnosticsConfigFlagBitsNV((VkDeviceDiagnosticsConfigFlagBitsNV) object, settings, indents);
}
#if defined(VK_USE_PLATFORM_METAL_EXT)
void dump_html_VkExportMetalObjectTypeFlagsEXT(VkExportMetalObjectTypeFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkExportMetalObjectTypeFlagBitsEXT((VkExportMetalObjectTypeFlagBitsEXT) object, settings, indents);
}
#endif // VK_USE_PLATFORM_METAL_EXT
void dump_html_VkGraphicsPipelineLibraryFlagsEXT(VkGraphicsPipelineLibraryFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkGraphicsPipelineLibraryFlagBitsEXT((VkGraphicsPipelineLibraryFlagBitsEXT) object, settings, indents);
}
void dump_html_VkImageCompressionFlagsEXT(VkImageCompressionFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkImageCompressionFlagBitsEXT((VkImageCompressionFlagBitsEXT) object, settings, indents);
}
void dump_html_VkImageCompressionFixedRateFlagsEXT(VkImageCompressionFixedRateFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkImageCompressionFixedRateFlagBitsEXT((VkImageCompressionFixedRateFlagBitsEXT) object, settings, indents);
}
void dump_html_VkDeviceAddressBindingFlagsEXT(VkDeviceAddressBindingFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkDeviceAddressBindingFlagBitsEXT((VkDeviceAddressBindingFlagBitsEXT) object, settings, indents);
}
#if defined(VK_USE_PLATFORM_FUCHSIA)
void dump_html_VkImageConstraintsInfoFlagsFUCHSIA(VkImageConstraintsInfoFlagsFUCHSIA object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkImageConstraintsInfoFlagBitsFUCHSIA((VkImageConstraintsInfoFlagBitsFUCHSIA) object, settings, indents);
}
#endif // VK_USE_PLATFORM_FUCHSIA
void dump_html_VkBuildMicromapFlagsEXT(VkBuildMicromapFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkBuildMicromapFlagBitsEXT((VkBuildMicromapFlagBitsEXT) object, settings, indents);
}
void dump_html_VkMicromapCreateFlagsEXT(VkMicromapCreateFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkMicromapCreateFlagBitsEXT((VkMicromapCreateFlagBitsEXT) object, settings, indents);
}
void dump_html_VkMemoryDecompressionMethodFlagsNV(VkMemoryDecompressionMethodFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkMemoryDecompressionMethodFlagBitsNV((VkMemoryDecompressionMethodFlagBitsNV) object, settings, indents);
}
void dump_html_VkOpticalFlowGridSizeFlagsNV(VkOpticalFlowGridSizeFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkOpticalFlowGridSizeFlagBitsNV((VkOpticalFlowGridSizeFlagBitsNV) object, settings, indents);
}
void dump_html_VkOpticalFlowUsageFlagsNV(VkOpticalFlowUsageFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkOpticalFlowUsageFlagBitsNV((VkOpticalFlowUsageFlagBitsNV) object, settings, indents);
}
void dump_html_VkOpticalFlowSessionCreateFlagsNV(VkOpticalFlowSessionCreateFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkOpticalFlowSessionCreateFlagBitsNV((VkOpticalFlowSessionCreateFlagBitsNV) object, settings, indents);
}
void dump_html_VkOpticalFlowExecuteFlagsNV(VkOpticalFlowExecuteFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkOpticalFlowExecuteFlagBitsNV((VkOpticalFlowExecuteFlagBitsNV) object, settings, indents);
}
void dump_html_VkShaderCreateFlagsEXT(VkShaderCreateFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_html_VkShaderCreateFlagBitsEXT((VkShaderCreateFlagBitsEXT) object, settings, indents);
}


void dump_html_VkDeviceCreateFlags(VkDeviceCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkMemoryMapFlags(VkMemoryMapFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkSemaphoreCreateFlags(VkSemaphoreCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkQueryPoolCreateFlags(VkQueryPoolCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkBufferViewCreateFlags(VkBufferViewCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkShaderModuleCreateFlags(VkShaderModuleCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkPipelineVertexInputStateCreateFlags(VkPipelineVertexInputStateCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkPipelineInputAssemblyStateCreateFlags(VkPipelineInputAssemblyStateCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkPipelineTessellationStateCreateFlags(VkPipelineTessellationStateCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkPipelineViewportStateCreateFlags(VkPipelineViewportStateCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkPipelineRasterizationStateCreateFlags(VkPipelineRasterizationStateCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkPipelineMultisampleStateCreateFlags(VkPipelineMultisampleStateCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkPipelineDynamicStateCreateFlags(VkPipelineDynamicStateCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkDescriptorPoolResetFlags(VkDescriptorPoolResetFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkCommandPoolTrimFlags(VkCommandPoolTrimFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkDescriptorUpdateTemplateCreateFlags(VkDescriptorUpdateTemplateCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkPrivateDataSlotCreateFlags(VkPrivateDataSlotCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkDisplayModeCreateFlagsKHR(VkDisplayModeCreateFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkDisplaySurfaceCreateFlagsKHR(VkDisplaySurfaceCreateFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
#if defined(VK_USE_PLATFORM_XLIB_KHR)
void dump_html_VkXlibSurfaceCreateFlagsKHR(VkXlibSurfaceCreateFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
#endif // VK_USE_PLATFORM_XLIB_KHR
#if defined(VK_USE_PLATFORM_XCB_KHR)
void dump_html_VkXcbSurfaceCreateFlagsKHR(VkXcbSurfaceCreateFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
#endif // VK_USE_PLATFORM_XCB_KHR
#if defined(VK_USE_PLATFORM_WAYLAND_KHR)
void dump_html_VkWaylandSurfaceCreateFlagsKHR(VkWaylandSurfaceCreateFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
#endif // VK_USE_PLATFORM_WAYLAND_KHR
#if defined(VK_USE_PLATFORM_ANDROID_KHR)
void dump_html_VkAndroidSurfaceCreateFlagsKHR(VkAndroidSurfaceCreateFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
#endif // VK_USE_PLATFORM_ANDROID_KHR
#if defined(VK_USE_PLATFORM_WIN32_KHR)
void dump_html_VkWin32SurfaceCreateFlagsKHR(VkWin32SurfaceCreateFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
#endif // VK_USE_PLATFORM_WIN32_KHR
void dump_html_VkVideoSessionParametersCreateFlagsKHR(VkVideoSessionParametersCreateFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkVideoBeginCodingFlagsKHR(VkVideoBeginCodingFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkVideoEndCodingFlagsKHR(VkVideoEndCodingFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkVideoDecodeFlagsKHR(VkVideoDecodeFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkPipelineRasterizationStateStreamCreateFlagsEXT(VkPipelineRasterizationStateStreamCreateFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
#if defined(VK_USE_PLATFORM_GGP)
void dump_html_VkStreamDescriptorSurfaceCreateFlagsGGP(VkStreamDescriptorSurfaceCreateFlagsGGP object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
#endif // VK_USE_PLATFORM_GGP
#if defined(VK_USE_PLATFORM_VI_NN)
void dump_html_VkViSurfaceCreateFlagsNN(VkViSurfaceCreateFlagsNN object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
#endif // VK_USE_PLATFORM_VI_NN
void dump_html_VkPipelineViewportSwizzleStateCreateFlagsNV(VkPipelineViewportSwizzleStateCreateFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkPipelineDiscardRectangleStateCreateFlagsEXT(VkPipelineDiscardRectangleStateCreateFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkPipelineRasterizationConservativeStateCreateFlagsEXT(VkPipelineRasterizationConservativeStateCreateFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkPipelineRasterizationDepthClipStateCreateFlagsEXT(VkPipelineRasterizationDepthClipStateCreateFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
#if defined(VK_USE_PLATFORM_IOS_MVK)
void dump_html_VkIOSSurfaceCreateFlagsMVK(VkIOSSurfaceCreateFlagsMVK object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
#endif // VK_USE_PLATFORM_IOS_MVK
#if defined(VK_USE_PLATFORM_MACOS_MVK)
void dump_html_VkMacOSSurfaceCreateFlagsMVK(VkMacOSSurfaceCreateFlagsMVK object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
#endif // VK_USE_PLATFORM_MACOS_MVK
void dump_html_VkDebugUtilsMessengerCallbackDataFlagsEXT(VkDebugUtilsMessengerCallbackDataFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkDebugUtilsMessengerCreateFlagsEXT(VkDebugUtilsMessengerCreateFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkPipelineCoverageToColorStateCreateFlagsNV(VkPipelineCoverageToColorStateCreateFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkPipelineCoverageModulationStateCreateFlagsNV(VkPipelineCoverageModulationStateCreateFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkValidationCacheCreateFlagsEXT(VkValidationCacheCreateFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
#if defined(VK_USE_PLATFORM_FUCHSIA)
void dump_html_VkImagePipeSurfaceCreateFlagsFUCHSIA(VkImagePipeSurfaceCreateFlagsFUCHSIA object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
#endif // VK_USE_PLATFORM_FUCHSIA
#if defined(VK_USE_PLATFORM_METAL_EXT)
void dump_html_VkMetalSurfaceCreateFlagsEXT(VkMetalSurfaceCreateFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
#endif // VK_USE_PLATFORM_METAL_EXT
void dump_html_VkPipelineCoverageReductionStateCreateFlagsNV(VkPipelineCoverageReductionStateCreateFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkHeadlessSurfaceCreateFlagsEXT(VkHeadlessSurfaceCreateFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkMemoryUnmapFlagsKHR(VkMemoryUnmapFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkDeviceMemoryReportFlagsEXT(VkDeviceMemoryReportFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeFlagsKHR(VkVideoEncodeFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
#endif // VK_ENABLE_BETA_EXTENSIONS
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeRateControlFlagsKHR(VkVideoEncodeRateControlFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
#endif // VK_ENABLE_BETA_EXTENSIONS
void dump_html_VkAccelerationStructureMotionInfoFlagsNV(VkAccelerationStructureMotionInfoFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
void dump_html_VkAccelerationStructureMotionInstanceFlagsNV(VkAccelerationStructureMotionInstanceFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
#if defined(VK_USE_PLATFORM_DIRECTFB_EXT)
void dump_html_VkDirectFBSurfaceCreateFlagsEXT(VkDirectFBSurfaceCreateFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#if defined(VK_USE_PLATFORM_FUCHSIA)
void dump_html_VkImageFormatConstraintsFlagsFUCHSIA(VkImageFormatConstraintsFlagsFUCHSIA object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
#endif // VK_USE_PLATFORM_FUCHSIA
#if defined(VK_USE_PLATFORM_SCREEN_QNX)
void dump_html_VkScreenSurfaceCreateFlagsQNX(VkScreenSurfaceCreateFlagsQNX object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}
#endif // VK_USE_PLATFORM_SCREEN_QNX
void dump_html_VkDirectDriverLoadingFlagsLUNARG(VkDirectDriverLoadingFlagsLUNARG object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>"
                             << object << "</div></summary>";
}

//======================= Func Pointer Implementations ======================//

void dump_html_PFN_vkAllocationFunction(PFN_vkAllocationFunction object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << object;
    else
        settings.stream() << "address";
    settings.stream() << "</div></summary>";
}
void dump_html_PFN_vkFreeFunction(PFN_vkFreeFunction object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << object;
    else
        settings.stream() << "address";
    settings.stream() << "</div></summary>";
}
void dump_html_PFN_vkInternalAllocationNotification(PFN_vkInternalAllocationNotification object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << object;
    else
        settings.stream() << "address";
    settings.stream() << "</div></summary>";
}
void dump_html_PFN_vkInternalFreeNotification(PFN_vkInternalFreeNotification object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << object;
    else
        settings.stream() << "address";
    settings.stream() << "</div></summary>";
}
void dump_html_PFN_vkReallocationFunction(PFN_vkReallocationFunction object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << object;
    else
        settings.stream() << "address";
    settings.stream() << "</div></summary>";
}
void dump_html_PFN_vkVoidFunction(PFN_vkVoidFunction object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << object;
    else
        settings.stream() << "address";
    settings.stream() << "</div></summary>";
}
void dump_html_PFN_vkDebugReportCallbackEXT(PFN_vkDebugReportCallbackEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << object;
    else
        settings.stream() << "address";
    settings.stream() << "</div></summary>";
}
void dump_html_PFN_vkDebugUtilsMessengerCallbackEXT(PFN_vkDebugUtilsMessengerCallbackEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << object;
    else
        settings.stream() << "address";
    settings.stream() << "</div></summary>";
}
void dump_html_PFN_vkDeviceMemoryReportCallbackEXT(PFN_vkDeviceMemoryReportCallbackEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << object;
    else
        settings.stream() << "address";
    settings.stream() << "</div></summary>";
}
void dump_html_PFN_vkGetInstanceProcAddrLUNARG(PFN_vkGetInstanceProcAddrLUNARG object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << object;
    else
        settings.stream() << "address";
    settings.stream() << "</div></summary>";
}

//========================== Struct Implementations =========================//

void dump_html_VkExtent2D(const VkExtent2D& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const uint32_t>(object.width, settings, "uint32_t", "width", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.height, settings, "uint32_t", "height", indents + 1, dump_html_uint32_t);
}
void dump_html_VkExtent3D(const VkExtent3D& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const uint32_t>(object.width, settings, "uint32_t", "width", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.height, settings, "uint32_t", "height", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.depth, settings, "uint32_t", "depth", indents + 1, dump_html_uint32_t);
}
void dump_html_VkOffset2D(const VkOffset2D& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const int32_t>(object.x, settings, "int32_t", "x", indents + 1, dump_html_int32_t);
    dump_html_value<const int32_t>(object.y, settings, "int32_t", "y", indents + 1, dump_html_int32_t);
}
void dump_html_VkOffset3D(const VkOffset3D& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const int32_t>(object.x, settings, "int32_t", "x", indents + 1, dump_html_int32_t);
    dump_html_value<const int32_t>(object.y, settings, "int32_t", "y", indents + 1, dump_html_int32_t);
    dump_html_value<const int32_t>(object.z, settings, "int32_t", "z", indents + 1, dump_html_int32_t);
}
void dump_html_VkRect2D(const VkRect2D& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkOffset2D>(object.offset, settings, "VkOffset2D", "offset", indents + 1, dump_html_VkOffset2D);
    dump_html_value<const VkExtent2D>(object.extent, settings, "VkExtent2D", "extent", indents + 1, dump_html_VkExtent2D);
}
void dump_html_VkBaseInStructure(const VkBaseInStructure& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    dump_html_pointer<const VkBaseInStructure>(object.pNext, settings, "const struct VkBaseInStructure*", "pNext", indents + 1, dump_html_VkBaseInStructure);
}
void dump_html_VkBaseOutStructure(const VkBaseOutStructure& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    dump_html_pointer<const VkBaseOutStructure>(object.pNext, settings, "struct VkBaseOutStructure*", "pNext", indents + 1, dump_html_VkBaseOutStructure);
}
void dump_html_VkBufferMemoryBarrier(const VkBufferMemoryBarrier& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkAccessFlags>(object.srcAccessMask, settings, "VkAccessFlags", "srcAccessMask", indents + 1, dump_html_VkAccessFlags);
    dump_html_value<const VkAccessFlags>(object.dstAccessMask, settings, "VkAccessFlags", "dstAccessMask", indents + 1, dump_html_VkAccessFlags);
    dump_html_value<const uint32_t>(object.srcQueueFamilyIndex, settings, "uint32_t", "srcQueueFamilyIndex", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.dstQueueFamilyIndex, settings, "uint32_t", "dstQueueFamilyIndex", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkBuffer>(object.buffer, settings, "VkBuffer", "buffer", indents + 1, dump_html_VkBuffer);
    dump_html_value<const VkDeviceSize>(object.offset, settings, "VkDeviceSize", "offset", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceSize>(object.size, settings, "VkDeviceSize", "size", indents + 1, dump_html_VkDeviceSize);
}
void dump_html_VkDispatchIndirectCommand(const VkDispatchIndirectCommand& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const uint32_t>(object.x, settings, "uint32_t", "x", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.y, settings, "uint32_t", "y", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.z, settings, "uint32_t", "z", indents + 1, dump_html_uint32_t);
}
void dump_html_VkDrawIndexedIndirectCommand(const VkDrawIndexedIndirectCommand& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const uint32_t>(object.indexCount, settings, "uint32_t", "indexCount", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.instanceCount, settings, "uint32_t", "instanceCount", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.firstIndex, settings, "uint32_t", "firstIndex", indents + 1, dump_html_uint32_t);
    dump_html_value<const int32_t>(object.vertexOffset, settings, "int32_t", "vertexOffset", indents + 1, dump_html_int32_t);
    dump_html_value<const uint32_t>(object.firstInstance, settings, "uint32_t", "firstInstance", indents + 1, dump_html_uint32_t);
}
void dump_html_VkDrawIndirectCommand(const VkDrawIndirectCommand& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const uint32_t>(object.vertexCount, settings, "uint32_t", "vertexCount", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.instanceCount, settings, "uint32_t", "instanceCount", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.firstVertex, settings, "uint32_t", "firstVertex", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.firstInstance, settings, "uint32_t", "firstInstance", indents + 1, dump_html_uint32_t);
}
void dump_html_VkImageSubresourceRange(const VkImageSubresourceRange& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkImageAspectFlags>(object.aspectMask, settings, "VkImageAspectFlags", "aspectMask", indents + 1, dump_html_VkImageAspectFlags);
    dump_html_value<const uint32_t>(object.baseMipLevel, settings, "uint32_t", "baseMipLevel", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.levelCount, settings, "uint32_t", "levelCount", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.baseArrayLayer, settings, "uint32_t", "baseArrayLayer", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.layerCount, settings, "uint32_t", "layerCount", indents + 1, dump_html_uint32_t);
}
void dump_html_VkImageMemoryBarrier(const VkImageMemoryBarrier& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkAccessFlags>(object.srcAccessMask, settings, "VkAccessFlags", "srcAccessMask", indents + 1, dump_html_VkAccessFlags);
    dump_html_value<const VkAccessFlags>(object.dstAccessMask, settings, "VkAccessFlags", "dstAccessMask", indents + 1, dump_html_VkAccessFlags);
    dump_html_value<const VkImageLayout>(object.oldLayout, settings, "VkImageLayout", "oldLayout", indents + 1, dump_html_VkImageLayout);
    dump_html_value<const VkImageLayout>(object.newLayout, settings, "VkImageLayout", "newLayout", indents + 1, dump_html_VkImageLayout);
    dump_html_value<const uint32_t>(object.srcQueueFamilyIndex, settings, "uint32_t", "srcQueueFamilyIndex", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.dstQueueFamilyIndex, settings, "uint32_t", "dstQueueFamilyIndex", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkImage>(object.image, settings, "VkImage", "image", indents + 1, dump_html_VkImage);
    dump_html_value<const VkImageSubresourceRange>(object.subresourceRange, settings, "VkImageSubresourceRange", "subresourceRange", indents + 1, dump_html_VkImageSubresourceRange);
}
void dump_html_VkMemoryBarrier(const VkMemoryBarrier& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkAccessFlags>(object.srcAccessMask, settings, "VkAccessFlags", "srcAccessMask", indents + 1, dump_html_VkAccessFlags);
    dump_html_value<const VkAccessFlags>(object.dstAccessMask, settings, "VkAccessFlags", "dstAccessMask", indents + 1, dump_html_VkAccessFlags);
}
void dump_html_VkPipelineCacheHeaderVersionOne(const VkPipelineCacheHeaderVersionOne& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const uint32_t>(object.headerSize, settings, "uint32_t", "headerSize", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkPipelineCacheHeaderVersion>(object.headerVersion, settings, "VkPipelineCacheHeaderVersion", "headerVersion", indents + 1, dump_html_VkPipelineCacheHeaderVersion);
    dump_html_value<const uint32_t>(object.vendorID, settings, "uint32_t", "vendorID", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.deviceID, settings, "uint32_t", "deviceID", indents + 1, dump_html_uint32_t);
    dump_html_array<const uint8_t>(object.pipelineCacheUUID, 16, settings, "uint8_t[VK_UUID_SIZE]", "uint8_t", "pipelineCacheUUID", indents + 1, dump_html_uint8_t); // ZRR
}
void dump_html_VkAllocationCallbacks(const VkAllocationCallbacks& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const void*>(object.pUserData, settings, "void*", "pUserData", indents + 1, dump_html_void);
    dump_html_value<const PFN_vkAllocationFunction>(object.pfnAllocation, settings, "PFN_vkAllocationFunction", "pfnAllocation", indents + 1, dump_html_PFN_vkAllocationFunction);
    dump_html_value<const PFN_vkReallocationFunction>(object.pfnReallocation, settings, "PFN_vkReallocationFunction", "pfnReallocation", indents + 1, dump_html_PFN_vkReallocationFunction);
    dump_html_value<const PFN_vkFreeFunction>(object.pfnFree, settings, "PFN_vkFreeFunction", "pfnFree", indents + 1, dump_html_PFN_vkFreeFunction);
    dump_html_value<const PFN_vkInternalAllocationNotification>(object.pfnInternalAllocation, settings, "PFN_vkInternalAllocationNotification", "pfnInternalAllocation", indents + 1, dump_html_PFN_vkInternalAllocationNotification);
    dump_html_value<const PFN_vkInternalFreeNotification>(object.pfnInternalFree, settings, "PFN_vkInternalFreeNotification", "pfnInternalFree", indents + 1, dump_html_PFN_vkInternalFreeNotification);
}
void dump_html_VkApplicationInfo(const VkApplicationInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const char*>(object.pApplicationName, settings, "const char*", "pApplicationName", indents + 1, dump_html_cstring);
    dump_html_value<const uint32_t>(object.applicationVersion, settings, "uint32_t", "applicationVersion", indents + 1, dump_html_uint32_t);
    dump_html_value<const char*>(object.pEngineName, settings, "const char*", "pEngineName", indents + 1, dump_html_cstring);
    dump_html_value<const uint32_t>(object.engineVersion, settings, "uint32_t", "engineVersion", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.apiVersion, settings, "uint32_t", "apiVersion", indents + 1, dump_html_uint32_t);
}
void dump_html_VkFormatProperties(const VkFormatProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkFormatFeatureFlags>(object.linearTilingFeatures, settings, "VkFormatFeatureFlags", "linearTilingFeatures", indents + 1, dump_html_VkFormatFeatureFlags);
    dump_html_value<const VkFormatFeatureFlags>(object.optimalTilingFeatures, settings, "VkFormatFeatureFlags", "optimalTilingFeatures", indents + 1, dump_html_VkFormatFeatureFlags);
    dump_html_value<const VkFormatFeatureFlags>(object.bufferFeatures, settings, "VkFormatFeatureFlags", "bufferFeatures", indents + 1, dump_html_VkFormatFeatureFlags);
}
void dump_html_VkImageFormatProperties(const VkImageFormatProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkExtent3D>(object.maxExtent, settings, "VkExtent3D", "maxExtent", indents + 1, dump_html_VkExtent3D);
    dump_html_value<const uint32_t>(object.maxMipLevels, settings, "uint32_t", "maxMipLevels", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxArrayLayers, settings, "uint32_t", "maxArrayLayers", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkSampleCountFlags>(object.sampleCounts, settings, "VkSampleCountFlags", "sampleCounts", indents + 1, dump_html_VkSampleCountFlags);
    dump_html_value<const VkDeviceSize>(object.maxResourceSize, settings, "VkDeviceSize", "maxResourceSize", indents + 1, dump_html_VkDeviceSize);
}
void dump_html_VkInstanceCreateInfo(const VkInstanceCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkInstanceCreateFlags>(object.flags, settings, "VkInstanceCreateFlags", "flags", indents + 1, dump_html_VkInstanceCreateFlags);
    dump_html_pointer<const VkApplicationInfo>(object.pApplicationInfo, settings, "const VkApplicationInfo*", "pApplicationInfo", indents + 1, dump_html_VkApplicationInfo);
    dump_html_value<const uint32_t>(object.enabledLayerCount, settings, "uint32_t", "enabledLayerCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const char*>(object.ppEnabledLayerNames, object.enabledLayerCount, settings, "const char* const*", "const char* const", "ppEnabledLayerNames", indents + 1, dump_html_cstring); // ZRT
    dump_html_value<const uint32_t>(object.enabledExtensionCount, settings, "uint32_t", "enabledExtensionCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const char*>(object.ppEnabledExtensionNames, object.enabledExtensionCount, settings, "const char* const*", "const char* const", "ppEnabledExtensionNames", indents + 1, dump_html_cstring); // ZRT
}
void dump_html_VkMemoryHeap(const VkMemoryHeap& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkDeviceSize>(object.size, settings, "VkDeviceSize", "size", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkMemoryHeapFlags>(object.flags, settings, "VkMemoryHeapFlags", "flags", indents + 1, dump_html_VkMemoryHeapFlags);
}
void dump_html_VkMemoryType(const VkMemoryType& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkMemoryPropertyFlags>(object.propertyFlags, settings, "VkMemoryPropertyFlags", "propertyFlags", indents + 1, dump_html_VkMemoryPropertyFlags);
    dump_html_value<const uint32_t>(object.heapIndex, settings, "uint32_t", "heapIndex", indents + 1, dump_html_uint32_t);
}
void dump_html_VkPhysicalDeviceFeatures(const VkPhysicalDeviceFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkBool32>(object.robustBufferAccess, settings, "VkBool32", "robustBufferAccess", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.fullDrawIndexUint32, settings, "VkBool32", "fullDrawIndexUint32", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.imageCubeArray, settings, "VkBool32", "imageCubeArray", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.independentBlend, settings, "VkBool32", "independentBlend", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.geometryShader, settings, "VkBool32", "geometryShader", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.tessellationShader, settings, "VkBool32", "tessellationShader", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.sampleRateShading, settings, "VkBool32", "sampleRateShading", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.dualSrcBlend, settings, "VkBool32", "dualSrcBlend", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.logicOp, settings, "VkBool32", "logicOp", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.multiDrawIndirect, settings, "VkBool32", "multiDrawIndirect", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.drawIndirectFirstInstance, settings, "VkBool32", "drawIndirectFirstInstance", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.depthClamp, settings, "VkBool32", "depthClamp", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.depthBiasClamp, settings, "VkBool32", "depthBiasClamp", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.fillModeNonSolid, settings, "VkBool32", "fillModeNonSolid", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.depthBounds, settings, "VkBool32", "depthBounds", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.wideLines, settings, "VkBool32", "wideLines", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.largePoints, settings, "VkBool32", "largePoints", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.alphaToOne, settings, "VkBool32", "alphaToOne", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.multiViewport, settings, "VkBool32", "multiViewport", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.samplerAnisotropy, settings, "VkBool32", "samplerAnisotropy", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.textureCompressionETC2, settings, "VkBool32", "textureCompressionETC2", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.textureCompressionASTC_LDR, settings, "VkBool32", "textureCompressionASTC_LDR", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.textureCompressionBC, settings, "VkBool32", "textureCompressionBC", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.occlusionQueryPrecise, settings, "VkBool32", "occlusionQueryPrecise", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.pipelineStatisticsQuery, settings, "VkBool32", "pipelineStatisticsQuery", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.vertexPipelineStoresAndAtomics, settings, "VkBool32", "vertexPipelineStoresAndAtomics", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.fragmentStoresAndAtomics, settings, "VkBool32", "fragmentStoresAndAtomics", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderTessellationAndGeometryPointSize, settings, "VkBool32", "shaderTessellationAndGeometryPointSize", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderImageGatherExtended, settings, "VkBool32", "shaderImageGatherExtended", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderStorageImageExtendedFormats, settings, "VkBool32", "shaderStorageImageExtendedFormats", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderStorageImageMultisample, settings, "VkBool32", "shaderStorageImageMultisample", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderStorageImageReadWithoutFormat, settings, "VkBool32", "shaderStorageImageReadWithoutFormat", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderStorageImageWriteWithoutFormat, settings, "VkBool32", "shaderStorageImageWriteWithoutFormat", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderUniformBufferArrayDynamicIndexing, settings, "VkBool32", "shaderUniformBufferArrayDynamicIndexing", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderSampledImageArrayDynamicIndexing, settings, "VkBool32", "shaderSampledImageArrayDynamicIndexing", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderStorageBufferArrayDynamicIndexing, settings, "VkBool32", "shaderStorageBufferArrayDynamicIndexing", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderStorageImageArrayDynamicIndexing, settings, "VkBool32", "shaderStorageImageArrayDynamicIndexing", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderClipDistance, settings, "VkBool32", "shaderClipDistance", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderCullDistance, settings, "VkBool32", "shaderCullDistance", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderFloat64, settings, "VkBool32", "shaderFloat64", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderInt64, settings, "VkBool32", "shaderInt64", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderInt16, settings, "VkBool32", "shaderInt16", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderResourceResidency, settings, "VkBool32", "shaderResourceResidency", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderResourceMinLod, settings, "VkBool32", "shaderResourceMinLod", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.sparseBinding, settings, "VkBool32", "sparseBinding", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.sparseResidencyBuffer, settings, "VkBool32", "sparseResidencyBuffer", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.sparseResidencyImage2D, settings, "VkBool32", "sparseResidencyImage2D", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.sparseResidencyImage3D, settings, "VkBool32", "sparseResidencyImage3D", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.sparseResidency2Samples, settings, "VkBool32", "sparseResidency2Samples", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.sparseResidency4Samples, settings, "VkBool32", "sparseResidency4Samples", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.sparseResidency8Samples, settings, "VkBool32", "sparseResidency8Samples", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.sparseResidency16Samples, settings, "VkBool32", "sparseResidency16Samples", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.sparseResidencyAliased, settings, "VkBool32", "sparseResidencyAliased", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.variableMultisampleRate, settings, "VkBool32", "variableMultisampleRate", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.inheritedQueries, settings, "VkBool32", "inheritedQueries", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceLimits(const VkPhysicalDeviceLimits& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const uint32_t>(object.maxImageDimension1D, settings, "uint32_t", "maxImageDimension1D", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxImageDimension2D, settings, "uint32_t", "maxImageDimension2D", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxImageDimension3D, settings, "uint32_t", "maxImageDimension3D", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxImageDimensionCube, settings, "uint32_t", "maxImageDimensionCube", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxImageArrayLayers, settings, "uint32_t", "maxImageArrayLayers", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxTexelBufferElements, settings, "uint32_t", "maxTexelBufferElements", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxUniformBufferRange, settings, "uint32_t", "maxUniformBufferRange", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxStorageBufferRange, settings, "uint32_t", "maxStorageBufferRange", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxPushConstantsSize, settings, "uint32_t", "maxPushConstantsSize", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxMemoryAllocationCount, settings, "uint32_t", "maxMemoryAllocationCount", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxSamplerAllocationCount, settings, "uint32_t", "maxSamplerAllocationCount", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkDeviceSize>(object.bufferImageGranularity, settings, "VkDeviceSize", "bufferImageGranularity", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceSize>(object.sparseAddressSpaceSize, settings, "VkDeviceSize", "sparseAddressSpaceSize", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const uint32_t>(object.maxBoundDescriptorSets, settings, "uint32_t", "maxBoundDescriptorSets", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxPerStageDescriptorSamplers, settings, "uint32_t", "maxPerStageDescriptorSamplers", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxPerStageDescriptorUniformBuffers, settings, "uint32_t", "maxPerStageDescriptorUniformBuffers", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxPerStageDescriptorStorageBuffers, settings, "uint32_t", "maxPerStageDescriptorStorageBuffers", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxPerStageDescriptorSampledImages, settings, "uint32_t", "maxPerStageDescriptorSampledImages", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxPerStageDescriptorStorageImages, settings, "uint32_t", "maxPerStageDescriptorStorageImages", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxPerStageDescriptorInputAttachments, settings, "uint32_t", "maxPerStageDescriptorInputAttachments", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxPerStageResources, settings, "uint32_t", "maxPerStageResources", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetSamplers, settings, "uint32_t", "maxDescriptorSetSamplers", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetUniformBuffers, settings, "uint32_t", "maxDescriptorSetUniformBuffers", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetUniformBuffersDynamic, settings, "uint32_t", "maxDescriptorSetUniformBuffersDynamic", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetStorageBuffers, settings, "uint32_t", "maxDescriptorSetStorageBuffers", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetStorageBuffersDynamic, settings, "uint32_t", "maxDescriptorSetStorageBuffersDynamic", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetSampledImages, settings, "uint32_t", "maxDescriptorSetSampledImages", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetStorageImages, settings, "uint32_t", "maxDescriptorSetStorageImages", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetInputAttachments, settings, "uint32_t", "maxDescriptorSetInputAttachments", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxVertexInputAttributes, settings, "uint32_t", "maxVertexInputAttributes", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxVertexInputBindings, settings, "uint32_t", "maxVertexInputBindings", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxVertexInputAttributeOffset, settings, "uint32_t", "maxVertexInputAttributeOffset", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxVertexInputBindingStride, settings, "uint32_t", "maxVertexInputBindingStride", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxVertexOutputComponents, settings, "uint32_t", "maxVertexOutputComponents", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxTessellationGenerationLevel, settings, "uint32_t", "maxTessellationGenerationLevel", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxTessellationPatchSize, settings, "uint32_t", "maxTessellationPatchSize", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxTessellationControlPerVertexInputComponents, settings, "uint32_t", "maxTessellationControlPerVertexInputComponents", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxTessellationControlPerVertexOutputComponents, settings, "uint32_t", "maxTessellationControlPerVertexOutputComponents", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxTessellationControlPerPatchOutputComponents, settings, "uint32_t", "maxTessellationControlPerPatchOutputComponents", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxTessellationControlTotalOutputComponents, settings, "uint32_t", "maxTessellationControlTotalOutputComponents", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxTessellationEvaluationInputComponents, settings, "uint32_t", "maxTessellationEvaluationInputComponents", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxTessellationEvaluationOutputComponents, settings, "uint32_t", "maxTessellationEvaluationOutputComponents", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxGeometryShaderInvocations, settings, "uint32_t", "maxGeometryShaderInvocations", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxGeometryInputComponents, settings, "uint32_t", "maxGeometryInputComponents", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxGeometryOutputComponents, settings, "uint32_t", "maxGeometryOutputComponents", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxGeometryOutputVertices, settings, "uint32_t", "maxGeometryOutputVertices", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxGeometryTotalOutputComponents, settings, "uint32_t", "maxGeometryTotalOutputComponents", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxFragmentInputComponents, settings, "uint32_t", "maxFragmentInputComponents", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxFragmentOutputAttachments, settings, "uint32_t", "maxFragmentOutputAttachments", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxFragmentDualSrcAttachments, settings, "uint32_t", "maxFragmentDualSrcAttachments", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxFragmentCombinedOutputResources, settings, "uint32_t", "maxFragmentCombinedOutputResources", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxComputeSharedMemorySize, settings, "uint32_t", "maxComputeSharedMemorySize", indents + 1, dump_html_uint32_t);
    dump_html_array<const uint32_t>(object.maxComputeWorkGroupCount, 3, settings, "uint32_t[3]", "uint32_t", "maxComputeWorkGroupCount", indents + 1, dump_html_uint32_t); // ZRR
    dump_html_value<const uint32_t>(object.maxComputeWorkGroupInvocations, settings, "uint32_t", "maxComputeWorkGroupInvocations", indents + 1, dump_html_uint32_t);
    dump_html_array<const uint32_t>(object.maxComputeWorkGroupSize, 3, settings, "uint32_t[3]", "uint32_t", "maxComputeWorkGroupSize", indents + 1, dump_html_uint32_t); // ZRR
    dump_html_value<const uint32_t>(object.subPixelPrecisionBits, settings, "uint32_t", "subPixelPrecisionBits", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.subTexelPrecisionBits, settings, "uint32_t", "subTexelPrecisionBits", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.mipmapPrecisionBits, settings, "uint32_t", "mipmapPrecisionBits", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDrawIndexedIndexValue, settings, "uint32_t", "maxDrawIndexedIndexValue", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDrawIndirectCount, settings, "uint32_t", "maxDrawIndirectCount", indents + 1, dump_html_uint32_t);
    dump_html_value<const float>(object.maxSamplerLodBias, settings, "float", "maxSamplerLodBias", indents + 1, dump_html_float);
    dump_html_value<const float>(object.maxSamplerAnisotropy, settings, "float", "maxSamplerAnisotropy", indents + 1, dump_html_float);
    dump_html_value<const uint32_t>(object.maxViewports, settings, "uint32_t", "maxViewports", indents + 1, dump_html_uint32_t);
    dump_html_array<const uint32_t>(object.maxViewportDimensions, 2, settings, "uint32_t[2]", "uint32_t", "maxViewportDimensions", indents + 1, dump_html_uint32_t); // ZRR
    dump_html_array<const float>(object.viewportBoundsRange, 2, settings, "float[2]", "float", "viewportBoundsRange", indents + 1, dump_html_float); // ZRR
    dump_html_value<const uint32_t>(object.viewportSubPixelBits, settings, "uint32_t", "viewportSubPixelBits", indents + 1, dump_html_uint32_t);
    dump_html_value<const size_t>(object.minMemoryMapAlignment, settings, "size_t", "minMemoryMapAlignment", indents + 1, dump_html_size_t);
    dump_html_value<const VkDeviceSize>(object.minTexelBufferOffsetAlignment, settings, "VkDeviceSize", "minTexelBufferOffsetAlignment", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceSize>(object.minUniformBufferOffsetAlignment, settings, "VkDeviceSize", "minUniformBufferOffsetAlignment", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceSize>(object.minStorageBufferOffsetAlignment, settings, "VkDeviceSize", "minStorageBufferOffsetAlignment", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const int32_t>(object.minTexelOffset, settings, "int32_t", "minTexelOffset", indents + 1, dump_html_int32_t);
    dump_html_value<const uint32_t>(object.maxTexelOffset, settings, "uint32_t", "maxTexelOffset", indents + 1, dump_html_uint32_t);
    dump_html_value<const int32_t>(object.minTexelGatherOffset, settings, "int32_t", "minTexelGatherOffset", indents + 1, dump_html_int32_t);
    dump_html_value<const uint32_t>(object.maxTexelGatherOffset, settings, "uint32_t", "maxTexelGatherOffset", indents + 1, dump_html_uint32_t);
    dump_html_value<const float>(object.minInterpolationOffset, settings, "float", "minInterpolationOffset", indents + 1, dump_html_float);
    dump_html_value<const float>(object.maxInterpolationOffset, settings, "float", "maxInterpolationOffset", indents + 1, dump_html_float);
    dump_html_value<const uint32_t>(object.subPixelInterpolationOffsetBits, settings, "uint32_t", "subPixelInterpolationOffsetBits", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxFramebufferWidth, settings, "uint32_t", "maxFramebufferWidth", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxFramebufferHeight, settings, "uint32_t", "maxFramebufferHeight", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxFramebufferLayers, settings, "uint32_t", "maxFramebufferLayers", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkSampleCountFlags>(object.framebufferColorSampleCounts, settings, "VkSampleCountFlags", "framebufferColorSampleCounts", indents + 1, dump_html_VkSampleCountFlags);
    dump_html_value<const VkSampleCountFlags>(object.framebufferDepthSampleCounts, settings, "VkSampleCountFlags", "framebufferDepthSampleCounts", indents + 1, dump_html_VkSampleCountFlags);
    dump_html_value<const VkSampleCountFlags>(object.framebufferStencilSampleCounts, settings, "VkSampleCountFlags", "framebufferStencilSampleCounts", indents + 1, dump_html_VkSampleCountFlags);
    dump_html_value<const VkSampleCountFlags>(object.framebufferNoAttachmentsSampleCounts, settings, "VkSampleCountFlags", "framebufferNoAttachmentsSampleCounts", indents + 1, dump_html_VkSampleCountFlags);
    dump_html_value<const uint32_t>(object.maxColorAttachments, settings, "uint32_t", "maxColorAttachments", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkSampleCountFlags>(object.sampledImageColorSampleCounts, settings, "VkSampleCountFlags", "sampledImageColorSampleCounts", indents + 1, dump_html_VkSampleCountFlags);
    dump_html_value<const VkSampleCountFlags>(object.sampledImageIntegerSampleCounts, settings, "VkSampleCountFlags", "sampledImageIntegerSampleCounts", indents + 1, dump_html_VkSampleCountFlags);
    dump_html_value<const VkSampleCountFlags>(object.sampledImageDepthSampleCounts, settings, "VkSampleCountFlags", "sampledImageDepthSampleCounts", indents + 1, dump_html_VkSampleCountFlags);
    dump_html_value<const VkSampleCountFlags>(object.sampledImageStencilSampleCounts, settings, "VkSampleCountFlags", "sampledImageStencilSampleCounts", indents + 1, dump_html_VkSampleCountFlags);
    dump_html_value<const VkSampleCountFlags>(object.storageImageSampleCounts, settings, "VkSampleCountFlags", "storageImageSampleCounts", indents + 1, dump_html_VkSampleCountFlags);
    dump_html_value<const uint32_t>(object.maxSampleMaskWords, settings, "uint32_t", "maxSampleMaskWords", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkBool32>(object.timestampComputeAndGraphics, settings, "VkBool32", "timestampComputeAndGraphics", indents + 1, dump_html_VkBool32);
    dump_html_value<const float>(object.timestampPeriod, settings, "float", "timestampPeriod", indents + 1, dump_html_float);
    dump_html_value<const uint32_t>(object.maxClipDistances, settings, "uint32_t", "maxClipDistances", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxCullDistances, settings, "uint32_t", "maxCullDistances", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxCombinedClipAndCullDistances, settings, "uint32_t", "maxCombinedClipAndCullDistances", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.discreteQueuePriorities, settings, "uint32_t", "discreteQueuePriorities", indents + 1, dump_html_uint32_t);
    dump_html_array<const float>(object.pointSizeRange, 2, settings, "float[2]", "float", "pointSizeRange", indents + 1, dump_html_float); // ZRR
    dump_html_array<const float>(object.lineWidthRange, 2, settings, "float[2]", "float", "lineWidthRange", indents + 1, dump_html_float); // ZRR
    dump_html_value<const float>(object.pointSizeGranularity, settings, "float", "pointSizeGranularity", indents + 1, dump_html_float);
    dump_html_value<const float>(object.lineWidthGranularity, settings, "float", "lineWidthGranularity", indents + 1, dump_html_float);
    dump_html_value<const VkBool32>(object.strictLines, settings, "VkBool32", "strictLines", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.standardSampleLocations, settings, "VkBool32", "standardSampleLocations", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkDeviceSize>(object.optimalBufferCopyOffsetAlignment, settings, "VkDeviceSize", "optimalBufferCopyOffsetAlignment", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceSize>(object.optimalBufferCopyRowPitchAlignment, settings, "VkDeviceSize", "optimalBufferCopyRowPitchAlignment", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceSize>(object.nonCoherentAtomSize, settings, "VkDeviceSize", "nonCoherentAtomSize", indents + 1, dump_html_VkDeviceSize);
}
void dump_html_VkPhysicalDeviceMemoryProperties(const VkPhysicalDeviceMemoryProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const uint32_t>(object.memoryTypeCount, settings, "uint32_t", "memoryTypeCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkMemoryType>(object.memoryTypes, object.memoryTypeCount, settings, "VkMemoryType[VK_MAX_MEMORY_TYPES]", "VkMemoryType", "memoryTypes", indents + 1, dump_html_VkMemoryType); // ZRT
    dump_html_value<const uint32_t>(object.memoryHeapCount, settings, "uint32_t", "memoryHeapCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkMemoryHeap>(object.memoryHeaps, object.memoryHeapCount, settings, "VkMemoryHeap[VK_MAX_MEMORY_HEAPS]", "VkMemoryHeap", "memoryHeaps", indents + 1, dump_html_VkMemoryHeap); // ZRT
}
void dump_html_VkPhysicalDeviceSparseProperties(const VkPhysicalDeviceSparseProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkBool32>(object.residencyStandard2DBlockShape, settings, "VkBool32", "residencyStandard2DBlockShape", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.residencyStandard2DMultisampleBlockShape, settings, "VkBool32", "residencyStandard2DMultisampleBlockShape", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.residencyStandard3DBlockShape, settings, "VkBool32", "residencyStandard3DBlockShape", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.residencyAlignedMipSize, settings, "VkBool32", "residencyAlignedMipSize", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.residencyNonResidentStrict, settings, "VkBool32", "residencyNonResidentStrict", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceProperties(const VkPhysicalDeviceProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const uint32_t>(object.apiVersion, settings, "uint32_t", "apiVersion", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.driverVersion, settings, "uint32_t", "driverVersion", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.vendorID, settings, "uint32_t", "vendorID", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.deviceID, settings, "uint32_t", "deviceID", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkPhysicalDeviceType>(object.deviceType, settings, "VkPhysicalDeviceType", "deviceType", indents + 1, dump_html_VkPhysicalDeviceType);
    dump_html_value<const char*>(object.deviceName, settings, "char[VK_MAX_PHYSICAL_DEVICE_NAME_SIZE]", "deviceName", indents + 1, dump_html_cstring);
    dump_html_array<const uint8_t>(object.pipelineCacheUUID, 16, settings, "uint8_t[VK_UUID_SIZE]", "uint8_t", "pipelineCacheUUID", indents + 1, dump_html_uint8_t); // ZRR
    dump_html_value<const VkPhysicalDeviceLimits>(object.limits, settings, "VkPhysicalDeviceLimits", "limits", indents + 1, dump_html_VkPhysicalDeviceLimits);
    dump_html_value<const VkPhysicalDeviceSparseProperties>(object.sparseProperties, settings, "VkPhysicalDeviceSparseProperties", "sparseProperties", indents + 1, dump_html_VkPhysicalDeviceSparseProperties);
}
void dump_html_VkQueueFamilyProperties(const VkQueueFamilyProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkQueueFlags>(object.queueFlags, settings, "VkQueueFlags", "queueFlags", indents + 1, dump_html_VkQueueFlags);
    dump_html_value<const uint32_t>(object.queueCount, settings, "uint32_t", "queueCount", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.timestampValidBits, settings, "uint32_t", "timestampValidBits", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkExtent3D>(object.minImageTransferGranularity, settings, "VkExtent3D", "minImageTransferGranularity", indents + 1, dump_html_VkExtent3D);
}
void dump_html_VkDeviceQueueCreateInfo(const VkDeviceQueueCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDeviceQueueCreateFlags>(object.flags, settings, "VkDeviceQueueCreateFlags", "flags", indents + 1, dump_html_VkDeviceQueueCreateFlags);
    dump_html_value<const uint32_t>(object.queueFamilyIndex, settings, "uint32_t", "queueFamilyIndex", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.queueCount, settings, "uint32_t", "queueCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const float>(object.pQueuePriorities, object.queueCount, settings, "const float*", "const float", "pQueuePriorities", indents + 1, dump_html_float); // ZRT
}
void dump_html_VkDeviceCreateInfo(const VkDeviceCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDeviceCreateFlags>(object.flags, settings, "VkDeviceCreateFlags", "flags", indents + 1, dump_html_VkDeviceCreateFlags);
    dump_html_value<const uint32_t>(object.queueCreateInfoCount, settings, "uint32_t", "queueCreateInfoCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkDeviceQueueCreateInfo>(object.pQueueCreateInfos, object.queueCreateInfoCount, settings, "const VkDeviceQueueCreateInfo*", "const VkDeviceQueueCreateInfo", "pQueueCreateInfos", indents + 1, dump_html_VkDeviceQueueCreateInfo); // ZRT
    dump_html_value<const uint32_t>(object.enabledLayerCount, settings, "uint32_t", "enabledLayerCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const char*>(object.ppEnabledLayerNames, object.enabledLayerCount, settings, "const char* const*", "const char* const", "ppEnabledLayerNames", indents + 1, dump_html_cstring); // ZRT
    dump_html_value<const uint32_t>(object.enabledExtensionCount, settings, "uint32_t", "enabledExtensionCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const char*>(object.ppEnabledExtensionNames, object.enabledExtensionCount, settings, "const char* const*", "const char* const", "ppEnabledExtensionNames", indents + 1, dump_html_cstring); // ZRT
    dump_html_pointer<const VkPhysicalDeviceFeatures>(object.pEnabledFeatures, settings, "const VkPhysicalDeviceFeatures*", "pEnabledFeatures", indents + 1, dump_html_VkPhysicalDeviceFeatures);
}
void dump_html_VkExtensionProperties(const VkExtensionProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const char*>(object.extensionName, settings, "char[VK_MAX_EXTENSION_NAME_SIZE]", "extensionName", indents + 1, dump_html_cstring);
    dump_html_value<const uint32_t>(object.specVersion, settings, "uint32_t", "specVersion", indents + 1, dump_html_uint32_t);
}
void dump_html_VkLayerProperties(const VkLayerProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const char*>(object.layerName, settings, "char[VK_MAX_EXTENSION_NAME_SIZE]", "layerName", indents + 1, dump_html_cstring);
    dump_html_value<const uint32_t>(object.specVersion, settings, "uint32_t", "specVersion", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.implementationVersion, settings, "uint32_t", "implementationVersion", indents + 1, dump_html_uint32_t);
    dump_html_value<const char*>(object.description, settings, "char[VK_MAX_DESCRIPTION_SIZE]", "description", indents + 1, dump_html_cstring);
}
void dump_html_VkSubmitInfo(const VkSubmitInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.waitSemaphoreCount, settings, "uint32_t", "waitSemaphoreCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkSemaphore>(object.pWaitSemaphores, object.waitSemaphoreCount, settings, "const VkSemaphore*", "const VkSemaphore", "pWaitSemaphores", indents + 1, dump_html_VkSemaphore); // ZRT
    dump_html_array<const VkPipelineStageFlags>(object.pWaitDstStageMask, object.waitSemaphoreCount, settings, "const VkPipelineStageFlags*", "const VkPipelineStageFlags", "pWaitDstStageMask", indents + 1, dump_html_VkPipelineStageFlags); // ZRT
    dump_html_value<const uint32_t>(object.commandBufferCount, settings, "uint32_t", "commandBufferCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkCommandBuffer>(object.pCommandBuffers, object.commandBufferCount, settings, "const VkCommandBuffer*", "const VkCommandBuffer", "pCommandBuffers", indents + 1, dump_html_VkCommandBuffer); // ZRT
    dump_html_value<const uint32_t>(object.signalSemaphoreCount, settings, "uint32_t", "signalSemaphoreCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkSemaphore>(object.pSignalSemaphores, object.signalSemaphoreCount, settings, "const VkSemaphore*", "const VkSemaphore", "pSignalSemaphores", indents + 1, dump_html_VkSemaphore); // ZRT
}
void dump_html_VkMappedMemoryRange(const VkMappedMemoryRange& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDeviceMemory>(object.memory, settings, "VkDeviceMemory", "memory", indents + 1, dump_html_VkDeviceMemory);
    dump_html_value<const VkDeviceSize>(object.offset, settings, "VkDeviceSize", "offset", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceSize>(object.size, settings, "VkDeviceSize", "size", indents + 1, dump_html_VkDeviceSize);
}
void dump_html_VkMemoryAllocateInfo(const VkMemoryAllocateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDeviceSize>(object.allocationSize, settings, "VkDeviceSize", "allocationSize", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const uint32_t>(object.memoryTypeIndex, settings, "uint32_t", "memoryTypeIndex", indents + 1, dump_html_uint32_t);
}
void dump_html_VkMemoryRequirements(const VkMemoryRequirements& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkDeviceSize>(object.size, settings, "VkDeviceSize", "size", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceSize>(object.alignment, settings, "VkDeviceSize", "alignment", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const uint32_t>(object.memoryTypeBits, settings, "uint32_t", "memoryTypeBits", indents + 1, dump_html_uint32_t);
}
void dump_html_VkSparseMemoryBind(const VkSparseMemoryBind& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkDeviceSize>(object.resourceOffset, settings, "VkDeviceSize", "resourceOffset", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceSize>(object.size, settings, "VkDeviceSize", "size", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceMemory>(object.memory, settings, "VkDeviceMemory", "memory", indents + 1, dump_html_VkDeviceMemory);
    dump_html_value<const VkDeviceSize>(object.memoryOffset, settings, "VkDeviceSize", "memoryOffset", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkSparseMemoryBindFlags>(object.flags, settings, "VkSparseMemoryBindFlags", "flags", indents + 1, dump_html_VkSparseMemoryBindFlags);
}
void dump_html_VkSparseBufferMemoryBindInfo(const VkSparseBufferMemoryBindInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkBuffer>(object.buffer, settings, "VkBuffer", "buffer", indents + 1, dump_html_VkBuffer);
    dump_html_value<const uint32_t>(object.bindCount, settings, "uint32_t", "bindCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkSparseMemoryBind>(object.pBinds, object.bindCount, settings, "const VkSparseMemoryBind*", "const VkSparseMemoryBind", "pBinds", indents + 1, dump_html_VkSparseMemoryBind); // ZRT
}
void dump_html_VkSparseImageOpaqueMemoryBindInfo(const VkSparseImageOpaqueMemoryBindInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkImage>(object.image, settings, "VkImage", "image", indents + 1, dump_html_VkImage);
    dump_html_value<const uint32_t>(object.bindCount, settings, "uint32_t", "bindCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkSparseMemoryBind>(object.pBinds, object.bindCount, settings, "const VkSparseMemoryBind*", "const VkSparseMemoryBind", "pBinds", indents + 1, dump_html_VkSparseMemoryBind); // ZRT
}
void dump_html_VkImageSubresource(const VkImageSubresource& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkImageAspectFlags>(object.aspectMask, settings, "VkImageAspectFlags", "aspectMask", indents + 1, dump_html_VkImageAspectFlags);
    dump_html_value<const uint32_t>(object.mipLevel, settings, "uint32_t", "mipLevel", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.arrayLayer, settings, "uint32_t", "arrayLayer", indents + 1, dump_html_uint32_t);
}
void dump_html_VkSparseImageMemoryBind(const VkSparseImageMemoryBind& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkImageSubresource>(object.subresource, settings, "VkImageSubresource", "subresource", indents + 1, dump_html_VkImageSubresource);
    dump_html_value<const VkOffset3D>(object.offset, settings, "VkOffset3D", "offset", indents + 1, dump_html_VkOffset3D);
    dump_html_value<const VkExtent3D>(object.extent, settings, "VkExtent3D", "extent", indents + 1, dump_html_VkExtent3D);
    dump_html_value<const VkDeviceMemory>(object.memory, settings, "VkDeviceMemory", "memory", indents + 1, dump_html_VkDeviceMemory);
    dump_html_value<const VkDeviceSize>(object.memoryOffset, settings, "VkDeviceSize", "memoryOffset", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkSparseMemoryBindFlags>(object.flags, settings, "VkSparseMemoryBindFlags", "flags", indents + 1, dump_html_VkSparseMemoryBindFlags);
}
void dump_html_VkSparseImageMemoryBindInfo(const VkSparseImageMemoryBindInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkImage>(object.image, settings, "VkImage", "image", indents + 1, dump_html_VkImage);
    dump_html_value<const uint32_t>(object.bindCount, settings, "uint32_t", "bindCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkSparseImageMemoryBind>(object.pBinds, object.bindCount, settings, "const VkSparseImageMemoryBind*", "const VkSparseImageMemoryBind", "pBinds", indents + 1, dump_html_VkSparseImageMemoryBind); // ZRT
}
void dump_html_VkBindSparseInfo(const VkBindSparseInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.waitSemaphoreCount, settings, "uint32_t", "waitSemaphoreCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkSemaphore>(object.pWaitSemaphores, object.waitSemaphoreCount, settings, "const VkSemaphore*", "const VkSemaphore", "pWaitSemaphores", indents + 1, dump_html_VkSemaphore); // ZRT
    dump_html_value<const uint32_t>(object.bufferBindCount, settings, "uint32_t", "bufferBindCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkSparseBufferMemoryBindInfo>(object.pBufferBinds, object.bufferBindCount, settings, "const VkSparseBufferMemoryBindInfo*", "const VkSparseBufferMemoryBindInfo", "pBufferBinds", indents + 1, dump_html_VkSparseBufferMemoryBindInfo); // ZRT
    dump_html_value<const uint32_t>(object.imageOpaqueBindCount, settings, "uint32_t", "imageOpaqueBindCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkSparseImageOpaqueMemoryBindInfo>(object.pImageOpaqueBinds, object.imageOpaqueBindCount, settings, "const VkSparseImageOpaqueMemoryBindInfo*", "const VkSparseImageOpaqueMemoryBindInfo", "pImageOpaqueBinds", indents + 1, dump_html_VkSparseImageOpaqueMemoryBindInfo); // ZRT
    dump_html_value<const uint32_t>(object.imageBindCount, settings, "uint32_t", "imageBindCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkSparseImageMemoryBindInfo>(object.pImageBinds, object.imageBindCount, settings, "const VkSparseImageMemoryBindInfo*", "const VkSparseImageMemoryBindInfo", "pImageBinds", indents + 1, dump_html_VkSparseImageMemoryBindInfo); // ZRT
    dump_html_value<const uint32_t>(object.signalSemaphoreCount, settings, "uint32_t", "signalSemaphoreCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkSemaphore>(object.pSignalSemaphores, object.signalSemaphoreCount, settings, "const VkSemaphore*", "const VkSemaphore", "pSignalSemaphores", indents + 1, dump_html_VkSemaphore); // ZRT
}
void dump_html_VkSparseImageFormatProperties(const VkSparseImageFormatProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkImageAspectFlags>(object.aspectMask, settings, "VkImageAspectFlags", "aspectMask", indents + 1, dump_html_VkImageAspectFlags);
    dump_html_value<const VkExtent3D>(object.imageGranularity, settings, "VkExtent3D", "imageGranularity", indents + 1, dump_html_VkExtent3D);
    dump_html_value<const VkSparseImageFormatFlags>(object.flags, settings, "VkSparseImageFormatFlags", "flags", indents + 1, dump_html_VkSparseImageFormatFlags);
}
void dump_html_VkSparseImageMemoryRequirements(const VkSparseImageMemoryRequirements& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkSparseImageFormatProperties>(object.formatProperties, settings, "VkSparseImageFormatProperties", "formatProperties", indents + 1, dump_html_VkSparseImageFormatProperties);
    dump_html_value<const uint32_t>(object.imageMipTailFirstLod, settings, "uint32_t", "imageMipTailFirstLod", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkDeviceSize>(object.imageMipTailSize, settings, "VkDeviceSize", "imageMipTailSize", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceSize>(object.imageMipTailOffset, settings, "VkDeviceSize", "imageMipTailOffset", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceSize>(object.imageMipTailStride, settings, "VkDeviceSize", "imageMipTailStride", indents + 1, dump_html_VkDeviceSize);
}
void dump_html_VkFenceCreateInfo(const VkFenceCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkFenceCreateFlags>(object.flags, settings, "VkFenceCreateFlags", "flags", indents + 1, dump_html_VkFenceCreateFlags);
}
void dump_html_VkSemaphoreCreateInfo(const VkSemaphoreCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkSemaphoreCreateFlags>(object.flags, settings, "VkSemaphoreCreateFlags", "flags", indents + 1, dump_html_VkSemaphoreCreateFlags);
}
void dump_html_VkEventCreateInfo(const VkEventCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkEventCreateFlags>(object.flags, settings, "VkEventCreateFlags", "flags", indents + 1, dump_html_VkEventCreateFlags);
}
void dump_html_VkQueryPoolCreateInfo(const VkQueryPoolCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkQueryPoolCreateFlags>(object.flags, settings, "VkQueryPoolCreateFlags", "flags", indents + 1, dump_html_VkQueryPoolCreateFlags);
    dump_html_value<const VkQueryType>(object.queryType, settings, "VkQueryType", "queryType", indents + 1, dump_html_VkQueryType);
    dump_html_value<const uint32_t>(object.queryCount, settings, "uint32_t", "queryCount", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkQueryPipelineStatisticFlags>(object.pipelineStatistics, settings, "VkQueryPipelineStatisticFlags", "pipelineStatistics", indents + 1, dump_html_VkQueryPipelineStatisticFlags);
}
void dump_html_VkBufferCreateInfo(const VkBufferCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBufferCreateFlags>(object.flags, settings, "VkBufferCreateFlags", "flags", indents + 1, dump_html_VkBufferCreateFlags);
    dump_html_value<const VkDeviceSize>(object.size, settings, "VkDeviceSize", "size", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkBufferUsageFlags>(object.usage, settings, "VkBufferUsageFlags", "usage", indents + 1, dump_html_VkBufferUsageFlags);
    dump_html_value<const VkSharingMode>(object.sharingMode, settings, "VkSharingMode", "sharingMode", indents + 1, dump_html_VkSharingMode);
    dump_html_value<const uint32_t>(object.queueFamilyIndexCount, settings, "uint32_t", "queueFamilyIndexCount", indents + 1, dump_html_uint32_t);
    if(object.sharingMode == VK_SHARING_MODE_CONCURRENT)
    dump_html_array<const uint32_t>(object.pQueueFamilyIndices, object.queueFamilyIndexCount, settings, "const uint32_t*", "const uint32_t", "pQueueFamilyIndices", indents + 1, dump_html_uint32_t); // ZRT
    else
        dump_html_special("UNUSED", settings, "const uint32_t*", "pQueueFamilyIndices", indents + 1);
}
void dump_html_VkBufferViewCreateInfo(const VkBufferViewCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBufferViewCreateFlags>(object.flags, settings, "VkBufferViewCreateFlags", "flags", indents + 1, dump_html_VkBufferViewCreateFlags);
    dump_html_value<const VkBuffer>(object.buffer, settings, "VkBuffer", "buffer", indents + 1, dump_html_VkBuffer);
    dump_html_value<const VkFormat>(object.format, settings, "VkFormat", "format", indents + 1, dump_html_VkFormat);
    dump_html_value<const VkDeviceSize>(object.offset, settings, "VkDeviceSize", "offset", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceSize>(object.range, settings, "VkDeviceSize", "range", indents + 1, dump_html_VkDeviceSize);
}
void dump_html_VkImageCreateInfo(const VkImageCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkImageCreateFlags>(object.flags, settings, "VkImageCreateFlags", "flags", indents + 1, dump_html_VkImageCreateFlags);
    dump_html_value<const VkImageType>(object.imageType, settings, "VkImageType", "imageType", indents + 1, dump_html_VkImageType);
    dump_html_value<const VkFormat>(object.format, settings, "VkFormat", "format", indents + 1, dump_html_VkFormat);
    dump_html_value<const VkExtent3D>(object.extent, settings, "VkExtent3D", "extent", indents + 1, dump_html_VkExtent3D);
    dump_html_value<const uint32_t>(object.mipLevels, settings, "uint32_t", "mipLevels", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.arrayLayers, settings, "uint32_t", "arrayLayers", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkSampleCountFlagBits>(object.samples, settings, "VkSampleCountFlagBits", "samples", indents + 1, dump_html_VkSampleCountFlagBits);
    dump_html_value<const VkImageTiling>(object.tiling, settings, "VkImageTiling", "tiling", indents + 1, dump_html_VkImageTiling);
    dump_html_value<const VkImageUsageFlags>(object.usage, settings, "VkImageUsageFlags", "usage", indents + 1, dump_html_VkImageUsageFlags);
    dump_html_value<const VkSharingMode>(object.sharingMode, settings, "VkSharingMode", "sharingMode", indents + 1, dump_html_VkSharingMode);
    dump_html_value<const uint32_t>(object.queueFamilyIndexCount, settings, "uint32_t", "queueFamilyIndexCount", indents + 1, dump_html_uint32_t);
    if(object.sharingMode == VK_SHARING_MODE_CONCURRENT)
    dump_html_array<const uint32_t>(object.pQueueFamilyIndices, object.queueFamilyIndexCount, settings, "const uint32_t*", "const uint32_t", "pQueueFamilyIndices", indents + 1, dump_html_uint32_t); // ZRT
    else
        dump_html_special("UNUSED", settings, "const uint32_t*", "pQueueFamilyIndices", indents + 1);
    dump_html_value<const VkImageLayout>(object.initialLayout, settings, "VkImageLayout", "initialLayout", indents + 1, dump_html_VkImageLayout);
}
void dump_html_VkSubresourceLayout(const VkSubresourceLayout& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkDeviceSize>(object.offset, settings, "VkDeviceSize", "offset", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceSize>(object.size, settings, "VkDeviceSize", "size", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceSize>(object.rowPitch, settings, "VkDeviceSize", "rowPitch", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceSize>(object.arrayPitch, settings, "VkDeviceSize", "arrayPitch", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceSize>(object.depthPitch, settings, "VkDeviceSize", "depthPitch", indents + 1, dump_html_VkDeviceSize);
}
void dump_html_VkComponentMapping(const VkComponentMapping& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkComponentSwizzle>(object.r, settings, "VkComponentSwizzle", "r", indents + 1, dump_html_VkComponentSwizzle);
    dump_html_value<const VkComponentSwizzle>(object.g, settings, "VkComponentSwizzle", "g", indents + 1, dump_html_VkComponentSwizzle);
    dump_html_value<const VkComponentSwizzle>(object.b, settings, "VkComponentSwizzle", "b", indents + 1, dump_html_VkComponentSwizzle);
    dump_html_value<const VkComponentSwizzle>(object.a, settings, "VkComponentSwizzle", "a", indents + 1, dump_html_VkComponentSwizzle);
}
void dump_html_VkImageViewCreateInfo(const VkImageViewCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkImageViewCreateFlags>(object.flags, settings, "VkImageViewCreateFlags", "flags", indents + 1, dump_html_VkImageViewCreateFlags);
    dump_html_value<const VkImage>(object.image, settings, "VkImage", "image", indents + 1, dump_html_VkImage);
    dump_html_value<const VkImageViewType>(object.viewType, settings, "VkImageViewType", "viewType", indents + 1, dump_html_VkImageViewType);
    dump_html_value<const VkFormat>(object.format, settings, "VkFormat", "format", indents + 1, dump_html_VkFormat);
    dump_html_value<const VkComponentMapping>(object.components, settings, "VkComponentMapping", "components", indents + 1, dump_html_VkComponentMapping);
    dump_html_value<const VkImageSubresourceRange>(object.subresourceRange, settings, "VkImageSubresourceRange", "subresourceRange", indents + 1, dump_html_VkImageSubresourceRange);
}
void dump_html_VkShaderModuleCreateInfo(const VkShaderModuleCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkShaderModuleCreateFlags>(object.flags, settings, "VkShaderModuleCreateFlags", "flags", indents + 1, dump_html_VkShaderModuleCreateFlags);
    dump_html_value<const size_t>(object.codeSize, settings, "size_t", "codeSize", indents + 1, dump_html_size_t);
    if(settings.showShader())
        dump_html_array<const uint32_t>(object.pCode, object.codeSize / 4, settings, "const uint32_t*", "const uint32_t", "pCode", indents + 1, dump_html_uint32_t); // ZRU
    else
        dump_html_special("SHADER DATA", settings, "const uint32_t*", "pCode", indents + 1);
}
void dump_html_VkPipelineCacheCreateInfo(const VkPipelineCacheCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkPipelineCacheCreateFlags>(object.flags, settings, "VkPipelineCacheCreateFlags", "flags", indents + 1, dump_html_VkPipelineCacheCreateFlags);
    dump_html_value<const size_t>(object.initialDataSize, settings, "size_t", "initialDataSize", indents + 1, dump_html_size_t);
    dump_html_value<const void*>(object.pInitialData, settings, "const void*", "pInitialData", indents + 1, dump_html_void);
}
void dump_html_VkSpecializationMapEntry(const VkSpecializationMapEntry& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const uint32_t>(object.constantID, settings, "uint32_t", "constantID", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.offset, settings, "uint32_t", "offset", indents + 1, dump_html_uint32_t);
    dump_html_value<const size_t>(object.size, settings, "size_t", "size", indents + 1, dump_html_size_t);
}
void dump_html_VkSpecializationInfo(const VkSpecializationInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const uint32_t>(object.mapEntryCount, settings, "uint32_t", "mapEntryCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkSpecializationMapEntry>(object.pMapEntries, object.mapEntryCount, settings, "const VkSpecializationMapEntry*", "const VkSpecializationMapEntry", "pMapEntries", indents + 1, dump_html_VkSpecializationMapEntry); // ZRT
    dump_html_value<const size_t>(object.dataSize, settings, "size_t", "dataSize", indents + 1, dump_html_size_t);
    dump_html_value<const void*>(object.pData, settings, "const void*", "pData", indents + 1, dump_html_void);
}
void dump_html_VkPipelineShaderStageCreateInfo(const VkPipelineShaderStageCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkPipelineShaderStageCreateFlags>(object.flags, settings, "VkPipelineShaderStageCreateFlags", "flags", indents + 1, dump_html_VkPipelineShaderStageCreateFlags);
    dump_html_value<const VkShaderStageFlagBits>(object.stage, settings, "VkShaderStageFlagBits", "stage", indents + 1, dump_html_VkShaderStageFlagBits);
    dump_html_value<const VkShaderModule>(object.module, settings, "VkShaderModule", "module", indents + 1, dump_html_VkShaderModule);
    dump_html_value<const char*>(object.pName, settings, "const char*", "pName", indents + 1, dump_html_cstring);
    dump_html_pointer<const VkSpecializationInfo>(object.pSpecializationInfo, settings, "const VkSpecializationInfo*", "pSpecializationInfo", indents + 1, dump_html_VkSpecializationInfo);
}
void dump_html_VkComputePipelineCreateInfo(const VkComputePipelineCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkPipelineCreateFlags>(object.flags, settings, "VkPipelineCreateFlags", "flags", indents + 1, dump_html_VkPipelineCreateFlags);
    dump_html_value<const VkPipelineShaderStageCreateInfo>(object.stage, settings, "VkPipelineShaderStageCreateInfo", "stage", indents + 1, dump_html_VkPipelineShaderStageCreateInfo);
    dump_html_value<const VkPipelineLayout>(object.layout, settings, "VkPipelineLayout", "layout", indents + 1, dump_html_VkPipelineLayout);
    dump_html_value<const VkPipeline>(object.basePipelineHandle, settings, "VkPipeline", "basePipelineHandle", indents + 1, dump_html_VkPipeline);
    dump_html_value<const int32_t>(object.basePipelineIndex, settings, "int32_t", "basePipelineIndex", indents + 1, dump_html_int32_t);
}
void dump_html_VkVertexInputBindingDescription(const VkVertexInputBindingDescription& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const uint32_t>(object.binding, settings, "uint32_t", "binding", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.stride, settings, "uint32_t", "stride", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkVertexInputRate>(object.inputRate, settings, "VkVertexInputRate", "inputRate", indents + 1, dump_html_VkVertexInputRate);
}
void dump_html_VkVertexInputAttributeDescription(const VkVertexInputAttributeDescription& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const uint32_t>(object.location, settings, "uint32_t", "location", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.binding, settings, "uint32_t", "binding", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkFormat>(object.format, settings, "VkFormat", "format", indents + 1, dump_html_VkFormat);
    dump_html_value<const uint32_t>(object.offset, settings, "uint32_t", "offset", indents + 1, dump_html_uint32_t);
}
void dump_html_VkPipelineVertexInputStateCreateInfo(const VkPipelineVertexInputStateCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkPipelineVertexInputStateCreateFlags>(object.flags, settings, "VkPipelineVertexInputStateCreateFlags", "flags", indents + 1, dump_html_VkPipelineVertexInputStateCreateFlags);
    dump_html_value<const uint32_t>(object.vertexBindingDescriptionCount, settings, "uint32_t", "vertexBindingDescriptionCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkVertexInputBindingDescription>(object.pVertexBindingDescriptions, object.vertexBindingDescriptionCount, settings, "const VkVertexInputBindingDescription*", "const VkVertexInputBindingDescription", "pVertexBindingDescriptions", indents + 1, dump_html_VkVertexInputBindingDescription); // ZRT
    dump_html_value<const uint32_t>(object.vertexAttributeDescriptionCount, settings, "uint32_t", "vertexAttributeDescriptionCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkVertexInputAttributeDescription>(object.pVertexAttributeDescriptions, object.vertexAttributeDescriptionCount, settings, "const VkVertexInputAttributeDescription*", "const VkVertexInputAttributeDescription", "pVertexAttributeDescriptions", indents + 1, dump_html_VkVertexInputAttributeDescription); // ZRT
}
void dump_html_VkPipelineInputAssemblyStateCreateInfo(const VkPipelineInputAssemblyStateCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkPipelineInputAssemblyStateCreateFlags>(object.flags, settings, "VkPipelineInputAssemblyStateCreateFlags", "flags", indents + 1, dump_html_VkPipelineInputAssemblyStateCreateFlags);
    dump_html_value<const VkPrimitiveTopology>(object.topology, settings, "VkPrimitiveTopology", "topology", indents + 1, dump_html_VkPrimitiveTopology);
    dump_html_value<const VkBool32>(object.primitiveRestartEnable, settings, "VkBool32", "primitiveRestartEnable", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPipelineTessellationStateCreateInfo(const VkPipelineTessellationStateCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkPipelineTessellationStateCreateFlags>(object.flags, settings, "VkPipelineTessellationStateCreateFlags", "flags", indents + 1, dump_html_VkPipelineTessellationStateCreateFlags);
    dump_html_value<const uint32_t>(object.patchControlPoints, settings, "uint32_t", "patchControlPoints", indents + 1, dump_html_uint32_t);
}
void dump_html_VkViewport(const VkViewport& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const float>(object.x, settings, "float", "x", indents + 1, dump_html_float);
    dump_html_value<const float>(object.y, settings, "float", "y", indents + 1, dump_html_float);
    dump_html_value<const float>(object.width, settings, "float", "width", indents + 1, dump_html_float);
    dump_html_value<const float>(object.height, settings, "float", "height", indents + 1, dump_html_float);
    dump_html_value<const float>(object.minDepth, settings, "float", "minDepth", indents + 1, dump_html_float);
    dump_html_value<const float>(object.maxDepth, settings, "float", "maxDepth", indents + 1, dump_html_float);
}
void dump_html_VkPipelineViewportStateCreateInfo(const VkPipelineViewportStateCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkPipelineViewportStateCreateFlags>(object.flags, settings, "VkPipelineViewportStateCreateFlags", "flags", indents + 1, dump_html_VkPipelineViewportStateCreateFlags);
    dump_html_value<const uint32_t>(object.viewportCount, settings, "uint32_t", "viewportCount", indents + 1, dump_html_uint32_t);
    if(!ApiDumpInstance::current().getIsDynamicViewport())
    dump_html_array<const VkViewport>(object.pViewports, object.viewportCount, settings, "const VkViewport*", "const VkViewport", "pViewports", indents + 1, dump_html_VkViewport); // ZRT
    else
        dump_html_special("UNUSED", settings, "const VkViewport*", "pViewports", indents + 1);
    dump_html_value<const uint32_t>(object.scissorCount, settings, "uint32_t", "scissorCount", indents + 1, dump_html_uint32_t);
    if(!ApiDumpInstance::current().getIsDynamicScissor())
    dump_html_array<const VkRect2D>(object.pScissors, object.scissorCount, settings, "const VkRect2D*", "const VkRect2D", "pScissors", indents + 1, dump_html_VkRect2D); // ZRT
    else
        dump_html_special("UNUSED", settings, "const VkRect2D*", "pScissors", indents + 1);
}
void dump_html_VkPipelineRasterizationStateCreateInfo(const VkPipelineRasterizationStateCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkPipelineRasterizationStateCreateFlags>(object.flags, settings, "VkPipelineRasterizationStateCreateFlags", "flags", indents + 1, dump_html_VkPipelineRasterizationStateCreateFlags);
    dump_html_value<const VkBool32>(object.depthClampEnable, settings, "VkBool32", "depthClampEnable", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.rasterizerDiscardEnable, settings, "VkBool32", "rasterizerDiscardEnable", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkPolygonMode>(object.polygonMode, settings, "VkPolygonMode", "polygonMode", indents + 1, dump_html_VkPolygonMode);
    dump_html_value<const VkCullModeFlags>(object.cullMode, settings, "VkCullModeFlags", "cullMode", indents + 1, dump_html_VkCullModeFlags);
    dump_html_value<const VkFrontFace>(object.frontFace, settings, "VkFrontFace", "frontFace", indents + 1, dump_html_VkFrontFace);
    dump_html_value<const VkBool32>(object.depthBiasEnable, settings, "VkBool32", "depthBiasEnable", indents + 1, dump_html_VkBool32);
    dump_html_value<const float>(object.depthBiasConstantFactor, settings, "float", "depthBiasConstantFactor", indents + 1, dump_html_float);
    dump_html_value<const float>(object.depthBiasClamp, settings, "float", "depthBiasClamp", indents + 1, dump_html_float);
    dump_html_value<const float>(object.depthBiasSlopeFactor, settings, "float", "depthBiasSlopeFactor", indents + 1, dump_html_float);
    dump_html_value<const float>(object.lineWidth, settings, "float", "lineWidth", indents + 1, dump_html_float);
}
void dump_html_VkPipelineMultisampleStateCreateInfo(const VkPipelineMultisampleStateCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkPipelineMultisampleStateCreateFlags>(object.flags, settings, "VkPipelineMultisampleStateCreateFlags", "flags", indents + 1, dump_html_VkPipelineMultisampleStateCreateFlags);
    dump_html_value<const VkSampleCountFlagBits>(object.rasterizationSamples, settings, "VkSampleCountFlagBits", "rasterizationSamples", indents + 1, dump_html_VkSampleCountFlagBits);
    dump_html_value<const VkBool32>(object.sampleShadingEnable, settings, "VkBool32", "sampleShadingEnable", indents + 1, dump_html_VkBool32);
    dump_html_value<const float>(object.minSampleShading, settings, "float", "minSampleShading", indents + 1, dump_html_float);
    dump_html_array<const VkSampleMask>(object.pSampleMask, (object.rasterizationSamples + 31) / 32, settings, "const VkSampleMask*", "const VkSampleMask", "pSampleMask", indents + 1, dump_html_VkSampleMask); // ZRT
    dump_html_value<const VkBool32>(object.alphaToCoverageEnable, settings, "VkBool32", "alphaToCoverageEnable", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.alphaToOneEnable, settings, "VkBool32", "alphaToOneEnable", indents + 1, dump_html_VkBool32);
}
void dump_html_VkStencilOpState(const VkStencilOpState& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStencilOp>(object.failOp, settings, "VkStencilOp", "failOp", indents + 1, dump_html_VkStencilOp);
    dump_html_value<const VkStencilOp>(object.passOp, settings, "VkStencilOp", "passOp", indents + 1, dump_html_VkStencilOp);
    dump_html_value<const VkStencilOp>(object.depthFailOp, settings, "VkStencilOp", "depthFailOp", indents + 1, dump_html_VkStencilOp);
    dump_html_value<const VkCompareOp>(object.compareOp, settings, "VkCompareOp", "compareOp", indents + 1, dump_html_VkCompareOp);
    dump_html_value<const uint32_t>(object.compareMask, settings, "uint32_t", "compareMask", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.writeMask, settings, "uint32_t", "writeMask", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.reference, settings, "uint32_t", "reference", indents + 1, dump_html_uint32_t);
}
void dump_html_VkPipelineDepthStencilStateCreateInfo(const VkPipelineDepthStencilStateCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkPipelineDepthStencilStateCreateFlags>(object.flags, settings, "VkPipelineDepthStencilStateCreateFlags", "flags", indents + 1, dump_html_VkPipelineDepthStencilStateCreateFlags);
    dump_html_value<const VkBool32>(object.depthTestEnable, settings, "VkBool32", "depthTestEnable", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.depthWriteEnable, settings, "VkBool32", "depthWriteEnable", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkCompareOp>(object.depthCompareOp, settings, "VkCompareOp", "depthCompareOp", indents + 1, dump_html_VkCompareOp);
    dump_html_value<const VkBool32>(object.depthBoundsTestEnable, settings, "VkBool32", "depthBoundsTestEnable", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.stencilTestEnable, settings, "VkBool32", "stencilTestEnable", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkStencilOpState>(object.front, settings, "VkStencilOpState", "front", indents + 1, dump_html_VkStencilOpState);
    dump_html_value<const VkStencilOpState>(object.back, settings, "VkStencilOpState", "back", indents + 1, dump_html_VkStencilOpState);
    dump_html_value<const float>(object.minDepthBounds, settings, "float", "minDepthBounds", indents + 1, dump_html_float);
    dump_html_value<const float>(object.maxDepthBounds, settings, "float", "maxDepthBounds", indents + 1, dump_html_float);
}
void dump_html_VkPipelineColorBlendAttachmentState(const VkPipelineColorBlendAttachmentState& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkBool32>(object.blendEnable, settings, "VkBool32", "blendEnable", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBlendFactor>(object.srcColorBlendFactor, settings, "VkBlendFactor", "srcColorBlendFactor", indents + 1, dump_html_VkBlendFactor);
    dump_html_value<const VkBlendFactor>(object.dstColorBlendFactor, settings, "VkBlendFactor", "dstColorBlendFactor", indents + 1, dump_html_VkBlendFactor);
    dump_html_value<const VkBlendOp>(object.colorBlendOp, settings, "VkBlendOp", "colorBlendOp", indents + 1, dump_html_VkBlendOp);
    dump_html_value<const VkBlendFactor>(object.srcAlphaBlendFactor, settings, "VkBlendFactor", "srcAlphaBlendFactor", indents + 1, dump_html_VkBlendFactor);
    dump_html_value<const VkBlendFactor>(object.dstAlphaBlendFactor, settings, "VkBlendFactor", "dstAlphaBlendFactor", indents + 1, dump_html_VkBlendFactor);
    dump_html_value<const VkBlendOp>(object.alphaBlendOp, settings, "VkBlendOp", "alphaBlendOp", indents + 1, dump_html_VkBlendOp);
    dump_html_value<const VkColorComponentFlags>(object.colorWriteMask, settings, "VkColorComponentFlags", "colorWriteMask", indents + 1, dump_html_VkColorComponentFlags);
}
void dump_html_VkPipelineColorBlendStateCreateInfo(const VkPipelineColorBlendStateCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkPipelineColorBlendStateCreateFlags>(object.flags, settings, "VkPipelineColorBlendStateCreateFlags", "flags", indents + 1, dump_html_VkPipelineColorBlendStateCreateFlags);
    dump_html_value<const VkBool32>(object.logicOpEnable, settings, "VkBool32", "logicOpEnable", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkLogicOp>(object.logicOp, settings, "VkLogicOp", "logicOp", indents + 1, dump_html_VkLogicOp);
    dump_html_value<const uint32_t>(object.attachmentCount, settings, "uint32_t", "attachmentCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkPipelineColorBlendAttachmentState>(object.pAttachments, object.attachmentCount, settings, "const VkPipelineColorBlendAttachmentState*", "const VkPipelineColorBlendAttachmentState", "pAttachments", indents + 1, dump_html_VkPipelineColorBlendAttachmentState); // ZRT
    dump_html_array<const float>(object.blendConstants, 4, settings, "float[4]", "float", "blendConstants", indents + 1, dump_html_float); // ZRR
}
void dump_html_VkPipelineDynamicStateCreateInfo(const VkPipelineDynamicStateCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkPipelineDynamicStateCreateFlags>(object.flags, settings, "VkPipelineDynamicStateCreateFlags", "flags", indents + 1, dump_html_VkPipelineDynamicStateCreateFlags);
    dump_html_value<const uint32_t>(object.dynamicStateCount, settings, "uint32_t", "dynamicStateCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkDynamicState>(object.pDynamicStates, object.dynamicStateCount, settings, "const VkDynamicState*", "const VkDynamicState", "pDynamicStates", indents + 1, dump_html_VkDynamicState); // ZRT
}
void dump_html_VkGraphicsPipelineCreateInfo(const VkGraphicsPipelineCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    ApiDumpInstance::current().setIsDynamicViewport(object.pDynamicState && std::count(object.pDynamicState->pDynamicStates, object.pDynamicState->pDynamicStates + object.pDynamicState->dynamicStateCount, VK_DYNAMIC_STATE_VIEWPORT) > 0);ApiDumpInstance::current().setIsDynamicScissor(object.pDynamicState && std::count(object.pDynamicState->pDynamicStates, object.pDynamicState->pDynamicStates + object.pDynamicState->dynamicStateCount, VK_DYNAMIC_STATE_SCISSOR));
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkPipelineCreateFlags>(object.flags, settings, "VkPipelineCreateFlags", "flags", indents + 1, dump_html_VkPipelineCreateFlags);
    dump_html_value<const uint32_t>(object.stageCount, settings, "uint32_t", "stageCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkPipelineShaderStageCreateInfo>(object.pStages, object.stageCount, settings, "const VkPipelineShaderStageCreateInfo*", "const VkPipelineShaderStageCreateInfo", "pStages", indents + 1, dump_html_VkPipelineShaderStageCreateInfo); // ZRT
    dump_html_pointer<const VkPipelineVertexInputStateCreateInfo>(object.pVertexInputState, settings, "const VkPipelineVertexInputStateCreateInfo*", "pVertexInputState", indents + 1, dump_html_VkPipelineVertexInputStateCreateInfo);
    dump_html_pointer<const VkPipelineInputAssemblyStateCreateInfo>(object.pInputAssemblyState, settings, "const VkPipelineInputAssemblyStateCreateInfo*", "pInputAssemblyState", indents + 1, dump_html_VkPipelineInputAssemblyStateCreateInfo);
    dump_html_pointer<const VkPipelineTessellationStateCreateInfo>(object.pTessellationState, settings, "const VkPipelineTessellationStateCreateInfo*", "pTessellationState", indents + 1, dump_html_VkPipelineTessellationStateCreateInfo);
    dump_html_pointer<const VkPipelineViewportStateCreateInfo>(object.pViewportState, settings, "const VkPipelineViewportStateCreateInfo*", "pViewportState", indents + 1, dump_html_VkPipelineViewportStateCreateInfo);
    dump_html_pointer<const VkPipelineRasterizationStateCreateInfo>(object.pRasterizationState, settings, "const VkPipelineRasterizationStateCreateInfo*", "pRasterizationState", indents + 1, dump_html_VkPipelineRasterizationStateCreateInfo);
    dump_html_pointer<const VkPipelineMultisampleStateCreateInfo>(object.pMultisampleState, settings, "const VkPipelineMultisampleStateCreateInfo*", "pMultisampleState", indents + 1, dump_html_VkPipelineMultisampleStateCreateInfo);
    dump_html_pointer<const VkPipelineDepthStencilStateCreateInfo>(object.pDepthStencilState, settings, "const VkPipelineDepthStencilStateCreateInfo*", "pDepthStencilState", indents + 1, dump_html_VkPipelineDepthStencilStateCreateInfo);
    dump_html_pointer<const VkPipelineColorBlendStateCreateInfo>(object.pColorBlendState, settings, "const VkPipelineColorBlendStateCreateInfo*", "pColorBlendState", indents + 1, dump_html_VkPipelineColorBlendStateCreateInfo);
    dump_html_pointer<const VkPipelineDynamicStateCreateInfo>(object.pDynamicState, settings, "const VkPipelineDynamicStateCreateInfo*", "pDynamicState", indents + 1, dump_html_VkPipelineDynamicStateCreateInfo);
    dump_html_value<const VkPipelineLayout>(object.layout, settings, "VkPipelineLayout", "layout", indents + 1, dump_html_VkPipelineLayout);
    dump_html_value<const VkRenderPass>(object.renderPass, settings, "VkRenderPass", "renderPass", indents + 1, dump_html_VkRenderPass);
    dump_html_value<const uint32_t>(object.subpass, settings, "uint32_t", "subpass", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkPipeline>(object.basePipelineHandle, settings, "VkPipeline", "basePipelineHandle", indents + 1, dump_html_VkPipeline);
    dump_html_value<const int32_t>(object.basePipelineIndex, settings, "int32_t", "basePipelineIndex", indents + 1, dump_html_int32_t);
}
void dump_html_VkPushConstantRange(const VkPushConstantRange& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkShaderStageFlags>(object.stageFlags, settings, "VkShaderStageFlags", "stageFlags", indents + 1, dump_html_VkShaderStageFlags);
    dump_html_value<const uint32_t>(object.offset, settings, "uint32_t", "offset", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.size, settings, "uint32_t", "size", indents + 1, dump_html_uint32_t);
}
void dump_html_VkPipelineLayoutCreateInfo(const VkPipelineLayoutCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkPipelineLayoutCreateFlags>(object.flags, settings, "VkPipelineLayoutCreateFlags", "flags", indents + 1, dump_html_VkPipelineLayoutCreateFlags);
    dump_html_value<const uint32_t>(object.setLayoutCount, settings, "uint32_t", "setLayoutCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkDescriptorSetLayout>(object.pSetLayouts, object.setLayoutCount, settings, "const VkDescriptorSetLayout*", "const VkDescriptorSetLayout", "pSetLayouts", indents + 1, dump_html_VkDescriptorSetLayout); // ZRT
    dump_html_value<const uint32_t>(object.pushConstantRangeCount, settings, "uint32_t", "pushConstantRangeCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkPushConstantRange>(object.pPushConstantRanges, object.pushConstantRangeCount, settings, "const VkPushConstantRange*", "const VkPushConstantRange", "pPushConstantRanges", indents + 1, dump_html_VkPushConstantRange); // ZRT
}
void dump_html_VkSamplerCreateInfo(const VkSamplerCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkSamplerCreateFlags>(object.flags, settings, "VkSamplerCreateFlags", "flags", indents + 1, dump_html_VkSamplerCreateFlags);
    dump_html_value<const VkFilter>(object.magFilter, settings, "VkFilter", "magFilter", indents + 1, dump_html_VkFilter);
    dump_html_value<const VkFilter>(object.minFilter, settings, "VkFilter", "minFilter", indents + 1, dump_html_VkFilter);
    dump_html_value<const VkSamplerMipmapMode>(object.mipmapMode, settings, "VkSamplerMipmapMode", "mipmapMode", indents + 1, dump_html_VkSamplerMipmapMode);
    dump_html_value<const VkSamplerAddressMode>(object.addressModeU, settings, "VkSamplerAddressMode", "addressModeU", indents + 1, dump_html_VkSamplerAddressMode);
    dump_html_value<const VkSamplerAddressMode>(object.addressModeV, settings, "VkSamplerAddressMode", "addressModeV", indents + 1, dump_html_VkSamplerAddressMode);
    dump_html_value<const VkSamplerAddressMode>(object.addressModeW, settings, "VkSamplerAddressMode", "addressModeW", indents + 1, dump_html_VkSamplerAddressMode);
    dump_html_value<const float>(object.mipLodBias, settings, "float", "mipLodBias", indents + 1, dump_html_float);
    dump_html_value<const VkBool32>(object.anisotropyEnable, settings, "VkBool32", "anisotropyEnable", indents + 1, dump_html_VkBool32);
    dump_html_value<const float>(object.maxAnisotropy, settings, "float", "maxAnisotropy", indents + 1, dump_html_float);
    dump_html_value<const VkBool32>(object.compareEnable, settings, "VkBool32", "compareEnable", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkCompareOp>(object.compareOp, settings, "VkCompareOp", "compareOp", indents + 1, dump_html_VkCompareOp);
    dump_html_value<const float>(object.minLod, settings, "float", "minLod", indents + 1, dump_html_float);
    dump_html_value<const float>(object.maxLod, settings, "float", "maxLod", indents + 1, dump_html_float);
    dump_html_value<const VkBorderColor>(object.borderColor, settings, "VkBorderColor", "borderColor", indents + 1, dump_html_VkBorderColor);
    dump_html_value<const VkBool32>(object.unnormalizedCoordinates, settings, "VkBool32", "unnormalizedCoordinates", indents + 1, dump_html_VkBool32);
}
void dump_html_VkCopyDescriptorSet(const VkCopyDescriptorSet& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDescriptorSet>(object.srcSet, settings, "VkDescriptorSet", "srcSet", indents + 1, dump_html_VkDescriptorSet);
    dump_html_value<const uint32_t>(object.srcBinding, settings, "uint32_t", "srcBinding", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.srcArrayElement, settings, "uint32_t", "srcArrayElement", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkDescriptorSet>(object.dstSet, settings, "VkDescriptorSet", "dstSet", indents + 1, dump_html_VkDescriptorSet);
    dump_html_value<const uint32_t>(object.dstBinding, settings, "uint32_t", "dstBinding", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.dstArrayElement, settings, "uint32_t", "dstArrayElement", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.descriptorCount, settings, "uint32_t", "descriptorCount", indents + 1, dump_html_uint32_t);
}
void dump_html_VkDescriptorBufferInfo(const VkDescriptorBufferInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkBuffer>(object.buffer, settings, "VkBuffer", "buffer", indents + 1, dump_html_VkBuffer);
    dump_html_value<const VkDeviceSize>(object.offset, settings, "VkDeviceSize", "offset", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceSize>(object.range, settings, "VkDeviceSize", "range", indents + 1, dump_html_VkDeviceSize);
}
void dump_html_VkDescriptorImageInfo(const VkDescriptorImageInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkSampler>(object.sampler, settings, "VkSampler", "sampler", indents + 1, dump_html_VkSampler);
    dump_html_value<const VkImageView>(object.imageView, settings, "VkImageView", "imageView", indents + 1, dump_html_VkImageView);
    dump_html_value<const VkImageLayout>(object.imageLayout, settings, "VkImageLayout", "imageLayout", indents + 1, dump_html_VkImageLayout);
}
void dump_html_VkDescriptorPoolSize(const VkDescriptorPoolSize& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkDescriptorType>(object.type, settings, "VkDescriptorType", "type", indents + 1, dump_html_VkDescriptorType);
    dump_html_value<const uint32_t>(object.descriptorCount, settings, "uint32_t", "descriptorCount", indents + 1, dump_html_uint32_t);
}
void dump_html_VkDescriptorPoolCreateInfo(const VkDescriptorPoolCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDescriptorPoolCreateFlags>(object.flags, settings, "VkDescriptorPoolCreateFlags", "flags", indents + 1, dump_html_VkDescriptorPoolCreateFlags);
    dump_html_value<const uint32_t>(object.maxSets, settings, "uint32_t", "maxSets", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.poolSizeCount, settings, "uint32_t", "poolSizeCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkDescriptorPoolSize>(object.pPoolSizes, object.poolSizeCount, settings, "const VkDescriptorPoolSize*", "const VkDescriptorPoolSize", "pPoolSizes", indents + 1, dump_html_VkDescriptorPoolSize); // ZRT
}
void dump_html_VkDescriptorSetAllocateInfo(const VkDescriptorSetAllocateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDescriptorPool>(object.descriptorPool, settings, "VkDescriptorPool", "descriptorPool", indents + 1, dump_html_VkDescriptorPool);
    dump_html_value<const uint32_t>(object.descriptorSetCount, settings, "uint32_t", "descriptorSetCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkDescriptorSetLayout>(object.pSetLayouts, object.descriptorSetCount, settings, "const VkDescriptorSetLayout*", "const VkDescriptorSetLayout", "pSetLayouts", indents + 1, dump_html_VkDescriptorSetLayout); // ZRT
}
void dump_html_VkDescriptorSetLayoutBinding(const VkDescriptorSetLayoutBinding& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const uint32_t>(object.binding, settings, "uint32_t", "binding", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkDescriptorType>(object.descriptorType, settings, "VkDescriptorType", "descriptorType", indents + 1, dump_html_VkDescriptorType);
    dump_html_value<const uint32_t>(object.descriptorCount, settings, "uint32_t", "descriptorCount", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkShaderStageFlags>(object.stageFlags, settings, "VkShaderStageFlags", "stageFlags", indents + 1, dump_html_VkShaderStageFlags);
    if((object.descriptorType == VK_DESCRIPTOR_TYPE_SAMPLER) || (object.descriptorType == VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER))
    dump_html_array<const VkSampler>(object.pImmutableSamplers, object.descriptorCount, settings, "const VkSampler*", "const VkSampler", "pImmutableSamplers", indents + 1, dump_html_VkSampler); // ZRT
    else
        dump_html_special("UNUSED", settings, "const VkSampler*", "pImmutableSamplers", indents + 1);
}
void dump_html_VkDescriptorSetLayoutCreateInfo(const VkDescriptorSetLayoutCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDescriptorSetLayoutCreateFlags>(object.flags, settings, "VkDescriptorSetLayoutCreateFlags", "flags", indents + 1, dump_html_VkDescriptorSetLayoutCreateFlags);
    dump_html_value<const uint32_t>(object.bindingCount, settings, "uint32_t", "bindingCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkDescriptorSetLayoutBinding>(object.pBindings, object.bindingCount, settings, "const VkDescriptorSetLayoutBinding*", "const VkDescriptorSetLayoutBinding", "pBindings", indents + 1, dump_html_VkDescriptorSetLayoutBinding); // ZRT
}
void dump_html_VkWriteDescriptorSet(const VkWriteDescriptorSet& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDescriptorSet>(object.dstSet, settings, "VkDescriptorSet", "dstSet", indents + 1, dump_html_VkDescriptorSet);
    dump_html_value<const uint32_t>(object.dstBinding, settings, "uint32_t", "dstBinding", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.dstArrayElement, settings, "uint32_t", "dstArrayElement", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.descriptorCount, settings, "uint32_t", "descriptorCount", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkDescriptorType>(object.descriptorType, settings, "VkDescriptorType", "descriptorType", indents + 1, dump_html_VkDescriptorType);
    if((object.descriptorType == VK_DESCRIPTOR_TYPE_SAMPLER) || (object.descriptorType == VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER) || (object.descriptorType == VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE) || (object.descriptorType == VK_DESCRIPTOR_TYPE_STORAGE_IMAGE) || (object.descriptorType == VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT))
    dump_html_array<const VkDescriptorImageInfo>(object.pImageInfo, object.descriptorCount, settings, "const VkDescriptorImageInfo*", "const VkDescriptorImageInfo", "pImageInfo", indents + 1, dump_html_VkDescriptorImageInfo); // ZRT
    else
        dump_html_special("UNUSED", settings, "const VkDescriptorImageInfo*", "pImageInfo", indents + 1);
    if((object.descriptorType == VK_DESCRIPTOR_TYPE_STORAGE_BUFFER) || (object.descriptorType == VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER) || (object.descriptorType == VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC) || (object.descriptorType == VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC))
    dump_html_array<const VkDescriptorBufferInfo>(object.pBufferInfo, object.descriptorCount, settings, "const VkDescriptorBufferInfo*", "const VkDescriptorBufferInfo", "pBufferInfo", indents + 1, dump_html_VkDescriptorBufferInfo); // ZRT
    else
        dump_html_special("UNUSED", settings, "const VkDescriptorBufferInfo*", "pBufferInfo", indents + 1);
    if((object.descriptorType == VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER) || (object.descriptorType == VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER))
    dump_html_array<const VkBufferView>(object.pTexelBufferView, object.descriptorCount, settings, "const VkBufferView*", "const VkBufferView", "pTexelBufferView", indents + 1, dump_html_VkBufferView); // ZRT
    else
        dump_html_special("UNUSED", settings, "const VkBufferView*", "pTexelBufferView", indents + 1);
}
void dump_html_VkAttachmentDescription(const VkAttachmentDescription& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkAttachmentDescriptionFlags>(object.flags, settings, "VkAttachmentDescriptionFlags", "flags", indents + 1, dump_html_VkAttachmentDescriptionFlags);
    dump_html_value<const VkFormat>(object.format, settings, "VkFormat", "format", indents + 1, dump_html_VkFormat);
    dump_html_value<const VkSampleCountFlagBits>(object.samples, settings, "VkSampleCountFlagBits", "samples", indents + 1, dump_html_VkSampleCountFlagBits);
    dump_html_value<const VkAttachmentLoadOp>(object.loadOp, settings, "VkAttachmentLoadOp", "loadOp", indents + 1, dump_html_VkAttachmentLoadOp);
    dump_html_value<const VkAttachmentStoreOp>(object.storeOp, settings, "VkAttachmentStoreOp", "storeOp", indents + 1, dump_html_VkAttachmentStoreOp);
    dump_html_value<const VkAttachmentLoadOp>(object.stencilLoadOp, settings, "VkAttachmentLoadOp", "stencilLoadOp", indents + 1, dump_html_VkAttachmentLoadOp);
    dump_html_value<const VkAttachmentStoreOp>(object.stencilStoreOp, settings, "VkAttachmentStoreOp", "stencilStoreOp", indents + 1, dump_html_VkAttachmentStoreOp);
    dump_html_value<const VkImageLayout>(object.initialLayout, settings, "VkImageLayout", "initialLayout", indents + 1, dump_html_VkImageLayout);
    dump_html_value<const VkImageLayout>(object.finalLayout, settings, "VkImageLayout", "finalLayout", indents + 1, dump_html_VkImageLayout);
}
void dump_html_VkAttachmentReference(const VkAttachmentReference& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const uint32_t>(object.attachment, settings, "uint32_t", "attachment", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkImageLayout>(object.layout, settings, "VkImageLayout", "layout", indents + 1, dump_html_VkImageLayout);
}
void dump_html_VkFramebufferCreateInfo(const VkFramebufferCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkFramebufferCreateFlags>(object.flags, settings, "VkFramebufferCreateFlags", "flags", indents + 1, dump_html_VkFramebufferCreateFlags);
    dump_html_value<const VkRenderPass>(object.renderPass, settings, "VkRenderPass", "renderPass", indents + 1, dump_html_VkRenderPass);
    dump_html_value<const uint32_t>(object.attachmentCount, settings, "uint32_t", "attachmentCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkImageView>(object.pAttachments, object.attachmentCount, settings, "const VkImageView*", "const VkImageView", "pAttachments", indents + 1, dump_html_VkImageView); // ZRT
    dump_html_value<const uint32_t>(object.width, settings, "uint32_t", "width", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.height, settings, "uint32_t", "height", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.layers, settings, "uint32_t", "layers", indents + 1, dump_html_uint32_t);
}
void dump_html_VkSubpassDescription(const VkSubpassDescription& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkSubpassDescriptionFlags>(object.flags, settings, "VkSubpassDescriptionFlags", "flags", indents + 1, dump_html_VkSubpassDescriptionFlags);
    dump_html_value<const VkPipelineBindPoint>(object.pipelineBindPoint, settings, "VkPipelineBindPoint", "pipelineBindPoint", indents + 1, dump_html_VkPipelineBindPoint);
    dump_html_value<const uint32_t>(object.inputAttachmentCount, settings, "uint32_t", "inputAttachmentCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkAttachmentReference>(object.pInputAttachments, object.inputAttachmentCount, settings, "const VkAttachmentReference*", "const VkAttachmentReference", "pInputAttachments", indents + 1, dump_html_VkAttachmentReference); // ZRT
    dump_html_value<const uint32_t>(object.colorAttachmentCount, settings, "uint32_t", "colorAttachmentCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkAttachmentReference>(object.pColorAttachments, object.colorAttachmentCount, settings, "const VkAttachmentReference*", "const VkAttachmentReference", "pColorAttachments", indents + 1, dump_html_VkAttachmentReference); // ZRT
    dump_html_array<const VkAttachmentReference>(object.pResolveAttachments, object.colorAttachmentCount, settings, "const VkAttachmentReference*", "const VkAttachmentReference", "pResolveAttachments", indents + 1, dump_html_VkAttachmentReference); // ZRT
    dump_html_pointer<const VkAttachmentReference>(object.pDepthStencilAttachment, settings, "const VkAttachmentReference*", "pDepthStencilAttachment", indents + 1, dump_html_VkAttachmentReference);
    dump_html_value<const uint32_t>(object.preserveAttachmentCount, settings, "uint32_t", "preserveAttachmentCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const uint32_t>(object.pPreserveAttachments, object.preserveAttachmentCount, settings, "const uint32_t*", "const uint32_t", "pPreserveAttachments", indents + 1, dump_html_uint32_t); // ZRT
}
void dump_html_VkSubpassDependency(const VkSubpassDependency& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const uint32_t>(object.srcSubpass, settings, "uint32_t", "srcSubpass", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.dstSubpass, settings, "uint32_t", "dstSubpass", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkPipelineStageFlags>(object.srcStageMask, settings, "VkPipelineStageFlags", "srcStageMask", indents + 1, dump_html_VkPipelineStageFlags);
    dump_html_value<const VkPipelineStageFlags>(object.dstStageMask, settings, "VkPipelineStageFlags", "dstStageMask", indents + 1, dump_html_VkPipelineStageFlags);
    dump_html_value<const VkAccessFlags>(object.srcAccessMask, settings, "VkAccessFlags", "srcAccessMask", indents + 1, dump_html_VkAccessFlags);
    dump_html_value<const VkAccessFlags>(object.dstAccessMask, settings, "VkAccessFlags", "dstAccessMask", indents + 1, dump_html_VkAccessFlags);
    dump_html_value<const VkDependencyFlags>(object.dependencyFlags, settings, "VkDependencyFlags", "dependencyFlags", indents + 1, dump_html_VkDependencyFlags);
}
void dump_html_VkRenderPassCreateInfo(const VkRenderPassCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkRenderPassCreateFlags>(object.flags, settings, "VkRenderPassCreateFlags", "flags", indents + 1, dump_html_VkRenderPassCreateFlags);
    dump_html_value<const uint32_t>(object.attachmentCount, settings, "uint32_t", "attachmentCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkAttachmentDescription>(object.pAttachments, object.attachmentCount, settings, "const VkAttachmentDescription*", "const VkAttachmentDescription", "pAttachments", indents + 1, dump_html_VkAttachmentDescription); // ZRT
    dump_html_value<const uint32_t>(object.subpassCount, settings, "uint32_t", "subpassCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkSubpassDescription>(object.pSubpasses, object.subpassCount, settings, "const VkSubpassDescription*", "const VkSubpassDescription", "pSubpasses", indents + 1, dump_html_VkSubpassDescription); // ZRT
    dump_html_value<const uint32_t>(object.dependencyCount, settings, "uint32_t", "dependencyCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkSubpassDependency>(object.pDependencies, object.dependencyCount, settings, "const VkSubpassDependency*", "const VkSubpassDependency", "pDependencies", indents + 1, dump_html_VkSubpassDependency); // ZRT
}
void dump_html_VkCommandPoolCreateInfo(const VkCommandPoolCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkCommandPoolCreateFlags>(object.flags, settings, "VkCommandPoolCreateFlags", "flags", indents + 1, dump_html_VkCommandPoolCreateFlags);
    dump_html_value<const uint32_t>(object.queueFamilyIndex, settings, "uint32_t", "queueFamilyIndex", indents + 1, dump_html_uint32_t);
}
void dump_html_VkCommandBufferAllocateInfo(const VkCommandBufferAllocateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkCommandPool>(object.commandPool, settings, "VkCommandPool", "commandPool", indents + 1, dump_html_VkCommandPool);
    dump_html_value<const VkCommandBufferLevel>(object.level, settings, "VkCommandBufferLevel", "level", indents + 1, dump_html_VkCommandBufferLevel);
    dump_html_value<const uint32_t>(object.commandBufferCount, settings, "uint32_t", "commandBufferCount", indents + 1, dump_html_uint32_t);
}
void dump_html_VkCommandBufferInheritanceInfo(const VkCommandBufferInheritanceInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkRenderPass>(object.renderPass, settings, "VkRenderPass", "renderPass", indents + 1, dump_html_VkRenderPass);
    dump_html_value<const uint32_t>(object.subpass, settings, "uint32_t", "subpass", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkFramebuffer>(object.framebuffer, settings, "VkFramebuffer", "framebuffer", indents + 1, dump_html_VkFramebuffer);
    dump_html_value<const VkBool32>(object.occlusionQueryEnable, settings, "VkBool32", "occlusionQueryEnable", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkQueryControlFlags>(object.queryFlags, settings, "VkQueryControlFlags", "queryFlags", indents + 1, dump_html_VkQueryControlFlags);
    dump_html_value<const VkQueryPipelineStatisticFlags>(object.pipelineStatistics, settings, "VkQueryPipelineStatisticFlags", "pipelineStatistics", indents + 1, dump_html_VkQueryPipelineStatisticFlags);
}
void dump_html_VkCommandBufferBeginInfo(const VkCommandBufferBeginInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkCommandBufferUsageFlags>(object.flags, settings, "VkCommandBufferUsageFlags", "flags", indents + 1, dump_html_VkCommandBufferUsageFlags);
    if(ApiDumpInstance::current().getCmdBufferLevel() == VK_COMMAND_BUFFER_LEVEL_SECONDARY)
    dump_html_pointer<const VkCommandBufferInheritanceInfo>(object.pInheritanceInfo, settings, "const VkCommandBufferInheritanceInfo*", "pInheritanceInfo", indents + 1, dump_html_VkCommandBufferInheritanceInfo);
    else
        dump_html_special("UNUSED", settings, "const VkCommandBufferInheritanceInfo*", "pInheritanceInfo", indents + 1);
}
void dump_html_VkBufferCopy(const VkBufferCopy& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkDeviceSize>(object.srcOffset, settings, "VkDeviceSize", "srcOffset", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceSize>(object.dstOffset, settings, "VkDeviceSize", "dstOffset", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceSize>(object.size, settings, "VkDeviceSize", "size", indents + 1, dump_html_VkDeviceSize);
}
void dump_html_VkImageSubresourceLayers(const VkImageSubresourceLayers& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkImageAspectFlags>(object.aspectMask, settings, "VkImageAspectFlags", "aspectMask", indents + 1, dump_html_VkImageAspectFlags);
    dump_html_value<const uint32_t>(object.mipLevel, settings, "uint32_t", "mipLevel", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.baseArrayLayer, settings, "uint32_t", "baseArrayLayer", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.layerCount, settings, "uint32_t", "layerCount", indents + 1, dump_html_uint32_t);
}
void dump_html_VkBufferImageCopy(const VkBufferImageCopy& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkDeviceSize>(object.bufferOffset, settings, "VkDeviceSize", "bufferOffset", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const uint32_t>(object.bufferRowLength, settings, "uint32_t", "bufferRowLength", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.bufferImageHeight, settings, "uint32_t", "bufferImageHeight", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkImageSubresourceLayers>(object.imageSubresource, settings, "VkImageSubresourceLayers", "imageSubresource", indents + 1, dump_html_VkImageSubresourceLayers);
    dump_html_value<const VkOffset3D>(object.imageOffset, settings, "VkOffset3D", "imageOffset", indents + 1, dump_html_VkOffset3D);
    dump_html_value<const VkExtent3D>(object.imageExtent, settings, "VkExtent3D", "imageExtent", indents + 1, dump_html_VkExtent3D);
}
void dump_html_VkClearDepthStencilValue(const VkClearDepthStencilValue& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const float>(object.depth, settings, "float", "depth", indents + 1, dump_html_float);
    dump_html_value<const uint32_t>(object.stencil, settings, "uint32_t", "stencil", indents + 1, dump_html_uint32_t);
}
void dump_html_VkClearAttachment(const VkClearAttachment& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkImageAspectFlags>(object.aspectMask, settings, "VkImageAspectFlags", "aspectMask", indents + 1, dump_html_VkImageAspectFlags);
    dump_html_value<const uint32_t>(object.colorAttachment, settings, "uint32_t", "colorAttachment", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkClearValue>(object.clearValue, settings, "VkClearValue", "clearValue", indents + 1, dump_html_VkClearValue);
}
void dump_html_VkClearRect(const VkClearRect& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkRect2D>(object.rect, settings, "VkRect2D", "rect", indents + 1, dump_html_VkRect2D);
    dump_html_value<const uint32_t>(object.baseArrayLayer, settings, "uint32_t", "baseArrayLayer", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.layerCount, settings, "uint32_t", "layerCount", indents + 1, dump_html_uint32_t);
}
void dump_html_VkImageBlit(const VkImageBlit& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkImageSubresourceLayers>(object.srcSubresource, settings, "VkImageSubresourceLayers", "srcSubresource", indents + 1, dump_html_VkImageSubresourceLayers);
    dump_html_array<const VkOffset3D>(object.srcOffsets, 2, settings, "VkOffset3D[2]", "VkOffset3D", "srcOffsets", indents + 1, dump_html_VkOffset3D); // ZRR
    dump_html_value<const VkImageSubresourceLayers>(object.dstSubresource, settings, "VkImageSubresourceLayers", "dstSubresource", indents + 1, dump_html_VkImageSubresourceLayers);
    dump_html_array<const VkOffset3D>(object.dstOffsets, 2, settings, "VkOffset3D[2]", "VkOffset3D", "dstOffsets", indents + 1, dump_html_VkOffset3D); // ZRR
}
void dump_html_VkImageCopy(const VkImageCopy& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkImageSubresourceLayers>(object.srcSubresource, settings, "VkImageSubresourceLayers", "srcSubresource", indents + 1, dump_html_VkImageSubresourceLayers);
    dump_html_value<const VkOffset3D>(object.srcOffset, settings, "VkOffset3D", "srcOffset", indents + 1, dump_html_VkOffset3D);
    dump_html_value<const VkImageSubresourceLayers>(object.dstSubresource, settings, "VkImageSubresourceLayers", "dstSubresource", indents + 1, dump_html_VkImageSubresourceLayers);
    dump_html_value<const VkOffset3D>(object.dstOffset, settings, "VkOffset3D", "dstOffset", indents + 1, dump_html_VkOffset3D);
    dump_html_value<const VkExtent3D>(object.extent, settings, "VkExtent3D", "extent", indents + 1, dump_html_VkExtent3D);
}
void dump_html_VkImageResolve(const VkImageResolve& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkImageSubresourceLayers>(object.srcSubresource, settings, "VkImageSubresourceLayers", "srcSubresource", indents + 1, dump_html_VkImageSubresourceLayers);
    dump_html_value<const VkOffset3D>(object.srcOffset, settings, "VkOffset3D", "srcOffset", indents + 1, dump_html_VkOffset3D);
    dump_html_value<const VkImageSubresourceLayers>(object.dstSubresource, settings, "VkImageSubresourceLayers", "dstSubresource", indents + 1, dump_html_VkImageSubresourceLayers);
    dump_html_value<const VkOffset3D>(object.dstOffset, settings, "VkOffset3D", "dstOffset", indents + 1, dump_html_VkOffset3D);
    dump_html_value<const VkExtent3D>(object.extent, settings, "VkExtent3D", "extent", indents + 1, dump_html_VkExtent3D);
}
void dump_html_VkRenderPassBeginInfo(const VkRenderPassBeginInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkRenderPass>(object.renderPass, settings, "VkRenderPass", "renderPass", indents + 1, dump_html_VkRenderPass);
    dump_html_value<const VkFramebuffer>(object.framebuffer, settings, "VkFramebuffer", "framebuffer", indents + 1, dump_html_VkFramebuffer);
    dump_html_value<const VkRect2D>(object.renderArea, settings, "VkRect2D", "renderArea", indents + 1, dump_html_VkRect2D);
    dump_html_value<const uint32_t>(object.clearValueCount, settings, "uint32_t", "clearValueCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkClearValue>(object.pClearValues, object.clearValueCount, settings, "const VkClearValue*", "const VkClearValue", "pClearValues", indents + 1, dump_html_VkClearValue); // ZRT
}
void dump_html_VkPhysicalDeviceSubgroupProperties(const VkPhysicalDeviceSubgroupProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.subgroupSize, settings, "uint32_t", "subgroupSize", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkShaderStageFlags>(object.supportedStages, settings, "VkShaderStageFlags", "supportedStages", indents + 1, dump_html_VkShaderStageFlags);
    dump_html_value<const VkSubgroupFeatureFlags>(object.supportedOperations, settings, "VkSubgroupFeatureFlags", "supportedOperations", indents + 1, dump_html_VkSubgroupFeatureFlags);
    dump_html_value<const VkBool32>(object.quadOperationsInAllStages, settings, "VkBool32", "quadOperationsInAllStages", indents + 1, dump_html_VkBool32);
}
void dump_html_VkBindBufferMemoryInfo(const VkBindBufferMemoryInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBuffer>(object.buffer, settings, "VkBuffer", "buffer", indents + 1, dump_html_VkBuffer);
    dump_html_value<const VkDeviceMemory>(object.memory, settings, "VkDeviceMemory", "memory", indents + 1, dump_html_VkDeviceMemory);
    dump_html_value<const VkDeviceSize>(object.memoryOffset, settings, "VkDeviceSize", "memoryOffset", indents + 1, dump_html_VkDeviceSize);
}
void dump_html_VkBindImageMemoryInfo(const VkBindImageMemoryInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkImage>(object.image, settings, "VkImage", "image", indents + 1, dump_html_VkImage);
    dump_html_value<const VkDeviceMemory>(object.memory, settings, "VkDeviceMemory", "memory", indents + 1, dump_html_VkDeviceMemory);
    dump_html_value<const VkDeviceSize>(object.memoryOffset, settings, "VkDeviceSize", "memoryOffset", indents + 1, dump_html_VkDeviceSize);
}
void dump_html_VkPhysicalDevice16BitStorageFeatures(const VkPhysicalDevice16BitStorageFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.storageBuffer16BitAccess, settings, "VkBool32", "storageBuffer16BitAccess", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.uniformAndStorageBuffer16BitAccess, settings, "VkBool32", "uniformAndStorageBuffer16BitAccess", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.storagePushConstant16, settings, "VkBool32", "storagePushConstant16", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.storageInputOutput16, settings, "VkBool32", "storageInputOutput16", indents + 1, dump_html_VkBool32);
}
void dump_html_VkMemoryDedicatedRequirements(const VkMemoryDedicatedRequirements& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.prefersDedicatedAllocation, settings, "VkBool32", "prefersDedicatedAllocation", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.requiresDedicatedAllocation, settings, "VkBool32", "requiresDedicatedAllocation", indents + 1, dump_html_VkBool32);
}
void dump_html_VkMemoryDedicatedAllocateInfo(const VkMemoryDedicatedAllocateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkImage>(object.image, settings, "VkImage", "image", indents + 1, dump_html_VkImage);
    dump_html_value<const VkBuffer>(object.buffer, settings, "VkBuffer", "buffer", indents + 1, dump_html_VkBuffer);
}
void dump_html_VkMemoryAllocateFlagsInfo(const VkMemoryAllocateFlagsInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkMemoryAllocateFlags>(object.flags, settings, "VkMemoryAllocateFlags", "flags", indents + 1, dump_html_VkMemoryAllocateFlags);
    dump_html_value<const uint32_t>(object.deviceMask, settings, "uint32_t", "deviceMask", indents + 1, dump_html_uint32_t);
}
void dump_html_VkDeviceGroupRenderPassBeginInfo(const VkDeviceGroupRenderPassBeginInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.deviceMask, settings, "uint32_t", "deviceMask", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.deviceRenderAreaCount, settings, "uint32_t", "deviceRenderAreaCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkRect2D>(object.pDeviceRenderAreas, object.deviceRenderAreaCount, settings, "const VkRect2D*", "const VkRect2D", "pDeviceRenderAreas", indents + 1, dump_html_VkRect2D); // ZRT
}
void dump_html_VkDeviceGroupCommandBufferBeginInfo(const VkDeviceGroupCommandBufferBeginInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.deviceMask, settings, "uint32_t", "deviceMask", indents + 1, dump_html_uint32_t);
}
void dump_html_VkDeviceGroupSubmitInfo(const VkDeviceGroupSubmitInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.waitSemaphoreCount, settings, "uint32_t", "waitSemaphoreCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const uint32_t>(object.pWaitSemaphoreDeviceIndices, object.waitSemaphoreCount, settings, "const uint32_t*", "const uint32_t", "pWaitSemaphoreDeviceIndices", indents + 1, dump_html_uint32_t); // ZRT
    dump_html_value<const uint32_t>(object.commandBufferCount, settings, "uint32_t", "commandBufferCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const uint32_t>(object.pCommandBufferDeviceMasks, object.commandBufferCount, settings, "const uint32_t*", "const uint32_t", "pCommandBufferDeviceMasks", indents + 1, dump_html_uint32_t); // ZRT
    dump_html_value<const uint32_t>(object.signalSemaphoreCount, settings, "uint32_t", "signalSemaphoreCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const uint32_t>(object.pSignalSemaphoreDeviceIndices, object.signalSemaphoreCount, settings, "const uint32_t*", "const uint32_t", "pSignalSemaphoreDeviceIndices", indents + 1, dump_html_uint32_t); // ZRT
}
void dump_html_VkDeviceGroupBindSparseInfo(const VkDeviceGroupBindSparseInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.resourceDeviceIndex, settings, "uint32_t", "resourceDeviceIndex", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.memoryDeviceIndex, settings, "uint32_t", "memoryDeviceIndex", indents + 1, dump_html_uint32_t);
}
void dump_html_VkBindBufferMemoryDeviceGroupInfo(const VkBindBufferMemoryDeviceGroupInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.deviceIndexCount, settings, "uint32_t", "deviceIndexCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const uint32_t>(object.pDeviceIndices, object.deviceIndexCount, settings, "const uint32_t*", "const uint32_t", "pDeviceIndices", indents + 1, dump_html_uint32_t); // ZRT
}
void dump_html_VkBindImageMemoryDeviceGroupInfo(const VkBindImageMemoryDeviceGroupInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.deviceIndexCount, settings, "uint32_t", "deviceIndexCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const uint32_t>(object.pDeviceIndices, object.deviceIndexCount, settings, "const uint32_t*", "const uint32_t", "pDeviceIndices", indents + 1, dump_html_uint32_t); // ZRT
    dump_html_value<const uint32_t>(object.splitInstanceBindRegionCount, settings, "uint32_t", "splitInstanceBindRegionCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkRect2D>(object.pSplitInstanceBindRegions, object.splitInstanceBindRegionCount, settings, "const VkRect2D*", "const VkRect2D", "pSplitInstanceBindRegions", indents + 1, dump_html_VkRect2D); // ZRT
}
void dump_html_VkPhysicalDeviceGroupProperties(const VkPhysicalDeviceGroupProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.physicalDeviceCount, settings, "uint32_t", "physicalDeviceCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkPhysicalDevice>(object.physicalDevices, object.physicalDeviceCount, settings, "VkPhysicalDevice[VK_MAX_DEVICE_GROUP_SIZE]", "VkPhysicalDevice", "physicalDevices", indents + 1, dump_html_VkPhysicalDevice); // ZRT
    dump_html_value<const VkBool32>(object.subsetAllocation, settings, "VkBool32", "subsetAllocation", indents + 1, dump_html_VkBool32);
}
void dump_html_VkDeviceGroupDeviceCreateInfo(const VkDeviceGroupDeviceCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.physicalDeviceCount, settings, "uint32_t", "physicalDeviceCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkPhysicalDevice>(object.pPhysicalDevices, object.physicalDeviceCount, settings, "const VkPhysicalDevice*", "const VkPhysicalDevice", "pPhysicalDevices", indents + 1, dump_html_VkPhysicalDevice); // ZRT
}
void dump_html_VkBufferMemoryRequirementsInfo2(const VkBufferMemoryRequirementsInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBuffer>(object.buffer, settings, "VkBuffer", "buffer", indents + 1, dump_html_VkBuffer);
}
void dump_html_VkImageMemoryRequirementsInfo2(const VkImageMemoryRequirementsInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkImage>(object.image, settings, "VkImage", "image", indents + 1, dump_html_VkImage);
}
void dump_html_VkImageSparseMemoryRequirementsInfo2(const VkImageSparseMemoryRequirementsInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkImage>(object.image, settings, "VkImage", "image", indents + 1, dump_html_VkImage);
}
void dump_html_VkMemoryRequirements2(const VkMemoryRequirements2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkMemoryRequirements>(object.memoryRequirements, settings, "VkMemoryRequirements", "memoryRequirements", indents + 1, dump_html_VkMemoryRequirements);
}
void dump_html_VkSparseImageMemoryRequirements2(const VkSparseImageMemoryRequirements2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkSparseImageMemoryRequirements>(object.memoryRequirements, settings, "VkSparseImageMemoryRequirements", "memoryRequirements", indents + 1, dump_html_VkSparseImageMemoryRequirements);
}
void dump_html_VkPhysicalDeviceFeatures2(const VkPhysicalDeviceFeatures2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkPhysicalDeviceFeatures>(object.features, settings, "VkPhysicalDeviceFeatures", "features", indents + 1, dump_html_VkPhysicalDeviceFeatures);
}
void dump_html_VkPhysicalDeviceProperties2(const VkPhysicalDeviceProperties2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkPhysicalDeviceProperties>(object.properties, settings, "VkPhysicalDeviceProperties", "properties", indents + 1, dump_html_VkPhysicalDeviceProperties);
}
void dump_html_VkFormatProperties2(const VkFormatProperties2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkFormatProperties>(object.formatProperties, settings, "VkFormatProperties", "formatProperties", indents + 1, dump_html_VkFormatProperties);
}
void dump_html_VkImageFormatProperties2(const VkImageFormatProperties2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkImageFormatProperties>(object.imageFormatProperties, settings, "VkImageFormatProperties", "imageFormatProperties", indents + 1, dump_html_VkImageFormatProperties);
}
void dump_html_VkPhysicalDeviceImageFormatInfo2(const VkPhysicalDeviceImageFormatInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkFormat>(object.format, settings, "VkFormat", "format", indents + 1, dump_html_VkFormat);
    dump_html_value<const VkImageType>(object.type, settings, "VkImageType", "type", indents + 1, dump_html_VkImageType);
    dump_html_value<const VkImageTiling>(object.tiling, settings, "VkImageTiling", "tiling", indents + 1, dump_html_VkImageTiling);
    dump_html_value<const VkImageUsageFlags>(object.usage, settings, "VkImageUsageFlags", "usage", indents + 1, dump_html_VkImageUsageFlags);
    dump_html_value<const VkImageCreateFlags>(object.flags, settings, "VkImageCreateFlags", "flags", indents + 1, dump_html_VkImageCreateFlags);
}
void dump_html_VkQueueFamilyProperties2(const VkQueueFamilyProperties2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkQueueFamilyProperties>(object.queueFamilyProperties, settings, "VkQueueFamilyProperties", "queueFamilyProperties", indents + 1, dump_html_VkQueueFamilyProperties);
}
void dump_html_VkPhysicalDeviceMemoryProperties2(const VkPhysicalDeviceMemoryProperties2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    ApiDumpInstance::current().setMemoryHeapCount(object.memoryProperties.memoryHeapCount);
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkPhysicalDeviceMemoryProperties>(object.memoryProperties, settings, "VkPhysicalDeviceMemoryProperties", "memoryProperties", indents + 1, dump_html_VkPhysicalDeviceMemoryProperties);
}
void dump_html_VkSparseImageFormatProperties2(const VkSparseImageFormatProperties2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkSparseImageFormatProperties>(object.properties, settings, "VkSparseImageFormatProperties", "properties", indents + 1, dump_html_VkSparseImageFormatProperties);
}
void dump_html_VkPhysicalDeviceSparseImageFormatInfo2(const VkPhysicalDeviceSparseImageFormatInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkFormat>(object.format, settings, "VkFormat", "format", indents + 1, dump_html_VkFormat);
    dump_html_value<const VkImageType>(object.type, settings, "VkImageType", "type", indents + 1, dump_html_VkImageType);
    dump_html_value<const VkSampleCountFlagBits>(object.samples, settings, "VkSampleCountFlagBits", "samples", indents + 1, dump_html_VkSampleCountFlagBits);
    dump_html_value<const VkImageUsageFlags>(object.usage, settings, "VkImageUsageFlags", "usage", indents + 1, dump_html_VkImageUsageFlags);
    dump_html_value<const VkImageTiling>(object.tiling, settings, "VkImageTiling", "tiling", indents + 1, dump_html_VkImageTiling);
}
void dump_html_VkPhysicalDevicePointClippingProperties(const VkPhysicalDevicePointClippingProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkPointClippingBehavior>(object.pointClippingBehavior, settings, "VkPointClippingBehavior", "pointClippingBehavior", indents + 1, dump_html_VkPointClippingBehavior);
}
void dump_html_VkInputAttachmentAspectReference(const VkInputAttachmentAspectReference& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const uint32_t>(object.subpass, settings, "uint32_t", "subpass", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.inputAttachmentIndex, settings, "uint32_t", "inputAttachmentIndex", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkImageAspectFlags>(object.aspectMask, settings, "VkImageAspectFlags", "aspectMask", indents + 1, dump_html_VkImageAspectFlags);
}
void dump_html_VkRenderPassInputAttachmentAspectCreateInfo(const VkRenderPassInputAttachmentAspectCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.aspectReferenceCount, settings, "uint32_t", "aspectReferenceCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkInputAttachmentAspectReference>(object.pAspectReferences, object.aspectReferenceCount, settings, "const VkInputAttachmentAspectReference*", "const VkInputAttachmentAspectReference", "pAspectReferences", indents + 1, dump_html_VkInputAttachmentAspectReference); // ZRT
}
void dump_html_VkImageViewUsageCreateInfo(const VkImageViewUsageCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkImageUsageFlags>(object.usage, settings, "VkImageUsageFlags", "usage", indents + 1, dump_html_VkImageUsageFlags);
}
void dump_html_VkPipelineTessellationDomainOriginStateCreateInfo(const VkPipelineTessellationDomainOriginStateCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkTessellationDomainOrigin>(object.domainOrigin, settings, "VkTessellationDomainOrigin", "domainOrigin", indents + 1, dump_html_VkTessellationDomainOrigin);
}
void dump_html_VkRenderPassMultiviewCreateInfo(const VkRenderPassMultiviewCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.subpassCount, settings, "uint32_t", "subpassCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const uint32_t>(object.pViewMasks, object.subpassCount, settings, "const uint32_t*", "const uint32_t", "pViewMasks", indents + 1, dump_html_uint32_t); // ZRT
    dump_html_value<const uint32_t>(object.dependencyCount, settings, "uint32_t", "dependencyCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const int32_t>(object.pViewOffsets, object.dependencyCount, settings, "const int32_t*", "const int32_t", "pViewOffsets", indents + 1, dump_html_int32_t); // ZRT
    dump_html_value<const uint32_t>(object.correlationMaskCount, settings, "uint32_t", "correlationMaskCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const uint32_t>(object.pCorrelationMasks, object.correlationMaskCount, settings, "const uint32_t*", "const uint32_t", "pCorrelationMasks", indents + 1, dump_html_uint32_t); // ZRT
}
void dump_html_VkPhysicalDeviceMultiviewFeatures(const VkPhysicalDeviceMultiviewFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.multiview, settings, "VkBool32", "multiview", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.multiviewGeometryShader, settings, "VkBool32", "multiviewGeometryShader", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.multiviewTessellationShader, settings, "VkBool32", "multiviewTessellationShader", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceMultiviewProperties(const VkPhysicalDeviceMultiviewProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.maxMultiviewViewCount, settings, "uint32_t", "maxMultiviewViewCount", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxMultiviewInstanceIndex, settings, "uint32_t", "maxMultiviewInstanceIndex", indents + 1, dump_html_uint32_t);
}
void dump_html_VkPhysicalDeviceVariablePointersFeatures(const VkPhysicalDeviceVariablePointersFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.variablePointersStorageBuffer, settings, "VkBool32", "variablePointersStorageBuffer", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.variablePointers, settings, "VkBool32", "variablePointers", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceProtectedMemoryFeatures(const VkPhysicalDeviceProtectedMemoryFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.protectedMemory, settings, "VkBool32", "protectedMemory", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceProtectedMemoryProperties(const VkPhysicalDeviceProtectedMemoryProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.protectedNoFault, settings, "VkBool32", "protectedNoFault", indents + 1, dump_html_VkBool32);
}
void dump_html_VkDeviceQueueInfo2(const VkDeviceQueueInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDeviceQueueCreateFlags>(object.flags, settings, "VkDeviceQueueCreateFlags", "flags", indents + 1, dump_html_VkDeviceQueueCreateFlags);
    dump_html_value<const uint32_t>(object.queueFamilyIndex, settings, "uint32_t", "queueFamilyIndex", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.queueIndex, settings, "uint32_t", "queueIndex", indents + 1, dump_html_uint32_t);
}
void dump_html_VkProtectedSubmitInfo(const VkProtectedSubmitInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.protectedSubmit, settings, "VkBool32", "protectedSubmit", indents + 1, dump_html_VkBool32);
}
void dump_html_VkSamplerYcbcrConversionCreateInfo(const VkSamplerYcbcrConversionCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkFormat>(object.format, settings, "VkFormat", "format", indents + 1, dump_html_VkFormat);
    dump_html_value<const VkSamplerYcbcrModelConversion>(object.ycbcrModel, settings, "VkSamplerYcbcrModelConversion", "ycbcrModel", indents + 1, dump_html_VkSamplerYcbcrModelConversion);
    dump_html_value<const VkSamplerYcbcrRange>(object.ycbcrRange, settings, "VkSamplerYcbcrRange", "ycbcrRange", indents + 1, dump_html_VkSamplerYcbcrRange);
    dump_html_value<const VkComponentMapping>(object.components, settings, "VkComponentMapping", "components", indents + 1, dump_html_VkComponentMapping);
    dump_html_value<const VkChromaLocation>(object.xChromaOffset, settings, "VkChromaLocation", "xChromaOffset", indents + 1, dump_html_VkChromaLocation);
    dump_html_value<const VkChromaLocation>(object.yChromaOffset, settings, "VkChromaLocation", "yChromaOffset", indents + 1, dump_html_VkChromaLocation);
    dump_html_value<const VkFilter>(object.chromaFilter, settings, "VkFilter", "chromaFilter", indents + 1, dump_html_VkFilter);
    dump_html_value<const VkBool32>(object.forceExplicitReconstruction, settings, "VkBool32", "forceExplicitReconstruction", indents + 1, dump_html_VkBool32);
}
void dump_html_VkSamplerYcbcrConversionInfo(const VkSamplerYcbcrConversionInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkSamplerYcbcrConversion>(object.conversion, settings, "VkSamplerYcbcrConversion", "conversion", indents + 1, dump_html_VkSamplerYcbcrConversion);
}
void dump_html_VkBindImagePlaneMemoryInfo(const VkBindImagePlaneMemoryInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkImageAspectFlagBits>(object.planeAspect, settings, "VkImageAspectFlagBits", "planeAspect", indents + 1, dump_html_VkImageAspectFlagBits);
}
void dump_html_VkImagePlaneMemoryRequirementsInfo(const VkImagePlaneMemoryRequirementsInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkImageAspectFlagBits>(object.planeAspect, settings, "VkImageAspectFlagBits", "planeAspect", indents + 1, dump_html_VkImageAspectFlagBits);
}
void dump_html_VkPhysicalDeviceSamplerYcbcrConversionFeatures(const VkPhysicalDeviceSamplerYcbcrConversionFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.samplerYcbcrConversion, settings, "VkBool32", "samplerYcbcrConversion", indents + 1, dump_html_VkBool32);
}
void dump_html_VkSamplerYcbcrConversionImageFormatProperties(const VkSamplerYcbcrConversionImageFormatProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.combinedImageSamplerDescriptorCount, settings, "uint32_t", "combinedImageSamplerDescriptorCount", indents + 1, dump_html_uint32_t);
}
void dump_html_VkDescriptorUpdateTemplateEntry(const VkDescriptorUpdateTemplateEntry& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const uint32_t>(object.dstBinding, settings, "uint32_t", "dstBinding", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.dstArrayElement, settings, "uint32_t", "dstArrayElement", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.descriptorCount, settings, "uint32_t", "descriptorCount", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkDescriptorType>(object.descriptorType, settings, "VkDescriptorType", "descriptorType", indents + 1, dump_html_VkDescriptorType);
    dump_html_value<const size_t>(object.offset, settings, "size_t", "offset", indents + 1, dump_html_size_t);
    dump_html_value<const size_t>(object.stride, settings, "size_t", "stride", indents + 1, dump_html_size_t);
}
void dump_html_VkDescriptorUpdateTemplateCreateInfo(const VkDescriptorUpdateTemplateCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDescriptorUpdateTemplateCreateFlags>(object.flags, settings, "VkDescriptorUpdateTemplateCreateFlags", "flags", indents + 1, dump_html_VkDescriptorUpdateTemplateCreateFlags);
    dump_html_value<const uint32_t>(object.descriptorUpdateEntryCount, settings, "uint32_t", "descriptorUpdateEntryCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkDescriptorUpdateTemplateEntry>(object.pDescriptorUpdateEntries, object.descriptorUpdateEntryCount, settings, "const VkDescriptorUpdateTemplateEntry*", "const VkDescriptorUpdateTemplateEntry", "pDescriptorUpdateEntries", indents + 1, dump_html_VkDescriptorUpdateTemplateEntry); // ZRT
    dump_html_value<const VkDescriptorUpdateTemplateType>(object.templateType, settings, "VkDescriptorUpdateTemplateType", "templateType", indents + 1, dump_html_VkDescriptorUpdateTemplateType);
    dump_html_value<const VkDescriptorSetLayout>(object.descriptorSetLayout, settings, "VkDescriptorSetLayout", "descriptorSetLayout", indents + 1, dump_html_VkDescriptorSetLayout);
    dump_html_value<const VkPipelineBindPoint>(object.pipelineBindPoint, settings, "VkPipelineBindPoint", "pipelineBindPoint", indents + 1, dump_html_VkPipelineBindPoint);
    dump_html_value<const VkPipelineLayout>(object.pipelineLayout, settings, "VkPipelineLayout", "pipelineLayout", indents + 1, dump_html_VkPipelineLayout);
    dump_html_value<const uint32_t>(object.set, settings, "uint32_t", "set", indents + 1, dump_html_uint32_t);
}
void dump_html_VkExternalMemoryProperties(const VkExternalMemoryProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkExternalMemoryFeatureFlags>(object.externalMemoryFeatures, settings, "VkExternalMemoryFeatureFlags", "externalMemoryFeatures", indents + 1, dump_html_VkExternalMemoryFeatureFlags);
    dump_html_value<const VkExternalMemoryHandleTypeFlags>(object.exportFromImportedHandleTypes, settings, "VkExternalMemoryHandleTypeFlags", "exportFromImportedHandleTypes", indents + 1, dump_html_VkExternalMemoryHandleTypeFlags);
    dump_html_value<const VkExternalMemoryHandleTypeFlags>(object.compatibleHandleTypes, settings, "VkExternalMemoryHandleTypeFlags", "compatibleHandleTypes", indents + 1, dump_html_VkExternalMemoryHandleTypeFlags);
}
void dump_html_VkPhysicalDeviceExternalImageFormatInfo(const VkPhysicalDeviceExternalImageFormatInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkExternalMemoryHandleTypeFlagBits>(object.handleType, settings, "VkExternalMemoryHandleTypeFlagBits", "handleType", indents + 1, dump_html_VkExternalMemoryHandleTypeFlagBits);
}
void dump_html_VkExternalImageFormatProperties(const VkExternalImageFormatProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkExternalMemoryProperties>(object.externalMemoryProperties, settings, "VkExternalMemoryProperties", "externalMemoryProperties", indents + 1, dump_html_VkExternalMemoryProperties);
}
void dump_html_VkPhysicalDeviceExternalBufferInfo(const VkPhysicalDeviceExternalBufferInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBufferCreateFlags>(object.flags, settings, "VkBufferCreateFlags", "flags", indents + 1, dump_html_VkBufferCreateFlags);
    dump_html_value<const VkBufferUsageFlags>(object.usage, settings, "VkBufferUsageFlags", "usage", indents + 1, dump_html_VkBufferUsageFlags);
    dump_html_value<const VkExternalMemoryHandleTypeFlagBits>(object.handleType, settings, "VkExternalMemoryHandleTypeFlagBits", "handleType", indents + 1, dump_html_VkExternalMemoryHandleTypeFlagBits);
}
void dump_html_VkExternalBufferProperties(const VkExternalBufferProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkExternalMemoryProperties>(object.externalMemoryProperties, settings, "VkExternalMemoryProperties", "externalMemoryProperties", indents + 1, dump_html_VkExternalMemoryProperties);
}
void dump_html_VkPhysicalDeviceIDProperties(const VkPhysicalDeviceIDProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_array<const uint8_t>(object.deviceUUID, 16, settings, "uint8_t[VK_UUID_SIZE]", "uint8_t", "deviceUUID", indents + 1, dump_html_uint8_t); // ZRR
    dump_html_array<const uint8_t>(object.driverUUID, 16, settings, "uint8_t[VK_UUID_SIZE]", "uint8_t", "driverUUID", indents + 1, dump_html_uint8_t); // ZRR
    dump_html_array<const uint8_t>(object.deviceLUID, 8, settings, "uint8_t[VK_LUID_SIZE]", "uint8_t", "deviceLUID", indents + 1, dump_html_uint8_t); // ZRR
    dump_html_value<const uint32_t>(object.deviceNodeMask, settings, "uint32_t", "deviceNodeMask", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkBool32>(object.deviceLUIDValid, settings, "VkBool32", "deviceLUIDValid", indents + 1, dump_html_VkBool32);
}
void dump_html_VkExternalMemoryImageCreateInfo(const VkExternalMemoryImageCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkExternalMemoryHandleTypeFlags>(object.handleTypes, settings, "VkExternalMemoryHandleTypeFlags", "handleTypes", indents + 1, dump_html_VkExternalMemoryHandleTypeFlags);
}
void dump_html_VkExternalMemoryBufferCreateInfo(const VkExternalMemoryBufferCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkExternalMemoryHandleTypeFlags>(object.handleTypes, settings, "VkExternalMemoryHandleTypeFlags", "handleTypes", indents + 1, dump_html_VkExternalMemoryHandleTypeFlags);
}
void dump_html_VkExportMemoryAllocateInfo(const VkExportMemoryAllocateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkExternalMemoryHandleTypeFlags>(object.handleTypes, settings, "VkExternalMemoryHandleTypeFlags", "handleTypes", indents + 1, dump_html_VkExternalMemoryHandleTypeFlags);
}
void dump_html_VkPhysicalDeviceExternalFenceInfo(const VkPhysicalDeviceExternalFenceInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkExternalFenceHandleTypeFlagBits>(object.handleType, settings, "VkExternalFenceHandleTypeFlagBits", "handleType", indents + 1, dump_html_VkExternalFenceHandleTypeFlagBits);
}
void dump_html_VkExternalFenceProperties(const VkExternalFenceProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkExternalFenceHandleTypeFlags>(object.exportFromImportedHandleTypes, settings, "VkExternalFenceHandleTypeFlags", "exportFromImportedHandleTypes", indents + 1, dump_html_VkExternalFenceHandleTypeFlags);
    dump_html_value<const VkExternalFenceHandleTypeFlags>(object.compatibleHandleTypes, settings, "VkExternalFenceHandleTypeFlags", "compatibleHandleTypes", indents + 1, dump_html_VkExternalFenceHandleTypeFlags);
    dump_html_value<const VkExternalFenceFeatureFlags>(object.externalFenceFeatures, settings, "VkExternalFenceFeatureFlags", "externalFenceFeatures", indents + 1, dump_html_VkExternalFenceFeatureFlags);
}
void dump_html_VkExportFenceCreateInfo(const VkExportFenceCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkExternalFenceHandleTypeFlags>(object.handleTypes, settings, "VkExternalFenceHandleTypeFlags", "handleTypes", indents + 1, dump_html_VkExternalFenceHandleTypeFlags);
}
void dump_html_VkExportSemaphoreCreateInfo(const VkExportSemaphoreCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkExternalSemaphoreHandleTypeFlags>(object.handleTypes, settings, "VkExternalSemaphoreHandleTypeFlags", "handleTypes", indents + 1, dump_html_VkExternalSemaphoreHandleTypeFlags);
}
void dump_html_VkPhysicalDeviceExternalSemaphoreInfo(const VkPhysicalDeviceExternalSemaphoreInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkExternalSemaphoreHandleTypeFlagBits>(object.handleType, settings, "VkExternalSemaphoreHandleTypeFlagBits", "handleType", indents + 1, dump_html_VkExternalSemaphoreHandleTypeFlagBits);
}
void dump_html_VkExternalSemaphoreProperties(const VkExternalSemaphoreProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkExternalSemaphoreHandleTypeFlags>(object.exportFromImportedHandleTypes, settings, "VkExternalSemaphoreHandleTypeFlags", "exportFromImportedHandleTypes", indents + 1, dump_html_VkExternalSemaphoreHandleTypeFlags);
    dump_html_value<const VkExternalSemaphoreHandleTypeFlags>(object.compatibleHandleTypes, settings, "VkExternalSemaphoreHandleTypeFlags", "compatibleHandleTypes", indents + 1, dump_html_VkExternalSemaphoreHandleTypeFlags);
    dump_html_value<const VkExternalSemaphoreFeatureFlags>(object.externalSemaphoreFeatures, settings, "VkExternalSemaphoreFeatureFlags", "externalSemaphoreFeatures", indents + 1, dump_html_VkExternalSemaphoreFeatureFlags);
}
void dump_html_VkPhysicalDeviceMaintenance3Properties(const VkPhysicalDeviceMaintenance3Properties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.maxPerSetDescriptors, settings, "uint32_t", "maxPerSetDescriptors", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkDeviceSize>(object.maxMemoryAllocationSize, settings, "VkDeviceSize", "maxMemoryAllocationSize", indents + 1, dump_html_VkDeviceSize);
}
void dump_html_VkDescriptorSetLayoutSupport(const VkDescriptorSetLayoutSupport& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.supported, settings, "VkBool32", "supported", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceShaderDrawParametersFeatures(const VkPhysicalDeviceShaderDrawParametersFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.shaderDrawParameters, settings, "VkBool32", "shaderDrawParameters", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceVulkan11Features(const VkPhysicalDeviceVulkan11Features& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.storageBuffer16BitAccess, settings, "VkBool32", "storageBuffer16BitAccess", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.uniformAndStorageBuffer16BitAccess, settings, "VkBool32", "uniformAndStorageBuffer16BitAccess", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.storagePushConstant16, settings, "VkBool32", "storagePushConstant16", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.storageInputOutput16, settings, "VkBool32", "storageInputOutput16", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.multiview, settings, "VkBool32", "multiview", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.multiviewGeometryShader, settings, "VkBool32", "multiviewGeometryShader", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.multiviewTessellationShader, settings, "VkBool32", "multiviewTessellationShader", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.variablePointersStorageBuffer, settings, "VkBool32", "variablePointersStorageBuffer", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.variablePointers, settings, "VkBool32", "variablePointers", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.protectedMemory, settings, "VkBool32", "protectedMemory", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.samplerYcbcrConversion, settings, "VkBool32", "samplerYcbcrConversion", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderDrawParameters, settings, "VkBool32", "shaderDrawParameters", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceVulkan11Properties(const VkPhysicalDeviceVulkan11Properties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_array<const uint8_t>(object.deviceUUID, 16, settings, "uint8_t[VK_UUID_SIZE]", "uint8_t", "deviceUUID", indents + 1, dump_html_uint8_t); // ZRR
    dump_html_array<const uint8_t>(object.driverUUID, 16, settings, "uint8_t[VK_UUID_SIZE]", "uint8_t", "driverUUID", indents + 1, dump_html_uint8_t); // ZRR
    dump_html_array<const uint8_t>(object.deviceLUID, 8, settings, "uint8_t[VK_LUID_SIZE]", "uint8_t", "deviceLUID", indents + 1, dump_html_uint8_t); // ZRR
    dump_html_value<const uint32_t>(object.deviceNodeMask, settings, "uint32_t", "deviceNodeMask", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkBool32>(object.deviceLUIDValid, settings, "VkBool32", "deviceLUIDValid", indents + 1, dump_html_VkBool32);
    dump_html_value<const uint32_t>(object.subgroupSize, settings, "uint32_t", "subgroupSize", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkShaderStageFlags>(object.subgroupSupportedStages, settings, "VkShaderStageFlags", "subgroupSupportedStages", indents + 1, dump_html_VkShaderStageFlags);
    dump_html_value<const VkSubgroupFeatureFlags>(object.subgroupSupportedOperations, settings, "VkSubgroupFeatureFlags", "subgroupSupportedOperations", indents + 1, dump_html_VkSubgroupFeatureFlags);
    dump_html_value<const VkBool32>(object.subgroupQuadOperationsInAllStages, settings, "VkBool32", "subgroupQuadOperationsInAllStages", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkPointClippingBehavior>(object.pointClippingBehavior, settings, "VkPointClippingBehavior", "pointClippingBehavior", indents + 1, dump_html_VkPointClippingBehavior);
    dump_html_value<const uint32_t>(object.maxMultiviewViewCount, settings, "uint32_t", "maxMultiviewViewCount", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxMultiviewInstanceIndex, settings, "uint32_t", "maxMultiviewInstanceIndex", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkBool32>(object.protectedNoFault, settings, "VkBool32", "protectedNoFault", indents + 1, dump_html_VkBool32);
    dump_html_value<const uint32_t>(object.maxPerSetDescriptors, settings, "uint32_t", "maxPerSetDescriptors", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkDeviceSize>(object.maxMemoryAllocationSize, settings, "VkDeviceSize", "maxMemoryAllocationSize", indents + 1, dump_html_VkDeviceSize);
}
void dump_html_VkPhysicalDeviceVulkan12Features(const VkPhysicalDeviceVulkan12Features& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.samplerMirrorClampToEdge, settings, "VkBool32", "samplerMirrorClampToEdge", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.drawIndirectCount, settings, "VkBool32", "drawIndirectCount", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.storageBuffer8BitAccess, settings, "VkBool32", "storageBuffer8BitAccess", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.uniformAndStorageBuffer8BitAccess, settings, "VkBool32", "uniformAndStorageBuffer8BitAccess", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.storagePushConstant8, settings, "VkBool32", "storagePushConstant8", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderBufferInt64Atomics, settings, "VkBool32", "shaderBufferInt64Atomics", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderSharedInt64Atomics, settings, "VkBool32", "shaderSharedInt64Atomics", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderFloat16, settings, "VkBool32", "shaderFloat16", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderInt8, settings, "VkBool32", "shaderInt8", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.descriptorIndexing, settings, "VkBool32", "descriptorIndexing", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderInputAttachmentArrayDynamicIndexing, settings, "VkBool32", "shaderInputAttachmentArrayDynamicIndexing", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderUniformTexelBufferArrayDynamicIndexing, settings, "VkBool32", "shaderUniformTexelBufferArrayDynamicIndexing", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderStorageTexelBufferArrayDynamicIndexing, settings, "VkBool32", "shaderStorageTexelBufferArrayDynamicIndexing", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderUniformBufferArrayNonUniformIndexing, settings, "VkBool32", "shaderUniformBufferArrayNonUniformIndexing", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderSampledImageArrayNonUniformIndexing, settings, "VkBool32", "shaderSampledImageArrayNonUniformIndexing", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderStorageBufferArrayNonUniformIndexing, settings, "VkBool32", "shaderStorageBufferArrayNonUniformIndexing", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderStorageImageArrayNonUniformIndexing, settings, "VkBool32", "shaderStorageImageArrayNonUniformIndexing", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderInputAttachmentArrayNonUniformIndexing, settings, "VkBool32", "shaderInputAttachmentArrayNonUniformIndexing", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderUniformTexelBufferArrayNonUniformIndexing, settings, "VkBool32", "shaderUniformTexelBufferArrayNonUniformIndexing", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderStorageTexelBufferArrayNonUniformIndexing, settings, "VkBool32", "shaderStorageTexelBufferArrayNonUniformIndexing", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.descriptorBindingUniformBufferUpdateAfterBind, settings, "VkBool32", "descriptorBindingUniformBufferUpdateAfterBind", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.descriptorBindingSampledImageUpdateAfterBind, settings, "VkBool32", "descriptorBindingSampledImageUpdateAfterBind", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.descriptorBindingStorageImageUpdateAfterBind, settings, "VkBool32", "descriptorBindingStorageImageUpdateAfterBind", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.descriptorBindingStorageBufferUpdateAfterBind, settings, "VkBool32", "descriptorBindingStorageBufferUpdateAfterBind", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.descriptorBindingUniformTexelBufferUpdateAfterBind, settings, "VkBool32", "descriptorBindingUniformTexelBufferUpdateAfterBind", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.descriptorBindingStorageTexelBufferUpdateAfterBind, settings, "VkBool32", "descriptorBindingStorageTexelBufferUpdateAfterBind", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.descriptorBindingUpdateUnusedWhilePending, settings, "VkBool32", "descriptorBindingUpdateUnusedWhilePending", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.descriptorBindingPartiallyBound, settings, "VkBool32", "descriptorBindingPartiallyBound", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.descriptorBindingVariableDescriptorCount, settings, "VkBool32", "descriptorBindingVariableDescriptorCount", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.runtimeDescriptorArray, settings, "VkBool32", "runtimeDescriptorArray", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.samplerFilterMinmax, settings, "VkBool32", "samplerFilterMinmax", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.scalarBlockLayout, settings, "VkBool32", "scalarBlockLayout", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.imagelessFramebuffer, settings, "VkBool32", "imagelessFramebuffer", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.uniformBufferStandardLayout, settings, "VkBool32", "uniformBufferStandardLayout", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderSubgroupExtendedTypes, settings, "VkBool32", "shaderSubgroupExtendedTypes", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.separateDepthStencilLayouts, settings, "VkBool32", "separateDepthStencilLayouts", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.hostQueryReset, settings, "VkBool32", "hostQueryReset", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.timelineSemaphore, settings, "VkBool32", "timelineSemaphore", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.bufferDeviceAddress, settings, "VkBool32", "bufferDeviceAddress", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.bufferDeviceAddressCaptureReplay, settings, "VkBool32", "bufferDeviceAddressCaptureReplay", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.bufferDeviceAddressMultiDevice, settings, "VkBool32", "bufferDeviceAddressMultiDevice", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.vulkanMemoryModel, settings, "VkBool32", "vulkanMemoryModel", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.vulkanMemoryModelDeviceScope, settings, "VkBool32", "vulkanMemoryModelDeviceScope", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.vulkanMemoryModelAvailabilityVisibilityChains, settings, "VkBool32", "vulkanMemoryModelAvailabilityVisibilityChains", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderOutputViewportIndex, settings, "VkBool32", "shaderOutputViewportIndex", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderOutputLayer, settings, "VkBool32", "shaderOutputLayer", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.subgroupBroadcastDynamicId, settings, "VkBool32", "subgroupBroadcastDynamicId", indents + 1, dump_html_VkBool32);
}
void dump_html_VkConformanceVersion(const VkConformanceVersion& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const uint8_t>(object.major, settings, "uint8_t", "major", indents + 1, dump_html_uint8_t);
    dump_html_value<const uint8_t>(object.minor, settings, "uint8_t", "minor", indents + 1, dump_html_uint8_t);
    dump_html_value<const uint8_t>(object.subminor, settings, "uint8_t", "subminor", indents + 1, dump_html_uint8_t);
    dump_html_value<const uint8_t>(object.patch, settings, "uint8_t", "patch", indents + 1, dump_html_uint8_t);
}
void dump_html_VkPhysicalDeviceVulkan12Properties(const VkPhysicalDeviceVulkan12Properties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDriverId>(object.driverID, settings, "VkDriverId", "driverID", indents + 1, dump_html_VkDriverId);
    dump_html_value<const char*>(object.driverName, settings, "char[VK_MAX_DRIVER_NAME_SIZE]", "driverName", indents + 1, dump_html_cstring);
    dump_html_value<const char*>(object.driverInfo, settings, "char[VK_MAX_DRIVER_INFO_SIZE]", "driverInfo", indents + 1, dump_html_cstring);
    dump_html_value<const VkConformanceVersion>(object.conformanceVersion, settings, "VkConformanceVersion", "conformanceVersion", indents + 1, dump_html_VkConformanceVersion);
    dump_html_value<const VkShaderFloatControlsIndependence>(object.denormBehaviorIndependence, settings, "VkShaderFloatControlsIndependence", "denormBehaviorIndependence", indents + 1, dump_html_VkShaderFloatControlsIndependence);
    dump_html_value<const VkShaderFloatControlsIndependence>(object.roundingModeIndependence, settings, "VkShaderFloatControlsIndependence", "roundingModeIndependence", indents + 1, dump_html_VkShaderFloatControlsIndependence);
    dump_html_value<const VkBool32>(object.shaderSignedZeroInfNanPreserveFloat16, settings, "VkBool32", "shaderSignedZeroInfNanPreserveFloat16", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderSignedZeroInfNanPreserveFloat32, settings, "VkBool32", "shaderSignedZeroInfNanPreserveFloat32", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderSignedZeroInfNanPreserveFloat64, settings, "VkBool32", "shaderSignedZeroInfNanPreserveFloat64", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderDenormPreserveFloat16, settings, "VkBool32", "shaderDenormPreserveFloat16", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderDenormPreserveFloat32, settings, "VkBool32", "shaderDenormPreserveFloat32", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderDenormPreserveFloat64, settings, "VkBool32", "shaderDenormPreserveFloat64", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderDenormFlushToZeroFloat16, settings, "VkBool32", "shaderDenormFlushToZeroFloat16", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderDenormFlushToZeroFloat32, settings, "VkBool32", "shaderDenormFlushToZeroFloat32", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderDenormFlushToZeroFloat64, settings, "VkBool32", "shaderDenormFlushToZeroFloat64", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderRoundingModeRTEFloat16, settings, "VkBool32", "shaderRoundingModeRTEFloat16", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderRoundingModeRTEFloat32, settings, "VkBool32", "shaderRoundingModeRTEFloat32", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderRoundingModeRTEFloat64, settings, "VkBool32", "shaderRoundingModeRTEFloat64", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderRoundingModeRTZFloat16, settings, "VkBool32", "shaderRoundingModeRTZFloat16", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderRoundingModeRTZFloat32, settings, "VkBool32", "shaderRoundingModeRTZFloat32", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderRoundingModeRTZFloat64, settings, "VkBool32", "shaderRoundingModeRTZFloat64", indents + 1, dump_html_VkBool32);
    dump_html_value<const uint32_t>(object.maxUpdateAfterBindDescriptorsInAllPools, settings, "uint32_t", "maxUpdateAfterBindDescriptorsInAllPools", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkBool32>(object.shaderUniformBufferArrayNonUniformIndexingNative, settings, "VkBool32", "shaderUniformBufferArrayNonUniformIndexingNative", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderSampledImageArrayNonUniformIndexingNative, settings, "VkBool32", "shaderSampledImageArrayNonUniformIndexingNative", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderStorageBufferArrayNonUniformIndexingNative, settings, "VkBool32", "shaderStorageBufferArrayNonUniformIndexingNative", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderStorageImageArrayNonUniformIndexingNative, settings, "VkBool32", "shaderStorageImageArrayNonUniformIndexingNative", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderInputAttachmentArrayNonUniformIndexingNative, settings, "VkBool32", "shaderInputAttachmentArrayNonUniformIndexingNative", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.robustBufferAccessUpdateAfterBind, settings, "VkBool32", "robustBufferAccessUpdateAfterBind", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.quadDivergentImplicitLod, settings, "VkBool32", "quadDivergentImplicitLod", indents + 1, dump_html_VkBool32);
    dump_html_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindSamplers, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindSamplers", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindUniformBuffers, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindUniformBuffers", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindStorageBuffers, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindStorageBuffers", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindSampledImages, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindSampledImages", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindStorageImages, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindStorageImages", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindInputAttachments, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindInputAttachments", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxPerStageUpdateAfterBindResources, settings, "uint32_t", "maxPerStageUpdateAfterBindResources", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindSamplers, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindSamplers", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindUniformBuffers, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindUniformBuffers", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindUniformBuffersDynamic, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindUniformBuffersDynamic", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindStorageBuffers, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindStorageBuffers", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindStorageBuffersDynamic, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindStorageBuffersDynamic", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindSampledImages, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindSampledImages", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindStorageImages, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindStorageImages", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindInputAttachments, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindInputAttachments", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkResolveModeFlags>(object.supportedDepthResolveModes, settings, "VkResolveModeFlags", "supportedDepthResolveModes", indents + 1, dump_html_VkResolveModeFlags);
    dump_html_value<const VkResolveModeFlags>(object.supportedStencilResolveModes, settings, "VkResolveModeFlags", "supportedStencilResolveModes", indents + 1, dump_html_VkResolveModeFlags);
    dump_html_value<const VkBool32>(object.independentResolveNone, settings, "VkBool32", "independentResolveNone", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.independentResolve, settings, "VkBool32", "independentResolve", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.filterMinmaxSingleComponentFormats, settings, "VkBool32", "filterMinmaxSingleComponentFormats", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.filterMinmaxImageComponentMapping, settings, "VkBool32", "filterMinmaxImageComponentMapping", indents + 1, dump_html_VkBool32);
    dump_html_value<const uint64_t>(object.maxTimelineSemaphoreValueDifference, settings, "uint64_t", "maxTimelineSemaphoreValueDifference", indents + 1, dump_html_uint64_t);
    dump_html_value<const VkSampleCountFlags>(object.framebufferIntegerColorSampleCounts, settings, "VkSampleCountFlags", "framebufferIntegerColorSampleCounts", indents + 1, dump_html_VkSampleCountFlags);
}
void dump_html_VkImageFormatListCreateInfo(const VkImageFormatListCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.viewFormatCount, settings, "uint32_t", "viewFormatCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkFormat>(object.pViewFormats, object.viewFormatCount, settings, "const VkFormat*", "const VkFormat", "pViewFormats", indents + 1, dump_html_VkFormat); // ZRT
}
void dump_html_VkAttachmentDescription2(const VkAttachmentDescription2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkAttachmentDescriptionFlags>(object.flags, settings, "VkAttachmentDescriptionFlags", "flags", indents + 1, dump_html_VkAttachmentDescriptionFlags);
    dump_html_value<const VkFormat>(object.format, settings, "VkFormat", "format", indents + 1, dump_html_VkFormat);
    dump_html_value<const VkSampleCountFlagBits>(object.samples, settings, "VkSampleCountFlagBits", "samples", indents + 1, dump_html_VkSampleCountFlagBits);
    dump_html_value<const VkAttachmentLoadOp>(object.loadOp, settings, "VkAttachmentLoadOp", "loadOp", indents + 1, dump_html_VkAttachmentLoadOp);
    dump_html_value<const VkAttachmentStoreOp>(object.storeOp, settings, "VkAttachmentStoreOp", "storeOp", indents + 1, dump_html_VkAttachmentStoreOp);
    dump_html_value<const VkAttachmentLoadOp>(object.stencilLoadOp, settings, "VkAttachmentLoadOp", "stencilLoadOp", indents + 1, dump_html_VkAttachmentLoadOp);
    dump_html_value<const VkAttachmentStoreOp>(object.stencilStoreOp, settings, "VkAttachmentStoreOp", "stencilStoreOp", indents + 1, dump_html_VkAttachmentStoreOp);
    dump_html_value<const VkImageLayout>(object.initialLayout, settings, "VkImageLayout", "initialLayout", indents + 1, dump_html_VkImageLayout);
    dump_html_value<const VkImageLayout>(object.finalLayout, settings, "VkImageLayout", "finalLayout", indents + 1, dump_html_VkImageLayout);
}
void dump_html_VkAttachmentReference2(const VkAttachmentReference2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.attachment, settings, "uint32_t", "attachment", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkImageLayout>(object.layout, settings, "VkImageLayout", "layout", indents + 1, dump_html_VkImageLayout);
    dump_html_value<const VkImageAspectFlags>(object.aspectMask, settings, "VkImageAspectFlags", "aspectMask", indents + 1, dump_html_VkImageAspectFlags);
}
void dump_html_VkSubpassDescription2(const VkSubpassDescription2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkSubpassDescriptionFlags>(object.flags, settings, "VkSubpassDescriptionFlags", "flags", indents + 1, dump_html_VkSubpassDescriptionFlags);
    dump_html_value<const VkPipelineBindPoint>(object.pipelineBindPoint, settings, "VkPipelineBindPoint", "pipelineBindPoint", indents + 1, dump_html_VkPipelineBindPoint);
    dump_html_value<const uint32_t>(object.viewMask, settings, "uint32_t", "viewMask", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.inputAttachmentCount, settings, "uint32_t", "inputAttachmentCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkAttachmentReference2>(object.pInputAttachments, object.inputAttachmentCount, settings, "const VkAttachmentReference2*", "const VkAttachmentReference2", "pInputAttachments", indents + 1, dump_html_VkAttachmentReference2); // ZRT
    dump_html_value<const uint32_t>(object.colorAttachmentCount, settings, "uint32_t", "colorAttachmentCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkAttachmentReference2>(object.pColorAttachments, object.colorAttachmentCount, settings, "const VkAttachmentReference2*", "const VkAttachmentReference2", "pColorAttachments", indents + 1, dump_html_VkAttachmentReference2); // ZRT
    dump_html_array<const VkAttachmentReference2>(object.pResolveAttachments, object.colorAttachmentCount, settings, "const VkAttachmentReference2*", "const VkAttachmentReference2", "pResolveAttachments", indents + 1, dump_html_VkAttachmentReference2); // ZRT
    dump_html_pointer<const VkAttachmentReference2>(object.pDepthStencilAttachment, settings, "const VkAttachmentReference2*", "pDepthStencilAttachment", indents + 1, dump_html_VkAttachmentReference2);
    dump_html_value<const uint32_t>(object.preserveAttachmentCount, settings, "uint32_t", "preserveAttachmentCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const uint32_t>(object.pPreserveAttachments, object.preserveAttachmentCount, settings, "const uint32_t*", "const uint32_t", "pPreserveAttachments", indents + 1, dump_html_uint32_t); // ZRT
}
void dump_html_VkSubpassDependency2(const VkSubpassDependency2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.srcSubpass, settings, "uint32_t", "srcSubpass", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.dstSubpass, settings, "uint32_t", "dstSubpass", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkPipelineStageFlags>(object.srcStageMask, settings, "VkPipelineStageFlags", "srcStageMask", indents + 1, dump_html_VkPipelineStageFlags);
    dump_html_value<const VkPipelineStageFlags>(object.dstStageMask, settings, "VkPipelineStageFlags", "dstStageMask", indents + 1, dump_html_VkPipelineStageFlags);
    dump_html_value<const VkAccessFlags>(object.srcAccessMask, settings, "VkAccessFlags", "srcAccessMask", indents + 1, dump_html_VkAccessFlags);
    dump_html_value<const VkAccessFlags>(object.dstAccessMask, settings, "VkAccessFlags", "dstAccessMask", indents + 1, dump_html_VkAccessFlags);
    dump_html_value<const VkDependencyFlags>(object.dependencyFlags, settings, "VkDependencyFlags", "dependencyFlags", indents + 1, dump_html_VkDependencyFlags);
    dump_html_value<const int32_t>(object.viewOffset, settings, "int32_t", "viewOffset", indents + 1, dump_html_int32_t);
}
void dump_html_VkRenderPassCreateInfo2(const VkRenderPassCreateInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkRenderPassCreateFlags>(object.flags, settings, "VkRenderPassCreateFlags", "flags", indents + 1, dump_html_VkRenderPassCreateFlags);
    dump_html_value<const uint32_t>(object.attachmentCount, settings, "uint32_t", "attachmentCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkAttachmentDescription2>(object.pAttachments, object.attachmentCount, settings, "const VkAttachmentDescription2*", "const VkAttachmentDescription2", "pAttachments", indents + 1, dump_html_VkAttachmentDescription2); // ZRT
    dump_html_value<const uint32_t>(object.subpassCount, settings, "uint32_t", "subpassCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkSubpassDescription2>(object.pSubpasses, object.subpassCount, settings, "const VkSubpassDescription2*", "const VkSubpassDescription2", "pSubpasses", indents + 1, dump_html_VkSubpassDescription2); // ZRT
    dump_html_value<const uint32_t>(object.dependencyCount, settings, "uint32_t", "dependencyCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkSubpassDependency2>(object.pDependencies, object.dependencyCount, settings, "const VkSubpassDependency2*", "const VkSubpassDependency2", "pDependencies", indents + 1, dump_html_VkSubpassDependency2); // ZRT
    dump_html_value<const uint32_t>(object.correlatedViewMaskCount, settings, "uint32_t", "correlatedViewMaskCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const uint32_t>(object.pCorrelatedViewMasks, object.correlatedViewMaskCount, settings, "const uint32_t*", "const uint32_t", "pCorrelatedViewMasks", indents + 1, dump_html_uint32_t); // ZRT
}
void dump_html_VkSubpassBeginInfo(const VkSubpassBeginInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkSubpassContents>(object.contents, settings, "VkSubpassContents", "contents", indents + 1, dump_html_VkSubpassContents);
}
void dump_html_VkSubpassEndInfo(const VkSubpassEndInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
}
void dump_html_VkPhysicalDevice8BitStorageFeatures(const VkPhysicalDevice8BitStorageFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.storageBuffer8BitAccess, settings, "VkBool32", "storageBuffer8BitAccess", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.uniformAndStorageBuffer8BitAccess, settings, "VkBool32", "uniformAndStorageBuffer8BitAccess", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.storagePushConstant8, settings, "VkBool32", "storagePushConstant8", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceDriverProperties(const VkPhysicalDeviceDriverProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDriverId>(object.driverID, settings, "VkDriverId", "driverID", indents + 1, dump_html_VkDriverId);
    dump_html_value<const char*>(object.driverName, settings, "char[VK_MAX_DRIVER_NAME_SIZE]", "driverName", indents + 1, dump_html_cstring);
    dump_html_value<const char*>(object.driverInfo, settings, "char[VK_MAX_DRIVER_INFO_SIZE]", "driverInfo", indents + 1, dump_html_cstring);
    dump_html_value<const VkConformanceVersion>(object.conformanceVersion, settings, "VkConformanceVersion", "conformanceVersion", indents + 1, dump_html_VkConformanceVersion);
}
void dump_html_VkPhysicalDeviceShaderAtomicInt64Features(const VkPhysicalDeviceShaderAtomicInt64Features& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.shaderBufferInt64Atomics, settings, "VkBool32", "shaderBufferInt64Atomics", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderSharedInt64Atomics, settings, "VkBool32", "shaderSharedInt64Atomics", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceShaderFloat16Int8Features(const VkPhysicalDeviceShaderFloat16Int8Features& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.shaderFloat16, settings, "VkBool32", "shaderFloat16", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderInt8, settings, "VkBool32", "shaderInt8", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceFloatControlsProperties(const VkPhysicalDeviceFloatControlsProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkShaderFloatControlsIndependence>(object.denormBehaviorIndependence, settings, "VkShaderFloatControlsIndependence", "denormBehaviorIndependence", indents + 1, dump_html_VkShaderFloatControlsIndependence);
    dump_html_value<const VkShaderFloatControlsIndependence>(object.roundingModeIndependence, settings, "VkShaderFloatControlsIndependence", "roundingModeIndependence", indents + 1, dump_html_VkShaderFloatControlsIndependence);
    dump_html_value<const VkBool32>(object.shaderSignedZeroInfNanPreserveFloat16, settings, "VkBool32", "shaderSignedZeroInfNanPreserveFloat16", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderSignedZeroInfNanPreserveFloat32, settings, "VkBool32", "shaderSignedZeroInfNanPreserveFloat32", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderSignedZeroInfNanPreserveFloat64, settings, "VkBool32", "shaderSignedZeroInfNanPreserveFloat64", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderDenormPreserveFloat16, settings, "VkBool32", "shaderDenormPreserveFloat16", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderDenormPreserveFloat32, settings, "VkBool32", "shaderDenormPreserveFloat32", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderDenormPreserveFloat64, settings, "VkBool32", "shaderDenormPreserveFloat64", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderDenormFlushToZeroFloat16, settings, "VkBool32", "shaderDenormFlushToZeroFloat16", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderDenormFlushToZeroFloat32, settings, "VkBool32", "shaderDenormFlushToZeroFloat32", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderDenormFlushToZeroFloat64, settings, "VkBool32", "shaderDenormFlushToZeroFloat64", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderRoundingModeRTEFloat16, settings, "VkBool32", "shaderRoundingModeRTEFloat16", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderRoundingModeRTEFloat32, settings, "VkBool32", "shaderRoundingModeRTEFloat32", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderRoundingModeRTEFloat64, settings, "VkBool32", "shaderRoundingModeRTEFloat64", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderRoundingModeRTZFloat16, settings, "VkBool32", "shaderRoundingModeRTZFloat16", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderRoundingModeRTZFloat32, settings, "VkBool32", "shaderRoundingModeRTZFloat32", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderRoundingModeRTZFloat64, settings, "VkBool32", "shaderRoundingModeRTZFloat64", indents + 1, dump_html_VkBool32);
}
void dump_html_VkDescriptorSetLayoutBindingFlagsCreateInfo(const VkDescriptorSetLayoutBindingFlagsCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.bindingCount, settings, "uint32_t", "bindingCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkDescriptorBindingFlags>(object.pBindingFlags, object.bindingCount, settings, "const VkDescriptorBindingFlags*", "const VkDescriptorBindingFlags", "pBindingFlags", indents + 1, dump_html_VkDescriptorBindingFlags); // ZRT
}
void dump_html_VkPhysicalDeviceDescriptorIndexingFeatures(const VkPhysicalDeviceDescriptorIndexingFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.shaderInputAttachmentArrayDynamicIndexing, settings, "VkBool32", "shaderInputAttachmentArrayDynamicIndexing", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderUniformTexelBufferArrayDynamicIndexing, settings, "VkBool32", "shaderUniformTexelBufferArrayDynamicIndexing", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderStorageTexelBufferArrayDynamicIndexing, settings, "VkBool32", "shaderStorageTexelBufferArrayDynamicIndexing", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderUniformBufferArrayNonUniformIndexing, settings, "VkBool32", "shaderUniformBufferArrayNonUniformIndexing", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderSampledImageArrayNonUniformIndexing, settings, "VkBool32", "shaderSampledImageArrayNonUniformIndexing", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderStorageBufferArrayNonUniformIndexing, settings, "VkBool32", "shaderStorageBufferArrayNonUniformIndexing", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderStorageImageArrayNonUniformIndexing, settings, "VkBool32", "shaderStorageImageArrayNonUniformIndexing", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderInputAttachmentArrayNonUniformIndexing, settings, "VkBool32", "shaderInputAttachmentArrayNonUniformIndexing", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderUniformTexelBufferArrayNonUniformIndexing, settings, "VkBool32", "shaderUniformTexelBufferArrayNonUniformIndexing", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderStorageTexelBufferArrayNonUniformIndexing, settings, "VkBool32", "shaderStorageTexelBufferArrayNonUniformIndexing", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.descriptorBindingUniformBufferUpdateAfterBind, settings, "VkBool32", "descriptorBindingUniformBufferUpdateAfterBind", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.descriptorBindingSampledImageUpdateAfterBind, settings, "VkBool32", "descriptorBindingSampledImageUpdateAfterBind", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.descriptorBindingStorageImageUpdateAfterBind, settings, "VkBool32", "descriptorBindingStorageImageUpdateAfterBind", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.descriptorBindingStorageBufferUpdateAfterBind, settings, "VkBool32", "descriptorBindingStorageBufferUpdateAfterBind", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.descriptorBindingUniformTexelBufferUpdateAfterBind, settings, "VkBool32", "descriptorBindingUniformTexelBufferUpdateAfterBind", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.descriptorBindingStorageTexelBufferUpdateAfterBind, settings, "VkBool32", "descriptorBindingStorageTexelBufferUpdateAfterBind", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.descriptorBindingUpdateUnusedWhilePending, settings, "VkBool32", "descriptorBindingUpdateUnusedWhilePending", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.descriptorBindingPartiallyBound, settings, "VkBool32", "descriptorBindingPartiallyBound", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.descriptorBindingVariableDescriptorCount, settings, "VkBool32", "descriptorBindingVariableDescriptorCount", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.runtimeDescriptorArray, settings, "VkBool32", "runtimeDescriptorArray", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceDescriptorIndexingProperties(const VkPhysicalDeviceDescriptorIndexingProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.maxUpdateAfterBindDescriptorsInAllPools, settings, "uint32_t", "maxUpdateAfterBindDescriptorsInAllPools", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkBool32>(object.shaderUniformBufferArrayNonUniformIndexingNative, settings, "VkBool32", "shaderUniformBufferArrayNonUniformIndexingNative", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderSampledImageArrayNonUniformIndexingNative, settings, "VkBool32", "shaderSampledImageArrayNonUniformIndexingNative", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderStorageBufferArrayNonUniformIndexingNative, settings, "VkBool32", "shaderStorageBufferArrayNonUniformIndexingNative", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderStorageImageArrayNonUniformIndexingNative, settings, "VkBool32", "shaderStorageImageArrayNonUniformIndexingNative", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderInputAttachmentArrayNonUniformIndexingNative, settings, "VkBool32", "shaderInputAttachmentArrayNonUniformIndexingNative", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.robustBufferAccessUpdateAfterBind, settings, "VkBool32", "robustBufferAccessUpdateAfterBind", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.quadDivergentImplicitLod, settings, "VkBool32", "quadDivergentImplicitLod", indents + 1, dump_html_VkBool32);
    dump_html_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindSamplers, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindSamplers", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindUniformBuffers, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindUniformBuffers", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindStorageBuffers, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindStorageBuffers", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindSampledImages, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindSampledImages", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindStorageImages, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindStorageImages", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindInputAttachments, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindInputAttachments", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxPerStageUpdateAfterBindResources, settings, "uint32_t", "maxPerStageUpdateAfterBindResources", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindSamplers, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindSamplers", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindUniformBuffers, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindUniformBuffers", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindUniformBuffersDynamic, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindUniformBuffersDynamic", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindStorageBuffers, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindStorageBuffers", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindStorageBuffersDynamic, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindStorageBuffersDynamic", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindSampledImages, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindSampledImages", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindStorageImages, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindStorageImages", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindInputAttachments, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindInputAttachments", indents + 1, dump_html_uint32_t);
}
void dump_html_VkDescriptorSetVariableDescriptorCountAllocateInfo(const VkDescriptorSetVariableDescriptorCountAllocateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.descriptorSetCount, settings, "uint32_t", "descriptorSetCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const uint32_t>(object.pDescriptorCounts, object.descriptorSetCount, settings, "const uint32_t*", "const uint32_t", "pDescriptorCounts", indents + 1, dump_html_uint32_t); // ZRT
}
void dump_html_VkDescriptorSetVariableDescriptorCountLayoutSupport(const VkDescriptorSetVariableDescriptorCountLayoutSupport& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.maxVariableDescriptorCount, settings, "uint32_t", "maxVariableDescriptorCount", indents + 1, dump_html_uint32_t);
}
void dump_html_VkSubpassDescriptionDepthStencilResolve(const VkSubpassDescriptionDepthStencilResolve& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkResolveModeFlagBits>(object.depthResolveMode, settings, "VkResolveModeFlagBits", "depthResolveMode", indents + 1, dump_html_VkResolveModeFlagBits);
    dump_html_value<const VkResolveModeFlagBits>(object.stencilResolveMode, settings, "VkResolveModeFlagBits", "stencilResolveMode", indents + 1, dump_html_VkResolveModeFlagBits);
    dump_html_pointer<const VkAttachmentReference2>(object.pDepthStencilResolveAttachment, settings, "const VkAttachmentReference2*", "pDepthStencilResolveAttachment", indents + 1, dump_html_VkAttachmentReference2);
}
void dump_html_VkPhysicalDeviceDepthStencilResolveProperties(const VkPhysicalDeviceDepthStencilResolveProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkResolveModeFlags>(object.supportedDepthResolveModes, settings, "VkResolveModeFlags", "supportedDepthResolveModes", indents + 1, dump_html_VkResolveModeFlags);
    dump_html_value<const VkResolveModeFlags>(object.supportedStencilResolveModes, settings, "VkResolveModeFlags", "supportedStencilResolveModes", indents + 1, dump_html_VkResolveModeFlags);
    dump_html_value<const VkBool32>(object.independentResolveNone, settings, "VkBool32", "independentResolveNone", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.independentResolve, settings, "VkBool32", "independentResolve", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceScalarBlockLayoutFeatures(const VkPhysicalDeviceScalarBlockLayoutFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.scalarBlockLayout, settings, "VkBool32", "scalarBlockLayout", indents + 1, dump_html_VkBool32);
}
void dump_html_VkImageStencilUsageCreateInfo(const VkImageStencilUsageCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkImageUsageFlags>(object.stencilUsage, settings, "VkImageUsageFlags", "stencilUsage", indents + 1, dump_html_VkImageUsageFlags);
}
void dump_html_VkSamplerReductionModeCreateInfo(const VkSamplerReductionModeCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkSamplerReductionMode>(object.reductionMode, settings, "VkSamplerReductionMode", "reductionMode", indents + 1, dump_html_VkSamplerReductionMode);
}
void dump_html_VkPhysicalDeviceSamplerFilterMinmaxProperties(const VkPhysicalDeviceSamplerFilterMinmaxProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.filterMinmaxSingleComponentFormats, settings, "VkBool32", "filterMinmaxSingleComponentFormats", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.filterMinmaxImageComponentMapping, settings, "VkBool32", "filterMinmaxImageComponentMapping", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceVulkanMemoryModelFeatures(const VkPhysicalDeviceVulkanMemoryModelFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.vulkanMemoryModel, settings, "VkBool32", "vulkanMemoryModel", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.vulkanMemoryModelDeviceScope, settings, "VkBool32", "vulkanMemoryModelDeviceScope", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.vulkanMemoryModelAvailabilityVisibilityChains, settings, "VkBool32", "vulkanMemoryModelAvailabilityVisibilityChains", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceImagelessFramebufferFeatures(const VkPhysicalDeviceImagelessFramebufferFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.imagelessFramebuffer, settings, "VkBool32", "imagelessFramebuffer", indents + 1, dump_html_VkBool32);
}
void dump_html_VkFramebufferAttachmentImageInfo(const VkFramebufferAttachmentImageInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkImageCreateFlags>(object.flags, settings, "VkImageCreateFlags", "flags", indents + 1, dump_html_VkImageCreateFlags);
    dump_html_value<const VkImageUsageFlags>(object.usage, settings, "VkImageUsageFlags", "usage", indents + 1, dump_html_VkImageUsageFlags);
    dump_html_value<const uint32_t>(object.width, settings, "uint32_t", "width", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.height, settings, "uint32_t", "height", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.layerCount, settings, "uint32_t", "layerCount", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.viewFormatCount, settings, "uint32_t", "viewFormatCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkFormat>(object.pViewFormats, object.viewFormatCount, settings, "const VkFormat*", "const VkFormat", "pViewFormats", indents + 1, dump_html_VkFormat); // ZRT
}
void dump_html_VkFramebufferAttachmentsCreateInfo(const VkFramebufferAttachmentsCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.attachmentImageInfoCount, settings, "uint32_t", "attachmentImageInfoCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkFramebufferAttachmentImageInfo>(object.pAttachmentImageInfos, object.attachmentImageInfoCount, settings, "const VkFramebufferAttachmentImageInfo*", "const VkFramebufferAttachmentImageInfo", "pAttachmentImageInfos", indents + 1, dump_html_VkFramebufferAttachmentImageInfo); // ZRT
}
void dump_html_VkRenderPassAttachmentBeginInfo(const VkRenderPassAttachmentBeginInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.attachmentCount, settings, "uint32_t", "attachmentCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkImageView>(object.pAttachments, object.attachmentCount, settings, "const VkImageView*", "const VkImageView", "pAttachments", indents + 1, dump_html_VkImageView); // ZRT
}
void dump_html_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(const VkPhysicalDeviceUniformBufferStandardLayoutFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.uniformBufferStandardLayout, settings, "VkBool32", "uniformBufferStandardLayout", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.shaderSubgroupExtendedTypes, settings, "VkBool32", "shaderSubgroupExtendedTypes", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.separateDepthStencilLayouts, settings, "VkBool32", "separateDepthStencilLayouts", indents + 1, dump_html_VkBool32);
}
void dump_html_VkAttachmentReferenceStencilLayout(const VkAttachmentReferenceStencilLayout& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkImageLayout>(object.stencilLayout, settings, "VkImageLayout", "stencilLayout", indents + 1, dump_html_VkImageLayout);
}
void dump_html_VkAttachmentDescriptionStencilLayout(const VkAttachmentDescriptionStencilLayout& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkImageLayout>(object.stencilInitialLayout, settings, "VkImageLayout", "stencilInitialLayout", indents + 1, dump_html_VkImageLayout);
    dump_html_value<const VkImageLayout>(object.stencilFinalLayout, settings, "VkImageLayout", "stencilFinalLayout", indents + 1, dump_html_VkImageLayout);
}
void dump_html_VkPhysicalDeviceHostQueryResetFeatures(const VkPhysicalDeviceHostQueryResetFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.hostQueryReset, settings, "VkBool32", "hostQueryReset", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceTimelineSemaphoreFeatures(const VkPhysicalDeviceTimelineSemaphoreFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.timelineSemaphore, settings, "VkBool32", "timelineSemaphore", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceTimelineSemaphoreProperties(const VkPhysicalDeviceTimelineSemaphoreProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint64_t>(object.maxTimelineSemaphoreValueDifference, settings, "uint64_t", "maxTimelineSemaphoreValueDifference", indents + 1, dump_html_uint64_t);
}
void dump_html_VkSemaphoreTypeCreateInfo(const VkSemaphoreTypeCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkSemaphoreType>(object.semaphoreType, settings, "VkSemaphoreType", "semaphoreType", indents + 1, dump_html_VkSemaphoreType);
    dump_html_value<const uint64_t>(object.initialValue, settings, "uint64_t", "initialValue", indents + 1, dump_html_uint64_t);
}
void dump_html_VkTimelineSemaphoreSubmitInfo(const VkTimelineSemaphoreSubmitInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.waitSemaphoreValueCount, settings, "uint32_t", "waitSemaphoreValueCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const uint64_t>(object.pWaitSemaphoreValues, object.waitSemaphoreValueCount, settings, "const uint64_t*", "const uint64_t", "pWaitSemaphoreValues", indents + 1, dump_html_uint64_t); // ZRT
    dump_html_value<const uint32_t>(object.signalSemaphoreValueCount, settings, "uint32_t", "signalSemaphoreValueCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const uint64_t>(object.pSignalSemaphoreValues, object.signalSemaphoreValueCount, settings, "const uint64_t*", "const uint64_t", "pSignalSemaphoreValues", indents + 1, dump_html_uint64_t); // ZRT
}
void dump_html_VkSemaphoreWaitInfo(const VkSemaphoreWaitInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkSemaphoreWaitFlags>(object.flags, settings, "VkSemaphoreWaitFlags", "flags", indents + 1, dump_html_VkSemaphoreWaitFlags);
    dump_html_value<const uint32_t>(object.semaphoreCount, settings, "uint32_t", "semaphoreCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkSemaphore>(object.pSemaphores, object.semaphoreCount, settings, "const VkSemaphore*", "const VkSemaphore", "pSemaphores", indents + 1, dump_html_VkSemaphore); // ZRT
    dump_html_array<const uint64_t>(object.pValues, object.semaphoreCount, settings, "const uint64_t*", "const uint64_t", "pValues", indents + 1, dump_html_uint64_t); // ZRT
}
void dump_html_VkSemaphoreSignalInfo(const VkSemaphoreSignalInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkSemaphore>(object.semaphore, settings, "VkSemaphore", "semaphore", indents + 1, dump_html_VkSemaphore);
    dump_html_value<const uint64_t>(object.value, settings, "uint64_t", "value", indents + 1, dump_html_uint64_t);
}
void dump_html_VkPhysicalDeviceBufferDeviceAddressFeatures(const VkPhysicalDeviceBufferDeviceAddressFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.bufferDeviceAddress, settings, "VkBool32", "bufferDeviceAddress", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.bufferDeviceAddressCaptureReplay, settings, "VkBool32", "bufferDeviceAddressCaptureReplay", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.bufferDeviceAddressMultiDevice, settings, "VkBool32", "bufferDeviceAddressMultiDevice", indents + 1, dump_html_VkBool32);
}
void dump_html_VkBufferDeviceAddressInfo(const VkBufferDeviceAddressInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBuffer>(object.buffer, settings, "VkBuffer", "buffer", indents + 1, dump_html_VkBuffer);
}
void dump_html_VkBufferOpaqueCaptureAddressCreateInfo(const VkBufferOpaqueCaptureAddressCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint64_t>(object.opaqueCaptureAddress, settings, "uint64_t", "opaqueCaptureAddress", indents + 1, dump_html_uint64_t);
}
void dump_html_VkMemoryOpaqueCaptureAddressAllocateInfo(const VkMemoryOpaqueCaptureAddressAllocateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint64_t>(object.opaqueCaptureAddress, settings, "uint64_t", "opaqueCaptureAddress", indents + 1, dump_html_uint64_t);
}
void dump_html_VkDeviceMemoryOpaqueCaptureAddressInfo(const VkDeviceMemoryOpaqueCaptureAddressInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDeviceMemory>(object.memory, settings, "VkDeviceMemory", "memory", indents + 1, dump_html_VkDeviceMemory);
}
void dump_html_VkPhysicalDeviceVulkan13Features(const VkPhysicalDeviceVulkan13Features& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.robustImageAccess, settings, "VkBool32", "robustImageAccess", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.inlineUniformBlock, settings, "VkBool32", "inlineUniformBlock", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.descriptorBindingInlineUniformBlockUpdateAfterBind, settings, "VkBool32", "descriptorBindingInlineUniformBlockUpdateAfterBind", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.pipelineCreationCacheControl, settings, "VkBool32", "pipelineCreationCacheControl", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.privateData, settings, "VkBool32", "privateData", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderDemoteToHelperInvocation, settings, "VkBool32", "shaderDemoteToHelperInvocation", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderTerminateInvocation, settings, "VkBool32", "shaderTerminateInvocation", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.subgroupSizeControl, settings, "VkBool32", "subgroupSizeControl", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.computeFullSubgroups, settings, "VkBool32", "computeFullSubgroups", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.synchronization2, settings, "VkBool32", "synchronization2", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.textureCompressionASTC_HDR, settings, "VkBool32", "textureCompressionASTC_HDR", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderZeroInitializeWorkgroupMemory, settings, "VkBool32", "shaderZeroInitializeWorkgroupMemory", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.dynamicRendering, settings, "VkBool32", "dynamicRendering", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.shaderIntegerDotProduct, settings, "VkBool32", "shaderIntegerDotProduct", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.maintenance4, settings, "VkBool32", "maintenance4", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceVulkan13Properties(const VkPhysicalDeviceVulkan13Properties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.minSubgroupSize, settings, "uint32_t", "minSubgroupSize", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxSubgroupSize, settings, "uint32_t", "maxSubgroupSize", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxComputeWorkgroupSubgroups, settings, "uint32_t", "maxComputeWorkgroupSubgroups", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkShaderStageFlags>(object.requiredSubgroupSizeStages, settings, "VkShaderStageFlags", "requiredSubgroupSizeStages", indents + 1, dump_html_VkShaderStageFlags);
    dump_html_value<const uint32_t>(object.maxInlineUniformBlockSize, settings, "uint32_t", "maxInlineUniformBlockSize", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxPerStageDescriptorInlineUniformBlocks, settings, "uint32_t", "maxPerStageDescriptorInlineUniformBlocks", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetInlineUniformBlocks, settings, "uint32_t", "maxDescriptorSetInlineUniformBlocks", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindInlineUniformBlocks, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindInlineUniformBlocks", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxInlineUniformTotalSize, settings, "uint32_t", "maxInlineUniformTotalSize", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkBool32>(object.integerDotProduct8BitUnsignedAccelerated, settings, "VkBool32", "integerDotProduct8BitUnsignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct8BitSignedAccelerated, settings, "VkBool32", "integerDotProduct8BitSignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct8BitMixedSignednessAccelerated, settings, "VkBool32", "integerDotProduct8BitMixedSignednessAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct4x8BitPackedUnsignedAccelerated, settings, "VkBool32", "integerDotProduct4x8BitPackedUnsignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct4x8BitPackedSignedAccelerated, settings, "VkBool32", "integerDotProduct4x8BitPackedSignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct4x8BitPackedMixedSignednessAccelerated, settings, "VkBool32", "integerDotProduct4x8BitPackedMixedSignednessAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct16BitUnsignedAccelerated, settings, "VkBool32", "integerDotProduct16BitUnsignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct16BitSignedAccelerated, settings, "VkBool32", "integerDotProduct16BitSignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct16BitMixedSignednessAccelerated, settings, "VkBool32", "integerDotProduct16BitMixedSignednessAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct32BitUnsignedAccelerated, settings, "VkBool32", "integerDotProduct32BitUnsignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct32BitSignedAccelerated, settings, "VkBool32", "integerDotProduct32BitSignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct32BitMixedSignednessAccelerated, settings, "VkBool32", "integerDotProduct32BitMixedSignednessAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct64BitUnsignedAccelerated, settings, "VkBool32", "integerDotProduct64BitUnsignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct64BitSignedAccelerated, settings, "VkBool32", "integerDotProduct64BitSignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct64BitMixedSignednessAccelerated, settings, "VkBool32", "integerDotProduct64BitMixedSignednessAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating8BitUnsignedAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating8BitUnsignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating8BitSignedAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating8BitSignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating16BitUnsignedAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating16BitUnsignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating16BitSignedAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating16BitSignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating32BitUnsignedAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating32BitUnsignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating32BitSignedAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating32BitSignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating64BitUnsignedAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating64BitUnsignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating64BitSignedAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating64BitSignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkDeviceSize>(object.storageTexelBufferOffsetAlignmentBytes, settings, "VkDeviceSize", "storageTexelBufferOffsetAlignmentBytes", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkBool32>(object.storageTexelBufferOffsetSingleTexelAlignment, settings, "VkBool32", "storageTexelBufferOffsetSingleTexelAlignment", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkDeviceSize>(object.uniformTexelBufferOffsetAlignmentBytes, settings, "VkDeviceSize", "uniformTexelBufferOffsetAlignmentBytes", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkBool32>(object.uniformTexelBufferOffsetSingleTexelAlignment, settings, "VkBool32", "uniformTexelBufferOffsetSingleTexelAlignment", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkDeviceSize>(object.maxBufferSize, settings, "VkDeviceSize", "maxBufferSize", indents + 1, dump_html_VkDeviceSize);
}
void dump_html_VkPipelineCreationFeedback(const VkPipelineCreationFeedback& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkPipelineCreationFeedbackFlags>(object.flags, settings, "VkPipelineCreationFeedbackFlags", "flags", indents + 1, dump_html_VkPipelineCreationFeedbackFlags);
    dump_html_value<const uint64_t>(object.duration, settings, "uint64_t", "duration", indents + 1, dump_html_uint64_t);
}
void dump_html_VkPipelineCreationFeedbackCreateInfo(const VkPipelineCreationFeedbackCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_pointer<const VkPipelineCreationFeedback>(object.pPipelineCreationFeedback, settings, "VkPipelineCreationFeedback*", "pPipelineCreationFeedback", indents + 1, dump_html_VkPipelineCreationFeedback);
    dump_html_value<const uint32_t>(object.pipelineStageCreationFeedbackCount, settings, "uint32_t", "pipelineStageCreationFeedbackCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkPipelineCreationFeedback>(object.pPipelineStageCreationFeedbacks, object.pipelineStageCreationFeedbackCount, settings, "VkPipelineCreationFeedback*", "VkPipelineCreationFeedback", "pPipelineStageCreationFeedbacks", indents + 1, dump_html_VkPipelineCreationFeedback); // ZRT
}
void dump_html_VkPhysicalDeviceShaderTerminateInvocationFeatures(const VkPhysicalDeviceShaderTerminateInvocationFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.shaderTerminateInvocation, settings, "VkBool32", "shaderTerminateInvocation", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceToolProperties(const VkPhysicalDeviceToolProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const char*>(object.name, settings, "char[VK_MAX_EXTENSION_NAME_SIZE]", "name", indents + 1, dump_html_cstring);
    dump_html_value<const char*>(object.version, settings, "char[VK_MAX_EXTENSION_NAME_SIZE]", "version", indents + 1, dump_html_cstring);
    dump_html_value<const VkToolPurposeFlags>(object.purposes, settings, "VkToolPurposeFlags", "purposes", indents + 1, dump_html_VkToolPurposeFlags);
    dump_html_value<const char*>(object.description, settings, "char[VK_MAX_DESCRIPTION_SIZE]", "description", indents + 1, dump_html_cstring);
    dump_html_value<const char*>(object.layer, settings, "char[VK_MAX_EXTENSION_NAME_SIZE]", "layer", indents + 1, dump_html_cstring);
}
void dump_html_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.shaderDemoteToHelperInvocation, settings, "VkBool32", "shaderDemoteToHelperInvocation", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDevicePrivateDataFeatures(const VkPhysicalDevicePrivateDataFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.privateData, settings, "VkBool32", "privateData", indents + 1, dump_html_VkBool32);
}
void dump_html_VkDevicePrivateDataCreateInfo(const VkDevicePrivateDataCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.privateDataSlotRequestCount, settings, "uint32_t", "privateDataSlotRequestCount", indents + 1, dump_html_uint32_t);
}
void dump_html_VkPrivateDataSlotCreateInfo(const VkPrivateDataSlotCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkPrivateDataSlotCreateFlags>(object.flags, settings, "VkPrivateDataSlotCreateFlags", "flags", indents + 1, dump_html_VkPrivateDataSlotCreateFlags);
}
void dump_html_VkPhysicalDevicePipelineCreationCacheControlFeatures(const VkPhysicalDevicePipelineCreationCacheControlFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.pipelineCreationCacheControl, settings, "VkBool32", "pipelineCreationCacheControl", indents + 1, dump_html_VkBool32);
}
void dump_html_VkMemoryBarrier2(const VkMemoryBarrier2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkPipelineStageFlags2>(object.srcStageMask, settings, "VkPipelineStageFlags2", "srcStageMask", indents + 1, dump_html_VkPipelineStageFlags2);
    dump_html_value<const VkAccessFlags2>(object.srcAccessMask, settings, "VkAccessFlags2", "srcAccessMask", indents + 1, dump_html_VkAccessFlags2);
    dump_html_value<const VkPipelineStageFlags2>(object.dstStageMask, settings, "VkPipelineStageFlags2", "dstStageMask", indents + 1, dump_html_VkPipelineStageFlags2);
    dump_html_value<const VkAccessFlags2>(object.dstAccessMask, settings, "VkAccessFlags2", "dstAccessMask", indents + 1, dump_html_VkAccessFlags2);
}
void dump_html_VkBufferMemoryBarrier2(const VkBufferMemoryBarrier2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkPipelineStageFlags2>(object.srcStageMask, settings, "VkPipelineStageFlags2", "srcStageMask", indents + 1, dump_html_VkPipelineStageFlags2);
    dump_html_value<const VkAccessFlags2>(object.srcAccessMask, settings, "VkAccessFlags2", "srcAccessMask", indents + 1, dump_html_VkAccessFlags2);
    dump_html_value<const VkPipelineStageFlags2>(object.dstStageMask, settings, "VkPipelineStageFlags2", "dstStageMask", indents + 1, dump_html_VkPipelineStageFlags2);
    dump_html_value<const VkAccessFlags2>(object.dstAccessMask, settings, "VkAccessFlags2", "dstAccessMask", indents + 1, dump_html_VkAccessFlags2);
    dump_html_value<const uint32_t>(object.srcQueueFamilyIndex, settings, "uint32_t", "srcQueueFamilyIndex", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.dstQueueFamilyIndex, settings, "uint32_t", "dstQueueFamilyIndex", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkBuffer>(object.buffer, settings, "VkBuffer", "buffer", indents + 1, dump_html_VkBuffer);
    dump_html_value<const VkDeviceSize>(object.offset, settings, "VkDeviceSize", "offset", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceSize>(object.size, settings, "VkDeviceSize", "size", indents + 1, dump_html_VkDeviceSize);
}
void dump_html_VkImageMemoryBarrier2(const VkImageMemoryBarrier2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkPipelineStageFlags2>(object.srcStageMask, settings, "VkPipelineStageFlags2", "srcStageMask", indents + 1, dump_html_VkPipelineStageFlags2);
    dump_html_value<const VkAccessFlags2>(object.srcAccessMask, settings, "VkAccessFlags2", "srcAccessMask", indents + 1, dump_html_VkAccessFlags2);
    dump_html_value<const VkPipelineStageFlags2>(object.dstStageMask, settings, "VkPipelineStageFlags2", "dstStageMask", indents + 1, dump_html_VkPipelineStageFlags2);
    dump_html_value<const VkAccessFlags2>(object.dstAccessMask, settings, "VkAccessFlags2", "dstAccessMask", indents + 1, dump_html_VkAccessFlags2);
    dump_html_value<const VkImageLayout>(object.oldLayout, settings, "VkImageLayout", "oldLayout", indents + 1, dump_html_VkImageLayout);
    dump_html_value<const VkImageLayout>(object.newLayout, settings, "VkImageLayout", "newLayout", indents + 1, dump_html_VkImageLayout);
    dump_html_value<const uint32_t>(object.srcQueueFamilyIndex, settings, "uint32_t", "srcQueueFamilyIndex", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.dstQueueFamilyIndex, settings, "uint32_t", "dstQueueFamilyIndex", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkImage>(object.image, settings, "VkImage", "image", indents + 1, dump_html_VkImage);
    dump_html_value<const VkImageSubresourceRange>(object.subresourceRange, settings, "VkImageSubresourceRange", "subresourceRange", indents + 1, dump_html_VkImageSubresourceRange);
}
void dump_html_VkDependencyInfo(const VkDependencyInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDependencyFlags>(object.dependencyFlags, settings, "VkDependencyFlags", "dependencyFlags", indents + 1, dump_html_VkDependencyFlags);
    dump_html_value<const uint32_t>(object.memoryBarrierCount, settings, "uint32_t", "memoryBarrierCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkMemoryBarrier2>(object.pMemoryBarriers, object.memoryBarrierCount, settings, "const VkMemoryBarrier2*", "const VkMemoryBarrier2", "pMemoryBarriers", indents + 1, dump_html_VkMemoryBarrier2); // ZRT
    dump_html_value<const uint32_t>(object.bufferMemoryBarrierCount, settings, "uint32_t", "bufferMemoryBarrierCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkBufferMemoryBarrier2>(object.pBufferMemoryBarriers, object.bufferMemoryBarrierCount, settings, "const VkBufferMemoryBarrier2*", "const VkBufferMemoryBarrier2", "pBufferMemoryBarriers", indents + 1, dump_html_VkBufferMemoryBarrier2); // ZRT
    dump_html_value<const uint32_t>(object.imageMemoryBarrierCount, settings, "uint32_t", "imageMemoryBarrierCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkImageMemoryBarrier2>(object.pImageMemoryBarriers, object.imageMemoryBarrierCount, settings, "const VkImageMemoryBarrier2*", "const VkImageMemoryBarrier2", "pImageMemoryBarriers", indents + 1, dump_html_VkImageMemoryBarrier2); // ZRT
}
void dump_html_VkSemaphoreSubmitInfo(const VkSemaphoreSubmitInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkSemaphore>(object.semaphore, settings, "VkSemaphore", "semaphore", indents + 1, dump_html_VkSemaphore);
    dump_html_value<const uint64_t>(object.value, settings, "uint64_t", "value", indents + 1, dump_html_uint64_t);
    dump_html_value<const VkPipelineStageFlags2>(object.stageMask, settings, "VkPipelineStageFlags2", "stageMask", indents + 1, dump_html_VkPipelineStageFlags2);
    dump_html_value<const uint32_t>(object.deviceIndex, settings, "uint32_t", "deviceIndex", indents + 1, dump_html_uint32_t);
}
void dump_html_VkCommandBufferSubmitInfo(const VkCommandBufferSubmitInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkCommandBuffer>(object.commandBuffer, settings, "VkCommandBuffer", "commandBuffer", indents + 1, dump_html_VkCommandBuffer);
    dump_html_value<const uint32_t>(object.deviceMask, settings, "uint32_t", "deviceMask", indents + 1, dump_html_uint32_t);
}
void dump_html_VkSubmitInfo2(const VkSubmitInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkSubmitFlags>(object.flags, settings, "VkSubmitFlags", "flags", indents + 1, dump_html_VkSubmitFlags);
    dump_html_value<const uint32_t>(object.waitSemaphoreInfoCount, settings, "uint32_t", "waitSemaphoreInfoCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkSemaphoreSubmitInfo>(object.pWaitSemaphoreInfos, object.waitSemaphoreInfoCount, settings, "const VkSemaphoreSubmitInfo*", "const VkSemaphoreSubmitInfo", "pWaitSemaphoreInfos", indents + 1, dump_html_VkSemaphoreSubmitInfo); // ZRT
    dump_html_value<const uint32_t>(object.commandBufferInfoCount, settings, "uint32_t", "commandBufferInfoCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkCommandBufferSubmitInfo>(object.pCommandBufferInfos, object.commandBufferInfoCount, settings, "const VkCommandBufferSubmitInfo*", "const VkCommandBufferSubmitInfo", "pCommandBufferInfos", indents + 1, dump_html_VkCommandBufferSubmitInfo); // ZRT
    dump_html_value<const uint32_t>(object.signalSemaphoreInfoCount, settings, "uint32_t", "signalSemaphoreInfoCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkSemaphoreSubmitInfo>(object.pSignalSemaphoreInfos, object.signalSemaphoreInfoCount, settings, "const VkSemaphoreSubmitInfo*", "const VkSemaphoreSubmitInfo", "pSignalSemaphoreInfos", indents + 1, dump_html_VkSemaphoreSubmitInfo); // ZRT
}
void dump_html_VkPhysicalDeviceSynchronization2Features(const VkPhysicalDeviceSynchronization2Features& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.synchronization2, settings, "VkBool32", "synchronization2", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.shaderZeroInitializeWorkgroupMemory, settings, "VkBool32", "shaderZeroInitializeWorkgroupMemory", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceImageRobustnessFeatures(const VkPhysicalDeviceImageRobustnessFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.robustImageAccess, settings, "VkBool32", "robustImageAccess", indents + 1, dump_html_VkBool32);
}
void dump_html_VkBufferCopy2(const VkBufferCopy2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDeviceSize>(object.srcOffset, settings, "VkDeviceSize", "srcOffset", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceSize>(object.dstOffset, settings, "VkDeviceSize", "dstOffset", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceSize>(object.size, settings, "VkDeviceSize", "size", indents + 1, dump_html_VkDeviceSize);
}
void dump_html_VkCopyBufferInfo2(const VkCopyBufferInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBuffer>(object.srcBuffer, settings, "VkBuffer", "srcBuffer", indents + 1, dump_html_VkBuffer);
    dump_html_value<const VkBuffer>(object.dstBuffer, settings, "VkBuffer", "dstBuffer", indents + 1, dump_html_VkBuffer);
    dump_html_value<const uint32_t>(object.regionCount, settings, "uint32_t", "regionCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkBufferCopy2>(object.pRegions, object.regionCount, settings, "const VkBufferCopy2*", "const VkBufferCopy2", "pRegions", indents + 1, dump_html_VkBufferCopy2); // ZRT
}
void dump_html_VkImageCopy2(const VkImageCopy2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkImageSubresourceLayers>(object.srcSubresource, settings, "VkImageSubresourceLayers", "srcSubresource", indents + 1, dump_html_VkImageSubresourceLayers);
    dump_html_value<const VkOffset3D>(object.srcOffset, settings, "VkOffset3D", "srcOffset", indents + 1, dump_html_VkOffset3D);
    dump_html_value<const VkImageSubresourceLayers>(object.dstSubresource, settings, "VkImageSubresourceLayers", "dstSubresource", indents + 1, dump_html_VkImageSubresourceLayers);
    dump_html_value<const VkOffset3D>(object.dstOffset, settings, "VkOffset3D", "dstOffset", indents + 1, dump_html_VkOffset3D);
    dump_html_value<const VkExtent3D>(object.extent, settings, "VkExtent3D", "extent", indents + 1, dump_html_VkExtent3D);
}
void dump_html_VkCopyImageInfo2(const VkCopyImageInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkImage>(object.srcImage, settings, "VkImage", "srcImage", indents + 1, dump_html_VkImage);
    dump_html_value<const VkImageLayout>(object.srcImageLayout, settings, "VkImageLayout", "srcImageLayout", indents + 1, dump_html_VkImageLayout);
    dump_html_value<const VkImage>(object.dstImage, settings, "VkImage", "dstImage", indents + 1, dump_html_VkImage);
    dump_html_value<const VkImageLayout>(object.dstImageLayout, settings, "VkImageLayout", "dstImageLayout", indents + 1, dump_html_VkImageLayout);
    dump_html_value<const uint32_t>(object.regionCount, settings, "uint32_t", "regionCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkImageCopy2>(object.pRegions, object.regionCount, settings, "const VkImageCopy2*", "const VkImageCopy2", "pRegions", indents + 1, dump_html_VkImageCopy2); // ZRT
}
void dump_html_VkBufferImageCopy2(const VkBufferImageCopy2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDeviceSize>(object.bufferOffset, settings, "VkDeviceSize", "bufferOffset", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const uint32_t>(object.bufferRowLength, settings, "uint32_t", "bufferRowLength", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.bufferImageHeight, settings, "uint32_t", "bufferImageHeight", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkImageSubresourceLayers>(object.imageSubresource, settings, "VkImageSubresourceLayers", "imageSubresource", indents + 1, dump_html_VkImageSubresourceLayers);
    dump_html_value<const VkOffset3D>(object.imageOffset, settings, "VkOffset3D", "imageOffset", indents + 1, dump_html_VkOffset3D);
    dump_html_value<const VkExtent3D>(object.imageExtent, settings, "VkExtent3D", "imageExtent", indents + 1, dump_html_VkExtent3D);
}
void dump_html_VkCopyBufferToImageInfo2(const VkCopyBufferToImageInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBuffer>(object.srcBuffer, settings, "VkBuffer", "srcBuffer", indents + 1, dump_html_VkBuffer);
    dump_html_value<const VkImage>(object.dstImage, settings, "VkImage", "dstImage", indents + 1, dump_html_VkImage);
    dump_html_value<const VkImageLayout>(object.dstImageLayout, settings, "VkImageLayout", "dstImageLayout", indents + 1, dump_html_VkImageLayout);
    dump_html_value<const uint32_t>(object.regionCount, settings, "uint32_t", "regionCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkBufferImageCopy2>(object.pRegions, object.regionCount, settings, "const VkBufferImageCopy2*", "const VkBufferImageCopy2", "pRegions", indents + 1, dump_html_VkBufferImageCopy2); // ZRT
}
void dump_html_VkCopyImageToBufferInfo2(const VkCopyImageToBufferInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkImage>(object.srcImage, settings, "VkImage", "srcImage", indents + 1, dump_html_VkImage);
    dump_html_value<const VkImageLayout>(object.srcImageLayout, settings, "VkImageLayout", "srcImageLayout", indents + 1, dump_html_VkImageLayout);
    dump_html_value<const VkBuffer>(object.dstBuffer, settings, "VkBuffer", "dstBuffer", indents + 1, dump_html_VkBuffer);
    dump_html_value<const uint32_t>(object.regionCount, settings, "uint32_t", "regionCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkBufferImageCopy2>(object.pRegions, object.regionCount, settings, "const VkBufferImageCopy2*", "const VkBufferImageCopy2", "pRegions", indents + 1, dump_html_VkBufferImageCopy2); // ZRT
}
void dump_html_VkImageBlit2(const VkImageBlit2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkImageSubresourceLayers>(object.srcSubresource, settings, "VkImageSubresourceLayers", "srcSubresource", indents + 1, dump_html_VkImageSubresourceLayers);
    dump_html_array<const VkOffset3D>(object.srcOffsets, 2, settings, "VkOffset3D[2]", "VkOffset3D", "srcOffsets", indents + 1, dump_html_VkOffset3D); // ZRR
    dump_html_value<const VkImageSubresourceLayers>(object.dstSubresource, settings, "VkImageSubresourceLayers", "dstSubresource", indents + 1, dump_html_VkImageSubresourceLayers);
    dump_html_array<const VkOffset3D>(object.dstOffsets, 2, settings, "VkOffset3D[2]", "VkOffset3D", "dstOffsets", indents + 1, dump_html_VkOffset3D); // ZRR
}
void dump_html_VkBlitImageInfo2(const VkBlitImageInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkImage>(object.srcImage, settings, "VkImage", "srcImage", indents + 1, dump_html_VkImage);
    dump_html_value<const VkImageLayout>(object.srcImageLayout, settings, "VkImageLayout", "srcImageLayout", indents + 1, dump_html_VkImageLayout);
    dump_html_value<const VkImage>(object.dstImage, settings, "VkImage", "dstImage", indents + 1, dump_html_VkImage);
    dump_html_value<const VkImageLayout>(object.dstImageLayout, settings, "VkImageLayout", "dstImageLayout", indents + 1, dump_html_VkImageLayout);
    dump_html_value<const uint32_t>(object.regionCount, settings, "uint32_t", "regionCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkImageBlit2>(object.pRegions, object.regionCount, settings, "const VkImageBlit2*", "const VkImageBlit2", "pRegions", indents + 1, dump_html_VkImageBlit2); // ZRT
    dump_html_value<const VkFilter>(object.filter, settings, "VkFilter", "filter", indents + 1, dump_html_VkFilter);
}
void dump_html_VkImageResolve2(const VkImageResolve2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkImageSubresourceLayers>(object.srcSubresource, settings, "VkImageSubresourceLayers", "srcSubresource", indents + 1, dump_html_VkImageSubresourceLayers);
    dump_html_value<const VkOffset3D>(object.srcOffset, settings, "VkOffset3D", "srcOffset", indents + 1, dump_html_VkOffset3D);
    dump_html_value<const VkImageSubresourceLayers>(object.dstSubresource, settings, "VkImageSubresourceLayers", "dstSubresource", indents + 1, dump_html_VkImageSubresourceLayers);
    dump_html_value<const VkOffset3D>(object.dstOffset, settings, "VkOffset3D", "dstOffset", indents + 1, dump_html_VkOffset3D);
    dump_html_value<const VkExtent3D>(object.extent, settings, "VkExtent3D", "extent", indents + 1, dump_html_VkExtent3D);
}
void dump_html_VkResolveImageInfo2(const VkResolveImageInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkImage>(object.srcImage, settings, "VkImage", "srcImage", indents + 1, dump_html_VkImage);
    dump_html_value<const VkImageLayout>(object.srcImageLayout, settings, "VkImageLayout", "srcImageLayout", indents + 1, dump_html_VkImageLayout);
    dump_html_value<const VkImage>(object.dstImage, settings, "VkImage", "dstImage", indents + 1, dump_html_VkImage);
    dump_html_value<const VkImageLayout>(object.dstImageLayout, settings, "VkImageLayout", "dstImageLayout", indents + 1, dump_html_VkImageLayout);
    dump_html_value<const uint32_t>(object.regionCount, settings, "uint32_t", "regionCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkImageResolve2>(object.pRegions, object.regionCount, settings, "const VkImageResolve2*", "const VkImageResolve2", "pRegions", indents + 1, dump_html_VkImageResolve2); // ZRT
}
void dump_html_VkPhysicalDeviceSubgroupSizeControlFeatures(const VkPhysicalDeviceSubgroupSizeControlFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.subgroupSizeControl, settings, "VkBool32", "subgroupSizeControl", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.computeFullSubgroups, settings, "VkBool32", "computeFullSubgroups", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceSubgroupSizeControlProperties(const VkPhysicalDeviceSubgroupSizeControlProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.minSubgroupSize, settings, "uint32_t", "minSubgroupSize", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxSubgroupSize, settings, "uint32_t", "maxSubgroupSize", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxComputeWorkgroupSubgroups, settings, "uint32_t", "maxComputeWorkgroupSubgroups", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkShaderStageFlags>(object.requiredSubgroupSizeStages, settings, "VkShaderStageFlags", "requiredSubgroupSizeStages", indents + 1, dump_html_VkShaderStageFlags);
}
void dump_html_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(const VkPipelineShaderStageRequiredSubgroupSizeCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.requiredSubgroupSize, settings, "uint32_t", "requiredSubgroupSize", indents + 1, dump_html_uint32_t);
}
void dump_html_VkPhysicalDeviceInlineUniformBlockFeatures(const VkPhysicalDeviceInlineUniformBlockFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.inlineUniformBlock, settings, "VkBool32", "inlineUniformBlock", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.descriptorBindingInlineUniformBlockUpdateAfterBind, settings, "VkBool32", "descriptorBindingInlineUniformBlockUpdateAfterBind", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceInlineUniformBlockProperties(const VkPhysicalDeviceInlineUniformBlockProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.maxInlineUniformBlockSize, settings, "uint32_t", "maxInlineUniformBlockSize", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxPerStageDescriptorInlineUniformBlocks, settings, "uint32_t", "maxPerStageDescriptorInlineUniformBlocks", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetInlineUniformBlocks, settings, "uint32_t", "maxDescriptorSetInlineUniformBlocks", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindInlineUniformBlocks, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindInlineUniformBlocks", indents + 1, dump_html_uint32_t);
}
void dump_html_VkWriteDescriptorSetInlineUniformBlock(const VkWriteDescriptorSetInlineUniformBlock& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.dataSize, settings, "uint32_t", "dataSize", indents + 1, dump_html_uint32_t);
    dump_html_value<const void*>(object.pData, settings, "const void*", "pData", indents + 1, dump_html_void);
}
void dump_html_VkDescriptorPoolInlineUniformBlockCreateInfo(const VkDescriptorPoolInlineUniformBlockCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.maxInlineUniformBlockBindings, settings, "uint32_t", "maxInlineUniformBlockBindings", indents + 1, dump_html_uint32_t);
}
void dump_html_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(const VkPhysicalDeviceTextureCompressionASTCHDRFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.textureCompressionASTC_HDR, settings, "VkBool32", "textureCompressionASTC_HDR", indents + 1, dump_html_VkBool32);
}
void dump_html_VkRenderingAttachmentInfo(const VkRenderingAttachmentInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkImageView>(object.imageView, settings, "VkImageView", "imageView", indents + 1, dump_html_VkImageView);
    dump_html_value<const VkImageLayout>(object.imageLayout, settings, "VkImageLayout", "imageLayout", indents + 1, dump_html_VkImageLayout);
    dump_html_value<const VkResolveModeFlagBits>(object.resolveMode, settings, "VkResolveModeFlagBits", "resolveMode", indents + 1, dump_html_VkResolveModeFlagBits);
    dump_html_value<const VkImageView>(object.resolveImageView, settings, "VkImageView", "resolveImageView", indents + 1, dump_html_VkImageView);
    dump_html_value<const VkImageLayout>(object.resolveImageLayout, settings, "VkImageLayout", "resolveImageLayout", indents + 1, dump_html_VkImageLayout);
    dump_html_value<const VkAttachmentLoadOp>(object.loadOp, settings, "VkAttachmentLoadOp", "loadOp", indents + 1, dump_html_VkAttachmentLoadOp);
    dump_html_value<const VkAttachmentStoreOp>(object.storeOp, settings, "VkAttachmentStoreOp", "storeOp", indents + 1, dump_html_VkAttachmentStoreOp);
    dump_html_value<const VkClearValue>(object.clearValue, settings, "VkClearValue", "clearValue", indents + 1, dump_html_VkClearValue);
}
void dump_html_VkRenderingInfo(const VkRenderingInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkRenderingFlags>(object.flags, settings, "VkRenderingFlags", "flags", indents + 1, dump_html_VkRenderingFlags);
    dump_html_value<const VkRect2D>(object.renderArea, settings, "VkRect2D", "renderArea", indents + 1, dump_html_VkRect2D);
    dump_html_value<const uint32_t>(object.layerCount, settings, "uint32_t", "layerCount", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.viewMask, settings, "uint32_t", "viewMask", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.colorAttachmentCount, settings, "uint32_t", "colorAttachmentCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkRenderingAttachmentInfo>(object.pColorAttachments, object.colorAttachmentCount, settings, "const VkRenderingAttachmentInfo*", "const VkRenderingAttachmentInfo", "pColorAttachments", indents + 1, dump_html_VkRenderingAttachmentInfo); // ZRT
    dump_html_pointer<const VkRenderingAttachmentInfo>(object.pDepthAttachment, settings, "const VkRenderingAttachmentInfo*", "pDepthAttachment", indents + 1, dump_html_VkRenderingAttachmentInfo);
    dump_html_pointer<const VkRenderingAttachmentInfo>(object.pStencilAttachment, settings, "const VkRenderingAttachmentInfo*", "pStencilAttachment", indents + 1, dump_html_VkRenderingAttachmentInfo);
}
void dump_html_VkPipelineRenderingCreateInfo(const VkPipelineRenderingCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.viewMask, settings, "uint32_t", "viewMask", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.colorAttachmentCount, settings, "uint32_t", "colorAttachmentCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkFormat>(object.pColorAttachmentFormats, object.colorAttachmentCount, settings, "const VkFormat*", "const VkFormat", "pColorAttachmentFormats", indents + 1, dump_html_VkFormat); // ZRT
    dump_html_value<const VkFormat>(object.depthAttachmentFormat, settings, "VkFormat", "depthAttachmentFormat", indents + 1, dump_html_VkFormat);
    dump_html_value<const VkFormat>(object.stencilAttachmentFormat, settings, "VkFormat", "stencilAttachmentFormat", indents + 1, dump_html_VkFormat);
}
void dump_html_VkPhysicalDeviceDynamicRenderingFeatures(const VkPhysicalDeviceDynamicRenderingFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.dynamicRendering, settings, "VkBool32", "dynamicRendering", indents + 1, dump_html_VkBool32);
}
void dump_html_VkCommandBufferInheritanceRenderingInfo(const VkCommandBufferInheritanceRenderingInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkRenderingFlags>(object.flags, settings, "VkRenderingFlags", "flags", indents + 1, dump_html_VkRenderingFlags);
    dump_html_value<const uint32_t>(object.viewMask, settings, "uint32_t", "viewMask", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.colorAttachmentCount, settings, "uint32_t", "colorAttachmentCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkFormat>(object.pColorAttachmentFormats, object.colorAttachmentCount, settings, "const VkFormat*", "const VkFormat", "pColorAttachmentFormats", indents + 1, dump_html_VkFormat); // ZRT
    dump_html_value<const VkFormat>(object.depthAttachmentFormat, settings, "VkFormat", "depthAttachmentFormat", indents + 1, dump_html_VkFormat);
    dump_html_value<const VkFormat>(object.stencilAttachmentFormat, settings, "VkFormat", "stencilAttachmentFormat", indents + 1, dump_html_VkFormat);
    dump_html_value<const VkSampleCountFlagBits>(object.rasterizationSamples, settings, "VkSampleCountFlagBits", "rasterizationSamples", indents + 1, dump_html_VkSampleCountFlagBits);
}
void dump_html_VkPhysicalDeviceShaderIntegerDotProductFeatures(const VkPhysicalDeviceShaderIntegerDotProductFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.shaderIntegerDotProduct, settings, "VkBool32", "shaderIntegerDotProduct", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceShaderIntegerDotProductProperties(const VkPhysicalDeviceShaderIntegerDotProductProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.integerDotProduct8BitUnsignedAccelerated, settings, "VkBool32", "integerDotProduct8BitUnsignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct8BitSignedAccelerated, settings, "VkBool32", "integerDotProduct8BitSignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct8BitMixedSignednessAccelerated, settings, "VkBool32", "integerDotProduct8BitMixedSignednessAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct4x8BitPackedUnsignedAccelerated, settings, "VkBool32", "integerDotProduct4x8BitPackedUnsignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct4x8BitPackedSignedAccelerated, settings, "VkBool32", "integerDotProduct4x8BitPackedSignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct4x8BitPackedMixedSignednessAccelerated, settings, "VkBool32", "integerDotProduct4x8BitPackedMixedSignednessAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct16BitUnsignedAccelerated, settings, "VkBool32", "integerDotProduct16BitUnsignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct16BitSignedAccelerated, settings, "VkBool32", "integerDotProduct16BitSignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct16BitMixedSignednessAccelerated, settings, "VkBool32", "integerDotProduct16BitMixedSignednessAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct32BitUnsignedAccelerated, settings, "VkBool32", "integerDotProduct32BitUnsignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct32BitSignedAccelerated, settings, "VkBool32", "integerDotProduct32BitSignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct32BitMixedSignednessAccelerated, settings, "VkBool32", "integerDotProduct32BitMixedSignednessAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct64BitUnsignedAccelerated, settings, "VkBool32", "integerDotProduct64BitUnsignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct64BitSignedAccelerated, settings, "VkBool32", "integerDotProduct64BitSignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProduct64BitMixedSignednessAccelerated, settings, "VkBool32", "integerDotProduct64BitMixedSignednessAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating8BitUnsignedAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating8BitUnsignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating8BitSignedAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating8BitSignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating16BitUnsignedAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating16BitUnsignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating16BitSignedAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating16BitSignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating32BitUnsignedAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating32BitUnsignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating32BitSignedAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating32BitSignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating64BitUnsignedAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating64BitUnsignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating64BitSignedAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating64BitSignedAccelerated", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated, settings, "VkBool32", "integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceTexelBufferAlignmentProperties(const VkPhysicalDeviceTexelBufferAlignmentProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDeviceSize>(object.storageTexelBufferOffsetAlignmentBytes, settings, "VkDeviceSize", "storageTexelBufferOffsetAlignmentBytes", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkBool32>(object.storageTexelBufferOffsetSingleTexelAlignment, settings, "VkBool32", "storageTexelBufferOffsetSingleTexelAlignment", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkDeviceSize>(object.uniformTexelBufferOffsetAlignmentBytes, settings, "VkDeviceSize", "uniformTexelBufferOffsetAlignmentBytes", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkBool32>(object.uniformTexelBufferOffsetSingleTexelAlignment, settings, "VkBool32", "uniformTexelBufferOffsetSingleTexelAlignment", indents + 1, dump_html_VkBool32);
}
void dump_html_VkFormatProperties3(const VkFormatProperties3& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkFormatFeatureFlags2>(object.linearTilingFeatures, settings, "VkFormatFeatureFlags2", "linearTilingFeatures", indents + 1, dump_html_VkFormatFeatureFlags2);
    dump_html_value<const VkFormatFeatureFlags2>(object.optimalTilingFeatures, settings, "VkFormatFeatureFlags2", "optimalTilingFeatures", indents + 1, dump_html_VkFormatFeatureFlags2);
    dump_html_value<const VkFormatFeatureFlags2>(object.bufferFeatures, settings, "VkFormatFeatureFlags2", "bufferFeatures", indents + 1, dump_html_VkFormatFeatureFlags2);
}
void dump_html_VkPhysicalDeviceMaintenance4Features(const VkPhysicalDeviceMaintenance4Features& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.maintenance4, settings, "VkBool32", "maintenance4", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceMaintenance4Properties(const VkPhysicalDeviceMaintenance4Properties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDeviceSize>(object.maxBufferSize, settings, "VkDeviceSize", "maxBufferSize", indents + 1, dump_html_VkDeviceSize);
}
void dump_html_VkDeviceBufferMemoryRequirements(const VkDeviceBufferMemoryRequirements& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_pointer<const VkBufferCreateInfo>(object.pCreateInfo, settings, "const VkBufferCreateInfo*", "pCreateInfo", indents + 1, dump_html_VkBufferCreateInfo);
}
void dump_html_VkDeviceImageMemoryRequirements(const VkDeviceImageMemoryRequirements& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_pointer<const VkImageCreateInfo>(object.pCreateInfo, settings, "const VkImageCreateInfo*", "pCreateInfo", indents + 1, dump_html_VkImageCreateInfo);
    dump_html_value<const VkImageAspectFlagBits>(object.planeAspect, settings, "VkImageAspectFlagBits", "planeAspect", indents + 1, dump_html_VkImageAspectFlagBits);
}
void dump_html_VkSurfaceCapabilitiesKHR(const VkSurfaceCapabilitiesKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const uint32_t>(object.minImageCount, settings, "uint32_t", "minImageCount", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxImageCount, settings, "uint32_t", "maxImageCount", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkExtent2D>(object.currentExtent, settings, "VkExtent2D", "currentExtent", indents + 1, dump_html_VkExtent2D);
    dump_html_value<const VkExtent2D>(object.minImageExtent, settings, "VkExtent2D", "minImageExtent", indents + 1, dump_html_VkExtent2D);
    dump_html_value<const VkExtent2D>(object.maxImageExtent, settings, "VkExtent2D", "maxImageExtent", indents + 1, dump_html_VkExtent2D);
    dump_html_value<const uint32_t>(object.maxImageArrayLayers, settings, "uint32_t", "maxImageArrayLayers", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkSurfaceTransformFlagsKHR>(object.supportedTransforms, settings, "VkSurfaceTransformFlagsKHR", "supportedTransforms", indents + 1, dump_html_VkSurfaceTransformFlagsKHR);
    dump_html_value<const VkSurfaceTransformFlagBitsKHR>(object.currentTransform, settings, "VkSurfaceTransformFlagBitsKHR", "currentTransform", indents + 1, dump_html_VkSurfaceTransformFlagBitsKHR);
    dump_html_value<const VkCompositeAlphaFlagsKHR>(object.supportedCompositeAlpha, settings, "VkCompositeAlphaFlagsKHR", "supportedCompositeAlpha", indents + 1, dump_html_VkCompositeAlphaFlagsKHR);
    dump_html_value<const VkImageUsageFlags>(object.supportedUsageFlags, settings, "VkImageUsageFlags", "supportedUsageFlags", indents + 1, dump_html_VkImageUsageFlags);
}
void dump_html_VkSurfaceFormatKHR(const VkSurfaceFormatKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkFormat>(object.format, settings, "VkFormat", "format", indents + 1, dump_html_VkFormat);
    dump_html_value<const VkColorSpaceKHR>(object.colorSpace, settings, "VkColorSpaceKHR", "colorSpace", indents + 1, dump_html_VkColorSpaceKHR);
}
void dump_html_VkSwapchainCreateInfoKHR(const VkSwapchainCreateInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkSwapchainCreateFlagsKHR>(object.flags, settings, "VkSwapchainCreateFlagsKHR", "flags", indents + 1, dump_html_VkSwapchainCreateFlagsKHR);
    dump_html_value<const VkSurfaceKHR>(object.surface, settings, "VkSurfaceKHR", "surface", indents + 1, dump_html_VkSurfaceKHR);
    dump_html_value<const uint32_t>(object.minImageCount, settings, "uint32_t", "minImageCount", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkFormat>(object.imageFormat, settings, "VkFormat", "imageFormat", indents + 1, dump_html_VkFormat);
    dump_html_value<const VkColorSpaceKHR>(object.imageColorSpace, settings, "VkColorSpaceKHR", "imageColorSpace", indents + 1, dump_html_VkColorSpaceKHR);
    dump_html_value<const VkExtent2D>(object.imageExtent, settings, "VkExtent2D", "imageExtent", indents + 1, dump_html_VkExtent2D);
    dump_html_value<const uint32_t>(object.imageArrayLayers, settings, "uint32_t", "imageArrayLayers", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkImageUsageFlags>(object.imageUsage, settings, "VkImageUsageFlags", "imageUsage", indents + 1, dump_html_VkImageUsageFlags);
    dump_html_value<const VkSharingMode>(object.imageSharingMode, settings, "VkSharingMode", "imageSharingMode", indents + 1, dump_html_VkSharingMode);
    dump_html_value<const uint32_t>(object.queueFamilyIndexCount, settings, "uint32_t", "queueFamilyIndexCount", indents + 1, dump_html_uint32_t);
    if(object.imageSharingMode == VK_SHARING_MODE_CONCURRENT)
    dump_html_array<const uint32_t>(object.pQueueFamilyIndices, object.queueFamilyIndexCount, settings, "const uint32_t*", "const uint32_t", "pQueueFamilyIndices", indents + 1, dump_html_uint32_t); // ZRT
    else
        dump_html_special("UNUSED", settings, "const uint32_t*", "pQueueFamilyIndices", indents + 1);
    dump_html_value<const VkSurfaceTransformFlagBitsKHR>(object.preTransform, settings, "VkSurfaceTransformFlagBitsKHR", "preTransform", indents + 1, dump_html_VkSurfaceTransformFlagBitsKHR);
    dump_html_value<const VkCompositeAlphaFlagBitsKHR>(object.compositeAlpha, settings, "VkCompositeAlphaFlagBitsKHR", "compositeAlpha", indents + 1, dump_html_VkCompositeAlphaFlagBitsKHR);
    dump_html_value<const VkPresentModeKHR>(object.presentMode, settings, "VkPresentModeKHR", "presentMode", indents + 1, dump_html_VkPresentModeKHR);
    dump_html_value<const VkBool32>(object.clipped, settings, "VkBool32", "clipped", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkSwapchainKHR>(object.oldSwapchain, settings, "VkSwapchainKHR", "oldSwapchain", indents + 1, dump_html_VkSwapchainKHR);
}
void dump_html_VkPresentInfoKHR(const VkPresentInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.waitSemaphoreCount, settings, "uint32_t", "waitSemaphoreCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkSemaphore>(object.pWaitSemaphores, object.waitSemaphoreCount, settings, "const VkSemaphore*", "const VkSemaphore", "pWaitSemaphores", indents + 1, dump_html_VkSemaphore); // ZRT
    dump_html_value<const uint32_t>(object.swapchainCount, settings, "uint32_t", "swapchainCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkSwapchainKHR>(object.pSwapchains, object.swapchainCount, settings, "const VkSwapchainKHR*", "const VkSwapchainKHR", "pSwapchains", indents + 1, dump_html_VkSwapchainKHR); // ZRT
    dump_html_array<const uint32_t>(object.pImageIndices, object.swapchainCount, settings, "const uint32_t*", "const uint32_t", "pImageIndices", indents + 1, dump_html_uint32_t); // ZRT
    dump_html_array<const VkResult>(object.pResults, object.swapchainCount, settings, "VkResult*", "VkResult", "pResults", indents + 1, dump_html_VkResult); // ZRT
}
void dump_html_VkImageSwapchainCreateInfoKHR(const VkImageSwapchainCreateInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkSwapchainKHR>(object.swapchain, settings, "VkSwapchainKHR", "swapchain", indents + 1, dump_html_VkSwapchainKHR);
}
void dump_html_VkBindImageMemorySwapchainInfoKHR(const VkBindImageMemorySwapchainInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkSwapchainKHR>(object.swapchain, settings, "VkSwapchainKHR", "swapchain", indents + 1, dump_html_VkSwapchainKHR);
    dump_html_value<const uint32_t>(object.imageIndex, settings, "uint32_t", "imageIndex", indents + 1, dump_html_uint32_t);
}
void dump_html_VkAcquireNextImageInfoKHR(const VkAcquireNextImageInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkSwapchainKHR>(object.swapchain, settings, "VkSwapchainKHR", "swapchain", indents + 1, dump_html_VkSwapchainKHR);
    dump_html_value<const uint64_t>(object.timeout, settings, "uint64_t", "timeout", indents + 1, dump_html_uint64_t);
    dump_html_value<const VkSemaphore>(object.semaphore, settings, "VkSemaphore", "semaphore", indents + 1, dump_html_VkSemaphore);
    dump_html_value<const VkFence>(object.fence, settings, "VkFence", "fence", indents + 1, dump_html_VkFence);
    dump_html_value<const uint32_t>(object.deviceMask, settings, "uint32_t", "deviceMask", indents + 1, dump_html_uint32_t);
}
void dump_html_VkDeviceGroupPresentCapabilitiesKHR(const VkDeviceGroupPresentCapabilitiesKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_array<const uint32_t>(object.presentMask, 32, settings, "uint32_t[VK_MAX_DEVICE_GROUP_SIZE]", "uint32_t", "presentMask", indents + 1, dump_html_uint32_t); // ZRR
    dump_html_value<const VkDeviceGroupPresentModeFlagsKHR>(object.modes, settings, "VkDeviceGroupPresentModeFlagsKHR", "modes", indents + 1, dump_html_VkDeviceGroupPresentModeFlagsKHR);
}
void dump_html_VkDeviceGroupPresentInfoKHR(const VkDeviceGroupPresentInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.swapchainCount, settings, "uint32_t", "swapchainCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const uint32_t>(object.pDeviceMasks, object.swapchainCount, settings, "const uint32_t*", "const uint32_t", "pDeviceMasks", indents + 1, dump_html_uint32_t); // ZRT
    dump_html_value<const VkDeviceGroupPresentModeFlagBitsKHR>(object.mode, settings, "VkDeviceGroupPresentModeFlagBitsKHR", "mode", indents + 1, dump_html_VkDeviceGroupPresentModeFlagBitsKHR);
}
void dump_html_VkDeviceGroupSwapchainCreateInfoKHR(const VkDeviceGroupSwapchainCreateInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDeviceGroupPresentModeFlagsKHR>(object.modes, settings, "VkDeviceGroupPresentModeFlagsKHR", "modes", indents + 1, dump_html_VkDeviceGroupPresentModeFlagsKHR);
}
void dump_html_VkDisplayModeParametersKHR(const VkDisplayModeParametersKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkExtent2D>(object.visibleRegion, settings, "VkExtent2D", "visibleRegion", indents + 1, dump_html_VkExtent2D);
    dump_html_value<const uint32_t>(object.refreshRate, settings, "uint32_t", "refreshRate", indents + 1, dump_html_uint32_t);
}
void dump_html_VkDisplayModeCreateInfoKHR(const VkDisplayModeCreateInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDisplayModeCreateFlagsKHR>(object.flags, settings, "VkDisplayModeCreateFlagsKHR", "flags", indents + 1, dump_html_VkDisplayModeCreateFlagsKHR);
    dump_html_value<const VkDisplayModeParametersKHR>(object.parameters, settings, "VkDisplayModeParametersKHR", "parameters", indents + 1, dump_html_VkDisplayModeParametersKHR);
}
void dump_html_VkDisplayModePropertiesKHR(const VkDisplayModePropertiesKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkDisplayModeKHR>(object.displayMode, settings, "VkDisplayModeKHR", "displayMode", indents + 1, dump_html_VkDisplayModeKHR);
    dump_html_value<const VkDisplayModeParametersKHR>(object.parameters, settings, "VkDisplayModeParametersKHR", "parameters", indents + 1, dump_html_VkDisplayModeParametersKHR);
}
void dump_html_VkDisplayPlaneCapabilitiesKHR(const VkDisplayPlaneCapabilitiesKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkDisplayPlaneAlphaFlagsKHR>(object.supportedAlpha, settings, "VkDisplayPlaneAlphaFlagsKHR", "supportedAlpha", indents + 1, dump_html_VkDisplayPlaneAlphaFlagsKHR);
    dump_html_value<const VkOffset2D>(object.minSrcPosition, settings, "VkOffset2D", "minSrcPosition", indents + 1, dump_html_VkOffset2D);
    dump_html_value<const VkOffset2D>(object.maxSrcPosition, settings, "VkOffset2D", "maxSrcPosition", indents + 1, dump_html_VkOffset2D);
    dump_html_value<const VkExtent2D>(object.minSrcExtent, settings, "VkExtent2D", "minSrcExtent", indents + 1, dump_html_VkExtent2D);
    dump_html_value<const VkExtent2D>(object.maxSrcExtent, settings, "VkExtent2D", "maxSrcExtent", indents + 1, dump_html_VkExtent2D);
    dump_html_value<const VkOffset2D>(object.minDstPosition, settings, "VkOffset2D", "minDstPosition", indents + 1, dump_html_VkOffset2D);
    dump_html_value<const VkOffset2D>(object.maxDstPosition, settings, "VkOffset2D", "maxDstPosition", indents + 1, dump_html_VkOffset2D);
    dump_html_value<const VkExtent2D>(object.minDstExtent, settings, "VkExtent2D", "minDstExtent", indents + 1, dump_html_VkExtent2D);
    dump_html_value<const VkExtent2D>(object.maxDstExtent, settings, "VkExtent2D", "maxDstExtent", indents + 1, dump_html_VkExtent2D);
}
void dump_html_VkDisplayPlanePropertiesKHR(const VkDisplayPlanePropertiesKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkDisplayKHR>(object.currentDisplay, settings, "VkDisplayKHR", "currentDisplay", indents + 1, dump_html_VkDisplayKHR);
    dump_html_value<const uint32_t>(object.currentStackIndex, settings, "uint32_t", "currentStackIndex", indents + 1, dump_html_uint32_t);
}
void dump_html_VkDisplayPropertiesKHR(const VkDisplayPropertiesKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkDisplayKHR>(object.display, settings, "VkDisplayKHR", "display", indents + 1, dump_html_VkDisplayKHR);
    dump_html_value<const char*>(object.displayName, settings, "const char*", "displayName", indents + 1, dump_html_cstring);
    dump_html_value<const VkExtent2D>(object.physicalDimensions, settings, "VkExtent2D", "physicalDimensions", indents + 1, dump_html_VkExtent2D);
    dump_html_value<const VkExtent2D>(object.physicalResolution, settings, "VkExtent2D", "physicalResolution", indents + 1, dump_html_VkExtent2D);
    dump_html_value<const VkSurfaceTransformFlagsKHR>(object.supportedTransforms, settings, "VkSurfaceTransformFlagsKHR", "supportedTransforms", indents + 1, dump_html_VkSurfaceTransformFlagsKHR);
    dump_html_value<const VkBool32>(object.planeReorderPossible, settings, "VkBool32", "planeReorderPossible", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.persistentContent, settings, "VkBool32", "persistentContent", indents + 1, dump_html_VkBool32);
}
void dump_html_VkDisplaySurfaceCreateInfoKHR(const VkDisplaySurfaceCreateInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDisplaySurfaceCreateFlagsKHR>(object.flags, settings, "VkDisplaySurfaceCreateFlagsKHR", "flags", indents + 1, dump_html_VkDisplaySurfaceCreateFlagsKHR);
    dump_html_value<const VkDisplayModeKHR>(object.displayMode, settings, "VkDisplayModeKHR", "displayMode", indents + 1, dump_html_VkDisplayModeKHR);
    dump_html_value<const uint32_t>(object.planeIndex, settings, "uint32_t", "planeIndex", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.planeStackIndex, settings, "uint32_t", "planeStackIndex", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkSurfaceTransformFlagBitsKHR>(object.transform, settings, "VkSurfaceTransformFlagBitsKHR", "transform", indents + 1, dump_html_VkSurfaceTransformFlagBitsKHR);
    dump_html_value<const float>(object.globalAlpha, settings, "float", "globalAlpha", indents + 1, dump_html_float);
    dump_html_value<const VkDisplayPlaneAlphaFlagBitsKHR>(object.alphaMode, settings, "VkDisplayPlaneAlphaFlagBitsKHR", "alphaMode", indents + 1, dump_html_VkDisplayPlaneAlphaFlagBitsKHR);
    dump_html_value<const VkExtent2D>(object.imageExtent, settings, "VkExtent2D", "imageExtent", indents + 1, dump_html_VkExtent2D);
}
void dump_html_VkDisplayPresentInfoKHR(const VkDisplayPresentInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkRect2D>(object.srcRect, settings, "VkRect2D", "srcRect", indents + 1, dump_html_VkRect2D);
    dump_html_value<const VkRect2D>(object.dstRect, settings, "VkRect2D", "dstRect", indents + 1, dump_html_VkRect2D);
    dump_html_value<const VkBool32>(object.persistent, settings, "VkBool32", "persistent", indents + 1, dump_html_VkBool32);
}
#if defined(VK_USE_PLATFORM_XLIB_KHR)
void dump_html_VkXlibSurfaceCreateInfoKHR(const VkXlibSurfaceCreateInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkXlibSurfaceCreateFlagsKHR>(object.flags, settings, "VkXlibSurfaceCreateFlagsKHR", "flags", indents + 1, dump_html_VkXlibSurfaceCreateFlagsKHR);
    dump_html_value<const Display*>(object.dpy, settings, "Display*", "dpy", indents + 1, dump_html_Display);
    dump_html_value<const Window>(object.window, settings, "Window", "window", indents + 1, dump_html_Window);
}
#endif // VK_USE_PLATFORM_XLIB_KHR
#if defined(VK_USE_PLATFORM_XCB_KHR)
void dump_html_VkXcbSurfaceCreateInfoKHR(const VkXcbSurfaceCreateInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkXcbSurfaceCreateFlagsKHR>(object.flags, settings, "VkXcbSurfaceCreateFlagsKHR", "flags", indents + 1, dump_html_VkXcbSurfaceCreateFlagsKHR);
    dump_html_value<const xcb_connection_t*>(object.connection, settings, "xcb_connection_t*", "connection", indents + 1, dump_html_xcb_connection_t);
    dump_html_value<const xcb_window_t>(object.window, settings, "xcb_window_t", "window", indents + 1, dump_html_xcb_window_t);
}
#endif // VK_USE_PLATFORM_XCB_KHR
#if defined(VK_USE_PLATFORM_WAYLAND_KHR)
void dump_html_VkWaylandSurfaceCreateInfoKHR(const VkWaylandSurfaceCreateInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkWaylandSurfaceCreateFlagsKHR>(object.flags, settings, "VkWaylandSurfaceCreateFlagsKHR", "flags", indents + 1, dump_html_VkWaylandSurfaceCreateFlagsKHR);
    dump_html_pointer<const wl_display>(object.display, settings, "struct wl_display*", "display", indents + 1, dump_html_wl_display);
    dump_html_pointer<const wl_surface>(object.surface, settings, "struct wl_surface*", "surface", indents + 1, dump_html_wl_surface);
}
#endif // VK_USE_PLATFORM_WAYLAND_KHR
#if defined(VK_USE_PLATFORM_ANDROID_KHR)
void dump_html_VkAndroidSurfaceCreateInfoKHR(const VkAndroidSurfaceCreateInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkAndroidSurfaceCreateFlagsKHR>(object.flags, settings, "VkAndroidSurfaceCreateFlagsKHR", "flags", indents + 1, dump_html_VkAndroidSurfaceCreateFlagsKHR);
    dump_html_value<const ANativeWindow*>(object.window, settings, "struct ANativeWindow*", "window", indents + 1, dump_html_ANativeWindow);
}
#endif // VK_USE_PLATFORM_ANDROID_KHR
#if defined(VK_USE_PLATFORM_WIN32_KHR)
void dump_html_VkWin32SurfaceCreateInfoKHR(const VkWin32SurfaceCreateInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkWin32SurfaceCreateFlagsKHR>(object.flags, settings, "VkWin32SurfaceCreateFlagsKHR", "flags", indents + 1, dump_html_VkWin32SurfaceCreateFlagsKHR);
    dump_html_value<const HINSTANCE>(object.hinstance, settings, "HINSTANCE", "hinstance", indents + 1, dump_html_HINSTANCE);
    dump_html_value<const HWND>(object.hwnd, settings, "HWND", "hwnd", indents + 1, dump_html_HWND);
}
#endif // VK_USE_PLATFORM_WIN32_KHR
void dump_html_VkDebugReportCallbackCreateInfoEXT(const VkDebugReportCallbackCreateInfoEXT& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDebugReportFlagsEXT>(object.flags, settings, "VkDebugReportFlagsEXT", "flags", indents + 1, dump_html_VkDebugReportFlagsEXT);
    dump_html_value<const PFN_vkDebugReportCallbackEXT>(object.pfnCallback, settings, "PFN_vkDebugReportCallbackEXT", "pfnCallback", indents + 1, dump_html_PFN_vkDebugReportCallbackEXT);
    dump_html_value<const void*>(object.pUserData, settings, "void*", "pUserData", indents + 1, dump_html_void);
}
void dump_html_VkPipelineRasterizationStateRasterizationOrderAMD(const VkPipelineRasterizationStateRasterizationOrderAMD& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkRasterizationOrderAMD>(object.rasterizationOrder, settings, "VkRasterizationOrderAMD", "rasterizationOrder", indents + 1, dump_html_VkRasterizationOrderAMD);
}
void dump_html_VkDebugMarkerObjectNameInfoEXT(const VkDebugMarkerObjectNameInfoEXT& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDebugReportObjectTypeEXT>(object.objectType, settings, "VkDebugReportObjectTypeEXT", "objectType", indents + 1, dump_html_VkDebugReportObjectTypeEXT);
    dump_html_value<const uint64_t>(object.object, settings, "uint64_t", "object", indents + 1, dump_html_uint64_t);
    dump_html_value<const char*>(object.pObjectName, settings, "const char*", "pObjectName", indents + 1, dump_html_cstring);
}
void dump_html_VkDebugMarkerObjectTagInfoEXT(const VkDebugMarkerObjectTagInfoEXT& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDebugReportObjectTypeEXT>(object.objectType, settings, "VkDebugReportObjectTypeEXT", "objectType", indents + 1, dump_html_VkDebugReportObjectTypeEXT);
    dump_html_value<const uint64_t>(object.object, settings, "uint64_t", "object", indents + 1, dump_html_uint64_t);
    dump_html_value<const uint64_t>(object.tagName, settings, "uint64_t", "tagName", indents + 1, dump_html_uint64_t);
    dump_html_value<const size_t>(object.tagSize, settings, "size_t", "tagSize", indents + 1, dump_html_size_t);
    dump_html_value<const void*>(object.pTag, settings, "const void*", "pTag", indents + 1, dump_html_void);
}
void dump_html_VkDebugMarkerMarkerInfoEXT(const VkDebugMarkerMarkerInfoEXT& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const char*>(object.pMarkerName, settings, "const char*", "pMarkerName", indents + 1, dump_html_cstring);
    dump_html_array<const float>(object.color, 4, settings, "float[4]", "float", "color", indents + 1, dump_html_float); // ZRR
}
void dump_html_VkQueueFamilyQueryResultStatusPropertiesKHR(const VkQueueFamilyQueryResultStatusPropertiesKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.queryResultStatusSupport, settings, "VkBool32", "queryResultStatusSupport", indents + 1, dump_html_VkBool32);
}
void dump_html_VkQueueFamilyVideoPropertiesKHR(const VkQueueFamilyVideoPropertiesKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkVideoCodecOperationFlagsKHR>(object.videoCodecOperations, settings, "VkVideoCodecOperationFlagsKHR", "videoCodecOperations", indents + 1, dump_html_VkVideoCodecOperationFlagsKHR);
}
void dump_html_VkVideoProfileInfoKHR(const VkVideoProfileInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkVideoCodecOperationFlagBitsKHR>(object.videoCodecOperation, settings, "VkVideoCodecOperationFlagBitsKHR", "videoCodecOperation", indents + 1, dump_html_VkVideoCodecOperationFlagBitsKHR);
    dump_html_value<const VkVideoChromaSubsamplingFlagsKHR>(object.chromaSubsampling, settings, "VkVideoChromaSubsamplingFlagsKHR", "chromaSubsampling", indents + 1, dump_html_VkVideoChromaSubsamplingFlagsKHR);
    dump_html_value<const VkVideoComponentBitDepthFlagsKHR>(object.lumaBitDepth, settings, "VkVideoComponentBitDepthFlagsKHR", "lumaBitDepth", indents + 1, dump_html_VkVideoComponentBitDepthFlagsKHR);
    dump_html_value<const VkVideoComponentBitDepthFlagsKHR>(object.chromaBitDepth, settings, "VkVideoComponentBitDepthFlagsKHR", "chromaBitDepth", indents + 1, dump_html_VkVideoComponentBitDepthFlagsKHR);
}
void dump_html_VkVideoProfileListInfoKHR(const VkVideoProfileListInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.profileCount, settings, "uint32_t", "profileCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkVideoProfileInfoKHR>(object.pProfiles, object.profileCount, settings, "const VkVideoProfileInfoKHR*", "const VkVideoProfileInfoKHR", "pProfiles", indents + 1, dump_html_VkVideoProfileInfoKHR); // ZRT
}
void dump_html_VkVideoCapabilitiesKHR(const VkVideoCapabilitiesKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkVideoCapabilityFlagsKHR>(object.flags, settings, "VkVideoCapabilityFlagsKHR", "flags", indents + 1, dump_html_VkVideoCapabilityFlagsKHR);
    dump_html_value<const VkDeviceSize>(object.minBitstreamBufferOffsetAlignment, settings, "VkDeviceSize", "minBitstreamBufferOffsetAlignment", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceSize>(object.minBitstreamBufferSizeAlignment, settings, "VkDeviceSize", "minBitstreamBufferSizeAlignment", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkExtent2D>(object.pictureAccessGranularity, settings, "VkExtent2D", "pictureAccessGranularity", indents + 1, dump_html_VkExtent2D);
    dump_html_value<const VkExtent2D>(object.minCodedExtent, settings, "VkExtent2D", "minCodedExtent", indents + 1, dump_html_VkExtent2D);
    dump_html_value<const VkExtent2D>(object.maxCodedExtent, settings, "VkExtent2D", "maxCodedExtent", indents + 1, dump_html_VkExtent2D);
    dump_html_value<const uint32_t>(object.maxDpbSlots, settings, "uint32_t", "maxDpbSlots", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxActiveReferencePictures, settings, "uint32_t", "maxActiveReferencePictures", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkExtensionProperties>(object.stdHeaderVersion, settings, "VkExtensionProperties", "stdHeaderVersion", indents + 1, dump_html_VkExtensionProperties);
}
void dump_html_VkPhysicalDeviceVideoFormatInfoKHR(const VkPhysicalDeviceVideoFormatInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkImageUsageFlags>(object.imageUsage, settings, "VkImageUsageFlags", "imageUsage", indents + 1, dump_html_VkImageUsageFlags);
}
void dump_html_VkVideoFormatPropertiesKHR(const VkVideoFormatPropertiesKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkFormat>(object.format, settings, "VkFormat", "format", indents + 1, dump_html_VkFormat);
    dump_html_value<const VkComponentMapping>(object.componentMapping, settings, "VkComponentMapping", "componentMapping", indents + 1, dump_html_VkComponentMapping);
    dump_html_value<const VkImageCreateFlags>(object.imageCreateFlags, settings, "VkImageCreateFlags", "imageCreateFlags", indents + 1, dump_html_VkImageCreateFlags);
    dump_html_value<const VkImageType>(object.imageType, settings, "VkImageType", "imageType", indents + 1, dump_html_VkImageType);
    dump_html_value<const VkImageTiling>(object.imageTiling, settings, "VkImageTiling", "imageTiling", indents + 1, dump_html_VkImageTiling);
    dump_html_value<const VkImageUsageFlags>(object.imageUsageFlags, settings, "VkImageUsageFlags", "imageUsageFlags", indents + 1, dump_html_VkImageUsageFlags);
}
void dump_html_VkVideoPictureResourceInfoKHR(const VkVideoPictureResourceInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkOffset2D>(object.codedOffset, settings, "VkOffset2D", "codedOffset", indents + 1, dump_html_VkOffset2D);
    dump_html_value<const VkExtent2D>(object.codedExtent, settings, "VkExtent2D", "codedExtent", indents + 1, dump_html_VkExtent2D);
    dump_html_value<const uint32_t>(object.baseArrayLayer, settings, "uint32_t", "baseArrayLayer", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkImageView>(object.imageViewBinding, settings, "VkImageView", "imageViewBinding", indents + 1, dump_html_VkImageView);
}
void dump_html_VkVideoReferenceSlotInfoKHR(const VkVideoReferenceSlotInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const int32_t>(object.slotIndex, settings, "int32_t", "slotIndex", indents + 1, dump_html_int32_t);
    dump_html_pointer<const VkVideoPictureResourceInfoKHR>(object.pPictureResource, settings, "const VkVideoPictureResourceInfoKHR*", "pPictureResource", indents + 1, dump_html_VkVideoPictureResourceInfoKHR);
}
void dump_html_VkVideoSessionMemoryRequirementsKHR(const VkVideoSessionMemoryRequirementsKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.memoryBindIndex, settings, "uint32_t", "memoryBindIndex", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkMemoryRequirements>(object.memoryRequirements, settings, "VkMemoryRequirements", "memoryRequirements", indents + 1, dump_html_VkMemoryRequirements);
}
void dump_html_VkBindVideoSessionMemoryInfoKHR(const VkBindVideoSessionMemoryInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.memoryBindIndex, settings, "uint32_t", "memoryBindIndex", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkDeviceMemory>(object.memory, settings, "VkDeviceMemory", "memory", indents + 1, dump_html_VkDeviceMemory);
    dump_html_value<const VkDeviceSize>(object.memoryOffset, settings, "VkDeviceSize", "memoryOffset", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceSize>(object.memorySize, settings, "VkDeviceSize", "memorySize", indents + 1, dump_html_VkDeviceSize);
}
void dump_html_VkVideoSessionCreateInfoKHR(const VkVideoSessionCreateInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.queueFamilyIndex, settings, "uint32_t", "queueFamilyIndex", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkVideoSessionCreateFlagsKHR>(object.flags, settings, "VkVideoSessionCreateFlagsKHR", "flags", indents + 1, dump_html_VkVideoSessionCreateFlagsKHR);
    dump_html_pointer<const VkVideoProfileInfoKHR>(object.pVideoProfile, settings, "const VkVideoProfileInfoKHR*", "pVideoProfile", indents + 1, dump_html_VkVideoProfileInfoKHR);
    dump_html_value<const VkFormat>(object.pictureFormat, settings, "VkFormat", "pictureFormat", indents + 1, dump_html_VkFormat);
    dump_html_value<const VkExtent2D>(object.maxCodedExtent, settings, "VkExtent2D", "maxCodedExtent", indents + 1, dump_html_VkExtent2D);
    dump_html_value<const VkFormat>(object.referencePictureFormat, settings, "VkFormat", "referencePictureFormat", indents + 1, dump_html_VkFormat);
    dump_html_value<const uint32_t>(object.maxDpbSlots, settings, "uint32_t", "maxDpbSlots", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxActiveReferencePictures, settings, "uint32_t", "maxActiveReferencePictures", indents + 1, dump_html_uint32_t);
    dump_html_pointer<const VkExtensionProperties>(object.pStdHeaderVersion, settings, "const VkExtensionProperties*", "pStdHeaderVersion", indents + 1, dump_html_VkExtensionProperties);
}
void dump_html_VkVideoSessionParametersCreateInfoKHR(const VkVideoSessionParametersCreateInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkVideoSessionParametersCreateFlagsKHR>(object.flags, settings, "VkVideoSessionParametersCreateFlagsKHR", "flags", indents + 1, dump_html_VkVideoSessionParametersCreateFlagsKHR);
    dump_html_value<const VkVideoSessionParametersKHR>(object.videoSessionParametersTemplate, settings, "VkVideoSessionParametersKHR", "videoSessionParametersTemplate", indents + 1, dump_html_VkVideoSessionParametersKHR);
    dump_html_value<const VkVideoSessionKHR>(object.videoSession, settings, "VkVideoSessionKHR", "videoSession", indents + 1, dump_html_VkVideoSessionKHR);
}
void dump_html_VkVideoSessionParametersUpdateInfoKHR(const VkVideoSessionParametersUpdateInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.updateSequenceCount, settings, "uint32_t", "updateSequenceCount", indents + 1, dump_html_uint32_t);
}
void dump_html_VkVideoBeginCodingInfoKHR(const VkVideoBeginCodingInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkVideoBeginCodingFlagsKHR>(object.flags, settings, "VkVideoBeginCodingFlagsKHR", "flags", indents + 1, dump_html_VkVideoBeginCodingFlagsKHR);
    dump_html_value<const VkVideoSessionKHR>(object.videoSession, settings, "VkVideoSessionKHR", "videoSession", indents + 1, dump_html_VkVideoSessionKHR);
    dump_html_value<const VkVideoSessionParametersKHR>(object.videoSessionParameters, settings, "VkVideoSessionParametersKHR", "videoSessionParameters", indents + 1, dump_html_VkVideoSessionParametersKHR);
    dump_html_value<const uint32_t>(object.referenceSlotCount, settings, "uint32_t", "referenceSlotCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkVideoReferenceSlotInfoKHR>(object.pReferenceSlots, object.referenceSlotCount, settings, "const VkVideoReferenceSlotInfoKHR*", "const VkVideoReferenceSlotInfoKHR", "pReferenceSlots", indents + 1, dump_html_VkVideoReferenceSlotInfoKHR); // ZRT
}
void dump_html_VkVideoEndCodingInfoKHR(const VkVideoEndCodingInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkVideoEndCodingFlagsKHR>(object.flags, settings, "VkVideoEndCodingFlagsKHR", "flags", indents + 1, dump_html_VkVideoEndCodingFlagsKHR);
}
void dump_html_VkVideoCodingControlInfoKHR(const VkVideoCodingControlInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkVideoCodingControlFlagsKHR>(object.flags, settings, "VkVideoCodingControlFlagsKHR", "flags", indents + 1, dump_html_VkVideoCodingControlFlagsKHR);
}
void dump_html_VkVideoDecodeCapabilitiesKHR(const VkVideoDecodeCapabilitiesKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkVideoDecodeCapabilityFlagsKHR>(object.flags, settings, "VkVideoDecodeCapabilityFlagsKHR", "flags", indents + 1, dump_html_VkVideoDecodeCapabilityFlagsKHR);
}
void dump_html_VkVideoDecodeUsageInfoKHR(const VkVideoDecodeUsageInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkVideoDecodeUsageFlagsKHR>(object.videoUsageHints, settings, "VkVideoDecodeUsageFlagsKHR", "videoUsageHints", indents + 1, dump_html_VkVideoDecodeUsageFlagsKHR);
}
void dump_html_VkVideoDecodeInfoKHR(const VkVideoDecodeInfoKHR& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkVideoDecodeFlagsKHR>(object.flags, settings, "VkVideoDecodeFlagsKHR", "flags", indents + 1, dump_html_VkVideoDecodeFlagsKHR);
    dump_html_value<const VkBuffer>(object.srcBuffer, settings, "VkBuffer", "srcBuffer", indents + 1, dump_html_VkBuffer);
    dump_html_value<const VkDeviceSize>(object.srcBufferOffset, settings, "VkDeviceSize", "srcBufferOffset", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkDeviceSize>(object.srcBufferRange, settings, "VkDeviceSize", "srcBufferRange", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const VkVideoPictureResourceInfoKHR>(object.dstPictureResource, settings, "VkVideoPictureResourceInfoKHR", "dstPictureResource", indents + 1, dump_html_VkVideoPictureResourceInfoKHR);
    dump_html_pointer<const VkVideoReferenceSlotInfoKHR>(object.pSetupReferenceSlot, settings, "const VkVideoReferenceSlotInfoKHR*", "pSetupReferenceSlot", indents + 1, dump_html_VkVideoReferenceSlotInfoKHR);
    dump_html_value<const uint32_t>(object.referenceSlotCount, settings, "uint32_t", "referenceSlotCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const VkVideoReferenceSlotInfoKHR>(object.pReferenceSlots, object.referenceSlotCount, settings, "const VkVideoReferenceSlotInfoKHR*", "const VkVideoReferenceSlotInfoKHR", "pReferenceSlots", indents + 1, dump_html_VkVideoReferenceSlotInfoKHR); // ZRT
}
void dump_html_VkDedicatedAllocationImageCreateInfoNV(const VkDedicatedAllocationImageCreateInfoNV& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.dedicatedAllocation, settings, "VkBool32", "dedicatedAllocation", indents + 1, dump_html_VkBool32);
}
void dump_html_VkDedicatedAllocationBufferCreateInfoNV(const VkDedicatedAllocationBufferCreateInfoNV& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.dedicatedAllocation, settings, "VkBool32", "dedicatedAllocation", indents + 1, dump_html_VkBool32);
}
void dump_html_VkDedicatedAllocationMemoryAllocateInfoNV(const VkDedicatedAllocationMemoryAllocateInfoNV& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkImage>(object.image, settings, "VkImage", "image", indents + 1, dump_html_VkImage);
    dump_html_value<const VkBuffer>(object.buffer, settings, "VkBuffer", "buffer", indents + 1, dump_html_VkBuffer);
}
void dump_html_VkPhysicalDeviceTransformFeedbackFeaturesEXT(const VkPhysicalDeviceTransformFeedbackFeaturesEXT& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkBool32>(object.transformFeedback, settings, "VkBool32", "transformFeedback", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.geometryStreams, settings, "VkBool32", "geometryStreams", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPhysicalDeviceTransformFeedbackPropertiesEXT(const VkPhysicalDeviceTransformFeedbackPropertiesEXT& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.maxTransformFeedbackStreams, settings, "uint32_t", "maxTransformFeedbackStreams", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxTransformFeedbackBuffers, settings, "uint32_t", "maxTransformFeedbackBuffers", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkDeviceSize>(object.maxTransformFeedbackBufferSize, settings, "VkDeviceSize", "maxTransformFeedbackBufferSize", indents + 1, dump_html_VkDeviceSize);
    dump_html_value<const uint32_t>(object.maxTransformFeedbackStreamDataSize, settings, "uint32_t", "maxTransformFeedbackStreamDataSize", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxTransformFeedbackBufferDataSize, settings, "uint32_t", "maxTransformFeedbackBufferDataSize", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxTransformFeedbackBufferDataStride, settings, "uint32_t", "maxTransformFeedbackBufferDataStride", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkBool32>(object.transformFeedbackQueries, settings, "VkBool32", "transformFeedbackQueries", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.transformFeedbackStreamsLinesTriangles, settings, "VkBool32", "transformFeedbackStreamsLinesTriangles", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.transformFeedbackRasterizationStreamSelect, settings, "VkBool32", "transformFeedbackRasterizationStreamSelect", indents + 1, dump_html_VkBool32);
    dump_html_value<const VkBool32>(object.transformFeedbackDraw, settings, "VkBool32", "transformFeedbackDraw", indents + 1, dump_html_VkBool32);
}
void dump_html_VkPipelineRasterizationStateStreamCreateInfoEXT(const VkPipelineRasterizationStateStreamCreateInfoEXT& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkPipelineRasterizationStateStreamCreateFlagsEXT>(object.flags, settings, "VkPipelineRasterizationStateStreamCreateFlagsEXT", "flags", indents + 1, dump_html_VkPipelineRasterizationStateStreamCreateFlagsEXT);
    dump_html_value<const uint32_t>(object.rasterizationStream, settings, "uint32_t", "rasterizationStream", indents + 1, dump_html_uint32_t);
}
void dump_html_VkCuModuleCreateInfoNVX(const VkCuModuleCreateInfoNVX& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const size_t>(object.dataSize, settings, "size_t", "dataSize", indents + 1, dump_html_size_t);
    dump_html_value<const void*>(object.pData, settings, "const void*", "pData", indents + 1, dump_html_void);
}
void dump_html_VkCuFunctionCreateInfoNVX(const VkCuFunctionCreateInfoNVX& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkCuModuleNVX>(object.module, settings, "VkCuModuleNVX", "module", indents + 1, dump_html_VkCuModuleNVX);
    dump_html_value<const char*>(object.pName, settings, "const char*", "pName", indents + 1, dump_html_cstring);
}
void dump_html_VkCuLaunchInfoNVX(const VkCuLaunchInfoNVX& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkCuFunctionNVX>(object.function, settings, "VkCuFunctionNVX", "function", indents + 1, dump_html_VkCuFunctionNVX);
    dump_html_value<const uint32_t>(object.gridDimX, settings, "uint32_t", "gridDimX", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.gridDimY, settings, "uint32_t", "gridDimY", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.gridDimZ, settings, "uint32_t", "gridDimZ", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.blockDimX, settings, "uint32_t", "blockDimX", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.blockDimY, settings, "uint32_t", "blockDimY", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.blockDimZ, settings, "uint32_t", "blockDimZ", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.sharedMemBytes, settings, "uint32_t", "sharedMemBytes", indents + 1, dump_html_uint32_t);
    dump_html_value<const size_t>(object.paramCount, settings, "size_t", "paramCount", indents + 1, dump_html_size_t);
    dump_html_array<const void*>(object.pParams, object.paramCount, settings, "const void* const *", "const void* const ", "pParams", indents + 1, dump_html_void); // ZRT
    dump_html_value<const size_t>(object.extraCount, settings, "size_t", "extraCount", indents + 1, dump_html_size_t);
    dump_html_array<const void*>(object.pExtras, object.extraCount, settings, "const void* const *", "const void* const ", "pExtras", indents + 1, dump_html_void); // ZRT
}
void dump_html_VkImageViewHandleInfoNVX(const VkImageViewHandleInfoNVX& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkImageView>(object.imageView, settings, "VkImageView", "imageView", indents + 1, dump_html_VkImageView);
    dump_html_value<const VkDescriptorType>(object.descriptorType, settings, "VkDescriptorType", "descriptorType", indents + 1, dump_html_VkDescriptorType);
    dump_html_value<const VkSampler>(object.sampler, settings, "VkSampler", "sampler", indents + 1, dump_html_VkSampler);
}
void dump_html_VkImageViewAddressPropertiesNVX(const VkImageViewAddressPropertiesNVX& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkDeviceAddress>(object.deviceAddress, settings, "VkDeviceAddress", "deviceAddress", indents + 1, dump_html_VkDeviceAddress);
    dump_html_value<const VkDeviceSize>(object.size, settings, "VkDeviceSize", "size", indents + 1, dump_html_VkDeviceSize);
}
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeH264CapabilitiesEXT(const VkVideoEncodeH264CapabilitiesEXT& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const VkVideoEncodeH264CapabilityFlagsEXT>(object.flags, settings, "VkVideoEncodeH264CapabilityFlagsEXT", "flags", indents + 1, dump_html_VkVideoEncodeH264CapabilityFlagsEXT);
    dump_html_value<const uint32_t>(object.maxPPictureL0ReferenceCount, settings, "uint32_t", "maxPPictureL0ReferenceCount", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxBPictureL0ReferenceCount, settings, "uint32_t", "maxBPictureL0ReferenceCount", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxL1ReferenceCount, settings, "uint32_t", "maxL1ReferenceCount", indents + 1, dump_html_uint32_t);
    dump_html_value<const VkBool32>(object.motionVectorsOverPicBoundariesFlag, settings, "VkBool32", "motionVectorsOverPicBoundariesFlag", indents + 1, dump_html_VkBool32);
    dump_html_value<const uint32_t>(object.maxBytesPerPicDenom, settings, "uint32_t", "maxBytesPerPicDenom", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxBitsPerMbDenom, settings, "uint32_t", "maxBitsPerMbDenom", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.log2MaxMvLengthHorizontal, settings, "uint32_t", "log2MaxMvLengthHorizontal", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.log2MaxMvLengthVertical, settings, "uint32_t", "log2MaxMvLengthVertical", indents + 1, dump_html_uint32_t);
}
#endif // VK_ENABLE_BETA_EXTENSIONS
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeH264SessionParametersAddInfoEXT(const VkVideoEncodeH264SessionParametersAddInfoEXT& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.stdSPSCount, settings, "uint32_t", "stdSPSCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const StdVideoH264SequenceParameterSet>(object.pStdSPSs, object.stdSPSCount, settings, "const StdVideoH264SequenceParameterSet*", "const StdVideoH264SequenceParameterSet", "pStdSPSs", indents + 1, dump_html_StdVideoH264SequenceParameterSet); // ZRT
    dump_html_value<const uint32_t>(object.stdPPSCount, settings, "uint32_t", "stdPPSCount", indents + 1, dump_html_uint32_t);
    dump_html_array<const StdVideoH264PictureParameterSet>(object.pStdPPSs, object.stdPPSCount, settings, "const StdVideoH264PictureParameterSet*", "const StdVideoH264PictureParameterSet", "pStdPPSs", indents + 1, dump_html_StdVideoH264PictureParameterSet); // ZRT
}
#endif // VK_ENABLE_BETA_EXTENSIONS
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeH264SessionParametersCreateInfoEXT(const VkVideoEncodeH264SessionParametersCreateInfoEXT& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.maxStdSPSCount, settings, "uint32_t", "maxStdSPSCount", indents + 1, dump_html_uint32_t);
    dump_html_value<const uint32_t>(object.maxStdPPSCount, settings, "uint32_t", "maxStdPPSCount", indents + 1, dump_html_uint32_t);
    dump_html_pointer<const VkVideoEncodeH264SessionParametersAddInfoEXT>(object.pParametersAddInfo, settings, "const VkVideoEncodeH264SessionParametersAddInfoEXT*", "pParametersAddInfo", indents + 1, dump_html_VkVideoEncodeH264SessionParametersAddInfoEXT);
}
#endif // VK_ENABLE_BETA_EXTENSIONS
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeH264NaluSliceInfoEXT(const VkVideoEncodeH264NaluSliceInfoEXT& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "const void*", "pNext", indents + 1, dump_html_void);
    }
    dump_html_value<const uint32_t>(object.mbCount, settings, "uint32_t", "mbCount", indents + 1, dump_html_uint32_t);
    dump_html_pointer<const StdVideoEncodeH264ReferenceListsInfo>(object.pStdReferenceFinalLists, settings, "const StdVideoEncodeH264ReferenceListsInfo*", "pStdReferenceFinalLists", indents + 1, dump_html_StdVideoEncodeH264ReferenceListsInfo);
    dump_html_pointer<const StdVideoEncodeH264SliceHeader>(object.pStdSliceHeader, settings, "const StdVideoEncodeH264SliceHeader*", "pStdSliceHeader", indents + 1, dump_html_StdVideoEncodeH264SliceHeader);
}
#endif // VK_ENABLE_BETA_EXTENSIONS
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_html_VkVideoEncodeH264VclFrameInfoEXT(const VkVideoEncodeH264VclFrameInfoEXT& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "<div class='val'>";
    if(settings.showAddress())
        settings.stream() << &object << "\n";
    else
        settings.stream() << "address\n";
    settings.stream() << "</div></summary>";
    dump_html_value<const VkStructureType>(object.sType, settings, "VkStructureType", "sType", indents + 1, dump_html_VkStructureType);
    if(object.pNext != nullptr){
        dump_html_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_html_value<const void*>(object.pNext, settings, "cons