/**
 * @file option_enum.cpp
 * Helpers for option enumerators.
 * Automatically generated by <code>scripts/make_option_enum.py</code>
 * from option.h.
 */

#include "options.h"

#include "base_types.h"
#include "logger.h"

#include <cstdlib>

#ifdef HAVE_STRINGS_H
#include <strings.h>  // strcasecmp()
#endif

#if defined(_MSC_VER)
#pragma warning(disable: 4809)
#elif __GNUC__ > 4 || __clang_major__ > 3 || __clang_minor__ > 4
#pragma GCC diagnostic ignored "-Wswitch-bool"
#endif

namespace uncrustify
{

const char *const iarf_values[] = {
   "ignore",
   "add",
   "remove",
   "force",
   "not_defined",
   nullptr
};

const char *const line_end_values[] = {
   "lf",
   "crlf",
   "cr",
   "auto",
   nullptr
};

const char *const token_pos_values[] = {
   "ignore",
   "break",
   "force",
   "lead",
   "trail",
   "join",
   "lead_break",
   "lead_force",
   "trail_break",
   "trail_force",
   nullptr
};


//-----------------------------------------------------------------------------
bool convert_string(const char *in, bool &out)
{
   if (false)
   {
   }
   else if (strcasecmp(in, "true") == 0)
   {
      out = true;
      return(true);
   }
   else if (strcasecmp(in, "1") == 0)
   {
      out = true;
      return(true);
   }
   else if (strcasecmp(in, "t") == 0)
   {
      out = true;
      return(true);
   }
   else if (strcasecmp(in, "y") == 0)
   {
      out = true;
      return(true);
   }
   else if (strcasecmp(in, "yes") == 0)
   {
      out = true;
      return(true);
   }
   else if (strcasecmp(in, "false") == 0)
   {
      out = false;
      return(true);
   }
   else if (strcasecmp(in, "0") == 0)
   {
      out = false;
      return(true);
   }
   else if (strcasecmp(in, "f") == 0)
   {
      out = false;
      return(true);
   }
   else if (strcasecmp(in, "n") == 0)
   {
      out = false;
      return(true);
   }
   else if (strcasecmp(in, "no") == 0)
   {
      out = false;
      return(true);
   }
   else
   {
      return(false);
   }
}


//-----------------------------------------------------------------------------
bool convert_string(const char *in, iarf_e &out)
{
   if (false)
   {
   }
   else if (strcasecmp(in, "ignore") == 0)
   {
      out = IARF_IGNORE;
      return(true);
   }
   else if (strcasecmp(in, "i") == 0)
   {
      out = IARF_IGNORE;
      return(true);
   }
   else if (strcasecmp(in, "add") == 0)
   {
      out = IARF_ADD;
      return(true);
   }
   else if (strcasecmp(in, "a") == 0)
   {
      out = IARF_ADD;
      return(true);
   }
   else if (strcasecmp(in, "2") == 0)
   {
      out = IARF_ADD;
      return(true);
   }
   else if (strcasecmp(in, "t") == 0)
   {
      out = IARF_ADD;
      return(true);
   }
   else if (strcasecmp(in, "true") == 0)
   {
      out = IARF_ADD;
      return(true);
   }
   else if (strcasecmp(in, "y") == 0)
   {
      out = IARF_ADD;
      return(true);
   }
   else if (strcasecmp(in, "yes") == 0)
   {
      out = IARF_ADD;
      return(true);
   }
   else if (strcasecmp(in, "remove") == 0)
   {
      out = IARF_REMOVE;
      return(true);
   }
   else if (strcasecmp(in, "r") == 0)
   {
      out = IARF_REMOVE;
      return(true);
   }
   else if (strcasecmp(in, "0") == 0)
   {
      out = IARF_REMOVE;
      return(true);
   }
   else if (strcasecmp(in, "f") == 0)
   {
      out = IARF_REMOVE;
      return(true);
   }
   else if (strcasecmp(in, "false") == 0)
   {
      out = IARF_REMOVE;
      return(true);
   }
   else if (strcasecmp(in, "n") == 0)
   {
      out = IARF_REMOVE;
      return(true);
   }
   else if (strcasecmp(in, "no") == 0)
   {
      out = IARF_REMOVE;
      return(true);
   }
   else if (strcasecmp(in, "force") == 0)
   {
      out = IARF_FORCE;
      return(true);
   }
   else if (strcasecmp(in, "f") == 0)
   {
      out = IARF_FORCE;
      return(true);
   }
   else if (strcasecmp(in, "1") == 0)
   {
      out = IARF_FORCE;
      return(true);
   }
   else if (strcasecmp(in, "not_defined") == 0)
   {
      out = IARF_NOT_DEFINED;
      return(true);
   }
   else
   {
      return(false);
   }
}


//-----------------------------------------------------------------------------
bool convert_string(const char *in, line_end_e &out)
{
   if (false)
   {
   }
   else if (strcasecmp(in, "lf") == 0)
   {
      out = LE_LF;
      return(true);
   }
   else if (strcasecmp(in, "crlf") == 0)
   {
      out = LE_CRLF;
      return(true);
   }
   else if (strcasecmp(in, "cr") == 0)
   {
      out = LE_CR;
      return(true);
   }
   else if (strcasecmp(in, "auto") == 0)
   {
      out = LE_AUTO;
      return(true);
   }
   else
   {
      return(false);
   }
}


//-----------------------------------------------------------------------------
bool convert_string(const char *in, token_pos_e &out)
{
   if (false)
   {
   }
   else if (strcasecmp(in, "ignore") == 0)
   {
      out = TP_IGNORE;
      return(true);
   }
   else if (strcasecmp(in, "break") == 0)
   {
      out = TP_BREAK;
      return(true);
   }
   else if (strcasecmp(in, "force") == 0)
   {
      out = TP_FORCE;
      return(true);
   }
   else if (strcasecmp(in, "lead") == 0)
   {
      out = TP_LEAD;
      return(true);
   }
   else if (strcasecmp(in, "trail") == 0)
   {
      out = TP_TRAIL;
      return(true);
   }
   else if (strcasecmp(in, "join") == 0)
   {
      out = TP_JOIN;
      return(true);
   }
   else if (strcasecmp(in, "lead_break") == 0)
   {
      out = TP_LEAD_BREAK;
      return(true);
   }
   else if (strcasecmp(in, "lead_force") == 0)
   {
      out = TP_LEAD_FORCE;
      return(true);
   }
   else if (strcasecmp(in, "trail_break") == 0)
   {
      out = TP_TRAIL_BREAK;
      return(true);
   }
   else if (strcasecmp(in, "trail_force") == 0)
   {
      out = TP_TRAIL_FORCE;
      return(true);
   }
   else
   {
      return(false);
   }
}


//-----------------------------------------------------------------------------
const char *to_string(option_type_e val)
{
   switch (val)
   {
   case OT_BOOL:
      return "BOOL";

   case OT_IARF:
      return "IARF";

   case OT_LINEEND:
      return "LINEEND";

   case OT_TOKENPOS:
      return "TOKENPOS";

   case OT_NUM:
      return "NUM";

   case OT_UNUM:
      return "UNUM";

   case OT_STRING:
      return "STRING";

   default:
      fprintf(stderr, "%s: Unknown option_type_e '%d'\n",
              __func__, static_cast<int>(val));
      log_flush(true);
      exit(EX_SOFTWARE);
   }
}


//-----------------------------------------------------------------------------
const char *to_string(bool val)
{
   switch (val)
   {
   case true:
      return "true";

   case false:
      return "false";

   default:
      fprintf(stderr, "%s: Unknown bool '%d'\n",
              __func__, static_cast<int>(val));
      log_flush(true);
      exit(EX_SOFTWARE);
   }
}


//-----------------------------------------------------------------------------
const char *to_string(iarf_e val)
{
   switch (val)
   {
   case IARF_IGNORE:
      return "ignore";

   case IARF_ADD:
      return "add";

   case IARF_REMOVE:
      return "remove";

   case IARF_FORCE:
      return "force";

   case IARF_NOT_DEFINED:
      return "not_defined";

   default:
      fprintf(stderr, "%s: Unknown iarf_e '%d'\n",
              __func__, static_cast<int>(val));
      log_flush(true);
      exit(EX_SOFTWARE);
   }
}


//-----------------------------------------------------------------------------
const char *to_string(line_end_e val)
{
   switch (val)
   {
   case LE_LF:
      return "lf";

   case LE_CRLF:
      return "crlf";

   case LE_CR:
      return "cr";

   case LE_AUTO:
      return "auto";

   default:
      fprintf(stderr, "%s: Unknown line_end_e '%d'\n",
              __func__, static_cast<int>(val));
      log_flush(true);
      exit(EX_SOFTWARE);
   }
}


//-----------------------------------------------------------------------------
const char *to_string(token_pos_e val)
{
   switch (val)
   {
   case TP_IGNORE:
      return "ignore";

   case TP_BREAK:
      return "break";

   case TP_FORCE:
      return "force";

   case TP_LEAD:
      return "lead";

   case TP_TRAIL:
      return "trail";

   case TP_JOIN:
      return "join";

   case TP_LEAD_BREAK:
      return "lead_break";

   case TP_LEAD_FORCE:
      return "lead_force";

   case TP_TRAIL_BREAK:
      return "trail_break";

   case TP_TRAIL_FORCE:
      return "trail_force";

   default:
      fprintf(stderr, "%s: Unknown token_pos_e '%d'\n",
              __func__, static_cast<int>(val));
      log_flush(true);
      exit(EX_SOFTWARE);
   }
}

} // namespace uncrustify
