/* ScaleRevealer.c generated by valac 0.56.17, the Vala compiler
 * generated from ScaleRevealer.vala, do not modify */

/* ScaleRevealer is ported from Fractal*/
/* https://gitlab.gnome.org/GNOME/fractal/-/blob/e1976cd4e182cc8513d52c1a985a4fce9a056ad2/src/components/scale_revealer.rs*/

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <graphene-gobject.h>
#include <float.h>
#include <math.h>
#include <gsk/gsk.h>
#include <string.h>

#define TUBA_WIDGETS_SCALE_REVEALER_ANIMATION_DURATION ((guint) 300)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TUBA_WIDGETS_TYPE_SCALE_REVEALER (tuba_widgets_scale_revealer_get_type ())
#define TUBA_WIDGETS_SCALE_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_WIDGETS_TYPE_SCALE_REVEALER, TubaWidgetsScaleRevealer))
#define TUBA_WIDGETS_SCALE_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_WIDGETS_TYPE_SCALE_REVEALER, TubaWidgetsScaleRevealerClass))
#define TUBA_WIDGETS_IS_SCALE_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_WIDGETS_TYPE_SCALE_REVEALER))
#define TUBA_WIDGETS_IS_SCALE_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_WIDGETS_TYPE_SCALE_REVEALER))
#define TUBA_WIDGETS_SCALE_REVEALER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_WIDGETS_TYPE_SCALE_REVEALER, TubaWidgetsScaleRevealerClass))

typedef struct _TubaWidgetsScaleRevealer TubaWidgetsScaleRevealer;
typedef struct _TubaWidgetsScaleRevealerClass TubaWidgetsScaleRevealerClass;
typedef struct _TubaWidgetsScaleRevealerPrivate TubaWidgetsScaleRevealerPrivate;
enum  {
	TUBA_WIDGETS_SCALE_REVEALER_0_PROPERTY,
	TUBA_WIDGETS_SCALE_REVEALER_ANIMATION_PROPERTY,
	TUBA_WIDGETS_SCALE_REVEALER_SOURCE_WIDGET_PROPERTY,
	TUBA_WIDGETS_SCALE_REVEALER_SOURCE_WIDGET_TEXTURE_PROPERTY,
	TUBA_WIDGETS_SCALE_REVEALER_REVEAL_CHILD_PROPERTY,
	TUBA_WIDGETS_SCALE_REVEALER_NUM_PROPERTIES
};
static GParamSpec* tuba_widgets_scale_revealer_properties[TUBA_WIDGETS_SCALE_REVEALER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gsk_render_node_unref0(var) ((var == NULL) ? NULL : (var = (gsk_render_node_unref (var), NULL)))
enum  {
	TUBA_WIDGETS_SCALE_REVEALER_TRANSITION_DONE_SIGNAL,
	TUBA_WIDGETS_SCALE_REVEALER_NUM_SIGNALS
};
static guint tuba_widgets_scale_revealer_signals[TUBA_WIDGETS_SCALE_REVEALER_NUM_SIGNALS] = {0};

struct _TubaWidgetsScaleRevealer {
	AdwBin parent_instance;
	TubaWidgetsScaleRevealerPrivate * priv;
};

struct _TubaWidgetsScaleRevealerClass {
	AdwBinClass parent_class;
};

struct _TubaWidgetsScaleRevealerPrivate {
	AdwTimedAnimation* _animation;
	GtkWidget* _source_widget;
	GdkTexture* _source_widget_texture;
	gboolean _reveal_child;
};

static gint TubaWidgetsScaleRevealer_private_offset;
static gpointer tuba_widgets_scale_revealer_parent_class = NULL;

VALA_EXTERN GType tuba_widgets_scale_revealer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaWidgetsScaleRevealer, g_object_unref)
static void tuba_widgets_scale_revealer_update_source_widget (TubaWidgetsScaleRevealer* self);
VALA_EXTERN GtkWidget* tuba_widgets_scale_revealer_get_source_widget (TubaWidgetsScaleRevealer* self);
VALA_EXTERN void tuba_widgets_scale_revealer_set_source_widget_texture (TubaWidgetsScaleRevealer* self,
                                                            GdkTexture* value);
static GdkTexture* tuba_widgets_scale_revealer_render_widget_to_texture (TubaWidgetsScaleRevealer* self,
                                                                  GtkWidget* widget);
static void tuba_widgets_scale_revealer_on_animation_end (TubaWidgetsScaleRevealer* self);
VALA_EXTERN gboolean tuba_widgets_scale_revealer_get_reveal_child (TubaWidgetsScaleRevealer* self);
static void tuba_widgets_scale_revealer_animation_target_cb (TubaWidgetsScaleRevealer* self,
                                                      gdouble value);
static void tuba_widgets_scale_revealer_real_snapshot (GtkWidget* base,
                                                GtkSnapshot* snapshot);
VALA_EXTERN AdwTimedAnimation* tuba_widgets_scale_revealer_get_animation (TubaWidgetsScaleRevealer* self);
VALA_EXTERN GdkTexture* tuba_widgets_scale_revealer_get_source_widget_texture (TubaWidgetsScaleRevealer* self);
VALA_EXTERN TubaWidgetsScaleRevealer* tuba_widgets_scale_revealer_new (void);
VALA_EXTERN TubaWidgetsScaleRevealer* tuba_widgets_scale_revealer_construct (GType object_type);
VALA_EXTERN void tuba_widgets_scale_revealer_set_animation (TubaWidgetsScaleRevealer* self,
                                                AdwTimedAnimation* value);
VALA_EXTERN void tuba_widgets_scale_revealer_set_source_widget (TubaWidgetsScaleRevealer* self,
                                                    GtkWidget* value);
VALA_EXTERN void tuba_widgets_scale_revealer_set_reveal_child (TubaWidgetsScaleRevealer* self,
                                                   gboolean value);
static GObject * tuba_widgets_scale_revealer_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _tuba_widgets_scale_revealer_animation_target_cb_adw_animation_target_func (gdouble value,
                                                                                 gpointer self);
static void _tuba_widgets_scale_revealer_on_animation_end_adw_animation_done (AdwAnimation* _sender,
                                                                       gpointer self);
static void tuba_widgets_scale_revealer_finalize (GObject * obj);
static GType tuba_widgets_scale_revealer_get_type_once (void);
static void _vala_tuba_widgets_scale_revealer_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_tuba_widgets_scale_revealer_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);

static const graphene_rect_t TUBA_WIDGETS_SCALE_REVEALER_FALLBACK_BOUNDS = {{0.0f, 0.0f}, {100.0f, 100.0f}};

static inline gpointer
tuba_widgets_scale_revealer_get_instance_private (TubaWidgetsScaleRevealer* self)
{
	return G_STRUCT_MEMBER_P (self, TubaWidgetsScaleRevealer_private_offset);
}

static void
tuba_widgets_scale_revealer_update_source_widget (TubaWidgetsScaleRevealer* self)
{
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tuba_widgets_scale_revealer_get_source_widget (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		tuba_widgets_scale_revealer_set_source_widget_texture (self, NULL);
	} else {
		GdkTexture* t_source_widget_texture = NULL;
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		GdkTexture* _tmp4_;
		GdkTexture* _tmp5_;
		GtkWidget* _tmp7_;
		GtkWidget* _tmp8_;
		_tmp2_ = tuba_widgets_scale_revealer_get_source_widget (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = tuba_widgets_scale_revealer_render_widget_to_texture (self, _tmp3_);
		t_source_widget_texture = _tmp4_;
		_tmp5_ = t_source_widget_texture;
		if (_tmp5_ != NULL) {
			GdkTexture* _tmp6_;
			_tmp6_ = t_source_widget_texture;
			tuba_widgets_scale_revealer_set_source_widget_texture (self, _tmp6_);
		}
		_tmp7_ = tuba_widgets_scale_revealer_get_source_widget (self);
		_tmp8_ = _tmp7_;
		gtk_widget_set_opacity (_tmp8_, 0.0);
		_g_object_unref0 (t_source_widget_texture);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GdkTexture*
tuba_widgets_scale_revealer_render_widget_to_texture (TubaWidgetsScaleRevealer* self,
                                                      GtkWidget* widget)
{
	GtkWidgetPaintable* widget_paintable = NULL;
	GtkWidgetPaintable* _tmp0_;
	GtkSnapshot* t_snapshot = NULL;
	GtkSnapshot* _tmp1_;
	GtkWidgetPaintable* _tmp2_;
	GtkSnapshot* _tmp3_;
	GtkWidgetPaintable* _tmp4_;
	GtkWidgetPaintable* _tmp5_;
	GskRenderNode* node = NULL;
	GtkSnapshot* _tmp6_;
	GskRenderNode* _tmp7_;
	GtkNative* native = NULL;
	GtkNative* _tmp8_;
	GtkNative* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GtkNative* _tmp11_;
	GtkNative* _tmp13_;
	GskRenderer* _tmp14_;
	GskRenderNode* _tmp15_;
	GdkTexture* _tmp16_;
	GdkTexture* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (widget != NULL, NULL);
	_tmp0_ = (GtkWidgetPaintable*) gtk_widget_paintable_new (widget);
	widget_paintable = _tmp0_;
	_tmp1_ = gtk_snapshot_new ();
	t_snapshot = _tmp1_;
	_tmp2_ = widget_paintable;
	_tmp3_ = t_snapshot;
	_tmp4_ = widget_paintable;
	_tmp5_ = widget_paintable;
	gdk_paintable_snapshot ((GdkPaintable*) _tmp2_, (GdkSnapshot*) _tmp3_, (gdouble) gdk_paintable_get_intrinsic_width ((GdkPaintable*) _tmp4_), (gdouble) gdk_paintable_get_intrinsic_height ((GdkPaintable*) _tmp5_));
	_tmp6_ = t_snapshot;
	_tmp7_ = gtk_snapshot_to_node (_tmp6_);
	node = _tmp7_;
	_tmp8_ = gtk_widget_get_native (widget);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	native = _tmp9_;
	_tmp11_ = native;
	if (_tmp11_ == NULL) {
		_tmp10_ = TRUE;
	} else {
		GskRenderNode* _tmp12_;
		_tmp12_ = node;
		_tmp10_ = _tmp12_ == NULL;
	}
	if (_tmp10_) {
		result = NULL;
		_g_object_unref0 (native);
		_gsk_render_node_unref0 (node);
		_g_object_unref0 (t_snapshot);
		_g_object_unref0 (widget_paintable);
		return result;
	}
	_tmp13_ = native;
	_tmp14_ = gtk_native_get_renderer (_tmp13_);
	_tmp15_ = node;
	_tmp16_ = gsk_renderer_render_texture (_tmp14_, _tmp15_, NULL);
	result = _tmp16_;
	_g_object_unref0 (native);
	_gsk_render_node_unref0 (node);
	_g_object_unref0 (t_snapshot);
	_g_object_unref0 (widget_paintable);
	return result;
}

static void
tuba_widgets_scale_revealer_on_animation_end (TubaWidgetsScaleRevealer* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tuba_widgets_scale_revealer_get_reveal_child (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		_tmp2_ = tuba_widgets_scale_revealer_get_source_widget (self);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			GtkWidget* _tmp4_;
			GtkWidget* _tmp5_;
			_tmp4_ = tuba_widgets_scale_revealer_get_source_widget (self);
			_tmp5_ = _tmp4_;
			gtk_widget_set_opacity (_tmp5_, 1.0);
		}
		gtk_widget_set_visible ((GtkWidget*) self, FALSE);
	}
	g_signal_emit (self, tuba_widgets_scale_revealer_signals[TUBA_WIDGETS_SCALE_REVEALER_TRANSITION_DONE_SIGNAL], 0);
}

static void
tuba_widgets_scale_revealer_animation_target_cb (TubaWidgetsScaleRevealer* self,
                                                 gdouble value)
{
	g_return_if_fail (self != NULL);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
tuba_widgets_scale_revealer_real_snapshot (GtkWidget* base,
                                           GtkSnapshot* snapshot)
{
	TubaWidgetsScaleRevealer * self;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	gdouble progress = 0.0;
	AdwTimedAnimation* _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble rev_progress = 0.0;
	graphene_rect_t source_bounds = {0};
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	gfloat x_scale = 0.0F;
	gfloat y_scale = 0.0F;
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	graphene_point_t _tmp13_ = {0};
	GtkWidget* _tmp14_;
	GtkWidget* _tmp15_;
	GdkTexture* _tmp16_;
	self = (TubaWidgetsScaleRevealer*) base;
	g_return_if_fail (snapshot != NULL);
	_tmp0_ = adw_bin_get_child ((AdwBin*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = self->priv->_animation;
	_tmp3_ = adw_animation_get_value ((AdwAnimation*) _tmp2_);
	_tmp4_ = _tmp3_;
	progress = _tmp4_;
	if (progress == 1.0) {
		GtkWidget* _tmp5_;
		GtkWidget* _tmp6_;
		_tmp5_ = adw_bin_get_child ((AdwBin*) self);
		_tmp6_ = _tmp5_;
		gtk_widget_snapshot_child ((GtkWidget*) self, _tmp6_, snapshot);
		return;
	}
	rev_progress = fabs (1.0 - progress);
	source_bounds = TUBA_WIDGETS_SCALE_REVEALER_FALLBACK_BOUNDS;
	_tmp7_ = tuba_widgets_scale_revealer_get_source_widget (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		GtkWidget* _tmp9_;
		GtkWidget* _tmp10_;
		graphene_rect_t _tmp11_ = {0};
		gboolean _tmp12_;
		_tmp9_ = tuba_widgets_scale_revealer_get_source_widget (self);
		_tmp10_ = _tmp9_;
		_tmp12_ = gtk_widget_compute_bounds (_tmp10_, (GtkWidget*) self, &_tmp11_);
		source_bounds = _tmp11_;
		if (!_tmp12_) {
			source_bounds = TUBA_WIDGETS_SCALE_REVEALER_FALLBACK_BOUNDS;
		}
	}
	x_scale = graphene_rect_get_width (&source_bounds) / gtk_widget_get_width ((GtkWidget*) self);
	y_scale = graphene_rect_get_height (&source_bounds) / gtk_widget_get_height ((GtkWidget*) self);
	x_scale = 1.0f + ((x_scale - 1.0f) * ((gfloat) rev_progress));
	y_scale = 1.0f + ((y_scale - 1.0f) * ((gfloat) rev_progress));
	x = graphene_rect_get_x (&source_bounds) * ((gfloat) rev_progress);
	y = graphene_rect_get_y (&source_bounds) * ((gfloat) rev_progress);
	memset (&_tmp13_, 0, sizeof (graphene_point_t));
	_tmp13_.x = x;
	_tmp13_.y = y;
	gtk_snapshot_translate (snapshot, &_tmp13_);
	gtk_snapshot_scale (snapshot, x_scale, y_scale);
	_tmp14_ = tuba_widgets_scale_revealer_get_source_widget (self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ == NULL) {
		return;
	}
	_tmp16_ = self->priv->_source_widget_texture;
	if (_tmp16_ == NULL) {
		GtkWidget* _tmp17_;
		GtkWidget* _tmp18_;
		g_warning ("ScaleRevealer.vala:138: The source widget texture is None, using child" \
" snapshot as fallback");
		_tmp17_ = adw_bin_get_child ((AdwBin*) self);
		_tmp18_ = _tmp17_;
		gtk_widget_snapshot_child ((GtkWidget*) self, _tmp18_, snapshot);
	} else {
		if (progress > 0.0) {
			GdkTexture* _tmp19_;
			GtkWidget* _tmp20_;
			GtkWidget* _tmp21_;
			gtk_snapshot_push_cross_fade (snapshot, progress);
			_tmp19_ = self->priv->_source_widget_texture;
			gdk_paintable_snapshot ((GdkPaintable*) _tmp19_, (GdkSnapshot*) snapshot, (gdouble) gtk_widget_get_width ((GtkWidget*) self), (gdouble) gtk_widget_get_height ((GtkWidget*) self));
			gtk_snapshot_pop (snapshot);
			_tmp20_ = adw_bin_get_child ((AdwBin*) self);
			_tmp21_ = _tmp20_;
			gtk_widget_snapshot_child ((GtkWidget*) self, _tmp21_, snapshot);
			gtk_snapshot_pop (snapshot);
		} else {
			if (progress <= 0.0) {
				GdkTexture* _tmp22_;
				_tmp22_ = self->priv->_source_widget_texture;
				gdk_paintable_snapshot ((GdkPaintable*) _tmp22_, (GdkSnapshot*) snapshot, (gdouble) gtk_widget_get_width ((GtkWidget*) self), (gdouble) gtk_widget_get_height ((GtkWidget*) self));
			}
		}
	}
}

TubaWidgetsScaleRevealer*
tuba_widgets_scale_revealer_construct (GType object_type)
{
	TubaWidgetsScaleRevealer * self = NULL;
	self = (TubaWidgetsScaleRevealer*) g_object_new (object_type, NULL);
	return self;
}

TubaWidgetsScaleRevealer*
tuba_widgets_scale_revealer_new (void)
{
	return tuba_widgets_scale_revealer_construct (TUBA_WIDGETS_TYPE_SCALE_REVEALER);
}

AdwTimedAnimation*
tuba_widgets_scale_revealer_get_animation (TubaWidgetsScaleRevealer* self)
{
	AdwTimedAnimation* result;
	AdwTimedAnimation* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_animation;
	result = _tmp0_;
	return result;
}

void
tuba_widgets_scale_revealer_set_animation (TubaWidgetsScaleRevealer* self,
                                           AdwTimedAnimation* value)
{
	AdwTimedAnimation* old_value;
	g_return_if_fail (self != NULL);
	old_value = tuba_widgets_scale_revealer_get_animation (self);
	if (old_value != value) {
		AdwTimedAnimation* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_animation);
		self->priv->_animation = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tuba_widgets_scale_revealer_properties[TUBA_WIDGETS_SCALE_REVEALER_ANIMATION_PROPERTY]);
	}
}

GtkWidget*
tuba_widgets_scale_revealer_get_source_widget (TubaWidgetsScaleRevealer* self)
{
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_widget;
	result = _tmp0_;
	return result;
}

void
tuba_widgets_scale_revealer_set_source_widget (TubaWidgetsScaleRevealer* self,
                                               GtkWidget* value)
{
	GtkWidget* _tmp0_;
	GtkWidget* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_source_widget;
	if (_tmp0_ != NULL) {
		GtkWidget* _tmp1_;
		_tmp1_ = self->priv->_source_widget;
		gtk_widget_set_opacity (_tmp1_, 1.0);
	}
	_tmp2_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_source_widget);
	self->priv->_source_widget = _tmp2_;
	tuba_widgets_scale_revealer_update_source_widget (self);
	g_object_notify_by_pspec ((GObject *) self, tuba_widgets_scale_revealer_properties[TUBA_WIDGETS_SCALE_REVEALER_SOURCE_WIDGET_PROPERTY]);
}

GdkTexture*
tuba_widgets_scale_revealer_get_source_widget_texture (TubaWidgetsScaleRevealer* self)
{
	GdkTexture* result;
	GdkTexture* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_widget_texture;
	result = _tmp0_;
	return result;
}

void
tuba_widgets_scale_revealer_set_source_widget_texture (TubaWidgetsScaleRevealer* self,
                                                       GdkTexture* value)
{
	GdkTexture* old_value;
	g_return_if_fail (self != NULL);
	old_value = tuba_widgets_scale_revealer_get_source_widget_texture (self);
	if (old_value != value) {
		GdkTexture* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_source_widget_texture);
		self->priv->_source_widget_texture = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tuba_widgets_scale_revealer_properties[TUBA_WIDGETS_SCALE_REVEALER_SOURCE_WIDGET_TEXTURE_PROPERTY]);
	}
}

gboolean
tuba_widgets_scale_revealer_get_reveal_child (TubaWidgetsScaleRevealer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_reveal_child;
	return result;
}

void
tuba_widgets_scale_revealer_set_reveal_child (TubaWidgetsScaleRevealer* self,
                                              gboolean value)
{
	AdwTimedAnimation* _tmp0_;
	AdwTimedAnimation* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	AdwTimedAnimation* _tmp6_;
	g_return_if_fail (self != NULL);
	if (self->priv->_reveal_child == value) {
		return;
	}
	_tmp0_ = self->priv->_animation;
	_tmp1_ = self->priv->_animation;
	_tmp2_ = adw_animation_get_value ((AdwAnimation*) _tmp1_);
	_tmp3_ = _tmp2_;
	adw_timed_animation_set_value_from (_tmp0_, _tmp3_);
	if (value) {
		AdwTimedAnimation* _tmp4_;
		_tmp4_ = self->priv->_animation;
		adw_timed_animation_set_value_to (_tmp4_, 1.0);
		gtk_widget_set_visible ((GtkWidget*) self, TRUE);
		tuba_widgets_scale_revealer_update_source_widget (self);
	} else {
		AdwTimedAnimation* _tmp5_;
		_tmp5_ = self->priv->_animation;
		adw_timed_animation_set_value_to (_tmp5_, 0.0);
	}
	self->priv->_reveal_child = value;
	_tmp6_ = self->priv->_animation;
	adw_animation_play ((AdwAnimation*) _tmp6_);
	g_object_notify ((GObject*) self, "reveal-child");
	g_object_notify_by_pspec ((GObject *) self, tuba_widgets_scale_revealer_properties[TUBA_WIDGETS_SCALE_REVEALER_REVEAL_CHILD_PROPERTY]);
}

static void
_tuba_widgets_scale_revealer_animation_target_cb_adw_animation_target_func (gdouble value,
                                                                            gpointer self)
{
	tuba_widgets_scale_revealer_animation_target_cb ((TubaWidgetsScaleRevealer*) self, value);
}

static void
_tuba_widgets_scale_revealer_on_animation_end_adw_animation_done (AdwAnimation* _sender,
                                                                  gpointer self)
{
	tuba_widgets_scale_revealer_on_animation_end ((TubaWidgetsScaleRevealer*) self);
}

static GObject *
tuba_widgets_scale_revealer_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TubaWidgetsScaleRevealer * self;
	AdwCallbackAnimationTarget* target = NULL;
	AdwCallbackAnimationTarget* _tmp0_;
	AdwCallbackAnimationTarget* _tmp1_;
	AdwAnimationTarget* _tmp2_;
	AdwTimedAnimation* _tmp3_ = NULL;
	AdwTimedAnimation* _tmp4_;
	AdwTimedAnimation* _tmp5_;
	parent_class = G_OBJECT_CLASS (tuba_widgets_scale_revealer_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_WIDGETS_TYPE_SCALE_REVEALER, TubaWidgetsScaleRevealer);
	_tmp0_ = (AdwCallbackAnimationTarget*) adw_callback_animation_target_new (_tuba_widgets_scale_revealer_animation_target_cb_adw_animation_target_func, g_object_ref (self), g_object_unref);
	target = _tmp0_;
	_tmp1_ = target;
	_tmp2_ = _g_object_ref0 ((AdwAnimationTarget*) _tmp1_);
	_tmp3_ = (AdwTimedAnimation*) adw_timed_animation_new ((GtkWidget*) self, 0.0, 1.0, TUBA_WIDGETS_SCALE_REVEALER_ANIMATION_DURATION, _tmp2_);
	adw_timed_animation_set_easing (_tmp3_, ADW_EASE_OUT_QUART);
	_tmp4_ = _tmp3_;
	tuba_widgets_scale_revealer_set_animation (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = self->priv->_animation;
	g_signal_connect_object ((AdwAnimation*) _tmp5_, "done", (GCallback) _tuba_widgets_scale_revealer_on_animation_end_adw_animation_done, self, 0);
	gtk_widget_set_visible ((GtkWidget*) self, FALSE);
	_g_object_unref0 (target);
	return obj;
}

static void
tuba_widgets_scale_revealer_class_init (TubaWidgetsScaleRevealerClass * klass,
                                        gpointer klass_data)
{
	tuba_widgets_scale_revealer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TubaWidgetsScaleRevealer_private_offset);
	((GtkWidgetClass *) klass)->snapshot = (void (*) (GtkWidget*, GtkSnapshot*)) tuba_widgets_scale_revealer_real_snapshot;
	G_OBJECT_CLASS (klass)->get_property = _vala_tuba_widgets_scale_revealer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tuba_widgets_scale_revealer_set_property;
	G_OBJECT_CLASS (klass)->constructor = tuba_widgets_scale_revealer_constructor;
	G_OBJECT_CLASS (klass)->finalize = tuba_widgets_scale_revealer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_SCALE_REVEALER_ANIMATION_PROPERTY, tuba_widgets_scale_revealer_properties[TUBA_WIDGETS_SCALE_REVEALER_ANIMATION_PROPERTY] = g_param_spec_object ("animation", "animation", "animation", adw_timed_animation_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_SCALE_REVEALER_SOURCE_WIDGET_PROPERTY, tuba_widgets_scale_revealer_properties[TUBA_WIDGETS_SCALE_REVEALER_SOURCE_WIDGET_PROPERTY] = g_param_spec_object ("source-widget", "source-widget", "source-widget", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_SCALE_REVEALER_SOURCE_WIDGET_TEXTURE_PROPERTY, tuba_widgets_scale_revealer_properties[TUBA_WIDGETS_SCALE_REVEALER_SOURCE_WIDGET_TEXTURE_PROPERTY] = g_param_spec_object ("source-widget-texture", "source-widget-texture", "source-widget-texture", gdk_texture_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_SCALE_REVEALER_REVEAL_CHILD_PROPERTY, tuba_widgets_scale_revealer_properties[TUBA_WIDGETS_SCALE_REVEALER_REVEAL_CHILD_PROPERTY] = g_param_spec_boolean ("reveal-child", "reveal-child", "reveal-child", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	tuba_widgets_scale_revealer_signals[TUBA_WIDGETS_SCALE_REVEALER_TRANSITION_DONE_SIGNAL] = g_signal_new ("transition-done", TUBA_WIDGETS_TYPE_SCALE_REVEALER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
tuba_widgets_scale_revealer_instance_init (TubaWidgetsScaleRevealer * self,
                                           gpointer klass)
{
	self->priv = tuba_widgets_scale_revealer_get_instance_private (self);
	self->priv->_source_widget = NULL;
	self->priv->_reveal_child = FALSE;
}

static void
tuba_widgets_scale_revealer_finalize (GObject * obj)
{
	TubaWidgetsScaleRevealer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_WIDGETS_TYPE_SCALE_REVEALER, TubaWidgetsScaleRevealer);
	_g_object_unref0 (self->priv->_animation);
	_g_object_unref0 (self->priv->_source_widget);
	_g_object_unref0 (self->priv->_source_widget_texture);
	G_OBJECT_CLASS (tuba_widgets_scale_revealer_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
tuba_widgets_scale_revealer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TubaWidgetsScaleRevealerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tuba_widgets_scale_revealer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TubaWidgetsScaleRevealer), 0, (GInstanceInitFunc) tuba_widgets_scale_revealer_instance_init, NULL };
	GType tuba_widgets_scale_revealer_type_id;
	tuba_widgets_scale_revealer_type_id = g_type_register_static (adw_bin_get_type (), "TubaWidgetsScaleRevealer", &g_define_type_info, 0);
	TubaWidgetsScaleRevealer_private_offset = g_type_add_instance_private (tuba_widgets_scale_revealer_type_id, sizeof (TubaWidgetsScaleRevealerPrivate));
	return tuba_widgets_scale_revealer_type_id;
}

GType
tuba_widgets_scale_revealer_get_type (void)
{
	static gsize tuba_widgets_scale_revealer_type_id__once = 0;
	if (g_once_init_enter (&tuba_widgets_scale_revealer_type_id__once)) {
		GType tuba_widgets_scale_revealer_type_id;
		tuba_widgets_scale_revealer_type_id = tuba_widgets_scale_revealer_get_type_once ();
		g_once_init_leave (&tuba_widgets_scale_revealer_type_id__once, tuba_widgets_scale_revealer_type_id);
	}
	return tuba_widgets_scale_revealer_type_id__once;
}

static void
_vala_tuba_widgets_scale_revealer_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	TubaWidgetsScaleRevealer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_WIDGETS_TYPE_SCALE_REVEALER, TubaWidgetsScaleRevealer);
	switch (property_id) {
		case TUBA_WIDGETS_SCALE_REVEALER_ANIMATION_PROPERTY:
		g_value_set_object (value, tuba_widgets_scale_revealer_get_animation (self));
		break;
		case TUBA_WIDGETS_SCALE_REVEALER_SOURCE_WIDGET_PROPERTY:
		g_value_set_object (value, tuba_widgets_scale_revealer_get_source_widget (self));
		break;
		case TUBA_WIDGETS_SCALE_REVEALER_SOURCE_WIDGET_TEXTURE_PROPERTY:
		g_value_set_object (value, tuba_widgets_scale_revealer_get_source_widget_texture (self));
		break;
		case TUBA_WIDGETS_SCALE_REVEALER_REVEAL_CHILD_PROPERTY:
		g_value_set_boolean (value, tuba_widgets_scale_revealer_get_reveal_child (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tuba_widgets_scale_revealer_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	TubaWidgetsScaleRevealer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_WIDGETS_TYPE_SCALE_REVEALER, TubaWidgetsScaleRevealer);
	switch (property_id) {
		case TUBA_WIDGETS_SCALE_REVEALER_ANIMATION_PROPERTY:
		tuba_widgets_scale_revealer_set_animation (self, g_value_get_object (value));
		break;
		case TUBA_WIDGETS_SCALE_REVEALER_SOURCE_WIDGET_PROPERTY:
		tuba_widgets_scale_revealer_set_source_widget (self, g_value_get_object (value));
		break;
		case TUBA_WIDGETS_SCALE_REVEALER_SOURCE_WIDGET_TEXTURE_PROPERTY:
		tuba_widgets_scale_revealer_set_source_widget_texture (self, g_value_get_object (value));
		break;
		case TUBA_WIDGETS_SCALE_REVEALER_REVEAL_CHILD_PROPERTY:
		tuba_widgets_scale_revealer_set_reveal_child (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

