/* Units.c generated by valac 0.56.17, the Vala compiler
 * generated from Units.vala, do not modify */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <math.h>
#include <float.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TUBA_TYPE_UNITS (tuba_units_get_type ())
#define TUBA_UNITS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_UNITS, TubaUnits))
#define TUBA_UNITS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_UNITS, TubaUnitsClass))
#define TUBA_IS_UNITS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_UNITS))
#define TUBA_IS_UNITS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_UNITS))
#define TUBA_UNITS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_UNITS, TubaUnitsClass))

typedef struct _TubaUnits TubaUnits;
typedef struct _TubaUnitsClass TubaUnitsClass;
typedef struct _TubaUnitsPrivate TubaUnitsPrivate;
typedef enum  {
	TUBA_UNITS_SHORT_UNIT_TYPE_NONE,
	TUBA_UNITS_SHORT_UNIT_TYPE_THOUSAND,
	TUBA_UNITS_SHORT_UNIT_TYPE_MILLION,
	TUBA_UNITS_SHORT_UNIT_TYPE_BILLION
} TubaUnitsShortUnitType;

#define TUBA_UNITS_TYPE_SHORT_UNIT_TYPE (tuba_units_short_unit_type_get_type ())

#define TUBA_UNITS_TYPE_SHORT_UNIT (tuba_units_short_unit_get_type ())
typedef struct _TubaUnitsShortUnit TubaUnitsShortUnit;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TubaParamSpecUnits TubaParamSpecUnits;

struct _TubaUnits {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TubaUnitsPrivate * priv;
};

struct _TubaUnitsClass {
	GTypeClass parent_class;
	void (*finalize) (TubaUnits *self);
};

struct _TubaUnitsShortUnit {
	gint64 top;
	TubaUnitsShortUnitType symbol;
};

struct _TubaParamSpecUnits {
	GParamSpec parent_instance;
};

static gpointer tuba_units_parent_class = NULL;

VALA_EXTERN gpointer tuba_units_ref (gpointer instance);
VALA_EXTERN void tuba_units_unref (gpointer instance);
VALA_EXTERN GParamSpec* tuba_param_spec_units (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void tuba_value_set_units (GValue* value,
                           gpointer v_object);
VALA_EXTERN void tuba_value_take_units (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer tuba_value_get_units (const GValue* value);
VALA_EXTERN GType tuba_units_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaUnits, tuba_units_unref)
VALA_EXTERN GType tuba_units_short_unit_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* tuba_units_short_unit_type_to_string (TubaUnitsShortUnitType self);
VALA_EXTERN GType tuba_units_short_unit_get_type (void) G_GNUC_CONST ;
VALA_EXTERN TubaUnitsShortUnit* tuba_units_short_unit_dup (const TubaUnitsShortUnit* self);
VALA_EXTERN void tuba_units_short_unit_free (TubaUnitsShortUnit* self);
VALA_EXTERN gchar* tuba_units_shorten (gint64 unit);
VALA_EXTERN TubaUnits* tuba_units_new (void);
VALA_EXTERN TubaUnits* tuba_units_construct (GType object_type);
static void tuba_units_finalize (TubaUnits * obj);
static GType tuba_units_get_type_once (void);

const TubaUnitsShortUnit TUBA_UNITS_SHORT_UNITS[4] = {{(gint64) 1000, TUBA_UNITS_SHORT_UNIT_TYPE_NONE}, {(gint64) 1000000, TUBA_UNITS_SHORT_UNIT_TYPE_THOUSAND}, {(gint64) 1000000000, TUBA_UNITS_SHORT_UNIT_TYPE_MILLION}, {1000000000000LL, TUBA_UNITS_SHORT_UNIT_TYPE_BILLION}};

gchar*
tuba_units_short_unit_type_to_string (TubaUnitsShortUnitType self)
{
	gchar* result;
	switch (self) {
		case TUBA_UNITS_SHORT_UNIT_TYPE_THOUSAND:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("k"));
			result = _tmp0_;
			return result;
		}
		case TUBA_UNITS_SHORT_UNIT_TYPE_MILLION:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("M"));
			result = _tmp1_;
			return result;
		}
		case TUBA_UNITS_SHORT_UNIT_TYPE_BILLION:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("G"));
			result = _tmp2_;
			return result;
		}
		default:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("");
			result = _tmp3_;
			return result;
		}
	}
}

 G_GNUC_NO_INLINE static GType
tuba_units_short_unit_type_get_type_once (void)
{
	static const GEnumValue values[] = {{TUBA_UNITS_SHORT_UNIT_TYPE_NONE, "TUBA_UNITS_SHORT_UNIT_TYPE_NONE", "none"}, {TUBA_UNITS_SHORT_UNIT_TYPE_THOUSAND, "TUBA_UNITS_SHORT_UNIT_TYPE_THOUSAND", "thousand"}, {TUBA_UNITS_SHORT_UNIT_TYPE_MILLION, "TUBA_UNITS_SHORT_UNIT_TYPE_MILLION", "million"}, {TUBA_UNITS_SHORT_UNIT_TYPE_BILLION, "TUBA_UNITS_SHORT_UNIT_TYPE_BILLION", "billion"}, {0, NULL, NULL}};
	GType tuba_units_short_unit_type_type_id;
	tuba_units_short_unit_type_type_id = g_enum_register_static ("TubaUnitsShortUnitType", values);
	return tuba_units_short_unit_type_type_id;
}

GType
tuba_units_short_unit_type_get_type (void)
{
	static gsize tuba_units_short_unit_type_type_id__once = 0;
	if (g_once_init_enter (&tuba_units_short_unit_type_type_id__once)) {
		GType tuba_units_short_unit_type_type_id;
		tuba_units_short_unit_type_type_id = tuba_units_short_unit_type_get_type_once ();
		g_once_init_leave (&tuba_units_short_unit_type_type_id__once, tuba_units_short_unit_type_type_id);
	}
	return tuba_units_short_unit_type_type_id__once;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gchar*
tuba_units_shorten (gint64 unit)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean is_negative = FALSE;
	gchar* _tmp30_;
	gchar* result;
	if (unit == ((gint64) 0)) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (unit < ((gint64) 0)) {
			_tmp2_ = unit > ((gint64) -1000);
		} else {
			_tmp2_ = FALSE;
		}
		_tmp1_ = _tmp2_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		if (unit > ((gint64) 0)) {
			_tmp3_ = unit < ((gint64) 1000);
		} else {
			_tmp3_ = FALSE;
		}
		_tmp0_ = _tmp3_;
	}
	if (_tmp0_) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, unit);
		result = _tmp4_;
		return result;
	}
	is_negative = unit < ((gint64) 0);
	if (is_negative) {
		unit = unit * -1;
	}
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				TubaUnitsShortUnit short_unit = {0};
				TubaUnitsShortUnit _tmp7_;
				TubaUnitsShortUnit _tmp8_;
				gchar* shortened_unit = NULL;
				TubaUnitsShortUnit _tmp9_;
				gchar* _tmp10_;
				gboolean _tmp11_ = FALSE;
				const gchar* _tmp12_;
				const gchar* _tmp21_ = NULL;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				TubaUnitsShortUnit _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				if (!(i < G_N_ELEMENTS (TUBA_UNITS_SHORT_UNITS))) {
					break;
				}
				_tmp7_ = TUBA_UNITS_SHORT_UNITS[i];
				short_unit = _tmp7_;
				_tmp8_ = short_unit;
				if (unit >= _tmp8_.top) {
					continue;
				}
				_tmp9_ = TUBA_UNITS_SHORT_UNITS[i - 1];
				_tmp10_ = g_strdup_printf ("%.1f", trunc ((((gdouble) unit) / _tmp9_.top) * 10.0) / 10.0);
				shortened_unit = _tmp10_;
				_tmp12_ = shortened_unit;
				if (g_str_has_suffix (_tmp12_, "0")) {
					_tmp11_ = TRUE;
				} else {
					const gchar* _tmp13_;
					gint _tmp14_;
					gint _tmp15_;
					_tmp13_ = shortened_unit;
					_tmp14_ = strlen (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp11_ = _tmp15_ > 3;
				}
				if (_tmp11_) {
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
					gchar* _tmp20_;
					_tmp16_ = shortened_unit;
					_tmp17_ = shortened_unit;
					_tmp18_ = strlen (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = string_slice (_tmp16_, (glong) 0, (glong) (_tmp19_ - 2));
					_g_free0 (shortened_unit);
					shortened_unit = _tmp20_;
				}
				if (is_negative) {
					_tmp21_ = "-";
				} else {
					_tmp21_ = "";
				}
				_tmp22_ = string_to_string (_tmp21_);
				_tmp23_ = shortened_unit;
				_tmp24_ = string_to_string (_tmp23_);
				_tmp25_ = short_unit;
				_tmp26_ = tuba_units_short_unit_type_to_string (_tmp25_.symbol);
				_tmp27_ = _tmp26_;
				_tmp28_ = g_strconcat (_tmp22_, _tmp24_, _tmp27_, NULL);
				_tmp29_ = _tmp28_;
				_g_free0 (_tmp27_);
				result = _tmp29_;
				_g_free0 (shortened_unit);
				return result;
			}
		}
	}
	_tmp30_ = g_strdup ("♾️");
	result = _tmp30_;
	return result;
}

TubaUnits*
tuba_units_construct (GType object_type)
{
	TubaUnits* self = NULL;
	self = (TubaUnits*) g_type_create_instance (object_type);
	return self;
}

TubaUnits*
tuba_units_new (void)
{
	return tuba_units_construct (TUBA_TYPE_UNITS);
}

TubaUnitsShortUnit*
tuba_units_short_unit_dup (const TubaUnitsShortUnit* self)
{
	TubaUnitsShortUnit* dup;
	dup = g_new0 (TubaUnitsShortUnit, 1);
	memcpy (dup, self, sizeof (TubaUnitsShortUnit));
	return dup;
}

void
tuba_units_short_unit_free (TubaUnitsShortUnit* self)
{
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
tuba_units_short_unit_get_type_once (void)
{
	GType tuba_units_short_unit_type_id;
	tuba_units_short_unit_type_id = g_boxed_type_register_static ("TubaUnitsShortUnit", (GBoxedCopyFunc) tuba_units_short_unit_dup, (GBoxedFreeFunc) tuba_units_short_unit_free);
	return tuba_units_short_unit_type_id;
}

GType
tuba_units_short_unit_get_type (void)
{
	static gsize tuba_units_short_unit_type_id__once = 0;
	if (g_once_init_enter (&tuba_units_short_unit_type_id__once)) {
		GType tuba_units_short_unit_type_id;
		tuba_units_short_unit_type_id = tuba_units_short_unit_get_type_once ();
		g_once_init_leave (&tuba_units_short_unit_type_id__once, tuba_units_short_unit_type_id);
	}
	return tuba_units_short_unit_type_id__once;
}

static void
tuba_value_units_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
tuba_value_units_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		tuba_units_unref (value->data[0].v_pointer);
	}
}

static void
tuba_value_units_copy_value (const GValue* src_value,
                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tuba_units_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
tuba_value_units_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
tuba_value_units_collect_value (GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TubaUnits * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tuba_units_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
tuba_value_units_lcopy_value (const GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	TubaUnits ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tuba_units_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
tuba_param_spec_units (const gchar* name,
                       const gchar* nick,
                       const gchar* blurb,
                       GType object_type,
                       GParamFlags flags)
{
	TubaParamSpecUnits* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TUBA_TYPE_UNITS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
tuba_value_get_units (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TUBA_TYPE_UNITS), NULL);
	return value->data[0].v_pointer;
}

void
tuba_value_set_units (GValue* value,
                      gpointer v_object)
{
	TubaUnits * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TUBA_TYPE_UNITS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TUBA_TYPE_UNITS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tuba_units_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tuba_units_unref (old);
	}
}

void
tuba_value_take_units (GValue* value,
                       gpointer v_object)
{
	TubaUnits * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TUBA_TYPE_UNITS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TUBA_TYPE_UNITS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tuba_units_unref (old);
	}
}

static void
tuba_units_class_init (TubaUnitsClass * klass,
                       gpointer klass_data)
{
	tuba_units_parent_class = g_type_class_peek_parent (klass);
	((TubaUnitsClass *) klass)->finalize = tuba_units_finalize;
}

static void
tuba_units_instance_init (TubaUnits * self,
                          gpointer klass)
{
	self->ref_count = 1;
}

static void
tuba_units_finalize (TubaUnits * obj)
{
	TubaUnits * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_TYPE_UNITS, TubaUnits);
	g_signal_handlers_destroy (self);
}

 G_GNUC_NO_INLINE static GType
tuba_units_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { tuba_value_units_init, tuba_value_units_free_value, tuba_value_units_copy_value, tuba_value_units_peek_pointer, "p", tuba_value_units_collect_value, "p", tuba_value_units_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TubaUnitsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tuba_units_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TubaUnits), 0, (GInstanceInitFunc) tuba_units_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType tuba_units_type_id;
	tuba_units_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TubaUnits", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return tuba_units_type_id;
}

GType
tuba_units_get_type (void)
{
	static gsize tuba_units_type_id__once = 0;
	if (g_once_init_enter (&tuba_units_type_id__once)) {
		GType tuba_units_type_id;
		tuba_units_type_id = tuba_units_get_type_once ();
		g_once_init_leave (&tuba_units_type_id__once, tuba_units_type_id);
	}
	return tuba_units_type_id__once;
}

gpointer
tuba_units_ref (gpointer instance)
{
	TubaUnits * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
tuba_units_unref (gpointer instance)
{
	TubaUnits * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TUBA_UNITS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

