/* Blurhash.c generated by valac 0.56.17, the Vala compiler
 * generated from Blurhash.vala, do not modify */

/* Blurhash decoding in pure Vala inspired by*/
/* https://github.com/woltapp/blurhash and https://github.com/mad-gooze/fast-blurhash/*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TUBA_TYPE_BLURHASH (tuba_blurhash_get_type ())
#define TUBA_BLURHASH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_BLURHASH, TubaBlurhash))
#define TUBA_BLURHASH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_BLURHASH, TubaBlurhashClass))
#define TUBA_IS_BLURHASH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_BLURHASH))
#define TUBA_IS_BLURHASH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_BLURHASH))
#define TUBA_BLURHASH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_BLURHASH, TubaBlurhashClass))

typedef struct _TubaBlurhash TubaBlurhash;
typedef struct _TubaBlurhashClass TubaBlurhashClass;
typedef struct _TubaBlurhashPrivate TubaBlurhashPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TUBA_BLURHASH_TYPE_AVERAGE_COLOR (tuba_blurhash_average_color_get_type ())
typedef struct _TubaBlurhashAverageColor TubaBlurhashAverageColor;

#define TUBA_BLURHASH_TYPE_COLOR_SRGB (tuba_blurhash_color_srgb_get_type ())
typedef struct _TubaBlurhashColorSRGB TubaBlurhashColorSRGB;

#define TUBA_BLURHASH_TYPE_BASE83 (tuba_blurhash_base83_get_type ())
#define TUBA_BLURHASH_BASE83(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_BLURHASH_TYPE_BASE83, TubaBlurhashBase83))
#define TUBA_BLURHASH_BASE83_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_BLURHASH_TYPE_BASE83, TubaBlurhashBase83Class))
#define TUBA_BLURHASH_IS_BASE83(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_BLURHASH_TYPE_BASE83))
#define TUBA_BLURHASH_IS_BASE83_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_BLURHASH_TYPE_BASE83))
#define TUBA_BLURHASH_BASE83_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_BLURHASH_TYPE_BASE83, TubaBlurhashBase83Class))

typedef struct _TubaBlurhashBase83 TubaBlurhashBase83;
typedef struct _TubaBlurhashBase83Class TubaBlurhashBase83Class;
typedef struct _TubaBlurhashBase83Private TubaBlurhashBase83Private;
typedef struct _TubaBlurhashParamSpecBase83 TubaBlurhashParamSpecBase83;
typedef struct _TubaParamSpecBlurhash TubaParamSpecBlurhash;

struct _TubaBlurhash {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TubaBlurhashPrivate * priv;
};

struct _TubaBlurhashClass {
	GTypeClass parent_class;
	void (*finalize) (TubaBlurhash *self);
};

struct _TubaBlurhashAverageColor {
	gint r;
	gint g;
	gint b;
};

struct _TubaBlurhashColorSRGB {
	gfloat r;
	gfloat g;
	gfloat b;
};

struct _TubaBlurhashBase83 {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TubaBlurhashBase83Private * priv;
};

struct _TubaBlurhashBase83Class {
	GTypeClass parent_class;
	void (*finalize) (TubaBlurhashBase83 *self);
};

struct _TubaBlurhashParamSpecBase83 {
	GParamSpec parent_instance;
};

struct _TubaParamSpecBlurhash {
	GParamSpec parent_instance;
};

static gpointer tuba_blurhash_parent_class = NULL;
static gpointer tuba_blurhash_base83_parent_class = NULL;

VALA_EXTERN gpointer tuba_blurhash_ref (gpointer instance);
VALA_EXTERN void tuba_blurhash_unref (gpointer instance);
VALA_EXTERN GParamSpec* tuba_param_spec_blurhash (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void tuba_value_set_blurhash (GValue* value,
                              gpointer v_object);
VALA_EXTERN void tuba_value_take_blurhash (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer tuba_value_get_blurhash (const GValue* value);
VALA_EXTERN GType tuba_blurhash_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaBlurhash, tuba_blurhash_unref)
static gint tuba_blurhash_decode_partial (const gchar* str,
                                   gint start,
                                   gint end);
VALA_EXTERN gint tuba_blurhash_base83_decode (const gchar* value);
static gint tuba_blurhash_linear_to_srgb (gfloat value);
static gfloat tuba_blurhash_srgb_to_linear (gint value);
static gfloat tuba_blurhash_sign_pow (gfloat value,
                               gfloat exp);
VALA_EXTERN gboolean tuba_blurhash_is_valid_blurhash (const gchar* blurhash,
                                          gint* size_flag,
                                          gint* num_x,
                                          gint* num_y,
                                          gint* size);
static GType tuba_blurhash_average_color_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static TubaBlurhashAverageColor* tuba_blurhash_average_color_dup (const TubaBlurhashAverageColor* self);
static void tuba_blurhash_average_color_free (TubaBlurhashAverageColor* self);
static void tuba_blurhash_get_blurhash_average_color (const gchar* blurhash,
                                               TubaBlurhashAverageColor* result);
static GType tuba_blurhash_color_srgb_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static TubaBlurhashColorSRGB* tuba_blurhash_color_srgb_dup (const TubaBlurhashColorSRGB* self);
static void tuba_blurhash_color_srgb_free (TubaBlurhashColorSRGB* self);
static void tuba_blurhash_decode_ac (gint value,
                              gfloat maximum_value,
                              TubaBlurhashColorSRGB* result);
VALA_EXTERN guint8* tuba_blurhash_decode_to_data (const gchar* blurhash,
                                      gint width,
                                      gint height,
                                      gint punch,
                                      gboolean has_alpha,
                                      gint* result_length1);
VALA_EXTERN GdkPixbuf* tuba_blurhash_blurhash_to_pixbuf (const gchar* blurhash,
                                             gint width,
                                             gint height);
static guint8* _vala_array_dup16 (guint8* self,
                           gssize length);
static void _g_free_gdk_pixbuf_destroy_notify (guint8* pixels,
                                        gpointer self);
VALA_EXTERN TubaBlurhash* tuba_blurhash_new (void);
VALA_EXTERN TubaBlurhash* tuba_blurhash_construct (GType object_type);
VALA_EXTERN gpointer tuba_blurhash_base83_ref (gpointer instance);
VALA_EXTERN void tuba_blurhash_base83_unref (gpointer instance);
VALA_EXTERN GParamSpec* tuba_blurhash_param_spec_base83 (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
VALA_EXTERN void tuba_blurhash_value_set_base83 (GValue* value,
                                     gpointer v_object);
VALA_EXTERN void tuba_blurhash_value_take_base83 (GValue* value,
                                      gpointer v_object);
VALA_EXTERN gpointer tuba_blurhash_value_get_base83 (const GValue* value);
VALA_EXTERN GType tuba_blurhash_base83_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaBlurhashBase83, tuba_blurhash_base83_unref)
VALA_EXTERN TubaBlurhashBase83* tuba_blurhash_base83_new (void);
VALA_EXTERN TubaBlurhashBase83* tuba_blurhash_base83_construct (GType object_type);
static void tuba_blurhash_base83_finalize (TubaBlurhashBase83 * obj);
static GType tuba_blurhash_base83_get_type_once (void);
static void tuba_blurhash_finalize (TubaBlurhash * obj);
static GType tuba_blurhash_get_type_once (void);

static const gchar TUBA_BLURHASH_BASE83_CHARACTERS[83] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '#', '$', '%', '*', '+', ',', '-', '.', ':', ';', '=', '?', '@', '[', ']', '^', '_', '{', '|', '}', '~'};

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gint
tuba_blurhash_decode_partial (const gchar* str,
                              gint start,
                              gint end)
{
	gint str_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	gint result;
	g_return_val_if_fail (str != NULL, 0);
	if (start > end) {
		result = 0;
		return result;
	}
	_tmp0_ = strlen (str);
	_tmp1_ = _tmp0_;
	str_length = _tmp1_;
	if (end >= str_length) {
		end = str_length;
	}
	_tmp2_ = string_slice (str, (glong) start, (glong) end);
	_tmp3_ = _tmp2_;
	_tmp4_ = tuba_blurhash_base83_decode (_tmp3_);
	_g_free0 (_tmp3_);
	result = _tmp4_;
	return result;
}

static gint
tuba_blurhash_linear_to_srgb (gfloat value)
{
	gfloat v = 0.0F;
	gint result;
	v = CLAMP (value, 0.f, 1.f);
	if (((gdouble) v) <= 0.0031308) {
		result = (gint) (((v * 12.92f) * 255) + 0.5);
		return result;
	}
	result = (gint) ((((1.055 * powf (v, 1 / 2.4f)) - 0.055) * 255) + 0.5);
	return result;
}

static gfloat
tuba_blurhash_srgb_to_linear (gint value)
{
	gfloat v = 0.0F;
	gfloat result;
	v = value / 255.f;
	if (((gdouble) v) <= 0.04045) {
		result = v / 12.92f;
		return result;
	}
	result = powf ((v + 0.055f) / 1.055f, 2.4f);
	return result;
}

static gfloat
tuba_blurhash_sign_pow (gfloat value,
                        gfloat exp)
{
	gfloat result;
	result = copysignf (powf (fabsf (value), exp), value);
	return result;
}

gboolean
tuba_blurhash_is_valid_blurhash (const gchar* blurhash,
                                 gint* size_flag,
                                 gint* num_x,
                                 gint* num_y,
                                 gint* size)
{
	gint _vala_size_flag = 0;
	gint _vala_num_x = 0;
	gint _vala_num_y = 0;
	gint _vala_size = 0;
	gint hash_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	gboolean result;
	g_return_val_if_fail (blurhash != NULL, FALSE);
	_vala_size_flag = 0;
	_vala_num_y = 0;
	_vala_num_x = 0;
	_vala_size = 0;
	_tmp0_ = strlen (blurhash);
	_tmp1_ = _tmp0_;
	hash_length = _tmp1_;
	if (hash_length < 6) {
		result = FALSE;
		if (size_flag) {
			*size_flag = _vala_size_flag;
		}
		if (num_x) {
			*num_x = _vala_num_x;
		}
		if (num_y) {
			*num_y = _vala_num_y;
		}
		if (size) {
			*size = _vala_size;
		}
		return result;
	}
	_vala_size_flag = tuba_blurhash_decode_partial (blurhash, 0, 1);
	_vala_num_y = ((gint) floorf ((gfloat) (_vala_size_flag / 9))) + 1;
	_vala_num_x = (_vala_size_flag % 9) + 1;
	_vala_size = _vala_num_x * _vala_num_y;
	if (hash_length != (4 + (2 * _vala_size))) {
		result = FALSE;
		if (size_flag) {
			*size_flag = _vala_size_flag;
		}
		if (num_x) {
			*num_x = _vala_num_x;
		}
		if (num_y) {
			*num_y = _vala_num_y;
		}
		if (size) {
			*size = _vala_size;
		}
		return result;
	}
	result = TRUE;
	if (size_flag) {
		*size_flag = _vala_size_flag;
	}
	if (num_x) {
		*num_x = _vala_num_x;
	}
	if (num_y) {
		*num_y = _vala_num_y;
	}
	if (size) {
		*size = _vala_size;
	}
	return result;
}

static void
tuba_blurhash_get_blurhash_average_color (const gchar* blurhash,
                                          TubaBlurhashAverageColor* result)
{
	gint val = 0;
	TubaBlurhashAverageColor _tmp0_ = {0};
	g_return_if_fail (blurhash != NULL);
	val = tuba_blurhash_decode_partial (blurhash, 2, 6);
	_tmp0_.r = val >> 16;
	_tmp0_.g = (val >> 8) & 255;
	_tmp0_.b = val & 255;
	*result = _tmp0_;
	return;
}

static void
tuba_blurhash_decode_ac (gint value,
                         gfloat maximum_value,
                         TubaBlurhashColorSRGB* result)
{
	gint quant_r = 0;
	gint quant_g = 0;
	gint quant_b = 0;
	TubaBlurhashColorSRGB _tmp0_ = {0};
	quant_r = (gint) floorf ((gfloat) (value / (19 * 19)));
	quant_g = ((gint) floorf ((gfloat) (value / 19))) % 19;
	quant_b = ((gint) value) % 19;
	memset (&_tmp0_, 0, sizeof (TubaBlurhashColorSRGB));
	_tmp0_.r = tuba_blurhash_sign_pow ((((gfloat) quant_r) - 9) / 9, 2.0f) * maximum_value;
	_tmp0_.g = tuba_blurhash_sign_pow ((((gfloat) quant_g) - 9) / 9, 2.0f) * maximum_value;
	_tmp0_.b = tuba_blurhash_sign_pow ((((gfloat) quant_b) - 9) / 9, 2.0f) * maximum_value;
	*result = _tmp0_;
	return;
}

guint8*
tuba_blurhash_decode_to_data (const gchar* blurhash,
                              gint width,
                              gint height,
                              gint punch,
                              gboolean has_alpha,
                              gint* result_length1)
{
	gint _tmp0_ = 0;
	gint bytes_per_row = 0;
	guint8* res = NULL;
	guint8* _tmp1_;
	gint res_length1;
	gint _res_size_;
	gint size_flag = 0;
	gint num_y = 0;
	gint num_x = 0;
	gint size = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_;
	gfloat maximum_value = 0.0F;
	gfloat* colors = NULL;
	gfloat* _tmp8_;
	gint colors_length1;
	gint _colors_size_;
	TubaBlurhashAverageColor average_color = {0};
	TubaBlurhashAverageColor _tmp9_ = {0};
	gfloat* _tmp10_;
	gint _tmp10__length1;
	TubaBlurhashAverageColor _tmp11_;
	gfloat* _tmp12_;
	gint _tmp12__length1;
	TubaBlurhashAverageColor _tmp13_;
	gfloat* _tmp14_;
	gint _tmp14__length1;
	TubaBlurhashAverageColor _tmp15_;
	guint8* _tmp43_;
	gint _tmp43__length1;
	guint8* result;
	g_return_val_if_fail (blurhash != NULL, NULL);
	if (has_alpha) {
		_tmp0_ = 4;
	} else {
		_tmp0_ = 3;
	}
	bytes_per_row = width * _tmp0_;
	_tmp1_ = g_new0 (guint8, bytes_per_row * height);
	res = _tmp1_;
	res_length1 = bytes_per_row * height;
	_res_size_ = res_length1;
	_tmp6_ = tuba_blurhash_is_valid_blurhash (blurhash, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
	size_flag = _tmp2_;
	num_x = _tmp3_;
	num_y = _tmp4_;
	size = _tmp5_;
	if (!_tmp6_) {
		guint8* _tmp7_;
		gint _tmp7__length1;
		_tmp7_ = NULL;
		_tmp7__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp7__length1;
		}
		result = _tmp7_;
		res = (g_free (res), NULL);
		return result;
	}
	if (punch < 1) {
		punch = 1;
	}
	maximum_value = ((gfloat) (tuba_blurhash_decode_partial (blurhash, 1, 2) + 1)) / 166;
	_tmp8_ = g_new0 (gfloat, size * 3);
	colors = _tmp8_;
	colors_length1 = size * 3;
	_colors_size_ = colors_length1;
	tuba_blurhash_get_blurhash_average_color (blurhash, &_tmp9_);
	average_color = _tmp9_;
	_tmp10_ = colors;
	_tmp10__length1 = colors_length1;
	_tmp11_ = average_color;
	_tmp10_[0] = tuba_blurhash_srgb_to_linear (_tmp11_.r);
	_tmp12_ = colors;
	_tmp12__length1 = colors_length1;
	_tmp13_ = average_color;
	_tmp12_[1] = tuba_blurhash_srgb_to_linear (_tmp13_.g);
	_tmp14_ = colors;
	_tmp14__length1 = colors_length1;
	_tmp15_ = average_color;
	_tmp14_[2] = tuba_blurhash_srgb_to_linear (_tmp15_.b);
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				gint value = 0;
				TubaBlurhashColorSRGB color = {0};
				TubaBlurhashColorSRGB _tmp18_ = {0};
				gfloat* _tmp19_;
				gint _tmp19__length1;
				TubaBlurhashColorSRGB _tmp20_;
				gfloat* _tmp21_;
				gint _tmp21__length1;
				TubaBlurhashColorSRGB _tmp22_;
				gfloat* _tmp23_;
				gint _tmp23__length1;
				TubaBlurhashColorSRGB _tmp24_;
				if (!_tmp16_) {
					gint _tmp17_;
					_tmp17_ = i;
					i = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				if (!(i < size)) {
					break;
				}
				value = tuba_blurhash_decode_partial (blurhash, 4 + (i * 2), 6 + (i * 2));
				tuba_blurhash_decode_ac (value, maximum_value, &_tmp18_);
				color = _tmp18_;
				_tmp19_ = colors;
				_tmp19__length1 = colors_length1;
				_tmp20_ = color;
				_tmp19_[i * 3] = _tmp20_.r;
				_tmp21_ = colors;
				_tmp21__length1 = colors_length1;
				_tmp22_ = color;
				_tmp21_[(i * 3) + 1] = _tmp22_.g;
				_tmp23_ = colors;
				_tmp23__length1 = colors_length1;
				_tmp24_ = color;
				_tmp23_[(i * 3) + 2] = _tmp24_.b;
			}
		}
	}
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp25_ = FALSE;
			_tmp25_ = TRUE;
			while (TRUE) {
				gfloat yh = 0.0F;
				if (!_tmp25_) {
					gint _tmp26_;
					_tmp26_ = y;
					y = _tmp26_ + 1;
				}
				_tmp25_ = FALSE;
				if (!(y < height)) {
					break;
				}
				yh = ((gfloat) (G_PI * y)) / height;
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp27_ = FALSE;
						_tmp27_ = TRUE;
						while (TRUE) {
							gfloat r = 0.0F;
							gfloat g = 0.0F;
							gfloat b = 0.0F;
							gfloat xw = 0.0F;
							gint pixel_index = 0;
							guint8* _tmp39_;
							gint _tmp39__length1;
							guint8* _tmp40_;
							gint _tmp40__length1;
							guint8* _tmp41_;
							gint _tmp41__length1;
							if (!_tmp27_) {
								gint _tmp28_;
								_tmp28_ = x;
								x = _tmp28_ + 1;
							}
							_tmp27_ = FALSE;
							if (!(x < width)) {
								break;
							}
							r = (gfloat) 0;
							g = (gfloat) 0;
							b = (gfloat) 0;
							xw = ((gfloat) (G_PI * x)) / width;
							{
								gint j = 0;
								j = 0;
								{
									gboolean _tmp29_ = FALSE;
									_tmp29_ = TRUE;
									while (TRUE) {
										gfloat basis_y = 0.0F;
										if (!_tmp29_) {
											gint _tmp30_;
											_tmp30_ = j;
											j = _tmp30_ + 1;
										}
										_tmp29_ = FALSE;
										if (!(j < num_y)) {
											break;
										}
										basis_y = cosf (yh * j);
										{
											gint i = 0;
											i = 0;
											{
												gboolean _tmp31_ = FALSE;
												_tmp31_ = TRUE;
												while (TRUE) {
													gfloat basis = 0.0F;
													gint color_index = 0;
													gfloat* _tmp33_;
													gint _tmp33__length1;
													gfloat _tmp34_;
													gfloat* _tmp35_;
													gint _tmp35__length1;
													gfloat _tmp36_;
													gfloat* _tmp37_;
													gint _tmp37__length1;
													gfloat _tmp38_;
													if (!_tmp31_) {
														gint _tmp32_;
														_tmp32_ = i;
														i = _tmp32_ + 1;
													}
													_tmp31_ = FALSE;
													if (!(i < num_x)) {
														break;
													}
													basis = cosf (xw * i) * basis_y;
													color_index = (i + (j * num_x)) * 3;
													_tmp33_ = colors;
													_tmp33__length1 = colors_length1;
													_tmp34_ = _tmp33_[color_index];
													r += _tmp34_ * basis;
													_tmp35_ = colors;
													_tmp35__length1 = colors_length1;
													_tmp36_ = _tmp35_[color_index + 1];
													g += _tmp36_ * basis;
													_tmp37_ = colors;
													_tmp37__length1 = colors_length1;
													_tmp38_ = _tmp37_[color_index + 2];
													b += _tmp38_ * basis;
												}
											}
										}
									}
								}
							}
							pixel_index = (4 * x) + (y * bytes_per_row);
							_tmp39_ = res;
							_tmp39__length1 = res_length1;
							_tmp39_[pixel_index] = (guint8) tuba_blurhash_linear_to_srgb (r);
							_tmp40_ = res;
							_tmp40__length1 = res_length1;
							_tmp40_[pixel_index + 1] = (guint8) tuba_blurhash_linear_to_srgb (g);
							_tmp41_ = res;
							_tmp41__length1 = res_length1;
							_tmp41_[pixel_index + 2] = (guint8) tuba_blurhash_linear_to_srgb (b);
							if (has_alpha) {
								guint8* _tmp42_;
								gint _tmp42__length1;
								_tmp42_ = res;
								_tmp42__length1 = res_length1;
								_tmp42_[pixel_index + 3] = (guint8) 255;
							}
						}
					}
				}
			}
		}
	}
	_tmp43_ = res;
	_tmp43__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp43__length1;
	}
	result = _tmp43_;
	colors = (g_free (colors), NULL);
	return result;
}

static guint8*
_vala_array_dup16 (guint8* self,
                   gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static void
_g_free_gdk_pixbuf_destroy_notify (guint8* pixels,
                                   gpointer self)
{
	g_free (pixels);
}

GdkPixbuf*
tuba_blurhash_blurhash_to_pixbuf (const gchar* blurhash,
                                  gint width,
                                  gint height)
{
	guint8* data = NULL;
	gint _tmp0_ = 0;
	guint8* _tmp1_;
	gint data_length1;
	gint _data_size_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* result;
	g_return_val_if_fail (blurhash != NULL, NULL);
	_tmp1_ = tuba_blurhash_decode_to_data (blurhash, width, height, 1, TRUE, &_tmp0_);
	data = _tmp1_;
	data_length1 = _tmp0_;
	_data_size_ = data_length1;
	_tmp2_ = data;
	_tmp2__length1 = data_length1;
	if (_tmp2_ == NULL) {
		result = NULL;
		data = (g_free (data), NULL);
		return result;
	}
	_tmp3_ = data;
	_tmp3__length1 = data_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup16 (_tmp3_, _tmp3__length1) : _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	_tmp5_ = gdk_pixbuf_new_from_data (_tmp4_, GDK_COLORSPACE_RGB, TRUE, 8, width, height, 4 * height, _g_free_gdk_pixbuf_destroy_notify, NULL);
	result = _tmp5_;
	data = (g_free (data), NULL);
	return result;
}

TubaBlurhash*
tuba_blurhash_construct (GType object_type)
{
	TubaBlurhash* self = NULL;
	self = (TubaBlurhash*) g_type_create_instance (object_type);
	return self;
}

TubaBlurhash*
tuba_blurhash_new (void)
{
	return tuba_blurhash_construct (TUBA_TYPE_BLURHASH);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

gint
tuba_blurhash_base83_decode (const gchar* value)
{
	gint res = 0;
	gint result;
	g_return_val_if_fail (value != NULL, 0);
	res = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				gchar character = '\0';
				gint index = 0;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = strlen (value);
				_tmp3_ = _tmp2_;
				if (!(i < _tmp3_)) {
					break;
				}
				character = string_get (value, (glong) i);
				index = -1;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gchar _tmp6_;
							if (!_tmp4_) {
								gint _tmp5_;
								_tmp5_ = j;
								j = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							if (!(j < 83)) {
								break;
							}
							_tmp6_ = TUBA_BLURHASH_BASE83_CHARACTERS[j];
							if (_tmp6_ == character) {
								index = j;
								break;
							}
						}
					}
				}
				if (index == -1) {
					result = 0;
					return result;
				}
				res = (res * 83) + index;
			}
		}
	}
	result = res;
	return result;
}

TubaBlurhashBase83*
tuba_blurhash_base83_construct (GType object_type)
{
	TubaBlurhashBase83* self = NULL;
	self = (TubaBlurhashBase83*) g_type_create_instance (object_type);
	return self;
}

TubaBlurhashBase83*
tuba_blurhash_base83_new (void)
{
	return tuba_blurhash_base83_construct (TUBA_BLURHASH_TYPE_BASE83);
}

static void
tuba_blurhash_value_base83_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
tuba_blurhash_value_base83_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		tuba_blurhash_base83_unref (value->data[0].v_pointer);
	}
}

static void
tuba_blurhash_value_base83_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tuba_blurhash_base83_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
tuba_blurhash_value_base83_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
tuba_blurhash_value_base83_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TubaBlurhashBase83 * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tuba_blurhash_base83_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
tuba_blurhash_value_base83_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	TubaBlurhashBase83 ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tuba_blurhash_base83_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
tuba_blurhash_param_spec_base83 (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	TubaBlurhashParamSpecBase83* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TUBA_BLURHASH_TYPE_BASE83), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
tuba_blurhash_value_get_base83 (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TUBA_BLURHASH_TYPE_BASE83), NULL);
	return value->data[0].v_pointer;
}

void
tuba_blurhash_value_set_base83 (GValue* value,
                                gpointer v_object)
{
	TubaBlurhashBase83 * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TUBA_BLURHASH_TYPE_BASE83));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TUBA_BLURHASH_TYPE_BASE83));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tuba_blurhash_base83_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tuba_blurhash_base83_unref (old);
	}
}

void
tuba_blurhash_value_take_base83 (GValue* value,
                                 gpointer v_object)
{
	TubaBlurhashBase83 * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TUBA_BLURHASH_TYPE_BASE83));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TUBA_BLURHASH_TYPE_BASE83));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tuba_blurhash_base83_unref (old);
	}
}

static void
tuba_blurhash_base83_class_init (TubaBlurhashBase83Class * klass,
                                 gpointer klass_data)
{
	tuba_blurhash_base83_parent_class = g_type_class_peek_parent (klass);
	((TubaBlurhashBase83Class *) klass)->finalize = tuba_blurhash_base83_finalize;
}

static void
tuba_blurhash_base83_instance_init (TubaBlurhashBase83 * self,
                                    gpointer klass)
{
	self->ref_count = 1;
}

static void
tuba_blurhash_base83_finalize (TubaBlurhashBase83 * obj)
{
	TubaBlurhashBase83 * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_BLURHASH_TYPE_BASE83, TubaBlurhashBase83);
	g_signal_handlers_destroy (self);
}

 G_GNUC_NO_INLINE static GType
tuba_blurhash_base83_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { tuba_blurhash_value_base83_init, tuba_blurhash_value_base83_free_value, tuba_blurhash_value_base83_copy_value, tuba_blurhash_value_base83_peek_pointer, "p", tuba_blurhash_value_base83_collect_value, "p", tuba_blurhash_value_base83_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TubaBlurhashBase83Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tuba_blurhash_base83_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TubaBlurhashBase83), 0, (GInstanceInitFunc) tuba_blurhash_base83_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType tuba_blurhash_base83_type_id;
	tuba_blurhash_base83_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TubaBlurhashBase83", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return tuba_blurhash_base83_type_id;
}

GType
tuba_blurhash_base83_get_type (void)
{
	static gsize tuba_blurhash_base83_type_id__once = 0;
	if (g_once_init_enter (&tuba_blurhash_base83_type_id__once)) {
		GType tuba_blurhash_base83_type_id;
		tuba_blurhash_base83_type_id = tuba_blurhash_base83_get_type_once ();
		g_once_init_leave (&tuba_blurhash_base83_type_id__once, tuba_blurhash_base83_type_id);
	}
	return tuba_blurhash_base83_type_id__once;
}

gpointer
tuba_blurhash_base83_ref (gpointer instance)
{
	TubaBlurhashBase83 * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
tuba_blurhash_base83_unref (gpointer instance)
{
	TubaBlurhashBase83 * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TUBA_BLURHASH_BASE83_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static TubaBlurhashAverageColor*
tuba_blurhash_average_color_dup (const TubaBlurhashAverageColor* self)
{
	TubaBlurhashAverageColor* dup;
	dup = g_new0 (TubaBlurhashAverageColor, 1);
	memcpy (dup, self, sizeof (TubaBlurhashAverageColor));
	return dup;
}

static void
tuba_blurhash_average_color_free (TubaBlurhashAverageColor* self)
{
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
tuba_blurhash_average_color_get_type_once (void)
{
	GType tuba_blurhash_average_color_type_id;
	tuba_blurhash_average_color_type_id = g_boxed_type_register_static ("TubaBlurhashAverageColor", (GBoxedCopyFunc) tuba_blurhash_average_color_dup, (GBoxedFreeFunc) tuba_blurhash_average_color_free);
	return tuba_blurhash_average_color_type_id;
}

static GType
tuba_blurhash_average_color_get_type (void)
{
	static gsize tuba_blurhash_average_color_type_id__once = 0;
	if (g_once_init_enter (&tuba_blurhash_average_color_type_id__once)) {
		GType tuba_blurhash_average_color_type_id;
		tuba_blurhash_average_color_type_id = tuba_blurhash_average_color_get_type_once ();
		g_once_init_leave (&tuba_blurhash_average_color_type_id__once, tuba_blurhash_average_color_type_id);
	}
	return tuba_blurhash_average_color_type_id__once;
}

static TubaBlurhashColorSRGB*
tuba_blurhash_color_srgb_dup (const TubaBlurhashColorSRGB* self)
{
	TubaBlurhashColorSRGB* dup;
	dup = g_new0 (TubaBlurhashColorSRGB, 1);
	memcpy (dup, self, sizeof (TubaBlurhashColorSRGB));
	return dup;
}

static void
tuba_blurhash_color_srgb_free (TubaBlurhashColorSRGB* self)
{
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
tuba_blurhash_color_srgb_get_type_once (void)
{
	GType tuba_blurhash_color_srgb_type_id;
	tuba_blurhash_color_srgb_type_id = g_boxed_type_register_static ("TubaBlurhashColorSRGB", (GBoxedCopyFunc) tuba_blurhash_color_srgb_dup, (GBoxedFreeFunc) tuba_blurhash_color_srgb_free);
	return tuba_blurhash_color_srgb_type_id;
}

static GType
tuba_blurhash_color_srgb_get_type (void)
{
	static gsize tuba_blurhash_color_srgb_type_id__once = 0;
	if (g_once_init_enter (&tuba_blurhash_color_srgb_type_id__once)) {
		GType tuba_blurhash_color_srgb_type_id;
		tuba_blurhash_color_srgb_type_id = tuba_blurhash_color_srgb_get_type_once ();
		g_once_init_leave (&tuba_blurhash_color_srgb_type_id__once, tuba_blurhash_color_srgb_type_id);
	}
	return tuba_blurhash_color_srgb_type_id__once;
}

static void
tuba_value_blurhash_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
tuba_value_blurhash_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		tuba_blurhash_unref (value->data[0].v_pointer);
	}
}

static void
tuba_value_blurhash_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tuba_blurhash_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
tuba_value_blurhash_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
tuba_value_blurhash_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TubaBlurhash * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tuba_blurhash_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
tuba_value_blurhash_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	TubaBlurhash ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tuba_blurhash_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
tuba_param_spec_blurhash (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	TubaParamSpecBlurhash* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TUBA_TYPE_BLURHASH), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
tuba_value_get_blurhash (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TUBA_TYPE_BLURHASH), NULL);
	return value->data[0].v_pointer;
}

void
tuba_value_set_blurhash (GValue* value,
                         gpointer v_object)
{
	TubaBlurhash * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TUBA_TYPE_BLURHASH));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TUBA_TYPE_BLURHASH));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tuba_blurhash_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tuba_blurhash_unref (old);
	}
}

void
tuba_value_take_blurhash (GValue* value,
                          gpointer v_object)
{
	TubaBlurhash * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TUBA_TYPE_BLURHASH));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TUBA_TYPE_BLURHASH));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tuba_blurhash_unref (old);
	}
}

static void
tuba_blurhash_class_init (TubaBlurhashClass * klass,
                          gpointer klass_data)
{
	tuba_blurhash_parent_class = g_type_class_peek_parent (klass);
	((TubaBlurhashClass *) klass)->finalize = tuba_blurhash_finalize;
}

static void
tuba_blurhash_instance_init (TubaBlurhash * self,
                             gpointer klass)
{
	self->ref_count = 1;
}

static void
tuba_blurhash_finalize (TubaBlurhash * obj)
{
	TubaBlurhash * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_TYPE_BLURHASH, TubaBlurhash);
	g_signal_handlers_destroy (self);
}

 G_GNUC_NO_INLINE static GType
tuba_blurhash_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { tuba_value_blurhash_init, tuba_value_blurhash_free_value, tuba_value_blurhash_copy_value, tuba_value_blurhash_peek_pointer, "p", tuba_value_blurhash_collect_value, "p", tuba_value_blurhash_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TubaBlurhashClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tuba_blurhash_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TubaBlurhash), 0, (GInstanceInitFunc) tuba_blurhash_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType tuba_blurhash_type_id;
	tuba_blurhash_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TubaBlurhash", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return tuba_blurhash_type_id;
}

GType
tuba_blurhash_get_type (void)
{
	static gsize tuba_blurhash_type_id__once = 0;
	if (g_once_init_enter (&tuba_blurhash_type_id__once)) {
		GType tuba_blurhash_type_id;
		tuba_blurhash_type_id = tuba_blurhash_get_type_once ();
		g_once_init_leave (&tuba_blurhash_type_id__once, tuba_blurhash_type_id);
	}
	return tuba_blurhash_type_id__once;
}

gpointer
tuba_blurhash_ref (gpointer instance)
{
	TubaBlurhash * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
tuba_blurhash_unref (gpointer instance)
{
	TubaBlurhash * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TUBA_BLURHASH_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

