/* Streams.c generated by valac 0.56.17, the Vala compiler
 * generated from Streams.vala, do not modify */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <json-glib/json-glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TUBA_TYPE_STREAMS (tuba_streams_get_type ())
#define TUBA_STREAMS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_STREAMS, TubaStreams))
#define TUBA_STREAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_STREAMS, TubaStreamsClass))
#define TUBA_IS_STREAMS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_STREAMS))
#define TUBA_IS_STREAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_STREAMS))
#define TUBA_STREAMS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_STREAMS, TubaStreamsClass))

typedef struct _TubaStreams TubaStreams;
typedef struct _TubaStreamsClass TubaStreamsClass;
typedef struct _TubaStreamsPrivate TubaStreamsPrivate;

#define TUBA_STREAMS_TYPE_CONNECTION (tuba_streams_connection_get_type ())
#define TUBA_STREAMS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_STREAMS_TYPE_CONNECTION, TubaStreamsConnection))
#define TUBA_STREAMS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_STREAMS_TYPE_CONNECTION, TubaStreamsConnectionClass))
#define TUBA_STREAMS_IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_STREAMS_TYPE_CONNECTION))
#define TUBA_STREAMS_IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_STREAMS_TYPE_CONNECTION))
#define TUBA_STREAMS_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_STREAMS_TYPE_CONNECTION, TubaStreamsConnectionClass))

typedef struct _TubaStreamsConnection TubaStreamsConnection;
typedef struct _TubaStreamsConnectionClass TubaStreamsConnectionClass;
enum  {
	TUBA_STREAMS_0_PROPERTY,
	TUBA_STREAMS_CONNECTIONS_PROPERTY,
	TUBA_STREAMS_NUM_PROPERTIES
};
static GParamSpec* tuba_streams_properties[TUBA_STREAMS_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define TUBA_TYPE_STREAMABLE (tuba_streamable_get_type ())
#define TUBA_STREAMABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_STREAMABLE, TubaStreamable))
#define TUBA_IS_STREAMABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_STREAMABLE))
#define TUBA_STREAMABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TUBA_TYPE_STREAMABLE, TubaStreamableIface))

typedef struct _TubaStreamable TubaStreamable;
typedef struct _TubaStreamableIface TubaStreamableIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _TubaStreamsConnectionPrivate TubaStreamsConnectionPrivate;
enum  {
	TUBA_STREAMS_CONNECTION_0_PROPERTY,
	TUBA_STREAMS_CONNECTION_URL_PROPERTY,
	TUBA_STREAMS_CONNECTION_NAME_PROPERTY,
	TUBA_STREAMS_CONNECTION_NUM_PROPERTIES
};
static GParamSpec* tuba_streams_connection_properties[TUBA_STREAMS_CONNECTION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define TUBA_TYPE_NETWORK (tuba_network_get_type ())
#define TUBA_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_NETWORK, TubaNetwork))
#define TUBA_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_NETWORK, TubaNetworkClass))
#define TUBA_IS_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_NETWORK))
#define TUBA_IS_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_NETWORK))
#define TUBA_NETWORK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_NETWORK, TubaNetworkClass))

typedef struct _TubaNetwork TubaNetwork;
typedef struct _TubaNetworkClass TubaNetworkClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TUBA_STREAMABLE_TYPE_EVENT (tuba_streamable_event_get_type ())
typedef struct _TubaStreamableEvent TubaStreamableEvent;
typedef struct _Block54Data Block54Data;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))

#define TUBA_TYPE_OOPSIE (tuba_oopsie_get_type ())
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

struct _TubaStreams {
	GObject parent_instance;
	TubaStreamsPrivate * priv;
};

struct _TubaStreamsClass {
	GObjectClass parent_class;
};

struct _TubaStreamsPrivate {
	GHashTable* _connections;
};

struct _TubaStreamableIface {
	GTypeInterface parent_iface;
	gchar* (*get_stream_url) (TubaStreamable* self);
	void (*on_streaming_policy_changed) (TubaStreamable* self);
	const gchar* (*get_t_connection_url) (TubaStreamable* self);
	void (*set_t_connection_url) (TubaStreamable* self, const gchar* value);
	gboolean (*get_subscribed) (TubaStreamable* self);
	void (*set_subscribed) (TubaStreamable* self, gboolean value);
};

struct _TubaStreamsConnection {
	GObject parent_instance;
	TubaStreamsConnectionPrivate * priv;
	GeeArrayList* subscribers;
	SoupWebsocketConnection* socket;
	gboolean closing;
	gint timeout;
};

struct _TubaStreamsConnectionClass {
	GObjectClass parent_class;
	void (*on_message) (TubaStreamsConnection* self, gint i, GBytes* bytes);
};

struct _TubaStreamsConnectionPrivate {
	gchar* _url;
};

struct _TubaStreamableEvent {
	gchar* type;
	JsonNode* payload;
};

struct _Block54Data {
	int _ref_count_;
	TubaStreamsConnection* self;
	TubaStreamableEvent ev;
};

typedef enum  {
	TUBA_OOPSIE_USER,
	TUBA_OOPSIE_PARSING,
	TUBA_OOPSIE_INSTANCE,
	TUBA_OOPSIE_INTERNAL
} TubaOopsie;
#define TUBA_OOPSIE tuba_oopsie_quark ()

static gint TubaStreams_private_offset;
static gpointer tuba_streams_parent_class = NULL;
static gint TubaStreamsConnection_private_offset;
static gpointer tuba_streams_connection_parent_class = NULL;
VALA_EXTERN TubaNetwork* tuba_network;

VALA_EXTERN GType tuba_streams_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaStreams, g_object_unref)
VALA_EXTERN GType tuba_streams_connection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaStreamsConnection, g_object_unref)
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN GType tuba_streamable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaStreamable, g_object_unref)
VALA_EXTERN void tuba_streams_subscribe (TubaStreams* self,
                             const gchar* url,
                             TubaStreamable* s);
VALA_EXTERN GHashTable* tuba_streams_get_connections (TubaStreams* self);
VALA_EXTERN void tuba_streams_connection_add (TubaStreamsConnection* self,
                                  TubaStreamable* s);
VALA_EXTERN TubaStreamsConnection* tuba_streams_connection_new (const gchar* url);
VALA_EXTERN TubaStreamsConnection* tuba_streams_connection_construct (GType object_type,
                                                          const gchar* url);
VALA_EXTERN gboolean tuba_streams_connection_start (TubaStreamsConnection* self);
VALA_EXTERN void tuba_streams_unsubscribe (TubaStreams* self,
                               const gchar* url,
                               TubaStreamable* s);
VALA_EXTERN gboolean tuba_streams_connection_remove (TubaStreamsConnection* self,
                                         TubaStreamable* s);
VALA_EXTERN TubaStreams* tuba_streams_new (void);
VALA_EXTERN TubaStreams* tuba_streams_construct (GType object_type);
VALA_EXTERN void tuba_streams_set_connections (TubaStreams* self,
                                   GHashTable* value);
VALA_EXTERN void tuba_streams_connection_on_message (TubaStreamsConnection* self,
                                         gint i,
                                         GBytes* bytes);
static void tuba_streams_connection_set_url (TubaStreamsConnection* self,
                                      const gchar* value);
VALA_EXTERN gchar* tuba_streams_connection_get_name (TubaStreamsConnection* self);
VALA_EXTERN GType tuba_network_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaNetwork, g_object_unref)
VALA_EXTERN SoupSession* tuba_network_get_session (TubaNetwork* self);
VALA_EXTERN const gchar* tuba_streams_connection_get_url (TubaStreamsConnection* self);
static void __lambda28_ (TubaStreamsConnection* self,
                  GObject* obj,
                  GAsyncResult* res);
static void tuba_streams_connection_on_error (TubaStreamsConnection* self,
                                       GError* e);
static void _tuba_streams_connection_on_error_soup_websocket_connection_error (SoupWebsocketConnection* _sender,
                                                                        GError* _error_,
                                                                        gpointer self);
static void tuba_streams_connection_on_closed (TubaStreamsConnection* self);
static void _tuba_streams_connection_on_closed_soup_websocket_connection_closed (SoupWebsocketConnection* _sender,
                                                                          gpointer self);
static void _tuba_streams_connection_on_message_soup_websocket_connection_message (SoupWebsocketConnection* _sender,
                                                                            gint type,
                                                                            GBytes* message,
                                                                            gpointer self);
static void ___lambda28__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN gchar* tuba_streamable_get_subscriber_name (TubaStreamable* self);
static gboolean _tuba_streams_connection_start_gsource_func (gpointer self);
static void tuba_streams_connection_real_on_message (TubaStreamsConnection* self,
                                              gint i,
                                              GBytes* bytes);
VALA_EXTERN GType tuba_streamable_event_get_type (void) G_GNUC_CONST ;
VALA_EXTERN TubaStreamableEvent* tuba_streamable_event_dup (const TubaStreamableEvent* self);
VALA_EXTERN void tuba_streamable_event_free (TubaStreamableEvent* self);
VALA_EXTERN void tuba_streamable_event_copy (const TubaStreamableEvent* self,
                                 TubaStreamableEvent* dest);
VALA_EXTERN void tuba_streamable_event_destroy (TubaStreamableEvent* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (TubaStreamableEvent, tuba_streamable_event_destroy)
static Block54Data* block54_data_ref (Block54Data* _data54_);
static void block54_data_unref (void * _userdata_);
static void tuba_streams_connection_decode (TubaStreamsConnection* self,
                                     GBytes* bytes,
                                     TubaStreamableEvent* event,
                                     GError** error);
static gboolean ___lambda29_ (Block54Data* _data54_,
                       TubaStreamable* s);
static gboolean ____lambda29__gee_forall_func (gpointer g,
                                        gpointer self);
static void _vala_JsonNode_free (JsonNode* self);
VALA_EXTERN GQuark tuba_oopsie_quark (void);
VALA_EXTERN GType tuba_oopsie_get_type (void) G_GNUC_CONST ;
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static void tuba_streams_connection_finalize (GObject * obj);
static GType tuba_streams_connection_get_type_once (void);
static void _vala_tuba_streams_connection_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_tuba_streams_connection_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void tuba_streams_finalize (GObject * obj);
static GType tuba_streams_get_type_once (void);
static void _vala_tuba_streams_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_tuba_streams_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

static inline gpointer
tuba_streams_get_instance_private (TubaStreams* self)
{
	return G_STRUCT_MEMBER_P (self, TubaStreams_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
tuba_streams_subscribe (TubaStreams* self,
                        const gchar* url,
                        TubaStreamable* s)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	if (url == NULL) {
		return;
	}
	_tmp0_ = self->priv->_connections;
	if (g_hash_table_contains (_tmp0_, url)) {
		GHashTable* _tmp1_;
		gconstpointer _tmp2_;
		_tmp1_ = self->priv->_connections;
		_tmp2_ = g_hash_table_lookup (_tmp1_, url);
		tuba_streams_connection_add ((TubaStreamsConnection*) _tmp2_, s);
	} else {
		TubaStreamsConnection* con = NULL;
		TubaStreamsConnection* _tmp3_;
		GHashTable* _tmp4_;
		gchar* _tmp5_;
		TubaStreamsConnection* _tmp6_;
		TubaStreamsConnection* _tmp7_;
		TubaStreamsConnection* _tmp8_;
		TubaStreamsConnection* _tmp9_;
		_tmp3_ = tuba_streams_connection_new (url);
		con = _tmp3_;
		_tmp4_ = self->priv->_connections;
		_tmp5_ = g_strdup (url);
		_tmp6_ = con;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		g_hash_table_insert (_tmp4_, _tmp5_, _tmp7_);
		_tmp8_ = con;
		tuba_streams_connection_add (_tmp8_, s);
		_tmp9_ = con;
		tuba_streams_connection_start (_tmp9_);
		_g_object_unref0 (con);
	}
}

void
tuba_streams_unsubscribe (TubaStreams* self,
                          const gchar* url,
                          TubaStreamable* s)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	if (url == NULL) {
		return;
	}
	_tmp0_ = self->priv->_connections;
	if (g_hash_table_contains (_tmp0_, url)) {
		gboolean unused = FALSE;
		GHashTable* _tmp1_;
		gconstpointer _tmp2_;
		_tmp1_ = self->priv->_connections;
		_tmp2_ = g_hash_table_lookup (_tmp1_, url);
		unused = tuba_streams_connection_remove ((TubaStreamsConnection*) _tmp2_, s);
		if (unused) {
			GHashTable* _tmp3_;
			_tmp3_ = self->priv->_connections;
			g_hash_table_remove (_tmp3_, url);
		}
	}
}

TubaStreams*
tuba_streams_construct (GType object_type)
{
	TubaStreams * self = NULL;
	self = (TubaStreams*) g_object_new (object_type, NULL);
	return self;
}

TubaStreams*
tuba_streams_new (void)
{
	return tuba_streams_construct (TUBA_TYPE_STREAMS);
}

GHashTable*
tuba_streams_get_connections (TubaStreams* self)
{
	GHashTable* result;
	GHashTable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_connections;
	result = _tmp0_;
	return result;
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

void
tuba_streams_set_connections (TubaStreams* self,
                              GHashTable* value)
{
	GHashTable* old_value;
	g_return_if_fail (self != NULL);
	old_value = tuba_streams_get_connections (self);
	if (old_value != value) {
		GHashTable* _tmp0_;
		_tmp0_ = _g_hash_table_ref0 (value);
		_g_hash_table_unref0 (self->priv->_connections);
		self->priv->_connections = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tuba_streams_properties[TUBA_STREAMS_CONNECTIONS_PROPERTY]);
	}
}

static inline gpointer
tuba_streams_connection_get_instance_private (TubaStreamsConnection* self)
{
	return G_STRUCT_MEMBER_P (self, TubaStreamsConnection_private_offset);
}

TubaStreamsConnection*
tuba_streams_connection_construct (GType object_type,
                                   const gchar* url)
{
	TubaStreamsConnection * self = NULL;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (url != NULL, NULL);
	self = (TubaStreamsConnection*) g_object_new (object_type, NULL);
	_tmp0_ = gee_array_list_new (TUBA_TYPE_STREAMABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->subscribers);
	self->subscribers = _tmp0_;
	tuba_streams_connection_set_url (self, url);
	return self;
}

TubaStreamsConnection*
tuba_streams_connection_new (const gchar* url)
{
	return tuba_streams_connection_construct (TUBA_STREAMS_TYPE_CONNECTION, url);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
_tuba_streams_connection_on_error_soup_websocket_connection_error (SoupWebsocketConnection* _sender,
                                                                   GError* _error_,
                                                                   gpointer self)
{
	tuba_streams_connection_on_error ((TubaStreamsConnection*) self, _error_);
}

static void
_tuba_streams_connection_on_closed_soup_websocket_connection_closed (SoupWebsocketConnection* _sender,
                                                                     gpointer self)
{
	tuba_streams_connection_on_closed ((TubaStreamsConnection*) self);
}

static void
_tuba_streams_connection_on_message_soup_websocket_connection_message (SoupWebsocketConnection* _sender,
                                                                       gint type,
                                                                       GBytes* message,
                                                                       gpointer self)
{
	tuba_streams_connection_on_message ((TubaStreamsConnection*) self, type, message);
}

static void
__lambda28_ (TubaStreamsConnection* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		SoupWebsocketConnection* _tmp0_ = NULL;
		TubaNetwork* _tmp1_;
		SoupSession* _tmp2_;
		SoupSession* _tmp3_;
		SoupWebsocketConnection* _tmp4_;
		SoupWebsocketConnection* _tmp5_;
		SoupWebsocketConnection* _tmp6_;
		SoupWebsocketConnection* _tmp7_;
		SoupWebsocketConnection* _tmp8_;
		SoupWebsocketConnection* _tmp9_;
		_tmp1_ = tuba_network;
		_tmp2_ = tuba_network_get_session (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = soup_session_websocket_connect_finish (_tmp3_, res, &_inner_error0_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->socket);
		self->socket = _tmp5_;
		_tmp6_ = self->socket;
		soup_websocket_connection_set_keepalive_interval (_tmp6_, (guint) 30);
		_tmp7_ = self->socket;
		g_signal_connect_object (_tmp7_, "error", (GCallback) _tuba_streams_connection_on_error_soup_websocket_connection_error, self, 0);
		_tmp8_ = self->socket;
		g_signal_connect_object (_tmp8_, "closed", (GCallback) _tuba_streams_connection_on_closed_soup_websocket_connection_closed, self, 0);
		_tmp9_ = self->socket;
		g_signal_connect_object (_tmp9_, "message", (GCallback) _tuba_streams_connection_on_message_soup_websocket_connection_message, self, 0);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gboolean _tmp15_ = FALSE;
		GError* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		_tmp12_ = string_to_string (_tmp11_);
		_tmp13_ = g_strconcat ("Error opening stream: ", _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		g_warning ("Streams.vala:78: %s", _tmp14_);
		_g_free0 (_tmp14_);
		_tmp16_ = e;
		if (g_error_matches (_tmp16_, g_quark_from_string ("g-tls-error-quark"), 3)) {
			_tmp15_ = TRUE;
		} else {
			GError* _tmp17_;
			_tmp17_ = e;
			_tmp15_ = g_error_matches (_tmp17_, g_quark_from_string ("g-io-error-quark"), 44);
		}
		if (_tmp15_) {
			tuba_streams_connection_on_closed (self);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda28__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda28_ ((TubaStreamsConnection*) self, source_object, res);
	g_object_unref (self);
}

gboolean
tuba_streams_connection_start (TubaStreamsConnection* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	TubaNetwork* _tmp6_;
	SoupSession* _tmp7_;
	SoupSession* _tmp8_;
	const gchar* _tmp9_;
	SoupMessage* _tmp10_;
	SoupMessage* _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tuba_streams_connection_get_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = g_strconcat ("Opening stream: ", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	g_debug ("Streams.vala:68: %s", _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	_tmp6_ = tuba_network;
	_tmp7_ = tuba_network_get_session (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->_url;
	_tmp10_ = soup_message_new ("GET", _tmp9_);
	_tmp11_ = _tmp10_;
	soup_session_websocket_connect_async (_tmp8_, _tmp11_, NULL, NULL, 0, NULL, ___lambda28__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (_tmp11_);
	result = FALSE;
	return result;
}

void
tuba_streams_connection_add (TubaStreamsConnection* self,
                             TubaStreamable* s)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GeeArrayList* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = tuba_streamable_get_subscriber_name (s);
	_tmp1_ = _tmp0_;
	_tmp2_ = tuba_streams_connection_get_name (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	g_info ("Streams.vala:88: %s > %s", _tmp1_, _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
	_tmp5_ = self->subscribers;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, s);
}

gboolean
tuba_streams_connection_remove (TubaStreamsConnection* self,
                                TubaStreamable* s)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (s != NULL, FALSE);
	_tmp0_ = self->subscribers;
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, s)) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GeeArrayList* _tmp6_;
		_tmp1_ = tuba_streamable_get_subscriber_name (s);
		_tmp2_ = _tmp1_;
		_tmp3_ = tuba_streams_connection_get_name (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		g_info ("Streams.vala:94: %s X %s", _tmp2_, _tmp5_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp2_);
		_tmp6_ = self->subscribers;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp6_, s);
	}
	_tmp7_ = self->subscribers;
	_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ <= 0) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		SoupWebsocketConnection* _tmp16_;
		_tmp10_ = tuba_streams_connection_get_name (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		_tmp13_ = string_to_string (_tmp12_);
		_tmp14_ = g_strconcat ("Closing: ", _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		g_debug ("Streams.vala:99: %s", _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp12_);
		self->closing = TRUE;
		_tmp16_ = self->socket;
		if (_tmp16_ != NULL) {
			SoupWebsocketConnection* _tmp17_;
			_tmp17_ = self->socket;
			soup_websocket_connection_close (_tmp17_, (gushort) 0, NULL);
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
tuba_streams_connection_on_error (TubaStreamsConnection* self,
                                  GError* e)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (e != NULL);
	if (self->closing) {
		return;
	}
	_tmp0_ = tuba_streams_connection_get_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = e->message;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = g_strconcat ("Error in ", _tmp3_, ": ", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	g_warning ("Streams.vala:112: %s", _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp2_);
}

static gboolean
_tuba_streams_connection_start_gsource_func (gpointer self)
{
	gboolean result;
	result = tuba_streams_connection_start ((TubaStreamsConnection*) self);
	return result;
}

static void
tuba_streams_connection_on_closed (TubaStreamsConnection* self)
{
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->socket);
	self->socket = NULL;
	if (!self->closing) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp0_ = tuba_streams_connection_get_name (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = g_strdup_printf ("%i", self->timeout);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat ("DISCONNECTED: ", _tmp3_, ". Reconnecting in ", _tmp5_, " seconds.", NULL);
		_tmp7_ = _tmp6_;
		g_warning ("Streams.vala:118: %s", _tmp7_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp2_);
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) self->timeout, _tuba_streams_connection_start_gsource_func, g_object_ref (self), g_object_unref);
		self->timeout = MIN (self->timeout * 2, 6);
	}
	_tmp8_ = tuba_streams_connection_get_name (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp11_ = string_to_string (_tmp10_);
	_tmp12_ = g_strconcat ("Closing stream: ", _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	g_debug ("Streams.vala:122: %s", _tmp13_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp10_);
}

static Block54Data*
block54_data_ref (Block54Data* _data54_)
{
	g_atomic_int_inc (&_data54_->_ref_count_);
	return _data54_;
}

static void
block54_data_unref (void * _userdata_)
{
	Block54Data* _data54_;
	_data54_ = (Block54Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data54_->_ref_count_)) {
		TubaStreamsConnection* self;
		self = _data54_->self;
		tuba_streamable_event_destroy (&_data54_->ev);
		_g_object_unref0 (self);
		g_slice_free (Block54Data, _data54_);
	}
}

static gboolean
___lambda29_ (Block54Data* _data54_,
              TubaStreamable* s)
{
	TubaStreamsConnection* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	TubaStreamableEvent _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	TubaStreamableEvent _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	TubaStreamableEvent _tmp15_;
	gboolean result;
	self = _data54_->self;
	g_return_val_if_fail (s != NULL, FALSE);
	_tmp0_ = tuba_streams_connection_get_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = _data54_->ev;
	_tmp5_ = _tmp4_.type;
	_tmp6_ = string_to_string (_tmp5_);
	_tmp7_ = tuba_streamable_get_subscriber_name (s);
	_tmp8_ = _tmp7_;
	_tmp9_ = string_to_string (_tmp8_);
	_tmp10_ = g_strconcat (_tmp3_, ": ", _tmp6_, " for ", _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	g_debug ("Streams.vala:131: %s", _tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp2_);
	_tmp12_ = _data54_->ev;
	_tmp13_ = _tmp12_.type;
	_tmp14_ = g_strconcat ("stream-event::", _tmp13_, NULL);
	_tmp15_ = _data54_->ev;
	g_signal_emit_by_name (s, _tmp14_, &_tmp15_);
	_g_free0 (_tmp14_);
	result = TRUE;
	_g_object_unref0 (s);
	return result;
}

static gboolean
____lambda29__gee_forall_func (gpointer g,
                               gpointer self)
{
	gboolean result;
	result = ___lambda29_ (self, (TubaStreamable*) g);
	return result;
}

static void
tuba_streams_connection_real_on_message (TubaStreamsConnection* self,
                                         gint i,
                                         GBytes* bytes)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (bytes != NULL);
	{
		Block54Data* _data54_;
		TubaStreamableEvent _tmp0_ = {0};
		GeeArrayList* _tmp1_;
		_data54_ = g_slice_new0 (Block54Data);
		_data54_->_ref_count_ = 1;
		_data54_->self = g_object_ref (self);
		tuba_streams_connection_decode (self, bytes, &_tmp0_, &_inner_error0_);
		tuba_streamable_event_destroy (&_data54_->ev);
		_data54_->ev = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block54_data_unref (_data54_);
			_data54_ = NULL;
			goto __catch0_g_error;
		}
		_tmp1_ = self->subscribers;
		gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp1_, ____lambda29__gee_forall_func, _data54_);
		block54_data_unref (_data54_);
		_data54_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		_tmp4_ = string_to_string (_tmp3_);
		_tmp5_ = g_strconcat ("Failed to handle websocket message. Reason: ", _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		g_warning ("Streams.vala:137: %s", _tmp6_);
		_g_free0 (_tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
tuba_streams_connection_on_message (TubaStreamsConnection* self,
                                    gint i,
                                    GBytes* bytes)
{
	TubaStreamsConnectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = TUBA_STREAMS_CONNECTION_GET_CLASS (self);
	if (_klass_->on_message) {
		_klass_->on_message (self, i, bytes);
	}
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
	return g_boxed_copy (json_node_get_type (), self);
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
	return self ? _vala_JsonNode_copy (self) : NULL;
}

static void
tuba_streams_connection_decode (TubaStreamsConnection* self,
                                GBytes* bytes,
                                TubaStreamableEvent* event,
                                GError** error)
{
	TubaStreamableEvent _vala_event = {0};
	gchar* msg = NULL;
	gsize _tmp0_ = 0;
	guint8* _tmp1_;
	gchar* _tmp2_;
	JsonParser* parser = NULL;
	JsonParser* _tmp3_;
	JsonParser* _tmp4_;
	const gchar* _tmp5_;
	JsonObject* obj = NULL;
	JsonParser* _tmp6_;
	JsonNode* _tmp7_;
	JsonNode* _tmp8_;
	JsonObject* _tmp9_;
	JsonObject* _tmp10_;
	JsonObject* _tmp11_;
	JsonObject* _tmp12_;
	JsonObject* _tmp14_;
	JsonObject* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	JsonObject* _tmp19_;
	JsonNode* _tmp20_;
	JsonNode* _tmp21_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bytes != NULL);
	_tmp1_ = g_bytes_get_data (bytes, &_tmp0_);
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
	msg = _tmp2_;
	_tmp3_ = json_parser_new ();
	parser = _tmp3_;
	_tmp4_ = parser;
	_tmp5_ = msg;
	json_parser_load_from_data (_tmp4_, _tmp5_, (gssize) -1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (parser);
		_g_free0 (msg);
		tuba_streamable_event_destroy (&_vala_event);
		return;
	}
	_tmp6_ = parser;
	_tmp7_ = json_parser_steal_root (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = json_node_get_object (_tmp8_);
	_tmp10_ = _json_object_ref0 (_tmp9_);
	_tmp11_ = _tmp10_;
	__vala_JsonNode_free0 (_tmp8_);
	obj = _tmp11_;
	_tmp12_ = obj;
	if (_tmp12_ == NULL) {
		GError* _tmp13_;
		_tmp13_ = g_error_new_literal (TUBA_OOPSIE, TUBA_OOPSIE_INSTANCE, "Failed to decode message as an Object");
		_inner_error0_ = _tmp13_;
		g_propagate_error (error, _inner_error0_);
		_json_object_unref0 (obj);
		_g_object_unref0 (parser);
		_g_free0 (msg);
		tuba_streamable_event_destroy (&_vala_event);
		return;
	}
	_tmp14_ = obj;
	if (!json_object_has_member (_tmp14_, "event")) {
		GError* _tmp15_;
		_tmp15_ = g_error_new_literal (TUBA_OOPSIE, TUBA_OOPSIE_INSTANCE, "No event specified");
		_inner_error0_ = _tmp15_;
		g_propagate_error (error, _inner_error0_);
		_json_object_unref0 (obj);
		_g_object_unref0 (parser);
		_g_free0 (msg);
		tuba_streamable_event_destroy (&_vala_event);
		return;
	}
	tuba_streamable_event_destroy (&_vala_event);
	memset (&_vala_event, 0, sizeof (TubaStreamableEvent));
	_tmp16_ = obj;
	_tmp17_ = json_object_get_string_member (_tmp16_, "event");
	_tmp18_ = g_strdup (_tmp17_);
	_g_free0 (_vala_event.type);
	_vala_event.type = _tmp18_;
	_tmp19_ = obj;
	_tmp20_ = json_object_get_member (_tmp19_, "payload");
	_tmp21_ = __vala_JsonNode_copy0 (_tmp20_);
	__vala_JsonNode_free0 (_vala_event.payload);
	_vala_event.payload = _tmp21_;
	_json_object_unref0 (obj);
	_g_object_unref0 (parser);
	_g_free0 (msg);
	if (event) {
		*event = _vala_event;
	} else {
		tuba_streamable_event_destroy (&_vala_event);
	}
}

const gchar*
tuba_streams_connection_get_url (TubaStreamsConnection* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_url;
	result = _tmp0_;
	return result;
}

static void
tuba_streams_connection_set_url (TubaStreamsConnection* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = tuba_streams_connection_get_url (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_url);
		self->priv->_url = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tuba_streams_connection_properties[TUBA_STREAMS_CONNECTION_URL_PROPERTY]);
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

gchar*
tuba_streams_connection_get_name (TubaStreamsConnection* self)
{
	gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_url;
	_tmp1_ = self->priv->_url;
	_tmp2_ = string_slice (_tmp0_, (glong) 0, (glong) string_last_index_of (_tmp1_, "&access_token", 0));
	result = _tmp2_;
	return result;
}

static void
tuba_streams_connection_class_init (TubaStreamsConnectionClass * klass,
                                    gpointer klass_data)
{
	tuba_streams_connection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TubaStreamsConnection_private_offset);
	((TubaStreamsConnectionClass *) klass)->on_message = (void (*) (TubaStreamsConnection*, gint, GBytes*)) tuba_streams_connection_real_on_message;
	G_OBJECT_CLASS (klass)->get_property = _vala_tuba_streams_connection_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tuba_streams_connection_set_property;
	G_OBJECT_CLASS (klass)->finalize = tuba_streams_connection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_STREAMS_CONNECTION_URL_PROPERTY, tuba_streams_connection_properties[TUBA_STREAMS_CONNECTION_URL_PROPERTY] = g_param_spec_string ("url", "url", "url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_STREAMS_CONNECTION_NAME_PROPERTY, tuba_streams_connection_properties[TUBA_STREAMS_CONNECTION_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
tuba_streams_connection_instance_init (TubaStreamsConnection * self,
                                       gpointer klass)
{
	self->priv = tuba_streams_connection_get_instance_private (self);
	self->closing = FALSE;
	self->timeout = 1;
}

static void
tuba_streams_connection_finalize (GObject * obj)
{
	TubaStreamsConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_STREAMS_TYPE_CONNECTION, TubaStreamsConnection);
	_g_object_unref0 (self->subscribers);
	_g_object_unref0 (self->socket);
	_g_free0 (self->priv->_url);
	G_OBJECT_CLASS (tuba_streams_connection_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
tuba_streams_connection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TubaStreamsConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tuba_streams_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TubaStreamsConnection), 0, (GInstanceInitFunc) tuba_streams_connection_instance_init, NULL };
	GType tuba_streams_connection_type_id;
	tuba_streams_connection_type_id = g_type_register_static (G_TYPE_OBJECT, "TubaStreamsConnection", &g_define_type_info, 0);
	TubaStreamsConnection_private_offset = g_type_add_instance_private (tuba_streams_connection_type_id, sizeof (TubaStreamsConnectionPrivate));
	return tuba_streams_connection_type_id;
}

GType
tuba_streams_connection_get_type (void)
{
	static gsize tuba_streams_connection_type_id__once = 0;
	if (g_once_init_enter (&tuba_streams_connection_type_id__once)) {
		GType tuba_streams_connection_type_id;
		tuba_streams_connection_type_id = tuba_streams_connection_get_type_once ();
		g_once_init_leave (&tuba_streams_connection_type_id__once, tuba_streams_connection_type_id);
	}
	return tuba_streams_connection_type_id__once;
}

static void
_vala_tuba_streams_connection_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	TubaStreamsConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_STREAMS_TYPE_CONNECTION, TubaStreamsConnection);
	switch (property_id) {
		case TUBA_STREAMS_CONNECTION_URL_PROPERTY:
		g_value_set_string (value, tuba_streams_connection_get_url (self));
		break;
		case TUBA_STREAMS_CONNECTION_NAME_PROPERTY:
		g_value_take_string (value, tuba_streams_connection_get_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tuba_streams_connection_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	TubaStreamsConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_STREAMS_TYPE_CONNECTION, TubaStreamsConnection);
	switch (property_id) {
		case TUBA_STREAMS_CONNECTION_URL_PROPERTY:
		tuba_streams_connection_set_url (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
tuba_streams_class_init (TubaStreamsClass * klass,
                         gpointer klass_data)
{
	tuba_streams_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TubaStreams_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_tuba_streams_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tuba_streams_set_property;
	G_OBJECT_CLASS (klass)->finalize = tuba_streams_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_STREAMS_CONNECTIONS_PROPERTY, tuba_streams_properties[TUBA_STREAMS_CONNECTIONS_PROPERTY] = g_param_spec_boxed ("connections", "connections", "connections", G_TYPE_HASH_TABLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
tuba_streams_instance_init (TubaStreams * self,
                            gpointer klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	self->priv = tuba_streams_get_instance_private (self);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	self->priv->_connections = _tmp2_;
}

static void
tuba_streams_finalize (GObject * obj)
{
	TubaStreams * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_TYPE_STREAMS, TubaStreams);
	_g_hash_table_unref0 (self->priv->_connections);
	G_OBJECT_CLASS (tuba_streams_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
tuba_streams_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TubaStreamsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tuba_streams_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TubaStreams), 0, (GInstanceInitFunc) tuba_streams_instance_init, NULL };
	GType tuba_streams_type_id;
	tuba_streams_type_id = g_type_register_static (G_TYPE_OBJECT, "TubaStreams", &g_define_type_info, 0);
	TubaStreams_private_offset = g_type_add_instance_private (tuba_streams_type_id, sizeof (TubaStreamsPrivate));
	return tuba_streams_type_id;
}

GType
tuba_streams_get_type (void)
{
	static gsize tuba_streams_type_id__once = 0;
	if (g_once_init_enter (&tuba_streams_type_id__once)) {
		GType tuba_streams_type_id;
		tuba_streams_type_id = tuba_streams_get_type_once ();
		g_once_init_leave (&tuba_streams_type_id__once, tuba_streams_type_id);
	}
	return tuba_streams_type_id__once;
}

static void
_vala_tuba_streams_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	TubaStreams * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_TYPE_STREAMS, TubaStreams);
	switch (property_id) {
		case TUBA_STREAMS_CONNECTIONS_PROPERTY:
		g_value_set_boxed (value, tuba_streams_get_connections (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tuba_streams_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	TubaStreams * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_TYPE_STREAMS, TubaStreams);
	switch (property_id) {
		case TUBA_STREAMS_CONNECTIONS_PROPERTY:
		tuba_streams_set_connections (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

