/* Network.c generated by valac 0.56.17, the Vala compiler
 * generated from Network.vala, do not modify */

#include <glib-object.h>
#include <libsoup/soup.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <adwaita.h>

#define BUILD_NAME "Tuba"
#define BUILD_VERSION "0.7.2"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TUBA_TYPE_NETWORK (tuba_network_get_type ())
#define TUBA_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_NETWORK, TubaNetwork))
#define TUBA_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_NETWORK, TubaNetworkClass))
#define TUBA_IS_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_NETWORK))
#define TUBA_IS_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_NETWORK))
#define TUBA_NETWORK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_NETWORK, TubaNetworkClass))

typedef struct _TubaNetwork TubaNetwork;
typedef struct _TubaNetworkClass TubaNetworkClass;
typedef struct _TubaNetworkPrivate TubaNetworkPrivate;
enum  {
	TUBA_NETWORK_0_PROPERTY,
	TUBA_NETWORK_SESSION_PROPERTY,
	TUBA_NETWORK_NUM_PROPERTIES
};
static GParamSpec* tuba_network_properties[TUBA_NETWORK_NUM_PROPERTIES];
typedef enum  {
	TUBA_NETWORK_EXTRA_DATA_RESPONSE_HEADERS
} TubaNetworkExtraData;

#define TUBA_NETWORK_TYPE_EXTRA_DATA (tuba_network_extra_data_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef void (*TubaNetworkSuccessCallback) (GInputStream* in_stream, SoupMessageHeaders* response_headers, gpointer user_data, GError** error);
typedef void (*TubaNetworkErrorCallback) (gint32 code, const gchar* reason, gpointer user_data);
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
typedef struct _Block47Data Block47Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define TUBA_TYPE_APPLICATION (tuba_application_get_type ())
#define TUBA_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_APPLICATION, TubaApplication))
#define TUBA_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_APPLICATION, TubaApplicationClass))
#define TUBA_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_APPLICATION))
#define TUBA_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_APPLICATION))
#define TUBA_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_APPLICATION, TubaApplicationClass))

typedef struct _TubaApplication TubaApplication;
typedef struct _TubaApplicationClass TubaApplicationClass;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef void (*TubaNetworkNodeCallback) (JsonNode* node, gpointer user_data, GError** error);
typedef struct _Block48Data Block48Data;
typedef void (*TubaNetworkObjectCallback) (JsonObject* node, gpointer user_data, GError** error);
enum  {
	TUBA_NETWORK_STARTED_SIGNAL,
	TUBA_NETWORK_FINISHED_SIGNAL,
	TUBA_NETWORK_NUM_SIGNALS
};
static guint tuba_network_signals[TUBA_NETWORK_NUM_SIGNALS] = {0};

struct _TubaNetwork {
	GObject parent_instance;
	TubaNetworkPrivate * priv;
};

struct _TubaNetworkClass {
	GObjectClass parent_class;
};

struct _TubaNetworkPrivate {
	SoupSession* _session;
	SoupCache* cache;
	gint requests_processing;
};

struct _Block47Data {
	int _ref_count_;
	TubaNetwork* self;
	SoupMessage* msg;
	TubaNetworkSuccessCallback cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
	TubaNetworkErrorCallback ecb;
	gpointer ecb_target;
	GDestroyNotify ecb_target_destroy_notify;
	TubaNetworkExtraData* extra_data;
};

struct _Block48Data {
	int _ref_count_;
	TubaNetworkNodeCallback cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
};

static gint TubaNetwork_private_offset;
static gpointer tuba_network_parent_class = NULL;
VALA_EXTERN TubaNetwork* tuba_network;
VALA_EXTERN TubaApplication* tuba_app;
VALA_EXTERN gchar* tuba_cache_path;

VALA_EXTERN GType tuba_network_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaNetwork, g_object_unref)
VALA_EXTERN GType tuba_network_extra_data_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void tuba_network_clear_cache (TubaNetwork* self);
VALA_EXTERN void tuba_helper_image_clear_cache (void);
VALA_EXTERN void tuba_network_flush_cache (TubaNetwork* self);
VALA_EXTERN void tuba_helper_image_flush_cache (void);
VALA_EXTERN void tuba_network_queue (TubaNetwork* self,
                         SoupMessage* msg,
                         GCancellable* cancellable,
                         TubaNetworkSuccessCallback cb,
                         gpointer cb_target,
                         GDestroyNotify cb_target_destroy_notify,
                         TubaNetworkErrorCallback ecb,
                         gpointer ecb_target,
                         GDestroyNotify ecb_target_destroy_notify,
                         TubaNetworkExtraData* extra_data);
static TubaNetworkExtraData* _tuba_network_extra_data_dup (TubaNetworkExtraData* self);
static Block47Data* block47_data_ref (Block47Data* _data47_);
static void block47_data_unref (void * _userdata_);
VALA_EXTERN SoupSession* tuba_network_get_session (TubaNetwork* self);
static void __lambda11_ (Block47Data* _data47_,
                  GObject* obj,
                  GAsyncResult* res);
static gboolean _tuba_network_extra_data_equal (const TubaNetworkExtraData * s1,
                                         const TubaNetworkExtraData * s2);
VALA_EXTERN JsonParser* tuba_network_get_parser_from_inputstream (GInputStream* in_stream,
                                                      GError** error);
VALA_EXTERN JsonObject* tuba_network_parse (TubaNetwork* self,
                                JsonParser* parser);
static void ___lambda11__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void tuba_network_on_error (TubaNetwork* self,
                            gint32 code,
                            const gchar* message);
VALA_EXTERN GType tuba_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaApplication, g_object_unref)
VALA_EXTERN JsonNode* tuba_network_parse_node (TubaNetwork* self,
                                   JsonParser* parser);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static void _vala_JsonNode_free (JsonNode* self);
VALA_EXTERN JsonArray* tuba_network_get_array_mstd (JsonParser* parser);
VALA_EXTERN guint tuba_network_get_array_size (JsonParser* parser);
VALA_EXTERN void tuba_network_parse_array (JsonParser* parser,
                               TubaNetworkNodeCallback cb,
                               gpointer cb_target,
                               GDestroyNotify cb_target_destroy_notify,
                               GError** error);
static Block48Data* block48_data_ref (Block48Data* _data48_);
static void block48_data_unref (void * _userdata_);
static void __lambda12_ (Block48Data* _data48_,
                  JsonArray* array,
                  guint i,
                  JsonNode* node);
static void ___lambda12__json_array_foreach (JsonArray* array,
                                      guint index_,
                                      JsonNode* element_node,
                                      gpointer self);
VALA_EXTERN TubaNetwork* tuba_network_new (void);
VALA_EXTERN TubaNetwork* tuba_network_construct (GType object_type);
VALA_EXTERN void tuba_network_set_session (TubaNetwork* self,
                               SoupSession* value);
static GObject * tuba_network_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static void _tuba_network___lambda13_ (TubaNetwork* self,
                                SoupMessage* msg);
static void __tuba_network___lambda13__soup_session_request_unqueued (SoupSession* _sender,
                                                               SoupMessage* msg,
                                                               gpointer self);
static void tuba_network_finalize (GObject * obj);
static GType tuba_network_get_type_once (void);
static void _vala_tuba_network_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_tuba_network_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

static inline gpointer
tuba_network_get_instance_private (TubaNetwork* self)
{
	return G_STRUCT_MEMBER_P (self, TubaNetwork_private_offset);
}

 G_GNUC_NO_INLINE static GType
tuba_network_extra_data_get_type_once (void)
{
	static const GEnumValue values[] = {{TUBA_NETWORK_EXTRA_DATA_RESPONSE_HEADERS, "TUBA_NETWORK_EXTRA_DATA_RESPONSE_HEADERS", "response-headers"}, {0, NULL, NULL}};
	GType tuba_network_extra_data_type_id;
	tuba_network_extra_data_type_id = g_enum_register_static ("TubaNetworkExtraData", values);
	return tuba_network_extra_data_type_id;
}

GType
tuba_network_extra_data_get_type (void)
{
	static gsize tuba_network_extra_data_type_id__once = 0;
	if (g_once_init_enter (&tuba_network_extra_data_type_id__once)) {
		GType tuba_network_extra_data_type_id;
		tuba_network_extra_data_type_id = tuba_network_extra_data_get_type_once ();
		g_once_init_leave (&tuba_network_extra_data_type_id__once, tuba_network_extra_data_type_id);
	}
	return tuba_network_extra_data_type_id__once;
}

void
tuba_network_clear_cache (TubaNetwork* self)
{
	SoupCache* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cache;
	soup_cache_clear (_tmp0_);
	tuba_helper_image_clear_cache ();
}

void
tuba_network_flush_cache (TubaNetwork* self)
{
	SoupCache* _tmp0_;
	SoupCache* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cache;
	soup_cache_flush (_tmp0_);
	_tmp1_ = self->priv->cache;
	soup_cache_dump (_tmp1_);
	tuba_helper_image_flush_cache ();
}

static TubaNetworkExtraData*
_tuba_network_extra_data_dup (TubaNetworkExtraData* self)
{
	TubaNetworkExtraData* dup;
	dup = g_new0 (TubaNetworkExtraData, 1);
	memcpy (dup, self, sizeof (TubaNetworkExtraData));
	return dup;
}

static gpointer
__tuba_network_extra_data_dup0 (gpointer self)
{
	return self ? _tuba_network_extra_data_dup (self) : NULL;
}

static Block47Data*
block47_data_ref (Block47Data* _data47_)
{
	g_atomic_int_inc (&_data47_->_ref_count_);
	return _data47_;
}

static void
block47_data_unref (void * _userdata_)
{
	Block47Data* _data47_;
	_data47_ = (Block47Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data47_->_ref_count_)) {
		TubaNetwork* self;
		self = _data47_->self;
		_g_object_unref0 (_data47_->msg);
		(_data47_->cb_target_destroy_notify == NULL) ? NULL : (_data47_->cb_target_destroy_notify (_data47_->cb_target), NULL);
		_data47_->cb = NULL;
		_data47_->cb_target = NULL;
		_data47_->cb_target_destroy_notify = NULL;
		(_data47_->ecb_target_destroy_notify == NULL) ? NULL : (_data47_->ecb_target_destroy_notify (_data47_->ecb_target), NULL);
		_data47_->ecb = NULL;
		_data47_->ecb_target = NULL;
		_data47_->ecb_target_destroy_notify = NULL;
		_g_free0 (_data47_->extra_data);
		_g_object_unref0 (self);
		g_slice_free (Block47Data, _data47_);
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gboolean
_tuba_network_extra_data_equal (const TubaNetworkExtraData * s1,
                                const TubaNetworkExtraData * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

static void
__lambda11_ (Block47Data* _data47_,
             GObject* obj,
             GAsyncResult* res)
{
	TubaNetwork* self;
	GError* _inner_error0_ = NULL;
	self = _data47_->self;
	g_return_if_fail (res != NULL);
	{
		GInputStream* in_stream = NULL;
		SoupSession* _tmp0_;
		GInputStream* _tmp1_;
		guint status = 0U;
		guint _tmp2_;
		guint _tmp3_;
		_tmp0_ = self->priv->_session;
		_tmp1_ = soup_session_send_finish (_tmp0_, res, &_inner_error0_);
		in_stream = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_object_get (_data47_->msg, "status-code", &_tmp2_, NULL);
		_tmp3_ = _tmp2_;
		status = _tmp3_;
		if (status == ((guint) SOUP_STATUS_OK)) {
			{
				if (_data47_->cb != NULL) {
					SoupMessageHeaders* _tmp4_ = NULL;
					TubaNetworkExtraData _tmp5_;
					_tmp5_ = TUBA_NETWORK_EXTRA_DATA_RESPONSE_HEADERS;
					if (_tuba_network_extra_data_equal (_data47_->extra_data, &_tmp5_) == TRUE) {
						SoupMessageHeaders* _tmp6_;
						SoupMessageHeaders* _tmp7_;
						_tmp6_ = soup_message_get_response_headers (_data47_->msg);
						_tmp7_ = _tmp6_;
						_tmp4_ = _tmp7_;
					} else {
						_tmp4_ = NULL;
					}
					_data47_->cb (in_stream, _tmp4_, _data47_->cb_target, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp8_ = e;
				_tmp9_ = _tmp8_->message;
				_tmp10_ = string_to_string (_tmp9_);
				_tmp11_ = g_strconcat ("Error in session: ", _tmp10_, NULL);
				_tmp12_ = _tmp11_;
				g_warning ("Network.vala:71: %s", _tmp12_);
				_g_free0 (_tmp12_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (in_stream);
				goto __catch0_g_error;
			}
		} else {
			if (status == ((guint) G_IO_ERROR_CANCELLED)) {
				g_debug ("Network.vala:74: Message is cancelled. Ignoring callback invocation.");
			} else {
				if (_data47_->ecb == NULL) {
					GUri* _tmp13_;
					GUri* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					const gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					_tmp13_ = soup_message_get_uri (_data47_->msg);
					_tmp14_ = _tmp13_;
					_tmp15_ = g_uri_to_string (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = string_to_string (_tmp16_);
					_tmp18_ = g_strdup_printf ("%u", status);
					_tmp19_ = _tmp18_;
					_tmp20_ = soup_message_get_reason_phrase (_data47_->msg);
					_tmp21_ = _tmp20_;
					_tmp22_ = string_to_string (_tmp21_);
					_tmp23_ = g_strconcat ("Request \"", _tmp17_, "\" failed: ", _tmp19_, " ", _tmp22_, NULL);
					_tmp24_ = _tmp23_;
					g_critical ("Network.vala:77: %s", _tmp24_);
					_g_free0 (_tmp24_);
					_g_free0 (_tmp19_);
					_g_free0 (_tmp16_);
				} else {
					gchar* error_msg = NULL;
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					const gchar* _tmp37_;
					_tmp25_ = soup_message_get_reason_phrase (_data47_->msg);
					_tmp26_ = _tmp25_;
					_tmp27_ = g_strdup (_tmp26_);
					error_msg = _tmp27_;
					{
						JsonParser* parser = NULL;
						JsonParser* _tmp28_;
						JsonObject* root = NULL;
						TubaNetwork* _tmp29_;
						JsonParser* _tmp30_;
						JsonObject* _tmp31_;
						JsonObject* _tmp32_;
						const gchar* _tmp33_;
						const gchar* _tmp34_;
						const gchar* _tmp35_;
						gchar* _tmp36_;
						_tmp28_ = tuba_network_get_parser_from_inputstream (in_stream, &_inner_error0_);
						parser = _tmp28_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch2_g_error;
						}
						_tmp29_ = tuba_network;
						_tmp30_ = parser;
						_tmp31_ = tuba_network_parse (_tmp29_, _tmp30_);
						root = _tmp31_;
						_tmp32_ = root;
						_tmp33_ = soup_message_get_reason_phrase (_data47_->msg);
						_tmp34_ = _tmp33_;
						_tmp35_ = json_object_get_string_member_with_default (_tmp32_, "error", _tmp34_);
						_tmp36_ = g_strdup (_tmp35_);
						_g_free0 (error_msg);
						error_msg = _tmp36_;
						_json_object_unref0 (root);
						_g_object_unref0 (parser);
					}
					goto __finally2;
					__catch2_g_error:
					{
						g_clear_error (&_inner_error0_);
					}
					__finally2:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (error_msg);
						_g_object_unref0 (in_stream);
						goto __catch0_g_error;
					}
					_tmp37_ = error_msg;
					_data47_->ecb ((gint32) status, _tmp37_, _data47_->ecb_target);
					_g_free0 (error_msg);
				}
			}
		}
		_g_object_unref0 (in_stream);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp38_;
		const gchar* _tmp39_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp38_ = e;
		_tmp39_ = _tmp38_->message;
		g_warning ("Network.vala:91: %s", _tmp39_);
		if (_data47_->ecb != NULL) {
			GError* _tmp40_;
			GError* _tmp41_;
			const gchar* _tmp42_;
			_tmp40_ = e;
			_tmp41_ = e;
			_tmp42_ = _tmp41_->message;
			_data47_->ecb ((gint32) _tmp40_->code, _tmp42_, _data47_->ecb_target);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda11__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda11_ (self, source_object, res);
	block47_data_unref (self);
}

void
tuba_network_queue (TubaNetwork* self,
                    SoupMessage* msg,
                    GCancellable* cancellable,
                    TubaNetworkSuccessCallback cb,
                    gpointer cb_target,
                    GDestroyNotify cb_target_destroy_notify,
                    TubaNetworkErrorCallback ecb,
                    gpointer ecb_target,
                    GDestroyNotify ecb_target_destroy_notify,
                    TubaNetworkExtraData* extra_data)
{
	Block47Data* _data47_;
	TubaNetworkExtraData* _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GUri* _tmp5_;
	GUri* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	SoupSession* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_data47_ = g_slice_new0 (Block47Data);
	_data47_->_ref_count_ = 1;
	_data47_->self = g_object_ref (self);
	_g_object_unref0 (_data47_->msg);
	_data47_->msg = msg;
	(_data47_->cb_target_destroy_notify == NULL) ? NULL : (_data47_->cb_target_destroy_notify (_data47_->cb_target), NULL);
	_data47_->cb = NULL;
	_data47_->cb_target = NULL;
	_data47_->cb_target_destroy_notify = NULL;
	_data47_->cb = cb;
	_data47_->cb_target = cb_target;
	_data47_->cb_target_destroy_notify = cb_target_destroy_notify;
	(_data47_->ecb_target_destroy_notify == NULL) ? NULL : (_data47_->ecb_target_destroy_notify (_data47_->ecb_target), NULL);
	_data47_->ecb = NULL;
	_data47_->ecb_target = NULL;
	_data47_->ecb_target_destroy_notify = NULL;
	_data47_->ecb = ecb;
	_data47_->ecb_target = ecb_target;
	_data47_->ecb_target_destroy_notify = ecb_target_destroy_notify;
	_tmp0_ = __tuba_network_extra_data_dup0 (extra_data);
	_g_free0 (_data47_->extra_data);
	_data47_->extra_data = _tmp0_;
	_tmp1_ = self->priv->requests_processing;
	self->priv->requests_processing = _tmp1_ + 1;
	g_signal_emit (self, tuba_network_signals[TUBA_NETWORK_STARTED_SIGNAL], 0);
	_tmp2_ = soup_message_get_method (_data47_->msg);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_to_string (_tmp3_);
	_tmp5_ = soup_message_get_uri (_data47_->msg);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_uri_to_string (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = string_to_string (_tmp8_);
	_tmp10_ = g_strconcat (_tmp4_, ": ", _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	g_debug ("Network.vala:59: %s", _tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp8_);
	_tmp12_ = self->priv->_session;
	soup_session_send_async (_tmp12_, _data47_->msg, 0, cancellable, ___lambda11__gasync_ready_callback, block47_data_ref (_data47_));
	block47_data_unref (_data47_);
	_data47_ = NULL;
}

void
tuba_network_on_error (TubaNetwork* self,
                       gint32 code,
                       const gchar* message)
{
	TubaApplication* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	g_warning ("Network.vala:100: %s", message);
	_tmp0_ = tuba_app;
	g_signal_emit_by_name (_tmp0_, "toast", message, (guint) 0);
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
	return g_boxed_copy (json_node_get_type (), self);
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
	return self ? _vala_JsonNode_copy (self) : NULL;
}

JsonNode*
tuba_network_parse_node (TubaNetwork* self,
                         JsonParser* parser)
{
	JsonNode* _tmp0_;
	JsonNode* _tmp1_;
	JsonNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parser != NULL, NULL);
	_tmp0_ = json_parser_get_root (parser);
	_tmp1_ = __vala_JsonNode_copy0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

JsonObject*
tuba_network_parse (TubaNetwork* self,
                    JsonParser* parser)
{
	JsonNode* _tmp0_;
	JsonNode* _tmp1_;
	JsonObject* _tmp2_;
	JsonObject* _tmp3_;
	JsonObject* _tmp4_;
	JsonObject* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parser != NULL, NULL);
	_tmp0_ = tuba_network_parse_node (self, parser);
	_tmp1_ = _tmp0_;
	_tmp2_ = json_node_get_object (_tmp1_);
	_tmp3_ = _json_object_ref0 (_tmp2_);
	_tmp4_ = _tmp3_;
	__vala_JsonNode_free0 (_tmp1_);
	result = _tmp4_;
	return result;
}

JsonParser*
tuba_network_get_parser_from_inputstream (GInputStream* in_stream,
                                          GError** error)
{
	JsonParser* parser = NULL;
	JsonParser* _tmp0_;
	GError* _inner_error0_ = NULL;
	JsonParser* result;
	g_return_val_if_fail (in_stream != NULL, NULL);
	_tmp0_ = json_parser_new ();
	parser = _tmp0_;
	json_parser_load_from_stream (parser, in_stream, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (parser);
		return NULL;
	}
	result = parser;
	return result;
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

JsonArray*
tuba_network_get_array_mstd (JsonParser* parser)
{
	JsonNode* _tmp0_;
	JsonArray* _tmp1_;
	JsonArray* _tmp2_;
	JsonArray* result;
	g_return_val_if_fail (parser != NULL, NULL);
	_tmp0_ = json_parser_get_root (parser);
	_tmp1_ = json_node_get_array (_tmp0_);
	_tmp2_ = _json_array_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

guint
tuba_network_get_array_size (JsonParser* parser)
{
	JsonArray* _tmp0_;
	JsonArray* _tmp1_;
	guint _tmp2_;
	guint result;
	g_return_val_if_fail (parser != NULL, 0U);
	_tmp0_ = tuba_network_get_array_mstd (parser);
	_tmp1_ = _tmp0_;
	_tmp2_ = json_array_get_length (_tmp1_);
	_json_array_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static Block48Data*
block48_data_ref (Block48Data* _data48_)
{
	g_atomic_int_inc (&_data48_->_ref_count_);
	return _data48_;
}

static void
block48_data_unref (void * _userdata_)
{
	Block48Data* _data48_;
	_data48_ = (Block48Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data48_->_ref_count_)) {
		(_data48_->cb_target_destroy_notify == NULL) ? NULL : (_data48_->cb_target_destroy_notify (_data48_->cb_target), NULL);
		_data48_->cb = NULL;
		_data48_->cb_target = NULL;
		_data48_->cb_target_destroy_notify = NULL;
		g_slice_free (Block48Data, _data48_);
	}
}

static void
__lambda12_ (Block48Data* _data48_,
             JsonArray* array,
             guint i,
             JsonNode* node)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (array != NULL);
	g_return_if_fail (node != NULL);
	{
		_data48_->cb (node, _data48_->cb_target, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		_tmp2_ = string_to_string (_tmp1_);
		_tmp3_ = g_strconcat ("Error parsing array: ", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		g_warning ("Network.vala:131: %s", _tmp4_);
		_g_free0 (_tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda12__json_array_foreach (JsonArray* array,
                                 guint index_,
                                 JsonNode* element_node,
                                 gpointer self)
{
	__lambda12_ (self, array, index_, element_node);
}

void
tuba_network_parse_array (JsonParser* parser,
                          TubaNetworkNodeCallback cb,
                          gpointer cb_target,
                          GDestroyNotify cb_target_destroy_notify,
                          GError** error)
{
	Block48Data* _data48_;
	JsonArray* _tmp0_;
	JsonArray* _tmp1_;
	g_return_if_fail (parser != NULL);
	_data48_ = g_slice_new0 (Block48Data);
	_data48_->_ref_count_ = 1;
	(_data48_->cb_target_destroy_notify == NULL) ? NULL : (_data48_->cb_target_destroy_notify (_data48_->cb_target), NULL);
	_data48_->cb = NULL;
	_data48_->cb_target = NULL;
	_data48_->cb_target_destroy_notify = NULL;
	_data48_->cb = cb;
	_data48_->cb_target = cb_target;
	_data48_->cb_target_destroy_notify = cb_target_destroy_notify;
	_tmp0_ = tuba_network_get_array_mstd (parser);
	_tmp1_ = _tmp0_;
	json_array_foreach_element (_tmp1_, ___lambda12__json_array_foreach, _data48_);
	_json_array_unref0 (_tmp1_);
	block48_data_unref (_data48_);
	_data48_ = NULL;
}

TubaNetwork*
tuba_network_construct (GType object_type)
{
	TubaNetwork * self = NULL;
	self = (TubaNetwork*) g_object_new (object_type, NULL);
	return self;
}

TubaNetwork*
tuba_network_new (void)
{
	return tuba_network_construct (TUBA_TYPE_NETWORK);
}

SoupSession*
tuba_network_get_session (TubaNetwork* self)
{
	SoupSession* result;
	SoupSession* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_session;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
tuba_network_set_session (TubaNetwork* self,
                          SoupSession* value)
{
	SoupSession* old_value;
	g_return_if_fail (self != NULL);
	old_value = tuba_network_get_session (self);
	if (old_value != value) {
		SoupSession* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_session);
		self->priv->_session = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tuba_network_properties[TUBA_NETWORK_SESSION_PROPERTY]);
	}
}

static void
_tuba_network___lambda13_ (TubaNetwork* self,
                           SoupMessage* msg)
{
	gint _tmp0_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = self->priv->requests_processing;
	self->priv->requests_processing = _tmp0_ - 1;
	if (self->priv->requests_processing <= 0) {
		g_signal_emit (self, tuba_network_signals[TUBA_NETWORK_FINISHED_SIGNAL], 0);
	}
}

static void
__tuba_network___lambda13__soup_session_request_unqueued (SoupSession* _sender,
                                                          SoupMessage* msg,
                                                          gpointer self)
{
	_tuba_network___lambda13_ ((TubaNetwork*) self, msg);
}

static GObject *
tuba_network_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TubaNetwork * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	SoupCache* _tmp3_;
	SoupCache* _tmp4_;
	SoupCache* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	SoupSession* _tmp21_ = NULL;
	SoupSession* _tmp22_;
	SoupSession* _tmp23_;
	SoupCache* _tmp24_;
	SoupSession* _tmp25_;
	parent_class = G_OBJECT_CLASS (tuba_network_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_TYPE_NETWORK, TubaNetwork);
	_tmp0_ = tuba_cache_path;
	_tmp1_ = g_build_path (G_DIR_SEPARATOR_S, _tmp0_, "soup", "misc", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = soup_cache_new (_tmp2_, SOUP_CACHE_SINGLE_USER);
	_g_object_unref0 (self->priv->cache);
	self->priv->cache = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp4_ = self->priv->cache;
	soup_cache_load (_tmp4_);
	_tmp5_ = self->priv->cache;
	soup_cache_set_max_size (_tmp5_, (guint) ((1024 * 1024) * 100));
	_tmp6_ = string_to_string (BUILD_NAME);
	_tmp7_ = string_to_string (BUILD_VERSION);
	_tmp8_ = g_strdup_printf ("%u", soup_get_major_version ());
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf ("%u", soup_get_minor_version ());
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("%u", soup_get_micro_version ());
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strdup_printf ("%i", SOUP_MAJOR_VERSION);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strdup_printf ("%i", SOUP_MINOR_VERSION);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strdup_printf ("%i", SOUP_MICRO_VERSION);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strconcat (_tmp6_, "/", _tmp7_, " libsoup/", _tmp9_, ".", _tmp11_, ".", _tmp13_, " (", _tmp15_, ".", _tmp17_, ".", _tmp19_, ")", NULL);
	_tmp21_ = soup_session_new_with_options ("max-conns", 64, "max-conns-per-host", 64, NULL);
	soup_session_set_user_agent (_tmp21_, _tmp20_);
	_g_free0 (_tmp20_);
	_tmp22_ = _tmp21_;
	tuba_network_set_session (self, _tmp22_);
	_g_object_unref0 (_tmp22_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_tmp23_ = self->priv->_session;
	_tmp24_ = self->priv->cache;
	soup_session_add_feature (_tmp23_, (SoupSessionFeature*) _tmp24_);
	_tmp25_ = self->priv->_session;
	g_signal_connect_object (_tmp25_, "request-unqueued", (GCallback) __tuba_network___lambda13__soup_session_request_unqueued, self, 0);
	return obj;
}

static void
tuba_network_class_init (TubaNetworkClass * klass,
                         gpointer klass_data)
{
	tuba_network_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TubaNetwork_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_tuba_network_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tuba_network_set_property;
	G_OBJECT_CLASS (klass)->constructor = tuba_network_constructor;
	G_OBJECT_CLASS (klass)->finalize = tuba_network_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_NETWORK_SESSION_PROPERTY, tuba_network_properties[TUBA_NETWORK_SESSION_PROPERTY] = g_param_spec_object ("session", "session", "session", soup_session_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	tuba_network_signals[TUBA_NETWORK_STARTED_SIGNAL] = g_signal_new ("started", TUBA_TYPE_NETWORK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	tuba_network_signals[TUBA_NETWORK_FINISHED_SIGNAL] = g_signal_new ("finished", TUBA_TYPE_NETWORK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
tuba_network_instance_init (TubaNetwork * self,
                            gpointer klass)
{
	self->priv = tuba_network_get_instance_private (self);
	self->priv->requests_processing = 0;
}

static void
tuba_network_finalize (GObject * obj)
{
	TubaNetwork * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_TYPE_NETWORK, TubaNetwork);
	_g_object_unref0 (self->priv->_session);
	_g_object_unref0 (self->priv->cache);
	G_OBJECT_CLASS (tuba_network_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
tuba_network_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TubaNetworkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tuba_network_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TubaNetwork), 0, (GInstanceInitFunc) tuba_network_instance_init, NULL };
	GType tuba_network_type_id;
	tuba_network_type_id = g_type_register_static (G_TYPE_OBJECT, "TubaNetwork", &g_define_type_info, 0);
	TubaNetwork_private_offset = g_type_add_instance_private (tuba_network_type_id, sizeof (TubaNetworkPrivate));
	return tuba_network_type_id;
}

GType
tuba_network_get_type (void)
{
	static gsize tuba_network_type_id__once = 0;
	if (g_once_init_enter (&tuba_network_type_id__once)) {
		GType tuba_network_type_id;
		tuba_network_type_id = tuba_network_get_type_once ();
		g_once_init_leave (&tuba_network_type_id__once, tuba_network_type_id);
	}
	return tuba_network_type_id__once;
}

static void
_vala_tuba_network_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	TubaNetwork * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_TYPE_NETWORK, TubaNetwork);
	switch (property_id) {
		case TUBA_NETWORK_SESSION_PROPERTY:
		g_value_set_object (value, tuba_network_get_session (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tuba_network_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	TubaNetwork * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_TYPE_NETWORK, TubaNetwork);
	switch (property_id) {
		case TUBA_NETWORK_SESSION_PROPERTY:
		tuba_network_set_session (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

