/* SecretAccountStore.c generated by valac 0.56.17, the Vala compiler
 * generated from SecretAccountStore.vala, do not modify */

#include <glib-object.h>
#include <glib.h>
#include <gee.h>
#include <libsecret/secret.h>
#include <stdlib.h>
#include <string.h>
#include <adwaita.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <libsoup/soup.h>
#include <json-glib/json-glib.h>
#include <glib/gi18n-lib.h>

#define TUBA_SECRET_ACCOUNT_STORE_VERSION "1"
#define BUILD_DOMAIN "dev.geopjr.Tuba"
#define BUILD_NAME "Tuba"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TUBA_TYPE_ACCOUNT_STORE (tuba_account_store_get_type ())
#define TUBA_ACCOUNT_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_ACCOUNT_STORE, TubaAccountStore))
#define TUBA_ACCOUNT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_ACCOUNT_STORE, TubaAccountStoreClass))
#define TUBA_IS_ACCOUNT_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_ACCOUNT_STORE))
#define TUBA_IS_ACCOUNT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_ACCOUNT_STORE))
#define TUBA_ACCOUNT_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_ACCOUNT_STORE, TubaAccountStoreClass))

typedef struct _TubaAccountStore TubaAccountStore;
typedef struct _TubaAccountStoreClass TubaAccountStoreClass;
typedef struct _TubaAccountStorePrivate TubaAccountStorePrivate;

#define TUBA_TYPE_ENTITY (tuba_entity_get_type ())
#define TUBA_ENTITY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_ENTITY, TubaEntity))
#define TUBA_ENTITY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_ENTITY, TubaEntityClass))
#define TUBA_IS_ENTITY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_ENTITY))
#define TUBA_IS_ENTITY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_ENTITY))
#define TUBA_ENTITY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_ENTITY, TubaEntityClass))

typedef struct _TubaEntity TubaEntity;
typedef struct _TubaEntityClass TubaEntityClass;

#define TUBA_API_TYPE_ACCOUNT (tuba_api_account_get_type ())
#define TUBA_API_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_API_TYPE_ACCOUNT, TubaAPIAccount))
#define TUBA_API_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_API_TYPE_ACCOUNT, TubaAPIAccountClass))
#define TUBA_API_IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_API_TYPE_ACCOUNT))
#define TUBA_API_IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_API_TYPE_ACCOUNT))
#define TUBA_API_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_API_TYPE_ACCOUNT, TubaAPIAccountClass))

typedef struct _TubaAPIAccount TubaAPIAccount;
typedef struct _TubaAPIAccountClass TubaAPIAccountClass;

#define TUBA_TYPE_INSTANCE_ACCOUNT (tuba_instance_account_get_type ())
#define TUBA_INSTANCE_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_INSTANCE_ACCOUNT, TubaInstanceAccount))
#define TUBA_INSTANCE_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_INSTANCE_ACCOUNT, TubaInstanceAccountClass))
#define TUBA_IS_INSTANCE_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_INSTANCE_ACCOUNT))
#define TUBA_IS_INSTANCE_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_INSTANCE_ACCOUNT))
#define TUBA_INSTANCE_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_INSTANCE_ACCOUNT, TubaInstanceAccountClass))

typedef struct _TubaInstanceAccount TubaInstanceAccount;
typedef struct _TubaInstanceAccountClass TubaInstanceAccountClass;

#define TUBA_ACCOUNT_STORE_TYPE_BACKEND_TEST (tuba_account_store_backend_test_get_type ())
#define TUBA_ACCOUNT_STORE_BACKEND_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_ACCOUNT_STORE_TYPE_BACKEND_TEST, TubaAccountStoreBackendTest))
#define TUBA_ACCOUNT_STORE_BACKEND_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_ACCOUNT_STORE_TYPE_BACKEND_TEST, TubaAccountStoreBackendTestClass))
#define TUBA_ACCOUNT_STORE_IS_BACKEND_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_ACCOUNT_STORE_TYPE_BACKEND_TEST))
#define TUBA_ACCOUNT_STORE_IS_BACKEND_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_ACCOUNT_STORE_TYPE_BACKEND_TEST))
#define TUBA_ACCOUNT_STORE_BACKEND_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_ACCOUNT_STORE_TYPE_BACKEND_TEST, TubaAccountStoreBackendTestClass))

typedef struct _TubaAccountStoreBackendTest TubaAccountStoreBackendTest;
typedef struct _TubaAccountStoreBackendTestClass TubaAccountStoreBackendTestClass;

#define TUBA_TYPE_SECRET_ACCOUNT_STORE (tuba_secret_account_store_get_type ())
#define TUBA_SECRET_ACCOUNT_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_SECRET_ACCOUNT_STORE, TubaSecretAccountStore))
#define TUBA_SECRET_ACCOUNT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_SECRET_ACCOUNT_STORE, TubaSecretAccountStoreClass))
#define TUBA_IS_SECRET_ACCOUNT_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_SECRET_ACCOUNT_STORE))
#define TUBA_IS_SECRET_ACCOUNT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_SECRET_ACCOUNT_STORE))
#define TUBA_SECRET_ACCOUNT_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_SECRET_ACCOUNT_STORE, TubaSecretAccountStoreClass))

typedef struct _TubaSecretAccountStore TubaSecretAccountStore;
typedef struct _TubaSecretAccountStoreClass TubaSecretAccountStoreClass;
typedef struct _TubaSecretAccountStorePrivate TubaSecretAccountStorePrivate;
enum  {
	TUBA_SECRET_ACCOUNT_STORE_0_PROPERTY,
	TUBA_SECRET_ACCOUNT_STORE_NUM_PROPERTIES
};
static GParamSpec* tuba_secret_account_store_properties[TUBA_SECRET_ACCOUNT_STORE_NUM_PROPERTIES];
#define _secret_schema_unref0(var) ((var == NULL) ? NULL : (var = (secret_schema_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block41Data Block41Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TUBA_DIALOGS_TYPE_NEW_ACCOUNT (tuba_dialogs_new_account_get_type ())
#define TUBA_DIALOGS_NEW_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_DIALOGS_TYPE_NEW_ACCOUNT, TubaDialogsNewAccount))
#define TUBA_DIALOGS_NEW_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_DIALOGS_TYPE_NEW_ACCOUNT, TubaDialogsNewAccountClass))
#define TUBA_DIALOGS_IS_NEW_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_DIALOGS_TYPE_NEW_ACCOUNT))
#define TUBA_DIALOGS_IS_NEW_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_DIALOGS_TYPE_NEW_ACCOUNT))
#define TUBA_DIALOGS_NEW_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_DIALOGS_TYPE_NEW_ACCOUNT, TubaDialogsNewAccountClass))

typedef struct _TubaDialogsNewAccount TubaDialogsNewAccount;
typedef struct _TubaDialogsNewAccountClass TubaDialogsNewAccountClass;

#define TUBA_TYPE_APPLICATION (tuba_application_get_type ())
#define TUBA_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_APPLICATION, TubaApplication))
#define TUBA_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_APPLICATION, TubaApplicationClass))
#define TUBA_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_APPLICATION))
#define TUBA_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_APPLICATION))
#define TUBA_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_APPLICATION, TubaApplicationClass))

typedef struct _TubaApplication TubaApplication;
typedef struct _TubaApplicationClass TubaApplicationClass;

#define TUBA_APPLICATION_TYPE_QUESTION_TEXT (tuba_application_question_text_get_type ())
typedef struct _TubaApplicationQuestionText TubaApplicationQuestionText;

#define TUBA_APPLICATION_TYPE_QUESTION_BUTTONS (tuba_application_question_buttons_get_type ())
typedef struct _TubaApplicationQuestionButtons TubaApplicationQuestionButtons;

#define TUBA_APPLICATION_TYPE_QUESTION_BUTTON (tuba_application_question_button_get_type ())
typedef struct _TubaApplicationQuestionButton TubaApplicationQuestionButton;
typedef enum  {
	TUBA_APPLICATION_QUESTION_ANSWER_YES,
	TUBA_APPLICATION_QUESTION_ANSWER_NO,
	TUBA_APPLICATION_QUESTION_ANSWER_CLOSE
} TubaApplicationQuestionAnswer;

#define TUBA_APPLICATION_TYPE_QUESTION_ANSWER (tuba_application_question_answer_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block42Data Block42Data;

#define TUBA_TYPE_REQUEST (tuba_request_get_type ())
#define TUBA_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_REQUEST, TubaRequest))
#define TUBA_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_REQUEST, TubaRequestClass))
#define TUBA_IS_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_REQUEST))
#define TUBA_IS_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_REQUEST))
#define TUBA_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_REQUEST, TubaRequestClass))

typedef struct _TubaRequest TubaRequest;
typedef struct _TubaRequestClass TubaRequestClass;
typedef void (*TubaNetworkSuccessCallback) (GInputStream* in_stream, SoupMessageHeaders* response_headers, gpointer user_data, GError** error);

#define TUBA_TYPE_NETWORK (tuba_network_get_type ())
#define TUBA_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_NETWORK, TubaNetwork))
#define TUBA_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_NETWORK, TubaNetworkClass))
#define TUBA_IS_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_NETWORK))
#define TUBA_IS_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_NETWORK))
#define TUBA_NETWORK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_NETWORK, TubaNetworkClass))

typedef struct _TubaNetwork TubaNetwork;
typedef struct _TubaNetworkClass TubaNetworkClass;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))

#define TUBA_DIALOGS_TYPE_MAIN_WINDOW (tuba_dialogs_main_window_get_type ())
#define TUBA_DIALOGS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_DIALOGS_TYPE_MAIN_WINDOW, TubaDialogsMainWindow))
#define TUBA_DIALOGS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_DIALOGS_TYPE_MAIN_WINDOW, TubaDialogsMainWindowClass))
#define TUBA_DIALOGS_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_DIALOGS_TYPE_MAIN_WINDOW))
#define TUBA_DIALOGS_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_DIALOGS_TYPE_MAIN_WINDOW))
#define TUBA_DIALOGS_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_DIALOGS_TYPE_MAIN_WINDOW, TubaDialogsMainWindowClass))

typedef struct _TubaDialogsMainWindow TubaDialogsMainWindow;
typedef struct _TubaDialogsMainWindowClass TubaDialogsMainWindowClass;
typedef struct _Block43Data Block43Data;

#define TUBA_API_TYPE_EMOJI (tuba_api_emoji_get_type ())
#define TUBA_API_EMOJI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_API_TYPE_EMOJI, TubaAPIEmoji))
#define TUBA_API_EMOJI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_API_TYPE_EMOJI, TubaAPIEmojiClass))
#define TUBA_API_IS_EMOJI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_API_TYPE_EMOJI))
#define TUBA_API_IS_EMOJI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_API_TYPE_EMOJI))
#define TUBA_API_EMOJI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_API_TYPE_EMOJI, TubaAPIEmojiClass))

typedef struct _TubaAPIEmoji TubaAPIEmoji;
typedef struct _TubaAPIEmojiClass TubaAPIEmojiClass;
#define _secret_value_unref0(var) ((var == NULL) ? NULL : (var = (secret_value_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

struct _TubaAccountStore {
	GObject parent_instance;
	TubaAccountStorePrivate * priv;
	GeeArrayList* backend_tests;
};

struct _TubaAccountStoreClass {
	GObjectClass parent_class;
	void (*init) (TubaAccountStore* self, GError** error);
	void (*load) (TubaAccountStore* self, GError** error);
	void (*save) (TubaAccountStore* self, GError** error);
	void (*add) (TubaAccountStore* self, TubaInstanceAccount* account, GError** error);
	void (*remove) (TubaAccountStore* self, TubaInstanceAccount* account, GError** error);
};

struct _TubaSecretAccountStore {
	TubaAccountStore parent_instance;
	TubaSecretAccountStorePrivate * priv;
};

struct _TubaSecretAccountStoreClass {
	TubaAccountStoreClass parent_class;
};

struct _TubaSecretAccountStorePrivate {
	SecretSchema* schema;
	GHashTable* schema_attributes;
};

struct _Block41Data {
	int _ref_count_;
	TubaSecretAccountStore* self;
	gchar* wiki_page;
};

struct _TubaApplicationQuestionText {
	gchar* text;
	gboolean use_markup;
};

struct _TubaApplicationQuestionButton {
	gchar* label;
	AdwResponseAppearance appearance;
};

struct _TubaApplicationQuestionButtons {
	TubaApplicationQuestionButton yes;
	TubaApplicationQuestionButton no;
};

struct _Block42Data {
	int _ref_count_;
	TubaSecretAccountStore* self;
	TubaInstanceAccount* account;
};

struct _Block43Data {
	int _ref_count_;
	TubaSecretAccountStore* self;
	TubaInstanceAccount* account;
};

static gint TubaSecretAccountStore_private_offset;
static gpointer tuba_secret_account_store_parent_class = NULL;
VALA_EXTERN TubaApplication* tuba_app;
VALA_EXTERN TubaNetwork* tuba_network;
VALA_EXTERN TubaAccountStore* tuba_accounts;

VALA_EXTERN GType tuba_account_store_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaAccountStore, g_object_unref)
VALA_EXTERN GType tuba_entity_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaEntity, g_object_unref)
VALA_EXTERN GType tuba_api_account_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaAPIAccount, g_object_unref)
VALA_EXTERN GType tuba_instance_account_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaInstanceAccount, g_object_unref)
VALA_EXTERN GType tuba_account_store_backend_test_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaAccountStoreBackendTest, g_object_unref)
VALA_EXTERN GType tuba_secret_account_store_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaSecretAccountStore, g_object_unref)
VALA_EXTERN void tuba_account_store_init (TubaAccountStore* self,
                              GError** error);
VALA_EXTERN void tuba_account_store_load (TubaAccountStore* self,
                              GError** error);
VALA_EXTERN void tuba_account_store_save (TubaAccountStore* self,
                              GError** error);
VALA_EXTERN void tuba_account_store_remove (TubaAccountStore* self,
                                TubaInstanceAccount* account,
                                GError** error);
static void tuba_secret_account_store_real_init (TubaAccountStore* base,
                                          GError** error);
static void _g_free0_ (gpointer var);
static void tuba_secret_account_store_real_load (TubaAccountStore* base,
                                          GError** error);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static Block41Data* block41_data_ref (Block41Data* _data41_);
static void block41_data_unref (void * _userdata_);
VALA_EXTERN TubaDialogsNewAccount* tuba_dialogs_new_account_new (void);
VALA_EXTERN TubaDialogsNewAccount* tuba_dialogs_new_account_construct (GType object_type);
VALA_EXTERN GType tuba_dialogs_new_account_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaDialogsNewAccount, g_object_unref)
VALA_EXTERN GType tuba_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaApplication, g_object_unref)
VALA_EXTERN GType tuba_application_question_text_get_type (void) G_GNUC_CONST ;
VALA_EXTERN TubaApplicationQuestionText* tuba_application_question_text_dup (const TubaApplicationQuestionText* self);
VALA_EXTERN void tuba_application_question_text_free (TubaApplicationQuestionText* self);
VALA_EXTERN void tuba_application_question_text_copy (const TubaApplicationQuestionText* self,
                                          TubaApplicationQuestionText* dest);
VALA_EXTERN void tuba_application_question_text_destroy (TubaApplicationQuestionText* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (TubaApplicationQuestionText, tuba_application_question_text_destroy)
VALA_EXTERN GType tuba_application_question_buttons_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType tuba_application_question_button_get_type (void) G_GNUC_CONST ;
VALA_EXTERN TubaApplicationQuestionButton* tuba_application_question_button_dup (const TubaApplicationQuestionButton* self);
VALA_EXTERN void tuba_application_question_button_free (TubaApplicationQuestionButton* self);
VALA_EXTERN void tuba_application_question_button_copy (const TubaApplicationQuestionButton* self,
                                            TubaApplicationQuestionButton* dest);
VALA_EXTERN void tuba_application_question_button_destroy (TubaApplicationQuestionButton* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (TubaApplicationQuestionButton, tuba_application_question_button_destroy)
VALA_EXTERN TubaApplicationQuestionButtons* tuba_application_question_buttons_dup (const TubaApplicationQuestionButtons* self);
VALA_EXTERN void tuba_application_question_buttons_free (TubaApplicationQuestionButtons* self);
VALA_EXTERN void tuba_application_question_buttons_copy (const TubaApplicationQuestionButtons* self,
                                             TubaApplicationQuestionButtons* dest);
VALA_EXTERN void tuba_application_question_buttons_destroy (TubaApplicationQuestionButtons* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (TubaApplicationQuestionButtons, tuba_application_question_buttons_destroy)
VALA_EXTERN void tuba_application_question (TubaApplication* self,
                                TubaApplicationQuestionText* title,
                                TubaApplicationQuestionText* msg,
                                GtkWidget* win,
                                TubaApplicationQuestionButtons* buttons,
                                gboolean skip,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
VALA_EXTERN GType tuba_application_question_answer_get_type (void) G_GNUC_CONST ;
VALA_EXTERN TubaApplicationQuestionAnswer tuba_application_question_finish (TubaApplication* self,
                                                                GAsyncResult* _res_);
VALA_EXTERN TubaDialogsNewAccount* tuba_application_get_add_account_window (TubaApplication* self);
static void ___lambda231_ (Block41Data* _data41_,
                    GObject* obj,
                    GAsyncResult* res);
VALA_EXTERN gboolean tuba_application_question_answer_truthy (TubaApplicationQuestionAnswer self);
VALA_EXTERN gboolean tuba_host_open_uri (const gchar* _uri);
static void ____lambda231__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void __lambda232_ (TubaSecretAccountStore* self,
                   SecretRetrievable* item);
static Block42Data* block42_data_ref (Block42Data* _data42_);
static void block42_data_unref (void * _userdata_);
static TubaInstanceAccount* tuba_secret_account_store_secret_to_account (TubaSecretAccountStore* self,
                                                                  SecretRetrievable* item,
                                                                  gboolean* force_save);
VALA_EXTERN const gchar* tuba_api_account_get_id (TubaAPIAccount* self);
VALA_EXTERN TubaRequest* tuba_request_new_GET (const gchar* url);
VALA_EXTERN TubaRequest* tuba_request_construct_GET (GType object_type,
                                         const gchar* url);
VALA_EXTERN GType tuba_request_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaRequest, g_object_unref)
VALA_EXTERN TubaRequest* tuba_request_with_account (TubaRequest* self,
                                        TubaInstanceAccount* account);
VALA_EXTERN TubaRequest* tuba_request_then (TubaRequest* self,
                                TubaNetworkSuccessCallback cb,
                                gpointer cb_target,
                                GDestroyNotify cb_target_destroy_notify);
static void ___lambda233_ (Block42Data* _data42_,
                    GInputStream* in_stream,
                    GError** error);
VALA_EXTERN JsonParser* tuba_network_get_parser_from_inputstream (GInputStream* in_stream,
                                                      GError** error);
VALA_EXTERN GType tuba_network_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaNetwork, g_object_unref)
VALA_EXTERN JsonNode* tuba_network_parse_node (TubaNetwork* self,
                                   JsonParser* parser);
VALA_EXTERN TubaAPIAccount* tuba_api_account_from (JsonNode* node,
                                       GError** error);
static void _vala_JsonNode_free (JsonNode* self);
VALA_EXTERN const gchar* tuba_api_account_get_display_name (TubaAPIAccount* self);
VALA_EXTERN const gchar* tuba_api_account_get_avatar (TubaAPIAccount* self);
VALA_EXTERN void tuba_api_account_set_display_name (TubaAPIAccount* self,
                                        const gchar* value);
VALA_EXTERN void tuba_api_account_set_avatar (TubaAPIAccount* self,
                                  const gchar* value);
static void tuba_secret_account_store_account_to_secret (TubaSecretAccountStore* self,
                                                  TubaInstanceAccount* account);
static void ____lambda233__tuba_network_success_callback (GInputStream* in_stream,
                                                   SoupMessageHeaders* response_headers,
                                                   gpointer self,
                                                   GError** error);
VALA_EXTERN TubaRequest* tuba_request_exec (TubaRequest* self);
VALA_EXTERN GeeArrayList* tuba_account_store_get_saved (TubaAccountStore* self);
VALA_EXTERN void tuba_account_store_safe_save (TubaAccountStore* self);
static void ___lambda232__gfunc (gconstpointer data,
                          gpointer self);
static void tuba_secret_account_store_real_save (TubaAccountStore* base,
                                          GError** error);
static gboolean __lambda235_ (TubaSecretAccountStore* self,
                       TubaInstanceAccount* account);
static gboolean ___lambda235__gee_forall_func (gpointer g,
                                        gpointer self);
static void tuba_secret_account_store_real_remove (TubaAccountStore* base,
                                            TubaInstanceAccount* account,
                                            GError** error);
VALA_EXTERN gchar* tuba_instance_account_get_handle (TubaInstanceAccount* self);
static void __lambda236_ (TubaSecretAccountStore* self,
                   GObject* obj,
                   GAsyncResult* async_res);
VALA_EXTERN AdwAlertDialog* tuba_application_inform (TubaApplication* self,
                                         const gchar* text,
                                         const gchar* msg);
VALA_EXTERN GType tuba_dialogs_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaDialogsMainWindow, g_object_unref)
VALA_EXTERN TubaDialogsMainWindow* tuba_application_get_main_window (TubaApplication* self);
static void ___lambda236__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static Block43Data* block43_data_ref (Block43Data* _data43_);
static void block43_data_unref (void * _userdata_);
VALA_EXTERN const gchar* tuba_api_account_get_username (TubaAPIAccount* self);
VALA_EXTERN const gchar* tuba_api_account_get_acct (TubaAPIAccount* self);
VALA_EXTERN const gchar* tuba_api_account_get_header (TubaAPIAccount* self);
VALA_EXTERN const gchar* tuba_api_account_get_url (TubaAPIAccount* self);
VALA_EXTERN const gchar* tuba_instance_account_get_instance (TubaInstanceAccount* self);
VALA_EXTERN const gchar* tuba_instance_account_get_client_id (TubaInstanceAccount* self);
VALA_EXTERN const gchar* tuba_instance_account_get_client_secret (TubaInstanceAccount* self);
VALA_EXTERN const gchar* tuba_instance_account_get_access_token (TubaInstanceAccount* self);
VALA_EXTERN const gchar* tuba_instance_account_get_backend (TubaInstanceAccount* self);
VALA_EXTERN const gchar* tuba_instance_account_get_uuid (TubaInstanceAccount* self);
VALA_EXTERN GType tuba_api_emoji_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaAPIEmoji, g_object_unref)
VALA_EXTERN GeeArrayList* tuba_api_account_get_emojis (TubaAPIAccount* self);
static gint* _int_dup (gint* self);
VALA_EXTERN const gchar* tuba_api_emoji_get_shortcode (TubaAPIEmoji* self);
VALA_EXTERN const gchar* tuba_api_emoji_get_url (TubaAPIEmoji* self);
static void __lambda234_ (Block43Data* _data43_,
                   GObject* obj,
                   GAsyncResult* async_res);
static void ___lambda234__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
VALA_EXTERN TubaInstanceAccount* tuba_account_store_create_account (TubaAccountStore* self,
                                                        JsonNode* node,
                                                        GError** error);
VALA_EXTERN TubaSecretAccountStore* tuba_secret_account_store_new (void);
VALA_EXTERN TubaSecretAccountStore* tuba_secret_account_store_construct (GType object_type);
VALA_EXTERN TubaAccountStore* tuba_account_store_construct (GType object_type);
static void tuba_secret_account_store_finalize (GObject * obj);
static GType tuba_secret_account_store_get_type_once (void);

static inline gpointer
tuba_secret_account_store_get_instance_private (TubaSecretAccountStore* self)
{
	return G_STRUCT_MEMBER_P (self, TubaSecretAccountStore_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
tuba_secret_account_store_real_init (TubaAccountStore* base,
                                     GError** error)
{
	TubaSecretAccountStore * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GHashFunc _tmp8_;
	GEqualFunc _tmp9_;
	GHashTable* _tmp10_;
	GHashTable* _tmp11_;
	gchar* _tmp12_;
	GHashTable* _tmp13_;
	gchar* _tmp14_;
	GHashTable* _tmp15_;
	SecretSchema* _tmp16_;
	GError* _inner_error0_ = NULL;
	self = (TubaSecretAccountStore*) base;
	_tmp0_ = g_strdup_printf ("%i", SECRET_MAJOR_VERSION);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%i", SECRET_MINOR_VERSION);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%i", SECRET_MICRO_VERSION);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("Using libsecret v", _tmp1_, ".", _tmp3_, ".", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	g_debug ("SecretAccountStore.vala:9: %s", _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp8_ = g_str_hash;
	_tmp9_ = g_str_equal;
	_tmp10_ = g_hash_table_new_full (_tmp8_, _tmp9_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->schema_attributes);
	self->priv->schema_attributes = _tmp10_;
	_tmp11_ = self->priv->schema_attributes;
	_tmp12_ = g_strdup ("login");
	g_hash_table_insert (_tmp11_, _tmp12_, (gpointer) ((gintptr) SECRET_SCHEMA_ATTRIBUTE_STRING));
	_tmp13_ = self->priv->schema_attributes;
	_tmp14_ = g_strdup ("version");
	g_hash_table_insert (_tmp13_, _tmp14_, (gpointer) ((gintptr) SECRET_SCHEMA_ATTRIBUTE_STRING));
	_tmp15_ = self->priv->schema_attributes;
	_tmp16_ = secret_schema_newv (BUILD_DOMAIN, SECRET_SCHEMA_DONT_MATCH_NAME, _tmp15_);
	_secret_schema_unref0 (self->priv->schema);
	self->priv->schema = _tmp16_;
	TUBA_ACCOUNT_STORE_CLASS (tuba_secret_account_store_parent_class)->init (G_TYPE_CHECK_INSTANCE_CAST (self, TUBA_TYPE_ACCOUNT_STORE, TubaAccountStore), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static Block41Data*
block41_data_ref (Block41Data* _data41_)
{
	g_atomic_int_inc (&_data41_->_ref_count_);
	return _data41_;
}

static void
block41_data_unref (void * _userdata_)
{
	Block41Data* _data41_;
	_data41_ = (Block41Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data41_->_ref_count_)) {
		TubaSecretAccountStore* self;
		self = _data41_->self;
		_g_free0 (_data41_->wiki_page);
		_g_object_unref0 (self);
		g_slice_free (Block41Data, _data41_);
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
___lambda231_ (Block41Data* _data41_,
               GObject* obj,
               GAsyncResult* res)
{
	TubaSecretAccountStore* self;
	TubaApplication* _tmp0_;
	self = _data41_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = tuba_app;
	if (tuba_application_question_answer_truthy (tuba_application_question_finish (_tmp0_, res))) {
		const gchar* _tmp1_;
		_tmp1_ = _data41_->wiki_page;
		tuba_host_open_uri (_tmp1_);
	}
	exit (1);
}

static void
____lambda231__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda231_ (self, source_object, res);
	block41_data_unref (self);
}

static Block42Data*
block42_data_ref (Block42Data* _data42_)
{
	g_atomic_int_inc (&_data42_->_ref_count_);
	return _data42_;
}

static void
block42_data_unref (void * _userdata_)
{
	Block42Data* _data42_;
	_data42_ = (Block42Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data42_->_ref_count_)) {
		TubaSecretAccountStore* self;
		self = _data42_->self;
		_g_object_unref0 (_data42_->account);
		_g_object_unref0 (self);
		g_slice_free (Block42Data, _data42_);
	}
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

static void
___lambda233_ (Block42Data* _data42_,
               GInputStream* in_stream,
               GError** error)
{
	TubaSecretAccountStore* self;
	JsonParser* parser = NULL;
	JsonParser* _tmp0_;
	JsonNode* node = NULL;
	TubaNetwork* _tmp1_;
	JsonParser* _tmp2_;
	JsonNode* _tmp3_;
	TubaAPIAccount* acc = NULL;
	JsonNode* _tmp4_;
	TubaAPIAccount* _tmp5_;
	gboolean _tmp6_ = FALSE;
	TubaInstanceAccount* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	TubaAPIAccount* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GError* _inner_error0_ = NULL;
	self = _data42_->self;
	g_return_if_fail (in_stream != NULL);
	_tmp0_ = tuba_network_get_parser_from_inputstream (in_stream, &_inner_error0_);
	parser = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp1_ = tuba_network;
	_tmp2_ = parser;
	_tmp3_ = tuba_network_parse_node (_tmp1_, _tmp2_);
	node = _tmp3_;
	_tmp4_ = node;
	_tmp5_ = tuba_api_account_from (_tmp4_, &_inner_error0_);
	acc = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		__vala_JsonNode_free0 (node);
		_g_object_unref0 (parser);
		return;
	}
	_tmp7_ = _data42_->account;
	_tmp8_ = tuba_api_account_get_display_name ((TubaAPIAccount*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = acc;
	_tmp11_ = tuba_api_account_get_display_name (_tmp10_);
	_tmp12_ = _tmp11_;
	if (g_strcmp0 (_tmp9_, _tmp12_) != 0) {
		_tmp6_ = TRUE;
	} else {
		TubaInstanceAccount* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		TubaAPIAccount* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp13_ = _data42_->account;
		_tmp14_ = tuba_api_account_get_avatar ((TubaAPIAccount*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = acc;
		_tmp17_ = tuba_api_account_get_avatar (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp6_ = g_strcmp0 (_tmp15_, _tmp18_) != 0;
	}
	if (_tmp6_) {
		TubaInstanceAccount* _tmp19_;
		TubaAPIAccount* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		TubaInstanceAccount* _tmp23_;
		TubaAPIAccount* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		TubaInstanceAccount* _tmp27_;
		_tmp19_ = _data42_->account;
		_tmp20_ = acc;
		_tmp21_ = tuba_api_account_get_display_name (_tmp20_);
		_tmp22_ = _tmp21_;
		tuba_api_account_set_display_name ((TubaAPIAccount*) _tmp19_, _tmp22_);
		_tmp23_ = _data42_->account;
		_tmp24_ = acc;
		_tmp25_ = tuba_api_account_get_avatar (_tmp24_);
		_tmp26_ = _tmp25_;
		tuba_api_account_set_avatar ((TubaAPIAccount*) _tmp23_, _tmp26_);
		_tmp27_ = _data42_->account;
		tuba_secret_account_store_account_to_secret (self, _tmp27_);
	}
	_g_object_unref0 (acc);
	__vala_JsonNode_free0 (node);
	_g_object_unref0 (parser);
}

static void
____lambda233__tuba_network_success_callback (GInputStream* in_stream,
                                              SoupMessageHeaders* response_headers,
                                              gpointer self,
                                              GError** error)
{
	___lambda233_ (self, in_stream, error);
}

static void
__lambda232_ (TubaSecretAccountStore* self,
              SecretRetrievable* item)
{
	Block42Data* _data42_;
	gboolean force_save = FALSE;
	gboolean _tmp0_ = FALSE;
	TubaInstanceAccount* _tmp1_;
	gboolean _tmp2_ = FALSE;
	TubaInstanceAccount* _tmp3_;
	g_return_if_fail (item != NULL);
	_data42_ = g_slice_new0 (Block42Data);
	_data42_->_ref_count_ = 1;
	_data42_->self = g_object_ref (self);
	force_save = FALSE;
	_tmp1_ = tuba_secret_account_store_secret_to_account (self, item, &_tmp0_);
	force_save = _tmp0_;
	_data42_->account = _tmp1_;
	_tmp3_ = _data42_->account;
	if (_tmp3_ != NULL) {
		TubaInstanceAccount* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = _data42_->account;
		_tmp5_ = tuba_api_account_get_id ((TubaAPIAccount*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = g_strcmp0 (_tmp6_, "") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		TubaInstanceAccount* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		TubaRequest* _tmp13_;
		TubaRequest* _tmp14_;
		TubaInstanceAccount* _tmp15_;
		TubaRequest* _tmp16_;
		TubaRequest* _tmp17_;
		TubaRequest* _tmp18_;
		TubaRequest* _tmp19_;
		TubaRequest* _tmp20_;
		TubaRequest* _tmp21_;
		GeeArrayList* _tmp22_;
		GeeArrayList* _tmp23_;
		TubaInstanceAccount* _tmp24_;
		TubaInstanceAccount* _tmp25_;
		_tmp7_ = _data42_->account;
		_tmp8_ = tuba_api_account_get_id ((TubaAPIAccount*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = string_to_string (_tmp9_);
		_tmp11_ = g_strconcat ("/api/v1/accounts/", _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = tuba_request_new_GET (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _data42_->account;
		_tmp16_ = tuba_request_with_account (_tmp14_, _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = tuba_request_then (_tmp17_, ____lambda233__tuba_network_success_callback, block42_data_ref (_data42_), block42_data_unref);
		_tmp19_ = _tmp18_;
		_tmp20_ = tuba_request_exec (_tmp19_);
		_tmp21_ = _tmp20_;
		_g_object_unref0 (_tmp21_);
		_g_object_unref0 (_tmp19_);
		_g_object_unref0 (_tmp17_);
		_g_object_unref0 (_tmp14_);
		_g_free0 (_tmp12_);
		_tmp22_ = tuba_account_store_get_saved ((TubaAccountStore*) self);
		_tmp23_ = _tmp22_;
		_tmp24_ = _data42_->account;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp24_);
		_tmp25_ = _data42_->account;
		g_signal_emit_by_name (_tmp25_, "added");
		if (force_save) {
			tuba_account_store_safe_save ((TubaAccountStore*) self);
		}
	}
	block42_data_unref (_data42_);
	_data42_ = NULL;
}

static void
___lambda232__gfunc (gconstpointer data,
                     gpointer self)
{
	__lambda232_ ((TubaSecretAccountStore*) self, (SecretRetrievable*) data);
}

static void
tuba_secret_account_store_real_load (TubaAccountStore* base,
                                     GError** error)
{
	TubaSecretAccountStore * self;
	GHashTable* attrs = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GList* secrets = NULL;
	GList* _tmp43_;
	GeeArrayList* _tmp44_;
	GeeArrayList* _tmp45_;
	GeeArrayList* _tmp46_;
	GeeArrayList* _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	GError* _inner_error0_ = NULL;
	self = (TubaSecretAccountStore*) base;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	attrs = _tmp2_;
	_tmp3_ = g_strdup ("version");
	_tmp4_ = g_strdup (TUBA_SECRET_ACCOUNT_STORE_VERSION);
	g_hash_table_insert (attrs, _tmp3_, _tmp4_);
	secrets = NULL;
	{
		GList* _tmp5_ = NULL;
		SecretSchema* _tmp6_;
		GList* _tmp7_;
		GList* _tmp8_;
		_tmp6_ = self->priv->schema;
		_tmp7_ = secret_password_searchv_sync (_tmp6_, attrs, SECRET_SEARCH_ALL | SECRET_SEARCH_UNLOCK, NULL, &_inner_error0_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		(secrets == NULL) ? NULL : (secrets = (_g_list_free__g_object_unref0_ (secrets), NULL));
		secrets = _tmp8_;
		(_tmp5_ == NULL) ? NULL : (_tmp5_ = (_g_list_free__g_object_unref0_ (_tmp5_), NULL));
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		Block41Data* _data41_;
		gchar* _tmp9_;
		gchar* help_msg = NULL;
		gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		GError* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		TubaDialogsNewAccount* _tmp30_;
		TubaDialogsNewAccount* _tmp31_;
		TubaApplication* _tmp32_;
		TubaApplicationQuestionText _tmp33_ = {0};
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		TubaApplicationQuestionText _tmp38_ = {0};
		TubaApplication* _tmp39_;
		TubaDialogsNewAccount* _tmp40_;
		TubaDialogsNewAccount* _tmp41_;
		TubaApplicationQuestionButtons _tmp42_ = {0};
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_data41_ = g_slice_new0 (Block41Data);
		_data41_->_ref_count_ = 1;
		_data41_->self = g_object_ref (self);
		_tmp9_ = g_strdup ("https://github.com/GeopJr/Tuba/wiki/keyring-issues");
		_data41_->wiki_page = _tmp9_;
		_tmp10_ = g_strdup ("If you didn’t manually cancel it, try creating a password keyring name" \
"d \"login\" using Passwords and Keys (seahorse) or KWalletManager");
		help_msg = _tmp10_;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		if (g_strcmp0 (_tmp12_, "org.freedesktop.DBus.Error.ServiceUnknown") == 0) {
			gchar* _tmp13_;
			GError* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp13_ = g_strdup ("https://github.com/GeopJr/Tuba/wiki/libsecret-issues");
			_g_free0 (_data41_->wiki_page);
			_data41_->wiki_page = _tmp13_;
			_tmp14_ = e;
			_tmp15_ = _tmp14_->message;
			_tmp16_ = string_to_string (_tmp15_);
			_tmp17_ = string_to_string (BUILD_NAME);
			_tmp18_ = g_strconcat (_tmp16_, ", ", _tmp17_, " might be missing some permissions", NULL);
			_g_free0 (help_msg);
			help_msg = _tmp18_;
		}
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		_tmp21_ = string_to_string (_tmp20_);
		_tmp22_ = g_strconcat ("Error while searching for items in the secret service: ", _tmp21_, NULL);
		_tmp23_ = _tmp22_;
		g_critical ("SecretAccountStore.vala:46: %s", _tmp23_);
		_g_free0 (_tmp23_);
		_tmp24_ = help_msg;
		_tmp25_ = string_to_string (_tmp24_);
		_tmp26_ = _data41_->wiki_page;
		_tmp27_ = string_to_string (_tmp26_);
		_tmp28_ = g_strconcat (_tmp25_, "\nread more: ", _tmp27_, NULL);
		_tmp29_ = _tmp28_;
		g_warning ("SecretAccountStore.vala:47: %s", _tmp29_);
		_g_free0 (_tmp29_);
		_tmp30_ = tuba_dialogs_new_account_new ();
		g_object_ref_sink (_tmp30_);
		_tmp31_ = _tmp30_;
		_g_object_unref0 (_tmp31_);
		_tmp32_ = tuba_app;
		_g_free0 (_tmp33_.text);
		_tmp33_.text = "Error while searching for user accounts";
		_tmp33_.use_markup = FALSE;
		_tmp34_ = help_msg;
		_tmp35_ = string_to_string (_tmp34_);
		_tmp36_ = g_strconcat (_tmp35_, ".", NULL);
		_tmp37_ = _tmp36_;
		_g_free0 (_tmp38_.text);
		_tmp38_.text = _tmp37_;
		_tmp38_.use_markup = FALSE;
		_tmp39_ = tuba_app;
		_tmp40_ = tuba_application_get_add_account_window (_tmp39_);
		_tmp41_ = _tmp40_;
		tuba_application_question_button_destroy (&_tmp42_.yes);
		_tmp42_.yes = (TubaApplicationQuestionButton) {"Read More", ADW_RESPONSE_SUGGESTED};
		tuba_application_question_button_destroy (&_tmp42_.no);
		_tmp42_.no = (TubaApplicationQuestionButton) {"Close", ADW_RESPONSE_DEFAULT};
		tuba_application_question (_tmp32_, &_tmp33_, &_tmp38_, (GtkWidget*) _tmp41_, &_tmp42_, FALSE, ____lambda231__gasync_ready_callback, block41_data_ref (_data41_));
		_g_free0 (_tmp37_);
		_g_free0 (help_msg);
		_g_error_free0 (e);
		block41_data_unref (_data41_);
		_data41_ = NULL;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		(secrets == NULL) ? NULL : (secrets = (_g_list_free__g_object_unref0_ (secrets), NULL));
		_g_hash_table_unref0 (attrs);
		return;
	}
	_tmp43_ = secrets;
	g_list_foreach (_tmp43_, ___lambda232__gfunc, self);
	_tmp44_ = tuba_account_store_get_saved ((TubaAccountStore*) self);
	_tmp45_ = _tmp44_;
	g_signal_emit_by_name ((TubaAccountStore*) self, "changed", _tmp45_);
	_tmp46_ = tuba_account_store_get_saved ((TubaAccountStore*) self);
	_tmp47_ = _tmp46_;
	_tmp48_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = g_strdup_printf ("%i", _tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = g_strconcat ("Loaded ", _tmp51_, " accounts", NULL);
	_tmp53_ = _tmp52_;
	g_debug ("SecretAccountStore.vala:92: %s", _tmp53_);
	_g_free0 (_tmp53_);
	_g_free0 (_tmp51_);
	(secrets == NULL) ? NULL : (secrets = (_g_list_free__g_object_unref0_ (secrets), NULL));
	_g_hash_table_unref0 (attrs);
}

static gboolean
__lambda235_ (TubaSecretAccountStore* self,
              TubaInstanceAccount* account)
{
	gboolean result;
	g_return_val_if_fail (account != NULL, FALSE);
	tuba_secret_account_store_account_to_secret (self, account);
	result = TRUE;
	_g_object_unref0 (account);
	return result;
}

static gboolean
___lambda235__gee_forall_func (gpointer g,
                               gpointer self)
{
	gboolean result;
	result = __lambda235_ ((TubaSecretAccountStore*) self, (TubaInstanceAccount*) g);
	return result;
}

static void
tuba_secret_account_store_real_save (TubaAccountStore* base,
                                     GError** error)
{
	TubaSecretAccountStore * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	self = (TubaSecretAccountStore*) base;
	_tmp0_ = tuba_account_store_get_saved ((TubaAccountStore*) self);
	_tmp1_ = _tmp0_;
	gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp1_, ___lambda235__gee_forall_func, self);
	_tmp2_ = tuba_account_store_get_saved ((TubaAccountStore*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%i", _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat ("Saved ", _tmp7_, " accounts", NULL);
	_tmp9_ = _tmp8_;
	g_debug ("SecretAccountStore.vala:100: %s", _tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static void
__lambda236_ (TubaSecretAccountStore* self,
              GObject* obj,
              GAsyncResult* async_res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (async_res != NULL);
	{
		secret_password_clear_finish (async_res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		AdwAlertDialog* dlg = NULL;
		TubaApplication* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		AdwAlertDialog* _tmp5_;
		AdwAlertDialog* _tmp6_;
		TubaApplication* _tmp7_;
		TubaDialogsMainWindow* _tmp8_;
		TubaDialogsMainWindow* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("SecretAccountStore.vala:119: %s", _tmp1_);
		_tmp2_ = tuba_app;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		_tmp5_ = tuba_application_inform (_tmp2_, _ ("Error"), _tmp4_);
		dlg = _tmp5_;
		_tmp6_ = dlg;
		_tmp7_ = tuba_app;
		_tmp8_ = tuba_application_get_main_window (_tmp7_);
		_tmp9_ = _tmp8_;
		adw_dialog_present ((AdwDialog*) _tmp6_, (GtkWidget*) _tmp9_);
		_g_object_unref0 (dlg);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda236__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda236_ ((TubaSecretAccountStore*) self, source_object, res);
	g_object_unref (self);
}

static void
tuba_secret_account_store_real_remove (TubaAccountStore* base,
                                       TubaInstanceAccount* account,
                                       GError** error)
{
	TubaSecretAccountStore * self;
	GHashTable* attrs = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GHashTable* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	SecretSchema* _tmp10_;
	GHashTable* _tmp11_;
	GHashTable* _tmp12_;
	GError* _inner_error0_ = NULL;
	self = (TubaSecretAccountStore*) base;
	g_return_if_fail (account != NULL);
	TUBA_ACCOUNT_STORE_CLASS (tuba_secret_account_store_parent_class)->remove (G_TYPE_CHECK_INSTANCE_CAST (self, TUBA_TYPE_ACCOUNT_STORE, TubaAccountStore), account, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	attrs = _tmp2_;
	_tmp3_ = attrs;
	_tmp4_ = g_strdup ("version");
	_tmp5_ = g_strdup (TUBA_SECRET_ACCOUNT_STORE_VERSION);
	g_hash_table_insert (_tmp3_, _tmp4_, _tmp5_);
	_tmp6_ = attrs;
	_tmp7_ = g_strdup ("login");
	_tmp8_ = tuba_instance_account_get_handle (account);
	_tmp9_ = _tmp8_;
	g_hash_table_insert (_tmp6_, _tmp7_, _tmp9_);
	_tmp10_ = self->priv->schema;
	_tmp11_ = attrs;
	_tmp12_ = _g_hash_table_ref0 (_tmp11_);
	secret_password_clearv (_tmp10_, _tmp12_, NULL, ___lambda236__gasync_ready_callback, g_object_ref (self));
	_g_hash_table_unref0 (attrs);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block43Data*
block43_data_ref (Block43Data* _data43_)
{
	g_atomic_int_inc (&_data43_->_ref_count_);
	return _data43_;
}

static void
block43_data_unref (void * _userdata_)
{
	Block43Data* _data43_;
	_data43_ = (Block43Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data43_->_ref_count_)) {
		TubaSecretAccountStore* self;
		self = _data43_->self;
		_g_object_unref0 (_data43_->account);
		_g_object_unref0 (self);
		g_slice_free (Block43Data, _data43_);
	}
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

static void
__lambda234_ (Block43Data* _data43_,
              GObject* obj,
              GAsyncResult* async_res)
{
	TubaSecretAccountStore* self;
	GError* _inner_error0_ = NULL;
	self = _data43_->self;
	g_return_if_fail (async_res != NULL);
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		secret_password_store_finish (async_res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp0_ = tuba_instance_account_get_handle (_data43_->account);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = g_strconcat ("Saved secret for ", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		g_debug ("SecretAccountStore.vala:217: %s", _tmp5_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		AdwAlertDialog* dlg = NULL;
		TubaApplication* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		AdwAlertDialog* _tmp11_;
		AdwAlertDialog* _tmp12_;
		TubaApplication* _tmp13_;
		TubaDialogsMainWindow* _tmp14_;
		TubaDialogsMainWindow* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("SecretAccountStore.vala:220: %s", _tmp7_);
		_tmp8_ = tuba_app;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		_tmp11_ = tuba_application_inform (_tmp8_, _ ("Error"), _tmp10_);
		dlg = _tmp11_;
		_tmp12_ = dlg;
		_tmp13_ = tuba_app;
		_tmp14_ = tuba_application_get_main_window (_tmp13_);
		_tmp15_ = _tmp14_;
		adw_dialog_present ((AdwDialog*) _tmp12_, (GtkWidget*) _tmp15_);
		_g_object_unref0 (dlg);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda234__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda234_ (self, source_object, res);
	block43_data_unref (self);
}

static void
tuba_secret_account_store_account_to_secret (TubaSecretAccountStore* self,
                                             TubaInstanceAccount* account)
{
	Block43Data* _data43_;
	TubaInstanceAccount* _tmp0_;
	GHashTable* attrs = NULL;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GHashTable* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	JsonGenerator* generator = NULL;
	JsonGenerator* _tmp11_;
	JsonBuilder* builder = NULL;
	JsonBuilder* _tmp12_;
	JsonBuilder* _tmp13_;
	JsonBuilder* _tmp14_;
	JsonBuilder* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	JsonBuilder* _tmp18_;
	JsonBuilder* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	JsonBuilder* _tmp22_;
	JsonBuilder* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	JsonBuilder* _tmp26_;
	JsonBuilder* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	JsonBuilder* _tmp30_;
	JsonBuilder* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	JsonBuilder* _tmp34_;
	JsonBuilder* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	JsonBuilder* _tmp38_;
	JsonBuilder* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	JsonBuilder* _tmp42_;
	JsonBuilder* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	JsonBuilder* _tmp46_;
	JsonBuilder* _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	JsonBuilder* _tmp50_;
	JsonBuilder* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	JsonBuilder* _tmp54_;
	JsonBuilder* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	JsonBuilder* _tmp58_;
	JsonBuilder* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	JsonBuilder* _tmp63_;
	JsonBuilder* _tmp64_;
	const gchar* _tmp65_;
	const gchar* _tmp66_;
	JsonBuilder* _tmp67_;
	JsonBuilder* _tmp68_;
	const gchar* _tmp69_;
	const gchar* _tmp70_;
	JsonBuilder* _tmp71_;
	JsonBuilder* _tmp72_;
	GeeArrayList* _tmp73_ = NULL;
	GeeArrayList* _tmp74_;
	GeeArrayList* _tmp75_;
	gint* _tmp76_ = NULL;
	JsonBuilder* _tmp101_;
	JsonBuilder* _tmp102_;
	JsonGenerator* _tmp103_;
	JsonBuilder* _tmp104_;
	JsonNode* _tmp105_;
	JsonNode* _tmp106_;
	gchar* secret = NULL;
	JsonGenerator* _tmp107_;
	gchar* _tmp108_;
	gchar* label = NULL;
	const gchar* _tmp109_;
	const gchar* _tmp110_;
	gchar* _tmp111_;
	SecretSchema* _tmp112_;
	GHashTable* _tmp113_;
	GHashTable* _tmp114_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (account != NULL);
	_data43_ = g_slice_new0 (Block43Data);
	_data43_->_ref_count_ = 1;
	_data43_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (account);
	_g_object_unref0 (_data43_->account);
	_data43_->account = _tmp0_;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_free0_);
	attrs = _tmp3_;
	_tmp4_ = attrs;
	_tmp5_ = g_strdup ("login");
	_tmp6_ = tuba_instance_account_get_handle (_data43_->account);
	_tmp7_ = _tmp6_;
	g_hash_table_insert (_tmp4_, _tmp5_, _tmp7_);
	_tmp8_ = attrs;
	_tmp9_ = g_strdup ("version");
	_tmp10_ = g_strdup (TUBA_SECRET_ACCOUNT_STORE_VERSION);
	g_hash_table_insert (_tmp8_, _tmp9_, _tmp10_);
	_tmp11_ = json_generator_new ();
	generator = _tmp11_;
	_tmp12_ = json_builder_new ();
	builder = _tmp12_;
	_tmp13_ = builder;
	json_builder_begin_object (_tmp13_);
	_tmp14_ = builder;
	json_builder_set_member_name (_tmp14_, "id");
	_tmp15_ = builder;
	_tmp16_ = tuba_api_account_get_id ((TubaAPIAccount*) _data43_->account);
	_tmp17_ = _tmp16_;
	json_builder_add_string_value (_tmp15_, _tmp17_);
	_tmp18_ = builder;
	json_builder_set_member_name (_tmp18_, "username");
	_tmp19_ = builder;
	_tmp20_ = tuba_api_account_get_username ((TubaAPIAccount*) _data43_->account);
	_tmp21_ = _tmp20_;
	json_builder_add_string_value (_tmp19_, _tmp21_);
	_tmp22_ = builder;
	json_builder_set_member_name (_tmp22_, "display-name");
	_tmp23_ = builder;
	_tmp24_ = tuba_api_account_get_display_name ((TubaAPIAccount*) _data43_->account);
	_tmp25_ = _tmp24_;
	json_builder_add_string_value (_tmp23_, _tmp25_);
	_tmp26_ = builder;
	json_builder_set_member_name (_tmp26_, "acct");
	_tmp27_ = builder;
	_tmp28_ = tuba_api_account_get_acct ((TubaAPIAccount*) _data43_->account);
	_tmp29_ = _tmp28_;
	json_builder_add_string_value (_tmp27_, _tmp29_);
	_tmp30_ = builder;
	json_builder_set_member_name (_tmp30_, "header");
	_tmp31_ = builder;
	_tmp32_ = tuba_api_account_get_header ((TubaAPIAccount*) _data43_->account);
	_tmp33_ = _tmp32_;
	json_builder_add_string_value (_tmp31_, _tmp33_);
	_tmp34_ = builder;
	json_builder_set_member_name (_tmp34_, "avatar");
	_tmp35_ = builder;
	_tmp36_ = tuba_api_account_get_avatar ((TubaAPIAccount*) _data43_->account);
	_tmp37_ = _tmp36_;
	json_builder_add_string_value (_tmp35_, _tmp37_);
	_tmp38_ = builder;
	json_builder_set_member_name (_tmp38_, "url");
	_tmp39_ = builder;
	_tmp40_ = tuba_api_account_get_url ((TubaAPIAccount*) _data43_->account);
	_tmp41_ = _tmp40_;
	json_builder_add_string_value (_tmp39_, _tmp41_);
	_tmp42_ = builder;
	json_builder_set_member_name (_tmp42_, "instance");
	_tmp43_ = builder;
	_tmp44_ = tuba_instance_account_get_instance (_data43_->account);
	_tmp45_ = _tmp44_;
	json_builder_add_string_value (_tmp43_, _tmp45_);
	_tmp46_ = builder;
	json_builder_set_member_name (_tmp46_, "client-id");
	_tmp47_ = builder;
	_tmp48_ = tuba_instance_account_get_client_id (_data43_->account);
	_tmp49_ = _tmp48_;
	json_builder_add_string_value (_tmp47_, _tmp49_);
	_tmp50_ = builder;
	json_builder_set_member_name (_tmp50_, "client-secret");
	_tmp51_ = builder;
	_tmp52_ = tuba_instance_account_get_client_secret (_data43_->account);
	_tmp53_ = _tmp52_;
	json_builder_add_string_value (_tmp51_, _tmp53_);
	_tmp54_ = builder;
	json_builder_set_member_name (_tmp54_, "access-token");
	_tmp55_ = builder;
	_tmp56_ = tuba_instance_account_get_access_token (_data43_->account);
	_tmp57_ = _tmp56_;
	json_builder_add_string_value (_tmp55_, _tmp57_);
	_tmp58_ = builder;
	json_builder_set_member_name (_tmp58_, "handle");
	_tmp59_ = builder;
	_tmp60_ = tuba_instance_account_get_handle (_data43_->account);
	_tmp61_ = _tmp60_;
	_tmp62_ = _tmp61_;
	json_builder_add_string_value (_tmp59_, _tmp62_);
	_g_free0 (_tmp62_);
	_tmp63_ = builder;
	json_builder_set_member_name (_tmp63_, "backend");
	_tmp64_ = builder;
	_tmp65_ = tuba_instance_account_get_backend (_data43_->account);
	_tmp66_ = _tmp65_;
	json_builder_add_string_value (_tmp64_, _tmp66_);
	_tmp67_ = builder;
	json_builder_set_member_name (_tmp67_, "uuid");
	_tmp68_ = builder;
	_tmp69_ = tuba_instance_account_get_uuid (_data43_->account);
	_tmp70_ = _tmp69_;
	json_builder_add_string_value (_tmp68_, _tmp70_);
	_tmp71_ = builder;
	json_builder_set_member_name (_tmp71_, "emojis");
	_tmp72_ = builder;
	json_builder_begin_array (_tmp72_);
	_tmp74_ = tuba_api_account_get_emojis ((TubaAPIAccount*) _data43_->account);
	_tmp75_ = _tmp74_;
	_tmp73_ = _tmp75_;
	_tmp76_ = NULL;
	if (_tmp73_ != NULL) {
		gint _tmp77_;
		gint _tmp78_;
		gint* _tmp79_;
		_tmp77_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp73_);
		_tmp78_ = _tmp77_;
		_tmp79_ = __int_dup0 (&_tmp78_);
		_g_free0 (_tmp76_);
		_tmp76_ = _tmp79_;
	}
	if ((*_tmp76_) > 0) {
		{
			GeeArrayList* _emoji_list = NULL;
			GeeArrayList* _tmp80_;
			GeeArrayList* _tmp81_;
			gint _emoji_size = 0;
			GeeArrayList* _tmp82_;
			gint _tmp83_;
			gint _tmp84_;
			gint _emoji_index = 0;
			_tmp80_ = tuba_api_account_get_emojis ((TubaAPIAccount*) _data43_->account);
			_tmp81_ = _tmp80_;
			_emoji_list = _tmp81_;
			_tmp82_ = _emoji_list;
			_tmp83_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp82_);
			_tmp84_ = _tmp83_;
			_emoji_size = _tmp84_;
			_emoji_index = -1;
			while (TRUE) {
				gint _tmp85_;
				gint _tmp86_;
				TubaAPIEmoji* emoji = NULL;
				GeeArrayList* _tmp87_;
				gpointer _tmp88_;
				JsonBuilder* _tmp89_;
				JsonBuilder* _tmp90_;
				JsonBuilder* _tmp91_;
				TubaAPIEmoji* _tmp92_;
				const gchar* _tmp93_;
				const gchar* _tmp94_;
				JsonBuilder* _tmp95_;
				JsonBuilder* _tmp96_;
				TubaAPIEmoji* _tmp97_;
				const gchar* _tmp98_;
				const gchar* _tmp99_;
				JsonBuilder* _tmp100_;
				_emoji_index = _emoji_index + 1;
				_tmp85_ = _emoji_index;
				_tmp86_ = _emoji_size;
				if (!(_tmp85_ < _tmp86_)) {
					break;
				}
				_tmp87_ = _emoji_list;
				_tmp88_ = gee_abstract_list_get ((GeeAbstractList*) _tmp87_, _emoji_index);
				emoji = (TubaAPIEmoji*) _tmp88_;
				_tmp89_ = builder;
				json_builder_begin_object (_tmp89_);
				_tmp90_ = builder;
				json_builder_set_member_name (_tmp90_, "shortcode");
				_tmp91_ = builder;
				_tmp92_ = emoji;
				_tmp93_ = tuba_api_emoji_get_shortcode (_tmp92_);
				_tmp94_ = _tmp93_;
				json_builder_add_string_value (_tmp91_, _tmp94_);
				_tmp95_ = builder;
				json_builder_set_member_name (_tmp95_, "url");
				_tmp96_ = builder;
				_tmp97_ = emoji;
				_tmp98_ = tuba_api_emoji_get_url (_tmp97_);
				_tmp99_ = _tmp98_;
				json_builder_add_string_value (_tmp96_, _tmp99_);
				_tmp100_ = builder;
				json_builder_end_object (_tmp100_);
				_g_object_unref0 (emoji);
			}
		}
	}
	_tmp101_ = builder;
	json_builder_end_array (_tmp101_);
	_tmp102_ = builder;
	json_builder_end_object (_tmp102_);
	_tmp103_ = generator;
	_tmp104_ = builder;
	_tmp105_ = json_builder_get_root (_tmp104_);
	_tmp106_ = _tmp105_;
	json_generator_set_root (_tmp103_, _tmp106_);
	__vala_JsonNode_free0 (_tmp106_);
	_tmp107_ = generator;
	_tmp108_ = json_generator_to_data (_tmp107_, NULL);
	secret = _tmp108_;
	_tmp109_ = tuba_instance_account_get_backend (_data43_->account);
	_tmp110_ = _tmp109_;
	_tmp111_ = g_strdup_printf (_ ("%s Account"), _tmp110_);
	label = _tmp111_;
	_tmp112_ = self->priv->schema;
	_tmp113_ = attrs;
	_tmp114_ = _g_hash_table_ref0 (_tmp113_);
	secret_password_storev (_tmp112_, _tmp114_, SECRET_COLLECTION_DEFAULT, label, secret, NULL, ___lambda234__gasync_ready_callback, block43_data_ref (_data43_));
	_g_free0 (label);
	_g_free0 (secret);
	_g_free0 (_tmp76_);
	_g_object_unref0 (builder);
	_g_object_unref0 (generator);
	_g_hash_table_unref0 (attrs);
	block43_data_unref (_data43_);
	_data43_ = NULL;
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
	return g_boxed_copy (json_node_get_type (), self);
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
	return self ? _vala_JsonNode_copy (self) : NULL;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static TubaInstanceAccount*
tuba_secret_account_store_secret_to_account (TubaSecretAccountStore* self,
                                             SecretRetrievable* item,
                                             gboolean* force_save)
{
	gboolean _vala_force_save = FALSE;
	TubaInstanceAccount* account = NULL;
	GError* _inner_error0_ = NULL;
	TubaInstanceAccount* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	account = NULL;
	_vala_force_save = FALSE;
	{
		SecretValue* secret = NULL;
		SecretValue* _tmp0_;
		gchar* contents = NULL;
		SecretValue* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		JsonParser* parser = NULL;
		JsonParser* _tmp4_;
		JsonParser* _tmp5_;
		const gchar* _tmp6_;
		JsonNode* root = NULL;
		JsonParser* _tmp7_;
		JsonNode* _tmp8_;
		JsonNode* _tmp9_;
		JsonObject* root_obj = NULL;
		JsonNode* _tmp10_;
		JsonObject* _tmp11_;
		JsonObject* _tmp12_;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		JsonObject* _tmp18_;
		gboolean had_uuid = FALSE;
		JsonObject* _tmp24_;
		TubaInstanceAccount* _tmp25_ = NULL;
		TubaAccountStore* _tmp26_;
		JsonNode* _tmp27_;
		TubaInstanceAccount* _tmp28_;
		TubaInstanceAccount* _tmp29_;
		gboolean _tmp30_ = FALSE;
		_tmp0_ = secret_retrievable_retrieve_secret_sync (item, NULL, &_inner_error0_);
		secret = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = secret;
		_tmp2_ = secret_value_get_text (_tmp1_);
		_tmp3_ = g_strdup (_tmp2_);
		contents = _tmp3_;
		_tmp4_ = json_parser_new ();
		parser = _tmp4_;
		_tmp5_ = parser;
		_tmp6_ = contents;
		json_parser_load_from_data (_tmp5_, _tmp6_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (parser);
			_g_free0 (contents);
			_secret_value_unref0 (secret);
			goto __catch0_g_error;
		}
		_tmp7_ = parser;
		_tmp8_ = json_parser_get_root (_tmp7_);
		_tmp9_ = __vala_JsonNode_copy0 (_tmp8_);
		root = _tmp9_;
		_tmp10_ = root;
		_tmp11_ = json_node_get_object (_tmp10_);
		_tmp12_ = _json_object_ref0 (_tmp11_);
		root_obj = _tmp12_;
		_tmp18_ = root_obj;
		if (!json_object_has_member (_tmp18_, "backend")) {
			_tmp17_ = TRUE;
		} else {
			JsonObject* _tmp19_;
			_tmp19_ = root_obj;
			_tmp17_ = !json_object_has_member (_tmp19_, "acct");
		}
		if (_tmp17_) {
			_tmp16_ = TRUE;
		} else {
			JsonObject* _tmp20_;
			_tmp20_ = root_obj;
			_tmp16_ = !json_object_has_member (_tmp20_, "id");
		}
		if (_tmp16_) {
			_tmp15_ = TRUE;
		} else {
			JsonObject* _tmp21_;
			_tmp21_ = root_obj;
			_tmp15_ = !json_object_has_member (_tmp21_, "client-secret");
		}
		if (_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			JsonObject* _tmp22_;
			_tmp22_ = root_obj;
			_tmp14_ = !json_object_has_member (_tmp22_, "client-id");
		}
		if (_tmp14_) {
			_tmp13_ = TRUE;
		} else {
			JsonObject* _tmp23_;
			_tmp23_ = root_obj;
			_tmp13_ = !json_object_has_member (_tmp23_, "access-token");
		}
		if (_tmp13_) {
			result = NULL;
			_json_object_unref0 (root_obj);
			__vala_JsonNode_free0 (root);
			_g_object_unref0 (parser);
			_g_free0 (contents);
			_secret_value_unref0 (secret);
			_g_object_unref0 (account);
			if (force_save) {
				*force_save = _vala_force_save;
			}
			return result;
		}
		_tmp24_ = root_obj;
		had_uuid = json_object_has_member (_tmp24_, "uuid");
		_tmp26_ = tuba_accounts;
		_tmp27_ = root;
		_tmp28_ = tuba_account_store_create_account (_tmp26_, _tmp27_, &_inner_error0_);
		_tmp25_ = _tmp28_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_json_object_unref0 (root_obj);
			__vala_JsonNode_free0 (root);
			_g_object_unref0 (parser);
			_g_free0 (contents);
			_secret_value_unref0 (secret);
			goto __catch0_g_error;
		}
		_tmp29_ = _tmp25_;
		_tmp25_ = NULL;
		_g_object_unref0 (account);
		account = _tmp29_;
		if (!had_uuid) {
			TubaInstanceAccount* _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			_tmp31_ = account;
			_tmp32_ = tuba_instance_account_get_uuid (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp30_ = _tmp33_ != NULL;
		} else {
			_tmp30_ = FALSE;
		}
		_vala_force_save = _tmp30_;
		_g_object_unref0 (_tmp25_);
		_json_object_unref0 (root_obj);
		__vala_JsonNode_free0 (root);
		_g_object_unref0 (parser);
		_g_free0 (contents);
		_secret_value_unref0 (secret);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp34_;
		const gchar* _tmp35_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp34_ = e;
		_tmp35_ = _tmp34_->message;
		g_warning ("SecretAccountStore.vala:260: %s", _tmp35_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (account);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = account;
	if (force_save) {
		*force_save = _vala_force_save;
	}
	return result;
}

TubaSecretAccountStore*
tuba_secret_account_store_construct (GType object_type)
{
	TubaSecretAccountStore * self = NULL;
	self = (TubaSecretAccountStore*) tuba_account_store_construct (object_type);
	return self;
}

TubaSecretAccountStore*
tuba_secret_account_store_new (void)
{
	return tuba_secret_account_store_construct (TUBA_TYPE_SECRET_ACCOUNT_STORE);
}

static void
tuba_secret_account_store_class_init (TubaSecretAccountStoreClass * klass,
                                      gpointer klass_data)
{
	tuba_secret_account_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TubaSecretAccountStore_private_offset);
	((TubaAccountStoreClass *) klass)->init = (void (*) (TubaAccountStore*, GError**)) tuba_secret_account_store_real_init;
	((TubaAccountStoreClass *) klass)->load = (void (*) (TubaAccountStore*, GError**)) tuba_secret_account_store_real_load;
	((TubaAccountStoreClass *) klass)->save = (void (*) (TubaAccountStore*, GError**)) tuba_secret_account_store_real_save;
	((TubaAccountStoreClass *) klass)->remove = (void (*) (TubaAccountStore*, TubaInstanceAccount*, GError**)) tuba_secret_account_store_real_remove;
	G_OBJECT_CLASS (klass)->finalize = tuba_secret_account_store_finalize;
}

static void
tuba_secret_account_store_instance_init (TubaSecretAccountStore * self,
                                         gpointer klass)
{
	self->priv = tuba_secret_account_store_get_instance_private (self);
}

static void
tuba_secret_account_store_finalize (GObject * obj)
{
	TubaSecretAccountStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_TYPE_SECRET_ACCOUNT_STORE, TubaSecretAccountStore);
	_secret_schema_unref0 (self->priv->schema);
	_g_hash_table_unref0 (self->priv->schema_attributes);
	G_OBJECT_CLASS (tuba_secret_account_store_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
tuba_secret_account_store_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TubaSecretAccountStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tuba_secret_account_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TubaSecretAccountStore), 0, (GInstanceInitFunc) tuba_secret_account_store_instance_init, NULL };
	GType tuba_secret_account_store_type_id;
	tuba_secret_account_store_type_id = g_type_register_static (TUBA_TYPE_ACCOUNT_STORE, "TubaSecretAccountStore", &g_define_type_info, 0);
	TubaSecretAccountStore_private_offset = g_type_add_instance_private (tuba_secret_account_store_type_id, sizeof (TubaSecretAccountStorePrivate));
	return tuba_secret_account_store_type_id;
}

GType
tuba_secret_account_store_get_type (void)
{
	static gsize tuba_secret_account_store_type_id__once = 0;
	if (g_once_init_enter (&tuba_secret_account_store_type_id__once)) {
		GType tuba_secret_account_store_type_id;
		tuba_secret_account_store_type_id = tuba_secret_account_store_get_type_once ();
		g_once_init_leave (&tuba_secret_account_store_type_id__once, tuba_secret_account_store_type_id);
	}
	return tuba_secret_account_store_type_id__once;
}

