/* AccountStore.c generated by valac 0.56.17, the Vala compiler
 * generated from AccountStore.vala, do not modify */

#include <glib-object.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <adwaita.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <json-glib/json-glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TUBA_TYPE_ACCOUNT_STORE (tuba_account_store_get_type ())
#define TUBA_ACCOUNT_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_ACCOUNT_STORE, TubaAccountStore))
#define TUBA_ACCOUNT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_ACCOUNT_STORE, TubaAccountStoreClass))
#define TUBA_IS_ACCOUNT_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_ACCOUNT_STORE))
#define TUBA_IS_ACCOUNT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_ACCOUNT_STORE))
#define TUBA_ACCOUNT_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_ACCOUNT_STORE, TubaAccountStoreClass))

typedef struct _TubaAccountStore TubaAccountStore;
typedef struct _TubaAccountStoreClass TubaAccountStoreClass;
typedef struct _TubaAccountStorePrivate TubaAccountStorePrivate;

#define TUBA_TYPE_ENTITY (tuba_entity_get_type ())
#define TUBA_ENTITY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_ENTITY, TubaEntity))
#define TUBA_ENTITY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_ENTITY, TubaEntityClass))
#define TUBA_IS_ENTITY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_ENTITY))
#define TUBA_IS_ENTITY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_ENTITY))
#define TUBA_ENTITY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_ENTITY, TubaEntityClass))

typedef struct _TubaEntity TubaEntity;
typedef struct _TubaEntityClass TubaEntityClass;

#define TUBA_API_TYPE_ACCOUNT (tuba_api_account_get_type ())
#define TUBA_API_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_API_TYPE_ACCOUNT, TubaAPIAccount))
#define TUBA_API_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_API_TYPE_ACCOUNT, TubaAPIAccountClass))
#define TUBA_API_IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_API_TYPE_ACCOUNT))
#define TUBA_API_IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_API_TYPE_ACCOUNT))
#define TUBA_API_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_API_TYPE_ACCOUNT, TubaAPIAccountClass))

typedef struct _TubaAPIAccount TubaAPIAccount;
typedef struct _TubaAPIAccountClass TubaAPIAccountClass;

#define TUBA_TYPE_INSTANCE_ACCOUNT (tuba_instance_account_get_type ())
#define TUBA_INSTANCE_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_INSTANCE_ACCOUNT, TubaInstanceAccount))
#define TUBA_INSTANCE_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_INSTANCE_ACCOUNT, TubaInstanceAccountClass))
#define TUBA_IS_INSTANCE_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_INSTANCE_ACCOUNT))
#define TUBA_IS_INSTANCE_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_INSTANCE_ACCOUNT))
#define TUBA_INSTANCE_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_INSTANCE_ACCOUNT, TubaInstanceAccountClass))

typedef struct _TubaInstanceAccount TubaInstanceAccount;
typedef struct _TubaInstanceAccountClass TubaInstanceAccountClass;

#define TUBA_ACCOUNT_STORE_TYPE_BACKEND_TEST (tuba_account_store_backend_test_get_type ())
#define TUBA_ACCOUNT_STORE_BACKEND_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_ACCOUNT_STORE_TYPE_BACKEND_TEST, TubaAccountStoreBackendTest))
#define TUBA_ACCOUNT_STORE_BACKEND_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_ACCOUNT_STORE_TYPE_BACKEND_TEST, TubaAccountStoreBackendTestClass))
#define TUBA_ACCOUNT_STORE_IS_BACKEND_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_ACCOUNT_STORE_TYPE_BACKEND_TEST))
#define TUBA_ACCOUNT_STORE_IS_BACKEND_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_ACCOUNT_STORE_TYPE_BACKEND_TEST))
#define TUBA_ACCOUNT_STORE_BACKEND_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_ACCOUNT_STORE_TYPE_BACKEND_TEST, TubaAccountStoreBackendTestClass))

typedef struct _TubaAccountStoreBackendTest TubaAccountStoreBackendTest;
typedef struct _TubaAccountStoreBackendTestClass TubaAccountStoreBackendTestClass;
enum  {
	TUBA_ACCOUNT_STORE_0_PROPERTY,
	TUBA_ACCOUNT_STORE_SAVED_PROPERTY,
	TUBA_ACCOUNT_STORE_ACTIVE_PROPERTY,
	TUBA_ACCOUNT_STORE_NUM_PROPERTIES
};
static GParamSpec* tuba_account_store_properties[TUBA_ACCOUNT_STORE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TUBA_TYPE_SETTINGS (tuba_settings_get_type ())
#define TUBA_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_SETTINGS, TubaSettings))
#define TUBA_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_SETTINGS, TubaSettingsClass))
#define TUBA_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_SETTINGS))
#define TUBA_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_SETTINGS))
#define TUBA_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_SETTINGS, TubaSettingsClass))

typedef struct _TubaSettings TubaSettings;
typedef struct _TubaSettingsClass TubaSettingsClass;

#define TUBA_TYPE_APPLICATION (tuba_application_get_type ())
#define TUBA_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_APPLICATION, TubaApplication))
#define TUBA_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_APPLICATION, TubaApplicationClass))
#define TUBA_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_APPLICATION))
#define TUBA_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_APPLICATION))
#define TUBA_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_APPLICATION, TubaApplicationClass))

typedef struct _TubaApplication TubaApplication;
typedef struct _TubaApplicationClass TubaApplicationClass;

#define TUBA_DIALOGS_TYPE_MAIN_WINDOW (tuba_dialogs_main_window_get_type ())
#define TUBA_DIALOGS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_DIALOGS_TYPE_MAIN_WINDOW, TubaDialogsMainWindow))
#define TUBA_DIALOGS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_DIALOGS_TYPE_MAIN_WINDOW, TubaDialogsMainWindowClass))
#define TUBA_DIALOGS_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_DIALOGS_TYPE_MAIN_WINDOW))
#define TUBA_DIALOGS_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_DIALOGS_TYPE_MAIN_WINDOW))
#define TUBA_DIALOGS_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_DIALOGS_TYPE_MAIN_WINDOW, TubaDialogsMainWindowClass))

typedef struct _TubaDialogsMainWindow TubaDialogsMainWindow;
typedef struct _TubaDialogsMainWindowClass TubaDialogsMainWindowClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block36Data Block36Data;
typedef struct _Block37Data Block37Data;

#define TUBA_TYPE_NETWORK (tuba_network_get_type ())
#define TUBA_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_NETWORK, TubaNetwork))
#define TUBA_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_NETWORK, TubaNetworkClass))
#define TUBA_IS_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_NETWORK))
#define TUBA_IS_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_NETWORK))
#define TUBA_NETWORK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_NETWORK, TubaNetworkClass))

typedef struct _TubaNetwork TubaNetwork;
typedef struct _TubaNetworkClass TubaNetworkClass;

#define TUBA_API_TYPE_ACCOUNT_SOURCE (tuba_api_account_source_get_type ())
#define TUBA_API_ACCOUNT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_API_TYPE_ACCOUNT_SOURCE, TubaAPIAccountSource))
#define TUBA_API_ACCOUNT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_API_TYPE_ACCOUNT_SOURCE, TubaAPIAccountSourceClass))
#define TUBA_API_IS_ACCOUNT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_API_TYPE_ACCOUNT_SOURCE))
#define TUBA_API_IS_ACCOUNT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_API_TYPE_ACCOUNT_SOURCE))
#define TUBA_API_ACCOUNT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_API_TYPE_ACCOUNT_SOURCE, TubaAPIAccountSourceClass))

typedef struct _TubaAPIAccountSource TubaAPIAccountSource;
typedef struct _TubaAPIAccountSourceClass TubaAPIAccountSourceClass;

#define TUBA_TYPE_WIDGETIZABLE (tuba_widgetizable_get_type ())
#define TUBA_WIDGETIZABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_WIDGETIZABLE, TubaWidgetizable))
#define TUBA_IS_WIDGETIZABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_WIDGETIZABLE))
#define TUBA_WIDGETIZABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TUBA_TYPE_WIDGETIZABLE, TubaWidgetizableIface))

typedef struct _TubaWidgetizable TubaWidgetizable;
typedef struct _TubaWidgetizableIface TubaWidgetizableIface;

#define TUBA_TYPE_OOPSIE (tuba_oopsie_get_type ())
typedef struct _TubaEntityPrivate TubaEntityPrivate;
typedef struct _TubaAPIAccountPrivate TubaAPIAccountPrivate;

#define TUBA_TYPE_STREAMABLE (tuba_streamable_get_type ())
#define TUBA_STREAMABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_STREAMABLE, TubaStreamable))
#define TUBA_IS_STREAMABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_STREAMABLE))
#define TUBA_STREAMABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TUBA_TYPE_STREAMABLE, TubaStreamableIface))

typedef struct _TubaStreamable TubaStreamable;
typedef struct _TubaStreamableIface TubaStreamableIface;
typedef struct _TubaInstanceAccountPrivate TubaInstanceAccountPrivate;

#define TUBA_INSTANCE_ACCOUNT_TYPE_KIND (tuba_instance_account_kind_get_type ())
typedef struct _TubaInstanceAccountKind TubaInstanceAccountKind;

#define TUBA_STREAMABLE_TYPE_EVENT (tuba_streamable_event_get_type ())
typedef struct _TubaStreamableEvent TubaStreamableEvent;

#define TUBA_INSTANCE_ACCOUNT_TYPE_VISIBILITY (tuba_instance_account_visibility_get_type ())
#define TUBA_INSTANCE_ACCOUNT_VISIBILITY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_INSTANCE_ACCOUNT_TYPE_VISIBILITY, TubaInstanceAccountVisibility))
#define TUBA_INSTANCE_ACCOUNT_VISIBILITY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_INSTANCE_ACCOUNT_TYPE_VISIBILITY, TubaInstanceAccountVisibilityClass))
#define TUBA_INSTANCE_ACCOUNT_IS_VISIBILITY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_INSTANCE_ACCOUNT_TYPE_VISIBILITY))
#define TUBA_INSTANCE_ACCOUNT_IS_VISIBILITY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_INSTANCE_ACCOUNT_TYPE_VISIBILITY))
#define TUBA_INSTANCE_ACCOUNT_VISIBILITY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_INSTANCE_ACCOUNT_TYPE_VISIBILITY, TubaInstanceAccountVisibilityClass))

typedef struct _TubaInstanceAccountVisibility TubaInstanceAccountVisibility;
typedef struct _TubaInstanceAccountVisibilityClass TubaInstanceAccountVisibilityClass;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
typedef struct _Block38Data Block38Data;

#define TUBA_TYPE_REQUEST (tuba_request_get_type ())
#define TUBA_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_REQUEST, TubaRequest))
#define TUBA_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_REQUEST, TubaRequestClass))
#define TUBA_IS_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_REQUEST))
#define TUBA_IS_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_REQUEST))
#define TUBA_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_REQUEST, TubaRequestClass))

typedef struct _TubaRequest TubaRequest;
typedef struct _TubaRequestClass TubaRequestClass;
typedef struct _TubaAccountStoreGuessBackendData TubaAccountStoreGuessBackendData;
typedef struct _TubaAccountStoreBackendTestPrivate TubaAccountStoreBackendTestPrivate;
enum  {
	TUBA_ACCOUNT_STORE_BACKEND_TEST_0_PROPERTY,
	TUBA_ACCOUNT_STORE_BACKEND_TEST_NUM_PROPERTIES
};
static GParamSpec* tuba_account_store_backend_test_properties[TUBA_ACCOUNT_STORE_BACKEND_TEST_NUM_PROPERTIES];
enum  {
	TUBA_ACCOUNT_STORE_CHANGED_SIGNAL,
	TUBA_ACCOUNT_STORE_SWITCHED_SIGNAL,
	TUBA_ACCOUNT_STORE_CREATE_FOR_BACKEND_SIGNAL,
	TUBA_ACCOUNT_STORE_NUM_SIGNALS
};
static guint tuba_account_store_signals[TUBA_ACCOUNT_STORE_NUM_SIGNALS] = {0};

struct _TubaAccountStore {
	GObject parent_instance;
	TubaAccountStorePrivate * priv;
	GeeArrayList* backend_tests;
};

struct _TubaAccountStoreClass {
	GObjectClass parent_class;
	void (*init) (TubaAccountStore* self, GError** error);
	void (*load) (TubaAccountStore* self, GError** error);
	void (*save) (TubaAccountStore* self, GError** error);
	void (*add) (TubaAccountStore* self, TubaInstanceAccount* account, GError** error);
	void (*remove) (TubaAccountStore* self, TubaInstanceAccount* account, GError** error);
};

struct _TubaAccountStorePrivate {
	GeeArrayList* _saved;
	TubaInstanceAccount* _active;
};

struct _Block36Data {
	int _ref_count_;
	TubaAccountStore* self;
	gchar* uuid;
};

struct _Block37Data {
	int _ref_count_;
	TubaAccountStore* self;
	TubaInstanceAccount* account;
};

typedef enum  {
	TUBA_OOPSIE_USER,
	TUBA_OOPSIE_PARSING,
	TUBA_OOPSIE_INSTANCE,
	TUBA_OOPSIE_INTERNAL
} TubaOopsie;
#define TUBA_OOPSIE tuba_oopsie_quark ()

struct _TubaWidgetizableIface {
	GTypeInterface parent_iface;
	GtkWidget* (*to_widget) (TubaWidgetizable* self, GError** error);
	void (*open) (TubaWidgetizable* self);
	void (*resolve_open) (TubaWidgetizable* self, TubaInstanceAccount* account);
};

struct _TubaEntity {
	GObject parent_instance;
	TubaEntityPrivate * priv;
};

struct _TubaEntityClass {
	GObjectClass parent_class;
	gboolean (*is_local) (TubaEntity* self, TubaInstanceAccount* account);
	GType (*deserialize_array_type) (TubaEntity* self, const gchar* prop);
};

struct _TubaAPIAccount {
	TubaEntity parent_instance;
	TubaAPIAccountPrivate * priv;
};

struct _TubaAPIAccountClass {
	TubaEntityClass parent_class;
};

struct _TubaStreamableIface {
	GTypeInterface parent_iface;
	gchar* (*get_stream_url) (TubaStreamable* self);
	void (*on_streaming_policy_changed) (TubaStreamable* self);
	const gchar* (*get_t_connection_url) (TubaStreamable* self);
	void (*set_t_connection_url) (TubaStreamable* self, const gchar* value);
	gboolean (*get_subscribed) (TubaStreamable* self);
	void (*set_subscribed) (TubaStreamable* self, gboolean value);
};

struct _TubaInstanceAccountKind {
	gchar* icon;
	gchar* description;
	gchar* url;
};

struct _TubaStreamableEvent {
	gchar* type;
	JsonNode* payload;
};

struct _TubaInstanceAccount {
	TubaAPIAccount parent_instance;
	TubaInstanceAccountPrivate * priv;
	GListStore* known_places;
	GeeHashMap* type_overrides;
	GeeHashMap* visibility;
	GListStore* visibility_list;
	GListStore* supported_mime_types;
};

struct _TubaInstanceAccountClass {
	TubaAPIAccountClass parent_class;
	void (*describe_kind) (TubaInstanceAccount* self, const gchar* kind, TubaInstanceAccountKind* _result_, const gchar* actor_name, const gchar* callback_url);
	void (*register_known_places) (TubaInstanceAccount* self, GListStore* places);
	void (*check_notifications) (TubaInstanceAccount* self);
	gchar* (*get_stream_url) (TubaInstanceAccount* self);
	void (*on_notification_event) (TubaInstanceAccount* self, TubaStreamableEvent* ev);
	void (*open_status_url) (TubaInstanceAccount* self, const gchar* url);
	void (*answer_follow_request) (TubaInstanceAccount* self, const gchar* issuer_id, const gchar* fr_id, gboolean accept);
	void (*follow_back) (TubaInstanceAccount* self, const gchar* issuer_id, const gchar* acc_id);
	void (*reply_to_status_uri) (TubaInstanceAccount* self, const gchar* issuer_id, const gchar* uri);
	void (*remove_from_followers) (TubaInstanceAccount* self, const gchar* issuer_id, const gchar* acc_id);
	void (*activated) (TubaInstanceAccount* self);
	void (*deactivated) (TubaInstanceAccount* self);
	void (*added) (TubaInstanceAccount* self);
	void (*removed) (TubaInstanceAccount* self);
};

struct _Block38Data {
	int _ref_count_;
	TubaAccountStore* self;
	JsonObject* root;
	gchar* backend;
	gpointer _async_data_;
};

struct _TubaAccountStoreGuessBackendData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TubaAccountStore* self;
	TubaInstanceAccount* account;
	Block38Data* _data38_;
	TubaRequest* req;
	TubaRequest* _tmp0_;
	TubaRequest* _tmp1_;
	TubaRequest* _tmp2_;
	TubaRequest* _tmp3_;
	TubaRequest* _tmp4_;
	TubaRequest* _tmp5_;
	TubaRequest* _tmp6_;
	JsonParser* parser;
	TubaRequest* _tmp7_;
	GInputStream* _tmp8_;
	GInputStream* _tmp9_;
	JsonParser* _tmp10_;
	TubaNetwork* _tmp11_;
	JsonParser* _tmp12_;
	JsonObject* _tmp13_;
	GeeArrayList* _tmp14_;
	const gchar* _tmp15_;
	GError* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GError* _inner_error0_;
};

struct _TubaAccountStoreBackendTest {
	GObject parent_instance;
	TubaAccountStoreBackendTestPrivate * priv;
};

struct _TubaAccountStoreBackendTestClass {
	GObjectClass parent_class;
	gchar* (*get_backend) (TubaAccountStoreBackendTest* self, JsonObject* obj);
};

static gint TubaAccountStore_private_offset;
static gpointer tuba_account_store_parent_class = NULL;
VALA_EXTERN TubaSettings* tuba_settings;
VALA_EXTERN TubaApplication* tuba_app;
VALA_EXTERN TubaNetwork* tuba_network;
VALA_EXTERN TubaAccountStore* tuba_accounts;
static gpointer tuba_account_store_backend_test_parent_class = NULL;

VALA_EXTERN GType tuba_account_store_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaAccountStore, g_object_unref)
VALA_EXTERN GType tuba_entity_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaEntity, g_object_unref)
VALA_EXTERN GType tuba_api_account_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaAPIAccount, g_object_unref)
VALA_EXTERN GType tuba_instance_account_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaInstanceAccount, g_object_unref)
VALA_EXTERN GType tuba_account_store_backend_test_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaAccountStoreBackendTest, g_object_unref)
VALA_EXTERN void tuba_account_store_init (TubaAccountStore* self,
                              GError** error);
VALA_EXTERN void tuba_account_store_load (TubaAccountStore* self,
                              GError** error);
VALA_EXTERN void tuba_account_store_save (TubaAccountStore* self,
                              GError** error);
VALA_EXTERN void tuba_account_store_add (TubaAccountStore* self,
                             TubaInstanceAccount* account,
                             GError** error);
VALA_EXTERN void tuba_account_store_remove (TubaAccountStore* self,
                                TubaInstanceAccount* account,
                                GError** error);
VALA_EXTERN gboolean tuba_account_store_ensure_active_account (TubaAccountStore* self);
VALA_EXTERN TubaInstanceAccount* tuba_account_store_find_by_uuid (TubaAccountStore* self,
                                                      const gchar* uuid);
VALA_EXTERN GType tuba_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaSettings, g_object_unref)
VALA_EXTERN const gchar* tuba_settings_get_active_account (TubaSettings* self);
VALA_EXTERN GeeArrayList* tuba_account_store_get_saved (TubaAccountStore* self);
VALA_EXTERN void tuba_account_store_activate (TubaAccountStore* self,
                                  TubaInstanceAccount* account,
                                  gboolean clear_cache);
VALA_EXTERN GType tuba_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaApplication, g_object_unref)
VALA_EXTERN void tuba_application_present_window (TubaApplication* self,
                                      gboolean destroy_main);
static void tuba_account_store_real_init (TubaAccountStore* self,
                                   GError** error);
VALA_EXTERN void tuba_mastodon_account_register (TubaAccountStore* store);
static void tuba_account_store_real_load (TubaAccountStore* self,
                                   GError** error);
static void tuba_account_store_real_save (TubaAccountStore* self,
                                   GError** error);
VALA_EXTERN void tuba_account_store_safe_save (TubaAccountStore* self);
VALA_EXTERN AdwAlertDialog* tuba_application_inform (TubaApplication* self,
                                         const gchar* text,
                                         const gchar* msg);
VALA_EXTERN GType tuba_dialogs_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaDialogsMainWindow, g_object_unref)
VALA_EXTERN TubaDialogsMainWindow* tuba_application_get_main_window (TubaApplication* self);
static void tuba_account_store_real_add (TubaAccountStore* self,
                                  TubaInstanceAccount* account,
                                  GError** error);
VALA_EXTERN gchar* tuba_instance_account_get_handle (TubaInstanceAccount* self);
static void tuba_account_store_real_remove (TubaAccountStore* self,
                                     TubaInstanceAccount* account,
                                     GError** error);
static Block36Data* block36_data_ref (Block36Data* _data36_);
static void block36_data_unref (void * _userdata_);
static gboolean __lambda178_ (Block36Data* _data36_,
                       TubaInstanceAccount* acc);
VALA_EXTERN const gchar* tuba_instance_account_get_uuid (TubaInstanceAccount* self);
static gboolean ___lambda178__gee_predicate (gconstpointer g,
                                      gpointer self);
static Block37Data* block37_data_ref (Block37Data* _data37_);
static void block37_data_unref (void * _userdata_);
VALA_EXTERN TubaInstanceAccount* tuba_account_store_get_active (TubaAccountStore* self);
VALA_EXTERN GType tuba_network_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaNetwork, g_object_unref)
VALA_EXTERN void tuba_network_clear_cache (TubaNetwork* self);
VALA_EXTERN void tuba_instance_account_verify_credentials (TubaInstanceAccount* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
VALA_EXTERN void tuba_instance_account_verify_credentials_finish (TubaInstanceAccount* self,
                                                      GAsyncResult* _res_,
                                                      GError** error);
static void ___lambda179_ (Block37Data* _data37_,
                    GObject* obj,
                    GAsyncResult* res);
VALA_EXTERN void tuba_instance_account_set_error (TubaInstanceAccount* self,
                                      GError* value);
VALA_EXTERN void tuba_settings_set_active_account (TubaSettings* self,
                                       const gchar* value);
VALA_EXTERN GType tuba_api_account_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaAPIAccountSource, g_object_unref)
VALA_EXTERN TubaAPIAccountSource* tuba_api_account_get_source (TubaAPIAccount* self);
VALA_EXTERN const gchar* tuba_api_account_source_get_language (TubaAPIAccountSource* self);
VALA_EXTERN void tuba_settings_set_default_language (TubaSettings* self,
                                         const gchar* value);
VALA_EXTERN const gchar* tuba_api_account_source_get_privacy (TubaAPIAccountSource* self);
VALA_EXTERN GQuark tuba_oopsie_quark (void);
VALA_EXTERN GType tuba_oopsie_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType tuba_widgetizable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaWidgetizable, g_object_unref)
VALA_EXTERN GType tuba_streamable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaStreamable, g_object_unref)
VALA_EXTERN GType tuba_instance_account_kind_get_type (void) G_GNUC_CONST ;
VALA_EXTERN TubaInstanceAccountKind* tuba_instance_account_kind_dup (const TubaInstanceAccountKind* self);
VALA_EXTERN void tuba_instance_account_kind_free (TubaInstanceAccountKind* self);
VALA_EXTERN void tuba_instance_account_kind_copy (const TubaInstanceAccountKind* self,
                                      TubaInstanceAccountKind* dest);
VALA_EXTERN void tuba_instance_account_kind_destroy (TubaInstanceAccountKind* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (TubaInstanceAccountKind, tuba_instance_account_kind_destroy)
VALA_EXTERN GType tuba_streamable_event_get_type (void) G_GNUC_CONST ;
VALA_EXTERN TubaStreamableEvent* tuba_streamable_event_dup (const TubaStreamableEvent* self);
VALA_EXTERN void tuba_streamable_event_free (TubaStreamableEvent* self);
VALA_EXTERN void tuba_streamable_event_copy (const TubaStreamableEvent* self,
                                 TubaStreamableEvent* dest);
VALA_EXTERN void tuba_streamable_event_destroy (TubaStreamableEvent* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (TubaStreamableEvent, tuba_streamable_event_destroy)
VALA_EXTERN GType tuba_instance_account_visibility_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaInstanceAccountVisibility, g_object_unref)
VALA_EXTERN void tuba_settings_set_default_post_visibility (TubaSettings* self,
                                                const gchar* value);
VALA_EXTERN gint tuba_api_account_source_get_follow_requests_count (TubaAPIAccountSource* self);
VALA_EXTERN void tuba_instance_account_set_unreviewed_follow_requests (TubaInstanceAccount* self,
                                                           gint value);
static void ____lambda179__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
VALA_EXTERN void tuba_account_store_set_active (TubaAccountStore* self,
                                    TubaInstanceAccount* value);
VALA_EXTERN TubaInstanceAccount* tuba_account_store_create_account (TubaAccountStore* self,
                                                        JsonNode* node,
                                                        GError** error);
VALA_EXTERN void tuba_instance_account_set_uuid (TubaInstanceAccount* self,
                                     const gchar* value);
static void tuba_account_store_guess_backend_data_free (gpointer _data);
VALA_EXTERN void tuba_account_store_guess_backend (TubaAccountStore* self,
                                       TubaInstanceAccount* account,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
VALA_EXTERN void tuba_account_store_guess_backend_finish (TubaAccountStore* self,
                                              GAsyncResult* _res_,
                                              GError** error);
static gboolean tuba_account_store_guess_backend_co (TubaAccountStoreGuessBackendData* _data_);
static Block38Data* block38_data_ref (Block38Data* _data38_);
static void block38_data_unref (void * _userdata_);
VALA_EXTERN GType tuba_request_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaRequest, g_object_unref)
VALA_EXTERN TubaRequest* tuba_request_new_GET (const gchar* url);
VALA_EXTERN TubaRequest* tuba_request_construct_GET (GType object_type,
                                         const gchar* url);
VALA_EXTERN TubaRequest* tuba_request_with_account (TubaRequest* self,
                                        TubaInstanceAccount* account);
VALA_EXTERN void tuba_request_await (TubaRequest* self,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_);
VALA_EXTERN TubaRequest* tuba_request_await_finish (TubaRequest* self,
                                        GAsyncResult* _res_,
                                        GError** error);
static void tuba_account_store_guess_backend_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
VALA_EXTERN JsonParser* tuba_network_get_parser_from_inputstream (GInputStream* in_stream,
                                                      GError** error);
VALA_EXTERN GInputStream* tuba_request_get_response_body (TubaRequest* self);
VALA_EXTERN JsonObject* tuba_network_parse (TubaNetwork* self,
                                JsonParser* parser);
static gboolean __lambda181_ (Block38Data* _data38_,
                       TubaAccountStoreBackendTest* test);
VALA_EXTERN gchar* tuba_account_store_backend_test_get_backend (TubaAccountStoreBackendTest* self,
                                                    JsonObject* obj);
static gboolean ___lambda181__gee_forall_func (gpointer g,
                                        gpointer self);
VALA_EXTERN void tuba_instance_account_set_backend (TubaInstanceAccount* self,
                                        const gchar* value);
VALA_EXTERN const gchar* tuba_instance_account_get_instance (TubaInstanceAccount* self);
VALA_EXTERN const gchar* tuba_instance_account_get_backend (TubaInstanceAccount* self);
VALA_EXTERN TubaAccountStore* tuba_account_store_construct (GType object_type);
VALA_EXTERN void tuba_account_store_set_saved (TubaAccountStore* self,
                                   GeeArrayList* value);
static void g_cclosure_user_marshal_OBJECT__BOXED (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data);
static gchar* tuba_account_store_backend_test_real_get_backend (TubaAccountStoreBackendTest* self,
                                                         JsonObject* obj);
VALA_EXTERN TubaAccountStoreBackendTest* tuba_account_store_backend_test_construct (GType object_type);
static GType tuba_account_store_backend_test_get_type_once (void);
static void tuba_account_store_finalize (GObject * obj);
static GType tuba_account_store_get_type_once (void);
static void _vala_tuba_account_store_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_tuba_account_store_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);

static inline gpointer
tuba_account_store_get_instance_private (TubaAccountStore* self)
{
	return G_STRUCT_MEMBER_P (self, TubaAccountStore_private_offset);
}

gboolean
tuba_account_store_ensure_active_account (TubaAccountStore* self)
{
	gboolean has_active = FALSE;
	TubaInstanceAccount* account = NULL;
	TubaSettings* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	TubaInstanceAccount* _tmp3_;
	gboolean clear_cache = FALSE;
	gboolean _tmp4_ = FALSE;
	TubaInstanceAccount* _tmp5_;
	TubaInstanceAccount* _tmp11_;
	TubaInstanceAccount* _tmp12_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	has_active = FALSE;
	_tmp0_ = tuba_settings;
	_tmp1_ = tuba_settings_get_active_account (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = tuba_account_store_find_by_uuid (self, _tmp2_);
	account = _tmp3_;
	clear_cache = FALSE;
	_tmp5_ = account;
	if (_tmp5_ == NULL) {
		GeeArrayList* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = self->priv->_saved;
		_tmp7_ = gee_collection_get_is_empty ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = !_tmp8_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GeeArrayList* _tmp9_;
		gpointer _tmp10_;
		_tmp9_ = self->priv->_saved;
		_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, 0);
		_g_object_unref0 (account);
		account = (TubaInstanceAccount*) _tmp10_;
		clear_cache = TRUE;
	}
	_tmp11_ = account;
	has_active = _tmp11_ != NULL;
	_tmp12_ = account;
	tuba_account_store_activate (self, _tmp12_, clear_cache);
	if (!has_active) {
		TubaApplication* _tmp13_;
		_tmp13_ = tuba_app;
		tuba_application_present_window (_tmp13_, TRUE);
	}
	result = has_active;
	_g_object_unref0 (account);
	return result;
}

static void
tuba_account_store_real_init (TubaAccountStore* self,
                              GError** error)
{
	GError* _inner_error0_ = NULL;
	tuba_mastodon_account_register (self);
	tuba_account_store_load (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	tuba_account_store_ensure_active_account (self);
}

void
tuba_account_store_init (TubaAccountStore* self,
                         GError** error)
{
	TubaAccountStoreClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = TUBA_ACCOUNT_STORE_GET_CLASS (self);
	if (_klass_->init) {
		_klass_->init (self, error);
	}
}

static void
tuba_account_store_real_load (TubaAccountStore* self,
                              GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `tuba_account_store_load'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
tuba_account_store_load (TubaAccountStore* self,
                         GError** error)
{
	TubaAccountStoreClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = TUBA_ACCOUNT_STORE_GET_CLASS (self);
	if (_klass_->load) {
		_klass_->load (self, error);
	}
}

static void
tuba_account_store_real_save (TubaAccountStore* self,
                              GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `tuba_account_store_save'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
tuba_account_store_save (TubaAccountStore* self,
                         GError** error)
{
	TubaAccountStoreClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = TUBA_ACCOUNT_STORE_GET_CLASS (self);
	if (_klass_->save) {
		_klass_->save (self, error);
	}
}

void
tuba_account_store_safe_save (TubaAccountStore* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		tuba_account_store_save (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		AdwAlertDialog* dlg = NULL;
		TubaApplication* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		AdwAlertDialog* _tmp5_;
		AdwAlertDialog* _tmp6_;
		TubaApplication* _tmp7_;
		TubaDialogsMainWindow* _tmp8_;
		TubaDialogsMainWindow* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("AccountStore.vala:42: %s", _tmp1_);
		_tmp2_ = tuba_app;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		_tmp5_ = tuba_application_inform (_tmp2_, _ ("Error"), _tmp4_);
		dlg = _tmp5_;
		_tmp6_ = dlg;
		_tmp7_ = tuba_app;
		_tmp8_ = tuba_application_get_main_window (_tmp7_);
		_tmp9_ = _tmp8_;
		adw_dialog_present ((AdwDialog*) _tmp6_, (GtkWidget*) _tmp9_);
		_g_object_unref0 (dlg);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
tuba_account_store_real_add (TubaAccountStore* self,
                             TubaInstanceAccount* account,
                             GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (account != NULL);
	_tmp0_ = tuba_instance_account_get_handle (account);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = g_strconcat ("Adding new account: ", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	g_debug ("AccountStore.vala:49: %s", _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	_tmp6_ = self->priv->_saved;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, account);
	_tmp7_ = self->priv->_saved;
	g_signal_emit (self, tuba_account_store_signals[TUBA_ACCOUNT_STORE_CHANGED_SIGNAL], 0, _tmp7_);
	tuba_account_store_save (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	tuba_account_store_ensure_active_account (self);
}

void
tuba_account_store_add (TubaAccountStore* self,
                        TubaInstanceAccount* account,
                        GError** error)
{
	TubaAccountStoreClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = TUBA_ACCOUNT_STORE_GET_CLASS (self);
	if (_klass_->add) {
		_klass_->add (self, account, error);
	}
}

static void
tuba_account_store_real_remove (TubaAccountStore* self,
                                TubaInstanceAccount* account,
                                GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (account != NULL);
	_tmp0_ = tuba_instance_account_get_handle (account);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = g_strconcat ("Removing account: ", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	g_debug ("AccountStore.vala:57: %s", _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	g_signal_emit_by_name (account, "removed");
	_tmp6_ = self->priv->_saved;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp6_, account);
	_tmp7_ = self->priv->_saved;
	g_signal_emit (self, tuba_account_store_signals[TUBA_ACCOUNT_STORE_CHANGED_SIGNAL], 0, _tmp7_);
	tuba_account_store_save (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	tuba_account_store_ensure_active_account (self);
}

void
tuba_account_store_remove (TubaAccountStore* self,
                           TubaInstanceAccount* account,
                           GError** error)
{
	TubaAccountStoreClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = TUBA_ACCOUNT_STORE_GET_CLASS (self);
	if (_klass_->remove) {
		_klass_->remove (self, account, error);
	}
}

static Block36Data*
block36_data_ref (Block36Data* _data36_)
{
	g_atomic_int_inc (&_data36_->_ref_count_);
	return _data36_;
}

static void
block36_data_unref (void * _userdata_)
{
	Block36Data* _data36_;
	_data36_ = (Block36Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data36_->_ref_count_)) {
		TubaAccountStore* self;
		self = _data36_->self;
		_g_free0 (_data36_->uuid);
		_g_object_unref0 (self);
		g_slice_free (Block36Data, _data36_);
	}
}

static gboolean
__lambda178_ (Block36Data* _data36_,
              TubaInstanceAccount* acc)
{
	TubaAccountStore* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean result;
	self = _data36_->self;
	g_return_val_if_fail (acc != NULL, FALSE);
	_tmp0_ = tuba_instance_account_get_uuid (acc);
	_tmp1_ = _tmp0_;
	result = g_strcmp0 (_tmp1_, _data36_->uuid) == 0;
	return result;
}

static gboolean
___lambda178__gee_predicate (gconstpointer g,
                             gpointer self)
{
	gboolean result;
	result = __lambda178_ (self, (TubaInstanceAccount*) g);
	return result;
}

TubaInstanceAccount*
tuba_account_store_find_by_uuid (TubaAccountStore* self,
                                 const gchar* uuid)
{
	Block36Data* _data36_;
	gchar* _tmp0_;
	GeeIterator* iter = NULL;
	GeeArrayList* _tmp1_;
	GeeIterator* _tmp2_;
	GeeIterator* _tmp3_;
	GeeIterator* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	TubaInstanceAccount* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uuid != NULL, NULL);
	_data36_ = g_slice_new0 (Block36Data);
	_data36_->_ref_count_ = 1;
	_data36_->self = g_object_ref (self);
	_tmp0_ = g_strdup (uuid);
	_g_free0 (_data36_->uuid);
	_data36_->uuid = _tmp0_;
	if (!g_uuid_string_is_valid (_data36_->uuid)) {
		result = NULL;
		block36_data_unref (_data36_);
		_data36_ = NULL;
		return result;
	}
	_tmp1_ = self->priv->_saved;
	_tmp2_ = gee_traversable_filter ((GeeTraversable*) _tmp1_, ___lambda178__gee_predicate, block36_data_ref (_data36_), block36_data_unref);
	iter = _tmp2_;
	_tmp3_ = iter;
	gee_iterator_next (_tmp3_);
	_tmp4_ = iter;
	_tmp5_ = gee_iterator_get_valid (_tmp4_);
	_tmp6_ = _tmp5_;
	if (!_tmp6_) {
		result = NULL;
		_g_object_unref0 (iter);
		block36_data_unref (_data36_);
		_data36_ = NULL;
		return result;
	} else {
		GeeIterator* _tmp7_;
		gpointer _tmp8_;
		_tmp7_ = iter;
		_tmp8_ = gee_iterator_get (_tmp7_);
		result = (TubaInstanceAccount*) _tmp8_;
		_g_object_unref0 (iter);
		block36_data_unref (_data36_);
		_data36_ = NULL;
		return result;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block37Data*
block37_data_ref (Block37Data* _data37_)
{
	g_atomic_int_inc (&_data37_->_ref_count_);
	return _data37_;
}

static void
block37_data_unref (void * _userdata_)
{
	Block37Data* _data37_;
	_data37_ = (Block37Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data37_->_ref_count_)) {
		TubaAccountStore* self;
		self = _data37_->self;
		_g_object_unref0 (_data37_->account);
		_g_object_unref0 (self);
		g_slice_free (Block37Data, _data37_);
	}
}

static void
___lambda179_ (Block37Data* _data37_,
               GObject* obj,
               GAsyncResult* res)
{
	TubaAccountStore* self;
	GError* _inner_error0_ = NULL;
	self = _data37_->self;
	g_return_if_fail (res != NULL);
	{
		TubaSettings* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		TubaAPIAccountSource* _tmp3_;
		TubaAPIAccountSource* _tmp4_;
		tuba_instance_account_verify_credentials_finish (_data37_->account, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		tuba_instance_account_set_error (_data37_->account, NULL);
		_tmp0_ = tuba_settings;
		_tmp1_ = tuba_instance_account_get_uuid (_data37_->account);
		_tmp2_ = _tmp1_;
		tuba_settings_set_active_account (_tmp0_, _tmp2_);
		_tmp3_ = tuba_api_account_get_source ((TubaAPIAccount*) _data37_->account);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			gboolean _tmp5_ = FALSE;
			TubaAPIAccountSource* _tmp6_;
			TubaAPIAccountSource* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gboolean _tmp19_ = FALSE;
			TubaAPIAccountSource* _tmp20_;
			TubaAPIAccountSource* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			TubaAPIAccountSource* _tmp37_;
			TubaAPIAccountSource* _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			_tmp6_ = tuba_api_account_get_source ((TubaAPIAccount*) _data37_->account);
			_tmp7_ = _tmp6_;
			_tmp8_ = tuba_api_account_source_get_language (_tmp7_);
			_tmp9_ = _tmp8_;
			if (_tmp9_ != NULL) {
				TubaAPIAccountSource* _tmp10_;
				TubaAPIAccountSource* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp10_ = tuba_api_account_get_source ((TubaAPIAccount*) _data37_->account);
				_tmp11_ = _tmp10_;
				_tmp12_ = tuba_api_account_source_get_language (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp5_ = g_strcmp0 (_tmp13_, "") != 0;
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				TubaSettings* _tmp14_;
				TubaAPIAccountSource* _tmp15_;
				TubaAPIAccountSource* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				_tmp14_ = tuba_settings;
				_tmp15_ = tuba_api_account_get_source ((TubaAPIAccount*) _data37_->account);
				_tmp16_ = _tmp15_;
				_tmp17_ = tuba_api_account_source_get_language (_tmp16_);
				_tmp18_ = _tmp17_;
				tuba_settings_set_default_language (_tmp14_, _tmp18_);
			}
			_tmp20_ = tuba_api_account_get_source ((TubaAPIAccount*) _data37_->account);
			_tmp21_ = _tmp20_;
			_tmp22_ = tuba_api_account_source_get_privacy (_tmp21_);
			_tmp23_ = _tmp22_;
			if (_tmp23_ != NULL) {
				TubaAPIAccountSource* _tmp24_;
				TubaAPIAccountSource* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				_tmp24_ = tuba_api_account_get_source ((TubaAPIAccount*) _data37_->account);
				_tmp25_ = _tmp24_;
				_tmp26_ = tuba_api_account_source_get_privacy (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp19_ = g_strcmp0 (_tmp27_, "") != 0;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				gchar* visibility_id = NULL;
				TubaAPIAccountSource* _tmp28_;
				TubaAPIAccountSource* _tmp29_;
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				gchar* _tmp32_;
				GeeHashMap* _tmp33_;
				const gchar* _tmp34_;
				_tmp28_ = tuba_api_account_get_source ((TubaAPIAccount*) _data37_->account);
				_tmp29_ = _tmp28_;
				_tmp30_ = tuba_api_account_source_get_privacy (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = g_utf8_strdown (_tmp31_, (gssize) -1);
				visibility_id = _tmp32_;
				_tmp33_ = _data37_->account->visibility;
				_tmp34_ = visibility_id;
				if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp33_, _tmp34_)) {
					TubaSettings* _tmp35_;
					const gchar* _tmp36_;
					_tmp35_ = tuba_settings;
					_tmp36_ = visibility_id;
					tuba_settings_set_default_post_visibility (_tmp35_, _tmp36_);
				}
				_g_free0 (visibility_id);
			}
			_tmp37_ = tuba_api_account_get_source ((TubaAPIAccount*) _data37_->account);
			_tmp38_ = _tmp37_;
			_tmp39_ = tuba_api_account_source_get_follow_requests_count (_tmp38_);
			_tmp40_ = _tmp39_;
			tuba_instance_account_set_unreviewed_follow_requests (_data37_->account, _tmp40_);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		const gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		GError* _tmp47_;
		const gchar* _tmp48_;
		GError* _tmp49_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp41_ = tuba_instance_account_get_handle (_data37_->account);
		_tmp42_ = _tmp41_;
		_tmp43_ = _tmp42_;
		_tmp44_ = string_to_string (_tmp43_);
		_tmp45_ = g_strconcat ("Couldn't activate account ", _tmp44_, ":", NULL);
		_tmp46_ = _tmp45_;
		g_warning ("AccountStore.vala:104: %s", _tmp46_);
		_g_free0 (_tmp46_);
		_g_free0 (_tmp43_);
		_tmp47_ = e;
		_tmp48_ = _tmp47_->message;
		g_warning ("AccountStore.vala:105: %s", _tmp48_);
		_tmp49_ = e;
		tuba_instance_account_set_error (_data37_->account, _tmp49_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda179__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda179_ (self, source_object, res);
	block37_data_unref (self);
}

void
tuba_account_store_activate (TubaAccountStore* self,
                             TubaInstanceAccount* account,
                             gboolean clear_cache)
{
	Block37Data* _data37_;
	TubaInstanceAccount* _tmp0_;
	TubaInstanceAccount* _tmp1_;
	TubaAccountStore* _tmp10_;
	TubaInstanceAccount* _tmp11_;
	TubaInstanceAccount* _tmp12_;
	g_return_if_fail (self != NULL);
	_data37_ = g_slice_new0 (Block37Data);
	_data37_->_ref_count_ = 1;
	_data37_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (account);
	_g_object_unref0 (_data37_->account);
	_data37_->account = _tmp0_;
	_tmp1_ = self->priv->_active;
	if (_tmp1_ != NULL) {
		TubaInstanceAccount* _tmp2_;
		_tmp2_ = self->priv->_active;
		g_signal_emit_by_name (_tmp2_, "deactivated");
	}
	if (_data37_->account == NULL) {
		g_debug ("AccountStore.vala:83: Reset active account");
		block37_data_unref (_data37_);
		_data37_ = NULL;
		return;
	} else {
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp3_ = tuba_instance_account_get_handle (_data37_->account);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp6_ = string_to_string (_tmp5_);
		_tmp7_ = g_strconcat ("Activating ", _tmp6_, "…", NULL);
		_tmp8_ = _tmp7_;
		g_debug ("AccountStore.vala:86: %s", _tmp8_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp5_);
		if (clear_cache) {
			TubaNetwork* _tmp9_;
			_tmp9_ = tuba_network;
			tuba_network_clear_cache (_tmp9_);
		}
		tuba_instance_account_verify_credentials (_data37_->account, ____lambda179__gasync_ready_callback, block37_data_ref (_data37_));
	}
	_tmp10_ = tuba_accounts;
	tuba_account_store_set_active (_tmp10_, _data37_->account);
	_tmp11_ = self->priv->_active;
	g_signal_emit_by_name (_tmp11_, "activated");
	_tmp12_ = self->priv->_active;
	g_signal_emit (self, tuba_account_store_signals[TUBA_ACCOUNT_STORE_SWITCHED_SIGNAL], 0, _tmp12_);
	block37_data_unref (_data37_);
	_data37_ = NULL;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

TubaInstanceAccount*
tuba_account_store_create_account (TubaAccountStore* self,
                                   JsonNode* node,
                                   GError** error)
{
	JsonObject* obj = NULL;
	JsonObject* _tmp0_;
	JsonObject* _tmp1_;
	gchar* backend = NULL;
	JsonObject* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* handle = NULL;
	JsonObject* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	TubaInstanceAccount* account = NULL;
	const gchar* _tmp8_;
	TubaInstanceAccount* _tmp9_ = NULL;
	TubaInstanceAccount* _tmp10_;
	gboolean _tmp19_ = FALSE;
	TubaInstanceAccount* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	GError* _inner_error0_ = NULL;
	TubaInstanceAccount* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = json_node_get_object (node);
	_tmp1_ = _json_object_ref0 (_tmp0_);
	obj = _tmp1_;
	_tmp2_ = obj;
	_tmp3_ = json_object_get_string_member (_tmp2_, "backend");
	_tmp4_ = g_strdup (_tmp3_);
	backend = _tmp4_;
	_tmp5_ = obj;
	_tmp6_ = json_object_get_string_member (_tmp5_, "handle");
	_tmp7_ = g_strdup (_tmp6_);
	handle = _tmp7_;
	_tmp8_ = backend;
	g_signal_emit (self, tuba_account_store_signals[TUBA_ACCOUNT_STORE_CREATE_FOR_BACKEND_SIGNAL], g_quark_from_string (_tmp8_), node, &_tmp9_);
	account = _tmp9_;
	_tmp10_ = account;
	if (_tmp10_ == NULL) {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GError* _tmp17_;
		GError* _tmp18_;
		_tmp11_ = handle;
		_tmp12_ = string_to_string (_tmp11_);
		_tmp13_ = backend;
		_tmp14_ = string_to_string (_tmp13_);
		_tmp15_ = g_strconcat ("Account ", _tmp12_, " has unknown backend: ", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_error_new_literal (TUBA_OOPSIE, TUBA_OOPSIE_INTERNAL, _tmp16_);
		_tmp18_ = _tmp17_;
		_g_free0 (_tmp16_);
		_inner_error0_ = _tmp18_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (account);
		_g_free0 (handle);
		_g_free0 (backend);
		_json_object_unref0 (obj);
		return NULL;
	}
	_tmp20_ = account;
	_tmp21_ = tuba_instance_account_get_uuid (_tmp20_);
	_tmp22_ = _tmp21_;
	if (_tmp22_ == NULL) {
		_tmp19_ = TRUE;
	} else {
		TubaInstanceAccount* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		_tmp23_ = account;
		_tmp24_ = tuba_instance_account_get_uuid (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp19_ = !g_uuid_string_is_valid (_tmp25_);
	}
	if (_tmp19_) {
		TubaInstanceAccount* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp26_ = account;
		_tmp27_ = g_uuid_string_random ();
		_tmp28_ = _tmp27_;
		tuba_instance_account_set_uuid (_tmp26_, _tmp28_);
		_g_free0 (_tmp28_);
	}
	result = account;
	_g_free0 (handle);
	_g_free0 (backend);
	_json_object_unref0 (obj);
	return result;
}

static void
tuba_account_store_guess_backend_data_free (gpointer _data)
{
	TubaAccountStoreGuessBackendData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->self);
	g_slice_free (TubaAccountStoreGuessBackendData, _data_);
}

void
tuba_account_store_guess_backend (TubaAccountStore* self,
                                  TubaInstanceAccount* account,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	TubaAccountStoreGuessBackendData* _data_;
	TubaAccountStore* _tmp0_;
	TubaInstanceAccount* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (account != NULL);
	_data_ = g_slice_new0 (TubaAccountStoreGuessBackendData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tuba_account_store_guess_backend_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (account);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	tuba_account_store_guess_backend_co (_data_);
}

void
tuba_account_store_guess_backend_finish (TubaAccountStore* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	TubaAccountStoreGuessBackendData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static Block38Data*
block38_data_ref (Block38Data* _data38_)
{
	g_atomic_int_inc (&_data38_->_ref_count_);
	return _data38_;
}

static void
block38_data_unref (void * _userdata_)
{
	Block38Data* _data38_;
	_data38_ = (Block38Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data38_->_ref_count_)) {
		TubaAccountStore* self;
		self = _data38_->self;
		_g_free0 (_data38_->backend);
		_json_object_unref0 (_data38_->root);
		_g_object_unref0 (self);
		g_slice_free (Block38Data, _data38_);
	}
}

static void
tuba_account_store_guess_backend_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	TubaAccountStoreGuessBackendData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tuba_account_store_guess_backend_co (_data_);
}

static gboolean
__lambda181_ (Block38Data* _data38_,
              TubaAccountStoreBackendTest* test)
{
	TubaAccountStore* self;
	JsonObject* _tmp0_;
	gchar* _tmp1_;
	gboolean result;
	self = _data38_->self;
	g_return_val_if_fail (test != NULL, FALSE);
	_tmp0_ = _data38_->root;
	_tmp1_ = tuba_account_store_backend_test_get_backend (test, _tmp0_);
	_g_free0 (_data38_->backend);
	_data38_->backend = _tmp1_;
	result = TRUE;
	_g_object_unref0 (test);
	return result;
}

static gboolean
___lambda181__gee_forall_func (gpointer g,
                               gpointer self)
{
	gboolean result;
	result = __lambda181_ (self, (TubaAccountStoreBackendTest*) g);
	return result;
}

static gboolean
tuba_account_store_guess_backend_co (TubaAccountStoreGuessBackendData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data38_ = g_slice_new0 (Block38Data);
	_data_->_data38_->_ref_count_ = 1;
	_data_->_data38_->self = g_object_ref (_data_->self);
	_data_->_data38_->_async_data_ = _data_;
	_data_->_tmp0_ = tuba_request_new_GET ("/api/v1/instance");
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = tuba_request_with_account (_data_->_tmp1_, _data_->account);
	_data_->_tmp3_ = _data_->_tmp2_;
	_g_object_unref0 (_data_->_tmp1_);
	_data_->req = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->req;
	_data_->_state_ = 1;
	tuba_request_await (_data_->_tmp4_, tuba_account_store_guess_backend_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp5_ = tuba_request_await_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_g_object_unref0 (_data_->_tmp6_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->req);
		block38_data_unref (_data_->_data38_);
		_data_->_data38_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->req;
	_data_->_tmp8_ = tuba_request_get_response_body (_data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = tuba_network_get_parser_from_inputstream (_data_->_tmp9_, &_data_->_inner_error0_);
	_data_->parser = _data_->_tmp10_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->req);
		block38_data_unref (_data_->_data38_);
		_data_->_data38_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = tuba_network;
	_data_->_tmp12_ = _data_->parser;
	_data_->_tmp13_ = tuba_network_parse (_data_->_tmp11_, _data_->_tmp12_);
	_data_->_data38_->root = _data_->_tmp13_;
	_data_->_data38_->backend = NULL;
	_data_->_tmp14_ = _data_->self->backend_tests;
	gee_abstract_collection_foreach ((GeeAbstractCollection*) _data_->_tmp14_, ___lambda181__gee_forall_func, _data_->_data38_);
	_data_->_tmp15_ = _data_->_data38_->backend;
	if (_data_->_tmp15_ == NULL) {
		_data_->_tmp16_ = g_error_new_literal (TUBA_OOPSIE, TUBA_OOPSIE_INTERNAL, "This instance is unsupported.");
		_data_->_inner_error0_ = _data_->_tmp16_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->parser);
		_g_object_unref0 (_data_->req);
		block38_data_unref (_data_->_data38_);
		_data_->_data38_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp17_ = _data_->_data38_->backend;
		tuba_instance_account_set_backend (_data_->account, _data_->_tmp17_);
		_data_->_tmp18_ = tuba_instance_account_get_instance (_data_->account);
		_data_->_tmp19_ = _data_->_tmp18_;
		_data_->_tmp20_ = string_to_string (_data_->_tmp19_);
		_data_->_tmp21_ = tuba_instance_account_get_backend (_data_->account);
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp23_ = string_to_string (_data_->_tmp22_);
		_data_->_tmp24_ = g_strconcat (_data_->_tmp20_, " is using ", _data_->_tmp23_, NULL);
		_data_->_tmp25_ = _data_->_tmp24_;
		g_debug ("AccountStore.vala:165: %s", _data_->_tmp25_);
		_g_free0 (_data_->_tmp25_);
	}
	_g_object_unref0 (_data_->parser);
	_g_object_unref0 (_data_->req);
	block38_data_unref (_data_->_data38_);
	_data_->_data38_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

TubaAccountStore*
tuba_account_store_construct (GType object_type)
{
	TubaAccountStore * self = NULL;
	self = (TubaAccountStore*) g_object_new (object_type, NULL);
	return self;
}

GeeArrayList*
tuba_account_store_get_saved (TubaAccountStore* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_saved;
	result = _tmp0_;
	return result;
}

void
tuba_account_store_set_saved (TubaAccountStore* self,
                              GeeArrayList* value)
{
	GeeArrayList* old_value;
	g_return_if_fail (self != NULL);
	old_value = tuba_account_store_get_saved (self);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_saved);
		self->priv->_saved = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tuba_account_store_properties[TUBA_ACCOUNT_STORE_SAVED_PROPERTY]);
	}
}

TubaInstanceAccount*
tuba_account_store_get_active (TubaAccountStore* self)
{
	TubaInstanceAccount* result;
	TubaInstanceAccount* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_active;
	result = _tmp0_;
	return result;
}

void
tuba_account_store_set_active (TubaAccountStore* self,
                               TubaInstanceAccount* value)
{
	TubaInstanceAccount* old_value;
	g_return_if_fail (self != NULL);
	old_value = tuba_account_store_get_active (self);
	if (old_value != value) {
		TubaInstanceAccount* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_active);
		self->priv->_active = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tuba_account_store_properties[TUBA_ACCOUNT_STORE_ACTIVE_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_OBJECT__BOXED (GClosure * closure,
                                       GValue * return_value,
                                       guint n_param_values,
                                       const GValue * param_values,
                                       gpointer invocation_hint,
                                       gpointer marshal_data)
{
	typedef gpointer (*GMarshalFunc_OBJECT__BOXED) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_OBJECT__BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gpointer v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_OBJECT__BOXED) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_boxed (param_values + 1), data2);
	g_value_take_object (return_value, v_return);
}

static gchar*
tuba_account_store_backend_test_real_get_backend (TubaAccountStoreBackendTest* self,
                                                  JsonObject* obj)
{
	g_critical ("Type `%s' does not implement abstract method `tuba_account_store_backend_test_get_backend'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
tuba_account_store_backend_test_get_backend (TubaAccountStoreBackendTest* self,
                                             JsonObject* obj)
{
	TubaAccountStoreBackendTestClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = TUBA_ACCOUNT_STORE_BACKEND_TEST_GET_CLASS (self);
	if (_klass_->get_backend) {
		return _klass_->get_backend (self, obj);
	}
	return NULL;
}

TubaAccountStoreBackendTest*
tuba_account_store_backend_test_construct (GType object_type)
{
	TubaAccountStoreBackendTest * self = NULL;
	self = (TubaAccountStoreBackendTest*) g_object_new (object_type, NULL);
	return self;
}

static void
tuba_account_store_backend_test_class_init (TubaAccountStoreBackendTestClass * klass,
                                            gpointer klass_data)
{
	tuba_account_store_backend_test_parent_class = g_type_class_peek_parent (klass);
	((TubaAccountStoreBackendTestClass *) klass)->get_backend = (gchar* (*) (TubaAccountStoreBackendTest*, JsonObject*)) tuba_account_store_backend_test_real_get_backend;
}

static void
tuba_account_store_backend_test_instance_init (TubaAccountStoreBackendTest * self,
                                               gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
tuba_account_store_backend_test_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TubaAccountStoreBackendTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tuba_account_store_backend_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TubaAccountStoreBackendTest), 0, (GInstanceInitFunc) tuba_account_store_backend_test_instance_init, NULL };
	GType tuba_account_store_backend_test_type_id;
	tuba_account_store_backend_test_type_id = g_type_register_static (G_TYPE_OBJECT, "TubaAccountStoreBackendTest", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return tuba_account_store_backend_test_type_id;
}

GType
tuba_account_store_backend_test_get_type (void)
{
	static gsize tuba_account_store_backend_test_type_id__once = 0;
	if (g_once_init_enter (&tuba_account_store_backend_test_type_id__once)) {
		GType tuba_account_store_backend_test_type_id;
		tuba_account_store_backend_test_type_id = tuba_account_store_backend_test_get_type_once ();
		g_once_init_leave (&tuba_account_store_backend_test_type_id__once, tuba_account_store_backend_test_type_id);
	}
	return tuba_account_store_backend_test_type_id__once;
}

static void
tuba_account_store_class_init (TubaAccountStoreClass * klass,
                               gpointer klass_data)
{
	tuba_account_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TubaAccountStore_private_offset);
	((TubaAccountStoreClass *) klass)->init = (void (*) (TubaAccountStore*, GError**)) tuba_account_store_real_init;
	((TubaAccountStoreClass *) klass)->load = (void (*) (TubaAccountStore*, GError**)) tuba_account_store_real_load;
	((TubaAccountStoreClass *) klass)->save = (void (*) (TubaAccountStore*, GError**)) tuba_account_store_real_save;
	((TubaAccountStoreClass *) klass)->add = (void (*) (TubaAccountStore*, TubaInstanceAccount*, GError**)) tuba_account_store_real_add;
	((TubaAccountStoreClass *) klass)->remove = (void (*) (TubaAccountStore*, TubaInstanceAccount*, GError**)) tuba_account_store_real_remove;
	G_OBJECT_CLASS (klass)->get_property = _vala_tuba_account_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tuba_account_store_set_property;
	G_OBJECT_CLASS (klass)->finalize = tuba_account_store_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_ACCOUNT_STORE_SAVED_PROPERTY, tuba_account_store_properties[TUBA_ACCOUNT_STORE_SAVED_PROPERTY] = g_param_spec_object ("saved", "saved", "saved", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_ACCOUNT_STORE_ACTIVE_PROPERTY, tuba_account_store_properties[TUBA_ACCOUNT_STORE_ACTIVE_PROPERTY] = g_param_spec_object ("active", "active", "active", TUBA_TYPE_INSTANCE_ACCOUNT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	tuba_account_store_signals[TUBA_ACCOUNT_STORE_CHANGED_SIGNAL] = g_signal_new ("changed", TUBA_TYPE_ACCOUNT_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_ARRAY_LIST);
	tuba_account_store_signals[TUBA_ACCOUNT_STORE_SWITCHED_SIGNAL] = g_signal_new ("switched", TUBA_TYPE_ACCOUNT_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TUBA_TYPE_INSTANCE_ACCOUNT);
	tuba_account_store_signals[TUBA_ACCOUNT_STORE_CREATE_FOR_BACKEND_SIGNAL] = g_signal_new ("create-for-backend", TUBA_TYPE_ACCOUNT_STORE, G_SIGNAL_RUN_LAST | G_SIGNAL_DETAILED, 0, NULL, NULL, g_cclosure_user_marshal_OBJECT__BOXED, TUBA_TYPE_INSTANCE_ACCOUNT, 1, json_node_get_type ());
}

static void
tuba_account_store_instance_init (TubaAccountStore * self,
                                  gpointer klass)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	self->priv = tuba_account_store_get_instance_private (self);
	_tmp0_ = gee_array_list_new (TUBA_TYPE_INSTANCE_ACCOUNT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->_saved = _tmp0_;
	self->priv->_active = NULL;
	_tmp1_ = gee_array_list_new (TUBA_ACCOUNT_STORE_TYPE_BACKEND_TEST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->backend_tests = _tmp1_;
}

static void
tuba_account_store_finalize (GObject * obj)
{
	TubaAccountStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_TYPE_ACCOUNT_STORE, TubaAccountStore);
	_g_object_unref0 (self->priv->_saved);
	_g_object_unref0 (self->priv->_active);
	_g_object_unref0 (self->backend_tests);
	G_OBJECT_CLASS (tuba_account_store_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
tuba_account_store_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TubaAccountStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tuba_account_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TubaAccountStore), 0, (GInstanceInitFunc) tuba_account_store_instance_init, NULL };
	GType tuba_account_store_type_id;
	tuba_account_store_type_id = g_type_register_static (G_TYPE_OBJECT, "TubaAccountStore", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	TubaAccountStore_private_offset = g_type_add_instance_private (tuba_account_store_type_id, sizeof (TubaAccountStorePrivate));
	return tuba_account_store_type_id;
}

GType
tuba_account_store_get_type (void)
{
	static gsize tuba_account_store_type_id__once = 0;
	if (g_once_init_enter (&tuba_account_store_type_id__once)) {
		GType tuba_account_store_type_id;
		tuba_account_store_type_id = tuba_account_store_get_type_once ();
		g_once_init_leave (&tuba_account_store_type_id__once, tuba_account_store_type_id);
	}
	return tuba_account_store_type_id__once;
}

static void
_vala_tuba_account_store_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	TubaAccountStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_TYPE_ACCOUNT_STORE, TubaAccountStore);
	switch (property_id) {
		case TUBA_ACCOUNT_STORE_SAVED_PROPERTY:
		g_value_set_object (value, tuba_account_store_get_saved (self));
		break;
		case TUBA_ACCOUNT_STORE_ACTIVE_PROPERTY:
		g_value_set_object (value, tuba_account_store_get_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tuba_account_store_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	TubaAccountStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_TYPE_ACCOUNT_STORE, TubaAccountStore);
	switch (property_id) {
		case TUBA_ACCOUNT_STORE_SAVED_PROPERTY:
		tuba_account_store_set_saved (self, g_value_get_object (value));
		break;
		case TUBA_ACCOUNT_STORE_ACTIVE_PROPERTY:
		tuba_account_store_set_active (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

