const char metrics_plugins_json_lua[] =
"local metrics = require('metrics')\n"
"local json = require('json')\n"
"local json_exporter = {}\n"
"\n"
"local function finite(value)\n"
"    if type(value) == \"string\" then\n"
"        value = tonumber(value)\n"
"        if value == nil then return nil end\n"
"    elseif type(value) == \"cdata\" then -- support number64\n"
"        return value\n"
"    elseif type(value) ~= \"number\" then\n"
"        return nil\n"
"    end\n"
"    return value > -metrics.INF and value < metrics.INF\n"
"end\n"
"\n"
"local function format_value(value)\n"
"    return finite(value) and value or tostring(value)\n"
"end\n"
"\n"
"local function format_label_pairs(label_pairs)\n"
"    local part = {}\n"
"    if next(label_pairs) ~= nil then\n"
"        for name, value in pairs(label_pairs) do\n"
"            part[tostring(name)] = format_value(value)\n"
"        end\n"
"    end\n"
"    return part\n"
"end\n"
"\n"
"local function format_observation(obs)\n"
"    local part = {\n"
"        metric_name = obs.metric_name,\n"
"        value = format_value(obs.value),\n"
"        label_pairs = format_label_pairs(obs.label_pairs),\n"
"        timestamp = obs.timestamp\n"
"    }\n"
"    return part\n"
"end\n"
"\n"
"function json_exporter.export()\n"
"    metrics.invoke_callbacks()\n"
"    local stat = {}\n"
"\n"
"    for _, c in pairs(metrics.collectors()) do\n"
"        for _, obs in ipairs(c:collect()) do\n"
"            local part = format_observation(obs)\n"
"            table.insert(stat, part)\n"
"        end\n"
"    end\n"
"    return json.encode(stat)\n"
"end\n"
"\n"
"return json_exporter\n"
""
;
