const char utils_avl_lua[] =
"local M = {}\n"
"local max = math.max\n"
"\n"
"local function create_node(key, value)\n"
"  return {\n"
"    key = key,\n"
"    value = value,\n"
"    left = nil,\n"
"    right = nil,\n"
"    height = 1,\n"
"  }\n"
"end\n"
"\n"
"local function height(node)\n"
"  if node == nil then\n"
"    return 0\n"
"  end\n"
"  return node.height\n"
"end\n"
"\n"
"local function update_height(node)\n"
"  node.height = 1 + max(height(node.left), height(node.right))\n"
"end\n"
"\n"
"local function get_balance(node)\n"
"  if node == nil then\n"
"    return 0\n"
"  end\n"
"  return height(node.left) - height(node.right)\n"
"end\n"
"\n"
"local function rotate_left(node)\n"
"    local r_subtree = node.right;\n"
"    local rl_subtree = r_subtree.left;\n"
"\n"
"    r_subtree.left = node;\n"
"    node.right = rl_subtree;\n"
"\n"
"    update_height(node)\n"
"    update_height(r_subtree)\n"
"\n"
"    return r_subtree;\n"
"end\n"
"\n"
"local function rotate_right(node)\n"
"    local l_subtree = node.left\n"
"    local lr_subtree = l_subtree.right;\n"
"\n"
"    l_subtree.right = node;\n"
"    node.left = lr_subtree;\n"
"\n"
"    update_height(node)\n"
"    update_height(l_subtree)\n"
"\n"
"    return l_subtree;\n"
"end\n"
"\n"
"local function rebalance(node, key)\n"
"  local balance = get_balance(node)\n"
"\n"
"  if -1 <= balance and balance <=1 then\n"
"    return node\n"
"  end\n"
"\n"
"  if balance > 1 and key < node.left.key then\n"
"    return rotate_right(node)\n"
"  elseif balance < -1 and key > node.right.key then\n"
"    return rotate_left(node)\n"
"  elseif balance > 1 and key > node.left.key then\n"
"    node.left = rotate_left(node.left)\n"
"    return rotate_right(node)\n"
"  elseif balance < -1 and key < node.right.key then\n"
"    node.right = rotate_right(node.right)\n"
"    return rotate_left(node)\n"
"  end\n"
"end\n"
"\n"
"function M.insert(node, key, value)\n"
"  assert(key, \"Key can't be nil\")\n"
"  if node == nil then\n"
"    return create_node(key, { value })\n"
"  end\n"
"\n"
"  if key < node.key then\n"
"    node.left = M.insert(node.left, key, value)\n"
"  elseif key > node.key then\n"
"    node.right = M.insert(node.right, key, value)\n"
"  else\n"
"    table.insert(node.value, value)\n"
"  end\n"
"\n"
"  update_height(node)\n"
"  return rebalance(node, key)\n"
"end\n"
"\n"
"function M.floor(node, key)\n"
"  if node == nil then\n"
"    return nil, nil\n"
"  end\n"
"  -- Explicit match.\n"
"  if key == node.key then\n"
"    return node.key, node.value\n"
"  elseif key < node.key then\n"
"    return M.floor(node.left, key)\n"
"  elseif key > node.key then\n"
"    local right_key, value = M.floor(node.right, key)\n"
"    right_key = right_key or node.key\n"
"    value = value or node.value\n"
"    return right_key, value\n"
"  end\n"
"end\n"
"\n"
"return M\n"
""
;
