const char init_lua[] =
"\n"
"-- init.lua -- internal file\n"
"\n"
"local ffi = require('ffi')\n"
"local loaders = require('internal.loaders')\n"
"\n"
"ffi.cdef[[\n"
"struct method_info;\n"
"\n"
"struct type_info {\n"
"    const char *name;\n"
"    const struct type_info *parent;\n"
"    const struct method_info *methods;\n"
"};\n"
"double\n"
"tarantool_uptime(void);\n"
"typedef int32_t pid_t;\n"
"pid_t getpid(void);\n"
"void\n"
"tarantool_exit(int);\n"
"]]\n"
"\n"
"local fio = require(\"fio\")\n"
"\n"
"-- A wrapper with a unique name, used in the call stack traversing.\n"
"local function __tarantool__internal__require__wrapper__()\n"
"    -- This require() may be overloaded.\n"
"    return require('log.get_callstack')\n"
"end\n"
"\n"
"-- Calculate how many times the standard require() function was overloaded.\n"
"-- E.g. if there are three user overloads, the call stack returned by\n"
"-- get_callstack will look like:\n"
"-- 7. the place where require('log') was called\n"
"-- 6. require('log') -- overloaded in this file\n"
"-- 5. __tarantool__internal__require__wrapper__\n"
"-- 4. require('log.get_callstack') -- overloaded in user module 3\n"
"-- 3. require('log.get_callstack') -- overloaded in user module 2\n"
"-- 2. require('log.get_callstack') -- overloaded in user module 1\n"
"-- 1. require('log.get_callstack') -- overloaded in this file\n"
"local function get_require_overload_count(stack)\n"
"    local wrapper_name = '__tarantool__internal__require__wrapper__'\n"
"    local count = 0\n"
"    for _, f in pairs(stack) do\n"
"        if f.name ~= nil and string.find(f.name, wrapper_name) ~= nil then\n"
"            return count + 1\n"
"        end\n"
"        count = count + 1\n"
"    end\n"
"    return 0\n"
"end\n"
"\n"
"-- Return longest common subpath of two paths.\n"
"local function get_common_subpath(path1, path2)\n"
"    local result = '/'\n"
"    path1 = path1:split('/')\n"
"    path2 = path2:split('/')\n"
"    for i = 1, math.min(#path1, #path2) do\n"
"        if path1[i] == path2[i] then\n"
"            result = fio.pathjoin(result, path1[i])\n"
"        else\n"
"            goto finish\n"
"        end\n"
"    end\n"
"::finish::\n"
"    return result == '/' and '/' or result .. '/'\n"
"end\n"
"\n"
"-- Strip a common part of cwd and path from the path.\n"
"local function strip_cwd_from_path(cwd, path)\n"
"    if not cwd or cwd:sub(1, 1) ~= '/' or\n"
"       not path or path:sub(1, 1) ~= '/' then\n"
"        return path\n"
"    end\n"
"    local common = get_common_subpath(cwd, path)\n"
"    return path:sub(#common + 1)\n"
"end\n"
"\n"
"-- Obtain the module name from the file name by removing:\n"
"-- 1. builtin/ prefixes\n"
"-- 2. path prefixes contained in package.path, package.cpath\n"
"-- 3. subpaths to the current directory\n"
"-- 4. ROCKS_LIB_PATH, ROCKS_LUA_PATH\n"
"-- 5. /init.lua and .lua suffixes\n"
"-- and by replacing all `/` with `.`\n"
"local function module_name_from_filename(filename)\n"
"    local paths = package.path .. package.cpath\n"
"    local result = filename:gsub('builtin/', '')\n"
"    for path in paths:gmatch'/([^\?]+)\\\\\?' do\n"
"        -- Escape magic characters in path.\n"
"        path = path:gsub('([^%w])', '%%%1')\n"
"        result = result:gsub('^/' .. path, '')\n"
"    end\n"
"    result = result:gsub('/init.lua', '')\n"
"    result = result:gsub('%.lua', '')\n"
"    result = strip_cwd_from_path(fio.cwd(), result)\n"
"    result = result:gsub(loaders.ROCKS_LIB_PATH .. '/', '')\n"
"    result = result:gsub(loaders.ROCKS_LUA_PATH .. '/', '')\n"
"    result = result:gsub('/', '.')\n"
"    return result\n"
"end\n"
"\n"
"-- Take the function level in the call stack as input and return\n"
"-- the name of the module in which the function is defined.\n"
"local function module_name_by_callstack_level(level)\n"
"    local info = debug.getinfo(level + 1)\n"
"    if info ~= nil and info.source:sub(1, 1) == '@' then\n"
"        local src_name = info.source:sub(2)\n"
"        return module_name_from_filename(src_name)\n"
"    end\n"
"    -- require('log') called from the interactive mode or `tarantool -e`\n"
"    return 'tarantool'\n"
"end\n"
"\n"
"-- Return current call stack.\n"
"local function get_callstack()\n"
"    local i = 2\n"
"    local stack = {}\n"
"    local info = debug.getinfo(i)\n"
"    while info ~= nil do\n"
"        stack[i] = info\n"
"        i = i + 1\n"
"        info = debug.getinfo(i)\n"
"    end\n"
"    return stack\n"
"end\n"
"\n"
"-- Overload the require() function to set the module name during require('log')\n"
"-- Note that the standard require() function may be already overloaded in a user\n"
"-- module, also there can be multiple overloads.\n"
"local real_require = require\n"
"_G.require = function(modname)\n"
"    if modname == 'log' then\n"
"        local callstack = __tarantool__internal__require__wrapper__()\n"
"        local overload_count = get_require_overload_count(callstack)\n"
"        local name = module_name_by_callstack_level(overload_count + 2)\n"
"        return real_require('log').new(name)\n"
"    elseif modname == 'log.get_callstack' then\n"
"        return get_callstack()\n"
"    end\n"
"    return real_require(modname)\n"
"end\n"
"\n"
"dostring = function(s, ...)\n"
"    local chunk, message = loadstring(s)\n"
"    if chunk == nil then\n"
"        error(message, 2)\n"
"    end\n"
"    return chunk(...)\n"
"end\n"
"\n"
"local fiber = require(\"fiber\")\n"
"local function exit(code)\n"
"    code = (type(code) == 'number') and code or 0\n"
"    ffi.C.tarantool_exit(code)\n"
"    -- Make sure we yield even if the code after\n"
"    -- os.exit() never yields. After on_shutdown\n"
"    -- fiber completes, we will never wake up again.\n"
"    local TIMEOUT_INFINITY = 500 * 365 * 86400\n"
"    while true do fiber.sleep(TIMEOUT_INFINITY) end\n"
"end\n"
"rawset(os, \"exit\", exit)\n"
"\n"
"local function uptime()\n"
"    return tonumber(ffi.C.tarantool_uptime());\n"
"end\n"
"\n"
"local function pid()\n"
"    return tonumber(ffi.C.getpid())\n"
"end\n"
"\n"
"-- Execute scripts or load modules pointed by TT_PRELOAD\n"
"-- environment variable.\n"
"local function run_preload()\n"
"    local tt_preload = os.getenv('TT_PRELOAD') or ''\n"
"    if #tt_preload == 0 then\n"
"        return\n"
"    end\n"
"    for _, script in ipairs(tt_preload:split(';')) do\n"
"        -- luacheck: ignore 542 empty if branch\n"
"        if #script == 0 then\n"
"            -- Ignore empty entries to allow duplicated semicolons\n"
"            -- and leading/trailing semicolons.\n"
"            --\n"
"            -- It simplifies construction of the environment\n"
"            -- variable value using concatenation.\n"
"        elseif script:endswith('.lua') then\n"
"            local fn = assert(loadfile(script))\n"
"            fn(script)\n"
"        else\n"
"            require(script)\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"-- Extract all fields from a table except ones that start from\n"
"-- the underscore.\n"
"--\n"
"-- Useful for __serialize.\n"
"local function filter_out_private_fields(t)\n"
"    local res = {}\n"
"    for k, v in pairs(t) do\n"
"        if not k:startswith('_') then\n"
"            res[k] = v\n"
"        end\n"
"    end\n"
"    return res\n"
"end\n"
"\n"
"local mt = {\n"
"    __serialize = filter_out_private_fields,\n"
"}\n"
"\n"
"return setmetatable({\n"
"    uptime = uptime,\n"
"    pid = pid,\n"
"    _internal = {\n"
"        strip_cwd_from_path = strip_cwd_from_path,\n"
"        module_name_from_filename = module_name_from_filename,\n"
"        run_preload = run_preload,\n"
"    },\n"
"}, mt)\n"
""
;
