const char httpc_lua[] =
"--\n"
"--  Copyright (C) 2016-2017 Tarantool AUTHORS: please see AUTHORS file.\n"
"--\n"
"--  Redistribution and use in source and binary forms, with or\n"
"--  without modification, are permitted provided that the following\n"
"--  conditions are met:\n"
"--\n"
"--  1. Redistributions of source code must retain the above\n"
"--   copyright notice, this list of conditions and the\n"
"--   following disclaimer.\n"
"--\n"
"--  2. Redistributions in binary form must reproduce the above\n"
"--   copyright notice, this list of conditions and the following\n"
"--   disclaimer in the documentation and/or other materials\n"
"--   provided with the distribution.\n"
"--\n"
"--  THIS SOFTWARE IS PROVIDED BY <COPYRIGHT HOLDER> ``AS IS'' AND\n"
"--  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED\n"
"--  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n"
"--  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL\n"
"--  <COPYRIGHT HOLDER> OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,\n"
"--  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL\n"
"--  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF\n"
"--  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR\n"
"--  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF\n"
"--  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n"
"--  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF\n"
"--  THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF\n"
"--  SUCH DAMAGE.\n"
"--\n"
"\n"
"local driver = require('http.client.lib')\n"
"\n"
"local ffi = require('ffi')\n"
"local buffer = require('buffer')\n"
"local fiber = require('fiber')\n"
"local json = require('json')\n"
"local yaml = require('yaml')\n"
"local msgpack = require('msgpack')\n"
"\n"
"local curl_mt\n"
"\n"
"local IO_TIMEOUT_DEFAULT = 10\n"
"local IO_CHUNK_DEFAULT = 2147483647\n"
"\n"
"local default_content_type = 'application/json'\n"
"\n"
"local encoders = {\n"
"    ['application/json'] = function(body, _content_type) return json.encode(body) end,\n"
"    ['application/yaml'] = function(body, _content_type) return yaml.encode(body) end,\n"
"    ['application/msgpack'] = function(body, _content_type) return msgpack.encode(body) end,\n"
"}\n"
"\n"
"local decoders = {\n"
"    ['application/json'] = function(body, _content_type) return json.decode(body) end,\n"
"    ['application/yaml'] = function(body, _content_type) return yaml.decode(body) end,\n"
"    ['application/msgpack'] = function(body, _content_type) return msgpack.decode(body) end,\n"
"}\n"
"\n"
"-- Extract all fields from a table except ones that start from\n"
"-- the underscore.\n"
"-- Copy-pasted from src/lua/init.lua.\n"
"--\n"
"-- Useful for __serialize.\n"
"local function filter_out_private_fields(t)\n"
"    local res = {}\n"
"    for k, v in pairs(t) do\n"
"        if not k:startswith('_') then\n"
"            res[k] = v\n"
"        end\n"
"    end\n"
"    return res\n"
"end\n"
"\n"
"--\n"
"--  <http> - create a new curl instance.\n"
"--\n"
"--  Parameters:\n"
"--\n"
"--  max_connections -  Maximum number of entries in the connection cache\n"
"--  max_total_connections -  Maximum number of active connections\n"
"--\n"
"--  Returns:\n"
"--  curl object or raise error()\n"
"--\n"
"\n"
"local http_new = function(opts)\n"
"\n"
"    opts = opts or {}\n"
"\n"
"    opts.max_connections = opts.max_connections or -1\n"
"    opts.max_total_connections = opts.max_total_connections or 0\n"
"\n"
"    local curl = driver.new(opts.max_connections, opts.max_total_connections)\n"
"    return setmetatable({\n"
"        curl = curl,\n"
"        encoders = table.copy(encoders),\n"
"        decoders = table.copy(decoders),\n"
"    }, curl_mt)\n"
"end\n"
"\n"
"local check_args_fmt = 'Use client:%s(...) instead of client.%s(...):'\n"
"\n"
"local function check_args(self, method)\n"
"    if type(self) ~= 'table' then\n"
"        error(check_args_fmt:format(method, method), 2)\n"
"    end\n"
"end\n"
"\n"
"--\n"
"-- RFC2616: http://www.w3.org/Protocols/rfc2616/rfc2616-sec4.html#sec4.2\n"
"--\n"
"-- Multiple message-header fields with the same field-name MAY be present\n"
"-- in a message if and only if the entire field-value for that header field\n"
"-- is defined as a comma-separated list [i.e., #(values)]. It MUST be possible\n"
"-- to combine the multiple header fields into one \"field-name: field-value\"\n"
"-- pair, without changing the semantics of the message, by appending each\n"
"-- subsequent field-value to the first, each separated by a comma. The order\n"
"-- in which header fields with the same field-name are received is therefore\n"
"-- significant to the interpretation of the combined field value, and thus\n"
"-- a proxy MUST NOT change the order of these field values when a message\n"
"-- is forwarded.\n"
"--\n"
"-- Tarantool implementation concatenates all headers by default except\n"
"-- the blacklist below.\n"
"--\n"
"\n"
"local special_headers = {\n"
"    [\"age\"] = true,\n"
"    [\"authorization\"] = true,\n"
"    [\"content-length\"] = true,\n"
"    [\"content-type\"] = true,\n"
"    [\"etag\"] = true,\n"
"    [\"expires\"] = true,\n"
"    [\"from\"] = true,\n"
"    [\"host\"] = true,\n"
"    [\"if-modified-since\"] = true,\n"
"    [\"if-unmodified-since\"] = true,\n"
"    [\"last-modified\"] = true,\n"
"    [\"location\"] = true,\n"
"    [\"max-forwards\"] = true,\n"
"    [\"proxy-authorization\"] = true,\n"
"    [\"referer\"] = true,\n"
"    [\"retry-after\"] = true,\n"
"    [\"user-agent\"] = true,\n"
"}\n"
"\n"
"local special_characters = {\n"
"    ['('] = true,\n"
"    [')'] = true,\n"
"    ['['] = true,\n"
"    [']'] = true,\n"
"    ['<'] = true,\n"
"    ['>'] = true,\n"
"    ['@'] = true,\n"
"    [','] = true,\n"
"    [';'] = true,\n"
"    [':'] = true,\n"
"    ['\\\\'] = true,\n"
"    ['\\\"'] = true,\n"
"    ['/'] = true,\n"
"    ['\?'] = true,\n"
"    ['='] = true,\n"
"    ['{'] = true,\n"
"    ['}'] = true,\n"
"    [' '] = true,\n"
"    ['\\t'] = true\n"
"}\n"
"\n"
"local option_keys = {\n"
"    [\"Expires\"] = true,\n"
"    [\"Max-Age\"] = true,\n"
"    [\"Domain\"] = true,\n"
"    [\"Path\"] = true,\n"
"    [\"Secure\"] = true,\n"
"    [\"HttpOnly\"] = true,\n"
"    [\"SameSite\"] = true,\n"
"}\n"
"\n"
"local function process_cookie(cookie, result)\n"
"    local vals = cookie:split(';')\n"
"    local val = vals[1]:split('=')\n"
"    if #val < 2 then\n"
"        return\n"
"    end\n"
"    val[1] = string.strip(val[1])\n"
"    for c in val[1]:gmatch('.') do\n"
"        if special_characters[c] then\n"
"            return\n"
"        end\n"
"    end\n"
"\n"
"    local options = {}\n"
"    table.remove(vals, 1)\n"
"    for _, opt in pairs(vals) do\n"
"        local splitted = opt:split('=')\n"
"        splitted = string.strip(splitted[1])\n"
"        if option_keys[splitted] then\n"
"            table.insert(options, string.strip(opt))\n"
"        end\n"
"    end\n"
"    result[val[1]] = {string.strip(val[2]), options}\n"
"end\n"
"\n"
"local function process_cookies(cookies)\n"
"    local result = {}\n"
"    for _, val in pairs(cookies) do\n"
"        process_cookie(val, result)\n"
"    end\n"
"    return result\n"
"end\n"
"\n"
"local function process_headers(headers)\n"
"    for header, value in pairs(headers) do\n"
"        if type(value) == 'table' then\n"
"            if special_headers[header] then\n"
"                headers[header] = value[1]\n"
"            else\n"
"                headers[header] = table.concat(value, ',')\n"
"            end\n"
"        end\n"
"    end\n"
"    return headers\n"
"end\n"
"\n"
"-- In RFC 1521, the Content-Type entity-header field indicates the media type\n"
"-- of the Entity-Body:\n"
"--\n"
"--   Content-Type   = \"Content-Type\" \":\" media-type\n"
"--\n"
"-- Where media-type is defined as follows:\n"
"--\n"
"--   media-type     = type \"/\" subtype *( \";\" parameter )\n"
"--\n"
"-- See RFC 1521, https://www.w3.org/Protocols/HTTP/1.0/spec.html#Media-Types\n"
"-- Function splits header with content type for part with type, part with\n"
"-- subtype and part with parameters and returns a string \"type/subtype\".\n"
"local function extract_mime_type(content_type)\n"
"    if content_type == nil then\n"
"        return nil\n"
"    end\n"
"    if type(content_type) ~= \"string\" then\n"
"        error('content type must be a string')\n"
"    end\n"
"    return content_type:split(';', 1)[1]:strip()\n"
"end\n"
"\n"
"local function string_lower(str)\n"
"    if type(str) == 'string' then\n"
"        str = str:lower()\n"
"    end\n"
"    return str\n"
"end\n"
"\n"
"-- Get a value from map by case-insensitive key.\n"
"-- Returns the value in the lower case on the first match.\n"
"local function get_icase(t, key)\n"
"    key = string_lower(key)\n"
"    for k, v in pairs(t) do\n"
"        k = string_lower(k)\n"
"        if k == key then\n"
"            v = string_lower(v)\n"
"            return v\n"
"        end\n"
"    end\n"
"\n"
"    return nil\n"
"end\n"
"\n"
"local function encode_body(body, content_type, encoders)\n"
"    local raw_body\n"
"    local body_type = type(body)\n"
"    local mime_type\n"
"    if body == nil then\n"
"        raw_body = ''\n"
"    elseif body_type == 'cdata' or\n"
"           body_type == 'userdata' or\n"
"           body_type == 'table' then\n"
"        mime_type = extract_mime_type(content_type)\n"
"        mime_type = string_lower(mime_type)\n"
"        local encoder = encoders[mime_type]\n"
"        if encoder == nil then\n"
"            local msg = 'Unable to encode body: encode function is not found (%s)'\n"
"            error(msg:format(content_type))\n"
"        end\n"
"        local ok, res = pcall(encoder, body, content_type)\n"
"        if not ok then\n"
"            error(('Unable to encode body: %s'):format(res))\n"
"        end\n"
"        raw_body = res\n"
"    elseif body_type == 'number' or\n"
"           body_type == 'string' or\n"
"           body_type == 'boolean' then\n"
"        raw_body = tostring(body)\n"
"    else\n"
"        error(('Unsupported body type: %s'):format(body_type))\n"
"    end\n"
"\n"
"    return raw_body\n"
"end\n"
"\n"
"local default_decoder = function(raw_body, _content_type)\n"
"    return json.decode(raw_body)\n"
"end\n"
"\n"
"local function decode_body(response)\n"
"    if response.body == nil then\n"
"        error('Unable to decode body: body is empty')\n"
"    end\n"
"    local headers = response.headers or {}\n"
"    local content_type = get_icase(headers, 'content-type')\n"
"    local mime_type = extract_mime_type(content_type)\n"
"    local decoder = default_decoder\n"
"    if mime_type ~= nil then\n"
"        mime_type = string_lower(mime_type)\n"
"        decoder = response._decoders[mime_type]\n"
"    end\n"
"    if decoder == nil then\n"
"        local msg = 'Unable to decode body: decode function is not found (%s)'\n"
"        error(msg:format(content_type))\n"
"    end\n"
"    if type(decoder) ~= 'function' then\n"
"        local msg = 'Unable to decode body: decode function is not a function (%s)'\n"
"        error(msg:format(content_type))\n"
"    end\n"
"    local ok, res = pcall(decoder, response.body, content_type)\n"
"    if not ok then\n"
"        error(('Unable to decode body: %s'):format(res))\n"
"    end\n"
"\n"
"    return res\n"
"end\n"
"\n"
"local function encode_url_params(params, http_method)\n"
"    assert(http_method ~= nil)\n"
"    local uri = require(\"uri\")\n"
"    local uri_escape_opts = uri.FORM_URLENCODED\n"
"    if http_method == \"GET\" or\n"
"       http_method == \"HEAD\" or\n"
"       http_method == \"DELETE\" then\n"
"        uri_escape_opts = uri.QUERY_PART\n"
"    end\n"
"\n"
"    local query_encoder = uri._internal.params\n"
"    local ok, res = pcall(query_encoder, params, uri_escape_opts)\n"
"    if not ok then\n"
"        error(res)\n"
"    end\n"
"    return res\n"
"end\n"
"\n"
"local function check_limit(self, limit)\n"
"    if self._internal.rbuf:size() >= limit then\n"
"        return limit\n"
"    end\n"
"    return nil\n"
"end\n"
"\n"
"local function check_delimiter(self, limit, eols)\n"
"    if limit == 0 then\n"
"        return 0\n"
"    end\n"
"    local rbuf = self._internal.rbuf\n"
"    if rbuf:size() == 0 then\n"
"        return nil\n"
"    end\n"
"\n"
"    local shortest\n"
"    for _, eol in ipairs(eols) do\n"
"        local data = ffi.C.memmem(rbuf.rpos, rbuf:size(), eol, #eol)\n"
"        if data ~= nil then\n"
"            local len = ffi.cast('char *', data) - rbuf.rpos + #eol\n"
"            if shortest == nil or shortest > len then\n"
"                shortest = len\n"
"            end\n"
"        end\n"
"    end\n"
"    if shortest ~= nil and shortest <= limit then\n"
"        return shortest\n"
"    elseif limit <= rbuf:size() then\n"
"        return limit\n"
"    end\n"
"    return nil\n"
"end\n"
"\n"
"local function io_read(self, opts, timeout)\n"
"    timeout = timeout or IO_TIMEOUT_DEFAULT\n"
"    local chunk\n"
"    local delimiter\n"
"    local check\n"
"    if type(opts) == 'number' then\n"
"        chunk = opts\n"
"        check = check_limit\n"
"    elseif type(opts) == 'string' then\n"
"        chunk = IO_CHUNK_DEFAULT\n"
"        delimiter = {opts}\n"
"        check = check_delimiter\n"
"    elseif type(opts) == 'table' then\n"
"        chunk = opts.chunk or IO_CHUNK_DEFAULT\n"
"        delimiter = opts.delimiter\n"
"        if delimiter == nil then\n"
"            check = check_limit\n"
"        elseif type(delimiter) == 'string' then\n"
"            delimiter = {delimiter}\n"
"            check = check_delimiter\n"
"        elseif type(delimiter) == 'table' then\n"
"            check = check_delimiter\n"
"        end\n"
"    else\n"
"        error('Usage: io:read(delimiter|chunk|{delimiter = x, chunk = x}, timeout)')\n"
"    end\n"
"\n"
"    if chunk < 0 then\n"
"        error('io:read(): chunk can not be negative')\n"
"    end\n"
"\n"
"    chunk = math.min(chunk, IO_CHUNK_DEFAULT)\n"
"    local rbuf = self._internal.rbuf\n"
"    if rbuf == nil then\n"
"        rbuf = buffer.ibuf()\n"
"        self._internal.rbuf = rbuf\n"
"    end\n"
"\n"
"    local len = check(self, chunk, delimiter)\n"
"    if len ~= nil then\n"
"        local data = ffi.string(rbuf.rpos, len)\n"
"        rbuf.rpos = rbuf.rpos + len\n"
"        return data\n"
"    end\n"
"\n"
"    local deadline = fiber.clock() + timeout\n"
"    repeat\n"
"        local to_read = math.min(chunk - rbuf:size(), buffer.READAHEAD)\n"
"        local data = rbuf:reserve(to_read)\n"
"\n"
"        local res = self._internal.io:read(data, rbuf:unused(), timeout)\n"
"        if res == 0 then -- eof\n"
"            self._errno = nil\n"
"            local len = rbuf:size()\n"
"            local data = ffi.string(rbuf.rpos, len)\n"
"            rbuf.rpos = rbuf.rpos + len\n"
"            return data\n"
"        else\n"
"            rbuf.wpos = rbuf.wpos + res\n"
"            local len = check(self, chunk, delimiter)\n"
"            if len ~= nil then\n"
"                self._errno = nil\n"
"                local data = ffi.string(rbuf.rpos, len)\n"
"                rbuf.rpos = rbuf.rpos + len\n"
"                return data\n"
"            end\n"
"        end\n"
"        timeout = deadline - fiber.clock()\n"
"    until timeout < 0\n"
"    return nil\n"
"end\n"
"\n"
"local function io_write(self, data, timeout)\n"
"    timeout = timeout or IO_TIMEOUT_DEFAULT\n"
"    return self._internal.io:write(data, #data, timeout)\n"
"end\n"
"\n"
"local function io_finish(self, timeout)\n"
"    timeout = timeout or IO_TIMEOUT_DEFAULT\n"
"    self[\"status\"], self[\"reason\"] = self._internal.io:finish(timeout)\n"
"end\n"
"\n"
"--\n"
"--  <request> This function does HTTP request\n"
"--\n"
"--  Parameters:\n"
"--\n"
"--  method  - HTTP method, like GET, POST, PUT and so on\n"
"--  url     - HTTP url, like https://tarantool.org/doc\n"
"--  body    - this parameter is optional, you may use it for passing\n"
"--            data to a server. Like 'My text string!'\n"
"--  options - this is a table of options.\n"
"--\n"
"--      ca_path - a path to ssl certificate dir;\n"
"--\n"
"--      ca_file - a path to ssl certificate file;\n"
"--\n"
"--      unix_socket - a path to Unix domain socket;\n"
"--\n"
"--      verify_host - set on/off verification of the certificate's name (CN)\n"
"--          against host;\n"
"--\n"
"--      verify_peer - set on/off verification of the peer's SSL certificate;\n"
"--\n"
"--      ssl_key - set path to the file with private key for TLS and SSL client\n"
"--          certificate;\n"
"--\n"
"--      ssl_cert - set path to the file with SSL client certificate;\n"
"--\n"
"--      proxy - set a proxy to use;\n"
"--\n"
"--      proxy_port - set a port number the proxy listens on;\n"
"--\n"
"--      proxy_user_pwd - set a user name and a password to use in authentication;\n"
"--\n"
"--      no_proxy - disable proxy use for specific hosts;\n"
"--\n"
"--      headers - a table of HTTP headers;\n"
"--\n"
"--      keepalive_idle & keepalive_interval -\n"
"--          non-universal keepalive knobs (Linux, AIX, HP-UX, more);\n"
"--\n"
"--      low_speed_time & low_speed_limit -\n"
"--          If the download receives less than \"low speed limit\" bytes/second\n"
"--          during \"low speed time\" seconds, the operations is aborted.\n"
"--          You could i.e if you have a pretty high speed connection, abort if\n"
"--          it is less than 2000 bytes/sec during 20 seconds;\n"
"--\n"
"--      timeout - time-out the read operation and\n"
"--          waiting for the curl api request after this amount of seconds;\n"
"--\n"
"--      max_header_name_length - maximum length of a response header;\n"
"--\n"
"--      verbose - set on/off verbose mode;\n"
"--\n"
"--      interface - source interface for outgoing traffic;\n"
"--\n"
"--      follow_location - whether the client will follow 'Location' header that\n"
"--          a server sends as part of an 3xx response;\n"
"--\n"
"--      accept_encoding - enables automatic decompression of HTTP responses;\n"
"--\n"
"--      chunked - enables chunked io interface;\n"
"--\n"
"--      params - a table with query parameters;\n"
"--\n"
"--  Returns:\n"
"--      {\n"
"--          status=NUMBER (if the request is completed),\n"
"--          reason=ERRMSG (if the request is completed),\n"
"--          body=STRING (if !opts.chunked == false),\n"
"--          headers=STRING,\n"
"--          errmsg=STRING (if the request is completed),\n"
"--          write=FUNCTION (if opts.chunked == true),\n"
"--          read=FUNCTION (if opts.chunked == true),\n"
"--          finish=FUNCTION (if opts.chunked == true),\n"
"--      }\n"
"--  Raises error() on invalid arguments and OOM\n"
"--\n"
"\n"
"curl_mt = {\n"
"    __index = {\n"
"        --\n"
"        --  <request> see above <request>\n"
"        --\n"
"        request = function(self, method, url, body, opts)\n"
"            if not method or not url then\n"
"                error('request(method, url[, body, [options]])')\n"
"            end\n"
"            method = method:upper()\n"
"\n"
"            opts = opts or {}\n"
"            opts.headers = opts.headers or {}\n"
"\n"
"            local encoded_params\n"
"            if opts.params then\n"
"                encoded_params = encode_url_params(opts.params, method)\n"
"            end\n"
"            local url_with_params = url\n"
"            if encoded_params then\n"
"                if method == \"GET\" or\n"
"                   method == \"HEAD\" or\n"
"                   method == \"DELETE\" then\n"
"                    url_with_params = (\"%s\?%s\"):format(url, encoded_params)\n"
"                elseif body then\n"
"                    error('use either body or http params')\n"
"                else\n"
"                    body = encoded_params\n"
"                end\n"
"            end\n"
"\n"
"            if method == 'PATCH' or\n"
"               method == 'POST' or\n"
"               method == 'PUT' then\n"
"                local content_type = get_icase(opts.headers, 'content-type')\n"
"                if content_type == nil then\n"
"                    content_type = default_content_type\n"
"                    local body_type = type(body)\n"
"                    if body_type == 'cdata' or\n"
"                       body_type == 'userdata' or\n"
"                       body_type == 'table' then\n"
"                        opts.headers['content-type'] = default_content_type\n"
"                    end\n"
"                end\n"
"                body = encode_body(body, content_type, self.encoders)\n"
"            end\n"
"            local resp = self.curl:request(method, url_with_params, body, opts or {})\n"
"\n"
"            if resp and resp.headers then\n"
"                if resp.headers['set-cookie'] ~= nil then\n"
"                    resp.cookies = process_cookies(resp.headers['set-cookie'])\n"
"                end\n"
"                resp.headers = process_headers(resp.headers)\n"
"            end\n"
"\n"
"            if not opts.chunked then\n"
"                resp.url = url_with_params\n"
"                resp._decoders = self.decoders\n"
"                return setmetatable(resp, {\n"
"                    __serialize = filter_out_private_fields,\n"
"                    __index = {\n"
"                        decode = decode_body,\n"
"                    },\n"
"                })\n"
"            else\n"
"                return setmetatable(resp, {\n"
"                    __index = {\n"
"                        read = io_read,\n"
"                        write = io_write,\n"
"                        finish = io_finish,\n"
"                    },\n"
"                })\n"
"            end\n"
"        end,\n"
"\n"
"        --\n"
"        -- <get> - see <request>\n"
"        --\n"
"        get = function(self, url, options)\n"
"            check_args(self, 'get')\n"
"            return self:request('GET', url, nil, options)\n"
"        end,\n"
"\n"
"        --\n"
"        -- <post> - see <request>\n"
"        --\n"
"        post = function(self, url, body, options)\n"
"            check_args(self, 'post')\n"
"            return self:request('POST', url, body, options)\n"
"        end,\n"
"\n"
"        --\n"
"        -- <put> - see <request>\n"
"        --\n"
"        put = function(self, url, body, options)\n"
"            check_args(self, 'put')\n"
"            return self:request('PUT', url, body, options)\n"
"        end,\n"
"\n"
"        --\n"
"        -- <patch> - see <request>\n"
"        --\n"
"        patch = function(self, url, body, options)\n"
"            check_args(self, 'patch')\n"
"            return self:request('PATCH', url, body, options)\n"
"        end,\n"
"\n"
"        --\n"
"        -- <options> see <request>\n"
"        --\n"
"        options = function(self, url, options)\n"
"            check_args(self, 'options')\n"
"            return self:request('OPTIONS', url, nil, options)\n"
"        end,\n"
"\n"
"        --\n"
"        -- <head> see <request>\n"
"        --\n"
"        head = function(self, url, options)\n"
"            check_args(self, 'head')\n"
"            return self:request('HEAD', url, nil, options)\n"
"        end,\n"
"        --\n"
"        -- <delete> see <request>\n"
"        --\n"
"        delete = function(self, url, options)\n"
"            check_args(self, 'delete')\n"
"            return self:request('DELETE', url, nil, options)\n"
"        end,\n"
"\n"
"        --\n"
"        -- <trace> see <request>\n"
"        --\n"
"        trace = function(self, url, options)\n"
"            check_args(self, 'trace')\n"
"            return self:request('TRACE', url, nil, options)\n"
"        end,\n"
"\n"
"        --\n"
"        -- <connect> see <request>\n"
"        --\n"
"        connect = function(self, url, options)\n"
"            check_args(self, 'connect')\n"
"            return self:request('CONNECT', url, nil, options)\n"
"        end,\n"
"\n"
"        --\n"
"        -- <stat> - this function returns a table with many values of statistic.\n"
"        --\n"
"        -- Returns {\n"
"        --\n"
"        --  active_requests - this is number of currently executing requests\n"
"        --\n"
"        --  sockets_added -\n"
"        --  this is a total number of added sockets into libev loop\n"
"        --\n"
"        --  sockets_deleted -\n"
"        --  this is a total number of deleted sockets from libev\n"
"        --                      loop\n"
"        --\n"
"        --  total_requests - this is a total number of requests\n"
"        --\n"
"        --  http_200_responses -\n"
"        --  this is a total number of requests which have\n"
"        --              returned a code HTTP 200\n"
"        --\n"
"        --  http_other_responses -\n"
"        --      this is a total number of requests which have\n"
"        --      requests not a HTTP 200\n"
"        --\n"
"        --  failed_requests - this is a total number of requests which have\n"
"        --      failed (included systeme erros, curl errors, HTTP\n"
"        --      errors and so on)\n"
"        --  }\n"
"        --  or error()\n"
"        --\n"
"        stat = function(self)\n"
"            return self.curl:stat()\n"
"        end,\n"
"\n"
"    },\n"
"}\n"
"\n"
"--\n"
"-- Export\n"
"--\n"
"local http_default = http_new()\n"
"local this_module = {\n"
"    new = http_new,\n"
"    encoders = table.copy(encoders),\n"
"    decoders = table.copy(decoders),\n"
"    _internal = {\n"
"        default_content_type = default_content_type,\n"
"        encode_body = encode_body,\n"
"        decode_body = decode_body,\n"
"        extract_mime_type = extract_mime_type,\n"
"        get_icase = get_icase,\n"
"    }\n"
"}\n"
"\n"
"local function http_default_wrap(fname)\n"
"    return function(...) return http_default[fname](http_default, ...) end\n"
"end\n"
"\n"
"for _, name in ipairs({ 'get', 'delete', 'trace', 'options', 'head',\n"
"                     'connect', 'post', 'put', 'patch', 'request'}) do\n"
"    this_module[name] = http_default_wrap(name)\n"
"end\n"
"\n"
"return this_module\n"
""
;
