const char tuple_lua[] =
"-- tuple.lua (internal file)\n"
"\n"
"local ffi = require('ffi')\n"
"local msgpackffi = require('msgpackffi')\n"
"local fun = require('fun')\n"
"local buffer = require('buffer')\n"
"local internal = box.internal\n"
"local cord_ibuf_take = buffer.internal.cord_ibuf_take\n"
"local cord_ibuf_put = buffer.internal.cord_ibuf_put\n"
"\n"
"ffi.cdef[[\n"
"/** \\cond public */\n"
"\n"
"typedef struct tuple box_tuple_t;\n"
"\n"
"int\n"
"box_tuple_ref(box_tuple_t *tuple);\n"
"\n"
"void\n"
"box_tuple_unref(box_tuple_t *tuple);\n"
"\n"
"uint32_t\n"
"box_tuple_field_count(box_tuple_t *tuple);\n"
"\n"
"size_t\n"
"box_tuple_bsize(box_tuple_t *tuple);\n"
"\n"
"ssize_t\n"
"box_tuple_to_buf(box_tuple_t *tuple, char *buf, size_t size);\n"
"\n"
"const char *\n"
"box_tuple_field(box_tuple_t *tuple, uint32_t i);\n"
"\n"
"typedef struct tuple_iterator box_tuple_iterator_t;\n"
"\n"
"box_tuple_iterator_t *\n"
"box_tuple_iterator(box_tuple_t *tuple);\n"
"\n"
"void\n"
"box_tuple_iterator_free(box_tuple_iterator_t *it);\n"
"\n"
"uint32_t\n"
"box_tuple_position(box_tuple_iterator_t *it);\n"
"\n"
"void\n"
"box_tuple_rewind(box_tuple_iterator_t *it);\n"
"\n"
"const char *\n"
"box_tuple_seek(box_tuple_iterator_t *it, uint32_t field_no);\n"
"\n"
"const char *\n"
"box_tuple_next(box_tuple_iterator_t *it);\n"
"\n"
"/** \\endcond public */\n"
"\n"
"box_tuple_t *\n"
"box_tuple_update(box_tuple_t *tuple, const char *expr, const char *expr_end);\n"
"\n"
"box_tuple_t *\n"
"box_tuple_upsert(box_tuple_t *tuple, const char *expr, const char *expr_end);\n"
"]]\n"
"\n"
"local builtin = ffi.C\n"
"\n"
"local tuple_t = ffi.typeof('box_tuple_t')\n"
"local const_tuple_ref_t = ffi.typeof('box_tuple_t&')\n"
"\n"
"local is_tuple = function(tuple)\n"
"    return tuple ~= nil and type(tuple) == 'cdata' and ffi.istype(const_tuple_ref_t, tuple)\n"
"end\n"
"\n"
"local encode_fix = msgpackffi.internal.encode_fix\n"
"local encode_array = msgpackffi.internal.encode_array\n"
"local encode_r = msgpackffi.internal.encode_r\n"
"\n"
"local tuple_encode = function(tmpbuf, obj)\n"
"    if obj == nil then\n"
"        encode_fix(tmpbuf, 0x90, 0)  -- empty array\n"
"    elseif is_tuple(obj) then\n"
"        encode_r(tmpbuf, obj, 1)\n"
"    elseif type(obj) == \"table\" then\n"
"        local obj_size = #obj\n"
"        if obj_size == 0 and not rawequal(next(obj), nil) then\n"
"            -- dictionary cannot represent a tuple\n"
"            return box.error(box.error.TUPLE_NOT_ARRAY)\n"
"        end\n"
"        encode_array(tmpbuf, obj_size)\n"
"        for i = 1, obj_size, 1 do\n"
"            encode_r(tmpbuf, obj[i], 1)\n"
"        end\n"
"    else\n"
"        encode_fix(tmpbuf, 0x90, 1)  -- array of one element\n"
"        encode_r(tmpbuf, obj, 1)\n"
"    end\n"
"    return tmpbuf.rpos, tmpbuf.wpos\n"
"end\n"
"\n"
"local tuple_gc = function(tuple)\n"
"    builtin.box_tuple_unref(tuple)\n"
"end\n"
"\n"
"local tuple_bless = function(tuple)\n"
"    -- overflow checked by tuple_bless() in C\n"
"    builtin.box_tuple_ref(tuple)\n"
"    -- must never fail:\n"
"    -- XXX: If we use tail call (instead of creating a new frame\n"
"    -- for a call just use the top one) here, then JIT tries to\n"
"    -- compile return from `ffi.gc()` to the frame below. This\n"
"    -- aborts the trace recording with the error \"NYI: return to\n"
"    -- lower frame\". So avoid tail call and use additional stack\n"
"    -- slots (for the local variable and the frame).\n"
"    local tuple_ref = ffi.gc(ffi.cast(const_tuple_ref_t, tuple), tuple_gc)\n"
"    return tuple_ref\n"
"end\n"
"\n"
"local tuple_check = function(tuple, usage)\n"
"    if not is_tuple(tuple) then\n"
"        error('Usage: ' .. usage)\n"
"    end\n"
"end\n"
"\n"
"local tuple_iterator_t = ffi.typeof('box_tuple_iterator_t')\n"
"local tuple_iterator_ref_t = ffi.typeof('box_tuple_iterator_t &')\n"
"\n"
"local function tuple_iterator(tuple)\n"
"    local it = builtin.box_tuple_iterator(tuple)\n"
"    if it == nil then\n"
"        box.error()\n"
"    end\n"
"    return ffi.gc(ffi.cast(tuple_iterator_ref_t, it),\n"
"        builtin.box_tuple_iterator_free)\n"
"end\n"
"\n"
"local function tuple_iterator_next(it, tuple, pos)\n"
"    if pos == nil then\n"
"        pos = 0\n"
"    elseif type(pos) ~= \"number\" then\n"
"         error(\"error: invalid key to 'next'\")\n"
"    end\n"
"    local curpos = builtin.box_tuple_position(it)\n"
"    local field\n"
"    if curpos == pos then\n"
"        -- Sequential iteration\n"
"        field = builtin.box_tuple_next(it)\n"
"    else\n"
"        -- Seek\n"
"        builtin.box_tuple_rewind(it)\n"
"        field = builtin.box_tuple_seek(it, pos);\n"
"    end\n"
"    if field == nil then\n"
"        if #tuple == pos then\n"
"            -- No more fields, stop iteration\n"
"            return nil\n"
"        else\n"
"            -- Invalid pos\n"
"            error(\"error: invalid key to 'next'\")\n"
"        end\n"
"    end\n"
"    -- () used to shrink the return stack to one value\n"
"    return pos + 1, (msgpackffi.decode_unchecked(field))\n"
"end;\n"
"\n"
"-- See http://www.lua.org/manual/5.2/manual.html#pdf-next\n"
"local function tuple_next(tuple, pos)\n"
"    tuple_check(tuple, \"tuple:next(tuple[, pos])\")\n"
"    if pos == nil then\n"
"        pos = 0\n"
"    end\n"
"    local field = builtin.box_tuple_field(tuple, pos)\n"
"    if field == nil then\n"
"        return nil\n"
"    end\n"
"    return pos + 1, (msgpackffi.decode_unchecked(field))\n"
"end\n"
"\n"
"-- See http://www.lua.org/manual/5.2/manual.html#pdf-ipairs\n"
"local function tuple_ipairs(tuple, pos)\n"
"    tuple_check(tuple, \"tuple:pairs(tuple[, pos])\")\n"
"    local it = tuple_iterator(tuple)\n"
"    return fun.wrap(it, tuple, pos)\n"
"end\n"
"\n"
"local function tuple_totable(tuple, i, j)\n"
"    tuple_check(tuple, \"tuple:totable([from[, to]])\");\n"
"    local it = tuple_iterator(tuple)\n"
"    builtin.box_tuple_rewind(it)\n"
"    local field\n"
"    if i ~= nil then\n"
"        if i < 1 then\n"
"            error('tuple.totable: invalid second argument')\n"
"        end\n"
"        field = builtin.box_tuple_seek(it, i - 1)\n"
"    else\n"
"        i = 1\n"
"        field = builtin.box_tuple_next(it)\n"
"    end\n"
"    if j ~= nil then\n"
"        if j <= 0 then\n"
"            error('tuple.totable: invalid third argument')\n"
"        end\n"
"    else\n"
"        j = 4294967295\n"
"    end\n"
"    local ret = {}\n"
"    while field ~= nil and i <= j do\n"
"        local val = msgpackffi.decode_unchecked(field)\n"
"        table.insert(ret, val)\n"
"        i = i + 1\n"
"        field = builtin.box_tuple_next(it)\n"
"    end\n"
"    return setmetatable(ret, msgpackffi.array_mt)\n"
"end\n"
"\n"
"local function tuple_unpack(tuple, i, j)\n"
"    return unpack(tuple_totable(tuple, i, j))\n"
"end\n"
"\n"
"local function tuple_find(tuple, offset, val)\n"
"    tuple_check(tuple, \"tuple:find([offset, ]val)\");\n"
"    if val == nil then\n"
"        val = offset\n"
"        offset = 0\n"
"    end\n"
"    local r = tuple:pairs(offset):index(val)\n"
"    return r ~= nil and offset + r or nil\n"
"end\n"
"\n"
"local function tuple_findall(tuple, offset, val)\n"
"    tuple_check(tuple, \"tuple:findall([offset, ]val)\");\n"
"    if val == nil then\n"
"        val = offset\n"
"        offset = 0\n"
"    end\n"
"    return tuple:pairs(offset):indexes(val)\n"
"        :map(function(i) return offset + i end)\n"
"        :totable()\n"
"end\n"
"\n"
"local function tuple_update(tuple, expr)\n"
"    tuple_check(tuple, \"tuple:update({ { op, field, arg}+ })\");\n"
"    if type(expr) ~= 'table' then\n"
"        error(\"Usage: tuple:update({ { op, field, arg}+ })\")\n"
"    end\n"
"    local ibuf = cord_ibuf_take()\n"
"    local pexpr, pexpr_end = tuple_encode(ibuf, expr)\n"
"    local tuple = builtin.box_tuple_update(tuple, pexpr, pexpr_end)\n"
"    cord_ibuf_put(ibuf)\n"
"    if tuple == nil then\n"
"        return box.error()\n"
"    end\n"
"    return tuple_bless(tuple)\n"
"end\n"
"\n"
"local function tuple_upsert(tuple, expr)\n"
"    tuple_check(tuple, \"tuple:upsert({ { op, field, arg}+ })\");\n"
"    if type(expr) ~= 'table' then\n"
"        error(\"Usage: tuple:upsert({ { op, field, arg}+ })\")\n"
"    end\n"
"    local ibuf = cord_ibuf_take()\n"
"    local pexpr, pexpr_end = tuple_encode(ibuf, expr)\n"
"    local tuple = builtin.box_tuple_upsert(tuple, pexpr, pexpr_end)\n"
"    cord_ibuf_put(ibuf)\n"
"    if tuple == nil then\n"
"        return box.error()\n"
"    end\n"
"    return tuple_bless(tuple)\n"
"end\n"
"\n"
"-- Set encode hooks for msgpackffi\n"
"local function tuple_to_msgpack(buf, tuple)\n"
"    assert(ffi.istype(tuple_t, tuple))\n"
"    local bsize = builtin.box_tuple_bsize(tuple)\n"
"    buf:reserve(bsize)\n"
"    builtin.box_tuple_to_buf(tuple, buf.wpos, bsize)\n"
"    buf.wpos = buf.wpos + bsize\n"
"end\n"
"\n"
"local function tuple_bsize(tuple)\n"
"    tuple_check(tuple, \"tuple:bsize()\");\n"
"    return tonumber(builtin.box_tuple_bsize(tuple))\n"
"end\n"
"\n"
"msgpackffi.on_encode(const_tuple_ref_t, tuple_to_msgpack)\n"
"\n"
"local function tuple_field_by_path(tuple, path)\n"
"    tuple_check(tuple, \"tuple['field_name']\");\n"
"    return internal.tuple.tuple_field_by_path(tuple, path)\n"
"end\n"
"\n"
"local methods = {\n"
"    [\"next\"]        = tuple_next;\n"
"    [\"ipairs\"]      = tuple_ipairs;\n"
"    [\"pairs\"]       = tuple_ipairs; -- just alias for ipairs()\n"
"    [\"slice\"]       = internal.tuple.slice;\n"
"    [\"transform\"]   = internal.tuple.transform;\n"
"    [\"find\"]        = tuple_find;\n"
"    [\"findall\"]     = tuple_findall;\n"
"    [\"unpack\"]      = tuple_unpack;\n"
"    [\"totable\"]     = tuple_totable;\n"
"    [\"update\"]      = tuple_update;\n"
"    [\"upsert\"]      = tuple_upsert;\n"
"    [\"bsize\"]       = tuple_bsize;\n"
"    [\"tomap\"]       = internal.tuple.tuple_to_map;\n"
"}\n"
"\n"
"-- Aliases for tuple:methods().\n"
"for k, v in pairs(methods) do\n"
"    box.tuple[k] = v\n"
"end\n"
"\n"
"methods[\"__serialize\"] = tuple_totable -- encode hook for msgpack/yaml/json\n"
"\n"
"local tuple_field = function(tuple, field_n)\n"
"    local field = builtin.box_tuple_field(tuple, field_n - 1)\n"
"    if field == nil then\n"
"        return nil\n"
"    end\n"
"    -- Use () to shrink stack to the first return value\n"
"    return (msgpackffi.decode_unchecked(field))\n"
"end\n"
"\n"
"ffi.metatype(tuple_t, {\n"
"    __len = function(tuple)\n"
"        return builtin.box_tuple_field_count(tuple)\n"
"    end;\n"
"    __tostring = internal.tuple.tostring;\n"
"    __index = function(tuple, key)\n"
"        if type(key) == \"number\" then\n"
"            return tuple_field(tuple, key)\n"
"        elseif type(key) == \"string\" then\n"
"            -- Try to get a field by JSON path. If it was not\n"
"            -- found (rc ~= 0) then return a method from the\n"
"            -- vtable. If a collision occurred, then fields have\n"
"            -- higher priority. For example, if a tuple T has a\n"
"            -- field with name 'bsize', then T.bsize returns\n"
"            -- field value, not tuple_bsize function. To access\n"
"            -- hidden methods use\n"
"            -- 'box.tuple.<method_name>(T, [args...])'.\n"
"            local res = tuple_field_by_path(tuple, key)\n"
"            if res ~= nil then\n"
"                return res\n"
"            end\n"
"        end\n"
"        return methods[key]\n"
"    end;\n"
"    __eq = function(tuple_a, tuple_b)\n"
"        -- Two tuple are considered equal if they have same memory address\n"
"        return ffi.cast('void *', tuple_a) == ffi.cast('void *', tuple_b);\n"
"    end;\n"
"    __pairs = tuple_ipairs;  -- Lua 5.2 compatibility\n"
"    __ipairs = tuple_ipairs; -- Lua 5.2 compatibility\n"
"})\n"
"\n"
"ffi.metatype(tuple_iterator_t, {\n"
"    __call = tuple_iterator_next;\n"
"    __tostring = function(self) return \"<tuple iterator>\" end;\n"
"})\n"
"\n"
"-- Free methods, which are not needed anymore.\n"
"internal.tuple.slice = nil\n"
"internal.tuple.transform = nil\n"
"internal.tuple.tuple_to_map = nil\n"
"internal.tuple.tostring = nil\n"
"\n"
"-- internal api for box.select and iterators\n"
"internal.tuple.bless = tuple_bless\n"
"internal.tuple.encode = tuple_encode\n"
"\n"
"-- Public API, additional to implemented in C.\n"
"\n"
"-- is() is implemented in Lua, because then it is\n"
"-- easy to be JITed.\n"
"box.tuple.is = is_tuple\n"
""
;
