/* OperatingSystemView.c generated by valac 0.56.13, the Vala compiler
 * generated from OperatingSystemView.vala, do not modify */

/*
* Copyright 2020–2021 elementary, Inc. (https://elementary.io)
*           2015 Ivo Nunes, Akshay Shekher
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "about.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <granite.h>
#include <glib-object.h>
#include <gio/gdesktopappinfo.h>
#include <sys/utsname.h>
#include <handy.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <pango/pango.h>

enum  {
	ABOUT_OPERATING_SYSTEM_VIEW_0_PROPERTY,
	ABOUT_OPERATING_SYSTEM_VIEW_NUM_PROPERTIES
};
static GParamSpec* about_operating_system_view_properties[ABOUT_OPERATING_SYSTEM_VIEW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _AboutOperatingSystemViewGetUpstreamReleaseData AboutOperatingSystemViewGetUpstreamReleaseData;
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_settings_schema_source_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_source_unref (var), NULL)))
typedef struct _Block6Data Block6Data;

struct _AboutOperatingSystemViewPrivate {
	gchar* support_url;
	GtkGrid* software_grid;
};

struct _AboutOperatingSystemViewGetUpstreamReleaseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AboutOperatingSystemView* self;
	GFile* file;
	GFile* _tmp0_;
	gchar* upstream_release;
	GFileInputStream* _tmp1_;
	GFile* _tmp2_;
	GFileInputStream* _tmp3_;
	GDataInputStream* dis;
	GDataInputStream* _tmp4_;
	gchar* line;
	gchar* _tmp5_;
	GDataInputStream* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar** distrib_component;
	const gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint distrib_component_length1;
	gint _distrib_component_size_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar* _tmp16_;
	gboolean _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gchar* _tmp24_;
	GError* e;
	GError* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	GtkLabel* based_off;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GtkLabel* _tmp31_;
	GtkLabel* _tmp32_;
	GtkGrid* _tmp33_;
	GtkLabel* _tmp34_;
	GtkGrid* _tmp35_;
	GError* _inner_error0_;
};

struct _Block6Data {
	int _ref_count_;
	AboutOperatingSystemView* self;
	GDesktopAppInfo* appcenter_info;
};

static gint AboutOperatingSystemView_private_offset;
static gpointer about_operating_system_view_parent_class = NULL;

static void about_operating_system_view_get_upstream_release_data_free (gpointer _data);
static void about_operating_system_view_get_upstream_release (AboutOperatingSystemView* self,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static void about_operating_system_view_get_upstream_release_finish (AboutOperatingSystemView* self,
                                                              GAsyncResult* _res_);
static gboolean about_operating_system_view_get_upstream_release_co (AboutOperatingSystemViewGetUpstreamReleaseData* _data_);
static void about_operating_system_view_get_upstream_release_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
static void about_operating_system_view_launch_support_url (AboutOperatingSystemView* self);
static gboolean about_operating_system_view_confirm_restore_action (AboutOperatingSystemView* self);
static void about_operating_system_view_settings_restore_clicked (AboutOperatingSystemView* self);
static gchar** about_operating_system_view_get_pantheon_schemas (gint* result_length1);
static void about_operating_system_view_reset_recursively (const gchar* schema);
static void about_operating_system_view_reset_all_keys (GSettings* settings);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static GObject * about_operating_system_view_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static GdkPixbuf* _about_operating_system_view___lambda4_ (AboutOperatingSystemView* self,
                                                    gint size);
static GdkPixbuf* __about_operating_system_view___lambda4__hdy_avatar_image_load_func (gint size,
                                                                                gpointer self);
static void _about_operating_system_view____lambda5_ (Block6Data* _data6_);
static void __about_operating_system_view____lambda5__gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self);
static void _about_operating_system_view_settings_restore_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                               gpointer self);
static void _about_operating_system_view___lambda6_ (AboutOperatingSystemView* self);
static void __about_operating_system_view___lambda6__gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self);
static void about_operating_system_view_finalize (GObject * obj);
static GType about_operating_system_view_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
about_operating_system_view_get_instance_private (AboutOperatingSystemView* self)
{
	return G_STRUCT_MEMBER_P (self, AboutOperatingSystemView_private_offset);
}

static void
about_operating_system_view_get_upstream_release_data_free (gpointer _data)
{
	AboutOperatingSystemViewGetUpstreamReleaseData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AboutOperatingSystemViewGetUpstreamReleaseData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
about_operating_system_view_get_upstream_release (AboutOperatingSystemView* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	AboutOperatingSystemViewGetUpstreamReleaseData* _data_;
	AboutOperatingSystemView* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AboutOperatingSystemViewGetUpstreamReleaseData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, about_operating_system_view_get_upstream_release_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	about_operating_system_view_get_upstream_release_co (_data_);
}

static void
about_operating_system_view_get_upstream_release_finish (AboutOperatingSystemView* self,
                                                         GAsyncResult* _res_)
{
	AboutOperatingSystemViewGetUpstreamReleaseData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
about_operating_system_view_get_upstream_release_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	AboutOperatingSystemViewGetUpstreamReleaseData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	about_operating_system_view_get_upstream_release_co (_data_);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
about_operating_system_view_get_upstream_release_co (AboutOperatingSystemViewGetUpstreamReleaseData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_file_new_for_path ("/usr/lib/upstream-os-release");
	_data_->file = _data_->_tmp0_;
	_data_->upstream_release = NULL;
	{
		_data_->_tmp2_ = _data_->file;
		_data_->_state_ = 1;
		g_file_read_async (_data_->_tmp2_, G_PRIORITY_DEFAULT, NULL, about_operating_system_view_get_upstream_release_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = g_file_read_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp1_ = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp1_);
		_data_->dis = _data_->_tmp4_;
		while (TRUE) {
			_data_->_tmp6_ = _data_->dis;
			_data_->_state_ = 2;
			g_data_input_stream_read_line_async (_data_->_tmp6_, G_PRIORITY_DEFAULT, NULL, about_operating_system_view_get_upstream_release_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp7_ = g_data_input_stream_read_line_finish (_data_->_tmp6_, _data_->_res_, NULL, &_data_->_inner_error0_);
			_data_->_tmp5_ = _data_->_tmp7_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_free0 (_data_->line);
				_g_object_unref0 (_data_->dis);
				_g_object_unref0 (_data_->_tmp1_);
				goto __catch0_g_error;
			}
			_data_->_tmp8_ = _data_->_tmp5_;
			_data_->_tmp5_ = NULL;
			_g_free0 (_data_->line);
			_data_->line = _data_->_tmp8_;
			_data_->_tmp9_ = _data_->line;
			if (!(_data_->_tmp9_ != NULL)) {
				_g_free0 (_data_->_tmp5_);
				break;
			}
			_data_->_tmp10_ = _data_->line;
			if (g_str_has_prefix (_data_->_tmp10_, "PRETTY_NAME")) {
				_data_->_tmp11_ = _data_->line;
				_data_->_tmp13_ = _data_->_tmp12_ = g_strsplit (_data_->_tmp11_, "=", 2);
				_data_->distrib_component = _data_->_tmp13_;
				_data_->distrib_component_length1 = _vala_array_length (_data_->_tmp12_);
				_data_->_distrib_component_size_ = _data_->distrib_component_length1;
				_data_->_tmp14_ = _data_->distrib_component;
				_data_->_tmp14__length1 = _data_->distrib_component_length1;
				if (_data_->_tmp14__length1 == 2) {
					_data_->_tmp15_ = _data_->distrib_component;
					_data_->_tmp15__length1 = _data_->distrib_component_length1;
					_data_->_tmp16_ = _data_->_tmp15_[1];
					_data_->_tmp15_[1] = NULL;
					_g_free0 (_data_->upstream_release);
					_data_->upstream_release = _data_->_tmp16_;
					_data_->_tmp18_ = _data_->upstream_release;
					if (g_str_has_prefix (_data_->_tmp18_, "\"")) {
						_data_->_tmp19_ = _data_->upstream_release;
						_data_->_tmp17_ = g_str_has_suffix (_data_->_tmp19_, "\"");
					} else {
						_data_->_tmp17_ = FALSE;
					}
					if (_data_->_tmp17_) {
						_data_->_tmp20_ = _data_->upstream_release;
						_data_->_tmp21_ = _data_->upstream_release;
						_data_->_tmp22_ = strlen (_data_->_tmp21_);
						_data_->_tmp23_ = _data_->_tmp22_;
						_data_->_tmp24_ = string_substring (_data_->_tmp20_, (glong) 1, (glong) (_data_->_tmp23_ - 2));
						_g_free0 (_data_->upstream_release);
						_data_->upstream_release = _data_->_tmp24_;
					}
					_data_->distrib_component = (_vala_array_free (_data_->distrib_component, _data_->distrib_component_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_data_->_tmp5_);
					break;
				}
				_data_->distrib_component = (_vala_array_free (_data_->distrib_component, _data_->distrib_component_length1, (GDestroyNotify) g_free), NULL);
			}
			_g_free0 (_data_->_tmp5_);
		}
		_g_free0 (_data_->line);
		_g_object_unref0 (_data_->dis);
		_g_object_unref0 (_data_->_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		g_warning ("OperatingSystemView.vala:214: Couldn't read upstream lsb-release file," \
" assuming none");
		_data_->_tmp25_ = _data_->e;
		_data_->_tmp26_ = _data_->_tmp25_->message;
		g_debug ("OperatingSystemView.vala:215: Error was: %s", _data_->_tmp26_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->upstream_release);
		_g_object_unref0 (_data_->file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp27_ = _data_->upstream_release;
	if (_data_->_tmp27_ != NULL) {
		_data_->_tmp28_ = _data_->upstream_release;
		_data_->_tmp29_ = g_strdup_printf (_ ("Built on %s"), _data_->_tmp28_);
		_data_->_tmp30_ = _data_->_tmp29_;
		_data_->_tmp31_ = NULL;
		_data_->_tmp31_ = (GtkLabel*) gtk_label_new (_data_->_tmp30_);
		gtk_label_set_selectable (_data_->_tmp31_, TRUE);
		gtk_label_set_xalign (_data_->_tmp31_, (gfloat) 0);
		g_object_ref_sink (_data_->_tmp31_);
		_data_->_tmp32_ = _data_->_tmp31_;
		_g_free0 (_data_->_tmp30_);
		_data_->based_off = _data_->_tmp32_;
		_data_->_tmp33_ = _data_->self->priv->software_grid;
		_data_->_tmp34_ = _data_->based_off;
		gtk_grid_attach (_data_->_tmp33_, (GtkWidget*) _data_->_tmp34_, 1, 1, 3, 1);
		_data_->_tmp35_ = _data_->self->priv->software_grid;
		gtk_widget_show_all ((GtkWidget*) _data_->_tmp35_);
		_g_object_unref0 (_data_->based_off);
	}
	_g_free0 (_data_->upstream_release);
	_g_object_unref0 (_data_->file);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
about_operating_system_view_launch_support_url (AboutOperatingSystemView* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		const gchar* _tmp0_;
		_tmp0_ = self->priv->support_url;
		g_app_info_launch_default_for_uri (_tmp0_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_critical ("OperatingSystemView.vala:232: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
     * returns true to continue, false to cancel
     */
static gboolean
about_operating_system_view_confirm_restore_action (AboutOperatingSystemView* self)
{
	GraniteMessageDialog* dialog = NULL;
	GraniteMessageDialog* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* continue_button = NULL;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkStyleContext* _tmp4_;
	gint _result_ = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = granite_message_dialog_new_with_image_from_icon_name (_ ("System Settings Will Be Restored to The Factory Defaults"), _ ("All system settings and data will be reset to the default values. Pers" \
"onal data, such as music and pictures, will be unaffected."), "dialog-warning", GTK_BUTTONS_CANCEL);
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	gtk_window_set_transient_for ((GtkWindow*) dialog, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow));
	_tmp2_ = gtk_dialog_add_button ((GtkDialog*) dialog, _ ("Restore Settings"), (gint) GTK_RESPONSE_ACCEPT);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	continue_button = _tmp3_;
	_tmp4_ = gtk_widget_get_style_context (continue_button);
	gtk_style_context_add_class (_tmp4_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
	_result_ = gtk_dialog_run ((GtkDialog*) dialog);
	gtk_widget_destroy ((GtkWidget*) dialog);
	result = _result_ == ((gint) GTK_RESPONSE_ACCEPT);
	_g_object_unref0 (continue_button);
	_g_object_unref0 (dialog);
	return result;
}

static void
about_operating_system_view_settings_restore_clicked (AboutOperatingSystemView* self)
{
	g_return_if_fail (self != NULL);
	if (about_operating_system_view_confirm_restore_action (self)) {
		gchar** all_schemas = NULL;
		gint _tmp0_ = 0;
		gchar** _tmp1_;
		gint all_schemas_length1;
		gint _all_schemas_size_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		_tmp1_ = about_operating_system_view_get_pantheon_schemas (&_tmp0_);
		all_schemas = _tmp1_;
		all_schemas_length1 = _tmp0_;
		_all_schemas_size_ = all_schemas_length1;
		_tmp2_ = all_schemas;
		_tmp2__length1 = all_schemas_length1;
		{
			gchar** schema_collection = NULL;
			gint schema_collection_length1 = 0;
			gint _schema_collection_size_ = 0;
			gint schema_it = 0;
			schema_collection = _tmp2_;
			schema_collection_length1 = _tmp2__length1;
			for (schema_it = 0; schema_it < schema_collection_length1; schema_it = schema_it + 1) {
				gchar* _tmp3_;
				gchar* schema = NULL;
				_tmp3_ = g_strdup (schema_collection[schema_it]);
				schema = _tmp3_;
				{
					const gchar* _tmp4_;
					_tmp4_ = schema;
					about_operating_system_view_reset_recursively (_tmp4_);
					_g_free0 (schema);
				}
			}
		}
		all_schemas = (_vala_array_free (all_schemas, all_schemas_length1, (GDestroyNotify) g_free), NULL);
	}
}

static void
about_operating_system_view_reset_all_keys (GSettings* settings)
{
	GSettingsSchema* schema = NULL;
	GSettingsSchemaSource* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GSettingsSchema* _tmp4_;
	GSettingsSchema* _tmp5_;
	GSettingsSchema* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	g_return_if_fail (settings != NULL);
	_tmp0_ = g_settings_schema_source_get_default ();
	g_object_get (settings, "schema-id", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_settings_schema_source_lookup (_tmp0_, _tmp3_, TRUE);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	schema = _tmp5_;
	_tmp6_ = schema;
	_tmp8_ = _tmp7_ = g_settings_schema_list_keys (_tmp6_);
	{
		gchar** key_collection = NULL;
		gint key_collection_length1 = 0;
		gint _key_collection_size_ = 0;
		gint key_it = 0;
		key_collection = _tmp8_;
		key_collection_length1 = _vala_array_length (_tmp7_);
		for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
			gchar* _tmp9_;
			gchar* key = NULL;
			_tmp9_ = g_strdup (key_collection[key_it]);
			key = _tmp9_;
			{
				const gchar* _tmp10_;
				_tmp10_ = key;
				g_settings_reset (settings, _tmp10_);
				_g_free0 (key);
			}
		}
		key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_settings_schema_unref0 (schema);
}

static gpointer
_g_settings_schema_source_ref0 (gpointer self)
{
	return self ? g_settings_schema_source_ref (self) : NULL;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
about_operating_system_view_get_pantheon_schemas (gint* result_length1)
{
	gchar** schemas = NULL;
	gchar** _tmp0_;
	gint schemas_length1;
	gint _schemas_size_;
	gchar** pantheon_schemas = NULL;
	gchar** _tmp1_;
	gint pantheon_schemas_length1;
	gint _pantheon_schemas_size_;
	gchar** prefixes = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gint prefixes_length1;
	gint _prefixes_size_;
	GSettingsSchemaSource* sss = NULL;
	GSettingsSchemaSource* _tmp9_;
	GSettingsSchemaSource* _tmp10_;
	GSettingsSchemaSource* _tmp11_;
	gchar** _tmp12_ = NULL;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gchar** result;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	schemas = _tmp0_;
	schemas_length1 = 0;
	_schemas_size_ = schemas_length1;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	pantheon_schemas = _tmp1_;
	pantheon_schemas_length1 = 0;
	_pantheon_schemas_size_ = pantheon_schemas_length1;
	_tmp2_ = g_strdup ("org.pantheon.desktop");
	_tmp3_ = g_strdup ("io.elementary.desktop");
	_tmp4_ = g_strdup ("io.elementary.onboarding");
	_tmp5_ = g_strdup ("io.elementary.wingpanel.keyboard");
	_tmp6_ = g_strdup ("org.gnome.desktop");
	_tmp7_ = g_strdup ("org.gnome.settings-daemon");
	_tmp8_ = g_new0 (gchar*, 6 + 1);
	_tmp8_[0] = _tmp2_;
	_tmp8_[1] = _tmp3_;
	_tmp8_[2] = _tmp4_;
	_tmp8_[3] = _tmp5_;
	_tmp8_[4] = _tmp6_;
	_tmp8_[5] = _tmp7_;
	prefixes = _tmp8_;
	prefixes_length1 = 6;
	_prefixes_size_ = prefixes_length1;
	_tmp9_ = g_settings_schema_source_get_default ();
	_tmp10_ = _g_settings_schema_source_ref0 (_tmp9_);
	sss = _tmp10_;
	_tmp11_ = sss;
	g_settings_schema_source_list_schemas (_tmp11_, TRUE, &_tmp12_, NULL);
	schemas = (_vala_array_free (schemas, schemas_length1, (GDestroyNotify) g_free), NULL);
	schemas = _tmp12_;
	schemas_length1 = -1;
	_schemas_size_ = schemas_length1;
	schemas_length1 = _vala_array_length (schemas);
	_tmp13_ = schemas;
	_tmp13__length1 = schemas_length1;
	{
		gchar** schema_collection = NULL;
		gint schema_collection_length1 = 0;
		gint _schema_collection_size_ = 0;
		gint schema_it = 0;
		schema_collection = _tmp13_;
		schema_collection_length1 = _tmp13__length1;
		for (schema_it = 0; schema_it < schema_collection_length1; schema_it = schema_it + 1) {
			gchar* _tmp14_;
			gchar* schema = NULL;
			_tmp14_ = g_strdup (schema_collection[schema_it]);
			schema = _tmp14_;
			{
				gchar** _tmp15_;
				gint _tmp15__length1;
				_tmp15_ = prefixes;
				_tmp15__length1 = prefixes_length1;
				{
					gchar** prefix_collection = NULL;
					gint prefix_collection_length1 = 0;
					gint _prefix_collection_size_ = 0;
					gint prefix_it = 0;
					prefix_collection = _tmp15_;
					prefix_collection_length1 = _tmp15__length1;
					for (prefix_it = 0; prefix_it < prefix_collection_length1; prefix_it = prefix_it + 1) {
						gchar* _tmp16_;
						gchar* prefix = NULL;
						_tmp16_ = g_strdup (prefix_collection[prefix_it]);
						prefix = _tmp16_;
						{
							const gchar* _tmp17_;
							const gchar* _tmp18_;
							_tmp17_ = schema;
							_tmp18_ = prefix;
							if (g_str_has_prefix (_tmp17_, _tmp18_)) {
								const gchar* _tmp19_;
								gchar* _tmp20_;
								_tmp19_ = schema;
								_tmp20_ = g_strdup (_tmp19_);
								_vala_array_add1 (&pantheon_schemas, &pantheon_schemas_length1, &_pantheon_schemas_size_, _tmp20_);
							}
							_g_free0 (prefix);
						}
					}
				}
				_g_free0 (schema);
			}
		}
	}
	_tmp21_ = pantheon_schemas;
	_tmp21__length1 = pantheon_schemas_length1;
	if (result_length1) {
		*result_length1 = _tmp21__length1;
	}
	result = _tmp21_;
	_g_settings_schema_source_unref0 (sss);
	prefixes = (_vala_array_free (prefixes, prefixes_length1, (GDestroyNotify) g_free), NULL);
	schemas = (_vala_array_free (schemas, schemas_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
about_operating_system_view_reset_recursively (const gchar* schema)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	GSettings* _tmp11_;
	g_return_if_fail (schema != NULL);
	_tmp0_ = g_settings_new (schema);
	settings = _tmp0_;
	_tmp1_ = settings;
	g_settings_delay (_tmp1_);
	_tmp2_ = settings;
	about_operating_system_view_reset_all_keys (_tmp2_);
	_tmp3_ = settings;
	_tmp5_ = _tmp4_ = g_settings_list_children (_tmp3_);
	{
		gchar** child_collection = NULL;
		gint child_collection_length1 = 0;
		gint _child_collection_size_ = 0;
		gint child_it = 0;
		child_collection = _tmp5_;
		child_collection_length1 = _vala_array_length (_tmp4_);
		for (child_it = 0; child_it < child_collection_length1; child_it = child_it + 1) {
			gchar* _tmp6_;
			gchar* child = NULL;
			_tmp6_ = g_strdup (child_collection[child_it]);
			child = _tmp6_;
			{
				GSettings* child_settings = NULL;
				GSettings* _tmp7_;
				const gchar* _tmp8_;
				GSettings* _tmp9_;
				GSettings* _tmp10_;
				_tmp7_ = settings;
				_tmp8_ = child;
				_tmp9_ = g_settings_get_child (_tmp7_, _tmp8_);
				child_settings = _tmp9_;
				_tmp10_ = child_settings;
				about_operating_system_view_reset_all_keys (_tmp10_);
				_g_object_unref0 (child_settings);
				_g_free0 (child);
			}
		}
		child_collection = (_vala_array_free (child_collection, child_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp11_ = settings;
	g_settings_apply (_tmp11_);
	g_settings_sync ();
	_g_object_unref0 (settings);
}

AboutOperatingSystemView*
about_operating_system_view_construct (GType object_type)
{
	AboutOperatingSystemView * self = NULL;
	self = (AboutOperatingSystemView*) g_object_new (object_type, NULL);
	return self;
}

AboutOperatingSystemView*
about_operating_system_view_new (void)
{
	return about_operating_system_view_construct (ABOUT_TYPE_OPERATING_SYSTEM_VIEW);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		AboutOperatingSystemView* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->appcenter_info);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static GdkPixbuf*
_about_operating_system_view___lambda4_ (AboutOperatingSystemView* self,
                                         gint size)
{
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	{
		GdkPixbuf* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_;
		GdkPixbuf* _tmp2_;
		_tmp1_ = gdk_pixbuf_new_from_file_at_scale ("/usr/share/backgrounds/elementaryos-default", -1, size, TRUE, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp2_;
		_g_object_unref0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_critical ("OperatingSystemView.vala:53: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static GdkPixbuf*
__about_operating_system_view___lambda4__hdy_avatar_image_load_func (gint size,
                                                                     gpointer self)
{
	GdkPixbuf* result;
	result = _about_operating_system_view___lambda4_ ((AboutOperatingSystemView*) self, size);
	return result;
}

static void
_about_operating_system_view____lambda5_ (Block6Data* _data6_)
{
	AboutOperatingSystemView* self;
	GDesktopAppInfo* _tmp0_;
	GAppLaunchContext* _tmp1_;
	GAppLaunchContext* _tmp2_;
	self = _data6_->self;
	_tmp0_ = _data6_->appcenter_info;
	_tmp1_ = g_app_launch_context_new ();
	_tmp2_ = _tmp1_;
	g_desktop_app_info_launch_action (_tmp0_, "ShowUpdates", _tmp2_);
	_g_object_unref0 (_tmp2_);
}

static void
__about_operating_system_view____lambda5__gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self)
{
	_about_operating_system_view____lambda5_ (self);
}

static void
_about_operating_system_view_settings_restore_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                          gpointer self)
{
	about_operating_system_view_settings_restore_clicked ((AboutOperatingSystemView*) self);
}

static void
_about_operating_system_view___lambda6_ (AboutOperatingSystemView* self)
{
	GDesktopAppInfo* appinfo = NULL;
	GDesktopAppInfo* _tmp0_;
	GDesktopAppInfo* _tmp1_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = g_desktop_app_info_new ("io.elementary.feedback.desktop");
	appinfo = _tmp0_;
	_tmp1_ = appinfo;
	if (_tmp1_ != NULL) {
		{
			GDesktopAppInfo* _tmp2_;
			_tmp2_ = appinfo;
			g_app_info_launch ((GAppInfo*) _tmp2_, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp3_;
			const gchar* _tmp4_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = e;
			_tmp4_ = _tmp3_->message;
			g_critical ("OperatingSystemView.vala:179: %s", _tmp4_);
			about_operating_system_view_launch_support_url (self);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (appinfo);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		about_operating_system_view_launch_support_url (self);
	}
	_g_object_unref0 (appinfo);
}

static void
__about_operating_system_view___lambda6__gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self)
{
	_about_operating_system_view___lambda6_ ((AboutOperatingSystemView*) self);
}

static GObject *
about_operating_system_view_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AboutOperatingSystemView * self;
	Block6Data* _data6_;
	GtkCssProvider* style_provider = NULL;
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	struct utsname uts_name = {0};
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gchar* logo_icon_name = NULL;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	HdyAvatar* logo = NULL;
	gchar* _tmp12_;
	HdyAvatar* _tmp13_ = NULL;
	HdyAvatar* _tmp14_;
	HdyAvatar* _tmp15_;
	GtkStyleContext* _tmp16_;
	GtkCssProvider* _tmp17_;
	GtkImage* icon = NULL;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	GtkImage* _tmp20_ = NULL;
	GtkStyleContext* icon_style_context = NULL;
	GtkImage* _tmp21_;
	GtkStyleContext* _tmp22_;
	GtkStyleContext* _tmp23_;
	GtkStyleContext* _tmp24_;
	GtkCssProvider* _tmp25_;
	GtkOverlay* logo_overlay = NULL;
	GtkOverlay* _tmp26_;
	GtkOverlay* _tmp27_;
	HdyAvatar* _tmp28_;
	GtkOverlay* _tmp29_;
	GtkImage* _tmp30_;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_;
	gchar* pretty_name = NULL;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	GtkLabel* title = NULL;
	const gchar* _tmp38_;
	GtkLabel* _tmp39_ = NULL;
	GtkLabel* _tmp40_;
	GtkStyleContext* _tmp41_;
	GtkLabel* kernel_version_label = NULL;
	struct utsname _tmp42_;
	const gchar* _tmp43_;
	struct utsname _tmp44_;
	const gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	GtkLabel* _tmp48_ = NULL;
	GtkLabel* _tmp49_;
	gchar* website_url = NULL;
	gchar* _tmp50_;
	gboolean _tmp51_ = FALSE;
	const gchar* _tmp52_;
	GtkLinkButton* website_label = NULL;
	const gchar* _tmp55_;
	GtkLinkButton* _tmp56_ = NULL;
	GtkLinkButton* help_button = NULL;
	const gchar* _tmp57_;
	GtkLinkButton* _tmp58_ = NULL;
	GtkLinkButton* translate_button = NULL;
	GtkLinkButton* _tmp59_ = NULL;
	GtkButton* bug_button = NULL;
	GtkButton* _tmp60_;
	GtkButton* update_button = NULL;
	GDesktopAppInfo* _tmp61_;
	GDesktopAppInfo* _tmp62_;
	GtkButton* settings_restore_button = NULL;
	GtkButton* _tmp65_;
	GtkButtonBox* button_grid = NULL;
	GtkButtonBox* _tmp66_ = NULL;
	GtkButtonBox* _tmp67_;
	GtkButton* _tmp68_;
	GtkButtonBox* _tmp69_;
	GtkButton* _tmp70_;
	GtkButton* _tmp71_;
	GtkButtonBox* _tmp74_;
	GtkButton* _tmp75_;
	GtkGrid* _tmp76_ = NULL;
	GtkGrid* _tmp77_;
	GtkOverlay* _tmp78_;
	GtkGrid* _tmp79_;
	GtkLabel* _tmp80_;
	GtkGrid* _tmp81_;
	GtkLabel* _tmp82_;
	GtkGrid* _tmp83_;
	GtkLinkButton* _tmp84_;
	GtkGrid* _tmp85_;
	GtkLinkButton* _tmp86_;
	GtkGrid* _tmp87_;
	GtkLinkButton* _tmp88_;
	GtkGrid* _tmp89_;
	GtkButtonBox* _tmp90_;
	GtkButton* _tmp91_;
	GtkButton* _tmp92_;
	parent_class = G_OBJECT_CLASS (about_operating_system_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_TYPE_OPERATING_SYSTEM_VIEW, AboutOperatingSystemView);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = gtk_css_provider_new ();
	style_provider = _tmp0_;
	_tmp1_ = style_provider;
	gtk_css_provider_load_from_resource (_tmp1_, "io/elementary/switchboard/system/OperatingSystemView.css");
	uname (&uts_name);
	_tmp2_ = g_get_os_info (G_OS_INFO_KEY_SUPPORT_URL);
	_g_free0 (self->priv->support_url);
	self->priv->support_url = _tmp2_;
	_tmp4_ = self->priv->support_url;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = self->priv->support_url;
		_tmp3_ = _tmp5_ == NULL;
	}
	if (_tmp3_) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("https://elementary.io/support");
		_g_free0 (self->priv->support_url);
		self->priv->support_url = _tmp6_;
	}
	_tmp7_ = g_get_os_info ("LOGO");
	logo_icon_name = _tmp7_;
	_tmp9_ = logo_icon_name;
	if (g_strcmp0 (_tmp9_, "") == 0) {
		_tmp8_ = TRUE;
	} else {
		const gchar* _tmp10_;
		_tmp10_ = logo_icon_name;
		_tmp8_ = _tmp10_ == NULL;
	}
	if (_tmp8_) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup ("distributor-logo");
		_g_free0 (logo_icon_name);
		logo_icon_name = _tmp11_;
	}
	_tmp12_ = g_strdup ("invalid-icon-name");
	_tmp13_ = (HdyAvatar*) hdy_avatar_new (128, "", FALSE);
	hdy_avatar_set_icon_name (_tmp13_, _tmp12_);
	_g_free0 (_tmp12_);
	g_object_set ((GtkWidget*) _tmp13_, "margin", 6, NULL);
	g_object_ref_sink (_tmp13_);
	logo = _tmp13_;
	_tmp14_ = logo;
	hdy_avatar_set_image_load_func (_tmp14_, __about_operating_system_view___lambda4__hdy_avatar_image_load_func, g_object_ref (self), g_object_unref);
	_tmp15_ = logo;
	_tmp16_ = gtk_widget_get_style_context ((GtkWidget*) _tmp15_);
	_tmp17_ = style_provider;
	gtk_style_context_add_provider (_tmp16_, (GtkStyleProvider*) _tmp17_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp18_ = logo_icon_name;
	_tmp19_ = g_strconcat (_tmp18_, "-symbolic", NULL);
	_tmp20_ = (GtkImage*) gtk_image_new ();
	g_object_set (_tmp20_, "icon-name", _tmp19_, NULL);
	_g_free0 (_tmp19_);
	gtk_image_set_pixel_size (_tmp20_, 128 - 6);
	g_object_ref_sink (_tmp20_);
	icon = _tmp20_;
	_tmp21_ = icon;
	_tmp22_ = gtk_widget_get_style_context ((GtkWidget*) _tmp21_);
	icon_style_context = _tmp22_;
	_tmp23_ = icon_style_context;
	gtk_style_context_add_class (_tmp23_, "logo");
	_tmp24_ = icon_style_context;
	_tmp25_ = style_provider;
	gtk_style_context_add_provider (_tmp24_, (GtkStyleProvider*) _tmp25_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp26_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp26_);
	logo_overlay = _tmp26_;
	_tmp27_ = logo_overlay;
	_tmp28_ = logo;
	gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp28_);
	_tmp29_ = logo_overlay;
	_tmp30_ = icon;
	gtk_overlay_add_overlay (_tmp29_, (GtkWidget*) _tmp30_);
	_tmp32_ = g_get_os_info (G_OS_INFO_KEY_VERSION);
	_tmp31_ = _tmp32_;
	if (_tmp31_ == NULL) {
		gchar* _tmp33_;
		_tmp33_ = g_strdup ("");
		_g_free0 (_tmp31_);
		_tmp31_ = _tmp33_;
	}
	_tmp34_ = g_get_os_info (G_OS_INFO_KEY_NAME);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_strdup_printf ("<b>%s</b> %s", _tmp35_, _tmp31_);
	_tmp37_ = _tmp36_;
	_g_free0 (_tmp35_);
	pretty_name = _tmp37_;
	_tmp38_ = pretty_name;
	_tmp39_ = (GtkLabel*) gtk_label_new (_tmp38_);
	gtk_label_set_ellipsize (_tmp39_, PANGO_ELLIPSIZE_END);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp39_, 12);
	gtk_label_set_selectable (_tmp39_, TRUE);
	gtk_label_set_use_markup (_tmp39_, TRUE);
	gtk_label_set_xalign (_tmp39_, (gfloat) 0);
	g_object_ref_sink (_tmp39_);
	title = _tmp39_;
	_tmp40_ = title;
	_tmp41_ = gtk_widget_get_style_context ((GtkWidget*) _tmp40_);
	gtk_style_context_add_class (_tmp41_, GRANITE_STYLE_CLASS_H2_LABEL);
	_tmp42_ = uts_name;
	_tmp43_ = _tmp42_.sysname;
	_tmp44_ = uts_name;
	_tmp45_ = _tmp44_.release;
	_tmp46_ = g_strdup_printf ("%s %s", _tmp43_, _tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = (GtkLabel*) gtk_label_new (_tmp47_);
	gtk_label_set_selectable (_tmp48_, TRUE);
	gtk_label_set_xalign (_tmp48_, (gfloat) 0);
	g_object_ref_sink (_tmp48_);
	_tmp49_ = _tmp48_;
	_g_free0 (_tmp47_);
	kernel_version_label = _tmp49_;
	_tmp50_ = g_get_os_info (G_OS_INFO_KEY_HOME_URL);
	website_url = _tmp50_;
	_tmp52_ = website_url;
	if (g_strcmp0 (_tmp52_, "") == 0) {
		_tmp51_ = TRUE;
	} else {
		const gchar* _tmp53_;
		_tmp53_ = website_url;
		_tmp51_ = _tmp53_ == NULL;
	}
	if (_tmp51_) {
		gchar* _tmp54_;
		_tmp54_ = g_strdup ("https://elementary.io");
		_g_free0 (website_url);
		website_url = _tmp54_;
	}
	_tmp55_ = website_url;
	_tmp56_ = (GtkLinkButton*) gtk_link_button_new_with_label (_tmp55_, _ ("Website"));
	gtk_widget_set_margin_top ((GtkWidget*) _tmp56_, 12);
	g_object_ref_sink (_tmp56_);
	website_label = _tmp56_;
	_tmp57_ = self->priv->support_url;
	_tmp58_ = (GtkLinkButton*) gtk_link_button_new_with_label (_tmp57_, _ ("Get Support"));
	gtk_widget_set_halign ((GtkWidget*) _tmp58_, GTK_ALIGN_CENTER);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp58_, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp58_, 12);
	g_object_ref_sink (_tmp58_);
	help_button = _tmp58_;
	_tmp59_ = (GtkLinkButton*) gtk_link_button_new_with_label ("https://l10n.elementary.io/projects/", _ ("Suggest Translations"));
	gtk_widget_set_margin_top ((GtkWidget*) _tmp59_, 12);
	g_object_ref_sink (_tmp59_);
	translate_button = _tmp59_;
	_tmp60_ = (GtkButton*) gtk_button_new_with_label (_ ("Send Feedback"));
	g_object_ref_sink (_tmp60_);
	bug_button = _tmp60_;
	update_button = NULL;
	_tmp61_ = g_desktop_app_info_new ("io.elementary.appcenter.desktop");
	_data6_->appcenter_info = _tmp61_;
	_tmp62_ = _data6_->appcenter_info;
	if (_tmp62_ != NULL) {
		GtkButton* _tmp63_;
		GtkButton* _tmp64_;
		_tmp63_ = (GtkButton*) gtk_button_new_with_label (_ ("Check for Updates"));
		g_object_ref_sink (_tmp63_);
		_g_object_unref0 (update_button);
		update_button = _tmp63_;
		_tmp64_ = update_button;
		g_signal_connect_data (_tmp64_, "clicked", (GCallback) __about_operating_system_view____lambda5__gtk_button_clicked, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	}
	_tmp65_ = (GtkButton*) gtk_button_new_with_label (_ ("Restore Default Settings"));
	g_object_ref_sink (_tmp65_);
	settings_restore_button = _tmp65_;
	_tmp66_ = (GtkButtonBox*) gtk_button_box_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp66_, TRUE);
	g_object_set (_tmp66_, "layout-style", GTK_BUTTONBOX_END, NULL);
	gtk_box_set_spacing ((GtkBox*) _tmp66_, 6);
	g_object_ref_sink (_tmp66_);
	button_grid = _tmp66_;
	_tmp67_ = button_grid;
	_tmp68_ = settings_restore_button;
	gtk_container_add ((GtkContainer*) _tmp67_, (GtkWidget*) _tmp68_);
	_tmp69_ = button_grid;
	_tmp70_ = bug_button;
	gtk_container_add ((GtkContainer*) _tmp69_, (GtkWidget*) _tmp70_);
	_tmp71_ = update_button;
	if (_tmp71_ != NULL) {
		GtkButtonBox* _tmp72_;
		GtkButton* _tmp73_;
		_tmp72_ = button_grid;
		_tmp73_ = update_button;
		gtk_container_add ((GtkContainer*) _tmp72_, (GtkWidget*) _tmp73_);
	}
	_tmp74_ = button_grid;
	_tmp75_ = settings_restore_button;
	gtk_button_box_set_child_secondary (_tmp74_, (GtkWidget*) _tmp75_, TRUE);
	_tmp76_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp76_, 32 - 6);
	gtk_widget_set_halign ((GtkWidget*) _tmp76_, GTK_ALIGN_CENTER);
	gtk_grid_set_row_spacing (_tmp76_, 6);
	gtk_widget_set_valign ((GtkWidget*) _tmp76_, GTK_ALIGN_CENTER);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp76_, TRUE);
	g_object_ref_sink (_tmp76_);
	_g_object_unref0 (self->priv->software_grid);
	self->priv->software_grid = _tmp76_;
	_tmp77_ = self->priv->software_grid;
	_tmp78_ = logo_overlay;
	gtk_grid_attach (_tmp77_, (GtkWidget*) _tmp78_, 0, 0, 1, 4);
	_tmp79_ = self->priv->software_grid;
	_tmp80_ = title;
	gtk_grid_attach (_tmp79_, (GtkWidget*) _tmp80_, 1, 0, 3, 1);
	_tmp81_ = self->priv->software_grid;
	_tmp82_ = kernel_version_label;
	gtk_grid_attach (_tmp81_, (GtkWidget*) _tmp82_, 1, 2, 3, 1);
	_tmp83_ = self->priv->software_grid;
	_tmp84_ = website_label;
	gtk_grid_attach (_tmp83_, (GtkWidget*) _tmp84_, 1, 3, 1, 1);
	_tmp85_ = self->priv->software_grid;
	_tmp86_ = help_button;
	gtk_grid_attach (_tmp85_, (GtkWidget*) _tmp86_, 2, 3, 1, 1);
	_tmp87_ = self->priv->software_grid;
	_tmp88_ = translate_button;
	gtk_grid_attach (_tmp87_, (GtkWidget*) _tmp88_, 3, 3, 1, 1);
	g_object_set ((GtkWidget*) self, "margin", 12, NULL);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	gtk_grid_set_row_spacing ((GtkGrid*) self, 12);
	_tmp89_ = self->priv->software_grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp89_);
	_tmp90_ = button_grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp90_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp91_ = settings_restore_button;
	g_signal_connect_object (_tmp91_, "clicked", (GCallback) _about_operating_system_view_settings_restore_clicked_gtk_button_clicked, self, 0);
	_tmp92_ = bug_button;
	g_signal_connect_object (_tmp92_, "clicked", (GCallback) __about_operating_system_view___lambda6__gtk_button_clicked, self, 0);
	about_operating_system_view_get_upstream_release (self, NULL, NULL);
	_g_object_unref0 (button_grid);
	_g_object_unref0 (settings_restore_button);
	_g_object_unref0 (update_button);
	_g_object_unref0 (bug_button);
	_g_object_unref0 (translate_button);
	_g_object_unref0 (help_button);
	_g_object_unref0 (website_label);
	_g_free0 (website_url);
	_g_object_unref0 (kernel_version_label);
	_g_object_unref0 (title);
	_g_free0 (pretty_name);
	_g_free0 (_tmp31_);
	_g_object_unref0 (logo_overlay);
	_g_object_unref0 (icon);
	_g_object_unref0 (logo);
	_g_free0 (logo_icon_name);
	_g_object_unref0 (style_provider);
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return obj;
}

static void
about_operating_system_view_class_init (AboutOperatingSystemViewClass * klass,
                                        gpointer klass_data)
{
	about_operating_system_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AboutOperatingSystemView_private_offset);
	G_OBJECT_CLASS (klass)->constructor = about_operating_system_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = about_operating_system_view_finalize;
}

static void
about_operating_system_view_instance_init (AboutOperatingSystemView * self,
                                           gpointer klass)
{
	self->priv = about_operating_system_view_get_instance_private (self);
}

static void
about_operating_system_view_finalize (GObject * obj)
{
	AboutOperatingSystemView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_TYPE_OPERATING_SYSTEM_VIEW, AboutOperatingSystemView);
	_g_free0 (self->priv->support_url);
	_g_object_unref0 (self->priv->software_grid);
	G_OBJECT_CLASS (about_operating_system_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
about_operating_system_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AboutOperatingSystemViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) about_operating_system_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AboutOperatingSystemView), 0, (GInstanceInitFunc) about_operating_system_view_instance_init, NULL };
	GType about_operating_system_view_type_id;
	about_operating_system_view_type_id = g_type_register_static (gtk_grid_get_type (), "AboutOperatingSystemView", &g_define_type_info, 0);
	AboutOperatingSystemView_private_offset = g_type_add_instance_private (about_operating_system_view_type_id, sizeof (AboutOperatingSystemViewPrivate));
	return about_operating_system_view_type_id;
}

GType
about_operating_system_view_get_type (void)
{
	static volatile gsize about_operating_system_view_type_id__once = 0;
	if (g_once_init_enter (&about_operating_system_view_type_id__once)) {
		GType about_operating_system_view_type_id;
		about_operating_system_view_type_id = about_operating_system_view_get_type_once ();
		g_once_init_leave (&about_operating_system_view_type_id__once, about_operating_system_view_type_id);
	}
	return about_operating_system_view_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

